/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GtkTargetEntry;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    int drag_motion_handler;
    int drag_leave_handler;
    int drag_data_received_handler;
    int drag_drop_handler;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final int DRAGOVER_HYSTERESIS = 50;
    static Callback Drag_Motion = new Callback(DropTarget.class, "Drag_Motion", 5);
    static Callback Drag_Leave = new Callback(DropTarget.class, "Drag_Leave", 3);
    static Callback Drag_Data_Received = new Callback(DropTarget.class, "Drag_Data_Received", 7);
    static Callback Drag_Drop = new Callback(DropTarget.class, "Drag_Drop", 5);
    long dropController;

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (GTK.GTK4) {
            int n2 = this.opToOsOp(n);
            this.dropController = GTK4.gtk_drop_target_async_new(0L, n2);
            GTK4.gtk_widget_add_controller(control.handle, this.dropController);
        } else {
            if (Drag_Motion == null || Drag_Leave == null || Drag_Data_Received == null || Drag_Drop == null) {
                DND.error(2001);
            }
            if (control.getData("DropTarget") != null) {
                DND.error(2001);
            }
            control.setData("DropTarget", this);
            this.drag_motion_handler = OS.g_signal_connect(control.handle, OS.drag_motion, Drag_Motion.getAddress(), 0L);
            this.drag_leave_handler = OS.g_signal_connect(control.handle, OS.drag_leave, Drag_Leave.getAddress(), 0L);
            this.drag_data_received_handler = OS.g_signal_connect(control.handle, OS.drag_data_received, Drag_Data_Received.getAddress(), 0L);
            this.drag_drop_handler = OS.g_signal_connect(control.handle, OS.drag_drop, Drag_Drop.getAddress(), 0L);
            this.controlListener = event -> {
                if (!this.isDisposed()) {
                    this.dispose();
                }
            };
            control.addListener(12, this.controlListener);
            this.addListener(12, event -> this.onDispose());
            Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
            if (object instanceof DropTargetEffect) {
                this.dropEffect = (DropTargetEffect)object;
            } else if (control instanceof Table) {
                this.dropEffect = new TableDropTargetEffect((Table)control);
            } else if (control instanceof Tree) {
                this.dropEffect = new TreeDropTargetEffect((Tree)control);
            }
            this.dragOverHeartbeat = () -> {
                Control control = this.control;
                if (control == null || control.isDisposed() || this.dragOverStart == 0L) {
                    return;
                }
                long l = System.currentTimeMillis();
                int n = 50;
                if (l < this.dragOverStart) {
                    n = (int)(this.dragOverStart - l);
                } else {
                    this.dragOverEvent.time += 50;
                    int n2 = this.dragOverEvent.operations;
                    TransferData[] transferDataArray = this.dragOverEvent.dataTypes;
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray2.length);
                    DNDEvent dNDEvent = new DNDEvent();
                    dNDEvent.widget = this.dragOverEvent.widget;
                    dNDEvent.x = this.dragOverEvent.x;
                    dNDEvent.y = this.dragOverEvent.y;
                    dNDEvent.time = this.dragOverEvent.time;
                    dNDEvent.feedback = 1;
                    dNDEvent.dataTypes = transferDataArray2;
                    dNDEvent.dataType = this.selectedDataType;
                    dNDEvent.operations = this.dragOverEvent.operations;
                    dNDEvent.detail = this.selectedOperation;
                    if (this.dropEffect != null) {
                        dNDEvent.item = this.dropEffect.getItem(this.dragOverEvent.x, this.dragOverEvent.y);
                    }
                    this.selectedDataType = null;
                    this.selectedOperation = 0;
                    this.notifyListeners(2004, dNDEvent);
                    if (dNDEvent.dataType != null) {
                        for (int i = 0; i < transferDataArray.length; ++i) {
                            if (transferDataArray[i].type != dNDEvent.dataType.type) continue;
                            this.selectedDataType = dNDEvent.dataType;
                            break;
                        }
                    }
                    if (this.selectedDataType != null && (dNDEvent.detail & n2) != 0) {
                        this.selectedOperation = dNDEvent.detail;
                    }
                }
                control = this.control;
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().timerExec(n, this.dragOverHeartbeat);
            };
        }
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static long Drag_Data_Received(long l, long l2, long l3, long l4, long l5, long l6, long l7) {
        DropTarget dropTarget = DropTarget.FindDropTarget(l);
        if (dropTarget == null) {
            return 0L;
        }
        dropTarget.drag_data_received(l, l2, (int)l3, (int)l4, l5, (int)l6, (int)l7);
        return 0L;
    }

    static long Drag_Drop(long l, long l2, long l3, long l4, long l5) {
        DropTarget dropTarget = DropTarget.FindDropTarget(l);
        if (dropTarget == null) {
            return 0L;
        }
        return dropTarget.drag_drop(l, l2, (int)l3, (int)l4, (int)l5) ? 1L : 0L;
    }

    static long Drag_Leave(long l, long l2, long l3) {
        DropTarget dropTarget = DropTarget.FindDropTarget(l);
        if (dropTarget == null) {
            return 0L;
        }
        dropTarget.drag_leave(l, l2, (int)l3);
        return 0L;
    }

    static long Drag_Motion(long l, long l2, long l3, long l4, long l5) {
        DropTarget dropTarget = DropTarget.FindDropTarget(l);
        if (dropTarget == null) {
            return 0L;
        }
        return dropTarget.drag_motion(l, l2, (int)l3, (int)l4, (int)l5) ? 1L : 0L;
    }

    static DropTarget FindDropTarget(long l) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(l);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    @Override
    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = DropTarget.class.getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    void drag_data_received(long l, long l2, int n, int n2, long l3, int n3, int n4) {
        DNDEvent dNDEvent = new DNDEvent();
        if (l3 == 0L || !this.setEventData(l2, n, n2, n4, dNDEvent)) {
            this.keyOperation = -1;
            return;
        }
        this.keyOperation = -1;
        int n5 = dNDEvent.operations;
        Object object = null;
        TransferData transferData = new TransferData();
        int n6 = GTK3.gtk_selection_data_get_length(l3);
        int n7 = GTK3.gtk_selection_data_get_format(l3);
        long l4 = GTK3.gtk_selection_data_get_data(l3);
        long l5 = GTK3.gtk_selection_data_get_data_type(l3);
        if (l4 != 0L) {
            transferData.type = l5;
            transferData.length = n6;
            transferData.pValue = l4;
            transferData.format = n7;
            for (int i = 0; i < this.transferAgents.length; ++i) {
                Transfer transfer = this.transferAgents[i];
                if (transfer == null || !transfer.isSupportedType(transferData)) continue;
                object = transfer.nativeToJava(transferData);
                break;
            }
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = transferData;
        dNDEvent.data = object;
        this.selectedOperation = 0;
        this.notifyListeners(2006, dNDEvent);
        if ((n5 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.g_signal_stop_emission_by_name(l, OS.drag_data_received);
        GTK3.gtk_drag_finish(l2, this.selectedOperation != 0, this.selectedOperation == 2, n4);
    }

    boolean drag_drop(long l, long l2, int n, int n2, int n3) {
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(l2, n, n2, n3, dNDEvent)) {
            this.keyOperation = -1;
            return false;
        }
        this.keyOperation = -1;
        int n4 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2007, dNDEvent);
        if (dNDEvent.dataType != null) {
            for (int i = 0; i < transferDataArray.length; ++i) {
                if (transferDataArray[i].type != dNDEvent.dataType.type) continue;
                this.selectedDataType = transferDataArray[i];
                break;
            }
        }
        if (this.selectedDataType != null && (dNDEvent.detail & n4) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        GTK3.gtk_drag_get_data(l, l2, this.selectedDataType.type, n3);
        return true;
    }

    void drag_leave(long l, long l2, int n) {
        this.updateDragOverHover(0L, null);
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = n;
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
    }

    boolean drag_motion(long l, long l2, int n, int n2, int n3) {
        DNDEvent dNDEvent;
        int n4 = this.keyOperation;
        if (n4 == -1 || !((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(l2, n, n2, n3, dNDEvent = new DNDEvent())) {
            this.keyOperation = -1;
            GDK.gdk_drag_status(l2, 0, n3);
            return false;
        }
        int n5 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (n4 == -1) {
            dNDEvent.type = 2002;
        } else if (this.keyOperation == n4) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.updateDragOverHover(50L, dNDEvent);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(dNDEvent.type, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n6 = dNDEvent.detail = (n5 & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            for (int i = 0; i < transferDataArray.length; ++i) {
                if (transferDataArray[i].type != dNDEvent.dataType.type) continue;
                this.selectedDataType = transferDataArray[i];
                break;
            }
        }
        if (this.selectedDataType != null && (n5 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        switch (this.selectedOperation) {
            case 0: {
                GDK.gdk_drag_status(l2, 0, n3);
                break;
            }
            case 1: {
                GDK.gdk_drag_status(l2, 2, n3);
                break;
            }
            case 2: {
                GDK.gdk_drag_status(l2, 4, n3);
                break;
            }
            case 4: {
                GDK.gdk_drag_status(l2, 8, n3);
            }
        }
        if (n4 == -1) {
            this.dragOverHeartbeat.run();
        }
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Listener listener = listenerArray[i];
            if (!(listener instanceof DNDListener)) continue;
            dropTargetListenerArray[n2] = (DropTargetListener)((DNDListener)listener).getEventListener();
            ++n2;
        }
        if (n2 == n) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n2];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n2);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        boolean bl;
        int[] nArray = new int[1];
        long l = GDK.gdk_get_pointer(GDK.gdk_display_get_default());
        if (!GTK.GTK4) {
            long l2 = GDK.gdk_get_default_root_window();
            GDK.gdk_window_get_device_position(l2, l, null, null, nArray);
        }
        boolean bl2 = (nArray[0] & 4) != 0;
        boolean bl3 = bl = (nArray[0] & 1) != 0;
        if (bl2 && bl) {
            return 4;
        }
        if (bl2) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_motion_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_leave_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_data_received_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_drop_handler);
        if (this.transferAgents.length != 0) {
            GTK3.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = null;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.control.setData("DropTarget", null);
        this.control = null;
        this.controlListener = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 2;
        }
        if ((n & 2) == 2) {
            n2 |= 4;
        }
        if ((n & 4) == 4) {
            n2 |= 8;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 2) == 2) {
            n2 |= 1;
        }
        if ((n & 4) == 4) {
            n2 |= 2;
        }
        if ((n & 8) == 8) {
            n2 |= 4;
        }
        return n2;
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setTransfer(Transfer ... transferArray) {
        if (GTK.GTK4) {
            this.transferAgents = transferArray;
            long l = GTK4.gdk_content_formats_builder_new();
            for (Transfer transfer : transferArray) {
                for (String string : transfer.getTypeNames()) {
                    GTK4.gdk_content_formats_builder_add_mime_type(l, Converter.javaStringToCString(string));
                }
            }
            GTK4.gtk_drop_target_async_set_formats(this.dropController, l);
        } else {
            long l;
            int n;
            if (transferArray == null) {
                DND.error(4);
            }
            if (this.transferAgents.length != 0) {
                GTK3.gtk_drag_dest_unset(this.control.handle);
            }
            this.transferAgents = transferArray;
            GtkTargetEntry[] gtkTargetEntryArray = new GtkTargetEntry[]{};
            for (int i = 0; i < transferArray.length; ++i) {
                Transfer transfer = transferArray[i];
                if (transfer == null) continue;
                int[] nArray = transfer.getTypeIds();
                String[] stringArray = transfer.getTypeNames();
                for (int j = 0; j < nArray.length; ++j) {
                    GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                    byte[] byArray = Converter.wcsToMbcs(stringArray[j], true);
                    gtkTargetEntry.target = OS.g_malloc(byArray.length);
                    C.memmove(gtkTargetEntry.target, byArray, (long)byArray.length);
                    gtkTargetEntry.info = nArray[j];
                    GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                    System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                    gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                    gtkTargetEntryArray = gtkTargetEntryArray2;
                }
            }
            long l2 = OS.g_malloc(gtkTargetEntryArray.length * GtkTargetEntry.sizeof);
            for (n = 0; n < gtkTargetEntryArray.length; ++n) {
                GTK3.memmove(l2 + (long)(n * GtkTargetEntry.sizeof), gtkTargetEntryArray[n], (long)GtkTargetEntry.sizeof);
            }
            n = this.opToOsOp(this.getStyle());
            if (this.control instanceof Combo && (this.control.getStyle() & 8) == 0 && (l = GTK3.gtk_bin_get_child(this.control.handle)) != 0L) {
                GTK3.gtk_drag_dest_unset(l);
            }
            GTK3.gtk_drag_dest_set(this.control.handle, 0, l2, gtkTargetEntryArray.length, n);
            for (int i = 0; i < gtkTargetEntryArray.length; ++i) {
                OS.g_free(gtkTargetEntryArray[i].target);
            }
        }
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    boolean setEventData(long l, int n, int n2, int n3, DNDEvent dNDEvent) {
        int n4;
        if (l == 0L) {
            return false;
        }
        long l2 = GDK.gdk_drag_context_list_targets(l);
        int n5 = GDK.gdk_drag_context_get_actions(l);
        if (l2 == 0L) {
            return false;
        }
        int n6 = this.getStyle();
        int n7 = this.osOpToOp(n5) & n6;
        if (n7 == 0) {
            return false;
        }
        this.keyOperation = n4 = this.getOperationFromKeyState();
        if (n4 == 16) {
            if ((n6 & 0x10) == 0) {
                n4 = (n7 & 2) != 0 ? 2 : 0;
            }
        } else if ((n4 & n7) == 0) {
            n4 = 0;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            TransferData transferData = new TransferData();
            transferData.type = l3;
            for (int i = 0; i < this.transferAgents.length; ++i) {
                Transfer transfer = this.transferAgents[i];
                if (transfer == null || !transfer.isSupportedType(transferData)) continue;
                TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                transferDataArray2[transferDataArray.length] = transferData;
                transferDataArray = transferDataArray2;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        if (transferDataArray.length == 0) {
            return false;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!GTK.GTK4) {
            long l4 = GTK3.gtk_widget_get_window(this.control.handle);
            GDK.gdk_window_get_origin(l4, nArray, nArray2);
        }
        Point point = DPIUtil.autoScaleDown(new Point(nArray[0] + n, nArray2[0] + n2));
        dNDEvent.widget = this;
        dNDEvent.x = point.x;
        dNDEvent.y = point.y;
        dNDEvent.time = n3;
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        dNDEvent.operations = n7;
        dNDEvent.detail = n4;
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(point.x, point.y);
        }
        return true;
    }

    void updateDragOverHover(long l, DNDEvent dNDEvent) {
        if (l == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + l;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = dNDEvent.x;
        this.dragOverEvent.y = dNDEvent.y;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.dragOverEvent.dataTypes = transferDataArray;
        this.dragOverEvent.operations = dNDEvent.operations;
        this.dragOverEvent.time = dNDEvent.time;
    }
}

