/*
 * Decompiled with CFR 0.152.
 */
package tornadofx;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javax.json.JsonArray;
import javax.json.JsonObject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tornadofx.HttpClientRequest;
import tornadofx.Rest;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0000H\u0016J\u0010\u0010\u001e\u001a\n \n*\u0004\u0018\u00010\u001f0\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016R6\u0010\u0007\u001a$\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\u0012\u0012\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u000b0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Ltornadofx/HttpClientResponse;", "Ltornadofx/Rest$Response;", "request", "Ltornadofx/HttpClientRequest;", "response", "Lorg/apache/http/client/methods/CloseableHttpResponse;", "(Ltornadofx/HttpClientRequest;Lorg/apache/http/client/methods/CloseableHttpResponse;)V", "headers", "", "", "kotlin.jvm.PlatformType", "", "getHeaders", "()Ljava/util/Map;", "reason", "getReason", "()Ljava/lang/String;", "getRequest", "()Ltornadofx/HttpClientRequest;", "getResponse", "()Lorg/apache/http/client/methods/CloseableHttpResponse;", "statusCode", "", "getStatusCode", "()I", "bytes", "", "close", "", "consume", "content", "Ljava/io/InputStream;", "text", "tornadofx"})
public final class HttpClientResponse
implements Rest.Response {
    @NotNull
    private final HttpClientRequest request;
    @NotNull
    private final CloseableHttpResponse response;

    @Override
    public int getStatusCode() {
        StatusLine statusLine = this.response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull(statusLine, "response.statusLine");
        return statusLine.getStatusCode();
    }

    @Override
    @NotNull
    public String getReason() {
        StatusLine statusLine = this.response.getStatusLine();
        Intrinsics.checkExpressionValueIsNotNull(statusLine, "response.statusLine");
        String string2 = statusLine.getReasonPhrase();
        Intrinsics.checkExpressionValueIsNotNull(string2, "response.statusLine.reasonPhrase");
        return string2;
    }

    @Override
    public void close() {
        this.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String text() {
        try {
            String string2 = EntityUtils.toString(this.response.getEntity(), StandardCharsets.UTF_8);
            Intrinsics.checkExpressionValueIsNotNull(string2, "EntityUtils.toString(response.entity, UTF_8)");
            String string3 = string2;
            return string3;
        }
        finally {
            this.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public HttpClientResponse consume() {
        HttpClientResponse httpClientResponse;
        HttpClientResponse $receiver = httpClientResponse = this;
        EntityUtils.consumeQuietly($receiver.response.getEntity());
        try {
            CloseableHttpResponse closeableHttpResponse = $receiver.response;
            if (!(closeableHttpResponse instanceof CloseableHttpResponse)) {
                closeableHttpResponse = null;
            }
            if (closeableHttpResponse != null) {
                closeableHttpResponse.close();
            }
        }
        catch (Throwable throwable) {
            Platform.runLater((Runnable)new Runnable($receiver){
                final /* synthetic */ HttpClientResponse $this_apply;

                public final void run() {
                    Rest.Companion.getOngoingRequests().remove((Object)this.$this_apply.getRequest());
                }
                {
                    this.$this_apply = httpClientResponse;
                }
            });
            throw throwable;
        }
        Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
        return httpClientResponse;
    }

    @Override
    public InputStream content() {
        HttpEntity httpEntity = this.response.getEntity();
        Intrinsics.checkExpressionValueIsNotNull(httpEntity, "response.entity");
        return httpEntity.getContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public byte[] bytes() {
        try {
            byte[] byArray = EntityUtils.toByteArray(this.response.getEntity());
            Intrinsics.checkExpressionValueIsNotNull(byArray, "EntityUtils.toByteArray(response.entity)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            this.consume();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, List<String>> getHeaders() {
        void $receiver$iv$iv;
        Header[] headerArray = this.response.getAllHeaders();
        Intrinsics.checkExpressionValueIsNotNull(headerArray, "response.allHeaders");
        Header[] $receiver$iv = headerArray;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($receiver$iv.length), 16);
        Header[] headerArray2 = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (void element$iv$iv : $receiver$iv$iv) {
            void it;
            Map map2 = destination$iv$iv;
            void v1 = it = element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(v1, "it");
            Pair<String, List<String>> pair = TuplesKt.to(v1.getName(), CollectionsKt.listOf(it.getValue()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @Override
    @NotNull
    public HttpClientRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final CloseableHttpResponse getResponse() {
        return this.response;
    }

    public HttpClientResponse(@NotNull HttpClientRequest request, @NotNull CloseableHttpResponse response) {
        Intrinsics.checkParameterIsNotNull(request, "request");
        Intrinsics.checkParameterIsNotNull(response, "response");
        this.request = request;
        this.response = response;
    }

    @Override
    @NotNull
    public Rest.Response.Status getStatus() {
        return Rest.Response.DefaultImpls.getStatus(this);
    }

    @Override
    @Nullable
    public String header(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return Rest.Response.DefaultImpls.header(this, name);
    }

    @Override
    @NotNull
    public JsonArray list() {
        return Rest.Response.DefaultImpls.list(this);
    }

    @Override
    @NotNull
    public JsonObject one() {
        return Rest.Response.DefaultImpls.one(this);
    }

    @Override
    public boolean ok() {
        return Rest.Response.DefaultImpls.ok(this);
    }
}

