/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui.data;

import gde.config.Settings;
import gde.histo.datasources.HistoSet;
import gde.histo.guard.Reminder;
import gde.histo.recordings.TrailRecord;
import gde.histo.ui.Measure;
import gde.histo.ui.SummaryComposite;
import gde.histo.utils.ElementaryQuantile;
import gde.log.Logger;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SummarySpots {
    private static final String $CLASS_NAME = SummarySpots.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final Color COLOR_GREY = SWTResourceManager.getColor(15);
    public static final Color COLOR_CANVAS_YELLOW = SWTResourceManager.getColor(250, 249, 211);
    public static final Color COLOR_BLUE = SWTResourceManager.getColor(9);
    public static final Color COLOR_LIGHT_BLUE = SWTResourceManager.getColor(239, 239, 255);
    public static final Color COLOR_DARK_GREEN = SWTResourceManager.getColor(6);
    public static final Color COLOR_BLACK = SWTResourceManager.getColor(2);
    public static final Color COLOR_RED = SWTResourceManager.getColor(3);
    public final SummaryComposite.SummaryLayout summary;
    public final TrailRecord record;
    private Rectangle drawStripBounds;
    private int elementWidth;
    private int stripNetX0;
    private int stripNetWidth;
    private double xValueScaleFactor;
    private double xValueOffset;
    private double xPointScaleFactor;
    private double xPointOffset;
    private final MarkerPositions xPositions = new MarkerPositions();
    public Reminder[] warningMinMaxValues = null;

    public String toString() {
        return "[record=" + this.record.getName() + ", warningMinMax=" + Arrays.toString(this.warningMinMaxValues) + ", xPositions=" + this.xPositions + " ]";
    }

    public List<Integer> defineGrid(boolean innerOnly) {
        ArrayList<Integer> grid = new ArrayList<Integer>();
        double xStep = (double)(this.stripNetWidth + 1) / 10.0;
        if (innerOnly) {
            for (int i = 1; i < 10; ++i) {
                grid.add(this.stripNetX0 + (int)(xStep * (double)i + 0.5));
            }
        } else {
            for (int i = 0; i < 11; ++i) {
                grid.add(this.stripNetX0 + (int)(xStep * (double)i + 0.5));
            }
        }
        return grid;
    }

    public SummarySpots(SummaryComposite.SummaryLayout summary) {
        this.summary = summary;
        this.record = summary.getTrailRecord();
    }

    public void initialize(Rectangle newDrawStripBounds, Density newDensity) {
        this.xPositions.clear();
        this.warningMinMaxValues = null;
        this.drawStripBounds = newDrawStripBounds;
        this.elementWidth = newDensity.markerWidth;
        this.stripNetX0 = newDrawStripBounds.x + this.elementWidth / 2;
        int tmpWidth = newDrawStripBounds.width - this.elementWidth;
        this.stripNetWidth = tmpWidth - tmpWidth % this.elementWidth;
        double[] decodedScaleMinMax = this.summary.getScaleMinMax();
        this.xValueScaleFactor = (double)this.stripNetWidth / (decodedScaleMinMax[1] - decodedScaleMinMax[0]);
        this.xValueOffset = decodedScaleMinMax[0] * this.xValueScaleFactor - 0.5;
        this.xPointScaleFactor = HistoSet.decodeDeltaValue(this.record.getChannelItem(), 0.001) / ((decodedScaleMinMax[1] - decodedScaleMinMax[0]) / (double)this.stripNetWidth);
        this.xPointOffset = HistoSet.encodeVaultValue(this.record, decodedScaleMinMax[0]) * 1000.0 * this.xPointScaleFactor - 0.5;
        int positionsLimit = Settings.getInstance().isSummarySpotsVisible() ? -1 : Settings.getInstance().getReminderCount();
        this.xPositions.putAll(this.defineXPositions(positionsLimit));
    }

    private MarkerPositions defineXPositions(int limit) {
        log.finest(() -> this.record.getName() + "  limit=" + limit);
        MarkerPositions resultXPositions = new MarkerPositions();
        Vector tmpRecord = this.record.getTrailSelector().isTrailSuite() ? this.record.getSuiteRecords().get(this.record.getTrailSelector().getSuiteMasterIndex()) : this.record;
        int actualLimit = limit > 0 && limit < tmpRecord.size() ? limit : tmpRecord.size();
        for (int i = 0; i < actualLimit; ++i) {
            Integer point = (Integer)tmpRecord.get(i);
            if (point == null) continue;
            int xPos = this.getXPos(point);
            int xDrawer = xPos - xPos % this.elementWidth;
            log.finest(() -> "xPos=" + xPos);
            PosMarkers posMarkers = resultXPositions.get(xDrawer);
            if (posMarkers == null) {
                posMarkers = new PosMarkers(this.drawStripBounds.height, this.elementWidth);
                resultXPositions.put(xDrawer, posMarkers);
            }
            posMarkers.add(i);
        }
        return resultXPositions;
    }

    Point[] defineFirstLastPoints(Measure measure) {
        Point[] result = new Point[2];
        int[] indexFirstLast = measure.getRecordSection().getIndexFirstLast();
        for (Map.Entry<Integer, PosMarkers> entry : this.xPositions.entrySet()) {
            for (Integer recordIndex : entry.getValue()) {
                Integer recordIndex2;
                int i;
                if (recordIndex == indexFirstLast[0]) {
                    for (i = 0; i < entry.getValue().size(); ++i) {
                        recordIndex2 = entry.getValue().get(i);
                        if (recordIndex2 != indexFirstLast[0]) continue;
                        result[0] = new Point(entry.getKey().intValue(), ((Integer)entry.getValue().yPositions.get(i)).intValue());
                    }
                }
                if (recordIndex == indexFirstLast[1]) {
                    for (i = 0; i < entry.getValue().size(); ++i) {
                        recordIndex2 = entry.getValue().get(i);
                        if (recordIndex2 != indexFirstLast[1]) continue;
                        result[1] = new Point(entry.getKey().intValue(), ((Integer)entry.getValue().yPositions.get(i)).intValue());
                    }
                }
                if (result[1] == null || result[0] == null) continue;
                return result;
            }
        }
        return result;
    }

    LinkedHashMap<Integer, PosMarkers> defineXPositionFirstLast(Measure measure) {
        int firstXPosition = -1;
        PosMarkers firstXPosMarkers = null;
        int lastXPosition = -1;
        PosMarkers lastXPosMarkers = null;
        int[] indexFirstLast = measure.getRecordSection().getIndexFirstLast();
        for (Map.Entry<Integer, PosMarkers> entry : this.xPositions.entrySet()) {
            for (Integer recordIndex : entry.getValue()) {
                Integer recordIndex2;
                int i;
                PosMarkers resultMarkers;
                int resultCounter = 0;
                if (recordIndex == indexFirstLast[0]) {
                    resultMarkers = entry.getValue().clone();
                    for (i = 0; i < resultMarkers.size(); ++i) {
                        recordIndex2 = resultMarkers.get(i);
                        if (recordIndex2 != indexFirstLast[0] && recordIndex2 != indexFirstLast[1]) {
                            resultMarkers.setToNull(i);
                            continue;
                        }
                        ++resultCounter;
                    }
                    if (resultCounter == 2) {
                        LinkedHashMap<Integer, PosMarkers> result = new LinkedHashMap<Integer, PosMarkers>();
                        result.put(firstXPosition, resultMarkers);
                        return result;
                    }
                    firstXPosition = entry.getKey();
                    firstXPosMarkers = resultMarkers;
                }
                if (recordIndex == indexFirstLast[1]) {
                    resultMarkers = entry.getValue().clone();
                    for (i = 0; i < resultMarkers.size(); ++i) {
                        recordIndex2 = resultMarkers.get(i);
                        if (recordIndex2 == indexFirstLast[1]) continue;
                        resultMarkers.setToNull(i);
                    }
                    lastXPosition = entry.getKey();
                    lastXPosMarkers = resultMarkers;
                }
                if (firstXPosMarkers == null || lastXPosMarkers == null) continue;
                LinkedHashMap<Integer, PosMarkers> result = new LinkedHashMap<Integer, PosMarkers>();
                result.put(firstXPosition, firstXPosMarkers);
                result.put(lastXPosition, lastXPosMarkers);
                return result;
            }
        }
        return new LinkedHashMap<Integer, PosMarkers>();
    }

    private TreeMap<Integer, PosMarkers> defineXPositions(Measure measure) {
        TreeMap<Integer, PosMarkers> resultXPositions = new TreeMap<Integer, PosMarkers>();
        int[] indexFirstLast = measure.getRecordSection().getIndexFirstLast();
        for (Map.Entry<Integer, PosMarkers> entry : this.xPositions.entrySet()) {
            for (Integer recordIndex : entry.getValue()) {
                if (recordIndex < indexFirstLast[0] || recordIndex > indexFirstLast[1]) continue;
                PosMarkers resultMarkers = entry.getValue().clone();
                for (int i = 0; i < resultMarkers.size(); ++i) {
                    Integer recordIndex2 = resultMarkers.get(i);
                    if (recordIndex2 >= indexFirstLast[0] && recordIndex2 <= indexFirstLast[1]) continue;
                    resultMarkers.setToNull(i);
                }
                resultXPositions.put(entry.getKey(), resultMarkers);
            }
        }
        return resultXPositions;
    }

    public int[] defineSpreadXPositions() {
        double avg = this.record.getQuantile().getAvgFigure();
        double sigma = this.record.getQuantile().getSigmaFigure();
        int[] result = new int[]{this.getXPos(avg - 2.0 * sigma), this.getXPos(avg), this.getXPos(avg + 2.0 * sigma)};
        log.log(Level.FINEST, "left,avg,right=", Arrays.toString(result));
        return result;
    }

    public int[] defineTukeyXPositions() {
        double[] tukeyBoxPlot = this.record.getQuantile().getTukeyBoxPlot();
        int[] resultXPositions = new int[tukeyBoxPlot.length];
        for (int i = 0; i < tukeyBoxPlot.length; ++i) {
            int xPos;
            resultXPositions[i] = xPos = this.getXPos(tukeyBoxPlot[i]);
        }
        log.finer(() -> Arrays.toString(resultXPositions));
        return resultXPositions;
    }

    private int getXPos(double value) {
        return (int)(value * this.xValueScaleFactor - this.xValueOffset);
    }

    private int getXPos(Integer point) {
        return (int)((double)point.intValue() * this.xPointScaleFactor - this.xPointOffset);
    }

    public void drawMarkers(GC gc, Measure measure) {
        this.drawMarkers(gc, this.defineXPositions(measure), COLOR_BLUE);
    }

    public void drawRecentMarkers(GC gc) {
        this.drawScalableMarkers(gc, this.defineXPositions(Settings.getInstance().getReminderCount()), COLOR_RED);
    }

    public void drawMarkers(GC gc) {
        this.drawScalableMarkers(gc, this.xPositions, COLOR_GREY);
    }

    private void drawMarkers(GC gc, TreeMap<Integer, PosMarkers> tmpXPositions, Color color) {
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setForeground(color);
        gc.setBackground(color);
        for (Map.Entry<Integer, PosMarkers> xEntry : tmpXPositions.entrySet()) {
            int actualWidth = this.elementWidth;
            int xPosOffset = this.stripNetX0 - this.elementWidth / 2 - actualWidth / 2 + 1;
            int yPosOffset = this.drawStripBounds.y - actualWidth / 2 + 1;
            for (Integer yPos : xEntry.getValue().getYPositions()) {
                if (yPos == null) continue;
                gc.fillRectangle(xEntry.getKey() + xPosOffset, yPos + yPosOffset, actualWidth, actualWidth);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, String.format("x=%d y=%d", xEntry.getKey() + xPosOffset, yPos + yPosOffset));
            }
        }
    }

    private void drawScalableMarkers(GC gc, MarkerPositions markerPositions, Color color) {
        gc.setLineWidth(1);
        gc.setLineStyle(1);
        gc.setForeground(color);
        gc.setBackground(color);
        int[] tukeyXPositions = this.defineTukeyXPositions();
        markerPositions.entrySet().stream().filter(x -> (Integer)x.getKey() >= 0 && (Integer)x.getKey() <= this.stripNetWidth).forEach(xEntry -> {
            int lowerLimit = tukeyXPositions[ElementaryQuantile.BoxplotItems.LOWER_WHISKER.ordinal()] / this.elementWidth * this.elementWidth;
            int upperLimit = (tukeyXPositions[ElementaryQuantile.BoxplotItems.UPPER_WHISKER.ordinal()] / this.elementWidth + 1) * this.elementWidth;
            int actualWidth = (Integer)xEntry.getKey() < lowerLimit || (Integer)xEntry.getKey() > upperLimit ? this.elementWidth * 2 : this.elementWidth;
            int xPosOffset = this.stripNetX0 - this.elementWidth / 2 - actualWidth / 2 + 1;
            int yPosOffset = this.drawStripBounds.y - actualWidth / 2 + 1;
            for (Integer yPos : ((PosMarkers)xEntry.getValue()).getYPositions()) {
                if (yPos == null) continue;
                gc.fillRectangle((Integer)xEntry.getKey() + xPosOffset, yPos + yPosOffset, actualWidth, actualWidth);
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, String.format("x=%d y=%d", (Integer)xEntry.getKey() + xPosOffset, yPos + yPosOffset));
            }
        });
    }

    public void drawConnections(GC gc, SummarySpots startSpots, Measure measure) {
        Point[] startFirstLastPoints = startSpots.defineFirstLastPoints(measure);
        Point[] endFirstLastPoints = this.defineFirstLastPoints(measure);
        int xPosOffset = this.stripNetX0 - this.elementWidth / 2 + 1;
        int startYPosOffset = startSpots.drawStripBounds.y + 1;
        int endYPosOffset = this.drawStripBounds.y + 1;
        gc.setLineWidth(1);
        gc.setLineStyle(2);
        gc.setForeground(COLOR_DARK_GREEN);
        gc.setBackground(COLOR_DARK_GREEN);
        if (startFirstLastPoints[0] != null && endFirstLastPoints[0] != null) {
            gc.drawLine(endFirstLastPoints[0].x + xPosOffset, endFirstLastPoints[0].y + endYPosOffset, startFirstLastPoints[0].x + xPosOffset, startFirstLastPoints[0].y + startYPosOffset);
        }
        if (measure.isDeltaMeasure()) {
            gc.setForeground(COLOR_BLUE);
            gc.setBackground(COLOR_BLUE);
            if (startFirstLastPoints[1] != null && endFirstLastPoints[1] != null) {
                gc.drawLine(endFirstLastPoints[1].x + xPosOffset, endFirstLastPoints[1].y + endYPosOffset, startFirstLastPoints[1].x + xPosOffset, startFirstLastPoints[1].y + startYPosOffset);
            }
        }
    }

    public Rectangle getDrawStripBounds() {
        return this.drawStripBounds;
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    private List<Integer> getSnappedIndexes(int stripXPos) {
        int xDrawer = stripXPos - stripXPos % this.elementWidth;
        PosMarkers posMarkers = this.xPositions.get(xDrawer);
        log.log(Level.FINER, "stripXPos=", stripXPos);
        return posMarkers != null ? posMarkers.toList() : new ArrayList<Integer>();
    }

    public List<Integer> getSnappedIndexes(int stripXPos, int stripYPos) {
        if (this.drawStripBounds == null) {
            return new ArrayList<Integer>();
        }
        if (stripYPos < 0 || stripYPos > this.drawStripBounds.height) {
            return new ArrayList<Integer>();
        }
        if (this.xPositions.isEmpty()) {
            return new ArrayList<Integer>();
        }
        List<Integer> indexes = this.getSnappedIndexes(stripXPos);
        if (indexes.size() <= 1) {
            return indexes;
        }
        int maxAdditionalMarker = (this.drawStripBounds.height - this.elementWidth) / 2 / (this.elementWidth + 1) * 2;
        if (maxAdditionalMarker == 0 || indexes.size() > maxAdditionalMarker + 1) {
            return indexes;
        }
        int markersHeight = (this.elementWidth + 1) * (maxAdditionalMarker + 1);
        int markersYPos = stripYPos - (this.drawStripBounds.height - markersHeight) / 2;
        if (markersYPos >= 0 && markersYPos < markersHeight) {
            int index;
            int relativePosition = markersYPos / (this.elementWidth + 1);
            int alternatingPosition = maxAdditionalMarker / 2 - relativePosition;
            log.finest(() -> "stripYPos=" + stripYPos + "  markersYPos=" + markersYPos + "  elementWidth=" + this.elementWidth + "  relativePosition=" + relativePosition + "  alternatingPosition=" + alternatingPosition);
            int n = index = alternatingPosition > 0 ? alternatingPosition * 2 - 1 : -alternatingPosition * 2;
            if (index >= indexes.size()) {
                return new ArrayList<Integer>();
            }
            log.finest(() -> "alternatingPosition=" + alternatingPosition + "  index=" + index);
            return new ArrayList<Integer>(Arrays.asList(indexes.get(index)));
        }
        return new ArrayList<Integer>();
    }

    public static final class MarkerPositions {
        private final TreeMap<Integer, PosMarkers> markerPositions = new TreeMap();

        public void clear() {
            this.markerPositions.clear();
        }

        public PosMarkers put(int xDrawer, PosMarkers posMarkers) {
            return this.markerPositions.put(xDrawer, posMarkers);
        }

        public PosMarkers get(int xDrawer) {
            return this.markerPositions.get(xDrawer);
        }

        public boolean isEmpty() {
            return this.markerPositions.isEmpty();
        }

        public Set<Map.Entry<Integer, PosMarkers>> entrySet() {
            return this.markerPositions.entrySet();
        }

        public void putAll(MarkerPositions newPositions) {
            this.markerPositions.putAll(newPositions.markerPositions);
        }

        public String toString() {
            return "MarkerPositions [markerPositionSize=" + this.markerPositions.size() + "markerPositions=" + this.markerPositions + "]";
        }
    }

    public static enum Density {
        EXTREME(2),
        HIGH(3),
        MEDIUM(4),
        LOW(5);

        private final Settings settings = Settings.getInstance();
        private final int distanceThreshold = 25;
        private final int markerWidth;
        public static final Density[] VALUES;

        private Density(int markerWidth) {
            this.markerWidth = markerWidth;
        }

        public static Density fromOrdinal(int ordinal) {
            return VALUES[ordinal];
        }

        public static String toString(Density density) {
            return density.name();
        }

        public static Density toDensity(int drawAreaWidth, int markerNumber) {
            int avgDistance = (int)(0.0 + (double)(drawAreaWidth / markerNumber));
            Density density = avgDistance > LOW.getThresholdDistance() ? LOW : (avgDistance > MEDIUM.getThresholdDistance() ? MEDIUM : (avgDistance > HIGH.getThresholdDistance() ? HIGH : EXTREME));
            log.finer(() -> String.format("density=%s  convenientDistance=%d  thresholdDistance=%d  elementWidth=%d", new Object[]{density, avgDistance, density.getThresholdDistance(), density.markerWidth}));
            return density;
        }

        private int getThresholdDistance() {
            return this.markerWidth * 25 / (1 + this.settings.getBoxplotScaleOrdinal());
        }

        static {
            VALUES = Density.values();
        }
    }

    public static final class PosMarkers
    implements Iterable<Integer> {
        private final Logger log = Logger.getLogger(PosMarkers.class.getName());
        private final List<Integer> recordIndices = new ArrayList<Integer>();
        private final List<Integer> yPositions = new ArrayList<Integer>();
        private final int elementWidth;
        private final int yStep;
        private final int stripHeight;
        private final int halfDrawingHeight;
        private int cycleNumber = 0;
        private int nextRelativeYPos = 0;

        PosMarkers(int stripHeight, int elementWidth) {
            this.stripHeight = stripHeight;
            this.elementWidth = elementWidth;
            this.yStep = elementWidth + 1;
            this.halfDrawingHeight = (stripHeight - 1) / 2;
        }

        public Integer get(int index) {
            return this.recordIndices.get(index);
        }

        public boolean add(Integer recordIndex) {
            int yPosition = recordIndex == null ? null : Integer.valueOf(-this.nextRelativeYPos + this.halfDrawingHeight + 0);
            this.yPositions.add(yPosition);
            this.nextRelativeYPos = (this.size() - 1) % 2 == 0 && this.nextRelativeYPos != 0 ? -Math.abs(this.nextRelativeYPos) : Math.abs(this.nextRelativeYPos) + this.yStep;
            if (this.nextRelativeYPos > this.halfDrawingHeight - this.elementWidth / 2) {
                ++this.cycleNumber;
                this.nextRelativeYPos = this.yStep - this.cycleNumber % this.yStep - 1;
            }
            this.log.finest(() -> String.format("%d cycleNumber=%d nextRelativeYPos=%d", this.size(), this.cycleNumber, this.nextRelativeYPos));
            return this.recordIndices.add(recordIndex);
        }

        public Integer setToNull(int index) {
            this.yPositions.set(index, null);
            return this.recordIndices.set(index, null);
        }

        public PosMarkers clone() {
            PosMarkers newPosMarkers = new PosMarkers(this.stripHeight, this.elementWidth);
            newPosMarkers.cycleNumber = this.cycleNumber;
            newPosMarkers.nextRelativeYPos = this.nextRelativeYPos;
            newPosMarkers.recordIndices.addAll(this.recordIndices);
            newPosMarkers.yPositions.addAll(this.yPositions);
            return newPosMarkers;
        }

        public List<Integer> getYPositions() {
            return this.yPositions;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.recordIndices.listIterator();
        }

        public int size() {
            return this.recordIndices.size();
        }

        public Stream<Integer> stream() {
            return this.recordIndices.stream();
        }

        public List<Integer> toList() {
            return this.recordIndices;
        }

        public String toString() {
            return "PosMarkers [recordIndices=" + this.recordIndices + ", yStep=" + this.yStep + ", stripHeight=" + this.stripHeight + ", cycleNumber=" + this.cycleNumber + ", nextRelativeYPos=" + this.nextRelativeYPos + "]";
        }
    }
}

