/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.comm.IDeviceCommPort;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.CheckSumTypes;
import gde.device.CommaSeparatorTypes;
import gde.device.DataBitsTypes;
import gde.device.DataTypes;
import gde.device.DesktopPropertyTypes;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.DeviceTypes;
import gde.device.FormatTypes;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.ParityTypes;
import gde.device.PropertyType;
import gde.device.StateType;
import gde.device.StatisticsType;
import gde.device.StopBitsTypes;
import gde.device.TimeUnitTypes;
import gde.exception.DataInconsitsentException;
import gde.utils.CalculationThread;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.custom.CTabItem;

public interface IDevice {
    public static final String OFFSET = MeasurementPropertyTypes.OFFSET.value();
    public static final String FACTOR = MeasurementPropertyTypes.FACTOR.value();
    public static final String REDUCTION = MeasurementPropertyTypes.REDUCTION.value();
    public static final String IS_BITS = MeasurementPropertyTypes.IS_BITS.value();
    public static final String IS_TOKENS = MeasurementPropertyTypes.IS_TOKENS.value();
    public static final String SYNC_ORDINAL = MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value();
    public static final int MIN_FILENAME_LENGTH = 4;

    public DeviceConfiguration getDeviceConfiguration();

    public String getPropertiesFileName();

    public boolean isChangePropery();

    public DeviceDialog getDialog();

    public IDeviceCommPort getCommunicationPort();

    public String getName();

    public void setName(String var1);

    public boolean isUsed();

    public String getManufacturer();

    public void setManufacturer(String var1);

    public DeviceTypes getDeviceGroup();

    public void setDeviceGroup(DeviceTypes var1);

    public String getManufacturerURL();

    public void setManufacturerURL(String var1);

    public String getImageFileName();

    public void setImageFileName(String var1);

    public boolean isTableTabRequested();

    public void setTableTabRequested(boolean var1);

    public boolean isDigitalTabRequested();

    public void setDigitalTabRequested(boolean var1);

    public boolean isAnalogTabRequested();

    public void setAnalogTabRequested(boolean var1);

    public boolean isVoltagePerCellTabRequested();

    public void setVoltagePerCellTabRequested(boolean var1);

    public int getDesktopTargetReferenceOrdinal(DesktopPropertyTypes var1);

    public boolean isUtilityGraphicsTabRequested();

    public boolean isUtilityDeviceTabRequested();

    public CTabItem getUtilityGraphicsTabItem();

    public CTabItem getUtilityDeviceTabItem();

    public double getTimeStep_ms();

    public void setTimeStep_ms(double var1);

    public Double getAverageTimeStep_ms();

    public void setAverageTimeStep_ms(double var1);

    public short getUTCdelta();

    public void setUTCdelta(int var1);

    public String getPort();

    public void setPort(String var1);

    public Integer getBaudeRate();

    public DataBitsTypes getDataBits();

    public StopBitsTypes getStopBits();

    public int getFlowCtrlMode();

    public ParityTypes getParity();

    public boolean isDTR();

    public boolean isRTS();

    public int getDataBlockSize(InputTypes var1);

    public int getDataBlockSize(FormatTypes var1);

    public void setDataBlockSize(InputTypes var1, FormatTypes var2, Integer var3);

    public FormatTypes getDataBlockFormat(InputTypes var1);

    public void setDataBlockFormat(InputTypes var1, FormatTypes var2);

    public CheckSumTypes getDataBlockCheckSumType();

    public void setDataBlockCheckSumType(CheckSumTypes var1);

    public FormatTypes getDataBlockCheckSumFormat();

    public void setDataBlockCheckSumFormat(FormatTypes var1);

    public void setDataBlockTimeUnit(TimeUnitTypes var1);

    public int getDataBlockTimeUnitFactor();

    public String getDataBlockLeader();

    public void setDataBlockLeader(String var1);

    public CommaSeparatorTypes getDataBlockSeparator();

    public void setDataBlockSeparator(CommaSeparatorTypes var1);

    public byte[] getDataBlockEnding();

    public void setDataBlockEnding(String var1);

    public String getDataBlockPreferredDataLocation();

    public void setDataBlockPreferredDataLocation(String var1);

    public String getDataBlockPreferredFileExtention();

    public void setDataBlockPreferredFileExtention(String var1);

    public StateType getStateType();

    public int getChannelCount();

    public String getChannelName(int var1);

    public String getChannelNameReplacement(int var1);

    public void setChannelName(String var1, int var2);

    public ChannelTypes getChannelTypes(int var1);

    public List<MeasurementType> getChannelMeasuremts(int var1);

    @Deprecated
    public List<MeasurementType> getChannelMeasuremts(String var1);

    public List<MeasurementType> getChannelMeasuremtsReplacedNames(int var1);

    public List<PropertyType> getProperties(int var1, int var2);

    @Deprecated
    public List<PropertyType> getProperties(String var1, int var2);

    public int getNumberOfMeasurements(int var1);

    @Deprecated
    public int getNumberOfMeasurements(String var1);

    public MeasurementType getMeasurement(int var1, int var2);

    @Deprecated
    public MeasurementType getMeasurement(String var1, int var2);

    public void setMeasurementActive(int var1, int var2, boolean var3);

    public String[] getMeasurementNames(int var1);

    public String[] getMeasurementNamesReplacements(int var1);

    @Deprecated
    public String[] getMeasurementNames(String var1);

    public String getMeasurementName(int var1, int var2);

    public String getMeasurementNameReplacement(int var1, int var2);

    public void setMeasurementName(int var1, int var2, String var3);

    @Deprecated
    public void setMeasurementName(String var1, int var2, String var3);

    public String getMeasurementUnit(int var1, int var2);

    @Deprecated
    public String getMeasurementUnit(String var1, int var2);

    public void setMeasurementUnit(int var1, int var2, String var3);

    @Deprecated
    public void setMeasurementUnit(String var1, int var2, String var3);

    public String getMeasurementSymbol(int var1, int var2);

    @Deprecated
    public String getMeasurementSymbol(String var1, int var2);

    public void setMeasurementSymbol(int var1, int var2, String var3);

    @Deprecated
    public void setMeasurementSymbol(String var1, int var2, String var3);

    public String getMeasurementLabelReplacement(int var1, int var2);

    public StatisticsType getMeasurementStatistic(int var1, int var2);

    @Deprecated
    public StatisticsType getMeasurementStatistic(String var1, int var2);

    public PropertyType getMeasruementProperty(int var1, int var2, String var3);

    @Deprecated
    public PropertyType getMeasruementProperty(String var1, int var2, String var3);

    public double getMeasurementOffset(int var1, int var2);

    @Deprecated
    public double getMeasurementOffset(String var1, int var2);

    public void setMeasurementOffset(int var1, int var2, double var3);

    @Deprecated
    public void setMeasurementOffset(String var1, int var2, double var3);

    public double getMeasurementFactor(int var1, int var2);

    @Deprecated
    public double getMeasurementFactor(String var1, int var2);

    public void setMeasurementFactor(int var1, int var2, double var3);

    @Deprecated
    public void setMeasurementFactor(String var1, int var2, double var3);

    public Object getMeasurementPropertyValue(int var1, int var2, String var3);

    @Deprecated
    public Object getMeasurementPropertyValue(String var1, int var2, String var3);

    public void setMeasurementPropertyValue(int var1, int var2, String var3, DataTypes var4, Object var5);

    @Deprecated
    public void setMeasurementPropertyValue(String var1, int var2, String var3, DataTypes var4, Object var5);

    public int getLastChannelNumber();

    public void setLastChannelNumber(int var1);

    public String getRecordSetStemName();

    public String getRecordSetStemNameReplacement();

    public String getRecordSetStateName(int var1);

    public String getRecordSetStateNameReplacement(int var1);

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> var1);

    public String getConvertedRecordConfigurations(HashMap<String, String> var1, HashMap<String, String> var2, int var3);

    public int getLovDataByteSize();

    public int[] convertDataBytes(int[] var1, byte[] var2);

    public void addDataBufferAsRawDataPoints(RecordSet var1, byte[] var2, int var3, boolean var4) throws DataInconsitsentException;

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet var1, byte[] var2, int var3, boolean var4) throws DataInconsitsentException;

    public String[] prepareExportRow(RecordSet var1, String[] var2, int var3);

    public String[] prepareRawExportRow(RecordSet var1, String[] var2, int var3);

    public String[] prepareDataTableRow(RecordSet var1, String[] var2, int var3);

    public double translateValue(Record var1, double var2);

    public double reverseTranslateValue(Record var1, double var2);

    default public double translateDeltaValue(Record record, double value) {
        double newValue = 0.0;
        if (this.isGPSCoordinates(record)) {
            newValue = value / 1000.0;
        } else {
            switch (record.getDataType()) {
                case GPS_LATITUDE: 
                case GPS_LONGITUDE: {
                    newValue = value / 1000.0;
                    break;
                }
                default: {
                    newValue = value * record.getFactor();
                }
            }
        }
        return newValue;
    }

    public void makeInActiveDisplayable(RecordSet var1);

    public void updateVisibilityStatus(RecordSet var1, boolean var2);

    public void setChangePropery(boolean var1);

    public void storeDeviceProperties();

    public String[] getUsedPropertyKeys();

    public void open_closeCommPort();

    public void configureSerialPortMenu(int var1, String var2, String var3);

    public CalculationThread getCalculationThread();

    public int[] getCellVoltageOrdinals();

    public boolean isActualRecordSetWithGpsData();

    public String exportFile(String var1, boolean var2);

    public String getJarName();

    public void setGPS2KMZMeasurementOrdinal(Integer var1);

    public Integer getGPS2KMZMeasurementOrdinal();

    public String translateGPS2IGC(RecordSet var1, int var2, char var3, int var4, int var5);

    public String[] getNoneCalculationMeasurementNames(int var1, String[] var2);

    public String[] crossCheckMeasurements(String[] var1, RecordSet var2);

    public void applyMeasurementSpecialties(String[] var1, RecordSet var2);

    public void removeMeasurementFromChannel(int var1, MeasurementType var2);

    public boolean isFilterEnabled();

    public Integer getFilteredPoint(int var1, Record var2, int var3);

    public boolean isGPSCoordinates(Record var1);

    public int getMeasurementOrdinalFirstLithiumCell(RecordSet var1);

    public int getNumberOfLithiumCells(Object var1);

    public boolean recordSetNumberFollowChannel();

    public boolean useChannelWithSyncedDescription();

    public int getCurrentSmoothIndex();

    public short getUsbVendorId();

    public short getUsbProductId();

    public String getUsbProductString();

    public byte getUsbInterface();

    public byte getUsbEndpointIn();

    public byte getUsbEndpointOut();

    public boolean isVariableMeasurementSize();

    public String getFileBaseDir();

    default public String toStringOption() {
        return "IDevice [name=" + this.getName() + ", isUsed=" + this.isUsed() + ", deviceGroup=" + (Object)((Object)this.getDeviceGroup()) + ", channelCount=" + this.getChannelCount() + "]";
    }

    public int[] getAtlitudeTripSpeedOrdinals();

    public String getMeasurementReplacement(String var1);

    public String crossCheckChannelConfig(String var1, HashMap<String, String> var2);
}

