/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.Graphene;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    long modelHandle;
    long checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int sortDirection;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    long ignoreCell;
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    boolean firstCompute = true;
    int drawState;
    int drawFlags;
    GdkRGBA background;
    GdkRGBA foreground;
    GdkRGBA drawForegroundRGBA;
    Color headerBackground;
    Color headerForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean pixbufSizeSet;
    boolean hasChildren;
    int maxWidth = 0;
    int topIndex;
    double cachedAdjustment;
    double currentAdjustment;
    int pixbufHeight;
    int pixbufWidth;
    int headerHeight;
    boolean boundsChangedSinceLastDraw;
    boolean headerVisible;
    boolean wasScrolled;
    boolean rowActivated;
    private long headerCSSProvider;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_SURFACE = 5;
    static final int CELL_TYPES = 6;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    @Override
    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.ownerDraw) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, n, false);
        return this.items[n];
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    long cellDataProc(long l, long l2, long l3, long l4, long l5) {
        if (l2 == this.ignoreCell) {
            return 0L;
        }
        long l6 = GTK.gtk_tree_model_get_path(l3, l4);
        int[] nArray = new int[1];
        C.memmove(nArray, GTK.gtk_tree_path_get_indices(l6), 4L);
        TableItem tableItem = this._getItem(nArray[0]);
        GTK.gtk_tree_path_free(l6);
        if (tableItem != null) {
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX2, tableItem.handle);
        }
        boolean bl = GTK.GTK_IS_CELL_RENDERER_PIXBUF(l2);
        boolean bl2 = GTK.GTK_IS_CELL_RENDERER_TEXT(l2);
        if (bl2) {
            GTK.gtk_cell_renderer_set_fixed_size(l2, -1, -1);
        }
        if (!bl && !bl2) {
            return 0L;
        }
        int n = -1;
        boolean bl3 = false;
        if (this.columnCount == 0) {
            n = 5;
            bl3 = this.firstCustomDraw;
        } else {
            TableColumn tableColumn = (TableColumn)this.display.getWidget(l);
            if (tableColumn != null) {
                n = tableColumn.modelIndex;
                bl3 = tableColumn.customDraw;
            }
        }
        if (n == -1) {
            return 0L;
        }
        boolean bl4 = false;
        if ((this.style & 0x10000000) != 0 && !tableItem.cached) {
            this.lastIndexOf = nArray[0];
            bl4 = this.checkData(tableItem);
        }
        long[] lArray = new long[1];
        if (bl4) {
            lArray[0] = 0L;
            if (bl) {
                GTK.gtk_tree_model_get(l3, l4, n + 0, lArray, -1);
                OS.g_object_set(l2, OS.gicon, lArray[0], 0L);
                if (lArray[0] != 0L) {
                    OS.g_object_unref(lArray[0]);
                }
            } else {
                GTK.gtk_tree_model_get(l3, l4, n + 1, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.text, lArray[0], 0L);
                    OS.g_free(lArray[0]);
                }
            }
        }
        if (bl3) {
            if (!this.ownerDraw) {
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 3, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.cell_background_rgba, lArray[0], 0L);
                    GDK.gdk_rgba_free(lArray[0]);
                }
            }
            if (!bl) {
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 2, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.foreground_rgba, lArray[0], 0L);
                    GDK.gdk_rgba_free(lArray[0]);
                }
                lArray[0] = 0L;
                GTK.gtk_tree_model_get(l3, l4, n + 4, lArray, -1);
                if (lArray[0] != 0L) {
                    OS.g_object_set(l2, OS.font_desc, lArray[0], 0L);
                    OS.pango_font_description_free(lArray[0]);
                }
            }
        }
        if (bl4) {
            this.ignoreCell = l2;
            this.setScrollWidth(l, tableItem);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TableItem tableItem) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, GTK.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            this.currentItem = tableItem;
            tableItem.settingData = true;
            this.sendEvent(36, event);
            tableItem.settingData = false;
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0L, 0L, this.handle);
            if (tableItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int calculateWidth(long l, long l2) {
        GTK.gtk_tree_view_column_cell_set_cell_data(l, this.modelHandle, l2, false, false);
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            GTK4.gtk_tree_view_column_cell_get_size(l, null, null, nArray, null);
        } else {
            GTK3.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray, null);
        }
        long l3 = this.getTextRenderer(l);
        int[] nArray2 = new int[1];
        if (l3 != 0L) {
            GTK.gtk_cell_renderer_get_padding(l3, nArray2, null);
        }
        return nArray[0] + nArray2[0] * 2;
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.clear();
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            for (int i = n; i <= n2; ++i) {
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                tableItem.clear();
            }
        }
    }

    public void clear(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        for (n = 0; n < nArray.length; ++n) {
            if (0 <= nArray[n] && nArray[n] < this.itemCount) continue;
            this.error(6);
        }
        for (n = 0; n < nArray.length; ++n) {
            TableItem tableItem = this.items[nArray[n]];
            if (tableItem == null) continue;
            tableItem.clear();
        }
    }

    public void clearAll() {
        this.checkWidget();
        for (int i = 0; i < this.itemCount; ++i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null) continue;
            tableItem.clear();
        }
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        if (this.firstCompute) {
            for (int i = 0; i < this.columns.length; ++i) {
                object = this.columns[i];
                if (object == null) continue;
                GTK.gtk_widget_set_visible(((TableColumn)object).buttonHandle, true);
            }
            this.firstCompute = false;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (n2 == -1 && point.y == this.getHeaderHeight() || point.y == 0) {
            point.y = this.getItemCount() * this.getItemHeight() + this.getHeaderHeight();
        }
        if (n == -1 && point.x == 0 && this.columnCount == 0) {
            point.x = this.maxWidth;
        }
        object = this.computeTrimInPixels(0, 0, point.x, point.y);
        point.x = ((Rectangle)object).width;
        if (point.y == this.headerHeight && this.headerVisible && (this.style & 0x10) != 0) {
            ++((Rectangle)object).height;
        }
        point.y = ((Rectangle)object).height;
        return point;
    }

    void copyModel(long l, int n, long l2, int n2, int n3) {
        long l3 = OS.g_malloc(OS.GValue_sizeof());
        C.memset(l3, 0, OS.GValue_sizeof());
        for (int i = 0; i < this.itemCount; ++i) {
            int n4;
            long l4 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (l4 == 0L) {
                this.error(2);
            }
            GTK.gtk_list_store_append(l2, l4);
            TableItem tableItem = this.items[i];
            if (tableItem == null) {
                OS.g_free(l4);
                continue;
            }
            long l5 = tableItem.handle;
            for (n4 = 0; n4 < 5; ++n4) {
                GTK.gtk_tree_model_get_value(l, l5, n4, l3);
                GTK.gtk_list_store_set_value(l2, l4, n4, l3);
                OS.g_value_unset(l3);
            }
            for (n4 = 0; n4 < n3 - 5; ++n4) {
                GTK.gtk_tree_model_get_value(l, l5, n + n4, l3);
                GTK.gtk_list_store_set_value(l2, l4, n2 + n4, l3);
                OS.g_value_unset(l3);
            }
            GTK.gtk_list_store_remove(l, l5);
            OS.g_free(l5);
            tableItem.handle = l4;
        }
        OS.g_free(l3);
    }

    void createColumn(TableColumn tableColumn, int n) {
        long l;
        int n2;
        int n3 = 5;
        if (this.columnCount != 0) {
            int n4 = GTK.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] blArray = new boolean[n4];
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                int n5 = this.columns[n2].modelIndex;
                for (int i = 0; i < 6; ++i) {
                    blArray[n5 + i] = true;
                }
            }
            while (n3 < n4 && blArray[n3]) {
                ++n3;
            }
            if (n3 == n4) {
                long l2 = this.modelHandle;
                long[] lArray = this.getColumnTypes(this.columnCount + 4);
                long l3 = GTK.gtk_list_store_newv(lArray.length, lArray);
                if (l3 == 0L) {
                    this.error(2);
                }
                GTK.gtk_tree_view_set_model(this.handle, 0L);
                this.copyModel(l2, 5, l3, 5, n4);
                GTK.gtk_tree_view_set_model(this.handle, l3);
                this.setModel(l3);
            }
        }
        if ((l = GTK.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            TableColumn tableColumn2 = this.columns[0];
            this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, false, tableColumn2.style);
        }
        this.createRenderers(l, n3, n == 0, tableColumn == null ? 0 : tableColumn.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            GTK.gtk_tree_view_column_set_sizing(l, 0);
        } else {
            GTK.gtk_tree_view_column_set_sizing(l, 2);
        }
        GTK.gtk_tree_view_column_set_resizable(l, true);
        GTK.gtk_tree_view_column_set_clickable(l, true);
        GTK.gtk_tree_view_column_set_min_width(l, 0);
        GTK.gtk_tree_view_insert_column(this.handle, l, n);
        if (this.columnCount != 0) {
            GTK.gtk_tree_view_column_set_visible(l, false);
        }
        if (tableColumn != null) {
            tableColumn.handle = l;
            tableColumn.modelIndex = n3;
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            n2 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, n2 + 1);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.scrolledHandle = GTK4.gtk_scrolled_window_new();
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            this.scrolledHandle = GTK3.gtk_scrolled_window_new(0L, 0L);
        }
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] lArray = this.getColumnTypes(1);
        this.modelHandle = GTK.gtk_list_store_newv(lArray.length, lArray);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
            GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            GTK3.gtk_container_add(this.scrolledHandle, this.handle);
        }
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        GTK.gtk_tree_selection_set_mode(l, n2);
        GTK.gtk_tree_view_set_headers_visible(this.handle, false);
        int n3 = (this.style & 0x100) != 0 ? 1 : 2;
        int n4 = (this.style & 0x200) != 0 ? 1 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, n3, n4);
        if ((this.style & 0x800) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_scrolled_window_set_has_frame(this.scrolledHandle, true);
            } else {
                GTK3.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        }
    }

    void createItem(TableColumn tableColumn, int n) {
        long l;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            tableColumn.handle = GTK.gtk_tree_view_get_column(this.handle, 0);
            GTK.gtk_tree_view_column_set_sizing(tableColumn.handle, 2);
            GTK.gtk_tree_view_column_set_visible(tableColumn.handle, false);
            tableColumn.modelIndex = 5;
            this.createRenderers(tableColumn.handle, tableColumn.modelIndex, true, tableColumn.style);
            tableColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(tableColumn, n);
        }
        long l2 = this.gtk_box_new(0, false, 3);
        if (l2 == 0L) {
            this.error(2);
        }
        GTK.gtk_tree_view_column_set_widget(tableColumn.handle, l2);
        long l3 = GTK.gtk_label_new_with_mnemonic(null);
        if (l3 == 0L) {
            this.error(2);
        }
        if ((l = GTK.gtk_image_new()) == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_box_append(l2, l);
            GTK4.gtk_box_append(l2, l3);
            GTK.gtk_widget_hide(l);
        } else {
            GTK3.gtk_container_add(l2, l);
            GTK3.gtk_container_add(l2, l3);
            GTK.gtk_widget_show(l2);
            GTK.gtk_widget_show(l3);
        }
        tableColumn.labelHandle = l3;
        tableColumn.imageHandle = l;
        tableColumn.buttonHandle = GTK.gtk_tree_view_column_get_button(tableColumn.handle);
        GTK.gtk_widget_set_focus_on_click(tableColumn.buttonHandle, false);
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        if ((this.state & 0x4000) != 0) {
            long l4 = this.getFontDescription();
            tableColumn.setFontDescription(l4);
            OS.pango_font_description_free(l4);
        }
        if (this.columnCount >= 1) {
            for (int i = 0; i < this.itemCount; ++i) {
                Object[] objectArray;
                boolean bl;
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                Font[] fontArray = tableItem.cellFont;
                boolean bl2 = bl = this.columnCount == 1 && fontArray != null && fontArray.length == this.columnCount;
                if (fontArray != null && !bl) {
                    objectArray = new Font[this.columnCount];
                    System.arraycopy(fontArray, 0, objectArray, 0, n);
                    System.arraycopy(fontArray, n, objectArray, n + 1, this.columnCount - n - 1);
                    tableItem.cellFont = objectArray;
                }
                objectArray = tableItem.strings;
                boolean bl3 = bl = this.columnCount == 1 && objectArray != null && objectArray.length == this.columnCount;
                if (objectArray == null || bl) continue;
                String[] stringArray = new String[this.columnCount];
                System.arraycopy(objectArray, 0, stringArray, 0, n);
                System.arraycopy(objectArray, n, stringArray, n + 1, this.columnCount - n - 1);
                stringArray[n] = "";
                tableItem.strings = stringArray;
            }
        }
        this.updateHeaderCSS();
        if (!this.isVisible()) {
            this.forceResize();
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (0 > n || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.drawCount <= 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        tableItem.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (tableItem.handle == 0L) {
            this.error(2);
        }
        if (n == this.itemCount) {
            GTK.gtk_list_store_append(this.modelHandle, tableItem.handle);
        } else {
            GTK.gtk_list_store_insert(this.modelHandle, tableItem.handle, n);
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
    }

    void createRenderers(long l, int n, boolean bl, int n2) {
        long l2;
        long l3;
        GTK.gtk_tree_view_column_clear(l);
        if ((this.style & 0x20) != 0 && bl) {
            GTK.gtk_tree_view_column_pack_start(l, this.checkRenderer, false);
            GTK.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.active, 0);
            GTK.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.inconsistent, 1);
            if (this.ownerDraw) {
                GTK.gtk_tree_view_column_set_cell_data_func(l, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, l);
            } else {
                GTK.gtk_tree_view_column_add_attribute(l, this.checkRenderer, OS.cell_background_rgba, 3);
            }
        }
        long l4 = l3 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : GTK.gtk_cell_renderer_pixbuf_new();
        if (l3 == 0L) {
            this.error(2);
        } else if (!this.ownerDraw) {
            GTK.gtk_cell_renderer_set_fixed_size(l3, 0, 0);
        }
        long l5 = l2 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : GTK.gtk_cell_renderer_text_new();
        if (l2 == 0L) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(l3, Display.SWT_OBJECT_INDEX1, l);
            OS.g_object_set_qdata(l2, Display.SWT_OBJECT_INDEX1, l);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(l3, OS.mode, 1, 0L);
        }
        if ((n2 & 0x20000) != 0) {
            OS.g_object_set(l2, OS.xalign, 1.0f, 0L);
            GTK.gtk_tree_view_column_pack_end(l, l2, true);
            GTK.gtk_tree_view_column_pack_end(l, l3, false);
            GTK.gtk_tree_view_column_set_alignment(l, 1.0f);
        } else if ((n2 & 0x1000000) != 0) {
            OS.g_object_set(l2, OS.xalign, 0.5f, 0L);
            GTK.gtk_tree_view_column_pack_start(l, l3, false);
            GTK.gtk_tree_view_column_pack_end(l, l2, true);
            GTK.gtk_tree_view_column_set_alignment(l, 0.5f);
        } else {
            GTK.gtk_tree_view_column_pack_start(l, l3, false);
            GTK.gtk_tree_view_column_pack_start(l, l2, true);
            GTK.gtk_tree_view_column_set_alignment(l, 0.0f);
        }
        GTK.gtk_tree_view_column_add_attribute(l, l3, OS.pixbuf, n + 0);
        if (!this.ownerDraw) {
            GTK.gtk_tree_view_column_add_attribute(l, l3, OS.cell_background_rgba, 3);
            GTK.gtk_tree_view_column_add_attribute(l, l2, OS.cell_background_rgba, 3);
        }
        GTK.gtk_tree_view_column_add_attribute(l, l2, OS.text, n + 1);
        GTK.gtk_tree_view_column_add_attribute(l, l2, OS.foreground_rgba, 2);
        GTK.gtk_tree_view_column_add_attribute(l, l2, OS.font_desc, 4);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != l) continue;
                bl2 = this.columns[i].customDraw;
                break;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.ownerDraw) {
            GTK.gtk_tree_view_column_set_cell_data_func(l, l2, this.display.cellDataProc, this.handle, 0L);
            GTK.gtk_tree_view_column_set_cell_data_func(l, l3, this.display.cellDataProc, this.handle, 0L);
        }
    }

    @Override
    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(GTK.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_iter(l, this._getItem((int)n).handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            if (i < 0 || i >= this.itemCount) continue;
            GTK.gtk_tree_selection_unselect_iter(l, this._getItem((int)i).handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.itemCount) continue;
            GTK.gtk_tree_selection_unselect_iter(l, this._getItem((int)n).handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TableColumn tableColumn) {
        int n;
        for (n = 0; n < this.columnCount && this.columns[n] != tableColumn; ++n) {
        }
        if (n == this.columnCount) {
            return;
        }
        long l = tableColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = tableColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        GTK.gtk_tree_view_remove_column(this.handle, l);
        if (this.columnCount == 0) {
            long l2 = this.modelHandle;
            long[] lArray = this.getColumnTypes(1);
            long l3 = GTK.gtk_list_store_newv(lArray.length, lArray);
            if (l3 == 0L) {
                this.error(2);
            }
            GTK.gtk_tree_view_set_model(this.handle, 0L);
            this.copyModel(l2, tableColumn.modelIndex, l3, 5, 11);
            GTK.gtk_tree_view_set_model(this.handle, l3);
            this.setModel(l3);
            this.createColumn(null, 0);
        } else {
            for (int i = 0; i < this.itemCount; ++i) {
                TableItem tableItem = this.items[i];
                if (tableItem == null) continue;
                long l4 = tableItem.handle;
                int n2 = tableColumn.modelIndex;
                GTK.gtk_list_store_set(this.modelHandle, l4, n2 + 0, 0L, -1);
                GTK.gtk_list_store_set(this.modelHandle, l4, n2 + 1, 0L, -1);
                GTK.gtk_list_store_set(this.modelHandle, l4, n2 + 2, 0L, -1);
                GTK.gtk_list_store_set(this.modelHandle, l4, n2 + 3, 0L, -1);
                GTK.gtk_list_store_set(this.modelHandle, l4, n2 + 4, 0L, -1);
                Font[] fontArray = tableItem.cellFont;
                if (fontArray == null) continue;
                if (this.columnCount == 0) {
                    tableItem.cellFont = null;
                    continue;
                }
                Font[] fontArray2 = new Font[this.columnCount];
                System.arraycopy(fontArray, 0, fontArray2, 0, n);
                System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                tableItem.cellFont = fontArray2;
            }
            if (n == 0) {
                TableColumn tableColumn2 = this.columns[0];
                this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, true, tableColumn2.style);
            }
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n3 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, n3 + 1);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n;
        for (n = 0; n < this.itemCount && this.items[n] != tableItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_list_store_remove(this.modelHandle, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3 = false;
        if (OS.isX11()) {
            boolean bl4;
            if (bl) {
                long[] lArray = new long[1];
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, n, n2, lArray, null, null, null)) {
                    if (lArray[0] != 0L) {
                        long l = GTK.gtk_tree_view_get_selection(this.handle);
                        if (GTK.gtk_tree_selection_path_is_selected(l, lArray[0])) {
                            bl3 = true;
                        }
                        GTK.gtk_tree_path_free(lArray[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((bl4 = super.dragDetect(n, n2, bl, false, blArray)) && bl3 && blArray != null) {
                blArray[0] = true;
            }
            return bl4;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        long[] lArray = new long[1];
        if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, dArray, dArray2)) {
            if (this.getHeaderVisible()) {
                dArray2[0] = dArray2[0] - (double)this.getHeaderHeightInPixels();
            }
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray, null, null, null)) {
                if (lArray[0] != 0L) {
                    boolean bl5 = super.dragDetect(n, n2, bl, false, blArray);
                    if (bl5 && bl3 && blArray != null) {
                        blArray[0] = true;
                    }
                    return bl5;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    @Override
    long eventSurface() {
        return this.paintSurface();
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle rectangle;
        int n;
        this.checkWidget();
        if (RESIZE_ON_GETCLIENTAREA) {
            this.forceResize();
        }
        long l = this.clientHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(l, gtkAllocation);
        int n2 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n3 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if (GTK.GTK4) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            GTK.gtk_tree_view_convert_bin_window_to_widget_coords(this.handle, 0, 0, nArray2, nArray);
            rectangle = new Rectangle(nArray2[0], nArray[0], n2, n);
        } else {
            GTK.gtk_widget_realize(this.handle);
            long l2 = this.gtk_widget_get_window(this.fixedHandle);
            long l3 = GTK3.gtk_tree_view_get_bin_window(this.handle);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            GDK.gdk_window_get_origin(l3, nArray, nArray3);
            int[] nArray4 = new int[1];
            int[] nArray5 = new int[1];
            GDK.gdk_window_get_origin(l2, nArray4, nArray5);
            rectangle = new Rectangle(nArray4[0] - nArray[0], nArray5[0] - nArray3[0], n2, n);
        }
        return rectangle;
    }

    @Override
    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            long l = this.gtk_widget_get_surface(this.handle);
            this.gdk_surface_get_size(l, nArray, nArray2);
        } else {
            GTK.gtk_widget_realize(this.handle);
            this.gdk_window_get_size(GTK3.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        }
        return nArray[0];
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    long[] getColumnTypes(int n) {
        long[] lArray = new long[5 + n * 6];
        lArray[0] = OS.G_TYPE_BOOLEAN();
        lArray[1] = OS.G_TYPE_BOOLEAN();
        lArray[2] = GDK.GDK_TYPE_RGBA();
        lArray[3] = GDK.GDK_TYPE_RGBA();
        lArray[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        for (int i = 5; i < lArray.length; i += 6) {
            lArray[i + 0] = GDK.GDK_TYPE_PIXBUF();
            lArray[i + 5] = OS.G_TYPE_LONG();
            lArray[i + 1] = OS.G_TYPE_STRING();
            lArray[i + 2] = GDK.GDK_TYPE_RGBA();
            lArray[i + 3] = GDK.GDK_TYPE_RGBA();
            lArray[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        }
        return lArray;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long l = GTK.gtk_tree_view_get_columns(this.handle);
        if (l == 0L) {
            return new int[0];
        }
        int n = 0;
        int n2 = OS.g_list_length(l);
        int[] nArray = new int[n2];
        long l2 = l;
        while (l2 != 0L) {
            long l3 = OS.g_list_data(l2);
            if (l3 != 0L) {
                for (int i = 0; i < this.columnCount; ++i) {
                    if (this.columns[i].handle != l3) continue;
                    nArray[n++] = i;
                    break;
                }
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_LIST_FOREGROUND_RGBA;
    }

    TableItem getFocusItem() {
        long[] lArray = new long[1];
        GTK.gtk_tree_view_get_cursor(this.handle, lArray, null);
        if (lArray[0] == 0L) {
            return null;
        }
        TableItem tableItem = null;
        long l = GTK.gtk_tree_path_get_indices(lArray[0]);
        if (l != 0L) {
            int[] nArray = new int[]{-1};
            C.memmove(nArray, l, 4L);
            tableItem = this._getItem(nArray[0]);
        }
        GTK.gtk_tree_path_free(lArray[0]);
        return tableItem;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getGridLineWidthInPixels());
    }

    int getGridLineWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.headerBackground != null ? this.headerBackground : this.display.getSystemColor(25);
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.headerForeground != null ? this.headerForeground : this.display.getSystemColor(24);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        int n = 0;
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            for (int i = 0; i < this.columnCount; ++i) {
                long l = this.columns[i].buttonHandle;
                if (l == 0L) continue;
                if (!GTK.gtk_widget_get_visible(l)) {
                    GTK.gtk_widget_show(l);
                    this.gtk_widget_get_preferred_size(l, gtkRequisition);
                    GTK.gtk_widget_hide(l);
                } else {
                    this.gtk_widget_get_preferred_size(l, gtkRequisition);
                }
                n = Math.max(n, gtkRequisition.height);
            }
        } else if (GTK.GTK4) {
            int[] nArray = new int[1];
            GTK.gtk_tree_view_convert_bin_window_to_widget_coords(this.handle, 0, 0, null, nArray);
            n = nArray[0];
        } else {
            GTK.gtk_widget_realize(this.handle);
            long l = this.gtk_widget_get_window(this.fixedHandle);
            long l2 = GTK3.gtk_tree_view_get_bin_window(this.handle);
            int[] nArray = new int[1];
            GDK.gdk_window_get_origin(l2, null, nArray);
            int[] nArray2 = new int[1];
            GDK.gdk_window_get_origin(l, null, nArray2);
            n = nArray[0] - nArray2[0];
        }
        return n;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return GTK.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    TableItem getItemInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] lArray = new long[1];
        GTK.gtk_widget_realize(this.handle);
        int n = point.y;
        if (this.getHeaderVisible() && GTK.GTK4) {
            n -= this.getHeaderHeight();
        }
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, point.x, n, lArray, null, null, null)) {
            return null;
        }
        if (lArray[0] == 0L) {
            return null;
        }
        long l = GTK.gtk_tree_path_get_indices(lArray[0]);
        TableItem tableItem = null;
        if (l != 0L) {
            int[] nArray = new int[1];
            C.memmove(nArray, l, 4L);
            tableItem = this._getItem(nArray[0]);
        }
        GTK.gtk_tree_path_free(lArray[0]);
        return tableItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        int n = 0;
        if (this.itemCount == 0) {
            long l = GTK.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            this.ignoreSize = true;
            if (GTK.GTK4) {
                GTK4.gtk_tree_view_column_cell_get_size(l, null, null, null, nArray);
            } else {
                GTK3.gtk_tree_view_column_cell_get_size(l, null, null, null, null, nArray);
            }
            n = nArray[0];
            long l2 = this.getTextRenderer(l);
            if (l2 != 0L) {
                GTK.gtk_cell_renderer_get_preferred_height_for_width(l2, this.handle, 0, nArray, null);
            }
            n += nArray[0];
            this.ignoreSize = false;
        } else {
            long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_get_iter_first(this.modelHandle, l);
            int n2 = Math.max(1, this.columnCount);
            for (int i = 0; i < n2; ++i) {
                long l3 = GTK.gtk_tree_view_get_column(this.handle, i);
                GTK.gtk_tree_view_column_cell_set_cell_data(l3, this.modelHandle, l, false, false);
                int[] nArray = new int[1];
                if (GTK.GTK4) {
                    GTK4.gtk_tree_view_column_cell_get_size(l3, null, null, null, nArray);
                } else {
                    GTK3.gtk_tree_view_column_cell_get_size(l3, null, null, null, null, nArray);
                }
                long l4 = this.getTextRenderer(l3);
                int[] nArray2 = new int[1];
                if (l4 != 0L) {
                    GTK.gtk_cell_renderer_get_padding(l4, null, nArray2);
                }
                n = Math.max(n, nArray[0] + nArray2[0]);
            }
            OS.g_free(l);
        }
        return n;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            for (int i = 0; i < this.itemCount; ++i) {
                tableItemArray[i] = this._getItem(i);
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return GTK.gtk_tree_view_get_grid_lines(this.handle) > 0;
    }

    long getPixbufRenderer(long l) {
        long l2 = GTK.gtk_cell_layout_get_cells(l);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = l2;
        long l4 = 0L;
        while (l2 != 0L) {
            long l5 = OS.g_list_data(l2);
            if (GTK.GTK_IS_CELL_RENDERER_PIXBUF(l5)) {
                l4 = l5;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l3);
        return l4;
    }

    public TableItem[] getSelection() {
        long l;
        this.checkWidget();
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        long l3 = l = GTK.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int n = OS.g_list_length(l);
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = OS.g_list_data(l);
                long l5 = GTK.gtk_tree_path_get_indices(l4);
                if (l5 != 0L) {
                    int[] nArray2 = new int[1];
                    C.memmove(nArray2, l5, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                GTK.gtk_tree_path_free(l4);
                l = OS.g_list_next(l);
            }
            OS.g_list_free(l3);
            TableItem[] tableItemArray = new TableItem[n2];
            for (int i = 0; i < tableItemArray.length; ++i) {
                tableItemArray[i] = this._getItem(nArray[i]);
            }
            return tableItemArray;
        }
        return new TableItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        return GTK.gtk_tree_selection_count_selected_rows(l);
    }

    public int getSelectionIndex() {
        long l;
        this.checkWidget();
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        long l3 = l = GTK.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int[] nArray = new int[1];
            boolean bl = false;
            while (l != 0L) {
                long l4;
                long l5 = OS.g_list_data(l);
                if (!bl && (l4 = GTK.gtk_tree_path_get_indices(l5)) != 0L) {
                    C.memmove(nArray, l4, 4L);
                    bl = true;
                }
                l = OS.g_list_next(l);
                GTK.gtk_tree_path_free(l5);
            }
            OS.g_list_free(l3);
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        long l;
        this.checkWidget();
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        long l3 = l = GTK.gtk_tree_selection_get_selected_rows(l2, null);
        if (l != 0L) {
            int n = OS.g_list_length(l);
            int[] nArray = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                long l4 = OS.g_list_data(l);
                long l5 = GTK.gtk_tree_path_get_indices(l4);
                if (l5 != 0L) {
                    int[] nArray2 = new int[1];
                    C.memmove(nArray2, l5, 4L);
                    nArray[n2] = nArray2[0];
                    ++n2;
                }
                l = OS.g_list_next(l);
                GTK.gtk_tree_path_free(l4);
            }
            OS.g_list_free(l3);
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            return nArray3;
        }
        return new int[0];
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long l) {
        long l2 = GTK.gtk_cell_layout_get_cells(l);
        if (l2 == 0L) {
            return 0L;
        }
        long l3 = l2;
        long l4 = 0L;
        while (l2 != 0L) {
            long l5 = OS.g_list_data(l2);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(l5)) {
                l4 = l5;
                break;
            }
            l2 = OS.g_list_next(l2);
        }
        OS.g_list_free(l3);
        return l4;
    }

    public int getTopIndex() {
        this.checkWidget();
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(l);
        if (this.cachedAdjustment == this.currentAdjustment) {
            return this.topIndex;
        }
        long[] lArray = new long[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, lArray, null, null, null)) {
            return 0;
        }
        if (lArray[0] == 0L) {
            return 0;
        }
        long l2 = GTK.gtk_tree_path_get_indices(lArray[0]);
        int[] nArray = new int[1];
        if (l2 != 0L) {
            C.memmove(nArray, l2, 4L);
        }
        GTK.gtk_tree_path_free(lArray[0]);
        return nArray[0];
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        long[] lArray;
        int n;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        GDK.gdk_event_get_coords(l2, dArray, dArray2);
        int n2 = GDK.gdk_event_get_event_type(l2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GDK.gdk_event_get_button(l2, nArray);
        GDK.gdk_event_get_state(l2, nArray2);
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        long l3 = this.gdk_event_get_surface_or_window(l2);
        if (l3 != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long l4 = super.gtk_button_press_event(l, l2);
        if (l4 != 0L) {
            return l4;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland() && n2 == 4) {
            long l5 = GDK.gdk_event_peek();
            if (l5 == 0L) {
                long[] lArray2 = new long[1];
                long l6 = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray2, null, null, null) && lArray2[0] != 0L) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (GTK.gtk_tree_selection_path_is_selected(l6, lArray2[0]) && ((nArray2[0] & 5) == 0 || (nArray2[0] & 4) != 0)) {
                        long l7 = GTK.GET_FUNCTION_POINTER_gtk_false();
                        GTK.gtk_tree_selection_set_select_function(l6, l7, 0L, 0L);
                    }
                }
            } else {
                this.gdk_event_free(l5);
            }
        }
        if ((n = nArray[0]) == 3 && n2 == 4 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            long l8 = GTK.gtk_tree_view_get_selection(this.handle);
            if (GTK.gtk_tree_selection_path_is_selected(l8, lArray[0])) {
                l4 = 1L;
            }
            GTK.gtk_tree_path_free(lArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray = new long[1], null, null, null) && lArray[0] != 0L) {
            long l9 = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l9, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(l9, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_path_free(lArray[0]);
        }
        if (n2 == 5 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
        return l4;
    }

    @Override
    void gtk_gesture_press_event(long l, int n, double d, double d2, long l2) {
        if (n == 1) {
            return;
        }
        super.gtk_gesture_press_event(l, n, d, d2, l2);
        if (n == 2 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
    }

    @Override
    long gtk_row_activated(long l, long l2, long l3) {
        this.rowActivated = true;
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l2);
        } else {
            GDK.gdk_event_get_keyval(l2, nArray);
        }
        switch (nArray[0]) {
            case 65293: {
                int n = this.gdk_event_get_state(l2);
                if ((n & 0x1C000008) != 0) break;
                this.sendTreeDefaultSelection();
                break;
            }
            case 32: {
                if ((this.style & 0x20) == 0) break;
                TableItem[] tableItemArray = this.getSelection();
                for (int i = 0; i < tableItemArray.length; ++i) {
                    this.toggleItemAndSendEvent(tableItemArray[i]);
                }
                return 1L;
            }
        }
        return super.gtk_key_press_event(l, l2);
    }

    private void toggleItemAndSendEvent(TableItem tableItem) {
        tableItem.setChecked(!tableItem.getChecked());
        Event event = new Event();
        event.detail = 32;
        event.item = tableItem;
        this.sendSelectionEvent(13, event, false);
    }

    void sendTreeDefaultSelection() {
        TableItem tableItem = this.getFocusItem();
        if (tableItem == null) {
            return;
        }
        Event event = new Event();
        event.item = tableItem;
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    long gtk_button_release_event(long l, long l2) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(l2, dArray, dArray2);
        } else {
            GDK.gdk_event_get_coords(l2, dArray, dArray2);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_button_event_get_button(l2);
            nArray2[0] = GDK.gdk_event_get_modifier_state(l2);
        } else {
            GDK.gdk_event_get_button(l2, nArray);
            GDK.gdk_event_get_state(l2, nArray2);
        }
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        GDK.gdk_event_get_root_coords(l2, dArray3, dArray4);
        long l3 = this.gdk_event_get_surface_or_window(l2);
        if (GTK.GTK4 ? l3 != this.gtk_widget_get_surface(this.handle) : l3 != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        this.lastInput.x = (int)dArray[0];
        this.lastInput.y = (int)dArray2[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland()) {
            long[] lArray = new long[1];
            long l4 = GTK.gtk_tree_view_get_selection(this.handle);
            GTK.gtk_tree_selection_set_select_function(l4, 0L, 0L, 0L);
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)dArray[0], (int)dArray2[0], lArray, null, null, null) && lArray[0] != 0L && GTK.gtk_tree_selection_path_is_selected(l4, lArray[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((nArray2[0] & 5) == 0) {
                    GTK.gtk_tree_view_set_cursor(this.handle, lArray[0], 0L, false);
                }
                if ((nArray2[0] & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    GTK.gtk_tree_selection_unselect_path(l4, lArray[0]);
                }
            }
        }
        return super.gtk_button_release_event(l, l2);
    }

    @Override
    long gtk_changed(long l) {
        TableItem tableItem = this.getFocusItem();
        if (tableItem != null) {
            Event event = new Event();
            event.item = tableItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    void drawInheritedBackground(long l) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            long l2;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            if (GTK.GTK4) {
                l2 = this.gtk_widget_get_surface(this.handle);
                this.gdk_surface_get_size(l2, nArray, nArray2);
            } else {
                l2 = GTK3.gtk_tree_view_get_bin_window(this.handle);
                this.gdk_window_get_size(l2, nArray, nArray2);
            }
            int n = 0;
            if (this.itemCount != 0) {
                long l3 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l3, 0L, this.itemCount - 1);
                long l4 = GTK.gtk_tree_model_get_path(this.modelHandle, l3);
                GdkRectangle gdkRectangle = new GdkRectangle();
                GTK.gtk_tree_view_get_cell_area(this.handle, l4, 0L, gdkRectangle);
                n = gdkRectangle.y + gdkRectangle.height;
                GTK.gtk_tree_path_free(l4);
                OS.g_free(l3);
            }
            if (nArray2[0] > n) {
                this.drawBackground(control, l2, l, 0, n, nArray[0], nArray2[0] - n);
            }
        }
    }

    @Override
    long gtk_draw(long l, long l2) {
        boolean bl = this.boundsChangedSinceLastDraw;
        this.boundsChangedSinceLastDraw = false;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (this.ownerDraw && bl) {
            GTK.gtk_widget_queue_draw(this.handle);
            return 0L;
        }
        this.drawInheritedBackground(l2);
        return super.gtk_draw(l, l2);
    }

    @Override
    long gtk_motion_notify_event(long l, long l2) {
        long l3;
        long l4;
        if (GTK.GTK4 ? (l4 = GDK.gdk_event_get_surface(l2)) != this.gtk_widget_get_surface(this.handle) : (l3 = GDK.GDK_EVENT_WINDOW(l2)) != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(l, l2);
    }

    @Override
    long gtk_scroll_event(long l, long l2) {
        long l3 = super.gtk_scroll_event(l, l2);
        if (!this.wasScrolled) {
            this.wasScrolled = true;
        }
        return l3;
    }

    @Override
    long gtk_start_interactive_search(long l) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(l, OS.start_interactive_search);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_toggled(long l, long l2) {
        long l3 = GTK.gtk_tree_path_new_from_string(l2);
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = GTK.gtk_tree_path_get_indices(l3);
        if (l4 != 0L) {
            int[] nArray = new int[1];
            C.memmove(nArray, l4, 4L);
            TableItem tableItem = this._getItem(nArray[0]);
            this.toggleItemAndSendEvent(tableItem);
        }
        GTK.gtk_tree_path_free(l3);
        return 0L;
    }

    @Override
    void gtk_widget_get_preferred_size(long l, GtkRequisition gtkRequisition) {
        long l2;
        boolean bl;
        long l3;
        if (this.columnCount == 0) {
            super.gtk_widget_get_preferred_size(l, gtkRequisition);
            return;
        }
        long l4 = l3 = GTK.gtk_tree_view_get_columns(this.handle);
        boolean bl2 = bl = l3 != 0L;
        while (l4 != 0L) {
            l2 = OS.g_list_data(l4);
            if (GTK.gtk_tree_view_column_get_visible(l2)) {
                bl = false;
                break;
            }
            l4 = OS.g_list_next(l4);
        }
        l2 = 0L;
        if (bl) {
            l2 = OS.g_list_data(l3);
            GTK.gtk_tree_view_column_set_visible(l2, true);
        }
        super.gtk_widget_get_preferred_size(l, gtkRequisition);
        if (bl) {
            GTK.gtk_tree_view_column_set_visible(l2, false);
        }
        if (l3 != 0L) {
            OS.g_list_free(l3);
        }
    }

    void hideFirstColumn() {
        long l = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(l, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(l, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != tableColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            for (int i = 0; i < this.itemCount; ++i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        } else {
            for (int i = this.itemCount - 1; i >= 0; --i) {
                if (this.items[i] != tableItem) continue;
                this.lastIndexOf = i;
                return this.lastIndexOf;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(Integer.toString(n), true);
        long l2 = GTK.gtk_tree_path_new_from_string(byArray);
        boolean bl = GTK.gtk_tree_selection_path_is_selected(l, l2);
        GTK.gtk_tree_path_free(l2);
        return bl;
    }

    @Override
    boolean mnemonicHit(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            long l = this.columns[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        for (int i = 0; i < this.columnCount; ++i) {
            long l = this.columns[i].labelHandle;
            if (l == 0L || !this.mnemonicMatch(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    long paintWindow() {
        GTK.gtk_widget_realize(this.handle);
        return GTK3.gtk_tree_view_get_bin_window(this.handle);
    }

    @Override
    void propagateDraw(long l, long l2) {
        super.propagateDraw(l, l2);
        if (this.headerVisible && this.noChildDrawing && this.wasScrolled) {
            for (TableColumn tableColumn : this.columns) {
                if (tableColumn == null) continue;
                GTK.gtk_widget_queue_draw(tableColumn.buttonHandle);
            }
            this.wasScrolled = false;
        }
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(GTK.gtk_tree_view_get_column(this.handle, 0), 5, true, 0);
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                TableColumn tableColumn = this.columns[i];
                this.createRenderers(tableColumn.handle, tableColumn.modelIndex, i == 0, tableColumn.style);
            }
        }
    }

    @Override
    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(GTK.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    @Override
    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            for (n = 0; n < this.itemCount; ++n) {
                item = this.items[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(15);
        }
        long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        TableItem tableItem = this.items[n];
        boolean bl = false;
        if (tableItem != null) {
            bl = tableItem.isDisposed();
            if (!bl) {
                C.memmove(l, tableItem.handle, (long)GTK.GtkTreeIter_sizeof());
                tableItem.release(false);
            }
        } else {
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l, 0L, n);
        }
        if (!bl) {
            long l2 = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_list_store_remove(this.modelHandle, l);
            OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
            System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
            this.items[this.itemCount] = null;
        }
        OS.g_free(l);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.removeAll();
            return;
        }
        this.checkSetDataInProcessBeforeRemoval(n, n2 + 1);
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (l2 == 0L) {
            this.error(2);
        }
        int n3 = -1;
        for (n3 = n; n3 <= n2; ++n3) {
            TableItem tableItem;
            if (n3 == n) {
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l2, 0L, n3);
            }
            if ((tableItem = this.items[n3]) != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_list_store_remove(this.modelHandle, l2);
            OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        }
        OS.g_free(l2);
        n3 = n2 + 1;
        System.arraycopy(this.items, n3, this.items, n, this.itemCount - n3);
        for (int i = this.itemCount - (n3 - n); i < this.itemCount; ++i) {
            this.items[i] = null;
        }
        this.itemCount -= n3 - n;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (0 > n || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        int n3 = -1;
        long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (l2 == 0L) {
            this.error(2);
        }
        for (int i = 0; i < nArray2.length; ++i) {
            int n4 = nArray2[i];
            if (n4 == n3) continue;
            TableItem tableItem = this.items[n4];
            boolean bl = false;
            if (tableItem != null) {
                bl = tableItem.isDisposed();
                if (!bl) {
                    C.memmove(l2, tableItem.handle, (long)GTK.GtkTreeIter_sizeof());
                    tableItem.release(false);
                }
            } else {
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, l2, 0L, n4);
            }
            if (!bl) {
                OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
                GTK.gtk_list_store_remove(this.modelHandle, l2);
                OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
                System.arraycopy(this.items, n4 + 1, this.items, n4, --this.itemCount - n4);
                this.items[this.itemCount] = null;
            }
            n3 = n4;
        }
        OS.g_free(l2);
    }

    public void removeAll() {
        boolean bl;
        this.checkWidget();
        this.checkSetDataInProcessBeforeRemoval(0, this.items.length);
        for (int i = this.itemCount - 1; i >= 0; --i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null || tableItem.isDisposed()) continue;
            tableItem.release(false);
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        boolean bl2 = bl = (this.style & 2) != 0;
        if (bl) {
            GTK.gtk_tree_selection_set_mode(l2, 2);
        }
        GTK.gtk_list_store_clear(this.modelHandle);
        if (bl) {
            GTK.gtk_tree_selection_set_mode(l2, 3);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        this.resetCustomDraw();
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int n = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, n + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void sendMeasureEvent(long l, long l2, long l3) {
        if (!this.ignoreSize && GTK.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(41)) {
            int n;
            int[] nArray;
            long l4 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
            TableItem tableItem = null;
            boolean bl = false;
            if (l4 != 0L) {
                long l5 = GTK.gtk_tree_model_get_path(this.modelHandle, l4);
                nArray = new int[1];
                C.memmove(nArray, GTK.gtk_tree_path_get_indices(l5), 4L);
                n = nArray[0];
                tableItem = this._getItem(n);
                long l6 = GTK.gtk_tree_view_get_selection(this.handle);
                bl = GTK.gtk_tree_selection_path_is_selected(l6, l5);
                GTK.gtk_tree_path_free(l5);
            }
            if (tableItem != null) {
                Object object;
                int n2 = 0;
                if (this.columnCount > 0) {
                    long l7 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
                    for (n = 0; n < this.columnCount; ++n) {
                        if (this.columns[n].handle != l7) continue;
                        n2 = n;
                        break;
                    }
                }
                int[] nArray2 = new int[1];
                nArray = new int[1];
                if (l2 != 0L) {
                    C.memmove(nArray2, l2, 4L);
                }
                if (l3 != 0L) {
                    C.memmove(nArray, l3, 4L);
                }
                GTK.gtk_cell_renderer_get_preferred_height_for_width(l, this.handle, nArray2[0], nArray, null);
                Image image = tableItem.getImage(n2);
                int n3 = 0;
                if (image != null) {
                    object = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
                    n3 = ((Rectangle)object).width;
                }
                nArray2[0] = nArray2[0] + n3;
                object = new GC(this);
                ((GC)object).setFont(tableItem.getFont(n2));
                Event event = new Event();
                event.item = tableItem;
                event.index = n2;
                event.gc = object;
                Rectangle rectangle = new Rectangle(0, 0, nArray2[0], nArray[0]);
                event.setBounds(DPIUtil.autoScaleDown(rectangle));
                if (bl) {
                    event.detail = 2;
                }
                this.sendEvent(41, event);
                ((Resource)object).dispose();
                Rectangle rectangle2 = DPIUtil.autoScaleUp(event.getBounds());
                nArray2[0] = rectangle2.width - n3;
                if (nArray[0] < rectangle2.height) {
                    nArray[0] = rectangle2.height;
                }
                if (l2 != 0L) {
                    C.memmove(l2, nArray2, 4L);
                }
                if (l3 != 0L) {
                    C.memmove(l3, nArray, 4L);
                }
                GTK.gtk_cell_renderer_set_fixed_size(l, -1, nArray[0]);
            }
        }
    }

    @Override
    long rendererGetPreferredWidthProc(long l, long l2, long l3, long l4) {
        long l5 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, l5);
        OS.call(gtkCellRendererClass.get_preferred_width, l, l2, l3, l4);
        this.sendMeasureEvent(l, l3, 0L);
        return 0L;
    }

    @Override
    long rendererSnapshotProc(long l, long l2, long l3, long l4, long l5, long l6) {
        long l7 = Graphene.graphene_rect_alloc();
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.memmove(gdkRectangle, l4, (long)GdkRectangle.sizeof);
        Graphene.graphene_rect_init(l7, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
        long l8 = GTK4.gtk_snapshot_append_cairo(l2, l7);
        this.rendererRender(l, l8, l2, l3, l4, l5, 0L, l6);
        return 0L;
    }

    @Override
    long rendererRenderProc(long l, long l2, long l3, long l4, long l5, long l6) {
        this.rendererRender(l, l2, 0L, l3, l4, l5, 0L, l6);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rendererRender(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        Object object;
        Object object2;
        Object object3;
        int n;
        long l9;
        TableItem tableItem = null;
        boolean bl = false;
        long l10 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX2);
        if (l10 != 0L) {
            l9 = GTK.gtk_tree_model_get_path(this.modelHandle, l10);
            int[] nArray = new int[1];
            C.memmove(nArray, GTK.gtk_tree_path_get_indices(l9), 4L);
            n = nArray[0];
            tableItem = this._getItem(n);
            GTK.gtk_tree_path_free(l9);
        }
        l9 = OS.g_object_get_qdata(l, Display.SWT_OBJECT_INDEX1);
        int n2 = 0;
        if (this.columnCount > 0) {
            for (n = 0; n < this.columnCount; ++n) {
                if (this.columns[n].handle != l9) continue;
                n2 = n;
                break;
            }
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.memmove(gdkRectangle, l5, (long)GdkRectangle.sizeof);
        long l11 = GTK.gtk_tree_model_get_path(this.modelHandle, l10);
        GTK.gtk_tree_view_get_background_area(this.handle, l11, l9, gdkRectangle2);
        GTK.gtk_tree_path_free(l11);
        int n3 = gdkRectangle2.y - gdkRectangle.y;
        gdkRectangle2.y -= n3;
        if (tableItem != null && (GTK.GTK_IS_CELL_RENDERER_TOGGLE(l) || n2 != 0 || (this.style & 0x20) == 0)) {
            long l12;
            Control control;
            this.drawFlags = (int)l8;
            this.drawState = 16;
            long[] lArray = new long[1];
            GTK.gtk_tree_model_get(this.modelHandle, tableItem.handle, 3, lArray, -1);
            if (lArray[0] == 0L) {
                int n4 = this.columnCount == 0 ? 5 : this.columns[n2].modelIndex;
                GTK.gtk_tree_model_get(this.modelHandle, tableItem.handle, n4 + 3, lArray, -1);
            }
            if (lArray[0] != 0L) {
                this.drawState |= 8;
                GDK.gdk_rgba_free(lArray[0]);
            }
            if ((l8 & 1L) != 0L) {
                this.drawState |= 2;
            }
            if ((l8 & 1L) == 0L && (l8 & 0x10L) != 0L) {
                this.drawState |= 4;
            }
            object3 = gdkRectangle2.toRectangle();
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                if (l2 != 0L) {
                    Cairo.cairo_save(l2);
                }
                this.drawBackground(control, 0L, l2, object3.x, object3.y, object3.width, object3.height);
                if (l2 != 0L) {
                    Cairo.cairo_restore(l2);
                }
            }
            if ((l12 = this.getTextRenderer(l9)) != 0L) {
                this.gtk_cell_renderer_get_preferred_size(l12, this.handle, null, null);
            }
            if (this.hooks(40)) {
                Rectangle rectangle;
                Object object4;
                Cairo.cairo_save(l2);
                boolean bl2 = bl = (this.drawState & 2) != 0;
                if (bl && (object4 = this.findBackgroundControl()) == null) {
                    object4 = this;
                }
                object4 = this.getGC(l2);
                if ((this.drawState & 2) != 0) {
                    ((GC)object4).setBackground(this.display.getSystemColor(26));
                    ((GC)object4).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object4).setBackground(tableItem.getBackground(n2));
                    ((GC)object4).setForeground(tableItem.getForeground(n2));
                }
                ((GC)object4).setFont(tableItem.getFont(n2));
                if ((this.style & 0x8000000) != 0) {
                    object3.x = this.getClientWidth() - object3.width - object3.x;
                }
                if (l2 != 0L) {
                    object2 = new GdkRectangle();
                    GDK.gdk_cairo_get_clip_rectangle(l2, (GdkRectangle)object2);
                    rectangle = DPIUtil.autoScaleDown((Rectangle)object3);
                    ((GC)object4).setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    object2 = DPIUtil.autoScaleDown((Rectangle)object3);
                    ((GC)object4).setClipping(((Rectangle)object2).x, ((Rectangle)object2).y, ((Rectangle)object2).width, ((Rectangle)object2).height);
                }
                object2 = new Event();
                try {
                    rectangle = new Rectangle(object3.x, object3.y, object3.width, object3.height);
                    rectangle.y += n3;
                    Cairo.cairo_translate(l2, 0.0, -n3);
                    ((Event)object2).item = tableItem;
                    ((Event)object2).index = n2;
                    ((Event)object2).gc = object4;
                    ((Event)object2).detail = this.drawState;
                    ((Event)object2).setBounds(DPIUtil.autoScaleDown(rectangle));
                    this.sendEvent(40, (Event)object2);
                }
                finally {
                    Cairo.cairo_translate(l2, 0.0, n3);
                }
                this.drawForegroundRGBA = null;
                this.drawState = ((Event)object2).doit ? ((Event)object2).detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    Cairo.cairo_save(l2);
                    Cairo.cairo_reset_clip(l2);
                    long l13 = GTK.gtk_widget_get_style_context(l4);
                    GTK.gtk_style_context_save(l13);
                    GTK.gtk_style_context_add_class(l13, GTK.GTK_STYLE_CLASS_CELL);
                    GTK.gtk_style_context_set_state(l13, 4L);
                    GTK.gtk_render_background(l13, l2, object3.x, object3.y, object3.width, object3.height);
                    GTK.gtk_style_context_restore(l13);
                    Cairo.cairo_restore(l2);
                } else if (bl) {
                    this.drawForegroundRGBA = ((GC)object4).getForeground().handle;
                }
                ((Resource)object4).dispose();
                Cairo.cairo_restore(l2);
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gC = this.getGC(l2);
            gC.setBackground(tableItem.getBackground(n2));
            gC.fillRectangle(DPIUtil.autoScaleDown(gdkRectangle.toRectangle()));
            gC.dispose();
        }
        if ((this.drawState & 0x10) != 0 || GTK.GTK_IS_CELL_RENDERER_TOGGLE(l)) {
            l11 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(l));
            GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
            OS.memmove(gtkCellRendererClass, l11);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(l)) {
                object = this.foreground != null ? this.foreground : this.display.getSystemColor((int)24).handle;
                OS.g_object_set(l, OS.foreground_rgba, (GdkRGBA)object, 0L);
            }
            if (GTK.GTK4) {
                OS.call(gtkCellRendererClass.snapshot, l, l3, l4, l5, l6, this.drawFlags);
            } else {
                OS.call(gtkCellRendererClass.render, l, l2, l4, l5, l6, this.drawFlags);
            }
        }
        if (tableItem != null && GTK.GTK_IS_CELL_RENDERER_TEXT(l) && this.hooks(42)) {
            Object object5;
            Object object6;
            if (bl) {
                this.drawState |= 2;
            }
            Rectangle rectangle = gdkRectangle2.toRectangle();
            this.ignoreSize = true;
            object3 = new int[1];
            int[] nArray = new int[1];
            this.gtk_cell_renderer_get_preferred_size(l, this.handle, nArray, null);
            this.gtk_tree_view_column_cell_get_position(l9, l, (int[])object3, null);
            this.ignoreSize = false;
            object = tableItem.getImage(n2);
            int n5 = 0;
            if (object != null) {
                object2 = DPIUtil.useCairoAutoScale() ? ((Image)object).getBounds() : ((Image)object).getBoundsInPixels();
                n5 = ((Rectangle)object2).width;
            }
            object3[0] = object3[0] - n5;
            nArray[0] = nArray[0] + n5;
            object2 = this.getGC(l2);
            if ((this.drawState & 2) != 0) {
                if (GTK.gtk_widget_has_focus(this.handle)) {
                    object6 = this.display.getSystemColor(26);
                    object5 = this.display.getSystemColor(27);
                } else {
                    object6 = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_INACTIVE_RGBA);
                    object5 = Color.gtk_new(this.display, this.display.COLOR_LIST_SELECTION_TEXT_INACTIVE_RGBA);
                }
                ((GC)object2).setBackground((Color)object6);
                ((GC)object2).setForeground((Color)object5);
            } else {
                ((GC)object2).setBackground(tableItem.getBackground(n2));
                object6 = this.drawForegroundRGBA != null ? Color.gtk_new(this.display, this.drawForegroundRGBA) : tableItem.getForeground(n2);
                ((GC)object2).setForeground((Color)object6);
            }
            ((GC)object2).setFont(tableItem.getFont(n2));
            if ((this.style & 0x8000000) != 0) {
                rectangle.x = this.getClientWidth() - rectangle.width - rectangle.x;
            }
            object6 = DPIUtil.autoScaleDown(rectangle);
            ((GC)object2).setClipping(((Rectangle)object6).x, ((Rectangle)object6).y, ((Rectangle)object6).width, ((Rectangle)object6).height);
            object5 = new Event();
            try {
                Rectangle rectangle2 = new Rectangle(rectangle.x + object3[0], rectangle.y, nArray[0], rectangle.height);
                rectangle2.y += n3;
                Cairo.cairo_translate(l2, 0.0, -n3);
                ((Event)object5).item = tableItem;
                ((Event)object5).index = n2;
                ((Event)object5).gc = object2;
                ((Event)object5).detail = this.drawState;
                ((Event)object5).setBounds(DPIUtil.autoScaleDown(rectangle2));
                this.sendEvent(42, (Event)object5);
            }
            finally {
                Cairo.cairo_translate(l2, 0.0, n3);
            }
            ((Resource)object2).dispose();
        }
    }

    private GC getGC(long l) {
        GCData gCData = new GCData();
        gCData.cairo = l;
        GC gC = GC.gtk_new(this, gCData);
        return gC;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (!bl) continue;
            long l = GTK.gtk_tree_view_get_column(this.handle, i);
            long l2 = this.getTextRenderer(l);
            GTK.gtk_tree_view_column_set_cell_data_func(l, l2, 0L, 0L, 0L);
            if (this.columnCount == 0) continue;
            this.columns[i].customDraw = false;
        }
        this.firstCustomDraw = false;
    }

    @Override
    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.itemCount; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskin(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                item = this.columns[n2];
                if (item.isDisposed()) continue;
                item.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void select(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        TableItem tableItem = this._getItem(n);
        GTK.gtk_tree_selection_select_iter(l, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = n; i <= n2; ++i) {
            TableItem tableItem = this._getItem(i);
            GTK.gtk_tree_selection_select_iter(l, tableItem.handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            if (0 > n2 || n2 >= this.itemCount) continue;
            TableItem tableItem = this._getItem(n2);
            GTK.gtk_tree_selection_select_iter(l, tableItem.handle);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        long l = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_select_all(l);
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 6L);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void selectFocusIndex(int n) {
        if (0 > n || n >= this.itemCount) {
            return;
        }
        TableItem tableItem = this._getItem(n);
        long l = GTK.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
        long l2 = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_view_set_cursor(this.handle, l, 0L, false);
        OS.g_signal_handlers_unblock_matched(l2, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_path_free(l);
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        this.background = gdkRGBA == null ? this.defaultBackground() : gdkRGBA;
        GdkRGBA gdkRGBA2 = this.display.getSystemColor((int)26).handle;
        String string = "treeview {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\ntreeview:selected {background-color: " + this.display.gtk_rgba_to_css_string(gdkRGBA2) + ";}";
        this.cssBackground = string;
        String string2 = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(l, string2);
    }

    @Override
    void setBackgroundSurface(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (n5 != 0) {
            this.boundsChangedSinceLastDraw = true;
        }
        GTK.gtk_widget_realize(this.handle);
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
        }
        for (n = 0; n < nArray.length; ++n) {
            long l = this.columns[nArray[n]].handle;
            long l2 = n == 0 ? 0L : this.columns[nArray[n - 1]].handle;
            GTK.gtk_tree_view_move_column_after(this.handle, l, l2);
        }
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        TableColumn[] tableColumnArray = this.getColumns();
        for (int i = 0; i < tableColumnArray.length; ++i) {
            if (tableColumnArray[i] == null) continue;
            tableColumnArray[i].setFontDescription(l);
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA gdkRGBA) {
        this.foreground = gdkRGBA;
        GdkRGBA gdkRGBA2 = gdkRGBA == null ? this.display.COLOR_LIST_FOREGROUND_RGBA : gdkRGBA;
        this.setForegroundGdkRGBA(this.handle, gdkRGBA2);
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerBackground)) {
                return;
            }
        }
        this.headerBackground = color;
        this.updateHeaderCSS();
    }

    void updateHeaderCSS() {
        StringBuilder stringBuilder = new StringBuilder("button {");
        if (this.headerBackground != null) {
            stringBuilder.append("background: " + this.display.gtk_rgba_to_css_string(this.headerBackground.handle) + "; ");
        }
        if (this.headerForeground != null) {
            stringBuilder.append("color: " + this.display.gtk_rgba_to_css_string(this.headerForeground.handle) + "; ");
        }
        stringBuilder.append("}\n");
        if (this.columnCount == 0) {
            long l = GTK.gtk_tree_view_column_get_button(GTK.gtk_tree_view_get_column(this.handle, 0));
            if (this.headerCSSProvider == 0L) {
                this.headerCSSProvider = GTK.gtk_css_provider_new();
                GTK.gtk_style_context_add_provider(GTK.gtk_widget_get_style_context(l), this.headerCSSProvider, 600);
            }
            if (GTK.GTK4) {
                GTK4.gtk_css_provider_load_from_data(this.headerCSSProvider, Converter.javaStringToCString(stringBuilder.toString()), -1L);
            } else {
                GTK3.gtk_css_provider_load_from_data(this.headerCSSProvider, Converter.javaStringToCString(stringBuilder.toString()), -1L, null);
            }
        } else {
            for (TableColumn tableColumn : this.columns) {
                if (tableColumn == null) continue;
                tableColumn.setHeaderCSS(stringBuilder.toString());
            }
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerForeground)) {
                return;
            }
        }
        this.headerForeground = color;
        this.updateHeaderCSS();
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        GTK.gtk_tree_view_set_headers_visible(this.handle, bl);
        this.headerHeight = this.getHeaderHeight();
        this.headerVisible = bl;
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(n, this.itemCount - 1);
        int n2 = Math.max(4, (n + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n2];
        System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        this.items = tableItemArray;
        if (bl) {
            long l = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (l == 0L) {
                this.error(2);
            }
            for (int i = this.itemCount; i < n; ++i) {
                GTK.gtk_list_store_append(this.modelHandle, l);
            }
            OS.g_free(l);
            this.itemCount = n;
        } else {
            for (int i = this.itemCount; i < n; ++i) {
                new TableItem(this, 0, i, true);
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        GTK.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
    }

    void setModel(long l) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = l;
        this.display.addWidget(this.modelHandle, this);
    }

    @Override
    void setOrientation(boolean bl) {
        int n;
        super.setOrientation(bl);
        for (n = 0; n < this.itemCount; ++n) {
            if (this.items[n] == null) continue;
            this.items[n].setOrientation(bl);
        }
        for (n = 0; n < this.columnCount; ++n) {
            if (this.columns[n] == null) continue;
            this.columns[n].setOrientation(bl);
        }
    }

    @Override
    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    void setParentGdkResource(Control control) {
        if (!GTK.GTK4) {
            long l = this.eventWindow();
            GTK3.gtk_widget_set_parent_window(control.topHandle(), l);
            this.hasChildren = true;
            this.connectFixedHandleDraw();
        }
    }

    @Override
    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] tableItemArray = new TableItem[n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
            this.items = tableItemArray;
        }
    }

    void setScrollWidth(long l, TableItem tableItem) {
        int n;
        if (this.columnCount != 0 || this.currentItem == tableItem) {
            return;
        }
        int n2 = GTK.gtk_tree_view_column_get_fixed_width(l);
        if (n2 < (n = this.calculateWidth(l, tableItem.handle))) {
            GTK.gtk_tree_view_column_set_fixed_width(l, n);
        }
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(TableItem tableItem) {
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        int n = tableItemArray.length;
        if (n != 0 && ((this.style & 4) == 0 || n <= 1)) {
            boolean bl2 = true;
            for (int i = 0; i < n; ++i) {
                int n2 = this.indexOf(tableItemArray[i]);
                if (n2 == -1) continue;
                if (bl2) {
                    bl2 = false;
                    this.selectFocusIndex(n2);
                    continue;
                }
                this.select(n2);
            }
            this.showSelection();
        }
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            return;
        }
        long l = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(l);
        this.topIndex = n;
        long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, this._getItem((int)n).handle);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, true, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(l2);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        GTK.gtk_tree_view_scroll_to_cell(this.handle, 0L, tableColumn.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int n = Math.max(1, this.columnCount);
        for (int i = 0; i < n; ++i) {
            long l = GTK.gtk_tree_view_get_column(this.handle, i);
            if (!GTK.gtk_tree_view_column_get_visible(l)) continue;
            return false;
        }
        long l = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(l, true);
        return true;
    }

    public void showItem(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if (tableItem.parent != this) {
            return;
        }
        this.showItem(tableItem.handle);
    }

    void showItem(long l) {
        long l2 = GTK.gtk_tree_model_get_path(this.modelHandle, l);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, l2, 0L, false, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(l2);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.getSelection();
        if (tableItemArray.length == 0) {
            return;
        }
        TableItem tableItem = tableItemArray[0];
        this.showItem(tableItem.handle);
    }

    @Override
    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        if (!GTK.GTK4) {
            long l = this.parentingHandle();
            long l2 = GTK3.gtk_container_get_children(l);
            if (l2 == 0L) {
                return;
            }
            long l3 = l2;
            while (l3 != 0L) {
                long l4 = OS.g_list_data(l3);
                if (l4 != 0L) {
                    GTK.gtk_widget_queue_resize(l4);
                }
                l3 = OS.g_list_next(l3);
            }
            OS.g_list_free(l2);
        }
    }

    @Override
    long windowProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 18: {
                if (!this.hasChildren) break;
                if (this.headerVisible) {
                    this.noChildDrawing = true;
                }
                this.propagateDraw(l, l2);
                break;
            }
            case 19: {
                long l4;
                Control control;
                if (this.itemCount != 0 || (this.state & 0x40) != 0 || GTK.GTK4 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null || (l4 = GTK3.gtk_tree_view_get_bin_window(l)) != GTK3.gtk_widget_get_window(l)) break;
                GdkRectangle gdkRectangle = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(l2, gdkRectangle);
                this.drawBackground(control, l4, l2, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            }
        }
        return super.windowProc(l, l2, l3);
    }

    @Override
    Point resizeCalculationsGTK3(long l, int n, int n2) {
        int n3;
        Point point = super.resizeCalculationsGTK3(l, n, n2);
        if (l == this.scrolledHandle && this.getHeaderVisible() && (n3 = this.hScrollBarWidth()) > 0) {
            point.y = Math.max(point.y, this.getHeaderHeight() + n3 + this.getBorderWidth() * 2);
        }
        return point;
    }

    void checkSetDataInProcessBeforeRemoval(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            TableItem tableItem = this.items[i];
            if (tableItem == null || !tableItem.settingData) continue;
            String string = "Cannot remove a table item while its data is being set. At item " + i + " in range [" + n + ", " + n2 + ").";
            throw new SWTException(string);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.headerCSSProvider != 0L) {
            OS.g_object_unref(this.headerCSSProvider);
            this.headerCSSProvider = 0L;
        }
    }
}

