/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    long labelHandle;
    long imageHandle;
    long pageHandle;
    long cssProvider;
    Control control;
    TabFolder parent;
    String toolTipText;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        this.parent = tabFolder;
        this.createWidget(tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        this.parent = tabFolder;
        this.createWidget(n2);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int n) {
        this.parent.createItem(this, n);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        int n;
        this.checkWidget();
        GtkAllocation gtkAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(this.handle, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = (this.state & 0x200) != 0 ? 0 : gtkAllocation.width;
        int n5 = n = (this.state & 0x400) != 0 ? 0 : gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        return new Rectangle(n2, n3, n4, n);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_enter_notify_event(long l, long l2) {
        this.parent.gtk_enter_notify_event(l, l2);
        return 0L;
    }

    @Override
    long gtk_mnemonic_activate(long l, long l2) {
        return this.parent.gtk_mnemonic_activate(l, l2);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
        if (GTK.GTK4) {
            long l = GTK4.gtk_event_controller_motion_new();
            GTK4.gtk_widget_add_controller(this.handle, l);
            GTK.gtk_event_controller_set_propagation_phase(l, 3);
            long l2 = this.display.enterMotionCallback.getAddress();
            OS.g_signal_connect(l, OS.enter, l2, 95L);
        } else {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        }
    }

    @Override
    void register() {
        super.register();
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    @Override
    void release(boolean bl) {
        if (this.control != null && !this.control.isDisposed()) {
            Control.gtk_widget_reparent(this.control, this.parent.parentingHandle());
        }
        super.release(bl);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.pageHandle = 0L;
        this.cssProvider = 0L;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        int n = this.parent.indexOf(this);
        if (n == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (GTK.GTK4) {
            long l;
            long l2;
            this.control = control;
            if (control != null && (l2 = GTK.gtk_widget_get_parent(l = control.topHandle())) != 0L) {
                OS.g_object_ref(l);
                OS.swt_fixed_remove(l2, l);
                OS.swt_fixed_add(this.pageHandle, l);
                OS.g_object_unref(l);
            }
        } else {
            int n;
            if (control != null) {
                Control.gtk_widget_reparent(control, this.pageHandle);
            }
            Control control2 = this.control;
            Control control3 = control;
            this.control = control;
            int n2 = this.parent.indexOf(this);
            if (n2 != (n = this.parent.getSelectionIndex()) && control3 != null) {
                Control control4;
                if (n != -1 && (control4 = this.parent.getItem(n).getControl()) == control3) {
                    return;
                }
                control3.setVisible(false);
                return;
            }
            if (control3 != null) {
                control3.setBoundsInPixels(this.parent.getClientAreaInPixels());
                control3.setVisible(true);
            }
            if (control2 != null && control2 != control3) {
                Control.gtk_widget_reparent(control2, this.parent.parentingHandle());
                if (control3 != null) {
                    control2.setVisible(false);
                }
            }
        }
    }

    void setFontDescription(long l) {
        this.setFontDescription(this.labelHandle, l);
    }

    void setForegroundRGBA(GdkRGBA gdkRGBA) {
        this.setForegroundGdkRGBA(this.labelHandle, gdkRGBA);
        this.setForegroundGdkRGBA(this.imageHandle, gdkRGBA);
    }

    void setForegroundGdkRGBA(long l, GdkRGBA gdkRGBA) {
        GdkRGBA gdkRGBA2 = new GdkRGBA();
        gdkRGBA2 = gdkRGBA != null ? gdkRGBA : this.display.COLOR_WIDGET_FOREGROUND_RGBA;
        long l2 = GTK.gtk_widget_get_style_context(l);
        String string = this.display.gtk_rgba_to_css_string(gdkRGBA2);
        String string2 = "* {color: " + string + ";}";
        this.parent.cssForeground = string2;
        this.gtk_css_provider_load_from_css(l2, string2);
    }

    void gtk_css_provider_load_from_css(long l, String string) {
        if (this.cssProvider == 0L) {
            this.cssProvider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(l, this.cssProvider, 600);
            OS.g_object_unref(this.cssProvider);
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.cssProvider, Converter.javaStringToCString(string), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.cssProvider, Converter.javaStringToCString(string), -1L, null);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            if (GTK.GTK4) {
                long l = ImageList.createPixbuf(image);
                long l2 = GDK.gdk_texture_new_for_pixbuf(l);
                OS.g_object_unref(l);
                GTK4.gtk_image_set_from_paintable(this.imageHandle, l2);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, image.surface);
            }
            GTK.gtk_widget_show(this.imageHandle);
        } else {
            if (GTK.GTK4) {
                GTK4.gtk_image_clear(this.imageHandle);
            } else {
                GTK3.gtk_image_set_from_surface(this.imageHandle, 0L);
            }
            GTK.gtk_widget_hide(this.imageHandle);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, n);
            }
            if (this.labelHandle != 0L) {
                GTK.gtk_widget_set_direction(this.labelHandle, n);
            }
            if (this.imageHandle != 0L) {
                GTK.gtk_widget_set_direction(this.imageHandle, n);
            }
            if (this.pageHandle != 0L) {
                GTK.gtk_widget_set_direction(this.pageHandle, n);
            }
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(cArray, true);
        GTK.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            GTK.gtk_widget_show(this.labelHandle);
        } else {
            GTK.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.setToolTipText(this.handle, string);
    }

    @Override
    long dpiChanged(long l, long l2) {
        super.dpiChanged(l, l2);
        if (this.image != null) {
            this.image.internal_gtk_refreshImageForZoom();
            this.setImage(this.image);
        }
        return 0L;
    }
}

