/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.LinkedList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventButton;
import org.eclipse.swt.internal.gtk3.GdkEventKey;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    MenuItem selectedItem;
    Decorations parent;
    ImageList imageList;
    int poppedUpCount;
    long menuHandle;
    long modelHandle;
    long actionGroup;
    long shortcutController;
    LinkedList<Section> sections;
    LinkedList<MenuItem> items;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n) {
        super(decorations, Menu.checkStyle(n));
        this.parent = decorations;
        this.createWidget(0);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n) {
        return Menu.checkBits(n, 8, 2, 4, 0, 0, 0);
    }

    boolean ableToSetLocation() {
        if (!OS.isX11() && !this.getShell().getVisible()) {
            return false;
        }
        return this.hasLocation;
    }

    void _setVisible(boolean bl) {
        if (bl == GTK.gtk_widget_get_mapped(this.handle)) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.getItemCount() != 0) {
                if ((this.parent._getShell().style & 0x4000) != 0 && !GTK.GTK4) {
                    GTK3.gtk_menu_shell_set_take_focus(this.handle, false);
                }
                long l = 0L;
                if (this.ableToSetLocation()) {
                    if (GTK.GTK4) {
                        GdkRectangle gdkRectangle = new GdkRectangle();
                        gdkRectangle.x = this.x;
                        gdkRectangle.y = this.y;
                        gdkRectangle.height = 1;
                        gdkRectangle.width = 1;
                        GTK.gtk_popover_set_pointing_to(this.handle, gdkRectangle);
                        GTK.gtk_popover_popup(this.handle);
                    } else {
                        l = GDK.gdk_event_new(4);
                        GdkEventButton gdkEventButton = new GdkEventButton();
                        gdkEventButton.type = 4;
                        gdkEventButton.device = GDK.gdk_get_pointer(GDK.gdk_display_get_default());
                        gdkEventButton.time = this.display.getLastEventTime();
                        GdkRectangle gdkRectangle = new GdkRectangle();
                        if (OS.isX11()) {
                            gdkEventButton.window = GDK.gdk_display_get_default_group(GDK.gdk_display_get_default());
                            OS.g_object_ref(gdkEventButton.window);
                            GTK3.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                            int[] nArray = new int[1];
                            int[] nArray2 = new int[1];
                            GDK.gdk_window_get_origin(gdkEventButton.window, nArray2, nArray);
                            gdkRectangle.x = this.x - nArray2[0];
                            gdkRectangle.y = this.y - nArray[0];
                        } else {
                            long l2 = GTK3.gtk_widget_get_window(this.getShell().topHandle());
                            gdkEventButton.window = OS.g_object_ref(l2);
                            GTK3.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                            gdkRectangle.x = this.x + 1;
                            gdkRectangle.y = this.y + 1;
                        }
                        GTK3.gtk_menu_popup_at_rect(this.handle, gdkEventButton.window, gdkRectangle, 1, 1, l);
                        this.gdk_event_free(l);
                    }
                } else {
                    l = GTK3.gtk_get_current_event();
                    if (l == 0L) {
                        l = GDK.gdk_event_new(GTK.GTK4 ? 5 : 4);
                        GdkEventButton gdkEventButton = new GdkEventButton();
                        int n = gdkEventButton.type = GTK.GTK4 ? 5 : 4;
                        if (OS.isX11()) {
                            gdkEventButton.window = OS.g_object_ref(GTK3.gtk_widget_get_window(this.getShell().handle));
                        }
                        gdkEventButton.device = GDK.gdk_get_pointer(GDK.gdk_display_get_default());
                        gdkEventButton.time = this.display.getLastEventTime();
                        GTK3.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                    }
                    this.adjustParentWindowWayland(l);
                    this.verifyMenuPosition(this.getItemCount());
                    GTK3.gtk_menu_popup_at_pointer(this.handle, l);
                    if (GTK.GTK4) {
                        GDK.gdk_event_unref(l);
                    } else {
                        GDK.gdk_event_free(l);
                    }
                }
                this.poppedUpCount = this.getItemCount();
            } else {
                this.sendEvent(23);
            }
        } else if (GTK.GTK4) {
            GTK.gtk_popover_popdown(this.handle);
        } else {
            GTK3.gtk_menu_popdown(this.handle);
        }
    }

    void addAccelerators(long l) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.addAccelerators(l);
        }
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    @Override
    void createHandle(int n) {
        this.state |= 8;
        if (GTK.GTK4) {
            int n2 = 14;
            this.modelHandle = OS.g_menu_new();
            if (this.modelHandle == 0L) {
                this.error(2);
            }
            this.items = new LinkedList();
            this.sections = new LinkedList();
            switch (this.style & n2) {
                case 2: {
                    this.handle = GTK4.gtk_popover_menu_bar_new_from_model(this.modelHandle);
                    if (this.handle == 0L) {
                        this.error(2);
                    }
                    GTK4.gtk_box_prepend(this.parent.vboxHandle, this.handle);
                    break;
                }
                case 4: {
                    this.handle = this.modelHandle;
                    break;
                }
                default: {
                    this.handle = GTK4.gtk_popover_menu_new_from_model_full(this.modelHandle, 1);
                    GTK.gtk_widget_set_parent(this.handle, this.parent.handle);
                    GTK.gtk_popover_set_position(this.handle, 3);
                    GTK4.gtk_popover_set_has_arrow(this.handle, false);
                    GTK.gtk_widget_set_halign(this.handle, 1);
                    if (this.handle != 0L) break;
                    this.error(2);
                }
            }
            long l = OS.g_menu_new();
            if (l == 0L) {
                this.error(2);
            }
            this.sections.add(new Section(l));
            long l2 = OS.g_menu_item_new_section(null, l);
            OS.g_menu_insert_item(this.modelHandle, 0, l2);
            OS.g_object_unref(l2);
            this.actionGroup = OS.g_simple_action_group_new();
            if (this.actionGroup == 0L) {
                this.error(2);
            }
            long l3 = this.parent.getShell().topHandle();
            GTK.gtk_widget_insert_action_group(l3, Converter.javaStringToCString(String.valueOf(this.hashCode())), this.actionGroup);
        } else if ((this.style & 2) != 0) {
            this.handle = GTK3.gtk_menu_bar_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            long l = this.parent.vboxHandle;
            GTK3.gtk_container_add(l, this.handle);
            this.gtk_box_set_child_packing(l, this.handle, false, true, 0, 0);
        } else {
            this.handle = GTK3.gtk_menu_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            this.menuHandle = this.handle;
            OS.g_object_ref_sink(this.menuHandle);
        }
    }

    @Override
    void createWidget(int n) {
        this.checkOrientation(this.parent);
        super.createWidget(n);
        this.parent.addMenu(this);
    }

    void fixMenus(Decorations decorations) {
        if (this.isDisposed()) {
            return;
        }
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            menuItemArray[i].fixMenus(decorations);
        }
        this.parent.removeMenu(this);
        decorations.addMenu(this);
        this.parent = decorations;
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        if (GTK.GTK4) {
            if ((this.style & 4) != 0) {
                return true;
            }
            return GTK.gtk_widget_get_sensitive(this.handle);
        }
        return GTK.gtk_widget_get_sensitive(this.handle);
    }

    public MenuItem getItem(int n) {
        this.checkWidget();
        if (GTK.GTK4) {
            if (n < 0 || n >= this.items.size()) {
                this.error(6);
            }
            return this.items.get(n);
        }
        long l = GTK3.gtk_container_get_children(this.handle);
        if (l == 0L) {
            this.error(8);
        }
        int n2 = OS.g_list_length(l);
        if (0 > n || n >= n2) {
            this.error(6);
        }
        long l2 = OS.g_list_nth_data(l, n);
        OS.g_list_free(l);
        if (l2 == 0L) {
            this.error(8);
        }
        return (MenuItem)this.display.getWidget(l2);
    }

    public int getItemCount() {
        this.checkWidget();
        if (GTK.GTK4) {
            return this.items.size();
        }
        int n = 0;
        long l = GTK3.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return 0;
        }
        n = OS.g_list_length(l);
        OS.g_list_free(l);
        return Math.max(0, n);
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        if (GTK.GTK4) {
            return this.items.toArray(new MenuItem[this.items.size()]);
        }
        long l = GTK3.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return new MenuItem[0];
        }
        long l2 = l;
        int n = OS.g_list_length(l);
        MenuItem[] menuItemArray = new MenuItem[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l3 = OS.g_list_data(l);
            MenuItem menuItem = (MenuItem)this.display.getWidget(l3);
            if (menuItem != null) {
                menuItemArray[n2++] = menuItem;
            }
            l = OS.g_list_next(l);
        }
        OS.g_list_free(l2);
        if (n2 != menuItemArray.length) {
            MenuItem[] menuItemArray2 = new MenuItem[n2];
            System.arraycopy(menuItemArray, 0, menuItemArray2, 0, n2);
            menuItemArray = menuItemArray2;
        }
        return menuItemArray;
    }

    @Override
    String getNameText() {
        Object object = "";
        MenuItem[] menuItemArray = this.getItems();
        int n = menuItemArray.length;
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                object = (String)object + menuItemArray[i].getNameText() + ", ";
            }
            object = (String)object + menuItemArray[n - 1].getNameText();
        }
        return object;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade == null) {
            return null;
        }
        return this.cascade.getParent();
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu[] menuArray;
        this.checkWidget();
        if ((this.style & 8) != 0 && (menuArray = this.display.popups) != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                if (menuArray[i] != this) continue;
                return true;
            }
        }
        return GTK.gtk_widget_get_mapped(this.handle);
    }

    @Override
    long gtk_hide(long l) {
        if ((this.style & 8) != 0 && this.display.activeShell != null) {
            this.display.activeShell = this.getShell();
            if (this.display.activeShell.ignoreFocusOut) {
                this.display.activeShell.ignoreFocusIn = true;
            }
            this.display.activeShell.ignoreFocusOut = false;
        }
        this.sendEvent(23);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(false)) continue;
            }
        }
        return 0L;
    }

    @Override
    long gtk_show(long l) {
        if ((this.style & 8) != 0) {
            if (this.display.activeShell != null) {
                this.display.activeShell = this.getShell();
                this.display.activeShell.ignoreFocusOut = true;
            }
            return 0L;
        }
        this.sendEvent(22);
        if (OS.ubuntu_menu_proxy_get() != 0L) {
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                MenuItem menuItem = menuItemArray[i];
                if (!menuItem.updateAcceleratorText(true)) continue;
            }
        }
        return 0L;
    }

    @Override
    long gtk3_show_help(long l, long l2) {
        if (this.sendHelpEvent(l2)) {
            GTK3.gtk_menu_shell_deactivate(this.handle);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_menu_popped_up(long l, long l2, long l3, long l4, long l5) {
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.memmove(gdkRectangle, l3, (long)GDK.GdkRectangle_sizeof());
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.memmove(gdkRectangle2, l2, (long)GDK.GdkRectangle_sizeof());
        boolean bl = l4 == 1L;
        boolean bl2 = l5 == 1L;
        System.out.println("SWT_MENU_LOCATION_DEBUGGING enabled, printing positioning info for " + l);
        if (OS.isWayland()) {
            System.out.println("Note: SWT is running on Wayland, coordinates will be parent-relative");
        }
        if (this.hasLocation) {
            System.out.println("hasLocation is true and set coordinates are Point {" + this.x + ", " + this.y + "}");
        } else {
            System.out.println("hasLocation is not set, this is most likely a right click menu");
        }
        if (bl) {
            System.out.println("Menu is inverted along the X-axis");
        }
        if (bl2) {
            System.out.println("Menu is inverted along the Y-axis");
        }
        System.out.println("Final menu position and size is Rectangle {" + gdkRectangle.x + ", " + gdkRectangle.y + ", " + gdkRectangle.width + ", " + gdkRectangle.height + "}");
        System.out.println("Flipped menu position and size is Rectangle {" + gdkRectangle2.x + ", " + gdkRectangle2.y + ", " + gdkRectangle2.width + ", " + gdkRectangle2.height + "}");
        System.out.println("");
        return 0L;
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        if (GTK.GTK4) {
            this.shortcutController = GTK4.gtk_shortcut_controller_new();
            if (this.shortcutController == 0L) {
                this.error(2);
            }
            GTK4.gtk_shortcut_controller_set_scope(this.shortcutController, 2);
            GTK4.gtk_widget_add_controller(this.parent.handle, this.shortcutController);
            if ((this.style & 4) == 0) {
                OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.getClosure(45), false);
                OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.getClosure(24), false);
            }
        } else {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[46], 0, this.display.getClosure(46), false);
            if (OS.SWT_MENU_LOCATION_DEBUGGING) {
                OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[85], 0, this.display.getClosure(85), false);
            }
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[45], 0, this.display.getClosure(45), false);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[24], 0, this.display.getClosure(24), false);
        }
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            if (menuItemArray[i] != menuItem) continue;
            return i;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled() && this.parent.isEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            if (menuItem == null || menuItem.isDisposed()) continue;
            menuItem.release(false);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.setMenu(null);
        }
        if ((this.style & 2) != 0 && this == this.parent.menuBar) {
            this.parent.setMenuBar(null);
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void destroyWidget() {
        super.destroyWidget();
        if (this.menuHandle != 0L) {
            OS.g_object_unref(this.menuHandle);
            this.menuHandle = 0L;
        }
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    void removeAccelerators(long l) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.removeAccelerators(l);
        }
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    @Override
    void reskinChildren(int n) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i = 0; i < menuItemArray.length; ++i) {
            MenuItem menuItem = menuItemArray[i];
            menuItem.reskin(n);
        }
        super.reskinChildren(n);
    }

    boolean sendHelpEvent(long l) {
        if (this.selectedItem != null && !this.selectedItem.isDisposed() && this.selectedItem.hooks(28)) {
            this.selectedItem.postEvent(28);
            return true;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return true;
        }
        return this.parent.sendHelpEvent(l);
    }

    public void setDefaultItem(MenuItem menuItem) {
        this.checkWidget();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (GTK.GTK4) {
            if ((this.style & 4) != 0) {
                return;
            }
            GTK.gtk_widget_set_sensitive(this.handle, bl);
        } else {
            GTK.gtk_widget_set_sensitive(this.handle, bl);
        }
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setLocation(new Point(n, n2));
    }

    void setLocationInPixels(int n, int n2) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(point));
    }

    void setLocationInPixels(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocationInPixels(point.x, point.y);
    }

    public void setOrientation(int n) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this._setOrientation(n);
    }

    void _setOrientation(int n) {
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= ~n2;
        this.style |= n & n2;
        this.setOrientation(false);
    }

    @Override
    void setOrientation(boolean bl) {
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0L) {
                GTK.gtk_widget_set_direction(this.handle, n);
            }
            MenuItem[] menuItemArray = this.getItems();
            for (int i = 0; i < menuItemArray.length; ++i) {
                menuItemArray[i].setOrientation(bl);
            }
        }
    }

    void adjustParentWindowWayland(long l) {
        if (OS.isWayland()) {
            long l2 = GDK.gdk_display_get_default();
            long l3 = GDK.gdk_get_pointer(l2);
            long l4 = GTK.GTK4 ? GDK.gdk_device_get_surface_at_position(l3, null, null) : GDK.gdk_device_get_window_at_position(l3, null, null);
            OS.g_object_ref(l4);
            int n = GDK.gdk_event_get_event_type(l);
            n = Control.fixGdkEventTypeValues(n);
            switch (n) {
                case 4: {
                    GdkEventButton gdkEventButton = new GdkEventButton();
                    GTK3.memmove(gdkEventButton, l, (long)GdkEventButton.sizeof);
                    gdkEventButton.window = l4;
                    GTK3.memmove(l, gdkEventButton, (long)GdkEventButton.sizeof);
                    break;
                }
                case 8: {
                    GdkEventKey gdkEventKey = new GdkEventKey();
                    GTK3.memmove(gdkEventKey, l, (long)GdkEventKey.sizeof);
                    gdkEventKey.window = l4;
                    GTK3.memmove(l, gdkEventKey, (long)GdkEventKey.sizeof);
                }
            }
        }
    }

    void verifyMenuPosition(int n) {
        if (OS.isX11() && n != this.poppedUpCount && this.poppedUpCount != 0) {
            int[] nArray = new int[1];
            GTK.gtk_widget_show(this.handle);
            GTK3.gtk_widget_get_preferred_height(this.handle, null, nArray);
            if (nArray[0] > 0 && !GTK.GTK4) {
                long l = GTK3.gtk_widget_get_toplevel(this.handle);
                long l2 = GTK3.gtk_widget_get_window(l);
                int n2 = GDK.gdk_window_get_width(l2);
                GDK.gdk_window_resize(l2, n2, nArray[0]);
            }
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        if (bl) {
            this.display.addPopup(this);
        } else {
            this.display.removePopup(this);
            this._setVisible(false);
        }
    }

    class Section {
        LinkedList<MenuItem> sectionItems = new LinkedList();
        private MenuItem separator;
        private long sectionHandle;

        public Section() {
        }

        public Section(MenuItem menuItem) {
            this();
            this.separator = menuItem;
        }

        public Section(long l) {
            this();
            this.sectionHandle = l;
        }

        public long getSectionHandle() {
            return this.sectionHandle != 0L ? this.sectionHandle : this.separator.modelHandle;
        }

        public int getItemPosition(MenuItem menuItem) {
            return this.sectionItems.indexOf(menuItem);
        }

        public int getSectionSize() {
            return this.sectionItems.size();
        }

        public int getSectionPosition() {
            return Menu.this.items.indexOf(this.separator);
        }
    }
}

