/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkBorder;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk3.GdkEventFocus;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    long buttonHandle;
    long entryHandle;
    long textRenderer;
    long cellHandle;
    long popupHandle;
    long menuHandle;
    long buttonBoxHandle;
    long cellBoxHandle;
    long arrowHandle;
    int lastEventTime;
    int visibleCount = 10;
    long imContext;
    long gdkEventKey = 0L;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    int indexSelected;
    GdkRGBA background;
    GdkRGBA foreground;
    long cssProvider;
    boolean firstDraw = true;
    boolean unselected = true;
    boolean fitModelToggled = false;
    public static final int LIMIT = 65535;
    private boolean delayedEnableWrap = false;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n > this.items.length) {
            this.error(6);
        }
        String[] stringArray = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, stringArray, 0, n);
        stringArray[n] = string;
        System.arraycopy(this.items, n, stringArray, n + 1, this.items.length - n);
        this.items = stringArray;
        this.gtk_combo_box_insert(string, n);
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    private void gtk_combo_box_insert(String string, int n) {
        byte[] byArray = Converter.wcsToMbcs(string, true);
        if (this.handle != 0L) {
            this.gtk_combo_box_toggle_wrap(false);
            GTK.gtk_combo_box_text_insert(this.handle, n, null, byArray);
            this.gtk_combo_box_toggle_wrap(true);
        }
    }

    private void gtk_combo_box_toggle_wrap(boolean bl) {
        if (this.handle == 0L || GTK.GTK4) {
            return;
        }
        if (!bl) {
            if (GTK3.gtk_combo_box_get_wrap_width(this.handle) == 1) {
                GTK3.gtk_combo_box_set_wrap_width(this.handle, 0);
            }
        } else {
            if (this.delayedEnableWrap) {
                return;
            }
            this.delayedEnableWrap = true;
            this.display.asyncExec(() -> {
                if (!this.isDisposed() && this.handle != 0L) {
                    GTK3.gtk_combo_box_set_wrap_width(this.handle, 1);
                    this.delayedEnableWrap = false;
                }
            });
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            int n = GTK.gtk_editable_get_position(this.entryHandle);
            GTK.gtk_editable_select_region(this.entryHandle, n, n);
        }
    }

    void clearText() {
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0) {
            int n = GTK.gtk_combo_box_get_active(this.handle);
            if (n != -1) {
                long l = GTK.gtk_combo_box_get_model(this.handle);
                long[] lArray = new long[1];
                long l2 = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child(l, l2, 0L, n);
                GTK.gtk_tree_model_get(l, l2, 0, lArray, -1);
                OS.g_free(l2);
                if (lArray[0] != 0L && C.strlen(lArray[0]) > 0) {
                    this.postEvent(24);
                }
                OS.g_free(lArray[0]);
            }
        } else if (GTK.GTK4) {
            long l = GTK4.gtk_entry_get_buffer(this.entryHandle);
            GTK.gtk_entry_buffer_delete_text(l, 0, -1);
        } else {
            GTK3.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        GTK.gtk_combo_box_set_active(this.handle, -1);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
    }

    @Override
    Point computeSizeInPixels(int n, int n2, boolean bl) {
        this.checkWidget();
        return this.computeNativeSize(this.handle, n, n2, bl);
    }

    @Override
    Point computeNativeSize(long l, int n, int n2, boolean bl) {
        if (this.fitModelToggled) {
            GTK.gtk_cell_view_set_fit_model(this.cellHandle, true);
        }
        int[] nArray = new int[1];
        if (this.textRenderer != 0L) {
            GTK.gtk_cell_renderer_get_padding(this.textRenderer, nArray, null);
        }
        Point point = super.computeNativeSize(l, n, n2, bl);
        point.x += nArray[0] * 2;
        if ((this.style & 8) != 0 && !GTK.GTK4) {
            GtkBorder gtkBorder = new GtkBorder();
            long l2 = GTK.gtk_widget_get_style_context(this.buttonHandle);
            int n3 = GTK.gtk_widget_get_state_flags(this.buttonHandle);
            this.gtk_style_context_get_padding(l2, n3, gtkBorder);
            point.x += gtkBorder.left + gtkBorder.right;
        }
        if (this.fitModelToggled) {
            GTK.gtk_cell_view_set_fit_model(this.cellHandle, false);
        }
        return point;
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            if (GTK.GTK4) {
                long l = GTK4.gtk_widget_get_first_child(this.entryHandle);
                GTK4.gtk_widget_activate_action(l, OS.action_copy_clipboard, null);
            } else {
                GTK3.gtk_editable_copy_clipboard(this.entryHandle);
            }
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
        }
        long l = GTK.gtk_window_list_toplevels();
        if ((this.style & 8) != 0) {
            this.handle = GTK.gtk_combo_box_text_new();
            if (this.handle == 0L) {
                this.error(2);
            }
            long l2 = this.cellHandle = GTK.GTK4 ? GTK4.gtk_combo_box_get_child(this.handle) : GTK3.gtk_bin_get_child(this.handle);
            if (this.cellHandle == 0L) {
                this.error(2);
            }
            this.gtk_combo_box_toggle_wrap(true);
        } else {
            this.handle = GTK.gtk_combo_box_text_new_with_entry();
            if (this.handle == 0L) {
                this.error(2);
            }
            long l3 = this.entryHandle = GTK.GTK4 ? GTK4.gtk_combo_box_get_child(this.handle) : GTK3.gtk_bin_get_child(this.handle);
            if (this.entryHandle == 0L) {
                this.error(2);
            }
            if (DISABLE_EMOJI && GTK.GTK_VERSION >= OS.VERSION(3, 22, 20)) {
                GTK.gtk_entry_set_input_hints(this.entryHandle, 1024);
            }
            this.imContext = OS.imContextLast();
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.handle);
        } else {
            this.popupHandle = this.findPopupHandle(l);
            GTK3.gtk_container_add(this.fixedHandle, this.handle);
        }
        this.textRenderer = GTK.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0L) {
            this.error(2);
        }
        GTK.gtk_cell_layout_clear(this.handle);
        GTK.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
        GTK.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0L);
        this.menuHandle = this.findMenuHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
        }
        this.buttonHandle = this.findButtonHandle();
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
        }
        if (this.buttonBoxHandle != 0L) {
            OS.g_object_ref(this.buttonBoxHandle);
        }
        if (this.cellHandle != 0L) {
            this.cellBoxHandle = GTK.gtk_widget_get_parent(this.cellHandle);
        }
        if (this.cellBoxHandle != 0L) {
            OS.g_object_ref(this.cellBoxHandle);
        }
        if ((this.style & 8) != 0 && this.buttonHandle != 0L) {
            GTK.gtk_widget_set_receives_default(this.buttonHandle, false);
        }
        if ((this.style & 8) != 0 && this.cellBoxHandle != 0L) {
            this.arrowHandle = this.findArrowHandle();
        }
        this.setFontDescription(this.defaultFont().handle);
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            if (GTK.GTK4) {
                long l = GTK4.gtk_widget_get_first_child(this.entryHandle);
                GTK4.gtk_widget_activate_action(l, OS.action_cut_clipboard, null);
            } else {
                GTK3.gtk_editable_cut_clipboard(this.entryHandle);
            }
        }
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        long l;
        super.deregister();
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0L) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.popupHandle != 0L) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.removeWidget(l);
        }
    }

    @Override
    boolean filterKey(long l) {
        int n = GDK.gdk_event_get_time(l);
        if (n != this.lastEventTime) {
            this.lastEventTime = n;
            long l2 = this.imContext();
            if (l2 != 0L) {
                if (GTK.GTK4) {
                    return GTK4.gtk_im_context_filter_keypress(l2, l);
                }
                return GTK3.gtk_im_context_filter_keypress(l2, l);
            }
        }
        this.gdkEventKey = l;
        return false;
    }

    long findPopupHandle(long l) {
        long l2 = 0L;
        long l3 = GTK.gtk_window_list_toplevels();
        long l4 = l;
        long l5 = OS.g_list_last(l3);
        while (l5 != 0L) {
            long l6 = OS.g_list_data(l5);
            boolean bl = false;
            l4 = l;
            while (l4 != 0L) {
                long l7 = OS.g_list_data(l4);
                if (l6 == l7) {
                    bl = true;
                    break;
                }
                l4 = OS.g_list_next(l4);
            }
            if (!bl) {
                l2 = l6;
                break;
            }
            l5 = OS.g_list_previous(l5);
        }
        OS.g_list_free(l);
        OS.g_list_free(l3);
        return l2;
    }

    @Override
    Point resizeCalculationsGTK3(long l, int n, int n2) {
        return new Point(n, n2);
    }

    long findButtonHandle() {
        long l = 0L;
        if (GTK.GTK4) {
            long l2 = GTK4.gtk_widget_get_first_child(this.handle);
            while (l2 != 0L) {
                if (GTK.GTK_IS_BOX(l2)) {
                    this.buttonBoxHandle = l2;
                    break;
                }
                l2 = GTK4.gtk_widget_get_next_sibling(l2);
            }
            l2 = GTK4.gtk_widget_get_first_child(this.buttonBoxHandle);
            while (l2 != 0L) {
                if (GTK.GTK_IS_BUTTON(l2)) {
                    l = l2;
                    break;
                }
                l2 = GTK4.gtk_widget_get_next_sibling(l2);
            }
        } else {
            long l3;
            long l4;
            long l5 = this.handle;
            GTK3.gtk_container_forall(this.handle, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                l4 = this.display.allChildren;
                while (l4 != 0L) {
                    l3 = OS.g_list_data(l4);
                    if (l3 != 0L) {
                        l5 = l3;
                        break;
                    }
                    l4 = OS.g_list_next(l4);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
            this.buttonBoxHandle = l5;
            GTK3.gtk_container_forall(l5, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                l4 = this.display.allChildren;
                while (l4 != 0L) {
                    l3 = OS.g_list_data(l4);
                    if (GTK.GTK_IS_BUTTON(l3)) {
                        l = l3;
                        break;
                    }
                    l4 = OS.g_list_next(l4);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
        }
        return l;
    }

    long findArrowHandle() {
        long l = 0L;
        if (this.cellBoxHandle != 0L) {
            if (GTK.GTK4) {
                long l2 = GTK4.gtk_widget_get_first_child(this.cellBoxHandle);
                while (l2 != 0L) {
                    String string = this.display.gtk_widget_get_name(l2);
                    if (string != null && string.equals("GtkBuiltinIcon")) {
                        l = l2;
                        break;
                    }
                    l2 = GTK4.gtk_widget_get_next_sibling(l2);
                }
            } else {
                GTK3.gtk_container_forall(this.cellBoxHandle, this.display.allChildrenProc, 0L);
                if (this.display.allChildren != 0L) {
                    long l3 = this.display.allChildren;
                    while (l3 != 0L) {
                        long l4 = OS.g_list_data(l3);
                        String string = this.display.gtk_widget_get_name(l4);
                        if (string != null && string.contains("GtkIcon")) {
                            l = l4;
                        }
                        l3 = OS.g_list_next(l3);
                    }
                    OS.g_list_free(this.display.allChildren);
                    this.display.allChildren = 0L;
                }
            }
        }
        return l;
    }

    long findMenuHandle() {
        long l = 0L;
        if (GTK.GTK4) {
            long l2 = GTK4.gtk_widget_get_first_child(this.handle);
            while (l2 != 0L) {
                String string = this.display.gtk_widget_get_name(l2);
                if (string != null && string.equals("GtkTreePopover")) {
                    l = GTK4.gtk_widget_get_first_child(l2);
                    break;
                }
                l2 = GTK4.gtk_widget_get_next_sibling(l2);
            }
        } else if (this.popupHandle != 0L) {
            GTK3.gtk_container_forall(this.popupHandle, this.display.allChildrenProc, 0L);
            if (this.display.allChildren != 0L) {
                long l3 = this.display.allChildren;
                while (l3 != 0L) {
                    long l4 = OS.g_list_data(l3);
                    String string = this.display.gtk_widget_get_name(l4);
                    if (string != null && string.contains("gtk-combobox-popup-menu")) {
                        l = l4;
                        break;
                    }
                    l3 = OS.g_list_next(l3);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0L;
            }
        }
        return l;
    }

    @Override
    void fixModal(long l, long l2) {
        if (this.popupHandle != 0L) {
            if (l != 0L) {
                GTK.gtk_window_group_add_window(l, this.popupHandle);
            } else if (l2 != 0L) {
                GTK.gtk_window_group_remove_window(l2, this.popupHandle);
            }
        }
    }

    void fixIM() {
        long l;
        if (this.gdkEventKey != 0L && this.gdkEventKey != -1L && (l = this.imContext()) != 0L) {
            if (GTK.GTK4) {
                GTK4.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            } else {
                GTK3.gtk_im_context_filter_keypress(l, this.gdkEventKey);
            }
            this.gdkEventKey = -1L;
            return;
        }
        this.gdkEventKey = 0L;
    }

    @Override
    long fontHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    @Override
    long focusHandle() {
        if (this.entryHandle != 0L) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    @Override
    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        return this.entryHandle != 0L && GTK.gtk_widget_has_focus(this.entryHandle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        if (this.entryHandle != 0L) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.getClosure(1), false);
            if (!GTK.GTK4) {
                OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.getClosure(37), false);
            }
        }
        this.hookEvents(new long[]{this.buttonHandle, this.entryHandle, this.menuHandle});
        long l = this.imContext();
        if (l != 0L) {
            OS.g_signal_connect_closure(l, OS.commit, this.display.getClosure(9), false);
            int n = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
            int n2 = 17;
            OS.g_signal_handlers_block_matched(l, n2, n, 0, 0L, 0L, this.entryHandle);
        }
    }

    void hookEvents(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            if (l == 0L) continue;
            if (GTK.GTK4) {
                long l2 = GTK4.gtk_event_controller_motion_new();
                GTK4.gtk_widget_add_controller(l, l2);
                OS.g_signal_connect(l2, OS.motion, this.display.enterMotionProc, 97L);
                OS.g_signal_connect(l2, OS.motion, this.display.enterMotionProc, 98L);
                long l3 = GTK4.gtk_gesture_click_new();
                GTK4.gtk_widget_add_controller(l, l3);
                OS.g_signal_connect(l3, OS.pressed, this.display.gesturePressReleaseProc, 100L);
                OS.g_signal_connect(l3, OS.released, this.display.gesturePressReleaseProc, 101L);
                continue;
            }
            int n = 772;
            GTK3.gtk_widget_add_events(l, n);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[33], 0, this.display.getClosure(34), true);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[2], 0, this.display.getClosure(3), true);
            OS.g_signal_connect_closure_by_id(l, this.display.signalIds[4], 0, this.display.getClosure(5), true);
            if (l != this.focusHandle()) {
                OS.g_signal_connect_closure_by_id(l, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
            if (OS.G_OBJECT_TYPE(l) != GTK3.GTK_TYPE_MENU()) continue;
            OS.g_signal_connect_closure(l, OS.selection_done, this.display.getClosure(68), true);
        }
    }

    long imContext() {
        if (this.imContext != 0L) {
            return this.imContext;
        }
        return 0L;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (GTK.gtk_combo_box_get_active(this.handle) == n) {
            this.clearText();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearText();
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl && this.entryHandle != 0L) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            long l = GTK3.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(l, n * 1024, n2 * 1024, nArray, nArray2);
            long l2 = OS.pango_layout_get_text(l);
            int n3 = (int)OS.g_utf8_pointer_to_offset(l2, l2 + (long)nArray[0]) + nArray2[0];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, nArray3, nArray4);
            if (nArray3[0] <= n3 && n3 < nArray4[0] && super.dragDetect(n, n2, bl, bl2, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, bl2, blArray);
    }

    @Override
    long enterExitHandle() {
        return this.fixedHandle;
    }

    @Override
    long eventWindow() {
        if ((this.style & 8) != 0) {
            GTK.gtk_widget_realize(this.handle);
            return this.gtk_widget_get_window(this.handle);
        }
        GTK.gtk_widget_realize(this.entryHandle);
        long l = this.gtk_widget_get_window(this.entryHandle);
        long l2 = GDK.gdk_window_get_children(l);
        if (l2 != 0L) {
            long l3 = l2;
            do {
                l = OS.g_list_data(l3);
            } while ((l3 = OS.g_list_next(l3)) != 0L);
        }
        OS.g_list_free(l2);
        return l;
    }

    @Override
    long eventSurface() {
        return this.paintSurface();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getCaretLocationInPixels());
    }

    Point getCaretLocationInPixels() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int n = GTK.gtk_editable_get_position(this.entryHandle);
        n = GTK3.gtk_entry_text_index_to_layout_index(this.entryHandle, n);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GTK3.gtk_entry_get_layout_offsets(this.entryHandle, nArray, nArray2);
        long l = GTK3.gtk_entry_get_layout(this.entryHandle);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(l, n, pangoRectangle);
        Point point = this.getThickness(this.entryHandle);
        int n2 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidthInPixels() - point.x;
        int n3 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y) - point.y;
        return new Point(n2, n3);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return 0;
        }
        long l = GTK3.gtk_entry_get_text(this.entryHandle);
        return (int)OS.g_utf8_offset_to_utf16_offset(l, GTK.gtk_editable_get_position(this.entryHandle));
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null && (this.state & 0x2000) != 0) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_WIDGET_FOREGROUND_RGBA;
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        long l = this.getFontDescription();
        int n = this.fontHeight(l, this.handle);
        OS.pango_font_description_free(l);
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.items.length];
        System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.popupHandle != 0L && GTK.gtk_widget_get_visible(this.popupHandle);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int n = 0;
            int n2 = GTK.gtk_combo_box_get_active(this.handle);
            if (n2 != -1) {
                n = this.getItem(n2).length();
            }
            return new Point(0, n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.entryHandle != 0L) {
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, nArray, nArray2);
            long l = GTK3.gtk_entry_get_text(this.entryHandle);
            nArray[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray[0]);
            nArray2[0] = (int)OS.g_utf8_offset_to_utf16_offset(l, nArray2[0]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return GTK.gtk_combo_box_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            long l = 0L;
            if (GTK.GTK4) {
                long l2 = GTK4.gtk_entry_get_buffer(this.entryHandle);
                l = GTK.gtk_entry_buffer_get_text(l2);
            } else {
                l = GTK3.gtk_entry_get_text(this.entryHandle);
            }
            if (l == 0L) {
                return "";
            }
            int n = C.strlen(l);
            byte[] byArray = new byte[n];
            C.memmove(byArray, l, (long)n);
            return new String(Converter.mbcsToWcs(byArray));
        }
        int n = GTK.gtk_combo_box_get_active(this.handle);
        return n != -1 ? this.getItem(n) : "";
    }

    String getText(int n, int n2) {
        return this.getText().substring(n, n2 - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getTextHeightInPixels());
    }

    int getTextHeightInPixels() {
        this.checkWidget();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.handle, gtkRequisition);
        return gtkRequisition.height;
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = this.entryHandle != 0L ? GTK.gtk_entry_get_max_length(this.entryHandle) : 0;
        return n == 0 ? LIMIT : n;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    long gtk_activate(long l) {
        this.sendSelectionEvent(14);
        return 0L;
    }

    @Override
    long gtk_button_press_event(long l, long l2) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_button_event_get_button(l2);
        } else {
            GDK.gdk_event_get_button(l2, nArray);
        }
        int n = GDK.gdk_event_get_event_type(l2);
        if (n == 4 && nArray[0] == 1) {
            return this.gtk_button_press_event(l, l2, false);
        }
        return super.gtk_button_press_event(l, l2);
    }

    @Override
    long gtk_changed(long l) {
        long l2;
        if (l == this.handle) {
            int n;
            this.unselected = false;
            if (this.entryHandle == 0L) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return 0L;
                }
            }
            if ((n = GTK.gtk_combo_box_get_active(this.handle)) != -1) {
                this.sendSelectionEvent(13);
            }
            this.indexSelected = -1;
            return 0L;
        }
        boolean bl = false;
        long l3 = l2 = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (l2 != 0L) {
            int n = GDK.gdk_event_get_event_type(l2);
            n = Combo.fixGdkEventTypeValues(n);
            switch (n) {
                case 8: {
                    bl = true;
                }
            }
            this.gdk_event_free(l2);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0L;
    }

    @Override
    long gtk_commit(long l, long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        if (!GTK.gtk_editable_get_editable(this.entryHandle)) {
            return 0L;
        }
        int n = C.strlen(l2);
        if (n == 0) {
            return 0L;
        }
        byte[] byArray = new byte[n];
        C.memmove(byArray, l2, (long)n);
        char[] cArray = Converter.mbcsToWcs(byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, 0L, cArray);
        if (cArray2 == null) {
            return 0L;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(l, 16, 0, 0, 0L, 0L, 9L);
        int n2 = OS.g_signal_lookup(OS.commit, GTK.gtk_im_context_get_type());
        int n3 = 17;
        OS.g_signal_handlers_unblock_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(l, OS.commit, l2);
        } else {
            byArray = Converter.wcsToMbcs(cArray2, true);
            OS.g_signal_emit_by_name(l, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(l, 16, 0, 0, 0L, 0L, 9L);
        OS.g_signal_handlers_block_matched(l, n3, n2, 0, 0L, 0L, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            GTK.gtk_editable_set_position(this.entryHandle, this.fixStart);
            GTK.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0L;
    }

    @Override
    long gtk_delete_text(long l, long l2, long l3) {
        int n;
        int n2;
        String string;
        long l4;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (GTK.GTK4) {
            long l5 = GTK4.gtk_entry_get_buffer(this.entryHandle);
            l4 = GTK.gtk_entry_buffer_get_text(l5);
        } else {
            l4 = GTK3.gtk_entry_get_text(this.entryHandle);
        }
        if (l3 == -1L) {
            l3 = OS.g_utf8_strlen(l4, -1L);
        }
        if ((string = this.verifyText("", n2 = (int)OS.g_utf8_offset_to_utf16_offset(l4, l2), n = (int)OS.g_utf8_offset_to_utf16_offset(l4, l3))) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{(int)l3};
            byte[] byArray = Converter.wcsToMbcs(string, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            GTK.gtk_editable_insert_text(this.entryHandle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_editable_set_position(this.entryHandle, nArray[0]);
        }
        return 0L;
    }

    @Override
    void adjustChildClipping(long l) {
        if (l == this.cellHandle && (this.style & 8) != 0 && !this.unselected) {
            if (GTK.GTK4) {
                super.adjustChildClipping(l);
                return;
            }
            if (!this.fitModelToggled) {
                GTK.gtk_cell_view_set_fit_model(this.cellHandle, false);
                this.fitModelToggled = true;
            }
            GtkAllocation gtkAllocation = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.arrowHandle, gtkAllocation);
            GtkAllocation gtkAllocation2 = new GtkAllocation();
            GTK.gtk_widget_get_allocation(this.cellHandle, gtkAllocation2);
            gtkAllocation2.width = gtkAllocation.x - gtkAllocation.width;
            GTK3.gtk_widget_set_clip(l, gtkAllocation2);
            return;
        }
        super.adjustChildClipping(l);
    }

    @Override
    long gtk_draw(long l, long l2) {
        long l3 = GTK.gtk_widget_get_parent(this.fixedHandle);
        if (l3 != 0L) {
            if (this.parent.fixClipHandle == 0L) {
                this.parent.fixClipHandle = l3;
            }
            if (this.firstDraw) {
                if ((this.style & 8) != 0) {
                    long[] lArray = new long[]{this.fixedHandle, this.handle, this.buttonBoxHandle, this.buttonHandle, this.cellBoxHandle, this.cellHandle};
                    this.parent.fixClipMap.put(this, lArray);
                } else {
                    long[] lArray = new long[]{this.fixedHandle, this.handle, this.entryHandle, this.buttonBoxHandle, this.buttonHandle};
                    this.parent.fixClipMap.put(this, lArray);
                }
                this.firstDraw = false;
                GTK.gtk_widget_queue_draw(l3);
            }
        }
        return super.gtk_draw(l, l2);
    }

    @Override
    long gtk_event_after(long l, long l2) {
        int n = GDK.gdk_event_get_event_type(l2);
        n = Combo.fixGdkEventTypeValues(n);
        switch (n) {
            case 4: {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                if (GTK.GTK4) {
                    nArray[0] = GDK.gdk_button_event_get_button(l2);
                    nArray2[0] = GDK.gdk_event_get_modifier_state(l2);
                } else {
                    GDK.gdk_event_get_button(l2, nArray);
                    GDK.gdk_event_get_state(l2, nArray2);
                }
                int n2 = GDK.gdk_event_get_time(l2);
                double[] dArray = new double[1];
                double[] dArray2 = new double[1];
                GDK.gdk_event_get_root_coords(l2, dArray, dArray2);
                if (nArray[0] != 1) break;
                if (!this.sendMouseEvent(3, nArray[0], this.display.clickCount, 0, false, n2, dArray[0], dArray2[0], false, nArray2[0])) {
                    return 1L;
                }
                if ((this.style & 8) != 0 || l != this.buttonHandle) break;
                GTK.gtk_widget_grab_focus(this.entryHandle);
                break;
            }
            case 12: {
                if ((this.style & 8) != 0) break;
                boolean[] blArray = new boolean[1];
                if (GTK.GTK4) {
                    blArray[0] = GDK.gdk_focus_event_get_in(l2);
                } else {
                    GdkEventFocus gdkEventFocus = new GdkEventFocus();
                    GTK3.memmove(gdkEventFocus, l2, (long)GdkEventFocus.sizeof);
                    boolean bl = blArray[0] = gdkEventFocus.in != 0;
                }
                if (blArray[0]) {
                    GTK.gtk_widget_set_focus_on_click(this.handle, false);
                    break;
                }
                GTK.gtk_widget_set_focus_on_click(this.handle, true);
            }
        }
        return super.gtk_event_after(l, l2);
    }

    @Override
    long gtk_focus_out_event(long l, long l2) {
        this.fixIM();
        return super.gtk_focus_out_event(l, l2);
    }

    @Override
    long gtk_insert_text(long l, long l2, long l3, long l4) {
        int n;
        String string;
        long l5;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0L;
        }
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        byte[] byArray = new byte[(int)l3];
        C.memmove(byArray, l2, (long)byArray.length);
        String string2 = new String(Converter.mbcsToWcs(byArray));
        int[] nArray = new int[1];
        C.memmove(nArray, l4, 4L);
        if (GTK.GTK4) {
            long l6 = GTK4.gtk_entry_get_buffer(this.entryHandle);
            l5 = GTK.gtk_entry_buffer_get_text(l6);
        } else {
            l5 = GTK3.gtk_entry_get_text(this.entryHandle);
        }
        if (nArray[0] == -1) {
            nArray[0] = (int)OS.g_utf8_strlen(l5, -1L);
        }
        if ((string = this.verifyText(string2, n = (int)OS.g_utf8_offset_to_utf16_offset(l5, nArray[0]), n)) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            GTK.gtk_editable_get_selection_bounds(this.entryHandle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                    GTK.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
                }
                byte[] byArray2 = Converter.wcsToMbcs(string, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                GTK.gtk_editable_insert_text(this.entryHandle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            C.memmove(l4, nArray, 4L);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0L;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            this.gdkEventKey = 0L;
            this.fixIM();
            return l3;
        }
        if (this.gdkEventKey == -1L) {
            l3 = 1L;
        }
        this.gdkEventKey = 0L;
        if ((this.style & 8) == 0) {
            int n;
            int n2 = n = GTK.gtk_combo_box_get_active(this.handle);
            int[] nArray = new int[1];
            if (GTK.GTK4) {
                nArray[0] = GDK.gdk_key_event_get_keyval(l2);
            } else {
                GDK.gdk_event_get_keyval(l2, nArray);
            }
            switch (nArray[0]) {
                case 65364: 
                case 65433: {
                    if (n == this.items.length - 1) break;
                    n2 = n + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (n == -1 || n == 0) break;
                    n2 = n - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    n2 = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    n2 = this.items.length - 1;
                }
            }
            if (n2 != n) {
                GTK.gtk_combo_box_set_active(this.handle, n2);
                return 1L;
            }
        }
        return l3;
    }

    @Override
    long gtk_populate_popup(long l, long l2) {
        if ((this.style & 0x4000000) != 0) {
            GTK.gtk_widget_set_direction(l2, 2);
            GTK3.gtk_container_forall(l2, this.display.setDirectionProc, 2L);
        }
        return 0L;
    }

    @Override
    long gtk_selection_done(long l) {
        int n = GTK.gtk_combo_box_get_active(this.handle);
        this.unselected = false;
        if (this.indexSelected == -1) {
            this.indexSelected = n;
        } else if (n != -1 && this.indexSelected == n) {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    @Override
    long gtk_style_updated(long l) {
        this.setButtonHandle(this.findButtonHandle());
        this.setMenuHandle(this.findMenuHandle());
        return super.gtk_style_updated(l);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            return -1;
        }
        for (int i = n; i < this.items.length; ++i) {
            if (!string.equals(this.items[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean isFocusHandle(long l) {
        if (this.buttonHandle != 0L && l == this.buttonHandle) {
            return true;
        }
        if (this.entryHandle != 0L && l == this.entryHandle) {
            return true;
        }
        return super.isFocusHandle(l);
    }

    @Override
    long paintSurface() {
        long l = this.entryHandle != 0L ? this.entryHandle : this.handle;
        GTK.gtk_widget_realize(l);
        long l2 = this.gtk_widget_get_surface(l);
        if ((this.style & 8) != 0) {
            return l2;
        }
        return l2;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0L) {
            GTK3.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    @Override
    long parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void register() {
        long l;
        super.register();
        if (this.buttonHandle != 0L) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0L) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.popupHandle != 0L) {
            this.display.addWidget(this.popupHandle, this);
        }
        if (this.menuHandle != 0L) {
            this.display.addWidget(this.menuHandle, this);
        }
        if ((l = this.imContext()) != 0L) {
            this.display.addWidget(l, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.menuHandle != 0L) {
            OS.g_object_unref(this.menuHandle);
            this.menuHandle = 0L;
        }
        if (this.buttonHandle != 0L) {
            OS.g_object_unref(this.buttonHandle);
            this.buttonHandle = 0L;
        }
        if (this.buttonBoxHandle != 0L) {
            OS.g_object_unref(this.buttonBoxHandle);
            this.buttonBoxHandle = 0L;
        }
        if (this.cellBoxHandle != 0L) {
            OS.g_object_unref(this.cellBoxHandle);
            this.cellBoxHandle = 0L;
        }
        this.entryHandle = 0L;
        if (this.cssProvider != 0L) {
            OS.g_object_unref(this.cssProvider);
            this.cssProvider = 0L;
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0L;
        this.fixIM();
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
        this.items = stringArray2;
        if (GTK.gtk_combo_box_get_active(this.handle) == n) {
            this.clearText();
        }
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove(this.handle, n);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - (n2 - n + 1)];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n2 + 1, stringArray2, n, stringArray.length - n2 - 1);
        this.items = stringArray2;
        int n3 = GTK.gtk_combo_box_get_active(this.handle);
        if (n <= n3 && n3 <= n2) {
            this.clearText();
        }
        this.gtk_combo_box_toggle_wrap(false);
        for (int i = n2; i >= n; --i) {
            if (this.handle == 0L) continue;
            GTK.gtk_combo_box_text_remove(this.handle, i);
        }
        this.gtk_combo_box_toggle_wrap(true);
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        this.items = new String[0];
        this.clearText();
        this.gtk_combo_box_text_remove_all();
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        int n2 = GTK.gtk_combo_box_get_active(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_combo_box_set_active(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        if ((this.style & 8) != 0 && n2 != n) {
            this.sendEvent(24);
        }
        this.unselected = false;
    }

    @Override
    void setBackgroundGdkRGBA(long l, long l2, GdkRGBA gdkRGBA) {
        this.background = gdkRGBA;
        this.updateCss();
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = n4;
        if (bl2) {
            n5 = Math.max(this.getTextHeightInPixels(), n4);
        }
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    void setButtonHandle(long l) {
        if (this.buttonHandle == l) {
            return;
        }
        if (this.buttonHandle != 0L) {
            this.display.removeWidget(this.buttonHandle);
            OS.g_object_unref(this.buttonHandle);
        }
        this.buttonHandle = l;
        if (this.buttonHandle != 0L) {
            OS.g_object_ref(this.buttonHandle);
            this.display.addWidget(this.buttonHandle, this);
            this.hookEvents(new long[]{this.buttonHandle});
        }
    }

    void setMenuHandle(long l) {
        if (this.menuHandle == l) {
            return;
        }
        if (this.menuHandle != 0L) {
            this.display.removeWidget(this.menuHandle);
            OS.g_object_unref(this.menuHandle);
        }
        this.menuHandle = l;
        if (this.menuHandle != 0L) {
            OS.g_object_ref(this.menuHandle);
            this.display.addWidget(this.menuHandle, this);
            this.hookEvents(new long[]{this.menuHandle});
        }
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        if (this.entryHandle != 0L) {
            this.setFontDescription(this.entryHandle, l);
        }
        OS.g_object_set(this.textRenderer, OS.font_desc, l, 0L);
        if ((this.style & 8) != 0) {
            int n = GTK.gtk_combo_box_get_active(this.handle);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_combo_box_set_active(this.handle, -1);
            GTK.gtk_combo_box_set_active(this.handle, n);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        }
    }

    @Override
    void setForegroundGdkRGBA(long l, GdkRGBA gdkRGBA) {
        OS.g_object_set(this.textRenderer, OS.foreground_rgba, gdkRGBA, 0L);
        this.foreground = gdkRGBA;
        this.updateCss();
    }

    @Override
    void setInitialBounds() {
        if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
            long l = this.topHandle();
            GtkAllocation gtkAllocation = new GtkAllocation();
            gtkAllocation.x = (this.parent.style & 0x8000000) != 0 ? this.parent.getClientWidth() : 0;
            gtkAllocation.y = 0;
            GTK.gtk_widget_set_visible(l, true);
            if (GTK.GTK4) {
                GTK4.gtk_widget_size_allocate(l, gtkAllocation, -1);
            } else {
                GTK.gtk_widget_get_preferred_size(l, null, null);
                GTK3.gtk_widget_set_allocation(l, gtkAllocation);
            }
        } else {
            super.setInitialBounds();
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            this.error(5);
        }
        this.items[n] = string;
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove(this.handle, n);
        }
        this.gtk_combo_box_insert(string, n);
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0L) {
            GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    public void setItems(String ... stringArray) {
        int n;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n] != null) continue;
            this.error(5);
        }
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        this.clearText();
        this.gtk_combo_box_text_remove_all();
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            this.gtk_combo_box_insert(string, n);
            if ((this.style & 0x4000000) == 0 || this.popupHandle == 0L) continue;
            GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2L);
        }
    }

    private void gtk_combo_box_text_remove_all() {
        this.gtk_combo_box_toggle_wrap(false);
        if (this.handle != 0L) {
            GTK.gtk_combo_box_text_remove_all(this.handle);
        }
        this.gtk_combo_box_toggle_wrap(true);
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            GTK.gtk_combo_box_popup(this.handle);
        } else {
            GTK.gtk_combo_box_popdown(this.handle);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.entryHandle != 0L) {
                GTK.gtk_widget_set_direction(this.entryHandle, n);
            }
            if (this.cellHandle != 0L) {
                GTK.gtk_widget_set_direction(this.cellHandle, n);
            }
            if (!bl && this.popupHandle != 0L) {
                GTK3.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, n);
            }
        }
    }

    @Override
    public void setOrientation(int n) {
        super.setOrientation(n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0L) {
            long l = 0L;
            if (GTK.GTK4) {
                long l2 = GTK4.gtk_entry_get_buffer(this.entryHandle);
                l = GTK.gtk_entry_buffer_get_text(l2);
            } else {
                l = GTK3.gtk_entry_get_text(this.entryHandle);
            }
            int n = (int)OS.g_utf16_offset_to_utf8_offset(l, point.x);
            int n2 = (int)OS.g_utf16_offset_to_utf8_offset(l, point.y);
            GTK.gtk_editable_set_position(this.entryHandle, n);
            GTK.gtk_editable_select_region(this.entryHandle, n, n2);
        }
    }

    public void setText(String string) {
        long l;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n == -1) {
                return;
            }
            this.select(n);
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, (int)OS.g_utf16_strlen(l = GTK3.gtk_entry_get_text(this.entryHandle), -1L))) == null) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs(string, true);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        if (GTK.GTK4) {
            long l2 = GTK4.gtk_entry_get_buffer(this.entryHandle);
            GTK.gtk_entry_buffer_set_text(l2, byArray, string.length());
        } else {
            GTK3.gtk_entry_set_text(this.entryHandle, byArray);
        }
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 6L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 13L);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0L, 0L, 26L);
        this.sendEvent(24);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0L) {
            GTK.gtk_entry_set_max_length(this.entryHandle, n);
        }
    }

    @Override
    void setToolTipText(Shell shell, String string) {
        if (this.entryHandle != 0L) {
            this.setToolTipText(this.entryHandle, string);
        }
        if (this.buttonHandle != 0L) {
            this.setToolTipText(this.buttonHandle, string);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    boolean translateTraversal(long l) {
        int[] nArray = new int[1];
        if (GTK.GTK4) {
            nArray[0] = GDK.gdk_key_event_get_keyval(l);
        } else {
            GDK.gdk_event_get_keyval(l, nArray);
        }
        switch (nArray[0]) {
            case 65293: 
            case 65421: {
                long l2 = this.imContext();
                if (l2 == 0L) break;
                long[] lArray = new long[1];
                GTK.gtk_im_context_get_preedit_string(l2, lArray, null, null);
                if (lArray[0] == 0L) break;
                int n = C.strlen(lArray[0]);
                OS.g_free(lArray[0]);
                if (n == 0) break;
                return false;
            }
        }
        return super.translateTraversal(l);
    }

    void updateCss() {
        String string;
        if (this.cssProvider == 0L) {
            long l;
            this.cssProvider = GTK.gtk_css_provider_new();
            if (this.menuHandle != 0L) {
                l = GTK.gtk_widget_get_style_context(this.menuHandle);
                GTK.gtk_style_context_add_provider(l, this.cssProvider, 600);
            }
            if (this.buttonHandle != 0L) {
                l = GTK.gtk_widget_get_style_context(this.buttonHandle);
                GTK.gtk_style_context_add_provider(l, this.cssProvider, 600);
            }
            if (this.entryHandle != 0L) {
                l = GTK.gtk_widget_get_style_context(this.entryHandle);
                GTK.gtk_style_context_add_provider(l, this.cssProvider, 600);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.background != null) {
            string = this.display.gtk_rgba_to_css_string(this.background);
            stringBuilder.append("* {background: " + string + ";}\n");
            stringBuilder.append("menu {background: " + string + ";}\n");
            String string2 = this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_SELECTION_RGBA);
            String string3 = this.display.gtk_rgba_to_css_string(this.display.COLOR_LIST_SELECTION_TEXT_RGBA);
            stringBuilder.append("entry selection {background-color: " + string2 + ";}\n");
            stringBuilder.append("entry selection {color: " + string3 + ";}\n");
        }
        if (this.foreground != null) {
            string = this.display.gtk_rgba_to_css_string(this.foreground);
            stringBuilder.append("* {color: " + string + ";}\n");
        }
        if (GTK.GTK4) {
            GTK4.gtk_css_provider_load_from_data(this.cssProvider, Converter.wcsToMbcs(stringBuilder.toString(), true), -1L);
        } else {
            GTK3.gtk_css_provider_load_from_data(this.cssProvider, Converter.wcsToMbcs(stringBuilder.toString(), true), -1L, null);
        }
    }

    String verifyText(String string, int n, int n2) {
        long l;
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        long l2 = l = GTK.GTK4 ? 0L : GTK3.gtk_get_current_event();
        if (l != 0L) {
            int n3 = GDK.gdk_event_get_event_type(l);
            n3 = Combo.fixGdkEventTypeValues(n3);
            switch (n3) {
                case 8: {
                    this.setKeyState(event, l);
                }
            }
            this.gdk_event_free(l);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

