/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.JSON;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.GDBus;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.internal.webkit.GdkRectangle;
import org.eclipse.swt.internal.webkit.WebKitGTK;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    long webView;
    long pageId;
    int failureCount;
    int lastKeyCode;
    int lastCharCode;
    boolean ignoreDispose;
    boolean tlsError;
    long tlsErrorCertificate;
    String tlsErrorUriString;
    URI tlsErrorUri;
    String tlsErrorType;
    boolean firstLoad = true;
    static boolean FirstCreate = true;
    private static Browser parentBrowser;
    static final int ASYNC_EXEC_TIMEOUT_MS = 10000;
    static boolean bug522733FirstInstanceCreated;
    static AtomicInteger w2_bug527738LastRequestCounter;
    private static int nonBlockingEvaluate;
    static Map<LONG, Integer> webKitDownloadStatus;
    static final String ABOUT_BLANK = "about:blank";
    static final String CLASSNAME_EXTERNAL = "External";
    static final String FUNCTIONNAME_CALLJAVA = "callJava";
    static final String HEADER_CONTENTTYPE = "content-type";
    static final String MIMETYPE_FORMURLENCODED = "application/x-www-form-urlencoded";
    static final String OBJECTNAME_EXTERNAL = "external";
    static final String PROPERTY_LENGTH = "length";
    static final String PROPERTY_PROXYHOST = "network.proxy_host";
    static final String PROPERTY_PROXYPORT = "network.proxy_port";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_FILEROOT = "file:///";
    static final String USER_AGENT = "user-agent";
    static final int MAX_PORT = 65535;
    static final int MAX_PROGRESS = 100;
    static final int[] MIN_VERSION;
    static final int SENTINEL_KEYPRESS = -1;
    static final char SEPARATOR_FILE;
    static final int STOP_PROPOGATE = 1;
    static final String DOMEVENT_DRAGSTART = "dragstart";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_KEYPRESS = "keypress";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEOUT = "mouseout";
    static final String DOMEVENT_MOUSEOVER = "mouseover";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final byte[] SWT_PROTOCOL;
    static final byte[] JSON_MIME_TYPE;
    static final int NOTIFY_PROGRESS = 1;
    static final int NOTIFY_TITLE = 2;
    static final int CREATE_WEB_VIEW = 3;
    static final int WEB_VIEW_READY = 4;
    static final int CLOSE_WEB_VIEW = 5;
    static final int LOAD_CHANGED = 6;
    static final int DECIDE_POLICY = 7;
    static final int MOUSE_TARGET_CHANGED = 8;
    static final int CONTEXT_MENU = 9;
    static final int AUTHENTICATE = 10;
    static final int DECIDE_DESTINATION = 11;
    static final int FAILED = 12;
    static final int FINISHED = 13;
    static final int DOWNLOAD_STARTED = 14;
    static final int WIDGET_EVENT = 15;
    static final int LOAD_FAILED_TLS = 16;
    static final String KEY_CHECK_SUBWINDOW = "org.eclipse.swt.internal.control.checksubwindow";
    static final String SWT_WEBKITGTK_VERSION = "org.eclipse.swt.internal.webkitgtk.version";
    static Callback Proc2;
    static Callback Proc3;
    static Callback Proc4;
    static Callback Proc5;
    static Callback JSDOMEventProc;
    static Callback RequestProc;
    static final boolean ignoreTls;

    WebKit() {
    }

    @Override
    public void createFunction(BrowserFunction browserFunction) {
        super.createFunction(browserFunction);
        this.updateUserScript();
    }

    @Override
    public void destroyFunction(BrowserFunction browserFunction) {
        super.destroyFunction(browserFunction);
        this.updateUserScript();
    }

    void updateUserScript() {
        long l = WebKitGTK.webkit_web_view_get_user_content_manager(this.webView);
        WebKitGTK.webkit_user_content_manager_remove_all_scripts(l);
        if (!this.functions.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (BrowserFunction browserFunction : this.functions.values()) {
                stringBuilder.append(browserFunction.functionString);
            }
            stringBuilder.append('\u0000');
            Object object = stringBuilder.toString().getBytes(StandardCharsets.UTF_8);
            long l2 = WebKitGTK.webkit_user_script_new((byte[])object, 0, 1, 0L, 0L);
            WebKitGTK.webkit_user_content_manager_add_script(l, l2);
            WebKitGTK.webkit_user_script_unref(l2);
        }
    }

    private static String getInternalErrorMsg() {
        String string = "Please report this issue *with steps to reproduce* via:\n https://bugs.eclipse.org/bugs/enter_bug.cgi?alias=&assigned_to=platform-swt-inbox%40eclipse.org&attach_text=&blocked=&bug_file_loc=http%3A%2F%2F&bug_severity=normal&bug_status=NEW&comment=&component=SWT&contenttypeentry=&contenttypemethod=autodetect&contenttypeselection=text%2Fplain&data=&defined_groups=1&dependson=&description=&flag_type-1=X&flag_type-11=X&flag_type-12=X&flag_type-13=X&flag_type-14=X&flag_type-15=X&flag_type-16=X&flag_type-2=X&flag_type-4=X&flag_type-6=X&flag_type-7=X&flag_type-8=X&form_name=enter_bug&keywords=&maketemplate=Remember%20values%20as%20bookmarkable%20template&op_sys=Linux&product=Platform&qa_contact=&rep_platform=PC&requestee_type-1=&requestee_type-2=&short_desc=webkit2_BrowserProblem";
        return string + "\nFor bug report, please atatch this stack trace:\n" + WebKit.getStackTrace();
    }

    private static String getStackTrace() {
        StringWriter stringWriter = new StringWriter();
        new Throwable("").printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Override
    String getJavaCallDeclaration() {
        return "if (!window.callJava) { window.callJava = function(index, token, args) {\nvar xhr = new XMLHttpRequest();\nvar uri = 'swt://browserfunction/' + index + '/' + token + '?' + encodeURIComponent(JSON.stringify(args));\nxhr.open('POST', uri, false);\nxhr.send(null);\nreturn JSON.parse(xhr.responseText);\n}}\n";
    }

    private static int[] internalGetWebkitVersion() {
        int[] nArray = new int[]{WebKitGTK.webkit_get_major_version(), WebKitGTK.webkit_get_minor_version(), WebKitGTK.webkit_get_micro_version()};
        return nArray;
    }

    private static String internalGetWebKitVersionStr() {
        int[] nArray = WebKit.internalGetWebkitVersion();
        return String.valueOf(nArray[0]) + "." + String.valueOf(nArray[1]) + "." + String.valueOf(nArray[2]);
    }

    static String getString(long l) {
        int n = C.strlen(l);
        byte[] byArray = new byte[n];
        C.memmove(byArray, l, (long)n);
        return new String(Converter.mbcsToWcs(byArray));
    }

    static Browser FindBrowser(long l) {
        if (l == 0L) {
            return null;
        }
        long l2 = GTK.gtk_widget_get_parent(l);
        return (Browser)Display.getCurrent().findWidget(l2);
    }

    static boolean IsInstalled() {
        if (!WebKitGTK.LibraryLoaded) {
            return false;
        }
        int[] nArray = WebKit.internalGetWebkitVersion();
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        return n > MIN_VERSION[0] || n == MIN_VERSION[0] && n2 > MIN_VERSION[1] || n == MIN_VERSION[0] && n2 == MIN_VERSION[1] && n3 >= MIN_VERSION[2];
    }

    static long JSDOMEventProc(long l, long l2, long l3) {
        block19: {
            block20: {
                Browser browser;
                block21: {
                    if (l3 != 15L) break block19;
                    browser = WebKit.FindBrowser(l);
                    if (browser == null || l3 != 15L) break block20;
                    block2 : switch (GDK.GDK_EVENT_TYPE(l2)) {
                        case 8: {
                            if (!browser.isFocusControl()) break;
                            int[] nArray = new int[1];
                            int[] nArray2 = new int[1];
                            if (GTK.GTK4) {
                                nArray[0] = GDK.gdk_key_event_get_keyval(l2);
                                nArray2[0] = GDK.gdk_event_get_modifier_state(l2);
                            } else {
                                GDK.gdk_event_get_keyval(l2, nArray);
                                GDK.gdk_event_get_state(l2, nArray2);
                            }
                            switch (nArray[0]) {
                                case 65056: 
                                case 65289: {
                                    if ((nArray2[0] & 0xC) == 0) {
                                        browser.getDisplay().asyncExec(() -> {
                                            if (browser.isDisposed()) {
                                                return;
                                            }
                                            if (browser.getDisplay().getFocusControl() == null) {
                                                int n = (nArray2[0] & 1) != 0 ? 8 : 16;
                                                browser.traverse(n);
                                            }
                                        });
                                        break block2;
                                    }
                                    break block21;
                                }
                                case 65307: {
                                    Event event = new Event();
                                    event.widget = browser;
                                    event.type = 1;
                                    event.character = (char)27;
                                    event.keyCode = 27;
                                    if ((nArray2[0] & 8) != 0) {
                                        event.stateMask |= 0x10000;
                                    }
                                    if ((nArray2[0] & 1) != 0) {
                                        event.stateMask |= 0x20000;
                                    }
                                    if ((nArray2[0] & 4) != 0) {
                                        event.stateMask |= 0x40000;
                                    }
                                    try {
                                        ++nonBlockingEvaluate;
                                        browser.webBrowser.sendKeyEvent(event);
                                    }
                                    catch (Exception exception) {
                                        throw exception;
                                    }
                                    finally {
                                        --nonBlockingEvaluate;
                                    }
                                    return 1L;
                                }
                            }
                        }
                    }
                }
                if (browser != null) {
                    GTK3.gtk_widget_event(browser.handle, l2);
                }
            }
            return 0L;
        }
        return 0L;
    }

    static long RequestProc(long l, long l2) {
        Object object;
        String string = "null";
        long l3 = WebKitGTK.webkit_uri_scheme_request_get_web_view(l);
        Browser browser = WebKit.FindBrowser(l3);
        if (browser != null) {
            Object object2;
            object = null;
            Object[] objectArray = null;
            long l4 = WebKitGTK.webkit_uri_scheme_request_get_uri(l);
            String string2 = Converter.cCharPtrToJavaString(l4, false);
            try {
                object2 = new URI(string2);
                String[] stringArray = ((URI)object2).getPath().split("/");
                int n = Integer.parseInt(stringArray[1]);
                String string3 = stringArray[2];
                WebKit webKit = (WebKit)browser.webBrowser;
                object = (BrowserFunction)webKit.functions.get(n);
                if (object != null && !object.token.equals(string3)) {
                    object = null;
                }
                objectArray = (Object[])JSON.parse(((URI)object2).getQuery());
            }
            catch (ClassCastException | IllegalArgumentException | IndexOutOfBoundsException | URISyntaxException exception) {
                // empty catch block
            }
            if (object != null) {
                try {
                    object2 = object.function(objectArray);
                }
                catch (Exception exception) {
                    object2 = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                }
                string = JSON.stringify(object2);
            }
        }
        object = new long[1];
        long l5 = OS.g_utf16_to_utf8(string.toCharArray(), string.length(), null, object, null);
        long l6 = OS.g_memory_input_stream_new_from_data(l5, object[0], OS.addressof_g_free());
        WebKitGTK.webkit_uri_scheme_request_finish(l, l6, object[0], JSON_MIME_TYPE);
        OS.g_object_unref(l6);
        return 0L;
    }

    static long Proc(long l, long l2) {
        long l3 = l;
        if (l2 == 13L) {
            long l4 = l;
            return WebKit.webkit_download_finished(l4);
        }
        Browser browser = WebKit.FindBrowser(l3);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2);
    }

    static long Proc(long l, long l2, long l3) {
        if (l3 == 14L) {
            long l4 = l2;
            WebKit.webkit_download_started(l4);
            return 0L;
        }
        if (l3 == 11L) {
            long l5 = l;
            long l6 = l2;
            return WebKit.webkit_download_decide_destination(l5, l6);
        }
        if (l3 == 12L) {
            long l7 = l;
            return WebKit.webkit_download_failed(l7);
        }
        assert (l != 0L) : "Webview shouldn't be null here";
        long l8 = l;
        Browser browser = WebKit.FindBrowser(l8);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l8, l2, l3);
    }

    static long Proc(long l, long l2, long l3, long l4) {
        Browser browser = WebKit.FindBrowser(l);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2, l3, l4);
    }

    static long Proc(long l, long l2, long l3, long l4, long l5) {
        long l6 = l;
        Browser browser = WebKit.FindBrowser(l6);
        if (browser == null) {
            return 0L;
        }
        WebKit webKit = (WebKit)browser.webBrowser;
        return webKit.webViewProc(l, l2, l3, l4, l5);
    }

    long webkit_authenticate(long l, long l2) {
        if (!WebKitGTK.webkit_authentication_request_is_retry(l2)) {
            this.failureCount = 0;
        } else if (++this.failureCount >= 3) {
            return 0L;
        }
        String string = this.getUrl();
        for (int i = 0; i < this.authenticationListeners.length; ++i) {
            AuthenticationEvent authenticationEvent = new AuthenticationEvent(this.browser);
            authenticationEvent.location = string;
            try {
                ++nonBlockingEvaluate;
                this.authenticationListeners[i].authenticate(authenticationEvent);
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                --nonBlockingEvaluate;
            }
            if (!authenticationEvent.doit) {
                WebKitGTK.webkit_authentication_request_cancel(l2);
                return 0L;
            }
            if (authenticationEvent.user == null || authenticationEvent.password == null) continue;
            byte[] byArray = Converter.wcsToMbcs(authenticationEvent.user, true);
            byte[] byArray2 = Converter.wcsToMbcs(authenticationEvent.password, true);
            long l3 = WebKitGTK.webkit_credential_new(byArray, byArray2, 0);
            WebKitGTK.webkit_authentication_request_authenticate(l2, l3);
            WebKitGTK.webkit_credential_free(l3);
            return 0L;
        }
        return 0L;
    }

    long webViewProc(long l, long l2) {
        switch ((int)l2) {
            case 5: {
                return this.webkit_close_web_view(l);
            }
            case 4: {
                return this.webkit_web_view_ready(l);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3) {
        switch ((int)l3) {
            case 3: {
                return this.webkit_create_web_view(l, l2);
            }
            case 6: {
                return this.webkit_load_changed(l, (int)l2, l3);
            }
            case 1: {
                return this.webkit_notify_progress(l, l2);
            }
            case 2: {
                return this.webkit_notify_title(l, l2);
            }
            case 10: {
                return this.webkit_authenticate(l, l2);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4) {
        switch ((int)l4) {
            case 8: {
                return this.webkit_mouse_target_changed(l, l2, l3);
            }
            case 7: {
                return this.webkit_decide_policy(l, l2, (int)l3, l4);
            }
        }
        return 0L;
    }

    long webViewProc(long l, long l2, long l3, long l4, long l5) {
        switch ((int)l5) {
            case 9: {
                return this.webkit_context_menu(l, l2, l3, l4);
            }
            case 16: {
                return this.webkit_load_failed_tls(l, l2, l3, l4);
            }
        }
        return 0L;
    }

    @Override
    public void create(Composite composite, int n) {
        int[] nArray = WebKit.internalGetWebkitVersion();
        System.setProperty(SWT_WEBKITGTK_VERSION, String.format("%s.%s.%s", nArray[0], nArray[1], nArray[2]));
        if (Device.DEBUG) {
            System.out.println(String.format("WebKit version %s.%s.%s", nArray[0], nArray[1], nArray[2]));
        }
        Webkit2AsyncToSync.setCookieBrowser(this.browser);
        if (FirstCreate) {
            FirstCreate = false;
            long l = WebKitGTK.webkit_web_context_get_default();
            WebKitGTK.webkit_web_context_register_uri_scheme(l, SWT_PROTOCOL, RequestProc.getAddress(), 0L, 0L);
            long l2 = WebKitGTK.webkit_web_context_get_security_manager(l);
            WebKitGTK.webkit_security_manager_register_uri_scheme_as_secure(l2, SWT_PROTOCOL);
        }
        Composite composite2 = composite.getParent();
        Browser browser = parentBrowser;
        if (browser == null && composite2 != null) {
            Control[] controlArray = composite2.getChildren();
            for (int i = 0; i < controlArray.length; ++i) {
                if (!(controlArray[i] instanceof Browser)) continue;
                browser = (Browser)controlArray[i];
                break;
            }
        }
        this.webView = browser == null ? WebKitGTK.webkit_web_view_new() : WebKitGTK.webkit_web_view_new_with_related_view(((WebKit)browser.webBrowser).webView);
        if (!bug522733FirstInstanceCreated && nArray[0] == 2 && nArray[1] >= 18) {
            bug522733FirstInstanceCreated = true;
            OS.g_object_ref(this.webView);
        }
        if (ignoreTls) {
            WebKitGTK.webkit_web_context_set_tls_errors_policy(WebKitGTK.webkit_web_view_get_context(this.webView), 0);
            System.out.println("***WARNING: WebKitGTK is configured to ignore TLS errors via -Dorg.eclipse.swt.internal.webkitgtk.ignoretlserrors=true .");
            System.out.println("***WARNING: Please use for development purposes only!");
        }
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.browser.handle, this.webView);
        } else {
            GTK3.gtk_container_add(this.browser.handle, this.webView);
        }
        OS.g_signal_connect(this.webView, WebKitGTK.close, Proc2.getAddress(), 5L);
        OS.g_signal_connect(this.webView, WebKitGTK.ready_to_show, Proc2.getAddress(), 4L);
        OS.g_signal_connect(this.webView, WebKitGTK.decide_policy, Proc4.getAddress(), 7L);
        OS.g_signal_connect(this.webView, WebKitGTK.mouse_target_changed, Proc4.getAddress(), 8L);
        OS.g_signal_connect(this.webView, WebKitGTK.context_menu, Proc5.getAddress(), 9L);
        OS.g_signal_connect(this.webView, WebKitGTK.load_failed_with_tls_errors, Proc5.getAddress(), 16L);
        OS.g_signal_connect(this.webView, WebKitGTK.create, Proc3.getAddress(), 3L);
        OS.g_signal_connect(this.webView, WebKitGTK.load_changed, Proc3.getAddress(), 6L);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_estimated_load_progress, Proc3.getAddress(), 1L);
        OS.g_signal_connect(this.webView, WebKitGTK.authenticate, Proc3.getAddress(), 10L);
        OS.g_signal_connect(WebKitGTK.webkit_web_context_get_default(), WebKitGTK.download_started, Proc3.getAddress(), 14L);
        GTK.gtk_widget_show(this.webView);
        GTK.gtk_widget_show(this.browser.handle);
        OS.g_signal_connect(this.webView, WebKitGTK.notify_title, Proc3.getAddress(), 2L);
        if (!GTK.GTK4) {
            OS.g_signal_connect(this.webView, OS.button_press_event, JSDOMEventProc.getAddress(), 15L);
            OS.g_signal_connect(this.webView, OS.button_release_event, JSDOMEventProc.getAddress(), 15L);
            OS.g_signal_connect(this.webView, OS.focus_in_event, JSDOMEventProc.getAddress(), 15L);
            OS.g_signal_connect(this.webView, OS.focus_out_event, JSDOMEventProc.getAddress(), 15L);
        }
        this.pageId = WebKitGTK.webkit_web_view_get_page_id(this.webView);
        if (!GTK.GTK4) {
            OS.g_signal_connect(this.webView, OS.key_press_event, JSDOMEventProc.getAddress(), 15L);
            OS.g_signal_connect(this.webView, OS.key_release_event, JSDOMEventProc.getAddress(), 15L);
            OS.g_signal_connect(this.webView, OS.scroll_event, JSDOMEventProc.getAddress(), 15L);
            OS.g_signal_connect(this.webView, OS.motion_notify_event, JSDOMEventProc.getAddress(), 15L);
        }
        byte[] byArray = Converter.wcsToMbcs("UTF-8", true);
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(l, WebKitGTK.javascript_can_open_windows_automatically, 1, 0L);
        OS.g_object_set(l, WebKitGTK.enable_webgl, 1, 0L);
        OS.g_object_set(l, WebKitGTK.enable_developer_extras, 1, 0L);
        OS.g_object_set(l, WebKitGTK.default_charset, byArray, 0L);
        if (WebKitGTK.webkit_get_minor_version() >= 14) {
            OS.g_object_set(l, WebKitGTK.allow_universal_access_from_file_urls, 1, 0L);
            if (WebKitGTK.webkit_get_minor_version() >= 24) {
                OS.g_object_set(l, WebKitGTK.enable_back_forward_navigation_gestures, 1, 0L);
            }
        } else {
            System.err.println("SWT WEBKIT: Warning, you are using Webkitgtk below version 2.14. Your version is: Your version is: " + WebKit.internalGetWebKitVersionStr() + "\nJavascript execution limited to same origin due to unimplemented feature of this version.");
        }
        Listener listener = event -> {
            switch (event.type) {
                case 12: {
                    if (this.ignoreDispose) {
                        this.ignoreDispose = false;
                        break;
                    }
                    this.ignoreDispose = true;
                    this.browser.notifyListeners(event.type, event);
                    event.type = 0;
                    this.onDispose(event);
                    break;
                }
                case 15: {
                    if (this.webView == 0L) break;
                    GTK.gtk_widget_grab_focus(this.webView);
                    break;
                }
                case 11: {
                    this.onResize(event);
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        this.browser.addListener(11, listener);
        this.browser.setData(KEY_CHECK_SUBWINDOW, Boolean.FALSE);
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n2 == 1 && n3 >= 10) {
            Rectangle rectangle = this.browser.computeTrim(0, 0, 2, 2);
            Point point = this.browser.getSize();
            point.x += rectangle.width;
            point.y += rectangle.height;
            this.browser.setSize(point);
            point.x -= rectangle.width;
            point.y -= rectangle.height;
            this.browser.setSize(point);
        }
    }

    @Override
    public boolean back() {
        if (WebKitGTK.webkit_web_view_can_go_back(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_back(this.webView);
        return true;
    }

    @Override
    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        Boolean bl2;
        if (!this.jsEnabled || !this.jsEnabledOnNextPage) {
            return true;
        }
        String string = Compatibility.getMessage("SWT_OnBeforeUnload_Message1");
        String string2 = Compatibility.getMessage("SWT_OnBeforeUnload_Message2");
        String string3 = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuilder stringBuilder = new StringBuilder("function ");
        stringBuilder.append(string3);
        stringBuilder.append("(win) {\n");
        stringBuilder.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuilder.append("if (str != null) { ");
            stringBuilder.append("var result = confirm('");
            stringBuilder.append(string);
            stringBuilder.append("\\n\\n'+str+'\\n\\n");
            stringBuilder.append(string2);
            stringBuilder.append("');");
            stringBuilder.append("if (!result) return false;}");
        }
        stringBuilder.append("} catch (e) {}}");
        stringBuilder.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuilder.append(string3);
        stringBuilder.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuilder.append("\n};");
        this.nonBlockingExecute(stringBuilder.toString());
        try {
            bl2 = (Boolean)this.evaluate("return " + string3 + "(window);");
            if (bl2 == null) {
                return true;
            }
        }
        catch (SWTException sWTException) {
            return true;
        }
        return bl2;
    }

    private boolean isJavascriptEnabled() {
        return this.webkit_settings_get(WebKitGTK.enable_javascript) != 0;
    }

    @Override
    void nonBlockingExecute(String string) {
        try {
            ++nonBlockingEvaluate;
            this.execute(string);
        }
        finally {
            --nonBlockingEvaluate;
        }
    }

    @Override
    public boolean execute(String string) {
        if (!this.isJavascriptEnabled()) {
            System.err.println("SWT Webkit Warning: Attempting to execute javascript when javascript is dissabled.Execution has no effect. Script:\n" + string);
            return false;
        }
        try {
            Webkit2AsyncToSync.runjavascript(string, this.browser, this.webView);
        }
        catch (SWTException sWTException) {
            return false;
        }
        return true;
    }

    @Override
    public Object evaluate(String string) throws SWTException {
        if ("".equals(string)) {
            return null;
        }
        if (!this.isJavascriptEnabled()) {
            return null;
        }
        return Webkit2AsyncToSync.evaluate(string, this.browser, this.webView);
    }

    @Override
    public boolean forward() {
        if (this.webView == 0L) {
            assert (false);
            System.err.println("SWT Webkit: forward() called after widget disposed. Should not have happened.\n" + WebKit.getInternalErrorMsg());
            return false;
        }
        if (WebKitGTK.webkit_web_view_can_go_forward(this.webView) == 0) {
            return false;
        }
        WebKitGTK.webkit_web_view_go_forward(this.webView);
        return true;
    }

    @Override
    public String getBrowserType() {
        return "webkit";
    }

    @Override
    public String getText() {
        return Webkit2AsyncToSync.getText(this.browser, this.webView);
    }

    @Override
    public String getUrl() {
        if (this.webView == 0L) {
            assert (false);
            System.err.println("SWT Webkit: getUrl() called after widget disposed. Should not have happened.\n" + WebKit.getInternalErrorMsg());
            return null;
        }
        long l = WebKitGTK.webkit_web_view_get_uri(this.webView);
        if (l == 0L) {
            return ABOUT_BLANK;
        }
        int n = C.strlen(l);
        byte[] byArray = new byte[n];
        C.memmove(byArray, l, (long)n);
        Object object = new String(Converter.mbcsToWcs(byArray));
        if (((String)object).equals(URI_FILEROOT)) {
            object = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (((String)object).startsWith(URI_FILEROOT) && ((String)object).charAt(n) == '#') {
                object = ABOUT_BLANK + ((String)object).substring(n);
            }
        }
        return object;
    }

    boolean handleDOMEvent(long l, int n) {
        int n2;
        String string = null;
        boolean bl = false;
        switch (n) {
            case 29: {
                string = DOMEVENT_DRAGSTART;
                bl = true;
                break;
            }
            case 3: {
                string = DOMEVENT_MOUSEDOWN;
                bl = true;
                break;
            }
            case 5: {
                string = DOMEVENT_MOUSEMOVE;
                bl = true;
                break;
            }
            case 4: {
                string = DOMEVENT_MOUSEUP;
                bl = true;
                break;
            }
            case 37: {
                string = DOMEVENT_MOUSEWHEEL;
                bl = true;
                break;
            }
            case 1: {
                string = DOMEVENT_KEYDOWN;
                break;
            }
            case 2: {
                string = DOMEVENT_KEYUP;
                break;
            }
            case -1: {
                string = DOMEVENT_KEYPRESS;
            }
        }
        if (bl) {
            int n3 = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_x(l);
            int n4 = (int)WebKitGTK.webkit_dom_mouse_event_get_screen_y(l);
            int n5 = WebKitGTK.webkit_dom_mouse_event_get_button(l) + 1;
            boolean bl2 = WebKitGTK.webkit_dom_mouse_event_get_alt_key(l) != 0;
            boolean bl3 = WebKitGTK.webkit_dom_mouse_event_get_ctrl_key(l) != 0;
            boolean bl4 = WebKitGTK.webkit_dom_mouse_event_get_shift_key(l) != 0;
            boolean bl5 = WebKitGTK.webkit_dom_mouse_event_get_meta_key(l) != 0;
            int n6 = (int)WebKitGTK.webkit_dom_ui_event_get_detail(l);
            boolean bl6 = false;
            return this.handleMouseEvent(string, n3, n4, n6, n5, bl2, bl3, bl4, bl5, bl6);
        }
        int n7 = 0;
        long l2 = GTK3.gtk_get_current_event();
        if (l2 != 0L) {
            n2 = GDK.gdk_event_get_event_type(l2);
            int[] nArray = new int[1];
            if (GTK.GTK4) {
                nArray[0] = GDK.gdk_event_get_modifier_state(l2);
            } else {
                GDK.gdk_event_get_state(l2, nArray);
            }
            switch (n2) {
                case 8: 
                case 9: {
                    n7 = nArray[0];
                }
            }
            if (GTK.GTK4) {
                OS.g_object_unref(l2);
            } else {
                GDK.gdk_event_free(l2);
            }
        }
        n2 = (int)WebKitGTK.webkit_dom_ui_event_get_key_code(l);
        int n8 = (int)WebKitGTK.webkit_dom_ui_event_get_char_code(l);
        boolean bl7 = (n7 & 8) != 0;
        boolean bl8 = (n7 & 4) != 0;
        boolean bl9 = (n7 & 1) != 0;
        return this.handleKeyEvent(string, n2, n8, bl7, bl8, bl9, false);
    }

    boolean handleEventFromFunction(Object[] objectArray) {
        String string = (String)objectArray[0];
        if (string.equals(DOMEVENT_KEYDOWN) || string.equals(DOMEVENT_KEYPRESS) || string.equals(DOMEVENT_KEYUP)) {
            return this.handleKeyEvent(string, ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue(), (Boolean)objectArray[3], (Boolean)objectArray[4], (Boolean)objectArray[5], (Boolean)objectArray[6]);
        }
        return this.handleMouseEvent(string, ((Double)objectArray[1]).intValue(), ((Double)objectArray[2]).intValue(), ((Double)objectArray[3]).intValue(), (objectArray[4] != null ? ((Double)objectArray[4]).intValue() : 0) + 1, (Boolean)objectArray[5], (Boolean)objectArray[6], (Boolean)objectArray[7], (Boolean)objectArray[8], (Boolean)objectArray[9]);
    }

    boolean handleKeyEvent(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string.equals(DOMEVENT_KEYDOWN)) {
            this.lastKeyCode = n = this.translateKey(n);
            switch (n) {
                case 8: 
                case 9: 
                case 27: 
                case 127: 
                case 65536: 
                case 131072: 
                case 262144: 
                case 0x400000: 
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: 
                case 0x1000009: 
                case 0x100000A: 
                case 0x100000B: 
                case 0x100000C: 
                case 0x100000D: 
                case 0x100000E: 
                case 0x100000F: 
                case 0x1000010: 
                case 0x1000011: 
                case 0x1000012: 
                case 0x1000013: 
                case 0x1000014: 
                case 0x1000015: 
                case 16777298: 
                case 16777299: 
                case 16777300: 
                case 0x1000055: {
                    Event event = new Event();
                    event.widget = this.browser;
                    event.type = string.equals(DOMEVENT_KEYDOWN) ? 1 : 2;
                    event.keyCode = n;
                    switch (n) {
                        case 8: {
                            event.character = (char)8;
                            break;
                        }
                        case 127: {
                            event.character = (char)127;
                            break;
                        }
                        case 27: {
                            event.character = (char)27;
                            break;
                        }
                        case 9: {
                            event.character = (char)9;
                        }
                    }
                    this.lastCharCode = event.character;
                    event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
                    event.stateMask &= ~n;
                    int n3 = event.stateMask;
                    if (!this.sendKeyEvent(event) || this.browser.isDisposed()) {
                        return false;
                    }
                    if (!this.browser.isFocusControl() || n != 9 || (n3 & 0x50000) != 0) break;
                    this.browser.getDisplay().asyncExec(() -> {
                        if (this.browser.isDisposed()) {
                            return;
                        }
                        if (this.browser.getDisplay().getFocusControl() == null) {
                            int n2 = (n3 & 0x20000) != 0 ? 8 : 16;
                            this.browser.traverse(n2);
                        }
                    });
                    break;
                }
            }
            return true;
        }
        if (string.equals(DOMEVENT_KEYPRESS)) {
            if (this.lastKeyCode == 0) {
                return true;
            }
            this.lastCharCode = n2;
            if (bl2 && 0 <= this.lastCharCode && this.lastCharCode <= 127) {
                if (97 <= this.lastCharCode && this.lastCharCode <= 122) {
                    this.lastCharCode -= 32;
                }
                if (64 <= this.lastCharCode && this.lastCharCode <= 95) {
                    this.lastCharCode -= 64;
                }
            }
            Event event = new Event();
            event.widget = this.browser;
            event.type = 1;
            event.keyCode = this.lastKeyCode;
            event.character = (char)this.lastCharCode;
            event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
            return this.sendKeyEvent(event) && !this.browser.isDisposed();
        }
        if ((n = this.translateKey(n)) == 0) {
            return true;
        }
        if (n != this.lastKeyCode) {
            this.lastKeyCode = n;
            this.lastCharCode = 0;
        }
        Event event = new Event();
        event.widget = this.browser;
        event.type = 2;
        event.keyCode = this.lastKeyCode;
        event.character = (char)this.lastCharCode;
        event.stateMask = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
        switch (this.lastKeyCode) {
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: {
                event.stateMask |= this.lastKeyCode;
            }
        }
        this.browser.notifyListeners(event.type, event);
        this.lastCharCode = 0;
        this.lastKeyCode = 0;
        return event.doit && !this.browser.isDisposed();
    }

    boolean handleMouseEvent(String string, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n5;
        Point point = new Point(n, n2);
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = n5 = (bl ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl4 ? 0x400000 : 0);
        if (string.equals(DOMEVENT_MOUSEDOWN)) {
            event.type = 3;
            event.count = n3;
            event.button = n4;
            this.browser.notifyListeners(event.type, event);
            if (this.browser.isDisposed()) {
                return true;
            }
            if (n3 == 2) {
                event = new Event();
                event.type = 8;
                event.widget = this.browser;
                event.x = point.x;
                event.y = point.y;
                event.stateMask = n5;
                event.count = n3;
                event.button = n4;
                this.browser.notifyListeners(event.type, event);
            }
            return true;
        }
        if (string.equals(DOMEVENT_MOUSEUP)) {
            event.type = 4;
            event.count = n3;
            event.button = n4;
        } else if (string.equals(DOMEVENT_MOUSEMOVE)) {
            event.type = 5;
        } else if (string.equals(DOMEVENT_MOUSEWHEEL)) {
            event.type = 37;
            event.count = n3;
        } else if (string.equals(DOMEVENT_DRAGSTART)) {
            event.type = 29;
            event.button = n4;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        }
        this.browser.notifyListeners(event.type, event);
        return true;
    }

    long handleLoadCommitted(long l, boolean bl) {
        int n = C.strlen(l);
        byte[] byArray = new byte[n];
        C.memmove(byArray, l, (long)n);
        Object object = new String(Converter.mbcsToWcs(byArray));
        if (((String)object).equals(URI_FILEROOT)) {
            object = ABOUT_BLANK;
        } else {
            n = URI_FILEROOT.length();
            if (((String)object).startsWith(URI_FILEROOT) && ((String)object).charAt(n) == '#') {
                object = ABOUT_BLANK + ((String)object).substring(n);
            }
        }
        LocationEvent locationEvent = new LocationEvent(this.browser);
        locationEvent.display = this.browser.getDisplay();
        locationEvent.widget = this.browser;
        locationEvent.location = object;
        locationEvent.top = bl;
        Runnable runnable = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            for (int i = 0; i < this.locationListeners.length; ++i) {
                this.locationListeners[i].changed(locationEvent);
            }
        };
        this.browser.getDisplay().asyncExec(runnable);
        return 0L;
    }

    private void fireProgressCompletedEvent() {
        Runnable runnable = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            ProgressEvent progressEvent = new ProgressEvent(this.browser);
            progressEvent.display = this.browser.getDisplay();
            progressEvent.widget = this.browser;
            progressEvent.current = 100;
            progressEvent.total = 100;
            for (int i = 0; i < this.progressListeners.length; ++i) {
                this.progressListeners[i].completed(progressEvent);
            }
        };
        this.browser.getDisplay().asyncExec(runnable);
    }

    @Override
    public boolean isBackEnabled() {
        if (this.webView == 0L) {
            return false;
        }
        return WebKitGTK.webkit_web_view_can_go_back(this.webView) != 0;
    }

    @Override
    public boolean isForwardEnabled() {
        return WebKitGTK.webkit_web_view_can_go_forward(this.webView) != 0;
    }

    void onDispose(Event event) {
        if (!this.browser.isDisposed() && !this.browser.isClosing) {
            this.close(false);
        }
        for (BrowserFunction browserFunction : this.functions.values()) {
            browserFunction.dispose(false);
        }
        this.functions = null;
        if (WebKitGTK.webkit_get_minor_version() >= 18) {
            OS.g_object_ref(this.webView);
            if (GTK.GTK4) {
                GTK.gtk_widget_unparent(this.webView);
            } else {
                GTK3.gtk_container_remove(GTK.gtk_widget_get_parent(this.webView), this.webView);
            }
            long l = this.webView;
            Display.getDefault().asyncExec(() -> OS.g_object_unref(l));
            this.webView = 0L;
        }
    }

    void onResize(Event event) {
        Rectangle rectangle = DPIUtil.autoScaleUp(this.browser.getClientArea());
        if (this.webView == 0L) {
            return;
        }
        GTK.gtk_widget_set_size_request(this.webView, rectangle.width, rectangle.height);
    }

    void openDownloadWindow(final long l, String string) {
        final Shell shell = new Shell();
        String string2 = Compatibility.getMessage("SWT_FileDownload");
        shell.setText(string2);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        shell.setLayout(gridLayout);
        String string3 = string;
        long l2 = WebKitGTK.webkit_download_get_request(l);
        long l3 = WebKitGTK.webkit_uri_request_get_uri(l2);
        int n = C.strlen(l3);
        byte[] byArray = new byte[n];
        C.memmove(byArray, l3, (long)n);
        String string4 = new String(Converter.mbcsToWcs(byArray));
        string2 = Compatibility.getMessage("SWT_Download_Location", new Object[]{string3, string4});
        Label label = new Label(shell, 64);
        label.setText(string2);
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n2 = monitor.getBounds().width / 2;
        int n3 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n3, n2);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        final Label label2 = new Label(shell, 0);
        label2.setText(Compatibility.getMessage("SWT_Download_Started"));
        gridData = new GridData(1808);
        label2.setLayoutData(gridData);
        final Button button = new Button(shell, 8);
        button.setText(Compatibility.getMessage("SWT_Cancel"));
        gridData = new GridData();
        gridData.horizontalAlignment = 2;
        button.setLayoutData(gridData);
        final Listener listener = event -> {
            webKitDownloadStatus.put(new LONG(l), 2);
            WebKitGTK.webkit_download_cancel(l);
        };
        button.addListener(13, listener);
        OS.g_object_ref(l);
        final Display display = this.browser.getDisplay();
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                int n;
                int n2 = n = webKitDownloadStatus.containsKey(new LONG(l)) ? webKitDownloadStatus.get(new LONG(l)) : 0;
                if (shell.isDisposed() || n == 3 || n == 2) {
                    shell.dispose();
                    display.timerExec(-1, this);
                    OS.g_object_unref(l);
                    webKitDownloadStatus.remove(new LONG(l));
                    return;
                }
                if (n == -1) {
                    label2.setText(Compatibility.getMessage("SWT_Download_Error"));
                    display.timerExec(-1, this);
                    OS.g_object_unref(l);
                    button.removeListener(13, listener);
                    button.addListener(13, event -> shell.dispose());
                    webKitDownloadStatus.remove(new LONG(l));
                    return;
                }
                long l4 = WebKitGTK.webkit_download_get_received_data_length(l) / 1024L;
                long l2 = WebKitGTK.webkit_download_get_response(l);
                long l3 = WebKitGTK.webkit_uri_response_get_content_length(l2) / 1024L;
                String string = Compatibility.getMessage("SWT_Download_Status", new Object[]{l4, l3});
                label2.setText(string);
                display.timerExec(500, this);
            }
        });
        shell.pack();
        shell.open();
    }

    @Override
    public void refresh() {
        if (this.webView == 0L) {
            return;
        }
        WebKitGTK.webkit_web_view_reload(this.webView);
    }

    @Override
    public boolean setText(String string, boolean bl) {
        byte[] byArray = (string + "\u0000").getBytes(StandardCharsets.UTF_8);
        w2_bug527738LastRequestCounter.incrementAndGet();
        byte[] byArray2 = !bl ? Converter.wcsToMbcs(ABOUT_BLANK, true) : Converter.wcsToMbcs(URI_FILEROOT, true);
        WebKitGTK.webkit_web_view_load_html(this.webView, byArray, byArray2);
        return true;
    }

    @Override
    public boolean setUrl(String object, String string, String[] stringArray) {
        Object object2;
        String string2;
        Object object3;
        w2_bug527738LastRequestCounter.incrementAndGet();
        if (this.webView == 0L) {
            return false;
        }
        try {
            new URL((String)object);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = null;
            string3 = ((String)object).charAt(0) == SEPARATOR_FILE ? PROTOCOL_FILE + (String)object : PROTOCOL_HTTP + (String)object;
            try {
                new URL(string3);
                object = string3;
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                int n;
                object3 = stringArray[i];
                if (object3 == null || (n = ((String)object3).indexOf(58)) == -1) continue;
                string2 = ((String)object3).substring(0, n).trim();
                String string4 = ((String)object3).substring(n + 1).trim();
                if (string2.length() <= 0 || string4.length() <= 0 || !string2.equalsIgnoreCase(USER_AGENT)) continue;
                object2 = Converter.wcsToMbcs(string4, true);
                OS.g_object_set(l, WebKitGTK.user_agent, (byte[])object2, 0L);
            }
        }
        byte[] byArray = Converter.wcsToMbcs((String)object, true);
        if (string == null && stringArray != null) {
            long l2 = WebKitGTK.webkit_uri_request_new(byArray);
            long l3 = WebKitGTK.webkit_uri_request_get_http_headers(l2);
            if (l3 != 0L) {
                this.addRequestHeaders(l3, stringArray);
            }
            WebKitGTK.webkit_web_view_load_request(this.webView, l2);
            OS.g_object_set(l, WebKitGTK.user_agent, 0, 0L);
            return true;
        }
        if (string != null) {
            object3 = object;
            long[] lArray = new long[1];
            OS.g_object_get(l, WebKitGTK.user_agent, lArray, 0L);
            string2 = Converter.cCharPtrToJavaString(lArray[0], true);
            int n = w2_bug527738LastRequestCounter.incrementAndGet();
            object2 = new Thread(() -> this.lambda$setUrl$11((String)object3, string2, stringArray, string, n, byArray, l));
            ((Thread)object2).start();
        } else {
            WebKitGTK.webkit_web_view_load_uri(this.webView, byArray);
        }
        if (string == null) {
            OS.g_object_set(l, WebKitGTK.user_agent, 0, 0L);
        }
        return true;
    }

    @Override
    public void stop() {
        WebKitGTK.webkit_web_view_stop_loading(this.webView);
    }

    long webkit_close_web_view(long l) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        Runnable runnable = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            for (int i = 0; i < this.closeWindowListeners.length; ++i) {
                this.closeWindowListeners[i].close(windowEvent);
            }
            this.browser.dispose();
        };
        this.browser.getDisplay().asyncExec(runnable);
        return 0L;
    }

    long webkit_create_web_view(long l, long l2) {
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        Runnable runnable = () -> {
            if (this.openWindowListeners != null) {
                for (int i = 0; i < this.openWindowListeners.length; ++i) {
                    this.openWindowListeners[i].open(windowEvent);
                }
            }
        };
        try {
            ++nonBlockingEvaluate;
            parentBrowser = this.browser;
            runnable.run();
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            parentBrowser = null;
            --nonBlockingEvaluate;
        }
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            return ((WebKit)((Browser)widget).webBrowser).webView;
        }
        return 0L;
    }

    static long webkit_download_started(long l) {
        OS.g_signal_connect(l, WebKitGTK.decide_destination, Proc3.getAddress(), 11L);
        OS.g_signal_connect(l, WebKitGTK.failed, Proc3.getAddress(), 12L);
        OS.g_signal_connect(l, WebKitGTK.finished, Proc2.getAddress(), 13L);
        return 1L;
    }

    static long webkit_download_decide_destination(long l, long l2) {
        String string = WebKit.getString(l2);
        long l3 = WebKitGTK.webkit_download_get_web_view(l);
        if (l3 != 0L) {
            Browser browser = WebKit.FindBrowser(l3);
            if (browser == null || browser.isDisposed() || browser.isClosing) {
                return 0L;
            }
            FileDialog fileDialog = new FileDialog(browser.getShell(), 8192);
            fileDialog.setFileName(string);
            String string2 = Compatibility.getMessage("SWT_FileDownload");
            fileDialog.setText(string2);
            Object object = fileDialog.open();
            if (object != null) {
                object = URI_FILEROOT + (String)object;
                byte[] byArray = Converter.wcsToMbcs((String)object, true);
                if (WebKitGTK.webkit_get_minor_version() >= 6) {
                    WebKitGTK.webkit_download_set_allow_overwrite(l, true);
                }
                WebKitGTK.webkit_download_set_destination(l, byArray);
                ((WebKit)browser.webBrowser).openDownloadWindow(l, string);
            }
        }
        return 0L;
    }

    static long webkit_download_finished(long l) {
        if (!webKitDownloadStatus.containsKey(new LONG(l))) {
            webKitDownloadStatus.put(new LONG(l), 3);
        }
        return 0L;
    }

    static long webkit_download_failed(long l) {
        if (!webKitDownloadStatus.containsKey(new LONG(l))) {
            webKitDownloadStatus.put(new LONG(l), -1);
        }
        return 0L;
    }

    long webkit_mouse_target_changed(long l, long l2, long l3) {
        if (WebKitGTK.webkit_hit_test_result_context_is_link(l2)) {
            long l4 = WebKitGTK.webkit_hit_test_result_get_link_uri(l2);
            long l5 = WebKitGTK.webkit_hit_test_result_get_link_title(l2);
            return this.webkit_hovering_over_link(l, l5, l4);
        }
        return 0L;
    }

    long webkit_hovering_over_link(long l, long l2, long l3) {
        if (l3 != 0L) {
            int n = C.strlen(l3);
            byte[] byArray = new byte[n];
            C.memmove(byArray, l3, (long)n);
            String string = new String(Converter.mbcsToWcs(byArray));
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            Runnable runnable = () -> {
                if (this.browser.isDisposed() || this.statusTextListeners == null) {
                    return;
                }
                for (int i = 0; i < this.statusTextListeners.length; ++i) {
                    this.statusTextListeners[i].changed(statusTextEvent);
                }
            };
            this.browser.getDisplay().asyncExec(runnable);
        }
        return 0L;
    }

    long webkit_decide_policy(long l, long l2, int n, long l3) {
        switch (n) {
            case 0: {
                long l4 = WebKitGTK.webkit_navigation_policy_decision_get_request(l2);
                if (l4 == 0L) {
                    return 0L;
                }
                long l5 = WebKitGTK.webkit_uri_request_get_uri(l4);
                Object object = WebKit.getString(l5);
                if (((String)object).equals(URI_FILEROOT)) {
                    object = ABOUT_BLANK;
                } else {
                    int n2 = URI_FILEROOT.length();
                    if (((String)object).startsWith(URI_FILEROOT) && ((String)object).charAt(n2) == '#') {
                        object = ABOUT_BLANK + ((String)object).substring(n2);
                    }
                }
                LocationEvent locationEvent = new LocationEvent(this.browser);
                locationEvent.display = this.browser.getDisplay();
                locationEvent.widget = this.browser;
                locationEvent.location = object;
                locationEvent.doit = true;
                try {
                    ++nonBlockingEvaluate;
                    if (this.locationListeners != null) {
                        for (int i = 0; i < this.locationListeners.length; ++i) {
                            this.locationListeners[i].changing(locationEvent);
                        }
                    }
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    --nonBlockingEvaluate;
                }
                if (locationEvent.doit && !this.browser.isDisposed() && this.jsEnabled != this.jsEnabledOnNextPage) {
                    this.jsEnabled = this.jsEnabledOnNextPage;
                    this.webkit_settings_set(WebKitGTK.enable_javascript, this.jsEnabled ? 1 : 0);
                }
                if (locationEvent.doit) break;
                WebKitGTK.webkit_policy_decision_ignore(l2);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                boolean bl;
                long l6 = WebKitGTK.webkit_response_policy_decision_get_response(l2);
                long l7 = WebKitGTK.webkit_uri_response_get_mime_type(l6);
                boolean bl2 = bl = WebKitGTK.webkit_web_view_can_show_mime_type(this.webView, l7) != 0;
                if (bl) break;
                WebKitGTK.webkit_policy_decision_download(l2);
                return 1L;
            }
            default: {
                return 0L;
            }
        }
        return 0L;
    }

    long webkit_load_changed(long l, int n, long l2) {
        switch (n) {
            case 2: {
                long l3 = WebKitGTK.webkit_web_view_get_uri(this.webView);
                return this.handleLoadCommitted(l3, true);
            }
            case 3: {
                Object object;
                if (this.firstLoad) {
                    object = new GtkAllocation();
                    GTK.gtk_widget_get_allocation(this.browser.handle, (GtkAllocation)object);
                    if (GTK.GTK4) {
                        GTK4.gtk_widget_size_allocate(this.browser.handle, (GtkAllocation)object, -1);
                    } else {
                        GTK3.gtk_widget_size_allocate(this.browser.handle, (GtkAllocation)object);
                    }
                    this.firstLoad = false;
                }
                this.fireProgressCompletedEvent();
                if (this.tlsError && !ignoreTls) {
                    this.tlsError = false;
                    object = this.tlsErrorUri.getHost();
                    MessageBox messageBox = new MessageBox(this.browser.getShell(), 192);
                    messageBox.setText(SWT.getMessage("SWT_InvalidCert_Title"));
                    String string = this.tlsErrorType.isEmpty() ? "\n\n" : "\n\n" + this.tlsErrorType + "\n\n";
                    String string2 = SWT.getMessage("SWT_InvalidCert_Message", new Object[]{object}) + string + SWT.getMessage("SWT_InvalidCert_Connect");
                    messageBox.setMessage(string2);
                    int n2 = messageBox.open();
                    if (n2 == 64) {
                        long l4 = WebKitGTK.webkit_web_view_get_context(l);
                        if (object != null) {
                            byte[] byArray = Converter.javaStringToCString((String)object);
                            WebKitGTK.webkit_web_context_allow_tls_certificate_for_host(l4, this.tlsErrorCertificate, byArray);
                            WebKitGTK.webkit_web_view_reload(l);
                        } else {
                            System.err.println("***ERROR: Unable to parse host from URI!");
                        }
                    } else {
                        this.back();
                    }
                    if (this.tlsErrorCertificate != 0L) {
                        OS.g_object_unref(this.tlsErrorCertificate);
                        this.tlsErrorCertificate = 0L;
                    }
                }
                return 0L;
            }
        }
        return 0L;
    }

    long webkit_load_failed_tls(long l, long l2, long l3, long l4) {
        if (!ignoreTls) {
            this.tlsError = true;
            OS.g_object_ref(l3);
            this.tlsErrorCertificate = l3;
            this.convertUri(l2);
            switch ((int)l4) {
                case 0: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_UnknownCA");
                    break;
                }
                case 1: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_BadIdentity");
                    break;
                }
                case 2: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_NotActivated");
                    break;
                }
                case 3: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_Expired");
                    break;
                }
                case 4: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_Revoked");
                    break;
                }
                case 5: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_Insecure");
                    break;
                }
                case 6: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_GenericError");
                    break;
                }
                case 7: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_ValidateAll");
                    break;
                }
                default: {
                    this.tlsErrorType = SWT.getMessage("SWT_InvalidCert_GenericError");
                }
            }
        }
        return 0L;
    }

    void convertUri(long l) {
        try {
            this.tlsErrorUriString = Converter.cCharPtrToJavaString(l, false);
            this.tlsErrorUri = new URI(this.tlsErrorUriString);
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("***ERROR: Malformed URI from WebKit!");
            return;
        }
    }

    long webkit_notify_progress(long l, long l2) {
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = this.browser.getDisplay();
        progressEvent.widget = this.browser;
        double d = 0.0;
        d = WebKitGTK.webkit_web_view_get_estimated_load_progress(this.webView);
        progressEvent.current = (int)(d * 100.0);
        progressEvent.total = 100;
        Runnable runnable = () -> {
            if (this.browser.isDisposed() || this.progressListeners == null) {
                return;
            }
            for (int i = 0; i < this.progressListeners.length; ++i) {
                this.progressListeners[i].changed(progressEvent);
            }
        };
        this.browser.getDisplay().asyncExec(runnable);
        return 0L;
    }

    long webkit_notify_title(long l, long l2) {
        Object object;
        String string;
        long l3 = WebKitGTK.webkit_web_view_get_title(this.webView);
        if (l3 == 0L) {
            string = "";
        } else {
            int n = C.strlen(l3);
            object = new byte[n];
            C.memmove(object, l3, (long)n);
            string = new String(Converter.mbcsToWcs(object));
        }
        TitleEvent titleEvent = new TitleEvent(this.browser);
        titleEvent.display = this.browser.getDisplay();
        titleEvent.widget = this.browser;
        titleEvent.title = string;
        object = () -> {
            for (int i = 0; i < this.titleListeners.length; ++i) {
                this.titleListeners[i].changed(titleEvent);
            }
        };
        this.browser.getDisplay().asyncExec((Runnable)object);
        return 0L;
    }

    long webkit_context_menu(long l, long l2, long l3, long l4) {
        Point point = this.browser.getDisplay().getCursorLocation();
        Event event = new Event();
        event.x = point.x;
        event.y = point.y;
        this.browser.notifyListeners(35, event);
        if (!event.doit) {
            return 1L;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (point.x != event.x || point.y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 1L;
        }
        return 0L;
    }

    private void addRequestHeaders(long l, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string = stringArray[i];
            if (string == null || (n = string.indexOf(58)) == -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            if (string2.length() <= 0 || string3.length() <= 0) continue;
            byte[] byArray = Converter.wcsToMbcs(string2, true);
            byte[] byArray2 = Converter.wcsToMbcs(string3, true);
            WebKitGTK.soup_message_headers_append(l, byArray, byArray2);
        }
    }

    long webkit_web_view_ready(long l) {
        Object object;
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        long l2 = WebKitGTK.webkit_web_view_get_window_properties(this.webView);
        windowEvent.addressBar = this.webkit_settings_get(l2, WebKitGTK.locationbar_visible) != 0;
        windowEvent.menuBar = this.webkit_settings_get(l2, WebKitGTK.menubar_visible) != 0;
        windowEvent.statusBar = this.webkit_settings_get(l2, WebKitGTK.statusbar_visible) != 0;
        windowEvent.toolBar = this.webkit_settings_get(l2, WebKitGTK.toolbar_visible) != 0;
        GdkRectangle gdkRectangle = new GdkRectangle();
        WebKitGTK.webkit_window_properties_get_geometry(l2, gdkRectangle);
        windowEvent.location = new Point(Math.max(0, gdkRectangle.x), Math.max(0, gdkRectangle.y));
        int n = gdkRectangle.width;
        int n2 = gdkRectangle.height;
        if (n2 == 100 && n == 100) {
            object = this.browser.getDisplay().getPrimaryMonitor().getBounds();
            n2 = (int)((double)((Rectangle)object).height * 0.66);
            n = (int)((double)((Rectangle)object).width * 0.66);
        }
        windowEvent.size = new Point(n, n2);
        object = () -> {
            if (this.browser.isDisposed()) {
                return;
            }
            for (int i = 0; i < this.visibilityWindowListeners.length; ++i) {
                this.visibilityWindowListeners[i].show(windowEvent);
            }
        };
        this.browser.getDisplay().asyncExec((Runnable)object);
        return 0L;
    }

    private int webkit_settings_get(byte[] byArray) {
        if (this.webView == 0L) {
            return -1;
        }
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        return this.webkit_settings_get(l, byArray);
    }

    private int webkit_settings_get(long l, byte[] byArray) {
        int[] nArray = new int[1];
        OS.g_object_get(l, byArray, nArray, 0L);
        return nArray[0];
    }

    private void webkit_settings_set(byte[] byArray, int n) {
        if (this.webView == 0L) {
            return;
        }
        long l = WebKitGTK.webkit_web_view_get_settings(this.webView);
        OS.g_object_set(l, byArray, n, 0L);
    }

    static Object convertToJava(long l, long l2) {
        int n = WebKitGTK.JSValueGetType(l, l2);
        switch (n) {
            case 2: {
                int n2 = (int)WebKitGTK.JSValueToNumber(l, l2, null);
                return n2 != 0;
            }
            case 3: {
                double d = WebKitGTK.JSValueToNumber(l, l2, null);
                return d;
            }
            case 4: {
                long l3 = WebKitGTK.JSValueToStringCopy(l, l2, null);
                if (l3 == 0L) {
                    return "";
                }
                long l4 = WebKitGTK.JSStringGetMaximumUTF8CStringSize(l3);
                byte[] byArray = new byte[(int)l4];
                l4 = WebKitGTK.JSStringGetUTF8CString(l3, byArray, l4);
                WebKitGTK.JSStringRelease(l3);
                return new String(byArray, 0, (int)l4 - 1, StandardCharsets.UTF_8);
            }
            case 0: 
            case 1: {
                return null;
            }
            case 5: {
                byte[] byArray = "length\u0000".getBytes(StandardCharsets.UTF_8);
                long l5 = WebKitGTK.JSStringCreateWithUTF8CString(byArray);
                long l6 = WebKitGTK.JSObjectGetProperty(l, l2, l5, null);
                WebKitGTK.JSStringRelease(l5);
                n = WebKitGTK.JSValueGetType(l, l6);
                if (n != 3) break;
                int n3 = (int)WebKitGTK.JSValueToNumber(l, l6, null);
                Object[] objectArray = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    long l7 = WebKitGTK.JSObjectGetPropertyAtIndex(l, l2, i, null);
                    if (l7 == 0L) continue;
                    objectArray[i] = WebKit.convertToJava(l, l7);
                }
                return objectArray;
            }
        }
        SWT.error(5);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$setUrl$11(String string, String string2, String[] stringArray, String string3, int n, byte[] byArray, long l) {
        String string4 = null;
        Object object = null;
        String string5 = null;
        try {
            HttpURLConnection httpURLConnection;
            Object object2 = new URL(string);
            URLConnection uRLConnection = ((URL)object2).openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                Object[] objectArray;
                httpURLConnection = (HttpURLConnection)uRLConnection;
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                httpURLConnection.setRequestProperty("User-Agent", string2);
                httpURLConnection.setDoOutput(true);
                if (stringArray != null) {
                    for (String string6 : stringArray) {
                        int n2 = string6.indexOf(58);
                        if (n2 <= 0) continue;
                        String string7 = string6.substring(0, n2).trim();
                        Object object3 = string6.substring(n2 + 1).trim();
                        httpURLConnection.setRequestProperty(string7, (String)object3);
                    }
                }
                try (Object object4 = httpURLConnection.getOutputStream();){
                    ((OutputStream)object4).write(string3.getBytes());
                }
                object4 = new StringBuilder();
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                    objectArray = new char[4096];
                    while (bufferedReader.read((char[])objectArray, 0, objectArray.length) > 0) {
                        ((StringBuilder)object4).append(new String((char[])objectArray));
                        Arrays.fill(objectArray, '\u0000');
                    }
                }
                string4 = ((StringBuilder)object4).toString();
                object4 = httpURLConnection.getContentType();
                int n3 = ((String)object4).indexOf(59);
                Object object5 = object = n3 > 0 ? ((String)object4).substring(0, n3) : object4;
                if (((String)object4).indexOf(59) > 0) {
                    objectArray = ((String)object4).split(";");
                    for (Object object3 : (String)objectArray) {
                        int n4 = ((String)object3).indexOf(61);
                        if (n4 <= 0) continue;
                        String string8 = ((String)object3).substring(0, n4).trim();
                        String string9 = ((String)object3).substring(n4 + 1).trim();
                        if (!"charset".equalsIgnoreCase(string8)) continue;
                        string5 = string9;
                    }
                }
            }
            if (string4 != null && n == w2_bug527738LastRequestCounter.get()) {
                object2 = string4;
                uRLConnection = object;
                httpURLConnection = string5;
                Display.getDefault().syncExec(() -> this.lambda$setUrl$10((String)object2, (String)((Object)uRLConnection), (String)((Object)httpURLConnection), byArray, l));
            }
        }
        catch (IOException iOException) {
            string4 = iOException.getMessage();
        }
        finally {
            if (string4 != null && n == w2_bug527738LastRequestCounter.get()) {
                String string10 = string4;
                Object object6 = object;
                String string11 = string5;
                Display.getDefault().syncExec(() -> {
                    byte[] byArray2;
                    byte[] byArray3;
                    byte[] byArray4 = Converter.wcsToMbcs(string10, false);
                    byte[] byArray5 = byArray3 = object6 != null ? Converter.javaStringToCString(object6) : Converter.javaStringToCString("text/plain");
                    if (string11 != null) {
                        byArray2 = Converter.wcsToMbcs(string11, true);
                    } else {
                        byte[] byArray6 = new byte[1];
                        byArray2 = byArray6;
                        byArray6[0] = 0;
                    }
                    byte[] byArray7 = byArray2;
                    long l2 = OS.g_bytes_new(byArray4, byArray4.length);
                    WebKitGTK.webkit_web_view_load_bytes(this.webView, l2, byArray3, byArray7, byArray);
                    OS.g_bytes_unref(l2);
                    OS.g_object_set(l, WebKitGTK.user_agent, 0, 0L);
                });
            }
        }
    }

    static {
        bug522733FirstInstanceCreated = false;
        w2_bug527738LastRequestCounter = new AtomicInteger();
        nonBlockingEvaluate = 0;
        webKitDownloadStatus = new HashMap<LONG, Integer>();
        MIN_VERSION = new int[]{1, 2, 0};
        SEPARATOR_FILE = File.separatorChar;
        SWT_PROTOCOL = Converter.wcsToMbcs("swt", true);
        JSON_MIME_TYPE = Converter.wcsToMbcs("application/json", true);
        Proc2 = new Callback(WebKit.class, "Proc", 2);
        Proc3 = new Callback(WebKit.class, "Proc", 3);
        Proc4 = new Callback(WebKit.class, "Proc", 4);
        Proc5 = new Callback(WebKit.class, "Proc", 5);
        new Webkit2AsyncToSync();
        JSDOMEventProc = new Callback(WebKit.class, "JSDOMEventProc", 3);
        RequestProc = new Callback(WebKit.class, "RequestProc", 2);
        NativeClearSessions = () -> {
            if (!WebKitGTK.LibraryLoaded) {
                return;
            }
            if (WebKitGTK.webkit_get_minor_version() >= 16) {
                long l = WebKitGTK.webkit_web_context_get_default();
                long l2 = WebKitGTK.webkit_web_context_get_website_data_manager(l);
                WebKitGTK.webkit_website_data_manager_clear(l2, 256L, 0L, 0L, 0L, 0L);
            } else {
                System.err.println("SWT WebKit: clear sessions only supported on WebKitGtk version 2.16 and above. Your version is: " + WebKit.internalGetWebKitVersionStr());
            }
        };
        NativeGetCookie = () -> {
            if (!WebKitGTK.LibraryLoaded) {
                return;
            }
            if (WebKitGTK.webkit_get_minor_version() >= 20) {
                CookieValue = Webkit2AsyncToSync.getCookie(CookieUrl, CookieName);
            } else {
                System.err.println("SWT WebKit: getCookie() only supported on WebKitGTK version 2.20 and above. Your version is: " + WebKit.internalGetWebKitVersionStr());
            }
        };
        NativeSetCookie = () -> {
            if (!WebKitGTK.LibraryLoaded) {
                return;
            }
            if (WebKitGTK.webkit_get_minor_version() >= 20) {
                CookieResult = Webkit2AsyncToSync.setCookie(CookieUrl, CookieValue);
            } else {
                System.err.println("SWT WebKit: setCookie() only supported on WebKitGTK version 2.20 and above. Your version is: " + WebKit.internalGetWebKitVersionStr());
            }
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
            NativePendingCookies = null;
        }
        ignoreTls = "true".equals(System.getProperty("org.eclipse.swt.internal.webkitgtk.ignoretlserrors"));
    }

    private static class Webkit2AsyncToSync {
        private static Browser cookieBrowser;
        private static Callback runjavascript_callback;
        private static Callback getText_callback;
        private static Callback setCookie_callback;
        private static Callback getCookie_callback;

        private Webkit2AsyncToSync() {
        }

        static Object evaluate(String string, Browser browser, long l) {
            String string2 = "SWTWebkit2TempFunc" + CallBackMap.getNextId() + "()";
            String string3 = "function " + string2 + "{" + string + "}; " + string2;
            return Webkit2AsyncToSync.runjavascript(string3, browser, l);
        }

        static Object runjavascript(String string, Browser browser, long l) {
            if (nonBlockingEvaluate > 0) {
                WebKitGTK.webkit_web_view_run_javascript(l, Converter.wcsToMbcs(string, true), 0L, 0L, 0L);
                return null;
            }
            Consumer<Integer> consumer = n -> WebKitGTK.webkit_web_view_run_javascript(l, Converter.wcsToMbcs(string, true), 0L, runjavascript_callback.getAddress(), n.intValue());
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(browser, consumer, " The following javascript was executed:\n" + string + "\n\n");
            if (webkit2AsyncReturnObj.swtAsyncTimeout) {
                return null;
            }
            if (webkit2AsyncReturnObj.errorNum != 0) {
                throw new SWTException(webkit2AsyncReturnObj.errorNum, webkit2AsyncReturnObj.errorMsg + "\nScript that was evaluated:\n" + string);
            }
            return webkit2AsyncReturnObj.returnValue;
        }

        private static void runjavascript_callback(long l, long l2, long l3) {
            int n = (int)l3;
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = CallBackMap.getObj(n);
            if (webkit2AsyncReturnObj != null) {
                long[] lArray = new long[1];
                long l4 = WebKitGTK.webkit_web_view_run_javascript_finish(l, l2, lArray);
                if (l4 == 0L) {
                    long l5 = OS.g_error_get_message(lArray[0]);
                    String string = Converter.cCharPtrToJavaString(l5, false);
                    OS.g_error_free(lArray[0]);
                    webkit2AsyncReturnObj.errorNum = 50;
                    webkit2AsyncReturnObj.errorMsg = string != null ? string : "";
                } else {
                    long l6 = WebKitGTK.webkit_javascript_result_get_global_context(l4);
                    long l7 = WebKitGTK.webkit_javascript_result_get_value(l4);
                    try {
                        webkit2AsyncReturnObj.returnValue = WebKit.convertToJava(l6, l7);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        webkit2AsyncReturnObj.errorNum = 51;
                        webkit2AsyncReturnObj.errorMsg = "Type of return value not is not valid. For supported types see: Browser.evaluate() JavaDoc";
                    }
                    WebKitGTK.webkit_javascript_result_unref(l4);
                }
                webkit2AsyncReturnObj.callbackFinished = true;
            }
            Display.getCurrent().wake();
        }

        static String getText(Browser browser, long l) {
            long l2 = WebKitGTK.webkit_web_view_get_main_resource(l);
            if (l2 == 0L) {
                return "";
            }
            if (nonBlockingEvaluate > 0) {
                System.err.println("SWT Webkit Warning: getText() called inside a synchronous callback, which can lead to a deadlock.\nAvoid using getText in OpenWindowListener, Authentication listener and when webkit is about to change to a new page\nReturn value is empty string '' instead of actual text");
                return "";
            }
            Consumer<Integer> consumer = n -> WebKitGTK.webkit_web_resource_get_data(l2, 0L, getText_callback.getAddress(), n.intValue());
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(browser, consumer, " getText() was called");
            if (webkit2AsyncReturnObj.swtAsyncTimeout) {
                return "SWT WEBKIT TIMEOUT ERROR";
            }
            return (String)webkit2AsyncReturnObj.returnValue;
        }

        private static void getText_callback(long l, long l2, long l3) {
            int n = (int)l3;
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = CallBackMap.getObj(n);
            long[] lArray = new long[1];
            long[] lArray2 = new long[1];
            long l4 = WebKitGTK.webkit_web_resource_get_data_finish(l, l2, lArray, lArray2);
            if (lArray2[0] != 0L || l4 == 0L) {
                OS.g_error_free(lArray2[0]);
                webkit2AsyncReturnObj.returnValue = "";
            } else {
                int n2 = (int)lArray[0];
                byte[] byArray = new byte[n2];
                C.memmove(byArray, l4, (long)n2);
                String string = Converter.byteToStringViaHeuristic(byArray);
                webkit2AsyncReturnObj.returnValue = string;
            }
            webkit2AsyncReturnObj.callbackFinished = true;
            Display.getCurrent().wake();
        }

        static void setCookieBrowser(Browser browser) {
            if (browser != null) {
                cookieBrowser = browser;
            }
        }

        static boolean setCookie(String string, String string2) {
            long l = WebKitGTK.webkit_web_context_get_default();
            long l2 = WebKitGTK.webkit_web_context_get_cookie_manager(l);
            byte[] byArray = Converter.wcsToMbcs(string, true);
            long l3 = WebKitGTK.soup_uri_new(byArray);
            if (l3 == 0L) {
                System.err.println("SWT WebKit: SoupURI == 0 when setting cookie");
                return false;
            }
            byArray = Converter.wcsToMbcs(string2, true);
            long l4 = WebKitGTK.soup_cookie_parse(byArray, l3);
            if (nonBlockingEvaluate > 0) {
                System.err.println("SWT Webkit: setCookie() called inside a synchronous callback, which can lead to a deadlock.\nReturn value is false.");
                return false;
            }
            Consumer<Integer> consumer = n -> WebKitGTK.webkit_cookie_manager_add_cookie(l2, l4, 0L, setCookie_callback.getAddress(), n.intValue());
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(cookieBrowser, consumer, " setCookie() was called");
            WebKitGTK.soup_uri_free(l3);
            if (webkit2AsyncReturnObj.swtAsyncTimeout) {
                return false;
            }
            return (Boolean)webkit2AsyncReturnObj.returnValue;
        }

        private static void setCookie_callback(long l, long l2, long l3) {
            int n = (int)l3;
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = CallBackMap.getObj(n);
            long[] lArray = new long[1];
            webkit2AsyncReturnObj.returnValue = WebKitGTK.webkit_cookie_manager_add_cookie_finish(l, l2, lArray);
            if (lArray[0] != 0L) {
                long l4 = OS.g_error_get_message(lArray[0]);
                String string = Converter.cCharPtrToJavaString(l4, false);
                System.err.println("SWT WebKit: error setting cookie: " + string);
                OS.g_error_free(lArray[0]);
            }
            webkit2AsyncReturnObj.callbackFinished = true;
            Display.getCurrent().wake();
        }

        static String getCookie(String string, String string2) {
            long l = WebKitGTK.webkit_web_context_get_default();
            long l2 = WebKitGTK.webkit_web_context_get_cookie_manager(l);
            byte[] byArray = Converter.wcsToMbcs(string, true);
            if (nonBlockingEvaluate > 0) {
                System.err.println("SWT Webkit: getCookie() called inside a synchronous callback, which can lead to a deadlock.\nReturn value is an empty string '' instead of actual cookie value.");
                return "";
            }
            Consumer<Integer> consumer = n -> WebKitGTK.webkit_cookie_manager_get_cookies(l2, byArray, 0L, getCookie_callback.getAddress(), GDBus.convertJavaToGVariant(new Object[]{string2, n}));
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = Webkit2AsyncToSync.execAsyncAndWaitForReturn(cookieBrowser, consumer, " getCookie() was called");
            if (webkit2AsyncReturnObj.swtAsyncTimeout) {
                return "SWT WEBKIT TIMEOUT ERROR";
            }
            return (String)webkit2AsyncReturnObj.returnValue;
        }

        private static void getCookie_callback(long l, long l2, long l3) {
            Object[] objectArray = GDBus.convertGVariantToJava(l3);
            if (objectArray instanceof Object[]) {
                Object[] objectArray2 = objectArray;
                String string = (String)objectArray2[0];
                int n = ((Number)objectArray2[1]).intValue();
                Webkit2AsyncReturnObj webkit2AsyncReturnObj = CallBackMap.getObj(n);
                long[] lArray = new long[1];
                long l4 = WebKitGTK.webkit_cookie_manager_get_cookies_finish(l, l2, lArray);
                if (lArray[0] != 0L) {
                    long l5 = OS.g_error_get_message(lArray[0]);
                    String string2 = Converter.cCharPtrToJavaString(l5, false);
                    System.err.println("SWT WebKit: error getting cookie: " + string2);
                    OS.g_error_free(lArray[0]);
                    webkit2AsyncReturnObj.returnValue = "";
                }
                int n2 = OS.g_slist_length(l4);
                long l6 = l4;
                for (int i = 0; i < n2; ++i) {
                    long l7 = OS.g_slist_data(l6);
                    long l8 = WebKitGTK.soup_cookie_get_name(l7);
                    String string3 = Converter.cCharPtrToJavaString(l8, false);
                    if (string3 != null && string3.equals(string)) {
                        long l9 = WebKitGTK.soup_cookie_get_value(l7);
                        webkit2AsyncReturnObj.returnValue = Converter.cCharPtrToJavaString(l9, false);
                        break;
                    }
                    l6 = OS.g_slist_next(l6);
                }
                OS.g_slist_free(l4);
                webkit2AsyncReturnObj.callbackFinished = true;
                Display.getCurrent().wake();
            } else {
                System.err.println("SWT WebKit: something went wrong unpacking GVariant tuple for getCookie_callback");
            }
        }

        private static Webkit2AsyncReturnObj execAsyncAndWaitForReturn(Browser browser, Consumer<Integer> consumer, String string) {
            Webkit2AsyncReturnObj webkit2AsyncReturnObj = new Webkit2AsyncReturnObj();
            int n = CallBackMap.putObject(webkit2AsyncReturnObj);
            consumer.accept(n);
            Instant instant = Instant.now().plusMillis(10000L);
            while (!browser.isDisposed() && !webkit2AsyncReturnObj.callbackFinished) {
                if (Instant.now().isAfter(instant)) {
                    System.err.println("SWT call to Webkit timed out after 10000ms. No return value will be provided.\nPossible reasons:\n1) Problem: Your javascript needs more than 10000ms to execute.\n   Solution: Don't run such javascript, it blocks Eclipse's UI. SWT currently allows such code to complete, but this error is thrown \n     and the return value of execute()/evalute() will be false/null.\n\n2) However, if you believe that your application should execute as expected (in under10000 ms),\n then it might be a deadlock in SWT/Browser/webkit2 logic.\n I.e, it might be a bug in SWT (e.g this does not occur on Windows/Cocoa, but occurs on Linux). If you believe it to be a bug in SWT, then\n" + WebKit.getInternalErrorMsg() + "\n Additional information about the error is as following:\n" + string);
                    webkit2AsyncReturnObj.swtAsyncTimeout = true;
                    break;
                }
                if (GTK.GTK4) {
                    OS.g_main_context_iteration(0L, true);
                    continue;
                }
                GTK3.gtk_main_iteration_do(true);
            }
            CallBackMap.removeObject(n);
            return webkit2AsyncReturnObj;
        }

        static {
            runjavascript_callback = new Callback(Webkit2AsyncToSync.class, "runjavascript_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            getText_callback = new Callback(Webkit2AsyncToSync.class, "getText_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            setCookie_callback = new Callback(Webkit2AsyncToSync.class, "setCookie_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
            getCookie_callback = new Callback(Webkit2AsyncToSync.class, "getCookie_callback", Void.TYPE, new Type[]{Long.TYPE, Long.TYPE, Long.TYPE});
        }

        private static class CallBackMap {
            private static HashMap<Integer, Webkit2AsyncReturnObj> callbackMap = new HashMap();
            private static int nextCallbackId = 1;
            private static HashSet<Integer> usedCallbackIds = new HashSet();

            private CallBackMap() {
            }

            static int putObject(Webkit2AsyncReturnObj webkit2AsyncReturnObj) {
                int n = CallBackMap.getNextId();
                callbackMap.put(n, webkit2AsyncReturnObj);
                return n;
            }

            static Webkit2AsyncReturnObj getObj(int n) {
                return callbackMap.get(n);
            }

            static void removeObject(int n) {
                callbackMap.remove(n);
                CallBackMap.removeId(n);
            }

            static int getNextId() {
                int n = 0;
                boolean bl = false;
                while (!bl) {
                    n = nextCallbackId;
                    boolean bl2 = bl = !usedCallbackIds.contains(n);
                    if (nextCallbackId != Integer.MAX_VALUE) {
                        ++nextCallbackId;
                        continue;
                    }
                    nextCallbackId = 1;
                }
                usedCallbackIds.add(n);
                return n;
            }

            private static void removeId(int n) {
                usedCallbackIds.remove(n);
            }
        }

        private static class Webkit2AsyncReturnObj {
            boolean callbackFinished = false;
            Object returnValue = null;
            int errorNum = 0;
            String errorMsg;
            boolean swtAsyncTimeout;

            private Webkit2AsyncReturnObj() {
            }
        }
    }
}

