/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.FontFaceImpl;
import com.sun.javafx.css.SelectorPartitioning;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleClassSet;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.ParentHelper;
import com.sun.javafx.util.Logging;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PermissionCollection;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.css.CssParser;
import javafx.css.FontFace;
import javafx.css.PseudoClass;
import javafx.css.Rule;
import javafx.css.Selector;
import javafx.css.StyleClass;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.Stylesheet;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.stage.Window;

public final class StyleManager {
    private static final Object styleLock = new Object();
    private static PlatformLogger LOGGER;
    public static final Map<Parent, CacheContainer> cacheContainerMap;
    public final List<StylesheetContainer> userAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    public final List<StylesheetContainer> platformUserAgentStylesheetContainers = new ArrayList<StylesheetContainer>();
    public boolean hasDefaultUserAgentStylesheet = false;
    public final Map<String, StylesheetContainer> stylesheetContainerMap = new HashMap<String, StylesheetContainer>();
    private final ImageCache imageCache = new ImageCache();
    private static final String skinPrefix = "com/sun/javafx/scene/control/skin/";
    private static final String skinUtilsClassName = "com.sun.javafx.scene.control.skin.Utils";
    private Key key = null;
    private final WeakHashMap<Region, String> weakRegionUserAgentStylesheetMap = new WeakHashMap();
    private static ObservableList<CssParser.ParseError> errors;
    private static List<String> cacheMapKey;

    private static PlatformLogger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getCSSLogger();
        }
        return LOGGER;
    }

    public static StyleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private StyleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheContainer getCacheContainer(Styleable styleable, SubScene subScene) {
        Object object;
        Object object2;
        if (styleable == null && subScene == null) {
            return null;
        }
        Parent parent = null;
        if (subScene != null) {
            parent = subScene.getRoot();
        } else if (styleable instanceof Node) {
            object2 = (Node)styleable;
            object = object2.getScene();
            if (object != null) {
                parent = object.getRoot();
            }
        } else if (styleable instanceof Window && (object2 = ((Window)styleable).getScene()) != null) {
            parent = object2.getRoot();
        }
        if (parent == null) {
            return null;
        }
        object2 = styleLock;
        synchronized (object2) {
            object = cacheContainerMap.get(parent);
            if (object == null) {
                object = new CacheContainer();
                cacheContainerMap.put(parent, (CacheContainer)object);
            }
            return object;
        }
    }

    public StyleCache getSharedCache(Styleable styleable, SubScene subScene, StyleCache.Key key2) {
        CacheContainer cacheContainer = this.getCacheContainer(styleable, subScene);
        if (cacheContainer == null) {
            return null;
        }
        Map map2 = cacheContainer.getStyleCache();
        if (map2 == null) {
            return null;
        }
        StyleCache styleCache = (StyleCache)map2.get(key2);
        if (styleCache == null) {
            styleCache = new StyleCache();
            map2.put(new StyleCache.Key(key2), styleCache);
        }
        return styleCache;
    }

    public StyleMap getStyleMap(Styleable styleable, SubScene subScene, int n) {
        if (n == -1) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer(styleable, subScene);
        if (cacheContainer == null) {
            return StyleMap.EMPTY_MAP;
        }
        return cacheContainer.getStyleMap(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Scene scene) {
        if (scene == null) {
            return;
        }
        this.forget(scene.getRoot());
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            String string2 = null;
            if (scene.getUserAgentStylesheet() != null && !(string2 = scene.getUserAgentStylesheet().trim()).isEmpty()) {
                for (int j = this.userAgentStylesheetContainers.size() - 1; 0 <= j; --j) {
                    object2 = this.userAgentStylesheetContainers.get(j);
                    if (!string2.equals(((StylesheetContainer)object2).fname)) continue;
                    ((StylesheetContainer)object2).parentUsers.remove(scene.getRoot());
                    if (((StylesheetContainer)object2).parentUsers.list.size() != 0) continue;
                    this.userAgentStylesheetContainers.remove(j);
                }
            }
            Set<Map.Entry<String, StylesheetContainer>> set2 = this.stylesheetContainerMap.entrySet();
            object2 = set2.iterator();
            while (object2.hasNext()) {
                Map.Entry<String, StylesheetContainer> entry = object2.next();
                StylesheetContainer stylesheetContainer = entry.getValue();
                Iterator iterator2 = stylesheetContainer.parentUsers.list.iterator();
                while (iterator2.hasNext()) {
                    Reference reference = iterator2.next();
                    Parent parent = (Parent)reference.get();
                    if (parent != null && parent.getScene() != scene && parent.getScene() != null) continue;
                    reference.clear();
                    iterator2.remove();
                }
                if (!stylesheetContainer.parentUsers.list.isEmpty()) continue;
                object2.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stylesheetsChanged(Scene scene, ListChangeListener.Change<String> change) {
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Set<Map.Entry<Parent, CacheContainer>> set2 = cacheContainerMap.entrySet();
            for (Map.Entry<Parent, CacheContainer> object3 : set2) {
                object2 = object3.getKey();
                CacheContainer cacheContainer = object3.getValue();
                if (object2.getScene() != scene) continue;
                cacheContainer.clearCache();
            }
            change.reset();
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (String string2 : change.getRemoved()) {
                    this.stylesheetRemoved(scene, string2);
                    object2 = this.stylesheetContainerMap.get(string2);
                    if (object2 == null) continue;
                    ((StylesheetContainer)object2).invalidateChecksum();
                }
            }
        }
    }

    private void stylesheetRemoved(Scene scene, String string2) {
        this.stylesheetRemoved(scene.getRoot(), string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Parent parent) {
        if (parent == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            ObservableList observableList;
            CacheContainer cacheContainer = cacheContainerMap.remove(parent);
            if (cacheContainer != null) {
                cacheContainer.clearCache();
            }
            if ((observableList = parent.getStylesheets()) != null && !observableList.isEmpty()) {
                for (Object object2 : observableList) {
                    this.stylesheetRemoved(parent, (String)object2);
                }
            }
            Iterator<Map.Entry<String, StylesheetContainer>> iterator2 = this.stylesheetContainerMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2;
                object2 = iterator2.next();
                StylesheetContainer stylesheetContainer = (StylesheetContainer)object2.getValue();
                stylesheetContainer.parentUsers.remove(parent);
                if (!stylesheetContainer.parentUsers.list.isEmpty()) continue;
                iterator2.remove();
                if (stylesheetContainer.selectorPartitioning != null) {
                    stylesheetContainer.selectorPartitioning.reset();
                }
                String string2 = stylesheetContainer.fname;
                this.imageCache.cleanUpImageCache(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stylesheetsChanged(Parent parent, ListChangeListener.Change<String> change) {
        Object object = styleLock;
        synchronized (object) {
            change.reset();
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                for (String string2 : change.getRemoved()) {
                    this.stylesheetRemoved(parent, string2);
                    StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(string2);
                    if (stylesheetContainer == null) continue;
                    stylesheetContainer.invalidateChecksum();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stylesheetRemoved(Parent parent, String string2) {
        Object object = styleLock;
        synchronized (object) {
            StylesheetContainer stylesheetContainer = this.stylesheetContainerMap.get(string2);
            if (stylesheetContainer == null) {
                return;
            }
            stylesheetContainer.parentUsers.remove(parent);
            if (stylesheetContainer.parentUsers.list.isEmpty()) {
                this.removeStylesheetContainer(stylesheetContainer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(SubScene subScene) {
        if (subScene == null) {
            return;
        }
        Parent parent = subScene.getRoot();
        if (parent == null) {
            return;
        }
        this.forget(parent);
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            Object object3;
            String string2 = null;
            if (subScene.getUserAgentStylesheet() != null && !(string2 = subScene.getUserAgentStylesheet().trim()).isEmpty()) {
                object3 = this.userAgentStylesheetContainers.iterator();
                while (object3.hasNext()) {
                    object2 = (StylesheetContainer)object3.next();
                    if (!string2.equals(((StylesheetContainer)object2).fname)) continue;
                    ((StylesheetContainer)object2).parentUsers.remove(subScene.getRoot());
                    if (((StylesheetContainer)object2).parentUsers.list.size() != 0) continue;
                    object3.remove();
                }
            }
            object3 = new ArrayList<StylesheetContainer>(this.stylesheetContainerMap.values());
            object2 = object3.iterator();
            while (object2.hasNext()) {
                StylesheetContainer stylesheetContainer = (StylesheetContainer)object2.next();
                Iterator iterator2 = stylesheetContainer.parentUsers.list.iterator();
                block5: while (iterator2.hasNext()) {
                    Reference reference = iterator2.next();
                    Parent parent2 = (Parent)reference.get();
                    if (parent2 == null) continue;
                    for (Parent parent3 = parent2; parent3 != null; parent3 = parent3.getParent()) {
                        if (parent != parent3.getParent()) continue;
                        reference.clear();
                        iterator2.remove();
                        this.forget(parent2);
                        continue block5;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStylesheetContainer(StylesheetContainer stylesheetContainer) {
        if (stylesheetContainer == null) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            Parent parent;
            Object object2;
            String string2 = stylesheetContainer.fname;
            this.stylesheetContainerMap.remove(string2);
            if (stylesheetContainer.selectorPartitioning != null) {
                stylesheetContainer.selectorPartitioning.reset();
            }
            for (Map.Entry<Parent, CacheContainer> entry : cacheContainerMap.entrySet()) {
                Object object3;
                object2 = entry.getValue();
                if (object2 == null || ((CacheContainer)object2).cacheMap == null || ((CacheContainer)object2).cacheMap.isEmpty()) continue;
                parent = new ArrayList();
                for (Map.Entry entry2 : ((CacheContainer)object2).cacheMap.entrySet()) {
                    object3 = (List)entry2.getKey();
                    if (!(object3 != null ? object3.contains(string2) : string2 == null)) continue;
                    parent.add(object3);
                }
                if (parent.isEmpty()) continue;
                for (Map.Entry entry2 : parent) {
                    object3 = (Map)((CacheContainer)object2).cacheMap.remove(entry2);
                    if (object3 == null) continue;
                    object3.clear();
                }
            }
            this.imageCache.cleanUpImageCache(string2);
            List list2 = stylesheetContainer.parentUsers.list;
            for (int j = list2.size() - 1; 0 <= j; --j) {
                object2 = (Reference)list2.remove(j);
                parent = (Parent)((Reference)object2).get();
                ((Reference)object2).clear();
                if (parent == null || parent.getScene() == null) continue;
                NodeHelper.reapplyCSS((Node)parent);
            }
        }
    }

    public Image getCachedImage(String string2) {
        return this.imageCache.getCachedImage(string2);
    }

    private static URL getURL(String string2) {
        if (string2 == null || string2.trim().isEmpty()) {
            return null;
        }
        try {
            URI uRI = new URI(string2.trim());
            if (!uRI.isAbsolute()) {
                if (string2.startsWith(skinPrefix) && (string2.endsWith(".css") || string2.endsWith(".bss"))) {
                    try {
                        ClassLoader classLoader = StyleManager.class.getClassLoader();
                        Class<?> clazz = Class.forName(skinUtilsClassName, true, classLoader);
                        Method method = clazz.getMethod("getResource", String.class);
                        return (URL)method.invoke(null, string2.substring(skinPrefix.length()));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                        return null;
                    }
                }
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string3 = uRI.getPath();
                URL uRL = null;
                uRL = string3.startsWith("/") ? classLoader.getResource(string3.substring(1)) : classLoader.getResource(string3);
                return uRL;
            }
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(String string2) {
        block15: {
            if (string2 == null || string2.isEmpty()) {
                return new byte[0];
            }
            try {
                URL uRL = StyleManager.getURL(string2);
                if (uRL == null || !"file".equals(uRL.getProtocol())) break block15;
                try (InputStream inputStream2 = uRL.openStream();){
                    byte[] byArray;
                    try (DigestInputStream digestInputStream = new DigestInputStream(inputStream2, MessageDigest.getInstance("MD5"));){
                        digestInputStream.getMessageDigest().reset();
                        while (digestInputStream.read() != -1) {
                        }
                        byArray = digestInputStream.getMessageDigest().digest();
                    }
                    return byArray;
                }
            }
            catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {
                // empty catch block
            }
        }
        return new byte[0];
    }

    public static Stylesheet loadStylesheet(String string2) {
        try {
            return StyleManager.loadStylesheetUnPrivileged(string2);
        }
        catch (AccessControlException accessControlException) {
            System.err.println("WARNING: security exception trying to load: " + string2);
            if (string2.length() < 7 && string2.indexOf("!/") < string2.length() - 7) {
                return null;
            }
            try {
                String string3;
                String string4;
                URI uRI;
                String string5;
                URI uRI2 = new URI(string2);
                if ("jar".equals(uRI2.getScheme()) && (string5 = (uRI = AccessController.doPrivileged(() -> StyleManager.class.getProtectionDomain().getCodeSource().getLocation().toURI())).getSchemeSpecificPart()).equals(string4 = (string3 = uRI2.getSchemeSpecificPart()).substring(string3.indexOf(47), string3.indexOf("!/")))) {
                    String string6 = string2.substring(string2.indexOf("!/") + 2);
                    if (string2.endsWith(".css") || string2.endsWith(".bss")) {
                        JarEntry jarEntry;
                        FilePermission filePermission = new FilePermission(string5, "read");
                        PermissionCollection permissionCollection = filePermission.newPermissionCollection();
                        permissionCollection.add(filePermission);
                        AccessControlContext accessControlContext = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)});
                        JarFile jarFile = null;
                        try {
                            jarFile = AccessController.doPrivileged(() -> new JarFile(string5), accessControlContext);
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            return null;
                        }
                        if (jarFile != null && (jarEntry = jarFile.getJarEntry(string6)) != null) {
                            return AccessController.doPrivileged(() -> StyleManager.loadStylesheetUnPrivileged(string2), accessControlContext);
                        }
                    }
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
            catch (PrivilegedActionException privilegedActionException) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Stylesheet loadStylesheetUnPrivileged(String string2) {
        Object object = styleLock;
        synchronized (object) {
            block23: {
                Boolean bl = AccessController.doPrivileged(() -> {
                    String string3 = System.getProperty("binary.css");
                    return !string2.endsWith(".bss") && string3 != null ? !Boolean.valueOf(string3).booleanValue() : Boolean.FALSE;
                });
                try {
                    Object object2;
                    String string3 = bl != false ? ".css" : ".bss";
                    URL uRL = null;
                    Stylesheet stylesheet = null;
                    if (!string2.endsWith(".css") && !string2.endsWith(".bss")) {
                        uRL = StyleManager.getURL(string2);
                        bl = true;
                    } else {
                        object2 = string2.substring(0, string2.length() - 4);
                        uRL = StyleManager.getURL((String)object2 + string3);
                        if (uRL == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                            uRL = StyleManager.getURL((String)object2 + ".css");
                        }
                        if (uRL != null && !bl.booleanValue()) {
                            try {
                                stylesheet = Stylesheet.loadBinary((URL)uRL);
                            }
                            catch (IOException iOException) {
                                stylesheet = null;
                            }
                            if (stylesheet == null && (bl = Boolean.valueOf(bl == false)).booleanValue()) {
                                uRL = StyleManager.getURL(string2);
                            }
                        }
                    }
                    if (uRL != null && bl.booleanValue()) {
                        stylesheet = new CssParser().parse(uRL);
                    }
                    if (stylesheet == null) {
                        if (errors != null) {
                            object2 = new CssParser.ParseError("Resource \"" + string2 + "\" not found.");
                            errors.add(object2);
                        }
                        if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.WARNING)) {
                            StyleManager.getLogger().warning(String.format("Resource \"%s\" not found.", string2));
                        }
                    }
                    if (stylesheet != null) {
                        block8: for (FontFace fontFace : stylesheet.getFontFaces()) {
                            if (!(fontFace instanceof FontFaceImpl)) continue;
                            for (FontFaceImpl.FontFaceSrc fontFaceSrc : ((FontFaceImpl)fontFace).getSources()) {
                                if (fontFaceSrc.getType() != FontFaceImpl.FontFaceSrcType.URL) continue;
                                Font font = Font.loadFont((String)fontFaceSrc.getSrc(), (double)10.0);
                                if (font != null) continue block8;
                                StyleManager.getLogger().info("Could not load @font-face font [" + fontFaceSrc.getSrc() + "]");
                                continue block8;
                            }
                        }
                    }
                    return stylesheet;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (errors != null) {
                        CssParser.ParseError parseError = new CssParser.ParseError("Stylesheet \"" + string2 + "\" not found.");
                        errors.add((Object)parseError);
                    }
                    if (StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) {
                        StyleManager.getLogger().info("Could not find stylesheet: " + string2);
                    }
                }
                catch (IOException iOException) {
                    if (errors != null) {
                        CssParser.ParseError parseError = new CssParser.ParseError("Could not load stylesheet: " + string2);
                        errors.add((Object)parseError);
                    }
                    if (!StyleManager.getLogger().isLoggable(PlatformLogger.Level.INFO)) break block23;
                    StyleManager.getLogger().info("Could not load stylesheet: " + string2);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserAgentStylesheets(List<String> list2) {
        if (list2 == null || list2.size() == 0) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            String string2;
            String string3;
            int n;
            int n2;
            boolean bl;
            if (list2.size() == this.platformUserAgentStylesheetContainers.size()) {
                bl = true;
                n2 = list2.size();
                for (n = 0; n < n2 && bl; ++n) {
                    string3 = list2.get(n);
                    String string4 = string2 = string3 != null ? string3.trim() : null;
                    if (string2 == null || string2.isEmpty()) break;
                    StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(n);
                    bl = string2.equals(stylesheetContainer.fname);
                    if (!bl) continue;
                    String string5 = stylesheetContainer.stylesheet.getUrl();
                    byte[] byArray = StyleManager.calculateCheckSum(string5);
                    bl = Arrays.equals(byArray, stylesheetContainer.checksum);
                }
                if (bl) {
                    return;
                }
            }
            bl = false;
            n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                string3 = list2.get(n);
                String string6 = string2 = string3 != null ? string3.trim() : null;
                if (string2 == null || string2.isEmpty()) continue;
                if (!bl) {
                    this.platformUserAgentStylesheetContainers.clear();
                    bl = true;
                }
                if (n == 0) {
                    this._setDefaultUserAgentStylesheet(string2);
                    continue;
                }
                this._addUserAgentStylesheet(string2);
            }
            if (bl) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    public void addUserAgentStylesheet(String string2) {
        this.addUserAgentStylesheet(null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserAgentStylesheet(Scene scene, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2.trim() : null;
        if (string3 == null || string3.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            if (this._addUserAgentStylesheet(string3)) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _addUserAgentStylesheet(String string2) {
        Object object = styleLock;
        synchronized (object) {
            int n = this.platformUserAgentStylesheetContainers.size();
            for (int j = 0; j < n; ++j) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(j);
                if (!string2.equals(stylesheetContainer.fname)) continue;
                return false;
            }
            Stylesheet stylesheet = StyleManager.loadStylesheet(string2);
            if (stylesheet == null) {
                return false;
            }
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(string2, stylesheet));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserAgentStylesheet(Scene scene, Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException("null arg ua_stylesheet");
        }
        String string2 = stylesheet.getUrl();
        String string3 = string2 != null ? string2.trim() : "";
        Object object = styleLock;
        synchronized (object) {
            int n = this.platformUserAgentStylesheetContainers.size();
            for (int j = 0; j < n; ++j) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(j);
                if (!string3.equals(stylesheetContainer.fname)) continue;
                return;
            }
            this.platformUserAgentStylesheetContainers.add(new StylesheetContainer(string3, stylesheet));
            if (stylesheet != null) {
                stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            }
            this.userAgentStylesheetsChanged();
        }
    }

    public void setDefaultUserAgentStylesheet(String string2) {
        this.setDefaultUserAgentStylesheet(null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultUserAgentStylesheet(Scene scene, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2.trim() : null;
        if (string3 == null || string3.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            if (this._setDefaultUserAgentStylesheet(string3)) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _setDefaultUserAgentStylesheet(String string2) {
        Object object = styleLock;
        synchronized (object) {
            int n = this.platformUserAgentStylesheetContainers.size();
            for (int j = 0; j < n; ++j) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(j);
                if (!string2.equals(stylesheetContainer.fname)) continue;
                if (j > 0) {
                    this.platformUserAgentStylesheetContainers.remove(j);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
                    }
                }
                return j > 0;
            }
            Stylesheet stylesheet = StyleManager.loadStylesheet(string2);
            if (stylesheet == null) {
                return false;
            }
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            StylesheetContainer stylesheetContainer = new StylesheetContainer(string2, stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(stylesheetContainer);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
            }
            this.hasDefaultUserAgentStylesheet = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserAgentStylesheet(String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2.trim() : null;
        if (string3 == null || string3.isEmpty()) {
            return;
        }
        Object object = styleLock;
        synchronized (object) {
            boolean bl = false;
            for (int j = this.platformUserAgentStylesheetContainers.size() - 1; j >= 0; --j) {
                if (string3.equals(Application.getUserAgentStylesheet())) continue;
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(j);
                if (!string3.equals(stylesheetContainer.fname)) continue;
                this.platformUserAgentStylesheetContainers.remove(j);
                bl = true;
            }
            if (bl) {
                this.userAgentStylesheetsChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultUserAgentStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            return;
        }
        String string2 = stylesheet.getUrl();
        String string3 = string2 != null ? string2.trim() : "";
        Object object = styleLock;
        synchronized (object) {
            int n = this.platformUserAgentStylesheetContainers.size();
            for (int j = 0; j < n; ++j) {
                StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(j);
                if (!string3.equals(stylesheetContainer.fname)) continue;
                if (j > 0) {
                    this.platformUserAgentStylesheetContainers.remove(j);
                    if (this.hasDefaultUserAgentStylesheet) {
                        this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
                    } else {
                        this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
                    }
                }
                return;
            }
            StylesheetContainer stylesheetContainer = new StylesheetContainer(string3, stylesheet);
            if (this.platformUserAgentStylesheetContainers.size() == 0) {
                this.platformUserAgentStylesheetContainers.add(stylesheetContainer);
            } else if (this.hasDefaultUserAgentStylesheet) {
                this.platformUserAgentStylesheetContainers.set(0, stylesheetContainer);
            } else {
                this.platformUserAgentStylesheetContainers.add(0, stylesheetContainer);
            }
            this.hasDefaultUserAgentStylesheet = true;
            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
            this.userAgentStylesheetsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userAgentStylesheetsChanged() {
        ArrayList<Parent> arrayList = new ArrayList<Parent>();
        Iterator iterator2 = styleLock;
        synchronized (iterator2) {
            for (CacheContainer cacheContainer : cacheContainerMap.values()) {
                cacheContainer.clearCache();
            }
            StyleConverter.clearCache();
            for (Parent parent : cacheContainerMap.keySet()) {
                if (parent == null) continue;
                arrayList.add(parent);
            }
        }
        for (Parent parent : arrayList) {
            NodeHelper.reapplyCSS((Node)parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> processStylesheets(List<String> list2, Parent parent) {
        Object object = styleLock;
        synchronized (object) {
            ArrayList<StylesheetContainer> arrayList = new ArrayList<StylesheetContainer>();
            int n = list2.size();
            for (int j = 0; j < n; ++j) {
                Object object2;
                String string2 = list2.get(j);
                StylesheetContainer stylesheetContainer = null;
                if (this.stylesheetContainerMap.containsKey(string2)) {
                    stylesheetContainer = this.stylesheetContainerMap.get(string2);
                    if (!arrayList.contains(stylesheetContainer)) {
                        if (stylesheetContainer.checksumInvalid) {
                            object2 = StyleManager.calculateCheckSum(string2);
                            if (!Arrays.equals((byte[])object2, stylesheetContainer.checksum)) {
                                this.removeStylesheetContainer(stylesheetContainer);
                                Stylesheet stylesheet = StyleManager.loadStylesheet(string2);
                                stylesheetContainer = new StylesheetContainer(string2, stylesheet, (byte[])object2);
                                this.stylesheetContainerMap.put(string2, stylesheetContainer);
                            } else {
                                stylesheetContainer.checksumInvalid = false;
                            }
                        }
                        arrayList.add(stylesheetContainer);
                    }
                    stylesheetContainer.parentUsers.add(parent);
                    continue;
                }
                object2 = StyleManager.loadStylesheet(string2);
                stylesheetContainer = new StylesheetContainer(string2, (Stylesheet)object2);
                stylesheetContainer.parentUsers.add(parent);
                this.stylesheetContainerMap.put(string2, stylesheetContainer);
                arrayList.add(stylesheetContainer);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> gatherParentStylesheets(Parent parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        List<String> list2 = ParentHelper.getAllParentStylesheets(parent);
        if (list2 == null || list2.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            return this.processStylesheets(list2, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StylesheetContainer> gatherSceneStylesheets(Scene scene) {
        if (scene == null) {
            return Collections.emptyList();
        }
        ObservableList observableList = scene.getStylesheets();
        if (observableList == null || observableList.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = styleLock;
        synchronized (object) {
            return this.processStylesheets((List<String>)observableList, scene.getRoot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyleMap findMatchingStyles(Node node, SubScene subScene, Set<PseudoClass>[] setArray) {
        Scene scene = node.getScene();
        if (scene == null) {
            return StyleMap.EMPTY_MAP;
        }
        CacheContainer cacheContainer = this.getCacheContainer((Styleable)node, subScene);
        if (cacheContainer == null) {
            assert (false) : node.toString();
            return StyleMap.EMPTY_MAP;
        }
        Object object = styleLock;
        synchronized (object) {
            Object object2;
            boolean bl;
            Node node2;
            Parent parent = node instanceof Parent ? (Parent)node : node.getParent();
            List<StylesheetContainer> list2 = this.gatherParentStylesheets(parent);
            boolean bl2 = !list2.isEmpty();
            List<StylesheetContainer> list3 = this.gatherSceneStylesheets(scene);
            boolean bl3 = !list3.isEmpty();
            String string2 = node.getStyle();
            boolean bl4 = string2 != null && !string2.trim().isEmpty();
            String string3 = scene.getUserAgentStylesheet();
            boolean bl5 = string3 != null && !string3.trim().isEmpty();
            String string4 = subScene != null ? subScene.getUserAgentStylesheet() : null;
            boolean bl6 = string4 != null && !string4.trim().isEmpty();
            String string5 = null;
            for (node2 = node; !(node2 == null || node2 instanceof Region && (string5 = this.weakRegionUserAgentStylesheetMap.computeIfAbsent((Region)node2, Region::getUserAgentStylesheet)) != null); node2 = node2.getParent()) {
            }
            boolean bl7 = bl = string5 != null && !string5.trim().isEmpty();
            if (!(bl4 || bl2 || bl3 || bl5 || bl6 || bl || !this.platformUserAgentStylesheetContainers.isEmpty())) {
                return StyleMap.EMPTY_MAP;
            }
            String string6 = node.getTypeSelector();
            String string7 = node.getId();
            ObservableList observableList = node.getStyleClass();
            if (this.key == null) {
                this.key = new Key();
            }
            this.key.className = string6;
            this.key.id = string7;
            int n = observableList.size();
            for (int j = 0; j < n; ++j) {
                object2 = (String)observableList.get(j);
                if (object2 == null || ((String)object2).isEmpty()) continue;
                this.key.styleClasses.add(StyleClassSet.getStyleClass((String)object2));
            }
            Map map2 = cacheContainer.getCacheMap(list2, string5);
            Cache cache = (Cache)map2.get(this.key);
            if (cache != null) {
                this.key.styleClasses.clear();
            } else {
                int n2;
                Object object3;
                object2 = new ArrayList();
                if (bl6 || bl5) {
                    object3 = bl6 ? subScene.getUserAgentStylesheet().trim() : scene.getUserAgentStylesheet().trim();
                    StylesheetContainer stylesheetContainer = null;
                    int n3 = this.userAgentStylesheetContainers.size();
                    for (n2 = 0; n2 < n3; ++n2) {
                        stylesheetContainer = this.userAgentStylesheetContainers.get(n2);
                        if (((String)object3).equals(stylesheetContainer.fname)) break;
                        stylesheetContainer = null;
                    }
                    if (stylesheetContainer == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet((String)object3);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        stylesheetContainer = new StylesheetContainer((String)object3, stylesheet);
                        this.userAgentStylesheetContainers.add(stylesheetContainer);
                    }
                    if (stylesheetContainer.selectorPartitioning != null) {
                        Parent parent2 = bl6 ? subScene.getRoot() : scene.getRoot();
                        stylesheetContainer.parentUsers.add(parent2);
                        List<Selector> list4 = stylesheetContainer.selectorPartitioning.match(string7, string6, (Set<StyleClass>)((Object)this.key.styleClasses));
                        object2.addAll(list4);
                    }
                } else if (!this.platformUserAgentStylesheetContainers.isEmpty()) {
                    int n4 = this.platformUserAgentStylesheetContainers.size();
                    for (int j = 0; j < n4; ++j) {
                        StylesheetContainer stylesheetContainer = this.platformUserAgentStylesheetContainers.get(j);
                        if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list5 = stylesheetContainer.selectorPartitioning.match(string7, string6, (Set<StyleClass>)((Object)this.key.styleClasses));
                        object2.addAll(list5);
                    }
                }
                if (bl) {
                    object3 = null;
                    n2 = this.userAgentStylesheetContainers.size();
                    for (int j = 0; j < n2; ++j) {
                        object3 = this.userAgentStylesheetContainers.get(j);
                        if (string5.equals(((StylesheetContainer)object3).fname)) break;
                        object3 = null;
                    }
                    if (object3 == null) {
                        Stylesheet stylesheet = StyleManager.loadStylesheet(string5);
                        if (stylesheet != null) {
                            stylesheet.setOrigin(StyleOrigin.USER_AGENT);
                        }
                        object3 = new StylesheetContainer(string5, stylesheet);
                        this.userAgentStylesheetContainers.add((StylesheetContainer)object3);
                    }
                    if (((StylesheetContainer)object3).selectorPartitioning != null) {
                        ((StylesheetContainer)object3).parentUsers.add((Parent)node2);
                        List<Selector> list6 = ((StylesheetContainer)object3).selectorPartitioning.match(string7, string6, (Set<StyleClass>)((Object)this.key.styleClasses));
                        object2.addAll(list6);
                    }
                }
                if (!list3.isEmpty()) {
                    int n5 = list3.size();
                    for (int j = 0; j < n5; ++j) {
                        StylesheetContainer stylesheetContainer = list3.get(j);
                        if (stylesheetContainer == null || stylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list7 = stylesheetContainer.selectorPartitioning.match(string7, string6, (Set<StyleClass>)((Object)this.key.styleClasses));
                        object2.addAll(list7);
                    }
                }
                if (bl2) {
                    int n6 = list2 == null ? 0 : list2.size();
                    for (int j = 0; j < n6; ++j) {
                        StylesheetContainer stylesheetContainer = list2.get(j);
                        if (stylesheetContainer.selectorPartitioning == null) continue;
                        List<Selector> list8 = stylesheetContainer.selectorPartitioning.match(string7, string6, (Set<StyleClass>)((Object)this.key.styleClasses));
                        object2.addAll(list8);
                    }
                }
                cache = new Cache((List<Selector>)object2);
                map2.put(this.key, cache);
                this.key = null;
            }
            object2 = cache.getStyleMap(cacheContainer, node, setArray, bl4);
            return object2;
        }
    }

    public static ObservableList<CssParser.ParseError> errorsProperty() {
        if (errors == null) {
            errors = FXCollections.observableArrayList();
        }
        return errors;
    }

    public static ObservableList<CssParser.ParseError> getErrors() {
        return errors;
    }

    static {
        cacheContainerMap = new WeakHashMap<Parent, CacheContainer>();
        errors = null;
    }

    private static class Key {
        String className;
        String id;
        final StyleClassSet styleClasses = new StyleClassSet();

        private Key() {
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Key) {
                Key key2 = (Key)object;
                if (this.className == null ? key2.className != null : !this.className.equals(key2.className)) {
                    return false;
                }
                if (this.id == null ? key2.id != null : !this.id.equals(key2.id)) {
                    return false;
                }
                return this.styleClasses.equals(key2.styleClasses);
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.className != null ? this.className.hashCode() : 0);
            n = 29 * n + (this.id != null ? this.id.hashCode() : 0);
            n = 29 * n + this.styleClasses.hashCode();
            return n;
        }
    }

    private static class Cache {
        private final List<Selector> selectors;
        private final Map<Key, Integer> cache;

        Cache(List<Selector> list2) {
            this.selectors = list2;
            this.cache = new HashMap<Key, Integer>();
        }

        private StyleMap getStyleMap(CacheContainer cacheContainer, Node node, Set<PseudoClass>[] setArray, boolean bl) {
            int n;
            Selector selector;
            Object object;
            if ((this.selectors == null || this.selectors.isEmpty()) && !bl) {
                return StyleMap.EMPTY_MAP;
            }
            int n2 = this.selectors.size();
            long[] lArray = new long[n2 / 64 + 1];
            boolean bl2 = true;
            for (int j = 0; j < n2; ++j) {
                long l;
                object = this.selectors.get(j);
                if (!object.applies((Styleable)node, (Set[])setArray, 0)) continue;
                int n3 = j / 64;
                lArray[n3] = l = lArray[n3] | 1L << j;
                bl2 = false;
            }
            if (bl2 && !bl) {
                return StyleMap.EMPTY_MAP;
            }
            String string2 = node.getStyle();
            object = new Key(lArray, string2);
            if (this.cache.containsKey(object)) {
                Integer n4 = this.cache.get(object);
                StyleMap styleMap = n4 != null ? cacheContainer.getStyleMap(n4) : StyleMap.EMPTY_MAP;
                return styleMap;
            }
            ArrayList<Selector> arrayList = new ArrayList<Selector>();
            if (bl && (selector = cacheContainer.getInlineStyleSelector(string2)) != null) {
                arrayList.add(selector);
            }
            for (n = 0; n < lArray.length; ++n) {
                if (lArray[n] == 0L) continue;
                int n5 = n * 64;
                for (int j = 0; j < 64; ++j) {
                    long l = 1L << j;
                    if ((l & lArray[n]) != l) continue;
                    Selector selector2 = this.selectors.get(n5 + j);
                    arrayList.add(selector2);
                }
            }
            n = cacheContainer.nextSmapId();
            this.cache.put((Key)object, n);
            StyleMap styleMap = new StyleMap(n, arrayList);
            cacheContainer.addStyleMap(styleMap);
            return styleMap;
        }

        private static class Key {
            final long[] key;
            final String inlineStyle;

            Key(long[] lArray, String string2) {
                this.key = lArray;
                this.inlineStyle = string2 != null && string2.trim().isEmpty() ? null : string2;
            }

            public String toString() {
                return Arrays.toString(this.key) + (String)(this.inlineStyle != null ? "* {" + this.inlineStyle + "}" : "");
            }

            public int hashCode() {
                int n = 3;
                n = 17 * n + Arrays.hashCode(this.key);
                if (this.inlineStyle != null) {
                    n = 17 * n + this.inlineStyle.hashCode();
                }
                return n;
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                Key key2 = (Key)object;
                if (this.inlineStyle == null ? key2.inlineStyle != null : !this.inlineStyle.equals(key2.inlineStyle)) {
                    return false;
                }
                return Arrays.equals(this.key, key2.key);
            }
        }
    }

    static class CacheContainer {
        private Map<StyleCache.Key, StyleCache> styleCache;
        private Map<List<String>, Map<Key, Cache>> cacheMap;
        private List<StyleMap> styleMapList;
        private Map<String, Selector> inlineStylesCache;
        private int styleMapId = 0;
        private int baseStyleMapId = 0;

        CacheContainer() {
        }

        private Map<StyleCache.Key, StyleCache> getStyleCache() {
            if (this.styleCache == null) {
                this.styleCache = new HashMap<StyleCache.Key, StyleCache>();
            }
            return this.styleCache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Key, Cache> getCacheMap(List<StylesheetContainer> list2, String string2) {
            if (this.cacheMap == null) {
                this.cacheMap = new HashMap<List<String>, Map<Key, Cache>>();
            }
            Object object = styleLock;
            synchronized (object) {
                Map<Key, Cache> map2;
                if ((list2 == null || list2.isEmpty()) && (string2 == null || string2.isEmpty())) {
                    Map<Key, Cache> map3 = this.cacheMap.get(null);
                    if (map3 == null) {
                        map3 = new HashMap<Key, Cache>();
                        this.cacheMap.put(null, map3);
                    }
                    return map3;
                }
                int n = list2.size();
                if (cacheMapKey == null) {
                    cacheMapKey = new ArrayList(n);
                }
                for (int j = 0; j < n; ++j) {
                    StylesheetContainer stylesheetContainer = list2.get(j);
                    if (stylesheetContainer == null || stylesheetContainer.fname == null || stylesheetContainer.fname.isEmpty()) continue;
                    cacheMapKey.add(stylesheetContainer.fname);
                }
                if (string2 != null) {
                    cacheMapKey.add(string2);
                }
                if ((map2 = this.cacheMap.get(cacheMapKey)) == null) {
                    map2 = new HashMap<Key, Cache>();
                    this.cacheMap.put(cacheMapKey, map2);
                    cacheMapKey = null;
                } else {
                    cacheMapKey.clear();
                }
                return map2;
            }
        }

        private List<StyleMap> getStyleMapList() {
            if (this.styleMapList == null) {
                this.styleMapList = new ArrayList<StyleMap>();
            }
            return this.styleMapList;
        }

        private int nextSmapId() {
            this.styleMapId = this.baseStyleMapId + this.getStyleMapList().size();
            return this.styleMapId;
        }

        private void addStyleMap(StyleMap styleMap) {
            this.getStyleMapList().add(styleMap);
        }

        public StyleMap getStyleMap(int n) {
            int n2 = n - this.baseStyleMapId;
            if (0 <= n2 && n2 < this.getStyleMapList().size()) {
                return this.getStyleMapList().get(n2);
            }
            return StyleMap.EMPTY_MAP;
        }

        private void clearCache() {
            if (this.cacheMap != null) {
                this.cacheMap.clear();
            }
            if (this.styleCache != null) {
                this.styleCache.clear();
            }
            if (this.styleMapList != null) {
                this.styleMapList.clear();
            }
            this.baseStyleMapId = this.styleMapId;
            if (this.baseStyleMapId > 0x6FFFFFF9) {
                this.styleMapId = 0;
                this.baseStyleMapId = 0;
            }
        }

        private Selector getInlineStyleSelector(String string2) {
            Stylesheet stylesheet;
            if (string2 == null || string2.trim().isEmpty()) {
                return null;
            }
            if (this.inlineStylesCache != null && this.inlineStylesCache.containsKey(string2)) {
                return this.inlineStylesCache.get(string2);
            }
            if (this.inlineStylesCache == null) {
                this.inlineStylesCache = new HashMap<String, Selector>();
            }
            if ((stylesheet = new CssParser().parse("*{" + string2 + "}")) != null) {
                Selector selector;
                stylesheet.setOrigin(StyleOrigin.INLINE);
                List list2 = stylesheet.getRules();
                Rule rule = list2 != null && !list2.isEmpty() ? (Rule)list2.get(0) : null;
                ObservableList observableList = rule != null ? rule.getSelectors() : null;
                Selector selector2 = selector = observableList != null && !observableList.isEmpty() ? (Selector)observableList.get(0) : null;
                if (selector != null) {
                    selector.setOrdinal(-1);
                    this.inlineStylesCache.put(string2, selector);
                    return selector;
                }
            }
            this.inlineStylesCache.put(string2, null);
            return null;
        }
    }

    private static final class ImageCache {
        private Map<String, SoftReference<Image>> imageCache = new HashMap<String, SoftReference<Image>>();

        private ImageCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Image getCachedImage(String string2) {
            Object object = styleLock;
            synchronized (object) {
                Image image;
                block11: {
                    image = null;
                    if (this.imageCache.containsKey(string2)) {
                        image = this.imageCache.get(string2).get();
                    }
                    if (image == null) {
                        try {
                            image = new Image(string2);
                            if (image.isError()) {
                                PlatformLogger platformLogger = StyleManager.getLogger();
                                if (platformLogger != null && platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                                    platformLogger.warning("Error loading image: " + string2);
                                }
                                image = null;
                            }
                            this.imageCache.put(string2, new SoftReference<Image>(image));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            PlatformLogger platformLogger = StyleManager.getLogger();
                            if (platformLogger != null && platformLogger.isLoggable(PlatformLogger.Level.WARNING)) {
                                platformLogger.warning(illegalArgumentException.getLocalizedMessage());
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            PlatformLogger platformLogger = StyleManager.getLogger();
                            if (platformLogger == null || !platformLogger.isLoggable(PlatformLogger.Level.WARNING)) break block11;
                            platformLogger.warning(nullPointerException.getLocalizedMessage());
                        }
                    }
                }
                return image;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUpImageCache(String string2) {
            Object object = styleLock;
            synchronized (object) {
                if (string2 == null || this.imageCache.isEmpty()) {
                    return;
                }
                String string3 = string2.trim();
                if (string3.isEmpty()) {
                    return;
                }
                int n = string3.lastIndexOf(47);
                String string4 = n > 0 ? string3.substring(0, n) : string3;
                int n2 = string4.length();
                String[] stringArray = new String[this.imageCache.size()];
                int n3 = 0;
                Set<Map.Entry<String, SoftReference<Image>>> set2 = this.imageCache.entrySet();
                for (Map.Entry<String, SoftReference<Image>> entry : set2) {
                    String string5 = entry.getKey();
                    if (entry.getValue().get() == null) {
                        stringArray[n3++] = string5;
                        continue;
                    }
                    n = string5.lastIndexOf(47);
                    String string6 = n > 0 ? string5.substring(0, n) : string5;
                    int n4 = string6.length();
                    boolean bl = n4 > n2 ? string6.startsWith(string4) : string4.startsWith(string6);
                    if (!bl) continue;
                    stringArray[n3++] = string5;
                }
                for (int j = 0; j < n3; ++j) {
                    this.imageCache.remove(stringArray[j]);
                }
            }
        }
    }

    static class RefList<K> {
        final List<Reference<K>> list = new ArrayList<Reference<K>>();

        RefList() {
        }

        void add(K k) {
            for (int j = this.list.size() - 1; 0 <= j; --j) {
                Reference<K> reference = this.list.get(j);
                K k2 = reference.get();
                if (k2 == null) {
                    this.list.remove(j);
                    continue;
                }
                if (k2 != k) continue;
                return;
            }
            this.list.add(new WeakReference<K>(k));
        }

        void remove(K k) {
            for (int j = this.list.size() - 1; 0 <= j; --j) {
                Reference<K> reference = this.list.get(j);
                K k2 = reference.get();
                if (k2 == null) {
                    this.list.remove(j);
                    continue;
                }
                if (k2 != k) continue;
                this.list.remove(j);
                return;
            }
        }

        boolean contains(K k) {
            for (int j = this.list.size() - 1; 0 <= j; --j) {
                Reference<K> reference = this.list.get(j);
                K k2 = reference.get();
                if (k2 != k) continue;
                return true;
            }
            return false;
        }
    }

    static class StylesheetContainer {
        final String fname;
        final Stylesheet stylesheet;
        final SelectorPartitioning selectorPartitioning;
        final RefList<Parent> parentUsers;
        final int hash;
        final byte[] checksum;
        boolean checksumInvalid = false;

        StylesheetContainer(String string2, Stylesheet stylesheet) {
            this(string2, stylesheet, stylesheet != null ? StyleManager.calculateCheckSum(stylesheet.getUrl()) : new byte[]{});
        }

        StylesheetContainer(String string2, Stylesheet stylesheet, byte[] byArray) {
            this.fname = string2;
            this.hash = string2 != null ? string2.hashCode() : 127;
            this.stylesheet = stylesheet;
            if (stylesheet != null) {
                this.selectorPartitioning = new SelectorPartitioning();
                List list2 = stylesheet.getRules();
                int n = list2 == null || list2.isEmpty() ? 0 : list2.size();
                for (int j = 0; j < n; ++j) {
                    Rule rule = (Rule)list2.get(j);
                    ObservableList observableList = rule.getSelectors();
                    int n2 = observableList == null || observableList.isEmpty() ? 0 : observableList.size();
                    for (int k = 0; k < n2; ++k) {
                        Selector selector = (Selector)observableList.get(k);
                        this.selectorPartitioning.partition(selector);
                    }
                }
            } else {
                this.selectorPartitioning = null;
            }
            this.parentUsers = new RefList();
            this.checksum = byArray;
        }

        void invalidateChecksum() {
            this.checksumInvalid = this.checksum.length > 0;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            StylesheetContainer stylesheetContainer = (StylesheetContainer)object;
            return !(this.fname == null ? stylesheetContainer.fname != null : !this.fname.equals(stylesheetContainer.fname));
        }

        public String toString() {
            return this.fname;
        }
    }

    private static class InstanceHolder {
        static final StyleManager INSTANCE = new StyleManager();

        private InstanceHolder() {
        }
    }
}

