/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class Library {
    static final String SEPARATOR = System.getProperty("file.separator");

    static boolean extract(String fileName, String mappedName) {
        File file;
        block14: {
            FileOutputStream os = null;
            InputStream is = null;
            file = new File(fileName);
            try {
                int read;
                if (file.exists() || (is = Library.class.getResourceAsStream("/src/" + mappedName)) == null) break block14;
                byte[] buffer = new byte[4096];
                os = new FileOutputStream(fileName);
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.close();
                is.close();
                if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", fileName}).waitFor();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (Library.load(fileName)) {
                    return true;
                }
            }
            catch (Throwable e) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (file.exists()) {
            file.delete();
        }
        return false;
    }

    static boolean load(String libName) {
        try {
            if (libName.indexOf(SEPARATOR) != -1) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static void loadLibrary(String name) {
        Library.loadLibrary(name, true);
    }

    public static void loadLibrary(String name, boolean mapName) {
        String mappedName;
        String libName;
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (mapName) {
            libName = name;
            mappedName = System.mapLibraryName(libName);
        } else {
            libName = mappedName = name;
        }
        String osPath = System.getProperty("os.name").toLowerCase();
        if (osPath.startsWith("win")) {
            osPath = "win" + prop + "/";
        } else if (osPath.startsWith("lin")) {
            osPath = "lnx" + prop + "/";
        } else if (osPath.startsWith("mac")) {
            osPath = "mac/";
        }
        if (Library.load(libName)) {
            return;
        }
        if (mapName && Library.load(libName)) {
            return;
        }
        String path = System.getProperty("user.dir");
        if (Library.load(String.valueOf(path = new File(path).getAbsolutePath()) + SEPARATOR + mappedName)) {
            return;
        }
        path = System.getProperty("java.io.tmpdir");
        if (Library.load(String.valueOf(path = new File(path).getAbsolutePath()) + SEPARATOR + mappedName)) {
            return;
        }
        if (path != null && Library.extract(String.valueOf(path) + SEPARATOR + mappedName, String.valueOf(osPath) + mappedName)) {
            return;
        }
        throw new UnsatisfiedLinkError("no " + libName + " in java.library.path or the jar file");
    }
}

