/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.GDE;
import gde.device.resource.DeviceXmlResource;
import gde.histo.recordings.TrailDataTags;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordFormatter;
import gde.histo.recordings.TrailRecordSet;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.LocalizedDateTime;
import gde.utils.StringHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.stream.Collectors;

public final class TrailRecordSetFormatter {
    private static final int MAX_TOOLTIP_LINES = 33;

    public static String getSelectedMeasurementsAsTable(long timestamp_ms) {
        TrailRecordSet trailRecordSet = DataExplorer.getInstance().getPresentHistoExplorer().getTrailRecordSet();
        if (trailRecordSet != null && trailRecordSet.getTimeStepSize() > 0) {
            Properties displayProps = trailRecordSet.getAnalyzer().getSettings().getMeasurementDisplayProperties();
            Vector<TrailRecord> records = trailRecordSet.getVisibleAndDisplayableRecords();
            StringBuilder sb = new StringBuilder().append(String.format("%-11.11s", Messages.getString("GDE_MSGT0799")));
            sb.append("|").append(String.format("%-16s", Messages.getString("GDE_MSGT0652")));
            DeviceXmlResource xmlResource = DeviceXmlResource.getInstance();
            for (int i = 0; i < records.size(); ++i) {
                String replacedName;
                TrailRecord record = records.get(i);
                if (displayProps.getProperty(record.getName()) != null) {
                    sb.append("|").append(String.format("%-10s", displayProps.getProperty(record.getName())));
                    continue;
                }
                String unit = "[" + record.getUnit() + "]";
                String name = replacedName.substring(0, (replacedName = xmlResource.getReplacement(record.getName())).length() >= 10 - unit.length() ? 10 - unit.length() : replacedName.length());
                String format = "%-" + (10 - unit.length()) + "s%" + unit.length() + "s";
                sb.append("|").append(String.format(format, name, unit));
            }
            sb.append("|").append(GDE.LINE_SEPARATOR);
            int index = trailRecordSet.getIndex(timestamp_ms);
            sb.append(String.format("%-11.11s", trailRecordSet.getDataTagText(index, TrailDataTags.DataTag.RECORDSET_BASE_NAME)));
            sb.append("|").append(String.format("%-16s", LocalizedDateTime.getFormatedTime(LocalizedDateTime.DateTimePattern.yyyyMMdd_HHmm, timestamp_ms)).substring(0, 16));
            for (int i = 0; i < records.size(); ++i) {
                TrailRecord record = records.get(i);
                sb.append("|").append(String.format("%.10s", StringHelper.center(new TrailRecordFormatter(record).getMeasureValue(index), 10)));
            }
            return sb.append("|").toString();
        }
        return "";
    }

    public static String getFileNameLines(List<Integer> indices) {
        TrailRecordSet trailRecordSet = DataExplorer.getInstance().getPresentHistoExplorer().getTrailRecordSet();
        if (trailRecordSet != null) {
            String fileNameLines = indices.stream().map(i -> trailRecordSet.getDataTagText((int)i, TrailDataTags.DataTag.FILE_PATH)).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getFileName).map(Path::toString).sorted(Comparator.reverseOrder()).limit(33L).collect(Collectors.joining("\n"));
            String suffix = indices.size() > 33 ? "\n..." : "";
            return fileNameLines + suffix;
        }
        return "";
    }
}

