/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.recordings;

import gde.device.TrailTypes;
import gde.histo.cache.ExtendedVault;
import gde.histo.datasources.HistoSet;
import gde.histo.guard.Reminder;
import gde.histo.recordings.TrailRecord;
import gde.histo.ui.SummaryComposite;
import gde.messages.Messages;
import gde.utils.StringHelper;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Vector;
import java.util.stream.Collectors;

public final class TrailRecordFormatter {
    private final int TRAIL_TEXT_MAX_LENGTH = 13;
    private final TrailRecord record;

    private static String trunc(String ss, int maxLength) {
        return ss.substring(0, Math.min(maxLength, ss.length()));
    }

    public static DecimalFormat getDecimalFormat(double[] valuePair) {
        return TrailRecordFormatter.getDecimalFormat(valuePair[0], valuePair[1]);
    }

    private static DecimalFormat getDecimalFormat(double value1, double value2) {
        DecimalFormat df = new DecimalFormat();
        double rangeValue = Math.abs(value1 - value2);
        if (Math.abs(value1) < 10.0 && Math.abs(value2) < 10.0) {
            if (rangeValue < 0.01) {
                df.applyPattern("0.0000");
            } else if (rangeValue < 0.1) {
                df.applyPattern("0.000");
            } else {
                df.applyPattern("0.00");
            }
        } else if (Math.abs(value1) < 100.0 && Math.abs(value2) < 100.0) {
            if (rangeValue < 0.1) {
                df.applyPattern("0.000");
            } else if (rangeValue < 1.0) {
                df.applyPattern("0.00");
            } else {
                df.applyPattern("0.0");
            }
        } else if (Math.abs(value1) < 1000.0 && Math.abs(value2) < 1000.0) {
            if (rangeValue < 1.0) {
                df.applyPattern("0.00");
            } else if (rangeValue < 10.0) {
                df.applyPattern("0.0");
            } else {
                df.applyPattern("0");
            }
        } else if (Math.abs(value1) < 10000.0 && Math.abs(value2) < 10000.0) {
            if (rangeValue < 10.0) {
                df.applyPattern("0.0");
            } else {
                df.applyPattern("0");
            }
        } else {
            df.applyPattern("0");
        }
        return df;
    }

    public TrailRecordFormatter(TrailRecord trailRecord) {
        this.record = trailRecord;
    }

    public DecimalFormat getDecimalFormat(int newNumberFormat) {
        DecimalFormat df = new DecimalFormat();
        switch (newNumberFormat) {
            case -1: {
                df = TrailRecordFormatter.getDecimalFormat(this.record.getMaxScaleValue(), this.record.getMinScaleValue());
                break;
            }
            case 0: {
                df.applyPattern("0");
                break;
            }
            case 1: {
                df.applyPattern("0.0");
                break;
            }
            default: {
                df.applyPattern("0.00");
                break;
            }
            case 3: {
                df.applyPattern("0.000");
            }
        }
        return df;
    }

    public String getSummaryValue(double finalValue, DecimalFormat decimalFormat) {
        if (HistoSet.isGpsCoordinates(this.record)) {
            if (this.record.getUnit().endsWith("'")) {
                return StringHelper.getFormatedWithMinutes("%2d %04.1f", finalValue);
            }
            return decimalFormat.format(finalValue);
        }
        return decimalFormat.format(finalValue);
    }

    public String getScaleValue(double finalValue) {
        if (HistoSet.isGpsCoordinates(this.record)) {
            if (this.record.getUnit().endsWith("'")) {
                return StringHelper.getFormatedWithMinutes("%2d %04.1f", finalValue);
            }
            return this.record.getDecimalFormat().format(finalValue);
        }
        return this.record.getDecimalFormat().format(finalValue);
    }

    public String getTableSuiteValue(int index, TrailTypes trailType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTruncatedTableValue(trailType.getSuiteLowerIndex(), index, 8));
        String d = sb.length() > 3 ? Character.toString('\u00b7') : " : ";
        sb.append(d).append(this.getTruncatedTableValue(trailType.getSuiteMasterIndex(), index, 8));
        sb.append(d).append(this.getTruncatedTableValue(trailType.getSuiteUpperIndex(), index, 8));
        String cellValue = sb.toString();
        return cellValue;
    }

    private String getTruncatedTableValue(int suiteOrdinal, int index, int length) {
        return TrailRecordFormatter.trunc(this.getTableValue((double)((Integer)this.record.getSuiteRecords().get(suiteOrdinal).get(index)).intValue() / 1000.0), length);
    }

    public String getMeasureValue(int index) {
        Vector<Integer> points = this.record.getPoints();
        if (points.elementAt(index) != null) {
            return this.getTableValue((double)points.elementAt(index).intValue() / 1000.0);
        }
        return "*";
    }

    public String getTableValue(double value) {
        String formattedValue = HistoSet.isGpsCoordinates(this.record) ? (this.record.getUnit().endsWith("'") ? StringHelper.getFormatedWithMinutes("%2d %07.4f", HistoSet.decodeVaultValue(this.record.getChannelItem(), value)).trim() : String.format("%8.6f", HistoSet.decodeVaultValue(this.record.getChannelItem(), value))) : this.record.getDecimalFormat().format(HistoSet.decodeVaultValue(this.record.getChannelItem(), value));
        return formattedValue;
    }

    public String getTableValue(int index) {
        return this.getTableValue((double)((Integer)this.record.elementAt(index)).intValue() / 1000.0);
    }

    public String defineFormattedMinWarning(SummaryComposite.SummaryLayout summary) {
        Reminder outliers = summary.getMinMaxWarning()[0];
        if (outliers == null) {
            return new String();
        }
        DecimalFormat df = summary.getDecimalFormat();
        if (outliers.getReminderType() == Reminder.ReminderType.WHISKER) {
            String values = outliers.getDecodedValues().stream().map(v -> this.getSummaryValue((double)v, df)).collect(Collectors.joining(", "));
            String fileNames = outliers.getIndices().stream().map(this.record.getParent()::getVault).map(ExtendedVault::getLoadFileAsPath).map(Path::getFileName).map(Path::toString).distinct().collect(Collectors.joining(", "));
            String outputText = outliers.getSelectText().length() > 13 ? outliers.getSelectText().substring(0, 12) + "..." : outliers.getSelectText();
            return outputText + " !" + Messages.getString("GDE_MSGT0906") + this.getSummaryValue(outliers.getFarLimit(), df) + "/" + this.getSummaryValue(outliers.getCloseLimit(), df) + outliers.getReminderType().localizedText() + Messages.getString("GDE_MSGT0911") + values + "\n" + fileNames;
        }
        String values = outliers.getDecodedValues().stream().map(v -> this.getSummaryValue((double)v, df)).collect(Collectors.joining(", "));
        String fileNames = outliers.getIndices().stream().map(this.record.getParent()::getVault).map(ExtendedVault::getLoadFileAsPath).map(Path::getFileName).map(Path::toString).distinct().collect(Collectors.joining(", "));
        String outputText = outliers.getSelectText().length() > 13 ? outliers.getSelectText().substring(0, 12) + "..." : outliers.getSelectText();
        return outputText + " !" + Messages.getString("GDE_MSGT0906") + this.getSummaryValue(outliers.getFarLimit(), df) + "/" + this.getSummaryValue(outliers.getCloseLimit(), df) + outliers.getReminderType().localizedText() + Messages.getString("GDE_MSGT0907") + values + "\n" + fileNames;
    }

    public String defineFormattedMaxWarning(SummaryComposite.SummaryLayout summary) {
        Reminder outliers = summary.getMinMaxWarning()[1];
        if (outliers == null) {
            return new String();
        }
        DecimalFormat df = summary.getDecimalFormat();
        if (outliers.getReminderType() == Reminder.ReminderType.WHISKER) {
            String values = outliers.getDecodedValues().stream().map(v -> this.getSummaryValue((double)v, df)).collect(Collectors.joining(", "));
            String fileNames = outliers.getIndices().stream().map(this.record.getParent()::getVault).map(ExtendedVault::getLoadFileAsPath).map(Path::getFileName).map(Path::toString).distinct().collect(Collectors.joining(", "));
            String outputText = outliers.getSelectText().length() > 13 ? outliers.getSelectText().substring(0, 12) + "..." : outliers.getSelectText();
            return outputText + " !" + Messages.getString("GDE_MSGT0906") + this.getSummaryValue(outliers.getCloseLimit(), df) + "/" + this.getSummaryValue(outliers.getFarLimit(), df) + outliers.getReminderType().localizedText() + Messages.getString("GDE_MSGT0911") + values + "\n" + fileNames;
        }
        String values = outliers.getDecodedValues().stream().map(v -> this.getSummaryValue((double)v, df)).collect(Collectors.joining(", "));
        String fileNames = outliers.getIndices().stream().map(this.record.getParent()::getVault).map(ExtendedVault::getLoadFileAsPath).map(Path::getFileName).map(Path::toString).distinct().collect(Collectors.joining(", "));
        String outputText = outliers.getSelectText().length() > 13 ? outliers.getSelectText().substring(0, 12) + "..." : outliers.getSelectText();
        return outputText + " !" + Messages.getString("GDE_MSGT0906") + this.getSummaryValue(outliers.getCloseLimit(), df) + "/" + this.getSummaryValue(outliers.getFarLimit(), df) + outliers.getReminderType().localizedText() + Messages.getString("GDE_MSGT0907") + values + "\n" + fileNames;
    }

    public String defineMinMaxWarningText(SummaryComposite.SummaryLayout summary) {
        String lineInitializer;
        String textLine1 = "";
        String textLine2 = "";
        String fileNameInitializer = Messages.getString("GDE_MSGT0908");
        String minMaxSeparator = "   >---<   ";
        String string = lineInitializer = this.record.getNameReplacement().length() > 13 ? this.record.getNameReplacement().substring(0, 12) + "..." + " > " : this.record.getNameReplacement() + " > ";
        if (summary.getMinMaxWarning()[0] != null) {
            if (summary.getMinMaxWarning()[0].getReminderType() == Reminder.ReminderType.FAR) {
                textLine1 = lineInitializer + this.defineFormattedMinWarning(summary).replace("\n", fileNameInitializer);
            } else {
                textLine2 = lineInitializer + this.defineFormattedMinWarning(summary).replace("\n", fileNameInitializer);
            }
        }
        if (summary.getMinMaxWarning()[1] != null) {
            lineInitializer = "                    " + lineInitializer;
            if (summary.getMinMaxWarning()[1].getReminderType() == Reminder.ReminderType.FAR) {
                textLine1 = textLine1.isEmpty() ? lineInitializer + this.defineFormattedMaxWarning(summary).replace("\n", fileNameInitializer) : textLine1 + "   >---<   " + this.defineFormattedMaxWarning(summary).replace("\n", fileNameInitializer);
            } else {
                textLine2 = textLine2.isEmpty() ? lineInitializer + this.defineFormattedMaxWarning(summary).replace("\n", fileNameInitializer) : textLine2 + "   >---<   " + this.defineFormattedMaxWarning(summary).replace("\n", fileNameInitializer);
            }
        }
        return textLine1 + "\n" + textLine2;
    }
}

