/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.resource.DeviceXmlResource;
import gde.device.skyrc.GplLogReader;
import gde.exception.DataInconsitsentException;
import gde.io.DataParser;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.GPSHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GPSLogger
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(GPSLogger.class.getName());
    final DataExplorer application;
    final Channels channels;

    public GPSLogger(String xmlFileName) throws FileNotFoundException, JAXBException {
        super(xmlFileName);
        Messages.setDeviceResourceBundle((String)"gde.device.skyrc.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGI3664"), Messages.getString((String)"GDE_MSGI3664"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public GPSLogger(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.skyrc.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGI3664"), Messages.getString((String)"GDE_MSGI3664"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGI3668", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGI3668"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + e);
                    GPSLogger.this.open_closeCommPort();
                }
            });
        }
    }

    public void updateFileMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGI3665"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DRelativeItem action performed! " + e);
                    GPSLogger.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGI3666"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    GPSLogger.this.export2KMZ3D(1);
                }
            });
            convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGI3667"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + e);
                    GPSLogger.this.export2KMZ3D(2);
                }
            });
            MenuItem convertGPXItem = new MenuItem(exportMenue, 8);
            convertGPXItem.setText(Messages.getString((String)"GDE_MSGT0728"));
            convertGPXItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertGPXItem action performed! " + e);
                    GPSLogger.this.export2GPX(false);
                }
            });
        }
    }

    public void export2KMZ3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGI3663"), 2, 3, 1, 0, -1, -1, -1, type == 0, type == 2);
    }

    public void export2GPX(boolean isGarminExtension) {
        new FileHandler().exportFileGPX(Messages.getString((String)"GDE_MSGT0730"), 3, 2, 1, 0, -1, -1, -1, -1, new int[0]);
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return null;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return null;
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        points[0] = DataParser.intFromBytes((byte)0, (byte)dataBuffer[0], (byte)dataBuffer[1], (byte)dataBuffer[2]) * 1000;
        points[1] = DataParser.intFromBytes((byte)0, (byte)dataBuffer[3], (byte)dataBuffer[4], (byte)dataBuffer[5]) * 1000;
        points[2] = dataBuffer[7] * 1000000 + DataParser.intFromBytes((byte)0, (byte)dataBuffer[8], (byte)dataBuffer[9], (byte)dataBuffer[10]) / 10;
        points[2] = dataBuffer[6] == 1 ? points[2] * -1 : points[2];
        points[3] = dataBuffer[12] * 1000000 + DataParser.intFromBytes((byte)0, (byte)dataBuffer[13], (byte)dataBuffer[14], (byte)dataBuffer[15]) / 10;
        points[3] = dataBuffer[11] == 1 ? points[3] * -1 : points[3];
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(java.util.logging.Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(java.util.logging.Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addNoneCalculationRecordsPoints(points);
            } else {
                recordSet.addNoneCalculationRecordsPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        this.makeInActiveDisplayable(recordSet);
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                dataTableRow[index + 1] = record.getOrdinal() == 2 || record.getOrdinal() == 3 ? String.format("%.6f", (double)record.get(rowIndex).intValue() / 1000000.0) : record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    /*
     * Unable to fully structure code
     */
    public double translateValue(Record record, double value) {
        block5: {
            factor = record.getFactor();
            offset = record.getOffset();
            reduction = record.getReduction();
            if (record.getOrdinal() != 1) break block5;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
                if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
                ** break block6
            }
            finally {
                newValue = 0.0;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    /*
     * Unable to fully structure code
     */
    public double reverseTranslateValue(Record record, double value) {
        block5: {
            factor = record.getFactor();
            offset = record.getOffset();
            reduction = record.getReduction();
            if (record.getOrdinal() != 1) break block5;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
            subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
            subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                }
                if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
                ** break block6
            }
            finally {
                newValue = 0.0;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        Record recordLatitude = recordSet.get(3);
        Record recordLongitude = recordSet.get(2);
        Record recordAlitude = recordSet.get(1);
        if (recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData() && recordAlitude.hasReasonableData()) {
            GPSHelper.calculateTripLength2D((IDevice)this, (RecordSet)recordSet, (int)3, (int)2, (int)4);
        }
        this.updateVisibilityStatus(recordSet, true);
        this.application.updateStatisticsData();
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, record.getName() + " = " + DeviceXmlResource.getInstance().getReplacement(this.getMeasurementNames(channelConfigNumber)[i]));
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isDisplayable()) continue;
            ++displayableCounter;
            if (!log.isLoggable(java.util.logging.Level.FINE)) continue;
            log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGI3662"));
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GPSLogger.this.application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith("*.3gpl")) {
                            if (selectedImportFile.contains(".")) {
                                selectedImportFile = selectedImportFile.substring(0, selectedImportFile.lastIndexOf(46));
                            }
                            selectedImportFile = selectedImportFile + ".3gpl";
                        }
                        log.log(java.util.logging.Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 5) continue;
                        try {
                            Integer channelConfigNumber = GPSLogger.this.application.getActiveChannelNumber();
                            String recordNameExtend = "";
                            RecordSet recordSet = GplLogReader.read(selectedImportFile, GPSLogger.this, recordNameExtend, channelConfigNumber);
                            if (recordSet != null) {
                                recordSet.get(1).setDataType(Record.DataType.GPS_ALTITUDE);
                                recordSet.get(2).setDataType(Record.DataType.GPS_LONGITUDE);
                                recordSet.get(3).setDataType(Record.DataType.GPS_LATITUDE);
                                continue;
                            }
                            GPSLogger.this.application.openMessageDialogAsync("Check " + selectedImportFile);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    GPSLogger.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            containsGPSdata = activeRecordSet.get(2).hasReasonableData() && activeRecordSet.get(3).hasReasonableData();
        }
        return containsGPSdata;
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getOrdinal() == 2 || record.getOrdinal() == 3;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 0;
        }
        return this.kmzMeasurementOrdinal;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz") && this.isActualRecordSetWithGpsData()) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            int ordinalLongitude = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE);
            ordinalLongitude = ordinalLongitude == -1 ? activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE_DEGREE) : ordinalLongitude;
            int ordinalLatitude = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE);
            ordinalLatitude = ordinalLatitude == -1 ? activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE_DEGREE) : ordinalLongitude;
            exportFileName = new FileHandler().exportFileKMZ(2, 3, 1, additionalMeasurementOrdinal, -1, -1, -1, true, isExportTmpDir);
        }
        return exportFileName;
    }
}

