/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String TEXT_RTF = "text/rtf";
    private static final int TEXT_RTF_ID = GTK.GTK4 ? 0 : RTFTransfer.registerType("text/rtf");
    private static final String TEXT_RTF2 = "TEXT/RTF";
    private static final int TEXT_RTF2_ID = GTK.GTK4 ? 0 : RTFTransfer.registerType("TEXT/RTF");
    private static final String APPLICATION_RTF = "application/rtf";
    private static final int APPLICATION_RTF_ID = GTK.GTK4 ? 0 : RTFTransfer.registerType("application/rtf");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        String string;
        byte[] byArray;
        long l;
        transferData.result = 0;
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((l = OS.g_malloc((byArray = Converter.wcsToMbcs(string = (String)object, true)).length)) == 0L) {
            return;
        }
        C.memmove(l, byArray, (long)byArray.length);
        transferData.length = byArray.length - 1;
        transferData.format = 8;
        transferData.pValue = l;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        int n = transferData.format * transferData.length / 8;
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        C.memmove(byArray, transferData.pValue, (long)n);
        char[] cArray = Converter.mbcsToWcs(byArray);
        String string = new String(cArray);
        int n2 = string.indexOf(0);
        return n2 == -1 ? string : string.substring(0, n2);
    }

    @Override
    protected int[] getTypeIds() {
        if (GTK.GTK4) {
            return new int[]{(int)OS.G_TYPE_STRING()};
        }
        return new int[]{TEXT_RTF_ID, TEXT_RTF2_ID, APPLICATION_RTF_ID};
    }

    @Override
    protected String[] getTypeNames() {
        if (GTK.GTK4) {
            return new String[]{TEXT_RTF};
        }
        return new String[]{TEXT_RTF, TEXT_RTF2, APPLICATION_RTF};
    }

    boolean checkRTF(Object object) {
        return object instanceof String && !((String)object).isEmpty();
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

