/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;

class TextWriter {
    private StringBuilder buffer;
    private int startOffset;
    private int endOffset;
    private boolean isClosed = false;

    public TextWriter(int n, int n2) {
        this.buffer = new StringBuilder(n2);
        this.startOffset = n;
        this.endOffset = n + n2;
    }

    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
        }
    }

    public int getCharCount() {
        return this.endOffset - this.startOffset;
    }

    public int getStart() {
        return this.startOffset;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String toString() {
        return this.buffer.toString();
    }

    void write(String string) {
        this.buffer.append(string);
    }

    void write(String string, int n) {
        if (n < 0 || n > this.buffer.length()) {
            return;
        }
        this.buffer.insert(n, string);
    }

    void write(int n) {
        this.buffer.append(n);
    }

    void write(char c) {
        this.buffer.append(c);
    }

    public void writeLine(String string, int n) {
        int n2;
        int n3;
        int n4;
        if (this.isClosed) {
            SWT.error(39);
        }
        if ((n4 = this.startOffset - n) >= (n3 = string.length())) {
            return;
        }
        int n5 = n4 > 0 ? n4 : 0;
        if (n5 < (n2 = Math.min(n3, this.endOffset - n))) {
            this.write(string.substring(n5, n2));
        }
    }

    public void writeLineDelimiter(String string) {
        if (this.isClosed) {
            SWT.error(39);
        }
        this.write(string);
    }
}

