/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.config.Settings;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.PropertyType;
import gde.device.renschler.DataGathererThread;
import gde.device.renschler.PicolarioDialog;
import gde.device.renschler.PicolarioSerialPort;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CalculationThread;
import gde.utils.LinearRegression;
import gde.utils.QuasiLinearRegression;
import gde.utils.StringHelper;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;

public class Picolario
extends DeviceConfiguration
implements IDevice {
    static final String $CLASS_NAME = Picolario.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final String DO_NO_ADAPTION = "do_no_adaption";
    public static final String DO_OFFSET_HEIGHT = "do_offset_height";
    public static final String DO_SUBTRACT_FIRST = MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value();
    public static final String DO_SUBTRACT_LAST = MeasurementPropertyTypes.DO_SUBTRACT_LAST.value();
    final DataExplorer application;
    protected DeviceDialog dialog;
    final PicolarioSerialPort serialPort;
    final Channels channels;
    DataGathererThread gatherThread;

    public Picolario(String iniFile) throws FileNotFoundException, JAXBException {
        super(iniFile);
        Messages.setDeviceResourceBundle((String)"gde.device.renschler.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new PicolarioSerialPort(this, this.application);
        this.dialog = new PicolarioDialog(this.application.getShell(), this);
        this.channels = Channels.getInstance();
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1222"), Messages.getString((String)"GDE_MSGT1221"));
        }
    }

    public Picolario(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.renschler.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.serialPort = new PicolarioSerialPort(this, this.application);
        this.dialog = new PicolarioDialog(this.application.getShell(), this);
        this.channels = Channels.getInstance();
        this.configureSerialPortMenu(1, Messages.getString((String)"GDE_MSGT1222"), Messages.getString((String)"GDE_MSGT1221"));
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 16;
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int offset = 4;
        int size = this.getLovDataByteSize();
        int deviceDataBufferSize = 3;
        byte[] convertBuffer = new byte[deviceDataBufferSize];
        int[] points = new int[deviceDataBufferSize];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, offset + i * size, convertBuffer, 0, deviceDataBufferSize);
            recordSet.addPoints(this.convertDataBytes(points, convertBuffer));
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        points[0] = Integer.valueOf(dataBuffer[2]) * 1000;
        points[1] = (dataBuffer[1] & 0x80) >> 7 == 0 ? ((dataBuffer[0] & 0xFF) + ((dataBuffer[1] & 0x7F) << 8)) * 1000 : ((dataBuffer[0] & 0xFF) + ((dataBuffer[1] & 0x7F) << 8)) * -1 * 1000;
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        for (int i = 0; i < recordDataSize; ++i) {
            System.arraycopy(dataBuffer, i * dataBufferSize, convertBuffer, 0, dataBufferSize);
            points[0] = ((convertBuffer[0] & 0xFF) << 24) + ((convertBuffer[1] & 0xFF) << 16) + ((convertBuffer[2] & 0xFF) << 8) + ((convertBuffer[3] & 0xFF) << 0);
            points[1] = ((convertBuffer[4] & 0xFF) << 24) + ((convertBuffer[5] & 0xFF) << 16) + ((convertBuffer[6] & 0xFF) << 8) + ((convertBuffer[7] & 0xFF) << 0);
            recordSet.addPoints(points);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                double offset = record.getOffset();
                double reduction = record.getReduction();
                double factor = record.getFactor();
                switch (record.getOrdinal()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        boolean subtractLast;
                        PropertyType property = record.getProperty(DO_SUBTRACT_FIRST);
                        boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                        property = record.getProperty(DO_SUBTRACT_LAST);
                        boolean bl = subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                        if (subtractFirst) {
                            reduction = (double)record.getFirst().intValue() / 1000.0;
                            break;
                        }
                        if (subtractLast) {
                            reduction = (double)record.getLast().intValue() / 1000.0;
                            break;
                        }
                        reduction = 0.0;
                        break;
                    }
                    case 2: {
                        factor = recordSet.get(1).getFactor();
                        break;
                    }
                    default: {
                        log.log(Level.WARNING, "exceed known record names");
                    }
                }
                dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        String $METHOD_NAME = "translateValue()";
        log.log(Level.FINEST, String.format("input value for %s - %f", record.getName(), value));
        String recordKey = "?";
        double newValue = 0.0;
        try {
            recordKey = record.getName();
            double offset = record.getOffset();
            double reduction = record.getReduction();
            double factor = record.getFactor();
            if (record.getOrdinal() == 1) {
                PropertyType property = record.getProperty(DO_SUBTRACT_FIRST);
                boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                property = record.getProperty(DO_SUBTRACT_LAST);
                boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                try {
                    if (subtractFirst) {
                        reduction = (double)record.getFirst().intValue() / 1000.0;
                    } else if (subtractLast) {
                        reduction = (double)record.getLast().intValue() / 1000.0;
                    }
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage() + " " + $CLASS_NAME + "." + "translateValue()");
                }
            } else if (record.getOrdinal() == 2) {
                factor = this.getMeasurementFactor(record.getParent().getChannelConfigNumber(), 1);
            }
            newValue = offset + (value - reduction) * factor;
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        log.log(Level.FINER, String.format("value calculated for %s - inValue %f - outValue %f", recordKey, value, newValue));
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        log.log(Level.FINEST, String.format("input value for %s - %f", record.getName(), value));
        String $METHOD_NAME = "reverseTranslateValue()";
        String recordKey = record.getName();
        double offset = record.getOffset();
        double reduction = record.getReduction();
        double factor = record.getFactor();
        if (record.getOrdinal() == 1) {
            PropertyType property = record.getProperty(DO_SUBTRACT_FIRST);
            boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
            property = record.getProperty(DO_SUBTRACT_LAST);
            boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
            try {
                if (subtractFirst) {
                    reduction = (double)record.getFirst().intValue() / 1000.0;
                } else if (subtractLast) {
                    reduction = (double)record.getLast().intValue() / 1000.0;
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, record.getAbstractParent().getName() + " " + record.getName() + " " + e.getMessage() + " " + $CLASS_NAME + "." + "reverseTranslateValue()");
            }
        } else if (record.getOrdinal() == 2) {
            factor = this.getMeasurementFactor(record.getParent().getChannelConfigNumber(), 1);
        }
        double newValue = (value - offset) / factor + reduction;
        log.log(Level.FINER, String.format("new value calculated for %s - inValue %f - outValue %f", recordKey, value, newValue));
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        recordSet.setAllDisplayable();
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet.isRaw() && recordSet.isRecalculation()) {
            Record slopeRecord = recordSet.get(2);
            slopeRecord.setDisplayable(false);
            PropertyType property = slopeRecord.getProperty(CalculationThread.REGRESSION_INTERVAL_SEC);
            int regressionInterval = property != null ? Integer.valueOf(property.getValue()) : 10;
            property = slopeRecord.getProperty(CalculationThread.REGRESSION_TYPE);
            this.calculationThread = property == null || property.getValue().equals(CalculationThread.REGRESSION_TYPE_CURVE) ? new QuasiLinearRegression(recordSet, recordSet.get(1).getName(), slopeRecord.getName(), regressionInterval) : new LinearRegression(recordSet, recordSet.get(1).getName(), slopeRecord.getName(), regressionInterval);
            try {
                this.calculationThread.start();
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION, DO_NO_ADAPTION, DO_OFFSET_HEIGHT, DO_SUBTRACT_FIRST, DO_SUBTRACT_LAST, CalculationThread.REGRESSION_INTERVAL_SEC, CalculationThread.REGRESSION_TYPE};
    }

    public DeviceDialog getDialog() {
        return this.dialog;
    }

    public PicolarioSerialPort getCommunicationPort() {
        return this.serialPort;
    }

    public void open_closeCommPort() {
        block8: {
            if (this.serialPort != null) {
                if (!this.serialPort.isConnected()) {
                    try {
                        int availableRecords;
                        if (this.dialog == null) break block8;
                        int n = availableRecords = ((PicolarioDialog)this.dialog).numberAvailable.length() == 0 ? 0 : Integer.parseInt(((PicolarioDialog)this.dialog).numberAvailable);
                        if (((PicolarioDialog)this.dialog).numberAvailable.length() == 0) {
                            this.serialPort.open();
                            availableRecords = this.serialPort.readNumberAvailableRecordSets();
                            this.serialPort.close();
                            ((PicolarioDialog)this.dialog).numberAvailable = Integer.valueOf(availableRecords).toString();
                        }
                        this.gatherThread = new DataGathererThread(this.application, this, this.serialPort, StringHelper.int2Array((int)availableRecords));
                        try {
                            this.gatherThread.start();
                            log.log(Level.FINE, "gatherThread.run() - executing");
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0025", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        this.application.getDeviceSelectionDialog().open();
                    }
                } else {
                    this.gatherThread.setThreadStop(true);
                }
            }
        }
    }
}

