/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Application;

public class ParametersImpl
extends Application.Parameters {
    private List<String> rawArgs = new ArrayList<String>();
    private Map<String, String> namedParams = new HashMap<String, String>();
    private List<String> unnamedParams = new ArrayList<String>();
    private List<String> readonlyRawArgs = null;
    private Map<String, String> readonlyNamedParams = null;
    private List<String> readonlyUnnamedParams = null;
    private static Map<Application, Application.Parameters> params = new HashMap<Application, Application.Parameters>();

    public ParametersImpl() {
    }

    public ParametersImpl(List<String> list2) {
        if (list2 != null) {
            this.init(list2);
        }
    }

    public ParametersImpl(String[] stringArray) {
        if (stringArray != null) {
            this.init(Arrays.asList(stringArray));
        }
    }

    public ParametersImpl(Map map2, String[] stringArray) {
        this.init(map2, stringArray);
    }

    private void init(List<String> list2) {
        for (String string2 : list2) {
            if (string2 == null) continue;
            this.rawArgs.add(string2);
        }
        this.computeNamedParams();
        this.computeUnnamedParams();
    }

    private void init(Map map2, String[] stringArray) {
        for (Map.Entry entry : map2.entrySet()) {
            Object object;
            Object k = entry.getKey();
            if (!this.validKey(k) || !((object = map2.get(k)) instanceof String)) continue;
            this.namedParams.put((String)k, (String)object);
        }
        this.computeRawArgs();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.unnamedParams.add(string2);
                this.rawArgs.add(string2);
            }
        }
    }

    private boolean validFirstChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private boolean validKey(Object object) {
        String string2;
        if (object instanceof String && (string2 = (String)object).length() > 0 && string2.indexOf(61) < 0) {
            return this.validFirstChar(string2.charAt(0));
        }
        return false;
    }

    private boolean isNamedParam(String string2) {
        if (string2.startsWith("--")) {
            return string2.indexOf(61) > 2 && this.validFirstChar(string2.charAt(2));
        }
        return false;
    }

    private void computeUnnamedParams() {
        for (String string2 : this.rawArgs) {
            if (this.isNamedParam(string2)) continue;
            this.unnamedParams.add(string2);
        }
    }

    private void computeNamedParams() {
        for (String string2 : this.rawArgs) {
            if (!this.isNamedParam(string2)) continue;
            int n = string2.indexOf(61);
            String string3 = string2.substring(2, n);
            String string4 = string2.substring(n + 1);
            this.namedParams.put(string3, string4);
        }
    }

    private void computeRawArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.namedParams.keySet());
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            this.rawArgs.add("--" + string2 + "=" + this.namedParams.get(string2));
        }
    }

    public List<String> getRaw() {
        if (this.readonlyRawArgs == null) {
            this.readonlyRawArgs = Collections.unmodifiableList(this.rawArgs);
        }
        return this.readonlyRawArgs;
    }

    public Map<String, String> getNamed() {
        if (this.readonlyNamedParams == null) {
            this.readonlyNamedParams = Collections.unmodifiableMap(this.namedParams);
        }
        return this.readonlyNamedParams;
    }

    public List<String> getUnnamed() {
        if (this.readonlyUnnamedParams == null) {
            this.readonlyUnnamedParams = Collections.unmodifiableList(this.unnamedParams);
        }
        return this.readonlyUnnamedParams;
    }

    public static Application.Parameters getParameters(Application application) {
        Application.Parameters parameters2 = params.get(application);
        return parameters2;
    }

    public static void registerParameters(Application application, Application.Parameters parameters2) {
        params.put(application, parameters2);
    }
}

