/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.menu;

import gde.config.Settings;
import gde.log.Level;
import java.util.logging.Logger;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class LogLevelSelectionContextMenu {
    static final Logger log = Logger.getLogger(LogLevelSelectionContextMenu.class.getName());
    MenuItem levelWarning;
    MenuItem levelTime;
    MenuItem levelInfo;
    MenuItem levelFine;
    MenuItem levelFiner;
    MenuItem levelFinest;
    String loggerName = "";
    final Settings settings;
    final String strWarning = Level.WARNING.getName();
    final String strTime = Level.TIME.getName();
    final String strInfo = Level.INFO.getName();
    final String strFine = Level.FINE.getName();
    final String strFiner = Level.FINER.getName();
    final String strFinest = Level.FINEST.getName();

    public LogLevelSelectionContextMenu() {
        this.settings = Settings.getInstance();
    }

    public void createMenu(final Menu popupmenu) {
        popupmenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent evt) {
                log.log(Level.FINEST, "popupmenu MenuListener.menuShown " + evt);
                LogLevelSelectionContextMenu.this.loggerName = (String)popupmenu.getData("logger_name");
                LogLevelSelectionContextMenu.this.levelWarning.setSelection(false);
                LogLevelSelectionContextMenu.this.levelTime.setSelection(false);
                LogLevelSelectionContextMenu.this.levelInfo.setSelection(false);
                LogLevelSelectionContextMenu.this.levelFine.setSelection(false);
                LogLevelSelectionContextMenu.this.levelFiner.setSelection(false);
                LogLevelSelectionContextMenu.this.levelFinest.setSelection(false);
                if (LogLevelSelectionContextMenu.this.loggerName != null) {
                    String logLevel = Settings.classbasedLogger.getProperty(LogLevelSelectionContextMenu.this.loggerName);
                    if (LogLevelSelectionContextMenu.this.strWarning.equalsIgnoreCase(logLevel)) {
                        LogLevelSelectionContextMenu.this.levelWarning.setSelection(true);
                    } else if (LogLevelSelectionContextMenu.this.strTime.equalsIgnoreCase(logLevel)) {
                        LogLevelSelectionContextMenu.this.levelTime.setSelection(true);
                    } else if (LogLevelSelectionContextMenu.this.strInfo.equalsIgnoreCase(logLevel)) {
                        LogLevelSelectionContextMenu.this.levelInfo.setSelection(true);
                    } else if (LogLevelSelectionContextMenu.this.strFine.equalsIgnoreCase(logLevel)) {
                        LogLevelSelectionContextMenu.this.levelFine.setSelection(true);
                    } else if (LogLevelSelectionContextMenu.this.strFiner.equalsIgnoreCase(logLevel)) {
                        LogLevelSelectionContextMenu.this.levelFiner.setSelection(true);
                    } else if (LogLevelSelectionContextMenu.this.strFinest.equalsIgnoreCase(logLevel)) {
                        LogLevelSelectionContextMenu.this.levelFinest.setSelection(true);
                    }
                }
            }

            public void menuHidden(MenuEvent evt) {
                log.log(Level.FINEST, "popupmenu MenuListener.menuHidden " + evt);
            }
        });
        this.levelWarning = new MenuItem(popupmenu, 32);
        this.levelWarning.setText(this.strWarning);
        this.levelWarning.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "levle warning selected! " + e);
                Settings.classbasedLogger.put(LogLevelSelectionContextMenu.this.loggerName, LogLevelSelectionContextMenu.this.strWarning);
            }
        });
        this.levelTime = new MenuItem(popupmenu, 32);
        this.levelTime.setText(this.strTime);
        this.levelTime.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "levle info selected! " + e);
                Settings.classbasedLogger.put(LogLevelSelectionContextMenu.this.loggerName, LogLevelSelectionContextMenu.this.strTime);
            }
        });
        this.levelInfo = new MenuItem(popupmenu, 32);
        this.levelInfo.setText(this.strInfo);
        this.levelInfo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "levle info selected! " + e);
                Settings.classbasedLogger.put(LogLevelSelectionContextMenu.this.loggerName, LogLevelSelectionContextMenu.this.strInfo);
            }
        });
        this.levelFine = new MenuItem(popupmenu, 32);
        this.levelFine.setText(this.strFine);
        this.levelFine.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "levle fine selected! " + e);
                Settings.classbasedLogger.put(LogLevelSelectionContextMenu.this.loggerName, LogLevelSelectionContextMenu.this.strFine);
            }
        });
        this.levelFiner = new MenuItem(popupmenu, 32);
        this.levelFiner.setText(this.strFiner);
        this.levelFiner.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "levle finer selected! " + e);
                Settings.classbasedLogger.put(LogLevelSelectionContextMenu.this.loggerName, LogLevelSelectionContextMenu.this.strFiner);
            }
        });
        this.levelFinest = new MenuItem(popupmenu, 32);
        this.levelFinest.setText(this.strFinest);
        this.levelFinest.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "levle finest selected! " + e);
                Settings.classbasedLogger.put(LogLevelSelectionContextMenu.this.loggerName, LogLevelSelectionContextMenu.this.strFinest);
            }
        });
    }
}

