/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.settlements;

import gde.data.IRecord;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.IChannelItem;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.ObjectFactory;
import gde.device.PropertyType;
import gde.device.SettlementType;
import gde.histo.transitions.Transition;
import gde.histo.utils.ElementaryQuantile;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

public final class SettlementRecord
extends Vector<Integer>
implements IRecord {
    private static final String $CLASS_NAME = SettlementRecord.class.getName();
    private static final long serialVersionUID = 6130190003229390899L;
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int INITIAL_RECORD_CAPACITY = 22;
    private static final String BELOW_LIMIT = MeasurementPropertyTypes.BELOW_LIMIT.value();
    private static final String BEYOND_LIMIT = MeasurementPropertyTypes.BEYOND_LIMIT.value();
    private final SettlementType settlement;
    private final RecordSet parent;
    private final int logChannelNumber;
    private final String name;
    private final Map<Integer, Double> translatedValues = new LinkedHashMap<Integer, Double>();
    private final List<Transition> transitions = new ArrayList<Transition>();
    private List<PropertyType> properties = new ArrayList<PropertyType>();
    private ElementaryQuantile<Integer> quantile = null;

    public SettlementRecord(SettlementType newSettlement, RecordSet parent, int logChannelNumber) {
        super(22);
        this.settlement = newSettlement;
        this.name = newSettlement.getName();
        this.parent = parent;
        this.logChannelNumber = logChannelNumber;
        this.initializeProperties(this, newSettlement.getProperty());
        log.log(Level.FINE, "newSettlement  ", this);
    }

    private void initializeProperties(SettlementRecord recordRef, List<PropertyType> newProperties) {
        this.properties = this.properties != null ? this.properties : new ArrayList<PropertyType>();
        for (PropertyType property : newProperties) {
            log.finer(() -> String.format("%20s - %s = %s", recordRef.name, property.getName(), property.getValue()));
            this.properties.add(property.clone());
        }
    }

    @Override
    public String toString() {
        String belowLimit = this.getBelowLimit() != -1.7976931348623157E308 ? String.format("%.1f", this.getBelowLimit()) : "none";
        String beyondLimit = this.getBeyondLimit() != Double.MAX_VALUE ? String.format("%.1f", this.getBeyondLimit()) : "none";
        return String.format("%s channel=%d  limits=%s/%s", this.name, this.logChannelNumber, belowLimit, beyondLimit);
    }

    @Override
    @Deprecated
    public synchronized boolean add(Integer e) {
        double translateValue = this.translateValue((double)e.intValue() / 1000.0);
        if (translateValue > this.getBeyondLimit()) {
            log.warning(() -> String.format("discard beyond value=%f", translateValue) + this);
            return false;
        }
        if (translateValue < this.getBelowLimit()) {
            log.warning(() -> String.format("discard below value=%f", translateValue) + this);
            return false;
        }
        return super.add(e);
    }

    public synchronized boolean add(Integer e, Transition transition) {
        double translatedValue = this.translateValue((double)e.intValue() / 1000.0);
        if (translatedValue > this.getBeyondLimit()) {
            log.warning(() -> String.format("discard beyond value=%f", translatedValue) + this);
            return false;
        }
        if (translatedValue < this.getBelowLimit()) {
            log.warning(() -> String.format("discard below value=%f", translatedValue) + this);
            return false;
        }
        this.transitions.add(transition);
        this.translatedValues.put(transition.getThresholdStartIndex(), translatedValue);
        return super.add(e);
    }

    @Override
    @Deprecated
    public synchronized Integer set(int index, Integer point) {
        return super.set(index, point);
    }

    @Override
    @Deprecated
    public synchronized int size() {
        return super.size();
    }

    public int realSize() {
        return super.size();
    }

    private PropertyType getProperty(String propertyKey) {
        PropertyType property = null;
        for (PropertyType propertyType : this.properties) {
            if (!propertyType.getName().equals(propertyKey)) continue;
            property = propertyType;
            break;
        }
        return property;
    }

    private PropertyType createProperty(String propertyKey, DataTypes type, Object value) {
        ObjectFactory factory = new ObjectFactory();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName(propertyKey);
        newProperty.setType(type);
        newProperty.setValue("" + value);
        this.properties.add(newProperty);
        return newProperty;
    }

    public double getFactor() {
        double value = 1.0;
        PropertyType property = this.getProperty(IDevice.FACTOR);
        if (property != null) {
            value = Double.parseDouble(property.getValue());
        }
        return value;
    }

    public void setFactor(double newValue) {
        PropertyType property = this.getProperty(IDevice.FACTOR);
        if (property != null) {
            property.setValue(String.format("%.4f", newValue));
        } else {
            this.createProperty(IDevice.FACTOR, DataTypes.DOUBLE, String.format(Locale.ENGLISH, "%.4f", newValue));
        }
    }

    public double getOffset() {
        double value = 0.0;
        PropertyType property = this.getProperty(IDevice.OFFSET);
        if (property != null) {
            value = Double.parseDouble(property.getValue());
        }
        return value;
    }

    public void setOffset(double newValue) {
        PropertyType property = this.getProperty(IDevice.OFFSET);
        if (property != null) {
            property.setValue(String.format("%.4f", newValue));
        } else {
            this.createProperty(IDevice.OFFSET, DataTypes.DOUBLE, String.format(Locale.ENGLISH, "%.4f", newValue));
        }
    }

    public double getReduction() {
        double value = 0.0;
        PropertyType property = this.getProperty(IDevice.REDUCTION);
        if (property != null) {
            value = Double.parseDouble(property.getValue());
        }
        return value;
    }

    public void setReduction(double newValue) {
        PropertyType property = this.getProperty(IDevice.REDUCTION);
        if (property != null) {
            property.setValue(String.format("%.4f", newValue));
        } else {
            this.createProperty(IDevice.REDUCTION, DataTypes.DOUBLE, String.format(Locale.ENGLISH, "%.4f", newValue));
        }
    }

    public boolean isBits() {
        boolean isBits = false;
        PropertyType tmpProperty = this.getProperty(IDevice.IS_BITS);
        if (tmpProperty != null) {
            isBits = Boolean.parseBoolean(tmpProperty.getValue());
        }
        return isBits;
    }

    @Override
    public Collection<Double> getTranslatedValues() {
        return this.translatedValues.values();
    }

    @Override
    public Collection<Integer> getValues() {
        return this;
    }

    public Double getTranslatedValue(int index) {
        return this.translatedValues.get(index);
    }

    public RecordSet getParent() {
        return this.parent;
    }

    public boolean hasReasonableData() {
        return this.realSize() > 0 && (this.getQuantile().getQuartile0() != this.getQuantile().getQuartile4() || this.translateValue(this.getQuantile().getQuartile4() / 1000.0) != 0.0);
    }

    public double translateValue(double value) {
        double newValue = (value - this.getReduction()) * this.getFactor() + this.getOffset();
        log.finer(() -> "for " + this.name + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public double reverseTranslateValue(double value) {
        double newValue = (value - this.getOffset()) / this.getFactor() + this.getReduction();
        log.finer(() -> "for " + this.name + " in value = " + value + " out value = " + newValue);
        return newValue;
    }

    public String getName() {
        return this.name;
    }

    public SettlementType getSettlement() {
        return this.settlement;
    }

    public IChannelItem getChannelItem() {
        return this.settlement;
    }

    public ElementaryQuantile<Integer> getQuantile() {
        if (this.quantile == null) {
            this.quantile = new ElementaryQuantile<Integer>(this, true, this.parent.getAnalyzer().getSettings());
        }
        return this.quantile;
    }

    public int getLogChannelNumber() {
        return this.logChannelNumber;
    }

    private double getBeyondLimit() {
        double value = Double.MAX_VALUE;
        PropertyType property = this.getProperty(BEYOND_LIMIT);
        if (property != null) {
            value = Double.parseDouble(property.getValue());
        }
        return value;
    }

    private double getBelowLimit() {
        double value = -1.7976931348623157E308;
        PropertyType property = this.getProperty(BELOW_LIMIT);
        if (property != null) {
            value = Double.parseDouble(property.getValue());
        }
        return value;
    }
}

