/*
 * Decompiled with CFR 0.152.
 */
package gde;

import gde.config.Settings;
import gde.exception.ApplicationConfigurationException;
import gde.log.Level;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import java.awt.SplashScreen;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class GDE {
    public static final String STRING_WITHIN_ECLIPSE = "/classes/";
    static final String $CLASS_NAME = GDE.class.getName();
    public static final long StartTime = new Date().getTime();
    public static Handler logHandler = null;
    public static Display display = null;
    public static Shell shell;
    private static boolean isWithUi;
    public static final String VERSION = "Version 3.8.3";
    public static final int VERSION_NUMBER;
    public static final String NAME_SHORT = "GDE";
    public static final String NAME_LONG = "DataExplorer";
    public static final String DEVICE_PROPERTIES_XSD_VERSION = "_V48";
    public static final String GRAPHICS_TEMPLATES_XSD_VERSION = "_V08";
    public static final String HISTO_CACHE_ENTRIES_XSD_VERSION = "_V04";
    public static final String CLEAN_SETTINGS_WHILE_SHUTDOWN = "CLEAN_SETTINGS_WHILE_SHUTDOWN";
    public static final String TEMP_FILE_STEM = "~TempFile";
    public static final String EXECUTION_ENV;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_LINUX;
    public static final boolean IS_MAC;
    public static final boolean IS_MAC_COCOA;
    public static final boolean IS_ARCH_DATA_MODEL_64;
    public static final boolean IS_OS_ARCH_ARM;
    public static final String APPL_HOME_PATH;
    public static final String SETTINGS_FILE_PATH;
    public static final String STRING_BASE_PACKAGE = "gde";
    public static final String BIT_MODE;
    public static final String STRING_FILE_SEPARATOR_UNIX = "/";
    public static final char CHAR_FILE_SEPARATOR_UNIX = '/';
    public static final String STRING_FILE_SEPARATOR_WINDOWS = "\\";
    public static final char CHAR_FILE_SEPARATOR_WINDOWS = '\\';
    public static final String FILE_SEPARATOR;
    public static final String JAVA_IO_TMPDIR;
    public static final int SIZE_BYTES_INTEGER = 4;
    public static final int SIZE_BYTES_LONG = 8;
    public static final int SIZE_UTF_SIGNATURE = 2;
    public static final long ONE_HOUR_MS = 3600000L;
    public static final int MIN_OBJECT_KEY_LENGTH = 2;
    public static final String REGEX_FILE_EXTENTION_SEPARATION = ",|;";
    public static final String STRING_NEW_LINE = "\n";
    public static final char CHAR_NEW_LINE = '\n';
    public static final char CHAR_RETURN = '\r';
    public static final String STRING_MESSAGE_CONCAT = " - ";
    public static final String STRING_DASH = "-";
    public static final char CHAR_DASH = '-';
    public static final String STRING_UNDER_BAR = "_";
    public static final char CHAR_UNDER_BAR = '_';
    public static final String STRING_EMPTY = "";
    public static final String STRING_BLANK = " ";
    public static final char CHAR_BLANK = ' ';
    public static final String STRING_URL_BLANK = "%20";
    public static final String STRING_COLON = ":";
    public static final char CHAR_COLON = ':';
    public static final String STRING_BLANK_COLON_BLANK = " : ";
    public static final String STRING_COMMA = ",";
    public static final char CHAR_COMMA = ',';
    public static final String STRING_COMMA_BLANK = ", ";
    public static final String STRING_SEMICOLON = ";";
    public static final char CHAR_SEMICOLON = ';';
    public static final String STRING_DOT = ".";
    public static final char CHAR_DOT = '.';
    public static final String STRING_EQUAL = "=";
    public static final char CHAR_EQUAL = '=';
    public static final String STRING_STAR = "*";
    public static final char CHAR_STAR = '*';
    public static final String STRING_LEFT_PARENTHESIS = "(";
    public static final char CHAR_LEFT_PARENTHESIS = '(';
    public static final String STRING_RIGHT_PARENTHESIS = ")";
    public static final char CHAR_RIGHT_PARENTHESIS = ')';
    public static final String STRING_RIGHT_PARENTHESIS_BLANK = ") ";
    public static final String STRING_BLANK_LEFT_BRACKET = " [";
    public static final String STRING_LEFT_BRACKET = "[";
    public static final char CHAR_LEFT_BRACKET = '[';
    public static final String STRING_RIGHT_BRACKET = "]";
    public static final char CHAR_RIGHT_BRACKET = ']';
    public static final String STRING_RIGHT_BRACKET_COMMA = "], ";
    public static final String STRING_OR = "|";
    public static final String STRING_DOLLAR = "$";
    public static final String STRING_OS_NAME = "os.name";
    public static final String STRING_UTF_8 = "UTF-8";
    public static final String STRING_ISO_8895_1 = "ISO-8859-1";
    public static final String STRING_BLANK_PLUS_BLANK = " + ";
    public static final String STRING_PLUS = "+";
    public static final char CHAR_PLUS = '+';
    public static final String STRING_MINUS = "-";
    public static final String STRING_TRUE = "true";
    public static final String STRING_FALSE = "false";
    public static final String STRING_SINGLE_QUOAT = "'";
    public static final String STRING_ENTRY = "entry - ";
    public static final String STRING_EXIT = "exit - ";
    public static final String STRING_BLANK_AT_BLANK = " @ ";
    public static final String STRING_GREATER = ">";
    public static final String STRING_ELLIPSIS = "...";
    public static final String STRING_PARENT_DIR = "..";
    public static final char CHAR_CSV_SEPARATOR = ',';
    public static final String STRING_CSV_SEPARATOR = ",";
    public static final String STRING_CSV_QUOTE = "\"";
    public static final String STRING_DEVICE_ORIENTED_FOLDER = "_";
    public static final String STRING_QUESTION_MARK = "?";
    public static final String STRING_SLASH = "/";
    public static final String[] STRING_ARRAY_TRUE_FALSE;
    public static final String STRING_WINDOWS_APP_OPEN = "rundll32.exe";
    public static final String STRING_WINDOWS_EXTERN_DEF_DIR = "G:\\";
    public static final String STRING_WINDOWS_EXTERN_MEDIA_DIR = ":";
    public static final String STRING_LINUX_APP_OPEN = "xdg-open";
    public static final String STRING_LINUX_EXTERN_MEDIA_DIR = "/media";
    public static final String STRING_MAC_APP_BASE_PATH = "/Applications/";
    public static final String STRING_MAC_DOT_APP = ".app";
    public static final String STRING_MAC_APP_EXE_PATH = "/Contents/MacOS/";
    public static final String STRING_MAC_APP_RES_PATH = "/Contents/Resources";
    public static final String STRING_MAC_APP_OPEN = "open";
    public static final String STRING_MAC_EXTERN_MEDIA_DIR = "/Volumes";
    public static final String FILE_ENDING_STAR_LOV = "*.lov";
    public static final String FILE_ENDING_STAR_OSD = "*.osd";
    public static final String FILE_ENDING_STAR_CSV = "*.csv";
    public static final String FILE_ENDING_STAR_IGC = "*.igc";
    public static final String FILE_ENDING_STAR_JPG = "*.jpg";
    public static final String FILE_ENDING_STAR_PNG = "*.png";
    public static final String FILE_ENDING_STAR_GIF = "*.gif";
    public static final String FILE_ENDING_STAR_XML = "*.xml";
    public static final String FILE_ENDING_STAR_KMZ = "*.kmz";
    public static final String FILE_ENDING_STAR_GPX = "*.gpx";
    public static final String FILE_ENDING_STAR_HEX = "*.hex";
    public static final String FILE_ENDING_STAR_INI = "*.ini";
    public static final String FILE_ENDING_STAR_TXT = "*.txt";
    public static final String FILE_ENDING_STAR_LOG = "*.log";
    public static final String FILE_ENDING_STAR_BIN = "*.bin";
    public static final String FILE_ENDING_STAR_TLM = "*.tlm";
    public static final String FILE_ENDING_STAR_JML = "*.jml";
    public static final String FILE_ENDING_STAR_STAR = "*.*";
    public static final String FILE_ENDING_DOT_JAR = ".jar";
    public static final String FILE_ENDING_DOT_LOV = ".lov";
    public static final String FILE_ENDING_DOT_OSD = ".osd";
    public static final String FILE_ENDING_DOT_CSV = ".csv";
    public static final String FILE_ENDING_DOT_IGC = ".igc";
    public static final String FILE_ENDING_DOT_NMEA = ".nmea";
    public static final String FILE_ENDING_DOT_JPG = ".jpg";
    public static final String FILE_ENDING_DOT_PNG = ".png";
    public static final String FILE_ENDING_DOT_GIF = ".gif";
    public static final String FILE_ENDING_DOT_TXT = ".txt";
    public static final String FILE_ENDING_DOT_LOG = ".log";
    public static final String FILE_ENDING_DOT_STF = ".stf";
    public static final String FILE_ENDING_DOT_ZIP = ".zip";
    public static final String FILE_ENDING_DOT_BAK = ".bak";
    public static final String FILE_ENDING_DOT_TMP = ".tmp";
    public static final String FILE_ENDING_DOT_XML = ".xml";
    public static final String FILE_ENDING_DOT_XSD = ".xsd";
    public static final String FILE_ENDING_DOT_HEX = ".hex";
    public static final String FILE_ENDING_DOT_KMZ = ".kmz";
    public static final String FILE_ENDING_DOT_GPX = ".gpx";
    public static final String FILE_ENDING_DOT_KML = ".kml";
    public static final String FILE_ENDING_DOT_EXE = ".exe";
    public static final String FILE_ENDING_DOT_INI = ".ini";
    public static final String FILE_ENDING_DOT_BIN = ".bin";
    public static final String FILE_ENDING_DOT_TLM = ".tlm";
    public static final String FILE_ENDING_DOT_JML = ".jml";
    public static final String FILE_ENDING_LOV = "lov";
    public static final String FILE_ENDING_OSD = "osd";
    public static final String FILE_ENDING_CSV = "csv";
    public static final String FILE_ENDING_IGC = "igc";
    public static final String FILE_ENDING_NMEA = "nmea";
    public static final String FILE_ENDING_XML = "xml";
    public static final String FILE_ENDING_JPG = "jpg";
    public static final String FILE_ENDING_PNG = "png";
    public static final String FILE_ENDING_GIF = "gif";
    public static final String FILE_ENDING_BAK = "bak";
    public static final String FILE_ENDING_TMP = "tmp";
    public static final String FILE_ENDING_KMZ = "kmz";
    public static final String FILE_ENDING_GPX = "gpx";
    public static final String FILE_ENDING_STAR = "*";
    public static final String FILE_ENDING_HEX = "hex";
    public static final String FILE_ENDING_EXE = "exe";
    public static final String FILE_ENDING_INI = "ini";
    public static final String FILE_ENDING_BIN = "bin";
    public static final String FILE_ENDING_TLM = "tlm";
    public static final String FILE_ENDING_LOG = "log";
    public static final String FILE_ENDING_TXT = "txt";
    public static final String FILE_ENDING_JML = "jml";
    public static final String FILE_ENDING_BIN_LOG = "bin;*.log";
    public static final String LINE_SEPARATOR;
    public static final String BOOTSTRAP_LOG = "/bootstrap.log";
    public static final String ECLIPSE_STRING = "ECLIPSE";
    public static String[] MOD1;
    public static String[] MOD2;
    public static String[] MOD3;
    public static int WIDGET_FONT_SIZE;
    public static final String WIDGET_FONT_NAME;
    public static final int NUMBER_RANGE_MIN_GDE = 0;
    public static final int NUMBER_RANGE_MAX_GDE = 1000;
    public static final int NUMBER_RANGE_MIN_SAMPLE_SIM = 1001;
    public static final int NUMBER_RANGE_MAX_SAMPLE_SIM = 1099;
    public static final int NUMBER_RANGE_MIN_AKKUMASTER = 1100;
    public static final int NUMBER_RANGE_MAX_AKKUMASTER = 1199;
    public static final int NUMBER_RANGE_MIN_PICOLARIO = 1200;
    public static final int NUMBER_RANGE_MAX_PICOLARIO = 1299;
    public static final int NUMBER_RANGE_MIN_UNILOG = 1300;
    public static final int NUMBER_RANGE_MAX_UNILOG = 1399;
    public static final int NUMBER_RANGE_MIN_ESTATION = 1400;
    public static final int NUMBER_RANGE_MAX_ESTATION = 1499;
    public static final int NUMBER_RANGE_MIN_VC800 = 1500;
    public static final int NUMBER_RANGE_MAX_VC800 = 1599;
    public static final int NUMBER_RANGE_MIN_LIPOWATCH = 1600;
    public static final int NUMBER_RANGE_MAX_LIPOWATCH = 1699;
    public static final int NUMBER_RANGE_MIN_CSV2SERIAL = 1700;
    public static final int NUMBER_RANGE_MAX_CSV2SERIAL = 1799;
    public static final int NUMBER_RANGE_MIN_WSTECHVARIO = 1800;
    public static final int NUMBER_RANGE_MAX_WSTECHVARIO = 1899;
    public static final int NUMBER_RANGE_MIN_QC_COPTER = 1900;
    public static final int NUMBER_RANGE_MAX_QC_COPTER = 1999;
    public static final int NUMBER_RANGE_MIN_GPS_LOGGER = 2000;
    public static final int NUMBER_RANGE_MAX_GPS_LOGGER = 2099;
    public static final int NUMBER_RANGE_MIN_NMEA_ADAPTER = 2100;
    public static final int NUMBER_RANGE_MAX_NMEA_ADAPTER = 2199;
    public static final int NUMBER_RANGE_MIN_ULTRAMAT_DUOPLUS = 2200;
    public static final int NUMBER_RANGE_MAX_ULTRAMAT_DUOPLUS = 2399;
    public static final int NUMBER_RANGE_MIN_HOTTADAPTER = 2400;
    public static final int NUMBER_RANGE_MAX_HOTTADAPTER = 2499;
    public static final int NUMBER_RANGE_MIN_UNILOG2 = 2500;
    public static final int NUMBER_RANGE_MAX_UNILOG2 = 2599;
    public static final int NUMBER_RANGE_MIN_ICHARGER = 2600;
    public static final int NUMBER_RANGE_MAX_ICHARGER = 2699;
    public static final int NUMBER_RANGE_MIN_FLIGHTRECORDER = 2700;
    public static final int NUMBER_RANGE_MAX_FLIGHTRECORDER = 2799;
    public static final int NUMBER_RANGE_MIN_JLOG2 = 2800;
    public static final int NUMBER_RANGE_MAX_JLOG2 = 2899;
    public static final int NUMBER_RANGE_MIN_JETIADAPTER = 2900;
    public static final int NUMBER_RANGE_MAX_JETIADAPTER = 2999;
    public static final String DATA_EXPLORER_FILE_VERSION = "DataExplorer version : ";
    public static final String LEGACY_FILE_VERSION = "OpenSerialData version : ";
    public static final String DATA_EXPLORER_FILE = "DataExplorer";
    public static final String LEGACY_OSDE_FILE = "OpenSerialData";
    public static final int DATA_EXPLORER_FILE_VERSION_INT = 4;
    public static final String CREATION_TIME_STAMP = "Created : ";
    public static final String LAST_UPDATE_TIME_STAMP = "Updated : ";
    public static final String FILE_COMMENT = "FileComment : ";
    public static final String DEVICE_NAME = "DeviceName : ";
    public static final String CHANNEL_CONFIG_TYPE = "Channel/Configuration Type : ";
    public static final String RECORD_SET_SIZE = "NumberRecordSets : ";
    public static final String RECORD_SET_NAME = "RecordSetName : ";
    public static final String CHANNEL_CONFIG_NUMBER = "Channel/Configuration Number : ";
    public static final String DATA_DELIMITER = "||::||";
    public static final String CHANNEL_CONFIG_NAME = "Channel/Configuration Name: ";
    public static final String OBJECT_KEY = "ObjectKey : ";
    public static final String RECORD_SET_COMMENT = "RecordSetComment : ";
    public static final String RECORD_SET_PROPERTIES = "RecordSetProperties : ";
    public static final String RECORDS_PROPERTIES = "RecordProperties : ";
    public static final String RECORD_DATA_SIZE = "RecordDataSize : ";
    public static final String RECORD_SET_DATA_POINTER = "RecordSetDataPointer : ";
    public static final String RECORD_SET_DATA_BYTES = "RecordSetDataBytes : ";
    public static final String[] OSD_FORMAT_HEADER_KEYS;
    public static final String[] OSD_FORMAT_DATA_KEYS;
    public static final String LOV_CONFIG_DATA = "logview_config_data";
    public static final String DATA_POINTER_POS = "Data_Pointer_Pos : ";
    public static final String LOV_HEADER_SIZE = "Header_Size : ";
    public static final String LOV_FORMAT_VERSION = "Format_Version : ";
    public static final String LOV_SSTREAM_VERSION = "String_Stream_Version : ";
    public static final String LOV_STREAM_VERSION = "Stream_Version : ";
    public static final String LOV_TIME_STEP = "TimeStep_ms=";
    public static final String LOV_NUM_MEASUREMENTS = "WerteAnzahl=";
    public static final String[] LOV_FORMAT_HEADER_KEYS;
    public static final String[] LOV_FORMAT_DATA_KEYS;
    public static final String CSV_DATA_HEADER = "CSV_data_header : ";
    public static final String CSV_DATA_HEADER_MEASUREMENTS = "CSV_data_header_measurements : ";
    public static final String CSV_DATA_HEADER_UNITS = "CSV_data_header_units : ";
    public static final String CSV_DATA_TYPE = "CSV_data_type : ";
    public static final String CSV_DATA_TYPE_RAW = "raw";
    public static final String CSV_DATA_TYPE_ABS = "abs";
    public static final String CSV_DATA_IGNORE_INDEX = "CSV_data_ignore_index : ";
    static final Logger log;
    static Logger rootLogger;
    static Vector<String> initErrors;
    static SplashScreen startSplash;
    public static Shell splash;
    public static ProgressBar progBar;
    static final String DEVICES_PLUG_IN_DIR = "devices/";
    static final String JAVA_EXT_DIR = "java/ext/";
    public static final Map<String, String> deviceMap;
    public static UiNotification uiNotification;
    private static Thread settingsThread;

    public static void main(String[] args) {
        String $METHOD_NAME = "main";
        log.log(Level.FINER, "main    start");
        try {
            System.setProperty("https.protocols", "SSLv3,TLSv1,TLSv1.1,TLSv1.2");
            System.setProperty("file.encoding", STRING_UTF_8);
            GDE.initLogger();
            log.log(Level.INFO, "initLogger  done ");
            settingsThread = new Thread("Settings async"){

                @Override
                public void run() {
                    log.log(Level.INFO, "Settings.getInstance() settingsAsyncThread.run()");
                    Settings.getInstance();
                }
            };
            settingsThread.start();
            log.log(Level.INFO, "main start");
            String inputFilePath = STRING_EMPTY;
            Display.setAppName((String)"DataExplorer");
            Display.setAppVersion((String)VERSION);
            isWithUi = true;
            display = Display.getDefault();
            shell = display.getActiveShell() == null ? new Shell(display) : display.getActiveShell();
            GDE.showSplash();
            log.logp(Level.INFO, $CLASS_NAME, "main", "DataExplorer Version 3.8.3");
            log.logp(Level.INFO, $CLASS_NAME, "main", "Screen resolution [dpi] = " + GDE.display.getDPI().y);
            Thread.currentThread().setContextClassLoader(GDE.getClassLoader());
            log.log(Level.INFO, "settingsThread.join() wait ");
            settingsThread.join();
            WIDGET_FONT_SIZE = (int)((double)(IS_LINUX ? 8 : 9) * Settings.getInstance().getFontDisplayDensityAdaptionFactor() * 96.0 / (double)Display.getDefault().getDPI().y);
            MOD1 = new String[]{IS_MAC ? "\u00e6" : (Settings.getInstance().getLocale().equals(Locale.GERMAN) ? "Strg" : "Ctrl")};
            MOD2 = new String[]{Settings.getInstance().getLocale().equals(Locale.GERMAN) ? "Umschalt" : "Shift"};
            MOD3 = new String[]{"Alt"};
            log.log(Level.TIME, "init to start DataExplorer time =", StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - StartTime));
            DataExplorer application = DataExplorer.getInstance();
            for (int i = 0; i < args.length; ++i) {
                log.logp(Level.INFO, $CLASS_NAME, "main", "commandline arg[" + i + "] = " + args[i]);
            }
            if (args.length > 0) {
                args[0] = args[0].trim();
                if (args[0].toLowerCase().endsWith(FILE_ENDING_DOT_OSD) || args[0].toLowerCase().endsWith(FILE_ENDING_DOT_LOV)) {
                    inputFilePath = args[0];
                    log.logp(Level.INFO, $CLASS_NAME, "main", "inputFilePath = " + inputFilePath);
                }
            }
            StringBuilder sb = new StringBuilder().append("Environment : \n");
            Properties props = System.getProperties();
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                sb.append(propName).append(" = ").append(props.get(propName)).append(STRING_NEW_LINE);
            }
            sb.append("SWT.PLATFORM = ").append(SWT.getPlatform()).append(LINE_SEPARATOR);
            sb.append("SWT.VERSION = ").append(SWT.getVersion()).append(LINE_SEPARATOR);
            log.logp(Level.INFO, $CLASS_NAME, "main", sb.toString());
            GDE.seStartupProgress(100);
            int javaVmSpecificationVersion = Integer.parseInt(((String)props.get("java.vm.specification.version")).contains(STRING_DOT) ? ((String)props.get("java.vm.specification.version")).substring(2) : (String)props.get("java.vm.specification.version"));
            if (IS_ARCH_DATA_MODEL_64 || IS_OS_ARCH_ARM) {
                if (javaVmSpecificationVersion < 11 || javaVmSpecificationVersion > 17) {
                    application.openMessageDialogAsync(Messages.getString("GDE_MSGW0050", new Integer[]{javaVmSpecificationVersion}));
                }
            } else if (javaVmSpecificationVersion < 8 || javaVmSpecificationVersion > 17) {
                application.openMessageDialogAsync(Messages.getString("GDE_MSGW0050", new Integer[]{javaVmSpecificationVersion}));
            }
            application.execute(inputFilePath);
        }
        catch (Throwable e) {
            log.logp(Level.SEVERE, $CLASS_NAME, "main", e.getMessage(), e);
            for (Throwable t = e; t != null; t = t.getCause()) {
                log.logp(Level.SEVERE, $CLASS_NAME, "main", t.getMessage(), t);
            }
        }
    }

    public static ClassLoader getClassLoader() throws MalformedURLException, URISyntaxException, ApplicationConfigurationException {
        String $METHOD_NAME = "getClassLoader";
        Vector<URL> urls = new Vector<URL>();
        URL url = GDE.class.getProtectionDomain().getCodeSource().getLocation();
        log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "base URL = " + url.toString());
        if (url.getPath().endsWith("/")) {
            log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "started inside Eclipse");
            String basePath = url.getFile().substring(0, url.getPath().lastIndexOf(DataExplorer.class.getSimpleName()));
            basePath = basePath.replace(STRING_URL_BLANK, STRING_BLANK);
            log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "basePath = " + basePath);
            File file = new File(basePath);
            String[] files = file.list();
            if (files == null) {
                throw new ApplicationConfigurationException(Messages.getString("GDE_MSGE0001", new Object[]{basePath}));
            }
            for (String path : files) {
                if (path.startsWith(STRING_DOT)) continue;
                if (new File(basePath + path + STRING_WITHIN_ECLIPSE).exists()) {
                    urls.add(new URL("file:" + basePath + path + STRING_WITHIN_ECLIPSE));
                    continue;
                }
                if (!new File(basePath + path + "/lib").exists()) continue;
                try {
                    List<File> jarFiles = FileUtils.getFileListing(new File(basePath + path + "/lib/"), 1);
                    for (File jarFile : jarFiles) {
                        if (!jarFile.getName().startsWith("HoTT") || !jarFile.getName().endsWith(FILE_ENDING_DOT_JAR)) continue;
                        urls.add(new URL("file:" + basePath + path + "/lib/" + jarFile.getName()));
                    }
                }
                catch (FileNotFoundException jarFiles) {
                    // empty catch block
                }
            }
        } else {
            URL fileUrl;
            log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "started outside with: java -jar *.jar");
            String basePath = url.getFile().substring(0, url.getPath().lastIndexOf(47) + 1);
            basePath = basePath.replace(STRING_URL_BLANK, STRING_BLANK).replace('\\', '/') + DEVICES_PLUG_IN_DIR;
            log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "basePath = " + basePath);
            File file = new File(basePath);
            String[] files = file.list();
            if (files == null) {
                throw new ApplicationConfigurationException(Messages.getString("GDE_MSGE0001", new Object[]{basePath}));
            }
            for (String path : files) {
                if (!path.endsWith(FILE_ENDING_DOT_JAR)) continue;
                fileUrl = new File(basePath + path).toURI().toURL();
                urls.add(fileUrl);
                log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "adding : " + fileUrl.toURI());
            }
            basePath = url.getFile().substring(0, url.getPath().lastIndexOf(47) + 1);
            basePath = basePath.replace(STRING_URL_BLANK, STRING_BLANK).replace('\\', '/') + JAVA_EXT_DIR;
            log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "basePath = " + basePath);
            file = new File(basePath);
            files = file.list();
            if (files != null) {
                for (String path : files) {
                    if (!path.endsWith(FILE_ENDING_DOT_JAR)) continue;
                    fileUrl = new File(basePath + path).toURI().toURL();
                    urls.add(fileUrl);
                    log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "adding : " + fileUrl.toURI());
                }
            }
        }
        log.logp(Level.INFO, $CLASS_NAME, "getClassLoader", "using class loader URL = " + urls.toString());
        return new URLClassLoader(urls.toArray(new URL[1]));
    }

    public static String getDevicesClasspathAsString() throws Exception {
        URL[] urls = ((URLClassLoader)GDE.getClassLoader()).getURLs();
        StringBuilder sb = new StringBuilder();
        String pathSeparator = System.getProperty("path.separator");
        for (URL url : urls) {
            sb.append(pathSeparator).append(url.getFile());
        }
        return sb.toString();
    }

    public static void initLogger() {
        Handler[] handlers;
        LogFormatter lf = new LogFormatter();
        rootLogger = Logger.getLogger(STRING_EMPTY);
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        rootLogger.setLevel(Level.ALL);
        if (System.getProperty(ECLIPSE_STRING) == null) {
            try {
                logHandler = new FileHandler(JAVA_IO_TMPDIR + BOOTSTRAP_LOG, 50000, 1);
                logHandler.setFormatter(lf);
                logHandler.setLevel(Level.INFO);
                rootLogger.addHandler(logHandler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            logHandler = new ConsoleHandler();
            logHandler.setFormatter(lf);
            logHandler.setLevel(Level.INFO);
            rootLogger.addHandler(logHandler);
        }
    }

    public static Vector<String> getInitErrors() {
        return initErrors;
    }

    public static void setInitError(String errorMessage) {
        initErrors.add(errorMessage);
    }

    private static void showSplash() {
        Image image = new Image((Device)display, GDE.class.getClassLoader().getResourceAsStream("gde/resource/splash.png"));
        GC gc = new GC((Drawable)image);
        gc.drawImage(image, 0, 0);
        gc.dispose();
        Shell splashShell = new Shell(shell, 18432);
        ProgressBar bar = new ProgressBar((Composite)splashShell, 0);
        bar.setMaximum(100);
        Label label = new Label((Composite)splashShell, 0);
        label.setImage(image);
        FormLayout layout = new FormLayout();
        splashShell.setLayout((Layout)layout);
        FormData labelData = new FormData();
        labelData.right = new FormAttachment(100, 0);
        labelData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)labelData);
        FormData progressData = new FormData();
        progressData.height = 15;
        progressData.left = new FormAttachment(0, 5);
        progressData.right = new FormAttachment(100, -5);
        progressData.bottom = new FormAttachment(100, -5);
        bar.setLayoutData((Object)progressData);
        bar.setSelection(40);
        bar.setSize(355, 15);
        splashShell.pack();
        Rectangle primaryMonitorBounds = display.getPrimaryMonitor().getBounds();
        Point splashRect = new Point(primaryMonitorBounds.width / 2 - 185, primaryMonitorBounds.height / 2 - 103);
        splashShell.setLocation(splashRect.x, splashRect.y);
        splashShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (splash != null && !splash.isDisposed()) {
                    splash.close();
                }
                if (startSplash != null) {
                    startSplash.close();
                }
                splash = null;
                startSplash = null;
            }
        });
        splashShell.open();
        splash = splashShell;
        progBar = bar;
    }

    public static void seStartupProgress(int percent) {
        if (progBar != null && !progBar.isDisposed()) {
            progBar.setSelection(percent);
        }
    }

    public static boolean isWithUi() {
        return isWithUi;
    }

    public static UiNotification getUiNotification() {
        if (uiNotification == null) {
            uiNotification = isWithUi ? new UiNotification() : new UiNotification(){

                @Override
                public int getProgressPercentage() {
                    return 100;
                }

                @Override
                public void setProgress(int percentage) {
                }

                @Override
                public void setStatusMessage(String message) {
                }

                @Override
                public void setStatusMessage(String message, int swtColor) {
                }
            };
        }
        return uiNotification;
    }

    static {
        isWithUi = false;
        VERSION_NUMBER = VERSION.contains("beta") ? Integer.parseInt(VERSION.substring(8, 13).replace(STRING_DOT, STRING_EMPTY)) - 1 : Integer.parseInt(VERSION.substring(8, 13).replace(STRING_DOT, STRING_EMPTY));
        EXECUTION_ENV = System.getenv("AWS_EXECUTION_ENV");
        IS_WINDOWS = System.getProperty(STRING_OS_NAME).toLowerCase().startsWith("windows");
        IS_LINUX = System.getProperty(STRING_OS_NAME).toLowerCase().startsWith("linux");
        IS_MAC = System.getProperty(STRING_OS_NAME).toLowerCase().startsWith("mac");
        IS_MAC_COCOA = IS_MAC && System.getProperty("DO_NOT_USE_COCOA") == null && SWT.getPlatform().toLowerCase().startsWith("cocoa");
        IS_ARCH_DATA_MODEL_64 = System.getProperty("sun.arch.data.model").equals("64");
        boolean bl = IS_OS_ARCH_ARM = System.getProperty("os.arch").toLowerCase().startsWith("arm") || System.getProperty("os.arch").toLowerCase().startsWith("aarch");
        APPL_HOME_PATH = IS_WINDOWS ? (System.getenv("APPDATA") + "/" + "DataExplorer").replace(STRING_FILE_SEPARATOR_WINDOWS, "/") : (IS_LINUX ? System.getProperty("user.home") + "/" + STRING_DOT + "DataExplorer" : (IS_MAC ? System.getProperty("user.home") + "/" + "Library" + "/" + "Application Support" + "/" + "DataExplorer" : STRING_EMPTY));
        SETTINGS_FILE_PATH = APPL_HOME_PATH + "/" + "DataExplorer" + ".properties";
        BIT_MODE = System.getProperty("sun.arch.data.model") != null ? System.getProperty("sun.arch.data.model") : System.getProperty("com.ibm.vm.bitmode");
        FILE_SEPARATOR = System.getProperty("file.separator");
        JAVA_IO_TMPDIR = System.getProperty("java.io.tmpdir").endsWith(FILE_SEPARATOR) ? System.getProperty("java.io.tmpdir") : System.getProperty("java.io.tmpdir") + FILE_SEPARATOR;
        STRING_ARRAY_TRUE_FALSE = new String[]{STRING_TRUE, STRING_FALSE};
        LINE_SEPARATOR = System.getProperty("line.separator");
        WIDGET_FONT_NAME = IS_WINDOWS ? "Microsoft Sans Serif" : (IS_MAC ? "Lucida Grande" : "Sans Serif");
        OSD_FORMAT_HEADER_KEYS = new String[]{CREATION_TIME_STAMP, FILE_COMMENT, DEVICE_NAME, OBJECT_KEY, CHANNEL_CONFIG_TYPE, RECORD_SET_SIZE};
        OSD_FORMAT_DATA_KEYS = new String[]{CHANNEL_CONFIG_NAME, RECORD_SET_NAME, RECORD_SET_COMMENT, RECORD_SET_PROPERTIES, RECORDS_PROPERTIES, RECORD_DATA_SIZE, RECORD_SET_DATA_POINTER};
        LOV_FORMAT_HEADER_KEYS = new String[]{CREATION_TIME_STAMP, FILE_COMMENT, DEVICE_NAME, CHANNEL_CONFIG_TYPE, RECORD_SET_SIZE};
        LOV_FORMAT_DATA_KEYS = new String[]{CHANNEL_CONFIG_NAME, RECORD_SET_NAME, RECORD_SET_COMMENT, RECORD_SET_PROPERTIES, RECORDS_PROPERTIES, RECORD_DATA_SIZE, RECORD_SET_DATA_POINTER, RECORD_SET_DATA_BYTES, "timeStep_ms", LOV_NUM_MEASUREMENTS};
        log = Logger.getLogger(GDE.class.getName());
        initErrors = new Vector(0);
        startSplash = null;
        deviceMap = new HashMap<String, String>();
        deviceMap.put("HoTTViewerAdapter", "HoTTViewer");
        deviceMap.put("HoTTAdapter3", "HoTTAdapter2");
        deviceMap.put("GPS-Logger (UL)", "GPS-Logger");
        deviceMap.put("GPS-Logger (UL2)", "GPS-Logger");
        deviceMap.put("GPS-Logger2 (UL)", "GPS-Logger2");
        deviceMap.put("GPS-Logger2 (UL2)", "GPS-Logger2");
        deviceMap.put("OnLineCommander", "Triangoli");
        display = Display.getDefault();
        shell = new Shell(display);
    }

    public static class UiNotification {
        private final DataExplorer application = DataExplorer.getInstance();

        public int getProgressPercentage() {
            return this.application.getProgressPercentage();
        }

        public void setProgress(int percentage) {
            String sThreadId = String.format("%06d", Thread.currentThread().getId());
            this.application.setProgress(percentage, sThreadId);
        }

        public void setStatusMessage(String message) {
            this.application.setStatusMessage(message);
        }

        public void setStatusMessage(String message, int swtColor) {
            this.application.setStatusMessage(message, swtColor);
        }
    }
}

