/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.data.Channel;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.graupner.GeniusWizardLogReader;
import gde.device.graupner.HoTTAdapter;
import gde.device.graupner.HoTTbinReader;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.FileUtils;
import gde.utils.WaitTimer;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.widgets.FileDialog;

public class GeniusWizard
extends HoTTAdapter
implements IDevice {
    public GeniusWizard(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
    }

    public GeniusWizard(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
    }

    @Override
    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        if (dataBuffer.length == this.getDataBlockSize(InputTypes.FILE_IO)) {
            points[0] = DataParser.parse2Short((byte[])dataBuffer, (int)9) * 1000;
            points[1] = DataParser.parse2Short((byte[])dataBuffer, (int)11) * 1000;
            points[2] = DataParser.parse2Short((byte[])dataBuffer, (int)17) * 1000;
            points[3] = DataParser.parse2Short((byte[])dataBuffer, (int)19) * 1000;
            points[4] = DataParser.parse2Short((byte[])dataBuffer, (int)21) * 1000;
            points[5] = DataParser.parse2Short((byte[])dataBuffer, (int)23) * 1000;
            points[6] = DataParser.parse2Short((byte[])dataBuffer, (int)13) * 1000;
            points[7] = (dataBuffer[15] & 0xFF) * 1000;
            points[8] = (dataBuffer[16] & 0xFF) * 1000;
            points[9] = (dataBuffer[25] & 0xFF) * 1000;
            points[10] = (dataBuffer[26] & 0xFF) * 1000;
            points[11] = DataParser.parse2Short((byte[])dataBuffer, (int)32) * 1000;
        }
        return points;
    }

    @Override
    protected void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2440"), (String)"LogData");
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GeniusWizard.this.application.setPortConnected(true);
                    boolean isInitialSwitched = false;
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith(".log")) {
                            if (selectedImportFile.contains(".")) {
                                selectedImportFile = selectedImportFile.substring(0, selectedImportFile.indexOf(46));
                            }
                            selectedImportFile = selectedImportFile + ".log";
                        }
                        HoTTAdapter.log.log(Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        Integer channelConfigNumber = GeniusWizard.this.application.getActiveChannelNumber();
                        channelConfigNumber = channelConfigNumber == null ? 1 : channelConfigNumber;
                        try {
                            GeniusWizardLogReader.read(selectedImportFile);
                            if (!isInitialSwitched) {
                                Channel selectedChannel = (Channel)GeniusWizard.this.channels.get((Object)1);
                                HoTTbinReader.channels.switchChannel(selectedChannel.getName());
                                if (GeniusWizard.this.application.getActiveChannel().getActiveRecordSet() != null) {
                                    selectedChannel.switchRecordSet(GeniusWizard.this.application.getActiveChannel().getActiveRecordSet().getName());
                                }
                                isInitialSwitched = true;
                            }
                            WaitTimer.delay((long)500L);
                        }
                        catch (Exception e) {
                            HoTTAdapter.log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    GeniusWizard.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }
}

