/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextAttachment;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextTab;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTTextAttachmentCell;

public final class TextLayout
extends Resource {
    NSTextStorage textStorage;
    NSLayoutManager layoutManager;
    NSTextContainer textContainer;
    Font font;
    String text = "";
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    int spacing;
    int ascent = -1;
    int descent = -1;
    int indent;
    int wrapIndent;
    int verticalIndentInPoints;
    boolean justify;
    int alignment = 16384;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    private double defaultTabWidth;
    int[] lineOffsets;
    NSRect[] lineBounds;
    static Callback textLayoutCallback2;
    static final byte[] SWT_OBJECT;
    static final int TAB_COUNT = 32;
    static final int UNDERLINE_THICK = 65536;
    static final RGB LINK_FOREGROUND;
    int[] invalidOffsets;
    private boolean ignoreSegments;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';

    static {
        byte[] byArray = new byte[11];
        byArray[0] = 83;
        byArray[1] = 87;
        byArray[2] = 84;
        byArray[3] = 95;
        byArray[4] = 79;
        byArray[5] = 66;
        byArray[6] = 74;
        byArray[7] = 69;
        byArray[8] = 67;
        byArray[9] = 84;
        SWT_OBJECT = byArray;
        LINK_FOREGROUND = new RGB(0, 51, 153);
    }

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.init();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    float[] computePolyline(int left2, int top2, int right2, int bottom2) {
        int length;
        int height = bottom2 - top2;
        int width = 2 * height;
        int peaks = Compatibility.ceil(right2 - left2, width);
        if (peaks == 0 && right2 - left2 > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new float[0];
        }
        float[] coordinates = new float[length];
        int i2 = 0;
        while (i2 < peaks) {
            int index = 4 * i2;
            coordinates[index] = left2 + width * i2;
            coordinates[index + 1] = bottom2;
            coordinates[index + 2] = coordinates[index] + (float)(width / 2);
            coordinates[index + 3] = top2;
            ++i2;
        }
        coordinates[length - 2] = left2 + width * peaks;
        coordinates[length - 1] = bottom2;
        return coordinates;
    }

    void computeRuns() {
        if (this.lineBounds != null) {
            return;
        }
        String segmentsText = this.ignoreSegments ? this.text : this.getSegmentsText();
        char[] chars = new char[segmentsText.length()];
        segmentsText.getChars(0, chars.length, chars, 0);
        NSString str = (NSString)new NSString().alloc();
        str = str.initWithCharacters(chars, chars.length);
        NSMutableAttributedString attrStr = (NSMutableAttributedString)new NSMutableAttributedString().alloc();
        attrStr.id = attrStr.initWithString((NSString)str).id;
        str.release();
        attrStr.beginEditing();
        Font defaultFont = this.font != null ? this.font : this.device.systemFont;
        NSRange range = new NSRange();
        range.length = attrStr.length();
        attrStr.addAttribute(OS.NSFontAttributeName, defaultFont.handle, range);
        attrStr.addAttribute(OS.NSLigatureAttributeName, NSNumber.numberWithInt(0), range);
        defaultFont.addTraits(attrStr, range);
        NSMutableParagraphStyle paragraph = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        int align = 0;
        if (this.wrapWidth != -1) {
            if (this.justify) {
                align = 3;
            } else {
                switch (this.alignment) {
                    case 0x1000000: {
                        align = 2;
                        break;
                    }
                    case 131072: {
                        align = 1;
                    }
                }
            }
        }
        if ((this.orientation & 0x4000000) != 0) {
            paragraph.setBaseWritingDirection(1L);
        } else {
            paragraph.setBaseWritingDirection(0L);
        }
        paragraph.setAlignment(align);
        paragraph.setLineSpacing(this.spacing);
        paragraph.setFirstLineHeadIndent(this.indent);
        paragraph.setHeadIndent(this.wrapIndent);
        paragraph.setLineBreakMode(this.wrapWidth != -1 ? 0 : 2);
        paragraph.setTabStops(NSArray.array());
        if (this.tabs != null && this.tabs.length > 0) {
            int count = this.tabs.length;
            if (count == 1) {
                double tabWidth = this.defaultTabWidth;
                if (this.defaultTabWidth == 0.0 || Math.ceil(this.defaultTabWidth) != (double)this.tabs[0]) {
                    tabWidth = this.tabs[0];
                }
                paragraph.setDefaultTabInterval(tabWidth);
            } else {
                int pos = 0;
                int i2 = 0;
                while (i2 < count) {
                    pos = this.tabs[i2];
                    NSTextTab tab2 = (NSTextTab)new NSTextTab().alloc();
                    tab2 = tab2.initWithType(0L, pos);
                    paragraph.addTabStop(tab2);
                    tab2.release();
                    ++i2;
                }
                int width = this.tabs[count - 1] - this.tabs[count - 2];
                while (i2 < 32) {
                    NSTextTab tab3 = (NSTextTab)new NSTextTab().alloc();
                    tab3 = tab3.initWithType(0L, pos += width);
                    paragraph.addTabStop(tab3);
                    tab3.release();
                    ++i2;
                }
            }
        }
        attrStr.addAttribute(OS.NSParagraphStyleAttributeName, paragraph, range);
        paragraph.release();
        long textLength = attrStr.length();
        int i3 = 0;
        while (i3 < this.stylesCount - 1) {
            StyleItem run2 = this.styles[i3];
            if (run2.style != null) {
                NSColor color;
                Color background;
                Color foreground;
                TextStyle style = run2.style;
                range.location = textLength != 0L ? this.translateOffset(run2.start) : 0;
                range.length = (long)this.translateOffset(this.styles[i3 + 1].start) - range.location;
                Font font = style.font;
                if (font != null) {
                    attrStr.addAttribute(OS.NSFontAttributeName, font.handle, range);
                    font.addTraits(attrStr, range);
                }
                if ((foreground = style.foreground) != null) {
                    NSColor color2 = NSColor.colorWithDeviceRed(foreground.handle[0], foreground.handle[1], foreground.handle[2], 1.0);
                    attrStr.addAttribute(OS.NSForegroundColorAttributeName, color2, range);
                }
                if ((background = style.background) != null) {
                    NSColor color3 = NSColor.colorWithDeviceRed(background.handle[0], background.handle[1], background.handle[2], 1.0);
                    attrStr.addAttribute(OS.NSBackgroundColorAttributeName, color3, range);
                }
                if (style.strikeout) {
                    attrStr.addAttribute(OS.NSStrikethroughStyleAttributeName, NSNumber.numberWithInt(1), range);
                    Color strikeColor = style.strikeoutColor;
                    if (strikeColor != null) {
                        color = NSColor.colorWithDeviceRed(strikeColor.handle[0], strikeColor.handle[1], strikeColor.handle[2], 1.0);
                        attrStr.addAttribute(OS.NSStrikethroughColorAttributeName, color, range);
                    }
                }
                if (this.isUnderlineSupported(style)) {
                    int underlineStyle = 0;
                    switch (style.underlineStyle) {
                        case 0: {
                            underlineStyle = 1;
                            break;
                        }
                        case 1: {
                            underlineStyle = 9;
                            break;
                        }
                        case 65536: {
                            underlineStyle = 2;
                            break;
                        }
                        case 4: {
                            underlineStyle = 1;
                            if (foreground != null) break;
                            color = NSColor.colorWithDeviceRed((float)TextLayout.LINK_FOREGROUND.red / 255.0f, (float)TextLayout.LINK_FOREGROUND.green / 255.0f, (float)TextLayout.LINK_FOREGROUND.blue / 255.0f, 1.0);
                            attrStr.addAttribute(OS.NSForegroundColorAttributeName, color, range);
                        }
                    }
                    if (underlineStyle != 0) {
                        attrStr.addAttribute(OS.NSUnderlineStyleAttributeName, NSNumber.numberWithInt(underlineStyle), range);
                        Color underlineColor = style.underlineColor;
                        if (underlineColor != null) {
                            NSColor color4 = NSColor.colorWithDeviceRed(underlineColor.handle[0], underlineColor.handle[1], underlineColor.handle[2], 1.0);
                            attrStr.addAttribute(OS.NSUnderlineColorAttributeName, color4, range);
                        }
                    }
                }
                if (style.rise != 0) {
                    attrStr.addAttribute(OS.NSBaselineOffsetAttributeName, NSNumber.numberWithInt(style.rise), range);
                }
                if (style.metrics != null) {
                    this.initClasses();
                    char[] buffer = new char[(int)range.length];
                    int j = 0;
                    while (j < buffer.length) {
                        buffer[j] = 65532;
                        ++j;
                    }
                    NSString string2 = (NSString)new NSString().alloc();
                    string2 = string2.initWithCharacters(buffer, buffer.length);
                    attrStr.replaceCharactersInRange(range, string2);
                    string2.release();
                    run2.jniRef = OS.NewGlobalRef(run2);
                    if (run2.jniRef == 0L) {
                        SWT.error(2);
                    }
                    run2.cell = (SWTTextAttachmentCell)new SWTTextAttachmentCell().alloc().init();
                    OS.object_setInstanceVariable(run2.cell.id, SWT_OBJECT, run2.jniRef);
                    NSTextAttachment attachment = ((NSTextAttachment)new NSTextAttachment().alloc()).initWithFileWrapper(null);
                    attachment.setAttachmentCell(run2.cell);
                    attrStr.addAttribute(OS.NSAttachmentAttributeName, attachment, range);
                    attachment.release();
                }
            }
            ++i3;
        }
        attrStr.endEditing();
        NSSize size = new NSSize();
        size.width = this.wrapWidth != -1 ? (double)this.wrapWidth : 5000000.0;
        size.height = 5000000.0;
        if (this.textStorage == null) {
            this.textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            this.layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            this.layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
            this.textContainer = (NSTextContainer)new NSTextContainer().alloc();
            this.textContainer = this.textContainer.initWithContainerSize(size);
            this.textContainer.setLineFragmentPadding(0.0);
            this.textStorage.addLayoutManager(this.layoutManager);
            this.layoutManager.addTextContainer(this.textContainer);
            this.layoutManager.release();
            this.textContainer.release();
        } else {
            this.textContainer.setContainerSize(size);
        }
        this.textStorage.setAttributedString(attrStr);
        attrStr.release();
        this.layoutManager.glyphRangeForTextContainer(this.textContainer);
        long numberOfGlyphs = this.layoutManager.numberOfGlyphs();
        long rangePtr = C.malloc(NSRange.sizeof);
        NSRange lineRange = new NSRange();
        int numberOfLines = 0;
        long index = 0L;
        while (index < numberOfGlyphs) {
            this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            OS.memmove(lineRange, rangePtr, (long)NSRange.sizeof);
            index = lineRange.location + lineRange.length;
            ++numberOfLines;
        }
        if (numberOfLines == 0) {
            ++numberOfLines;
        }
        int[] offsets = new int[numberOfLines + 1];
        NSRect[] bounds = new NSRect[numberOfLines];
        numberOfLines = 0;
        index = 0L;
        while (index < numberOfGlyphs) {
            bounds[numberOfLines] = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(index, rangePtr, true);
            if (numberOfLines < bounds.length - 1) {
                bounds[numberOfLines].height -= (double)this.spacing;
            }
            OS.memmove(lineRange, rangePtr, (long)NSRange.sizeof);
            offsets[numberOfLines] = (int)lineRange.location;
            index = lineRange.location + lineRange.length;
            ++numberOfLines;
        }
        if (numberOfLines == 0) {
            Font font = this.font != null ? this.font : this.device.systemFont;
            NSFont nsFont = font.handle;
            bounds[0] = new NSRect();
            bounds[0].height = Math.max(this.layoutManager.defaultLineHeightForFont(nsFont), (double)(this.ascent + this.descent));
        }
        C.free(rangePtr);
        offsets[numberOfLines] = (int)this.textStorage.length();
        this.lineOffsets = offsets;
        this.lineBounds = bounds;
    }

    @Override
    void destroy() {
        this.freeRuns();
        if (this.textStorage != null) {
            this.textStorage.release();
        }
        this.textStorage = null;
        this.layoutManager = null;
        this.textContainer = null;
        this.font = null;
        this.text = null;
        this.styles = null;
        this.segments = null;
        this.segmentsChars = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = gc.checkGC(3073);
        try {
            boolean hasSelection;
            this.computeRuns();
            int length = this.translateOffset(this.text.length());
            if (length == 0 && flags == 0) {
                return;
            }
            gc.handle.saveGraphicsState();
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y += this.getVerticalIndent();
            NSRange range = new NSRange();
            long numberOfGlyphs = this.layoutManager.numberOfGlyphs();
            if (numberOfGlyphs > 0L) {
                range.location = 0L;
                range.length = numberOfGlyphs;
                this.layoutManager.drawBackgroundForGlyphRange(range, pt);
            }
            boolean bl = hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            if (hasSelection || (flags & 0x100000) != 0 && (flags & 0x30000) != 0) {
                if (selectionBackground == null) {
                    selectionBackground = this.device.getSystemColor(26);
                }
                NSColor selectionColor = NSColor.colorWithDeviceRed(selectionBackground.handle[0], selectionBackground.handle[1], selectionBackground.handle[2], selectionBackground.handle[3]);
                NSBezierPath path2 = NSBezierPath.bezierPath();
                NSRect rect = new NSRect();
                if (hasSelection) {
                    range.location = this.translateOffset(selectionStart);
                    range.length = this.translateOffset(selectionEnd - selectionStart + 1);
                    long[] rectCount = new long[1];
                    long pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
                    int k = 0;
                    while ((long)k < rectCount[0]) {
                        OS.memmove(rect, pArray, (long)NSRect.sizeof);
                        this.fixRect(rect);
                        rect.x += pt.x;
                        rect.y += pt.y;
                        rect.height = Math.max(rect.height, (double)(this.ascent + this.descent));
                        path2.appendBezierPathWithRect(rect);
                        ++k;
                        pArray += (long)NSRect.sizeof;
                    }
                }
                if ((flags & 0x30000) != 0 && (flags & 0x100000) != 0) {
                    NSRect bounds = this.lineBounds[this.lineBounds.length - 1];
                    rect.x = pt.x + bounds.x + bounds.width;
                    rect.y = (double)y + bounds.y;
                    rect.width = (flags & 0x10000) != 0 ? 2.147483647E9 : bounds.height / 3.0;
                    rect.height = Math.max(bounds.height, (double)(this.ascent + this.descent));
                    path2.appendBezierPathWithRect(rect);
                }
                selectionColor.setFill();
                path2.fill();
            }
            if (numberOfGlyphs > 0L) {
                boolean defaultFg;
                range.location = 0L;
                range.length = numberOfGlyphs;
                double[] fg = gc.data.foreground;
                boolean bl2 = defaultFg = fg[0] == 0.0 && fg[1] == 0.0 && fg[2] == 0.0 && fg[3] == 1.0 && gc.data.alpha == 255;
                if (!defaultFg) {
                    int i2 = 0;
                    while (i2 < this.stylesCount - 1) {
                        StyleItem run2 = this.styles[i2];
                        if (!(run2.style != null && run2.style.foreground != null || run2.style != null && run2.style.underline && run2.style.underlineStyle == 4)) {
                            range.location = length != 0 ? this.translateOffset(run2.start) : 0;
                            range.length = (long)this.translateOffset(this.styles[i2 + 1].start) - range.location;
                            this.layoutManager.addTemporaryAttribute(OS.NSForegroundColorAttributeName, gc.data.fg, range);
                        }
                        ++i2;
                    }
                }
                range.location = 0L;
                range.length = numberOfGlyphs;
                this.layoutManager.drawGlyphsForGlyphRange(range, pt);
                if (!defaultFg) {
                    range.location = 0L;
                    range.length = length;
                    this.layoutManager.removeTemporaryAttribute(OS.NSForegroundColorAttributeName, range);
                }
                NSPoint point = new NSPoint();
                int j = 0;
                while (j < this.stylesCount) {
                    StyleItem run3 = this.styles[j];
                    TextStyle style = run3.style;
                    if (style != null) {
                        boolean drawUnderline = style.underline && !this.isUnderlineSupported(style);
                        drawUnderline = drawUnderline && (j + 1 == this.stylesCount || !style.isAdherentUnderline(this.styles[j + 1].style));
                        boolean drawBorder = style.borderStyle != 0;
                        boolean bl3 = drawBorder = drawBorder && (j + 1 == this.stylesCount || !style.isAdherentBorder(this.styles[j + 1].style));
                        if (drawUnderline || drawBorder) {
                            int end = j + 1 < this.stylesCount ? this.translateOffset(this.styles[j + 1].start - 1) : length;
                            int i3 = 0;
                            while (i3 < this.lineOffsets.length - 1) {
                                NSRect rect;
                                long pArray;
                                int start;
                                int lineStart = this.untranslateOffset(this.lineOffsets[i3]);
                                int lineEnd = this.untranslateOffset(this.lineOffsets[i3 + 1] - 1);
                                if (drawUnderline) {
                                    start = run3.start;
                                    int k = j;
                                    while (k > 0 && style.isAdherentUnderline(this.styles[k - 1].style)) {
                                        start = this.styles[k - 1].start;
                                        --k;
                                    }
                                    if ((start = this.translateOffset(start)) <= lineEnd && end >= lineStart) {
                                        range.location = Math.max(lineStart, start);
                                        range.length = (long)(Math.min(lineEnd, end) + 1) - range.location;
                                        if (range.length > 0L) {
                                            long[] rectCount = new long[1];
                                            pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
                                            rect = new NSRect();
                                            gc.handle.saveGraphicsState();
                                            double baseline = this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, lineStart);
                                            double[] color = null;
                                            if (style.underlineColor != null) {
                                                color = style.underlineColor.handle;
                                            }
                                            if (color == null && style.foreground != null) {
                                                color = style.foreground.handle;
                                            }
                                            if (color != null) {
                                                NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]).setStroke();
                                            }
                                            int k2 = 0;
                                            while ((long)k2 < rectCount[0]) {
                                                OS.memmove(rect, pArray, (long)NSRect.sizeof);
                                                this.fixRect(rect);
                                                double underlineX = pt.x + rect.x;
                                                double underlineY = pt.y + rect.y + rect.height - baseline + 1.0;
                                                NSBezierPath path3 = NSBezierPath.bezierPath();
                                                switch (style.underlineStyle) {
                                                    case 2: {
                                                        path3.setLineWidth(2.0);
                                                        path3.setLineCapStyle(1L);
                                                        path3.setLineJoinStyle(1L);
                                                        path3.setLineDash(new double[]{1.0, 3.0}, 2L, 0.0);
                                                        point.x = underlineX;
                                                        point.y = underlineY + 0.5;
                                                        path3.moveToPoint(point);
                                                        point.x = underlineX + rect.width;
                                                        point.y = underlineY + 0.5;
                                                        path3.lineToPoint(point);
                                                        break;
                                                    }
                                                    case 3: {
                                                        gc.handle.setShouldAntialias(false);
                                                        path3.setLineWidth(1.0);
                                                        path3.setLineCapStyle(0L);
                                                        path3.setLineJoinStyle(0L);
                                                        double lineBottom = pt.y + rect.y + rect.height;
                                                        float squigglyThickness = 1.0f;
                                                        float squigglyHeight = 2.0f * squigglyThickness;
                                                        double squigglyY = Math.min(underlineY - (double)(squigglyHeight / 2.0f), lineBottom - (double)squigglyHeight - 1.0);
                                                        float[] points = this.computePolyline((int)underlineX, (int)squigglyY, (int)(underlineX + rect.width), (int)(squigglyY + (double)squigglyHeight));
                                                        point.x = points[0] + 0.5f;
                                                        point.y = points[1] + 0.5f;
                                                        path3.moveToPoint(point);
                                                        int p = 2;
                                                        while (p < points.length) {
                                                            point.x = points[p] + 0.5f;
                                                            point.y = points[p + 1] + 0.5f;
                                                            path3.lineToPoint(point);
                                                            p += 2;
                                                        }
                                                        break;
                                                    }
                                                }
                                                path3.stroke();
                                                ++k2;
                                                pArray += (long)NSRect.sizeof;
                                            }
                                            gc.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                if (drawBorder) {
                                    start = run3.start;
                                    int k = j;
                                    while (k > 0 && style.isAdherentBorder(this.styles[k - 1].style)) {
                                        start = this.styles[k - 1].start;
                                        --k;
                                    }
                                    if ((start = this.translateOffset(start)) <= lineEnd && end >= lineStart) {
                                        range.location = Math.max(lineStart, start);
                                        range.length = (long)(Math.min(lineEnd, end) + 1) - range.location;
                                        if (range.length > 0L) {
                                            long[] rectCount = new long[1];
                                            pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
                                            rect = new NSRect();
                                            gc.handle.saveGraphicsState();
                                            double[] color = null;
                                            if (style.borderColor != null) {
                                                color = style.borderColor.handle;
                                            }
                                            if (color == null && style.foreground != null) {
                                                color = style.foreground.handle;
                                            }
                                            if (color != null) {
                                                NSColor.colorWithDeviceRed(color[0], color[1], color[2], color[3]).setStroke();
                                            }
                                            boolean width = true;
                                            float[] dashes = null;
                                            switch (style.borderStyle) {
                                                case 1: {
                                                    break;
                                                }
                                                case 2: {
                                                    dashes = width ? GC.LINE_DASH : GC.LINE_DASH_ZERO;
                                                    break;
                                                }
                                                case 4: {
                                                    dashes = width ? GC.LINE_DOT : GC.LINE_DOT_ZERO;
                                                }
                                            }
                                            double[] lengths = null;
                                            if (dashes != null) {
                                                lengths = new double[dashes.length];
                                                int k3 = 0;
                                                while (k3 < lengths.length) {
                                                    lengths[k3] = !width ? dashes[k3] : dashes[k3] * (float)width;
                                                    ++k3;
                                                }
                                            }
                                            int k4 = 0;
                                            while ((long)k4 < rectCount[0]) {
                                                OS.memmove(rect, pArray, (long)NSRect.sizeof);
                                                this.fixRect(rect);
                                                rect.x += pt.x + 0.5;
                                                rect.y += pt.y + 0.5;
                                                rect.width -= 0.5;
                                                rect.height -= 0.5;
                                                NSBezierPath path4 = NSBezierPath.bezierPath();
                                                path4.setLineDash(lengths, lengths != null ? lengths.length : 0, 0.0);
                                                path4.appendBezierPathWithRect(rect);
                                                path4.stroke();
                                                ++k4;
                                                pArray += (long)NSRect.sizeof;
                                            }
                                            gc.handle.restoreGraphicsState();
                                        }
                                    }
                                }
                                ++i3;
                            }
                        }
                    }
                    ++j;
                }
            }
            gc.handle.restoreGraphicsState();
        }
        finally {
            gc.uncheckGC(pool);
        }
    }

    void fixRect(NSRect rect) {
        double right2 = -1.0;
        int j = 0;
        while (j < this.lineBounds.length) {
            NSRect line2 = this.lineBounds[j];
            if (rect.y <= line2.y && line2.y <= rect.y + rect.height) {
                right2 = Math.max(right2, line2.x + line2.width);
            }
            ++j;
        }
        if (right2 != -1.0 && rect.x + rect.width > right2) {
            rect.width = right2 - rect.x;
        }
    }

    void freeRuns() {
        this.lineBounds = null;
        this.lineOffsets = null;
        int i2 = 0;
        while (i2 < this.stylesCount - 1) {
            StyleItem run2 = this.styles[i2];
            if (run2.cell != null) {
                OS.object_setInstanceVariable(run2.cell.id, SWT_OBJECT, 0L);
                run2.cell.release();
                run2.cell = null;
                OS.DeleteGlobalRef(run2.jniRef);
                run2.jniRef = 0L;
            }
            ++i2;
        }
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            NSRect rect = this.layoutManager.usedRectForTextContainer(this.textContainer);
            if (this.wrapWidth != -1) {
                rect.width = this.wrapWidth;
            }
            if (this.text.length() == 0) {
                Font font = this.font != null ? this.font : this.device.systemFont;
                NSFont nsFont = font.handle;
                rect.height = this.layoutManager.defaultLineHeightForFont(nsFont);
            }
            rect.height = Math.max(rect.height, (double)(this.ascent + this.descent)) + (double)this.spacing;
            Rectangle rectangle2 = new Rectangle(0, 0, (int)Math.ceil(rect.width), (int)Math.ceil(rect.height) + this.getVerticalIndent());
            return rectangle2;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (length == 0) {
                Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
                return rectangle2;
            }
            if (start > end) {
                Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
                return rectangle3;
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            start = this.translateOffset(start);
            end = this.translateOffset(end);
            NSRange range = new NSRange();
            range.location = start;
            range.length = end - start + 1;
            long[] rectCount = new long[1];
            long pArray = this.layoutManager.rectArrayForCharacterRange(range, range, this.textContainer, rectCount);
            NSRect rect = new NSRect();
            int left2 = Integer.MAX_VALUE;
            int right2 = 0;
            int top2 = Integer.MAX_VALUE;
            int bottom2 = 0;
            int i2 = 0;
            while ((long)i2 < rectCount[0]) {
                OS.memmove(rect, pArray, (long)NSRect.sizeof);
                this.fixRect(rect);
                left2 = Math.min(left2, (int)rect.x);
                right2 = Math.max(right2, (int)Math.ceil(rect.x + rect.width));
                top2 = Math.min(top2, (int)rect.y);
                bottom2 = Math.max(bottom2, (int)Math.ceil(rect.y + rect.height));
                ++i2;
                pArray += (long)NSRect.sizeof;
            }
            Rectangle rectangle4 = new Rectangle(left2, top2, right2 - left2, bottom2 - top2 + this.getVerticalIndent());
            return rectangle4;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (offset < 0 || offset > length) {
                SWT.error(6);
            }
            offset = this.translateOffset(offset);
            long glyphOffset = this.layoutManager.glyphIndexForCharacterAtIndex(offset);
            NSRange range = new NSRange();
            range.location = glyphOffset;
            range.length = 1L;
            byte[] bidiLevels = new byte[1];
            this.layoutManager.getGlyphsInRange(range, 0L, 0L, 0L, 0L, bidiLevels);
            byte by = bidiLevels[0];
            return by;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int[] offsets = new int[this.lineOffsets.length];
            int i2 = 0;
            while (i2 < offsets.length) {
                offsets[i2] = this.untranslateOffset(this.lineOffsets[i2]);
                ++i2;
            }
            int[] nArray = offsets;
            return nArray;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (offset < 0 || offset > length) {
                SWT.error(6);
            }
            offset = this.translateOffset(offset);
            int line2 = 0;
            while (line2 < this.lineOffsets.length - 1) {
                if (this.lineOffsets[line2 + 1] > offset) {
                    int n = line2;
                    return n;
                }
                ++line2;
            }
            int n = this.lineBounds.length - 1;
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            if (lineIndex < 0 || lineIndex >= this.lineBounds.length) {
                SWT.error(6);
            }
            NSRect rect = this.lineBounds[lineIndex];
            int height = Math.max((int)Math.ceil(rect.height), this.ascent + this.descent);
            Rectangle rectangle2 = new Rectangle((int)rect.x, (int)rect.y, (int)Math.ceil(rect.width), height);
            return rectangle2;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getLineCount() {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int n = this.lineOffsets.length - 1;
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int length;
            this.computeRuns();
            int lineCount = this.getLineCount();
            if (lineIndex < 0 || lineIndex >= lineCount) {
                SWT.error(6);
            }
            if ((length = this.text.length()) == 0) {
                Font font = this.font != null ? this.font : this.device.systemFont;
                int ascent = (int)this.layoutManager.defaultBaselineOffsetForFont(font.handle);
                int descent = (int)this.layoutManager.defaultLineHeightForFont(font.handle) - ascent;
                ascent = Math.max(ascent, this.ascent);
                descent = Math.max(descent, this.descent);
                FontMetrics fontMetrics = FontMetrics.cocoa_new(ascent, descent, 0.0, 0, ascent + descent);
                return fontMetrics;
            }
            Rectangle rect = this.getLineBounds(lineIndex);
            int baseline = (int)this.layoutManager.typesetter().baselineOffsetInLayoutManager(this.layoutManager, this.getLineOffsets()[lineIndex]);
            FontMetrics fontMetrics = FontMetrics.cocoa_new(rect.height - baseline, baseline, 0.0, 0, rect.height);
            return fontMetrics;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            int length = this.text.length();
            if (offset < 0 || offset > length) {
                SWT.error(6);
            }
            if (length == 0) {
                Point point = new Point(0, 0);
                return point;
            }
            if (offset == length) {
                NSRect rect = this.lineBounds[this.lineBounds.length - 1];
                Point point = new Point((int)(rect.x + rect.width), (int)rect.y);
                return point;
            }
            offset = this.translateOffset(offset);
            long glyphIndex = this.layoutManager.glyphIndexForCharacterAtIndex(offset);
            NSRect rect = this.layoutManager.lineFragmentUsedRectForGlyphAtIndex(glyphIndex, 0L);
            NSPoint point = this.layoutManager.locationForGlyphAtIndex(glyphIndex);
            boolean rtl = false;
            NSRange range = new NSRange();
            range.location = glyphIndex;
            range.length = 1L;
            byte[] bidiLevels = new byte[1];
            long result2 = this.layoutManager.getGlyphsInRange(range, 0L, 0L, 0L, 0L, bidiLevels);
            if (result2 > 0L) {
                boolean bl = rtl = (bidiLevels[0] & 1) != 0;
            }
            if (trailing != rtl) {
                long[] rectCount = new long[1];
                long pArray = this.layoutManager.rectArrayForGlyphRange(range, range, this.textContainer, rectCount);
                if (rectCount[0] > 0L) {
                    NSRect bounds = new NSRect();
                    OS.memmove(bounds, pArray, (long)NSRect.sizeof);
                    this.fixRect(bounds);
                    point.x += bounds.width;
                }
            }
            Point point2 = new Point((int)point.x, (int)rect.y + this.getVerticalIndent());
            return point2;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getNextOffset(int offset, int movement) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n = this._getOffset(offset, movement, true);
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        switch (movement) {
            case 2: {
                char ch;
                if ((offset += step) < 0 || offset >= length || '\udc00' > (ch = this.text.charAt(offset)) || ch > '\udfff' || offset <= 0 || '\ud800' > (ch = this.text.charAt(offset - 1)) || ch > '\udbff') return offset;
                offset += step;
                return offset;
            }
            case 4: {
                offset = this.translateOffset(offset);
                offset = (int)this.textStorage.nextWordFromIndex(offset, forward);
                return this.untranslateOffset(offset);
            }
            case 8: {
                offset = this.translateOffset(offset);
                if (forward) {
                    offset = (int)this.textStorage.nextWordFromIndex(offset, true);
                    return this.untranslateOffset(offset);
                } else {
                    length = this.translateOffset(length);
                    int result2 = 0;
                    while (result2 < length) {
                        int wordEnd = (int)this.textStorage.nextWordFromIndex(result2, true);
                        if (wordEnd >= offset) {
                            offset = result2;
                            return this.untranslateOffset(offset);
                        }
                        result2 = wordEnd;
                    }
                }
                return this.untranslateOffset(offset);
            }
            case 16: {
                offset = this.translateOffset(offset);
                if (forward) {
                    int result3 = this.translateOffset(length);
                    while (result3 > 0) {
                        int wordStart = (int)this.textStorage.nextWordFromIndex(result3, false);
                        if (wordStart <= offset) {
                            offset = result3;
                            return this.untranslateOffset(offset);
                        }
                        result3 = wordStart;
                    }
                    return this.untranslateOffset(offset);
                }
                offset = (int)this.textStorage.nextWordFromIndex(offset, false);
                return this.untranslateOffset(offset);
            }
        }
        return offset;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int length;
            this.computeRuns();
            if (trailing != null && trailing.length < 1) {
                SWT.error(5);
            }
            if ((length = this.text.length()) == 0) {
                return 0;
            }
            NSPoint pt = new NSPoint();
            pt.x = x;
            pt.y = y - this.getVerticalIndent();
            double[] partialFraction = new double[1];
            long glyphIndex = this.layoutManager.glyphIndexForPoint(pt, this.textContainer, partialFraction);
            long charOffset = this.layoutManager.characterIndexForGlyphAtIndex(glyphIndex);
            if (this.textStorage.string().characterAtIndex(charOffset) == 10L) {
                --charOffset;
            }
            int offset = (int)charOffset;
            offset = Math.min(this.untranslateOffset(offset), length - 1);
            if (trailing != null) {
                char ch;
                trailing[0] = Math.round((float)partialFraction[0]);
                if (partialFraction[0] >= 0.5 && '\ud800' <= (ch = this.text.charAt(offset)) && ch <= '\udbff' && offset + 1 < length && '\udc00' <= (ch = this.text.charAt(offset + 1)) && ch <= '\udfff') {
                    trailing[0] = trailing[0] + 1;
                }
            }
            int n = offset;
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int offset, int movement) {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int n = this._getOffset(offset, movement, false);
            return n;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result2 = new int[this.stylesCount * 2];
        int count = 0;
        int i2 = 0;
        while (i2 < this.stylesCount - 1) {
            if (this.styles[i2].style != null) {
                result2[count++] = this.styles[i2].start;
                result2[count++] = this.styles[i2 + 1].start - 1;
            }
            ++i2;
        }
        if (count != result2.length) {
            int[] newResult2 = new int[count];
            System.arraycopy(result2, 0, newResult2, 0, count);
            result2 = newResult2;
        }
        return result2;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int separator2;
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return this.text;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return this.text;
            }
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int defaultSeparator = this.orientation == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                separator2 = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount + segmentCount++] = separator2;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        while (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            separator2 = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount + segmentCount++] = separator2;
        }
        return new String(newChars, 0, newChars.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public int getVerticalIndent() {
        this.checkLayout();
        return this.verticalIndentInPoints;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i2 = 1;
        while (i2 < this.stylesCount) {
            StyleItem item2 = this.styles[i2];
            if (item2.start > offset) {
                return this.styles[i2 - 1].style;
            }
            ++i2;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result2 = new TextStyle[this.stylesCount];
        int count = 0;
        int i2 = 0;
        while (i2 < this.stylesCount) {
            if (this.styles[i2].style != null) {
                result2[count++] = this.styles[i2].style;
            }
            ++i2;
        }
        if (count != result2.length) {
            TextStyle[] newResult2 = new TextStyle[count];
            System.arraycopy(result2, 0, newResult2, 0, count);
            result2 = newResult2;
        }
        return result2;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        this.checkLayout();
        return this.orientation;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    void initClasses() {
        String className = "SWTTextAttachmentCell";
        if (OS.objc_lookUpClass(className) != 0L) {
            return;
        }
        textLayoutCallback2 = new Callback(this.getClass(), "textLayoutProc", 2);
        long proc2 = textLayoutCallback2.getAddress();
        if (proc2 == 0L) {
            SWT.error(3);
        }
        long cellBaselineOffsetProc = OS.CALLBACK_cellBaselineOffset(proc2);
        long cellSizeProc = OS.CALLBACK_NSTextAttachmentCell_cellSize(proc2);
        byte[] byArray = new byte[2];
        byArray[0] = 42;
        byte[] types = byArray;
        int size = C.PTR_SIZEOF;
        int align = C.PTR_SIZEOF == 4 ? 2 : 3;
        long cls = OS.objc_allocateClassPair(OS.class_NSCell, className, 0L);
        OS.class_addIvar(cls, SWT_OBJECT, size, (byte)align, types);
        OS.class_addProtocol(cls, OS.protocol_NSTextAttachmentCell);
        OS.class_addMethod(cls, OS.sel_cellSize, cellSizeProc, "@:");
        OS.class_addMethod(cls, OS.sel_cellBaselineOffset, cellBaselineOffsetProc, "@:");
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 11, 0)) {
            long attachmentProc = OS.CALLBACK_NSTextAttachmentCell_attachment(proc2);
            OS.class_addMethod(cls, OS.sel_attachment, attachmentProc, "@:");
        }
        OS.objc_registerClassPair(cls);
    }

    @Override
    public boolean isDisposed() {
        return this.device == null;
    }

    boolean isUnderlineSupported(TextStyle style) {
        if (style != null && style.underline) {
            int uStyle = style.underlineStyle;
            return uStyle == 0 || uStyle == 1 || uStyle == 4 || uStyle == 65536;
        }
        return false;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.alignment = alignment;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.ascent = ascent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.descent = descent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.indent = indent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setWrapIndent(int wrapIndent) {
        this.checkLayout();
        if (wrapIndent < 0) {
            return;
        }
        if (this.wrapIndent == wrapIndent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapIndent = wrapIndent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (justify == this.justify) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.justify = justify;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i2 = 0;
            while (i2 < segments.length) {
                if (this.segments[i2] != segments[i2]) break;
                ++i2;
            }
            if (i2 == segments.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segments = segments;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setSegmentsChars(char[] segmentsChars) {
        this.checkLayout();
        if (this.segmentsChars == null && segmentsChars == null) {
            return;
        }
        if (this.segmentsChars != null && segmentsChars != null && this.segmentsChars.length == segmentsChars.length) {
            int i2 = 0;
            while (i2 < segmentsChars.length) {
                if (this.segmentsChars[i2] != segmentsChars[i2]) break;
                ++i2;
            }
            if (i2 == segmentsChars.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.segmentsChars = segmentsChars;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.spacing == spacing) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.spacing = spacing;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setVerticalIndent(int verticalIndent) {
        this.checkLayout();
        if (verticalIndent < 0) {
            SWT.error(5);
        }
        if (this.verticalIndentInPoints == verticalIndent) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.verticalIndentInPoints = verticalIndent;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setStyle(TextStyle style, int start, int end) {
        this.checkLayout();
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            int newLength;
            int modifyStart;
            int length = this.text.length();
            if (length == 0) {
                return;
            }
            if (start > end) {
                return;
            }
            start = Math.min(Math.max(0, start), length - 1);
            end = Math.min(Math.max(0, end), length - 1);
            int low = -1;
            int high = this.stylesCount;
            while (high - low > 1) {
                int index = (high + low) / 2;
                if (this.styles[index + 1].start > start) {
                    high = index;
                    continue;
                }
                low = index;
            }
            if (high >= 0 && high < this.stylesCount) {
                StyleItem item2 = this.styles[high];
                if (item2.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item2.style == null : style.equals(item2.style))) {
                    return;
                }
            }
            this.freeRuns();
            int modifyEnd = modifyStart = high;
            while (modifyEnd < this.stylesCount) {
                if (this.styles[modifyEnd + 1].start > end) break;
                ++modifyEnd;
            }
            if (modifyStart == modifyEnd) {
                int styleStart = this.styles[modifyStart].start;
                int styleEnd = this.styles[modifyEnd + 1].start - 1;
                if (styleStart == start && styleEnd == end) {
                    this.styles[modifyStart].style = style;
                    return;
                }
                if (styleStart != start && styleEnd != end) {
                    int newLength2 = this.stylesCount + 2;
                    if (newLength2 > this.styles.length) {
                        int newSize = Math.min(newLength2 + 1024, Math.max(64, newLength2 * 2));
                        StyleItem[] newStyles = new StyleItem[newSize];
                        System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                        this.styles = newStyles;
                    }
                    System.arraycopy(this.styles, modifyEnd + 1, this.styles, modifyEnd + 3, this.stylesCount - modifyEnd - 1);
                    StyleItem item3 = new StyleItem();
                    item3.start = start;
                    item3.style = style;
                    this.styles[modifyStart + 1] = item3;
                    item3 = new StyleItem();
                    item3.start = end + 1;
                    item3.style = this.styles[modifyStart].style;
                    this.styles[modifyStart + 2] = item3;
                    this.stylesCount = newLength2;
                    return;
                }
            }
            if (start == this.styles[modifyStart].start) {
                --modifyStart;
            }
            if (end == this.styles[modifyEnd + 1].start - 1) {
                ++modifyEnd;
            }
            if ((newLength = this.stylesCount + 1 - (modifyEnd - modifyStart - 1)) > this.styles.length) {
                int newSize = Math.min(newLength + 1024, Math.max(64, newLength * 2));
                StyleItem[] newStyles = new StyleItem[newSize];
                System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                this.styles = newStyles;
            }
            System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart + 2, this.stylesCount - modifyEnd);
            StyleItem item4 = new StyleItem();
            item4.start = start;
            item4.style = style;
            this.styles[modifyStart + 1] = item4;
            this.styles[modifyStart + 2].start = end + 1;
            this.stylesCount = newLength;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i2 = 0;
            while (i2 < tabs.length) {
                if (this.tabs[i2] != tabs[i2]) break;
                ++i2;
            }
            if (i2 == tabs.length) {
                return;
            }
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.tabs = tabs;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setText(String text2) {
        this.checkLayout();
        if (text2 == null) {
            SWT.error(4);
        }
        if (text2.equals(this.text)) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.text = text2;
            this.styles = new StyleItem[2];
            this.styles[0] = new StyleItem();
            this.styles[1] = new StyleItem();
            this.styles[1].start = text2.length();
            this.stylesCount = 2;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setTextDirection(int textDirection) {
        this.checkLayout();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.freeRuns();
            this.wrapWidth = width;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.text + "}";
    }

    static long textLayoutProc(long id2, long sel) {
        long[] jniRef = new long[1];
        OS.object_getInstanceVariable(id2, SWT_OBJECT, jniRef);
        if (jniRef[0] == 0L) {
            return 0L;
        }
        StyleItem run2 = (StyleItem)OS.JNIGetObject(jniRef[0]);
        if (run2 == null) {
            return 0L;
        }
        TextStyle style = run2.style;
        if (style == null) {
            return 0L;
        }
        GlyphMetrics metrics = style.metrics;
        if (metrics == null) {
            return 0L;
        }
        if (sel == OS.sel_cellSize) {
            NSSize size = new NSSize();
            size.width = metrics.width;
            size.height = metrics.ascent + metrics.descent;
            long result2 = C.malloc(NSSize.sizeof);
            OS.memmove(result2, size, (long)NSSize.sizeof);
            return result2;
        }
        if (sel == OS.sel_cellBaselineOffset) {
            NSPoint point = new NSPoint();
            point.y = -metrics.descent;
            long result3 = C.malloc(NSPoint.sizeof);
            OS.memmove(result3, point, (long)NSPoint.sizeof);
            return result3;
        }
        if (sel == OS.sel_attachment) {
            return 0L;
        }
        return 0L;
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        int i2 = 0;
        while (i2 < nSegments && offset - i2 >= this.segments[i2]) {
            ++offset;
            ++i2;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        int i2 = 0;
        while (i2 < nSegments && offset > this.segments[i2]) {
            --offset;
            ++i2;
        }
        return offset;
    }

    public void setDefaultTabWidth(int tabLength) {
        if (tabLength < 0) {
            SWT.error(5);
        }
        this.checkLayout();
        String oldString = this.getText();
        StringBuffer tabBuffer = new StringBuffer(tabLength);
        int i2 = 0;
        while (i2 < tabLength) {
            tabBuffer.append(' ');
            ++i2;
        }
        this.setText(tabBuffer.toString());
        this.ignoreSegments = true;
        this.defaultTabWidth = this.getTabWidth();
        this.ignoreSegments = false;
        this.setText(oldString);
    }

    double getTabWidth() {
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.computeRuns();
            NSRect rect = this.layoutManager.usedRectForTextContainer(this.textContainer);
            if (this.wrapWidth != -1) {
                rect.width = this.wrapWidth;
            }
            double d = rect.width;
            return d;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    static class StyleItem {
        TextStyle style;
        int start;
        long jniRef;
        NSCell cell;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

