/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.smmodellbau.UniLog;
import gde.device.smmodellbau.UniLogConfigTab;
import gde.device.smmodellbau.UniLogDataGatherer;
import gde.device.smmodellbau.UniLogLiveGatherer;
import gde.device.smmodellbau.UniLogSerialPort;
import gde.device.smmodellbau.UniLogTelemetryTab;
import gde.exception.ApplicationConfigurationException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniLogDialog
extends DeviceDialog {
    static final String DEVICE_NAME = "UniLog";
    static final Logger log = Logger.getLogger(UniLogDialog.class.getName());
    public static final int WERTESAETZE_MAX = 25920;
    public static final String[] TIME_INTERVAL = new String[]{" 1/16 s  (-> 27 min)", "   1/8 s  (-> 54 min)", "   1/4 s  (-> 1:48 h)", "   1/2 s  (-> 3:36 h)", "      1 s   (-> 7:12 h)", "      2 s   (-> 14:24 h)", "      5 s   (-> 36 h)", "    10 s   (->  3 d)", "    30 s   (->  9 d)", "   1 min (-> 18 d)", "   2 min (-> 36 d)", "   5 min (-> 90 d)"};
    public static final String[] RX_AUTO_START_MS = new String[]{" 1,1 ms", " 1,2 ms", " 1,3 ms", " 1,4 ms", " 1,5 ms", " 1,6 ms", " 1,7 ms", " 1,8 ms", " 1,9 ms", " Rx on"};
    public static final String[] CURRENT_SENSOR = new String[]{" 40/80A ", "  150A ", "  400A ", "    20A "};
    public static final String[] A1_MODUS_NAMES = Messages.getString((String)"GDE_MSGT1366").split(";");
    public static final String[] A2_MODUS_NAMES = Messages.getString((String)"GDE_MSGT1367").split(";");
    public static final String[] A3_MODUS_NAMES = Messages.getString((String)"GDE_MSGT1368").split(";");
    public static final String[] A1_MODUS_NAMES_COMBO = Messages.getString((String)"GDE_MSGT1372").split(";");
    public static final String[] A2_MODUS_NAMES_COMBO = Messages.getString((String)"GDE_MSGT1373").split(";");
    public static final String[] A3_MODUS_NAMES_COMBO = Messages.getString((String)"GDE_MSGT1374").split(";");
    public static final String[] A1_MODUS_UNITS = Messages.getString((String)"GDE_MSGT1369").split(";");
    public static final String[] A2_MODUS_UNITS = Messages.getString((String)"GDE_MSGT1370").split(";");
    public static final String[] A3_MODUS_UNITS = Messages.getString((String)"GDE_MSGT1371").split(";");
    CTabItem configTabItem1;
    CTabItem configTabItem2;
    CTabItem configTabItem3;
    CTabItem configTabItem4;
    CLabel currentSensorLabel;
    CLabel a1ModusLabel;
    CLabel a2ModusLabel;
    CLabel a3ModusLabel;
    CCombo a1ModusCombo;
    CCombo a2ModusCombo;
    CCombo a3ModusCombo;
    CCombo sensorCurrentCombo;
    Group sensorGroup;
    CCombo impulseTriggerCombo;
    CCombo timeTriggerCombo;
    Button numberPolsButton;
    CCombo currentTriggerCombo;
    Button impulseTriggerButton;
    Button timeTriggerButton;
    Button currentTriggerButton;
    Group autoStartGroup;
    Text gearFactorCombo;
    CLabel gearLabel;
    CCombo numberProbCombo;
    CCombo motorPoleCombo;
    Button numberPropButton;
    Group motorPropGroup;
    Button storeAdjustmentsButton;
    CCombo useConfigCombo;
    CLabel firmwareVersionLabel;
    CLabel firmwareText;
    CLabel snLabel;
    CLabel serialNumberText;
    CLabel memUsageUnit;
    CLabel memoryUsageText;
    Slider gearRatioSlider;
    Button stopDataButton;
    Group liveDataCaptureGroup;
    Button clearMemoryButton;
    Group clearDataBufferGroup;
    Button startLiveGatherButton;
    Button stopLoggingButton;
    Button startLoggingButton;
    Group loggingGroup;
    CLabel numberReadErrorLabel;
    CLabel readDataErrorLabel;
    CLabel redDataSetLabel;
    CLabel readDataLess2Label;
    CLabel numberLess2Label;
    CLabel dataSetLabel;
    CLabel actualDataSetNumberLabel;
    CLabel actualDataSetNumber;
    ProgressBar readDataProgressBar;
    Button readDataButton;
    Group dataReadGroup;
    Button closeButton;
    Button helpButton;
    Composite dataMainComposite;
    CTabItem dataTabItem;
    Group statusGroup;
    CLabel memUsagePercent;
    CCombo timeIntervalCombo;
    Group dataRateGroup;
    Composite configMainComosite;
    Button readAdjustmentButton;
    CTabItem baseConfigTabItem;
    CTabFolder deviceConfigTabFolder;
    Group limiterGroup;
    CCombo limiterEnergyCombo;
    Button limiterButton;
    Group channleConfigGroup;
    Button stopLiveGatherButton;
    Button editConfigButton;
    Text memoryDeleteInfo;
    CTabItem telemetryTabItem;
    UniLogTelemetryTab telemetryTab;
    final Settings settings;
    final UniLogSerialPort serialPort;
    final UniLog device;
    UniLogDataGatherer gatherThread;
    UniLogLiveGatherer liveThread;
    UniLogConfigTab configTab1;
    UniLogConfigTab configTab2;
    UniLogConfigTab configTab3;
    UniLogConfigTab configTab4;
    TaskItem taskBarItem;
    RecordSet lastActiveRecordSet = null;
    String statusText = "";
    String serialNumber = "";
    String unilogVersion = "";
    int memoryUsed = 0;
    String memoryUsedPercent = "0";
    int timeIntervalPosition = -1;
    boolean isMotorPole = false;
    boolean isPropBlade = false;
    int countMotorPole = 0;
    int countPropBlade = 0;
    boolean isAutoStartCurrent = false;
    int currentAutoStart = 0;
    boolean isAutStartRx = false;
    boolean isRxOn = false;
    int rxAutoStartValue = 0;
    boolean isImpulseAutoStartTime = false;
    int impulseAutoStartTime_sec = 0;
    int currentSensorPosition = 0;
    int modusA1Position = 0;
    int modusA2Position = 0;
    int modusA3Position = 0;
    int limiterValue = 0;
    boolean isLimiterActive = false;
    double gearRatio = 1.0;
    boolean isLiveGathererEnabled = true;
    int sliderPosition = 50;
    String[] configurationNames = new String[]{" Konfig 1"};
    String numberRedDataSetsText = "0";
    String numberActualDataSetsText = "0";
    String numberReadErrorText = "0";
    String numberLess2Text = "0";
    int channelSelectionIndex = 0;

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            UniLog device = new UniLog("c:\\Documents and Settings\\user\\Application Data\\DataExplorer\\Geraete\\Htronic Akkumaster C4.ini");
            UniLogDialog inst = new UniLogDialog(shell, device);
            inst.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UniLogDialog(Shell parent, UniLog useDevice) {
        super(parent);
        this.serialPort = useDevice.getCommunicationPort();
        this.device = useDevice;
        this.settings = Settings.getInstance();
        UniLogDialog.RX_AUTO_START_MS[UniLogDialog.RX_AUTO_START_MS.length - 1] = Messages.getString((String)"GDE_MSGT1300");
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            }
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                this.dialogShell.setText(DEVICE_NAME + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                this.dialogShell.setLayout(null);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(GDE.IS_LINUX ? 655 : 645, 445);
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                UniLogDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "dialogShell.widgetDisposed, event=" + evt);
                        }
                        if (UniLogDialog.this.configTab1.getConfigButtonStatus() || UniLogDialog.this.configTab2.getConfigButtonStatus() || UniLogDialog.this.configTab3.getConfigButtonStatus() || UniLogDialog.this.configTab4.getConfigButtonStatus()) {
                            String msg = Messages.getString((String)"GDE_MSGI1300");
                            if (UniLogDialog.this.application.openYesNoMessageDialog(UniLogDialog.this.getDialogShell(), msg) == 64) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "SWT.YES");
                                }
                                UniLogDialog.this.device.storeDeviceProperties();
                                UniLogDialog.this.setClosePossible(true);
                            }
                        }
                        if (UniLogDialog.this.gatherThread != null && UniLogDialog.this.gatherThread.isAlive()) {
                            UniLogDialog.this.gatherThread.interrupt();
                        }
                        if (UniLogDialog.this.liveThread != null) {
                            if (UniLogDialog.this.liveThread.isTimerRunning) {
                                UniLogDialog.this.liveThread.stopTimerThread();
                            }
                            if (UniLogDialog.this.liveThread.isAlive()) {
                                UniLogDialog.this.liveThread.interrupt();
                            }
                        }
                        UniLogDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        int selection;
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "dialogShell.helpRequested, event=" + evt);
                        }
                        if ((selection = UniLogDialog.this.deviceConfigTabFolder.getSelectionIndex()) == 0) {
                            UniLogDialog.this.application.openHelpDialog(UniLogDialog.DEVICE_NAME, "HelpInfo.html#adjustment");
                        } else if (selection == UniLogDialog.this.deviceConfigTabFolder.getItemCount() - 2) {
                            UniLogDialog.this.application.openHelpDialog(UniLogDialog.DEVICE_NAME, "HelpInfo.html#data_io");
                        } else if (selection == UniLogDialog.this.deviceConfigTabFolder.getItemCount() - 1) {
                            UniLogDialog.this.application.openHelpDialog(UniLogDialog.DEVICE_NAME, "HelpInfo.html#telemetry");
                        } else {
                            UniLogDialog.this.application.openHelpDialog(UniLogDialog.DEVICE_NAME, "HelpInfo.html#config_tab");
                        }
                    }
                });
                this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "dialogShell.mouseEnter, event=" + evt);
                        }
                        UniLogDialog.this.fadeOutAplhaBlending(evt, UniLogDialog.this.getDialogShell().getClientArea(), 10, 10, 10, 15);
                    }

                    public void mouseHover(MouseEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.mouseHover, event=" + evt);
                        }
                    }

                    public void mouseExit(MouseEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "dialogShell.mouseExit, event=" + evt);
                        }
                        UniLogDialog.this.fadeInAlpaBlending(evt, UniLogDialog.this.getDialogShell().getClientArea(), 10, 10, -10, 15);
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + paintevent);
                        }
                        RecordSet activeRecordSet = UniLogDialog.this.application.getActiveRecordSet();
                        if (UniLogDialog.this.lastActiveRecordSet != null && activeRecordSet != null && !UniLogDialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            int index = Channels.getInstance().getActiveChannelNumber();
                            index = index < 1 || index > UniLogDialog.this.deviceConfigTabFolder.getChildren().length - 2 ? 1 : index;
                            UniLogDialog.this.deviceConfigTabFolder.setSelection(index);
                            UniLogDialog.this.deviceConfigTabFolder.getChildren()[index].update();
                        }
                        UniLogDialog.this.lastActiveRecordSet = UniLogDialog.this.application.getActiveRecordSet();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setText(Messages.getString((String)"GDE_MSGT0280"));
                this.helpButton.setBounds(31, 374, 259, 30);
                this.helpButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "helpButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.application.openHelpDialog(UniLogDialog.DEVICE_NAME, "HelpInfo.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0188"));
                this.closeButton.setBounds(342, 374, 260, 30);
                this.closeButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.dispose();
                    }
                });
                this.deviceConfigTabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.baseConfigTabItem = new CTabItem(this.deviceConfigTabFolder, 0);
                this.baseConfigTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.baseConfigTabItem.setText(Messages.getString((String)"GDE_MSGT1301"));
                this.configMainComosite = new Composite((Composite)this.deviceConfigTabFolder, 0);
                this.baseConfigTabItem.setControl((Control)this.configMainComosite);
                this.configMainComosite.setLayout(null);
                this.configMainComosite.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.configMainComosite.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "configMainComosite.paintControl " + evt);
                        }
                        if (UniLogDialog.this.timeIntervalPosition == -1) {
                            int selection = Double.valueOf(UniLogDialog.this.device.getTimeStep_ms() / 62.5).intValue();
                            switch (selection) {
                                case 1: {
                                    UniLogDialog.this.timeIntervalPosition = 0;
                                    break;
                                }
                                case 2: {
                                    UniLogDialog.this.timeIntervalPosition = 1;
                                    break;
                                }
                                default: {
                                    UniLogDialog.this.timeIntervalPosition = 2;
                                    break;
                                }
                                case 8: {
                                    UniLogDialog.this.timeIntervalPosition = 3;
                                    break;
                                }
                                case 16: {
                                    UniLogDialog.this.timeIntervalPosition = 4;
                                    break;
                                }
                                case 32: {
                                    UniLogDialog.this.timeIntervalPosition = 5;
                                    break;
                                }
                                case 80: {
                                    UniLogDialog.this.timeIntervalPosition = 6;
                                    break;
                                }
                                case 160: {
                                    UniLogDialog.this.timeIntervalPosition = 7;
                                }
                            }
                        }
                        UniLogDialog.this.timeIntervalCombo.select(UniLogDialog.this.timeIntervalPosition);
                    }
                });
                this.statusGroup = new Group(this.configMainComosite, 0);
                this.statusGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.statusGroup.setLayout((Layout)new RowLayout(256));
                this.statusGroup.setText(Messages.getString((String)"GDE_MSGT1302"));
                this.statusGroup.setBounds(12, 17, 602, GDE.IS_MAC ? 55 : 45);
                this.statusGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                new Composite((Composite)this.statusGroup, 0).setLayoutData((Object)new RowData(10, 22));
                this.firmwareText = new CLabel((Composite)this.statusGroup, 0);
                this.firmwareText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.firmwareText.setText(Messages.getString((String)"GDE_MSGT1303"));
                this.firmwareText.setLayoutData((Object)new RowData(90, 22));
                this.firmwareVersionLabel = new CLabel((Composite)this.statusGroup, 0);
                this.firmwareVersionLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.firmwareVersionLabel.setLayoutData((Object)new RowData(70, 22));
                this.firmwareVersionLabel.setText(this.unilogVersion);
                this.serialNumberText = new CLabel((Composite)this.statusGroup, 0);
                this.serialNumberText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.serialNumberText.setText(Messages.getString((String)"GDE_MSGT1304"));
                this.serialNumberText.setLayoutData((Object)new RowData(45, 22));
                this.snLabel = new CLabel((Composite)this.statusGroup, 0x1000000);
                this.snLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.snLabel.setLayoutData((Object)new RowData(90, 22));
                this.snLabel.setText(this.serialNumber);
                this.memoryUsageText = new CLabel((Composite)this.statusGroup, 0);
                this.memoryUsageText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.memoryUsageText.setText(Messages.getString((String)"GDE_MSGT1305"));
                this.memoryUsageText.setLayoutData((Object)new RowData(135, 22));
                this.memUsagePercent = new CLabel((Composite)this.statusGroup, 0);
                this.memUsagePercent.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.memUsagePercent.setLayoutData((Object)new RowData(70, 22));
                this.memUsagePercent.setText(this.memoryUsedPercent);
                this.memUsageUnit = new CLabel((Composite)this.statusGroup, 0);
                this.memUsageUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.memUsageUnit.setText(Messages.getString((String)"GDE_MSGT1306"));
                this.memUsageUnit.setLayoutData((Object)new RowData(25, 22));
                this.statusGroup.layout();
                this.autoStartGroup = new Group(this.configMainComosite, 0);
                this.autoStartGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.autoStartGroup.setText(Messages.getString((String)"GDE_MSGT1309"));
                this.autoStartGroup.setBounds(12, 226, 300, GDE.IS_MAC ? 105 : 100);
                this.autoStartGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.autoStartGroup.setLayout((Layout)new GridLayout(3, false));
                new Composite((Composite)this.autoStartGroup, 0).setLayoutData((Object)new GridData(10, 20));
                this.currentTriggerButton = new Button((Composite)this.autoStartGroup, 16416);
                this.currentTriggerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.currentTriggerButton.setText(Messages.getString((String)"GDE_MSGT1310"));
                this.currentTriggerButton.setLayoutData((Object)new GridData(150, 18));
                this.currentTriggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "currentTriggerButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.currentTriggerCombo = new CCombo((Composite)this.autoStartGroup, 2048);
                this.currentTriggerCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.currentTriggerCombo.setLayoutData((Object)new GridData(80, 20));
                this.currentTriggerCombo.setItems(new String[]{"  1", "  2", "  3", "  4", "  5", "  6", "  7", "  8", "  9", " 10", "15", "20", "25", "30", "35", "40", "45", "50"});
                this.currentTriggerCombo.select(2);
                this.currentTriggerCombo.setEditable(false);
                this.currentTriggerCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.currentTriggerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "currentTriggerCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                new Composite((Composite)this.autoStartGroup, 0).setLayoutData((Object)new GridData(10, 20));
                this.timeTriggerButton = new Button((Composite)this.autoStartGroup, 16416);
                this.timeTriggerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeTriggerButton.setText(Messages.getString((String)"GDE_MSGT1311"));
                this.timeTriggerButton.setLayoutData((Object)new GridData(150, 18));
                this.timeTriggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "timeTriggerButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.timeTriggerCombo = new CCombo((Composite)this.autoStartGroup, 2048);
                this.timeTriggerCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeTriggerCombo.setLayoutData((Object)new GridData(80, 20));
                this.timeTriggerCombo.setItems(new String[]{"  1", "  2", "  3", "  4", "  5", "  6", "  7", "  8", "  9", " 10", " 11", " 12", " 13", " 14", " 15", " 16", " 17", " 18", " 19", " 20", " 30", " 60", " 120"});
                this.timeTriggerCombo.select(16);
                this.timeTriggerCombo.setEditable(true);
                this.timeTriggerCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.timeTriggerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "timeTriggerCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                new Composite((Composite)this.autoStartGroup, 0).setLayoutData((Object)new GridData(10, 20));
                this.impulseTriggerButton = new Button((Composite)this.autoStartGroup, 16416);
                this.impulseTriggerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.impulseTriggerButton.setText(Messages.getString((String)"GDE_MSGT1312"));
                this.impulseTriggerButton.setLayoutData((Object)new GridData(150, 18));
                this.impulseTriggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "impulseTriggerButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.impulseTriggerCombo = new CCombo((Composite)this.autoStartGroup, 2048);
                this.impulseTriggerCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.impulseTriggerCombo.setLayoutData((Object)new GridData(80, 20));
                this.impulseTriggerCombo.setEditable(false);
                this.impulseTriggerCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.impulseTriggerCombo.setItems(RX_AUTO_START_MS);
                this.impulseTriggerCombo.select(4);
                this.impulseTriggerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "rcTriggerCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.autoStartGroup.layout();
                this.motorPropGroup = new Group(this.configMainComosite, 0);
                this.motorPropGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.motorPropGroup.setLayout(null);
                this.motorPropGroup.setText(Messages.getString((String)"GDE_MSGT1313"));
                this.motorPropGroup.setBounds(12, 117, 300, GDE.IS_MAC ? 105 : 100);
                this.motorPropGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.motorPropGroup.setLayout((Layout)new RowLayout(256));
                new Composite((Composite)this.motorPropGroup, 0).setLayoutData((Object)new RowData(10, 22));
                this.numberPolsButton = new Button((Composite)this.motorPropGroup, 16400);
                this.numberPolsButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.numberPolsButton.setText(Messages.getString((String)"GDE_MSGT1314"));
                this.numberPolsButton.setLayoutData((Object)new RowData(140, 20));
                this.numberPolsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "numberPolsButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                        if (UniLogDialog.this.numberPolsButton.getSelection()) {
                            UniLogDialog.this.numberProbCombo.setEnabled(false);
                            UniLogDialog.this.motorPoleCombo.setEnabled(true);
                        } else {
                            UniLogDialog.this.numberProbCombo.setEnabled(true);
                            UniLogDialog.this.motorPoleCombo.setEnabled(false);
                            UniLogDialog.this.numberPropButton.setSelection(false);
                        }
                    }
                });
                this.motorPoleCombo = new CCombo((Composite)this.motorPropGroup, 2048);
                this.motorPoleCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.motorPoleCombo.setLayoutData((Object)new RowData(60, 20));
                this.motorPoleCombo.setItems(new String[]{"  2", "  4", "  6", "  8", " 10", " 12", " 14", " 16"});
                this.motorPoleCombo.select(6);
                this.motorPoleCombo.setEditable(false);
                this.motorPoleCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.motorPoleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "motorPoleCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.gearLabel = new CLabel((Composite)this.motorPropGroup, 16384);
                this.gearLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.gearLabel.setLayoutData((Object)new RowData(150, 20));
                this.gearLabel.setText(Messages.getString((String)"GDE_MSGT1315"));
                this.gearFactorCombo = new Text((Composite)this.motorPropGroup, 18432);
                this.gearFactorCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.gearFactorCombo.setLayoutData((Object)new RowData(50, 20));
                this.gearFactorCombo.setText(" 1.0  :  1");
                this.gearFactorCombo.setEditable(false);
                this.gearFactorCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.gearRatioSlider = new Slider((Composite)this.motorPropGroup, 256);
                this.gearRatioSlider.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.gearRatioSlider.setLayoutData((Object)new RowData(70, 20));
                this.gearRatioSlider.setMinimum(0);
                this.gearRatioSlider.setMaximum(100);
                this.gearRatioSlider.setSelection(this.sliderPosition);
                this.gearRatioSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "gearRatioSlider.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                        if (UniLogDialog.this.gearRatioSlider.getSelection() > UniLogDialog.this.sliderPosition) {
                            UniLogDialog.this.gearFactorCombo.setText(String.format(" %.1f  :  1", UniLogDialog.this.getGearRatio() - 0.1));
                            ++UniLogDialog.this.sliderPosition;
                        } else {
                            UniLogDialog.this.gearFactorCombo.setText(String.format(" %.1f  :  1", UniLogDialog.this.getGearRatio() + 0.1));
                            --UniLogDialog.this.sliderPosition;
                        }
                    }
                });
                new Composite((Composite)this.motorPropGroup, 0).setLayoutData((Object)new RowData(10, 22));
                this.numberPropButton = new Button((Composite)this.motorPropGroup, 16400);
                this.numberPropButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.numberPropButton.setText(Messages.getString((String)"GDE_MSGT1316"));
                this.numberPropButton.setLayoutData((Object)new RowData(140, 20));
                this.numberPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "numberPropButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                        if (UniLogDialog.this.numberPropButton.getSelection()) {
                            UniLogDialog.this.numberProbCombo.setEnabled(true);
                            UniLogDialog.this.motorPoleCombo.setEnabled(false);
                        } else {
                            UniLogDialog.this.numberProbCombo.setEnabled(false);
                            UniLogDialog.this.motorPoleCombo.setEnabled(true);
                            UniLogDialog.this.numberPolsButton.setSelection(false);
                        }
                    }
                });
                this.numberProbCombo = new CCombo((Composite)this.motorPropGroup, 2048);
                this.numberProbCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.numberProbCombo.setLayoutData((Object)new RowData(60, 20));
                this.numberProbCombo.setItems(new String[]{" 1", " 2", " 3", " 4"});
                this.numberProbCombo.select(1);
                this.numberProbCombo.setEditable(false);
                this.numberProbCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.numberProbCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "numbeProbCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.motorPropGroup.layout();
                this.dataRateGroup = new Group(this.configMainComosite, 0);
                this.dataRateGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dataRateGroup.setText(Messages.getString((String)"GDE_MSGT1317"));
                this.dataRateGroup.setBounds(337, 70, 277, GDE.IS_MAC ? 55 : 45);
                this.dataRateGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.dataRateGroup.setLayout((Layout)new GridLayout(1, true));
                this.timeIntervalCombo = new CCombo((Composite)this.dataRateGroup, 2048);
                this.timeIntervalCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeIntervalCombo.setItems(TIME_INTERVAL);
                GridData timeGridData = new GridData(160, 20);
                timeGridData.grabExcessHorizontalSpace = true;
                timeGridData.horizontalAlignment = 0x1000000;
                this.timeIntervalCombo.setLayoutData((Object)timeGridData);
                this.timeIntervalCombo.select(1);
                this.timeIntervalCombo.setEditable(false);
                this.timeIntervalCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.timeIntervalCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "timeRateCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                        UniLogDialog.this.timeIntervalPosition = UniLogDialog.this.timeIntervalCombo.getSelectionIndex();
                    }
                });
                this.dataRateGroup.layout();
                this.sensorGroup = new Group(this.configMainComosite, 0);
                this.sensorGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.sensorGroup.setText(Messages.getString((String)"GDE_MSGT1307"));
                this.sensorGroup.setBounds(337, 120, 277, 123);
                this.sensorGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.sensorGroup.setLayout((Layout)new RowLayout(256));
                this.currentSensorLabel = new CLabel((Composite)this.sensorGroup, 131072);
                this.currentSensorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.currentSensorLabel.setText("Current");
                this.currentSensorLabel.setLayoutData((Object)new RowData(90, 20));
                this.sensorCurrentCombo = new CCombo((Composite)this.sensorGroup, 2048);
                this.sensorCurrentCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.sensorCurrentCombo.setLayoutData((Object)new RowData(135, 20));
                this.sensorCurrentCombo.setItems(CURRENT_SENSOR);
                this.sensorCurrentCombo.select(2);
                this.sensorCurrentCombo.setEditable(false);
                this.sensorCurrentCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.sensorCurrentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "sensorCurrentCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.a1ModusLabel = new CLabel((Composite)this.sensorGroup, 131072);
                this.a1ModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.a1ModusLabel.setText("A1 Modus");
                this.a1ModusLabel.setLayoutData((Object)new RowData(90, 20));
                this.a1ModusCombo = new CCombo((Composite)this.sensorGroup, 2048);
                this.a1ModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.a1ModusCombo.setItems(A1_MODUS_NAMES_COMBO);
                this.a1ModusCombo.select(0);
                this.a1ModusCombo.setEditable(false);
                this.a1ModusCombo.setLayoutData((Object)new RowData(135, 20));
                this.a1ModusCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.a1ModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "a1ModusCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.modusA1Position = UniLogDialog.this.a1ModusCombo.getSelectionIndex();
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.a2ModusLabel = new CLabel((Composite)this.sensorGroup, 131072);
                this.a2ModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.a2ModusLabel.setText("A2 Modus");
                this.a2ModusLabel.setLayoutData((Object)new RowData(90, 20));
                this.a2ModusCombo = new CCombo((Composite)this.sensorGroup, 2048);
                this.a2ModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.a2ModusCombo.setItems(A2_MODUS_NAMES_COMBO);
                this.a2ModusCombo.select(0);
                this.a2ModusCombo.setEditable(false);
                this.a2ModusCombo.setLayoutData((Object)new RowData(135, 20));
                this.a2ModusCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.a2ModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "a2ModusCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.modusA2Position = UniLogDialog.this.a2ModusCombo.getSelectionIndex();
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.a3ModusLabel = new CLabel((Composite)this.sensorGroup, 131072);
                this.a3ModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.a3ModusLabel.setText("A3 Modus");
                this.a3ModusLabel.setLayoutData((Object)new RowData(90, 20));
                this.a3ModusCombo = new CCombo((Composite)this.sensorGroup, 2048);
                this.a3ModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.a3ModusCombo.setItems(A3_MODUS_NAMES_COMBO);
                this.a3ModusCombo.select(0);
                this.a3ModusCombo.setEditable(false);
                this.a3ModusCombo.setLayoutData((Object)new RowData(135, 20));
                this.a3ModusCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.a3ModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "a3ModusCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.modusA3Position = UniLogDialog.this.a3ModusCombo.getSelectionIndex();
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.sensorGroup.layout();
                this.limiterGroup = new Group(this.configMainComosite, 0);
                this.limiterGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.limiterGroup.setText(Messages.getString((String)"GDE_MSGT1308"));
                this.limiterGroup.setBounds(337, 243, 277, GDE.IS_MAC ? 55 : 45);
                this.limiterGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.limiterGroup.setLayout((Layout)new GridLayout(3, false));
                new Composite((Composite)this.limiterGroup, 0).setLayoutData((Object)new GridData(25, 20));
                this.limiterButton = new Button((Composite)this.limiterGroup, 16416);
                this.limiterButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.limiterButton.setLayoutData((Object)new GridData(100, 20));
                this.limiterButton.setText("      [ W min ] ");
                this.limiterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "limiterEnergyButton.widgetSelected, event=" + evt);
                        }
                        if (UniLogDialog.this.limiterButton.getSelection() && 256 == UniLogDialog.this.application.openOkCancelMessageDialog(UniLogDialog.this.getDialogShell(), "Da der UniLog im Limiter Modus aktiv in das Servosignal eingreift, darf hier nur der Reglerkanal \u00fcber den UniLog geleitet werden. Bei erreichtem Limit wird ein Servoimpuls von 900 us an den Regler ausgegeben. Es muss sichergestellt sein, dass damit der Antrieb abgeschaltet ist.\n\nLimiter Modus aktivieren?")) {
                            UniLogDialog.this.limiterButton.setSelection(false);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.limiterEnergyCombo = new CCombo((Composite)this.limiterGroup, 2048);
                this.limiterEnergyCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.limiterEnergyCombo.setItems(new String[]{" 100", " 250", " 500", " 1000", " 1500", " 2000", " 2500", " 3000"});
                this.limiterEnergyCombo.setLayoutData((Object)new GridData(80, 20));
                this.limiterEnergyCombo.select(1);
                this.limiterEnergyCombo.setEditable(true);
                this.limiterEnergyCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.limiterEnergyCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "limiterEnergyCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                        int limiterMaxValue = Integer.parseInt(UniLogDialog.this.limiterEnergyCombo.getText().trim().replace(",", "."));
                        if (limiterMaxValue < 100) {
                            limiterMaxValue = 100;
                        } else if (limiterMaxValue > 3000) {
                            limiterMaxValue = 3000;
                        }
                    }
                });
                this.limiterEnergyCombo.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "recordSelectCombo.keyPressed, event=" + evt);
                        }
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                    }
                });
                this.limiterGroup.layout();
                this.readAdjustmentButton = new Button(this.configMainComosite, 0x1800008);
                this.readAdjustmentButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.readAdjustmentButton.setText(Messages.getString((String)"GDE_MSGT1318"));
                this.readAdjustmentButton.setBounds(12, GDE.IS_MAC ? 83 : 74, 300, 30);
                this.readAdjustmentButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.readAdjustmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "readAdjustmentButton.widgetSelected, event=" + evt);
                        }
                        try {
                            UniLogDialog.this.updateConfigurationValues(UniLogDialog.this.serialPort.readConfiguration());
                        }
                        catch (ApplicationConfigurationException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            UniLogDialog.this.application.openMessageDialog(UniLogDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                            UniLogDialog.this.application.getDeviceSelectionDialog().open();
                        }
                        catch (Exception e) {
                            UniLogDialog.this.application.openMessageDialog(UniLogDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        }
                    }
                });
                this.storeAdjustmentsButton = new Button(this.configMainComosite, 0x1000008);
                this.storeAdjustmentsButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.storeAdjustmentsButton.setText(Messages.getString((String)"GDE_MSGT1319"));
                this.storeAdjustmentsButton.setBounds(335, GDE.IS_MAC ? 300 : 296, 281, 30);
                this.storeAdjustmentsButton.setEnabled(false);
                this.storeAdjustmentsButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.storeAdjustmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "storeAdjustmentsButton.widgetSelected, event=" + evt);
                        }
                        try {
                            if (UniLogDialog.this.serialPort.setConfiguration(UniLogDialog.this.buildUpdateBuffer())) {
                                UniLogDialog.this.updateTimeStep_ms(UniLogDialog.this.timeIntervalPosition);
                                UniLogDialog.this.storeAdjustmentsButton.setEnabled(false);
                            } else {
                                UniLogDialog.this.storeAdjustmentsButton.setEnabled(true);
                            }
                        }
                        catch (Exception e) {
                            UniLogDialog.this.application.openMessageDialog(UniLogDialog.this.getDialogShell(), e.getMessage());
                        }
                    }
                });
                if (this.device.getChannelCount() > 0) {
                    this.configTabItem1 = new CTabItem(this.deviceConfigTabFolder, 0);
                    this.configTabItem1.setText(this.device.getChannelNameReplacement(1));
                    this.configTab1 = new UniLogConfigTab(this.deviceConfigTabFolder, this.device, this.device.getChannelNameReplacement(1));
                    this.configTabItem1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.configTabItem1.setControl((Control)this.configTab1);
                }
                if (this.device.getChannelCount() > 1) {
                    this.configTabItem2 = new CTabItem(this.deviceConfigTabFolder, 0);
                    this.configTabItem2.setText(this.device.getChannelNameReplacement(2));
                    this.configTab2 = new UniLogConfigTab(this.deviceConfigTabFolder, this.device, this.device.getChannelNameReplacement(2));
                    this.configTabItem2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.configTabItem2.setControl((Control)this.configTab2);
                }
                if (this.device.getChannelCount() > 2) {
                    this.configTabItem3 = new CTabItem(this.deviceConfigTabFolder, 0);
                    this.configTabItem3.setText(this.device.getChannelNameReplacement(3));
                    this.configTab3 = new UniLogConfigTab(this.deviceConfigTabFolder, this.device, this.device.getChannelNameReplacement(3));
                    this.configTabItem3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.configTabItem3.setControl((Control)this.configTab3);
                }
                if (this.device.getChannelCount() > 3) {
                    this.configTabItem4 = new CTabItem(this.deviceConfigTabFolder, 0);
                    this.configTabItem4.setText(this.device.getChannelNameReplacement(4));
                    this.configTab4 = new UniLogConfigTab(this.deviceConfigTabFolder, this.device, this.device.getChannelNameReplacement(4));
                    this.configTabItem4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.configTabItem4.setControl((Control)this.configTab4);
                }
                this.dataTabItem = new CTabItem(this.deviceConfigTabFolder, 0);
                this.dataTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dataTabItem.setText(Messages.getString((String)"GDE_MSGT1320"));
                this.dataMainComposite = new Composite((Composite)this.deviceConfigTabFolder, 0);
                this.dataMainComposite.setLayout(null);
                this.dataTabItem.setControl((Control)this.dataMainComposite);
                this.channleConfigGroup = new Group(this.dataMainComposite, 0);
                this.channleConfigGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.channleConfigGroup.setBounds(14, 12, 290, 58);
                this.channleConfigGroup.setText(Messages.getString((String)"GDE_MSGT1321"));
                this.channleConfigGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.channleConfigGroup.setLayout((Layout)new GridLayout(2, true));
                this.useConfigCombo = new CCombo((Composite)this.channleConfigGroup, 2048);
                this.useConfigCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.useConfigCombo.setLayoutData((Object)new GridData(140, 20));
                this.useConfigCombo.setItems(this.configurationNames);
                this.useConfigCombo.select(this.channelSelectionIndex);
                this.useConfigCombo.setEditable(false);
                this.useConfigCombo.setTextLimit(18);
                this.useConfigCombo.setVisibleItemCount(5);
                this.useConfigCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.useConfigCombo.setToolTipText(Messages.getString((String)"GDE_MSGT1322"));
                this.useConfigCombo.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "useConfigCombo.keyReleased, event=" + evt);
                        }
                        if (evt.character == '\r') {
                            String configName = UniLogDialog.this.useConfigCombo.getText().trim();
                            UniLogDialog.this.device.setChannelName(configName, UniLogDialog.this.channelSelectionIndex + 1);
                            UniLogDialog.this.configurationNames[UniLogDialog.this.channelSelectionIndex] = configName;
                            UniLogDialog.this.useConfigCombo.select(UniLogDialog.this.channelSelectionIndex);
                            UniLogDialog.this.dataReadGroup.redraw();
                            ((Channel)Channels.getInstance().get((Object)(UniLogDialog.this.channelSelectionIndex + 1))).setName(" " + (UniLogDialog.this.channelSelectionIndex + 1) + " : " + configName);
                            UniLogDialog.this.application.getMenuToolBar().updateChannelSelector();
                            switch (UniLogDialog.this.channelSelectionIndex) {
                                case 0: {
                                    UniLogDialog.this.configTabItem1.setText(configName);
                                    UniLogDialog.this.configTab1.setConfigName(configName);
                                    break;
                                }
                                case 1: {
                                    UniLogDialog.this.configTabItem2.setText(configName);
                                    UniLogDialog.this.configTab2.setConfigName(configName);
                                    break;
                                }
                                case 2: {
                                    UniLogDialog.this.configTabItem3.setText(configName);
                                    UniLogDialog.this.configTab3.setConfigName(configName);
                                    break;
                                }
                                case 3: {
                                    UniLogDialog.this.configTabItem4.setText(configName);
                                    UniLogDialog.this.configTab4.setConfigName(configName);
                                }
                            }
                            UniLogDialog.this.deviceConfigTabFolder.redraw();
                            UniLogDialog.this.editConfigButton.setEnabled(false);
                            UniLogDialog.this.device.storeDeviceProperties();
                        }
                    }
                });
                this.useConfigCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "useConfigCombo.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.readDataButton.setEnabled(true);
                        UniLogDialog.this.startLoggingButton.setEnabled(true);
                        UniLogDialog.this.isLiveGathererEnabled = true;
                        UniLogDialog.this.startLiveGatherButton.setEnabled(true);
                        UniLogDialog.this.channelSelectionIndex = UniLogDialog.this.useConfigCombo.getSelectionIndex();
                        UniLogDialog.this.useConfigCombo.select(UniLogDialog.this.channelSelectionIndex);
                        Channels.getInstance().switchChannel(UniLogDialog.this.channelSelectionIndex + 1, "");
                        UniLogDialog.this.editConfigButton.setEnabled(true);
                        UniLogDialog.this.resetDataSetsLabel();
                    }
                });
                this.editConfigButton = new Button((Composite)this.channleConfigGroup, 0x1000008);
                this.editConfigButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.editConfigButton.setLayoutData((Object)new GridData(130, 20));
                this.editConfigButton.setText(Messages.getString((String)"GDE_MSGT1323"));
                this.editConfigButton.setEnabled(false);
                this.editConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "editConfigButton.widgetSelected, event=" + evt);
                        }
                        UniLogDialog.this.useConfigCombo.setEditable(true);
                        UniLogDialog.this.editConfigButton.setEnabled(false);
                    }
                });
                this.channleConfigGroup.layout();
                this.dataReadGroup = new Group(this.dataMainComposite, 0);
                this.dataReadGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dataReadGroup.setBounds(14, 78, 290, 242);
                this.dataReadGroup.setText(Messages.getString((String)"GDE_MSGT1324"));
                this.dataReadGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.dataReadGroup.setLayout((Layout)new GridLayout(2, false));
                this.dataReadGroup.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dataReadGroup.paintControl, event=" + evt);
                        }
                        int index = UniLogDialog.this.application.getActiveChannelNumber() - 1;
                        UniLogDialog.this.configurationNames = new String[UniLogDialog.this.device.getChannelCount()];
                        for (int i = 0; i < UniLogDialog.this.configurationNames.length; ++i) {
                            UniLogDialog.this.configurationNames[i] = " " + UniLogDialog.this.device.getChannelNameReplacement(i + 1);
                        }
                        UniLogDialog.this.useConfigCombo.setItems(UniLogDialog.this.configurationNames);
                        UniLogDialog.this.useConfigCombo.select(index);
                    }
                });
                this.readDataButton = new Button((Composite)this.dataReadGroup, 0x1000008);
                this.readDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.readDataButton.setText(Messages.getString((String)"GDE_MSGT1325"));
                GridData buttonGridData = new GridData(260, 35);
                buttonGridData.grabExcessHorizontalSpace = true;
                buttonGridData.horizontalAlignment = 0x1000000;
                buttonGridData.horizontalSpan = 2;
                this.readDataButton.setLayoutData((Object)buttonGridData);
                this.readDataButton.setEnabled(true);
                this.readDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "readDataButton.widgetSelected, event=" + evt);
                        }
                        String channelName = " " + (UniLogDialog.this.useConfigCombo.getSelectionIndex() + 1) + " : " + UniLogDialog.this.useConfigCombo.getText();
                        UniLogDialog.this.gatherThread = new UniLogDataGatherer(UniLogDialog.this.application, UniLogDialog.this.device, UniLogDialog.this.serialPort, channelName);
                        try {
                            UniLogDialog.this.gatherThread.start();
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                        UniLogDialog.this.setClosePossible(false);
                        UniLogDialog.this.readAdjustmentButton.setEnabled(false);
                        UniLogDialog.this.storeAdjustmentsButton.setEnabled(false);
                        UniLogDialog.this.readDataButton.setEnabled(false);
                        UniLogDialog.this.editConfigButton.setEnabled(false);
                        UniLogDialog.this.stopDataButton.setEnabled(true);
                        UniLogDialog.this.startLoggingButton.setEnabled(false);
                        UniLogDialog.this.stopLoggingButton.setEnabled(false);
                        UniLogDialog.this.useConfigCombo.setEnabled(false);
                        UniLogDialog.this.isLiveGathererEnabled = false;
                        UniLogDialog.this.startLiveGatherButton.setEnabled(false);
                        UniLogDialog.this.clearMemoryButton.setEnabled(false);
                        UniLogDialog.this.closeButton.setEnabled(false);
                    }
                });
                this.dataSetLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.dataSetLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                GridData labelGridData = new GridData(180, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.dataSetLabel.setLayoutData((Object)labelGridData);
                this.dataSetLabel.setText(Messages.getString((String)"GDE_MSGT1326"));
                this.redDataSetLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.redDataSetLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                labelGridData = new GridData(55, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.redDataSetLabel.setLayoutData((Object)labelGridData);
                this.redDataSetLabel.setText("0");
                this.actualDataSetNumberLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.actualDataSetNumberLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                labelGridData = new GridData(180, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.actualDataSetNumberLabel.setLayoutData((Object)labelGridData);
                this.actualDataSetNumberLabel.setText(Messages.getString((String)"GDE_MSGT1327"));
                this.actualDataSetNumber = new CLabel((Composite)this.dataReadGroup, 131072);
                this.actualDataSetNumber.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                labelGridData = new GridData(55, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.actualDataSetNumber.setLayoutData((Object)labelGridData);
                this.actualDataSetNumber.setText("0");
                this.readDataErrorLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.readDataErrorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                labelGridData = new GridData(180, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.readDataErrorLabel.setLayoutData((Object)labelGridData);
                this.readDataErrorLabel.setText(Messages.getString((String)"GDE_MSGT1328"));
                this.numberReadErrorLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.numberReadErrorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                labelGridData = new GridData(55, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.numberReadErrorLabel.setLayoutData((Object)labelGridData);
                this.numberReadErrorLabel.setText("0");
                this.readDataLess2Label = new CLabel((Composite)this.dataReadGroup, 131072);
                this.readDataLess2Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                labelGridData = new GridData(180, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.readDataLess2Label.setLayoutData((Object)labelGridData);
                this.readDataLess2Label.setText(Messages.getString((String)"GDE_MSGT1331"));
                this.numberLess2Label = new CLabel((Composite)this.dataReadGroup, 131072);
                this.numberLess2Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                labelGridData = new GridData(55, 20);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 1;
                this.numberLess2Label.setLayoutData((Object)labelGridData);
                this.numberLess2Label.setText("0");
                this.readDataProgressBar = new ProgressBar((Composite)this.dataReadGroup, 0);
                labelGridData = new GridData(260, 24);
                labelGridData.grabExcessHorizontalSpace = true;
                labelGridData.horizontalAlignment = 0x1000000;
                labelGridData.horizontalSpan = 2;
                this.readDataProgressBar.setLayoutData((Object)labelGridData);
                this.readDataProgressBar.setMinimum(0);
                this.readDataProgressBar.setMaximum(100);
                this.stopDataButton = new Button((Composite)this.dataReadGroup, 0x1000008);
                this.stopDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                buttonGridData = new GridData(260, 35);
                buttonGridData.grabExcessHorizontalSpace = true;
                buttonGridData.horizontalAlignment = 0x1000000;
                buttonGridData.horizontalSpan = 2;
                this.stopDataButton.setLayoutData((Object)buttonGridData);
                this.stopDataButton.setText(Messages.getString((String)"GDE_MSGT0278"));
                this.stopDataButton.setEnabled(false);
                this.stopDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "stopDataButton.widgetSelected, event=" + evt);
                        }
                        if (UniLogDialog.this.gatherThread != null && UniLogDialog.this.gatherThread.isAlive()) {
                            UniLogDialog.this.gatherThread.setThreadStop();
                        }
                        UniLogDialog.this.resetButtons();
                    }
                });
                this.dataReadGroup.layout();
                this.liveDataCaptureGroup = new Group(this.dataMainComposite, 0);
                this.liveDataCaptureGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.liveDataCaptureGroup.setBounds(324, 12, 284, 198);
                this.liveDataCaptureGroup.setText(Messages.getString((String)"GDE_MSGT1329"));
                this.liveDataCaptureGroup.setToolTipText(Messages.getString((String)"GDE_MSGT1384"));
                this.liveDataCaptureGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.liveDataCaptureGroup.setLayout((Layout)new GridLayout(1, true));
                this.startLiveGatherButton = new Button((Composite)this.liveDataCaptureGroup, 0x1000008);
                this.startLiveGatherButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startLiveGatherButton.setText(Messages.getString((String)"GDE_MSGT1330"));
                this.startLiveGatherButton.setToolTipText(Messages.getString((String)"GDE_MSGT1384"));
                buttonGridData = new GridData(260, 35);
                buttonGridData.grabExcessHorizontalSpace = true;
                buttonGridData.horizontalAlignment = 0x1000000;
                this.startLiveGatherButton.setLayoutData((Object)buttonGridData);
                this.startLiveGatherButton.setEnabled(this.isLiveGathererEnabled);
                this.startLiveGatherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "liveViewButton.widgetSelected, event=" + evt);
                        }
                        try {
                            int channelNumber = UniLogDialog.this.useConfigCombo.getSelectionIndex() + 1;
                            UniLogDialog.this.isLiveGathererEnabled = false;
                            UniLogDialog.this.setButtonStateLiveGatherer(false);
                            UniLogDialog.this.setClosePossible(false);
                            UniLogDialog.this.liveThread = new UniLogLiveGatherer(UniLogDialog.this.application, UniLogDialog.this.device, UniLogDialog.this.serialPort, channelNumber, UniLogDialog.this);
                            try {
                                UniLogDialog.this.liveThread.start();
                            }
                            catch (RuntimeException e) {
                                log.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                        catch (Exception e) {
                            if (UniLogDialog.this.liveThread != null && UniLogDialog.this.liveThread.isTimerRunning) {
                                UniLogDialog.this.liveThread.stopTimerThread();
                                UniLogDialog.this.liveThread.interrupt();
                            }
                            UniLogDialog.this.application.updateGraphicsWindow();
                            UniLogDialog.this.application.openMessageDialog(UniLogDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE1301", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                            UniLogDialog.this.resetButtons();
                        }
                    }
                });
                this.loggingGroup = new Group((Composite)this.liveDataCaptureGroup, 0);
                this.loggingGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                GridData groupGridData = new GridData(260, 50);
                groupGridData.grabExcessHorizontalSpace = true;
                groupGridData.horizontalAlignment = 0x1000000;
                this.loggingGroup.setLayoutData((Object)groupGridData);
                this.loggingGroup.setText(Messages.getString((String)"GDE_MSGT1332"));
                this.loggingGroup.setToolTipText(Messages.getString((String)"GDE_MSGT1383"));
                this.loggingGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.loggingGroup.setLayout((Layout)new GridLayout(2, true));
                this.startLoggingButton = new Button((Composite)this.loggingGroup, 0x1000008);
                this.startLoggingButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startLoggingButton.setText(Messages.getString((String)"GDE_MSGT0274"));
                this.startLoggingButton.setToolTipText(Messages.getString((String)"GDE_MSGT1383"));
                GridData buttonGridData2 = new GridData(100, 30);
                buttonGridData2.grabExcessHorizontalSpace = true;
                buttonGridData2.grabExcessVerticalSpace = true;
                buttonGridData2.horizontalAlignment = 0x1000000;
                this.startLoggingButton.setLayoutData((Object)buttonGridData2);
                this.startLoggingButton.setEnabled(true);
                this.startLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "startLoggingButton.widgetSelected, event=" + evt);
                        }
                        try {
                            UniLogDialog.this.setClosePossible(false);
                            UniLogDialog.this.serialPort.startLogging();
                            UniLogDialog.this.startLoggingButton.setEnabled(false);
                            UniLogDialog.this.stopLoggingButton.setEnabled(true);
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            UniLogDialog.this.application.openMessageDialog(UniLogDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        }
                    }
                });
                this.stopLoggingButton = new Button((Composite)this.loggingGroup, 0x1000008);
                this.stopLoggingButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopLoggingButton.setText(Messages.getString((String)"GDE_MSGT0275"));
                buttonGridData2 = new GridData(100, 30);
                buttonGridData2.grabExcessHorizontalSpace = true;
                buttonGridData2.grabExcessVerticalSpace = true;
                buttonGridData2.horizontalAlignment = 0x1000000;
                this.stopLoggingButton.setLayoutData((Object)buttonGridData2);
                this.stopLoggingButton.setEnabled(false);
                this.stopLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "stopLoggingButton.widgetSelected, event=" + evt);
                        }
                        try {
                            UniLogDialog.this.serialPort.stopLogging();
                            UniLogDialog.this.startLoggingButton.setEnabled(true);
                            UniLogDialog.this.stopLoggingButton.setEnabled(false);
                            UniLogDialog.this.setClosePossible(true);
                            if (!UniLogDialog.this.stopLiveGatherButton.getEnabled()) {
                                UniLogDialog.this.readDataButton.setEnabled(true);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            UniLogDialog.this.application.openMessageDialog(UniLogDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        }
                    }
                });
                this.loggingGroup.layout();
                this.stopLiveGatherButton = new Button((Composite)this.liveDataCaptureGroup, 0x1000008);
                this.stopLiveGatherButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                buttonGridData = new GridData(260, 35);
                buttonGridData.grabExcessHorizontalSpace = true;
                buttonGridData.horizontalAlignment = 0x1000000;
                this.stopLiveGatherButton.setLayoutData((Object)buttonGridData);
                this.stopLiveGatherButton.setText(Messages.getString((String)"GDE_MSGT1333"));
                this.stopLiveGatherButton.setEnabled(!this.isLiveGathererEnabled);
                this.stopLiveGatherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "stopLiveGatherButton.widgetSelected, event=" + evt);
                        }
                        if (UniLogDialog.this.liveThread != null) {
                            RecordSet activeRecordSet;
                            Channel activeChannle;
                            if (UniLogDialog.this.liveThread.isTimerRunning) {
                                UniLogDialog.this.liveThread.stopTimerThread();
                            }
                            UniLogDialog.this.serialPort.isInterruptedByUser = true;
                            UniLogDialog.this.liveThread.interrupt();
                            if (Channels.getInstance().getActiveChannel() != null && (activeChannle = Channels.getInstance().getActiveChannel()) != null && (activeRecordSet = activeChannle.getActiveRecordSet()) != null) {
                                UniLogDialog.this.liveThread.finalizeRecordSet(activeRecordSet.getName());
                            }
                        }
                        UniLogDialog.this.isLiveGathererEnabled = true;
                        UniLogDialog.this.setButtonStateLiveGatherer(true);
                        UniLogDialog.this.setClosePossible(true);
                        if (!UniLogDialog.this.stopLoggingButton.getEnabled()) {
                            UniLogDialog.this.readDataButton.setEnabled(true);
                        }
                    }
                });
                this.liveDataCaptureGroup.layout();
                this.clearDataBufferGroup = new Group(this.dataMainComposite, 0);
                this.clearDataBufferGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.clearDataBufferGroup.setBounds(324, 216, 284, 104);
                this.clearDataBufferGroup.setText(Messages.getString((String)"GDE_MSGT1334"));
                this.clearDataBufferGroup.setToolTipText(Messages.getString((String)"GDE_MSGT1385"));
                this.clearDataBufferGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.clearDataBufferGroup.setLayout((Layout)new GridLayout(1, true));
                this.memoryDeleteInfo = new Text((Composite)this.clearDataBufferGroup, 16777282);
                this.memoryDeleteInfo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                GridData infoGridData = new GridData(260, 30);
                infoGridData.grabExcessHorizontalSpace = true;
                infoGridData.horizontalAlignment = 0x1000000;
                this.memoryDeleteInfo.setLayoutData((Object)infoGridData);
                this.memoryDeleteInfo.setText(Messages.getString((String)"GDE_MSGI1301"));
                this.memoryDeleteInfo.setBackground(DataExplorer.getInstance().COLOR_LIGHT_GREY);
                this.clearMemoryButton = new Button((Composite)this.clearDataBufferGroup, 0x1000008);
                this.clearMemoryButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.clearMemoryButton.setText(Messages.getString((String)"GDE_MSGT1335"));
                this.clearMemoryButton.setToolTipText(Messages.getString((String)"GDE_MSGT1385"));
                buttonGridData = new GridData(260, 35);
                buttonGridData.grabExcessHorizontalSpace = true;
                buttonGridData.horizontalAlignment = 0x1000000;
                this.clearMemoryButton.setLayoutData((Object)buttonGridData);
                this.clearMemoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "clearMemoryButton.widgetSelected, event=" + evt);
                        }
                        try {
                            UniLogDialog.this.clearMemoryButton.setEnabled(false);
                            UniLogDialog.this.serialPort.clearMemory();
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            UniLogDialog.this.application.openMessageDialog(UniLogDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE1300", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                            e.printStackTrace();
                        }
                        UniLogDialog.this.clearMemoryButton.setEnabled(true);
                    }
                });
                this.clearDataBufferGroup.layout();
                this.deviceConfigTabFolder.setBounds(0, 0, GDE.IS_LINUX ? 650 : 635, 360);
                this.deviceConfigTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        int channelNumber;
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "configTabFolder.widgetSelected, event=" + evt);
                        }
                        if ((channelNumber = UniLogDialog.this.deviceConfigTabFolder.getSelectionIndex()) >= 1 && channelNumber <= 4) {
                            String configKey = channelNumber + " : " + ((CTabItem)evt.item).getText();
                            Channels channels = Channels.getInstance();
                            Channel activeChannel = channels.getActiveChannel();
                            if (activeChannel != null) {
                                int answer;
                                RecordSet activeRecordSet;
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "activeChannel = " + activeChannel.getName() + " configKey = " + configKey);
                                }
                                if ((activeRecordSet = activeChannel.getActiveRecordSet()) != null && !activeChannel.getName().trim().equals(configKey) && (answer = UniLogDialog.this.application.openYesNoMessageDialog(UniLogDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGI1302"))) == 64) {
                                    String recordSetKey = activeRecordSet.getName();
                                    if (log.isLoggable(Level.FINE)) {
                                        log.log(Level.FINE, "move record set " + recordSetKey + " to channel/configuration " + channelNumber + " : " + configKey);
                                    }
                                    ((Channel)channels.get((Object)channelNumber)).put((Object)recordSetKey, (Object)activeRecordSet.clone(channelNumber));
                                    activeChannel.remove(recordSetKey);
                                    channels.switchChannel(channelNumber, recordSetKey);
                                    switch (channelNumber) {
                                        case 1: {
                                            UniLogDialog.this.configTab1.initEditable();
                                            UniLogDialog.this.configTab1.checkUpdateAnalog();
                                            break;
                                        }
                                        case 2: {
                                            UniLogDialog.this.configTab2.initEditable();
                                            UniLogDialog.this.configTab2.checkUpdateAnalog();
                                            break;
                                        }
                                        case 3: {
                                            UniLogDialog.this.configTab3.initEditable();
                                            UniLogDialog.this.configTab3.checkUpdateAnalog();
                                            break;
                                        }
                                        case 4: {
                                            UniLogDialog.this.configTab4.initEditable();
                                            UniLogDialog.this.configTab4.checkUpdateAnalog();
                                        }
                                    }
                                    RecordSet newActiveRecordSet = ((Channel)channels.get((Object)channelNumber)).getActiveRecordSet();
                                    if (newActiveRecordSet != null) {
                                        UniLogDialog.this.device.updateVisibilityStatus(newActiveRecordSet, false);
                                        UniLogDialog.this.device.makeInActiveDisplayable(newActiveRecordSet);
                                        UniLogDialog.this.application.updateCurveSelectorTable();
                                    }
                                }
                            }
                        }
                    }
                });
                this.telemetryTabItem = new CTabItem(this.deviceConfigTabFolder, 0);
                this.telemetryTabItem.setText(Messages.getString((String)"GDE_MSGT1390"));
                this.telemetryTab = new UniLogTelemetryTab(this.deviceConfigTabFolder, this.device);
                this.telemetryTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.telemetryTabItem.setControl((Control)this.telemetryTab);
                int index = Channels.getInstance().getActiveChannelNumber();
                this.deviceConfigTabFolder.setSelection(index < 1 || index > this.deviceConfigTabFolder.getChildren().length - 2 ? 1 : index);
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 320, 100));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void updateConfigurationValues(byte[] readBuffer) {
        this.memoryUsed = ((readBuffer[6] & 0xFF) << 8) + (readBuffer[7] & 0xFF);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "memoryUsed = " + this.memoryUsed);
        }
        this.unilogVersion = String.format(Locale.ENGLISH, "v%.2f", Double.valueOf(readBuffer[8] & 0xFF) / 100.0);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "unilogVersion = " + this.unilogVersion);
        }
        int memoryDeleted = readBuffer[9] & 0xFF;
        int tmpMemoryUsed = 0;
        tmpMemoryUsed = memoryDeleted > 0 ? 0 : this.memoryUsed;
        this.memoryUsedPercent = String.format("%.2f", (double)tmpMemoryUsed * 100.0 / 25920.0);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "memoryUsedPercent = " + this.memoryUsedPercent + " (" + tmpMemoryUsed + "/" + 25920 + ")");
        }
        this.timeIntervalPosition = readBuffer[10] & 0xFF;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "timeIntervalPosition = " + this.timeIntervalPosition);
        }
        this.updateTimeStep_ms(this.timeIntervalPosition);
        this.isMotorPole = false;
        this.isPropBlade = false;
        this.countMotorPole = 0;
        this.countPropBlade = 0;
        if ((readBuffer[11] & 0x80) == 0) {
            this.isPropBlade = true;
        } else {
            this.isMotorPole = true;
        }
        this.countPropBlade = readBuffer[11] & 0x7F;
        this.countMotorPole = (readBuffer[11] & 0x7F) * 2;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "isPropBlade = " + this.isPropBlade + " countPropBlade = " + this.countPropBlade);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "isMotorPole = " + this.isMotorPole + " countMotorPole = " + this.countMotorPole);
        }
        this.isAutoStartCurrent = false;
        this.currentAutoStart = 0;
        if ((readBuffer[12] & 0x80) != 0) {
            this.isAutoStartCurrent = true;
        }
        this.currentAutoStart = readBuffer[12] & 0x7F;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "isAutoStartCurrent = " + this.isAutoStartCurrent + " currentAutoStart = " + this.currentAutoStart);
        }
        this.isAutStartRx = false;
        this.isRxOn = false;
        this.rxAutoStartValue = 0;
        if ((readBuffer[13] & 0x80) != 0) {
            this.isAutStartRx = true;
        }
        this.rxAutoStartValue = readBuffer[13] & 0x7F;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "isAutStartRx = " + this.isAutStartRx + " isRxOn = " + this.isRxOn + " rxAutoStartValue = " + this.rxAutoStartValue);
        }
        this.isImpulseAutoStartTime = false;
        this.impulseAutoStartTime_sec = 0;
        if ((readBuffer[14] & 0x80) != 0) {
            this.isImpulseAutoStartTime = true;
        }
        this.impulseAutoStartTime_sec = readBuffer[14] & 0x7F;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "isAutoStartTime = " + this.isImpulseAutoStartTime + " timeAutoStart_sec = " + this.impulseAutoStartTime_sec);
        }
        this.currentSensorPosition = readBuffer[15] & 0xFF;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "currentSensor = " + this.currentSensorPosition);
        }
        this.serialNumber = "" + (((readBuffer[16] & 0xFF) << 8) + (readBuffer[17] & 0xFF));
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "serialNumber = " + this.serialNumber);
        }
        int n = this.modusA1Position = (readBuffer[18] & 0xFF) <= 3 ? readBuffer[18] & 0xFF : 0;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "modusA1 = " + this.modusA1Position);
        }
        this.modusA2Position = readBuffer[4] & 0xFF;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "modusA2 = " + this.modusA2Position);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "select A2 combo = " + (this.modusA2Position >= 1 ? this.modusA2Position - 1 : this.modusA2Position));
        }
        this.modusA3Position = readBuffer[5] & 0xFF;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "modusA3 = " + this.modusA3Position);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "select A3 combo = " + (this.modusA3Position >= 1 ? this.modusA3Position - 1 : this.modusA3Position));
        }
        boolean bl = this.isLimiterActive = (readBuffer[19] & 0x80) > 1;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "limiter active = " + this.isLimiterActive);
        }
        this.limiterValue = (readBuffer[19] & 0x7F) << 8 | readBuffer[20] & 0xFF;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "limiterValue = " + this.limiterValue);
        }
        this.gearRatio = (double)(readBuffer[21] & 0xFF) / 10.0;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, String.format("gearRatio = %.1f", this.gearRatio));
        }
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    TaskBar taskBar;
                    UniLogDialog.this.firmwareVersionLabel.setText(UniLogDialog.this.unilogVersion);
                    UniLogDialog.this.memUsagePercent.setText(UniLogDialog.this.memoryUsedPercent);
                    UniLogDialog.this.timeIntervalCombo.select(UniLogDialog.this.timeIntervalPosition);
                    UniLogDialog.this.numberPolsButton.setSelection(UniLogDialog.this.isMotorPole);
                    UniLogDialog.this.numberPropButton.setSelection(UniLogDialog.this.isPropBlade);
                    UniLogDialog.this.motorPoleCombo.select(UniLogDialog.this.countMotorPole / 2 - 1);
                    UniLogDialog.this.numberProbCombo.select(UniLogDialog.this.countPropBlade - 1);
                    if (UniLogDialog.this.isMotorPole) {
                        UniLogDialog.this.numberProbCombo.setEnabled(false);
                        UniLogDialog.this.motorPoleCombo.setEnabled(true);
                    } else {
                        UniLogDialog.this.numberProbCombo.setEnabled(true);
                        UniLogDialog.this.motorPoleCombo.setEnabled(false);
                    }
                    UniLogDialog.this.currentTriggerButton.setSelection(UniLogDialog.this.isAutoStartCurrent);
                    UniLogDialog.this.currentTriggerCombo.select(UniLogDialog.this.currentAutoStart - 1);
                    UniLogDialog.this.impulseTriggerCombo.select(UniLogDialog.this.rxAutoStartValue - 11);
                    UniLogDialog.this.impulseTriggerButton.setSelection(UniLogDialog.this.isAutStartRx);
                    UniLogDialog.this.timeTriggerButton.setSelection(UniLogDialog.this.isImpulseAutoStartTime);
                    UniLogDialog.this.timeTriggerCombo.select(UniLogDialog.this.impulseAutoStartTime_sec + 1);
                    UniLogDialog.this.timeTriggerCombo.setText(String.format("%4s", UniLogDialog.this.impulseAutoStartTime_sec));
                    UniLogDialog.this.sensorCurrentCombo.select(UniLogDialog.this.currentSensorPosition);
                    UniLogDialog.this.snLabel.setText(UniLogDialog.this.serialNumber);
                    UniLogDialog.this.a1ModusCombo.select(UniLogDialog.this.modusA1Position);
                    UniLogDialog.this.a2ModusCombo.select(UniLogDialog.this.modusA2Position >= 1 ? UniLogDialog.this.modusA2Position - 1 : UniLogDialog.this.modusA2Position);
                    UniLogDialog.this.a3ModusCombo.select(UniLogDialog.this.modusA3Position >= 1 ? UniLogDialog.this.modusA3Position - 1 : UniLogDialog.this.modusA3Position);
                    UniLogDialog.this.limiterButton.setSelection(UniLogDialog.this.isLimiterActive);
                    if (UniLogDialog.this.limiterValue < 1000) {
                        UniLogDialog.this.limiterEnergyCombo.select(UniLogDialog.this.limiterValue / 250);
                    } else {
                        UniLogDialog.this.limiterEnergyCombo.select(UniLogDialog.this.limiterValue / 500 + 1);
                    }
                    UniLogDialog.this.limiterEnergyCombo.setText("" + UniLogDialog.this.limiterValue);
                    UniLogDialog.this.gearFactorCombo.setText(String.format(" %.1f  :  1", UniLogDialog.this.gearRatio));
                    if (UniLogDialog.this.configTab1 != null) {
                        UniLogDialog.this.configTab1.setA1ModusAvailable(true);
                    }
                    if (UniLogDialog.this.configTab2 != null) {
                        UniLogDialog.this.configTab2.setA1ModusAvailable(true);
                    }
                    if (UniLogDialog.this.configTab3 != null) {
                        UniLogDialog.this.configTab3.setA1ModusAvailable(true);
                    }
                    if (UniLogDialog.this.configTab4 != null) {
                        UniLogDialog.this.configTab4.setA1ModusAvailable(true);
                    }
                    if ((taskBar = UniLogDialog.this.dialogShell.getDisplay().getSystemTaskBar()) == null) {
                        UniLogDialog.this.taskBarItem = null;
                    } else {
                        TaskItem taskItem = UniLogDialog.this.taskBarItem = taskBar.getItem(UniLogDialog.this.dialogShell) != null ? taskBar.getItem(UniLogDialog.this.dialogShell) : taskBar.getItem(null);
                        if (!UniLogDialog.this.readDataButton.getEnabled() && UniLogDialog.this.taskBarItem != null) {
                            UniLogDialog.this.taskBarItem.setProgressState(GDE.IS_MAC ? 1 : 0);
                        }
                    }
                }
            });
        }
    }

    public byte[] buildUpdateBuffer() {
        int checkSum = 0;
        byte[] updateBuffer = new byte[15];
        updateBuffer[0] = -64;
        updateBuffer[1] = 3;
        checkSum += 0xFF & updateBuffer[1];
        updateBuffer[2] = 2;
        checkSum += 0xFF & updateBuffer[2];
        updateBuffer[3] = (byte)this.timeIntervalCombo.getSelectionIndex();
        checkSum += 0xFF & updateBuffer[3];
        updateBuffer[4] = this.numberPolsButton.getSelection() ? (byte)(this.motorPoleCombo.getSelectionIndex() + 1 | 0x80) : (byte)(this.numberProbCombo.getSelectionIndex() + 1);
        checkSum += 0xFF & updateBuffer[4];
        updateBuffer[5] = this.currentTriggerButton.getSelection() ? (byte)(this.currentTriggerCombo.getSelectionIndex() + 1 | 0x80) : (byte)(this.currentTriggerCombo.getSelectionIndex() + 1);
        checkSum += 0xFF & updateBuffer[5];
        updateBuffer[6] = this.impulseTriggerButton.getSelection() ? (this.impulseTriggerCombo.getSelectionIndex() + 1 == RX_AUTO_START_MS.length ? -128 : (byte)((this.impulseTriggerCombo.getSelectionIndex() | 0x80) + 11)) : (this.impulseTriggerCombo.getSelectionIndex() + 1 == RX_AUTO_START_MS.length ? 0 : (int)(this.impulseTriggerCombo.getSelectionIndex() + 11));
        checkSum += 0xFF & updateBuffer[6];
        updateBuffer[7] = this.timeTriggerButton.getSelection() ? (byte)(Byte.parseByte(this.timeTriggerCombo.getText().trim()) | 0x80) : Byte.parseByte(this.timeTriggerCombo.getText().trim());
        checkSum += 0xFF & updateBuffer[7];
        updateBuffer[8] = (byte)this.sensorCurrentCombo.getSelectionIndex();
        checkSum += 0xFF & updateBuffer[8];
        updateBuffer[9] = (byte)this.a1ModusCombo.getSelectionIndex();
        checkSum += 0xFF & updateBuffer[9];
        updateBuffer[10] = (byte)((Integer.parseInt(this.limiterEnergyCombo.getText().trim()) & 0xFF00) >> 8);
        if (this.limiterButton.getSelection()) {
            updateBuffer[10] = (byte)(updateBuffer[10] | 0x80);
        }
        checkSum += 0xFF & updateBuffer[10];
        updateBuffer[11] = (byte)(Integer.parseInt(this.limiterEnergyCombo.getText().trim()) & 0xFF);
        checkSum += 0xFF & updateBuffer[11];
        double tempGearRatio = Double.valueOf(this.gearFactorCombo.getText().split(":")[0].trim().replace(',', '.')) * 10.0;
        updateBuffer[12] = (byte)tempGearRatio;
        checkSum += 0xFF & updateBuffer[12];
        int tmpA2Modus = this.a2ModusCombo.getSelectionIndex();
        tmpA2Modus = tmpA2Modus >= 1 ? tmpA2Modus + 1 : tmpA2Modus;
        int tmpA3Modus = this.a3ModusCombo.getSelectionIndex();
        tmpA3Modus = tmpA3Modus >= 1 ? tmpA3Modus + 1 : tmpA3Modus;
        updateBuffer[13] = (byte)((tmpA3Modus & 0xF) << 4 | tmpA2Modus & 0xF);
        updateBuffer[14] = (byte)((checkSum += 0xFF & updateBuffer[13]) % 256);
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("updateBuffer = [");
            for (int i = 0; i < updateBuffer.length; ++i) {
                if (i == updateBuffer.length - 1) {
                    sb.append(String.format("%02X", updateBuffer[i]));
                    continue;
                }
                sb.append(String.format("%02X ", updateBuffer[i]));
            }
            sb.append("]");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, sb.toString());
            }
        }
        return updateBuffer;
    }

    public void setStatusText(String newStatus) {
        this.statusText = newStatus;
        this.memUsagePercent.setText(this.statusText);
    }

    public ProgressBar getReadDataProgressBar() {
        return this.readDataProgressBar;
    }

    public void setReadDataProgressBar(final int value) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                int tmpValue = value < 0 ? 0 : value;
                tmpValue = value > 100 ? 100 : value;
                UniLogDialog.this.readDataProgressBar.setSelection(tmpValue);
                if (UniLogDialog.this.taskBarItem != null) {
                    UniLogDialog.this.taskBarItem.setProgress(tmpValue);
                }
            }
        });
    }

    double getGearRatio() {
        return Double.valueOf(this.gearFactorCombo.getText().split(":")[0].trim().replace(',', '.'));
    }

    public void updateDataGatherProgress(final int redTelegrams, int numberRecordSet, int numReadErrors, int numLess2Measurements, final int memoryUsedValue) {
        this.numberRedDataSetsText = "" + redTelegrams;
        this.numberActualDataSetsText = "" + numberRecordSet;
        this.numberReadErrorText = "" + numReadErrors;
        this.numberLess2Text = "" + numLess2Measurements;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                int progress = memoryUsedValue > 0 ? redTelegrams * 100 / memoryUsedValue : 100;
                int tmpValue = progress < 0 ? 0 : progress;
                tmpValue = progress > 100 ? 100 : progress;
                UniLogDialog.this.readDataProgressBar.setSelection(tmpValue);
                if (UniLogDialog.this.taskBarItem != null) {
                    UniLogDialog.this.taskBarItem.setProgress(tmpValue);
                }
                UniLogDialog.this.redDataSetLabel.setText(UniLogDialog.this.numberRedDataSetsText);
                UniLogDialog.this.actualDataSetNumber.setText(UniLogDialog.this.numberActualDataSetsText);
                UniLogDialog.this.numberReadErrorLabel.setText(UniLogDialog.this.numberReadErrorText);
                UniLogDialog.this.numberLess2Label.setText(UniLogDialog.this.numberLess2Text);
            }
        });
    }

    public void resetDataSetsLabel() {
        if (Thread.currentThread().getId() == this.application.getThreadId()) {
            this.numberRedDataSetsText = "0";
            this.numberActualDataSetsText = "0";
            this.numberReadErrorText = "0";
            this.numberLess2Text = "0";
            this.redDataSetLabel.setText(this.numberRedDataSetsText);
            this.actualDataSetNumber.setText(this.numberActualDataSetsText);
            this.numberReadErrorLabel.setText(this.numberReadErrorText);
            this.numberLess2Label.setText(this.numberLess2Text);
            this.readDataProgressBar.setSelection(0);
            if (this.taskBarItem != null) {
                this.taskBarItem.setProgress(0);
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    UniLogDialog.this.numberRedDataSetsText = "0";
                    UniLogDialog.this.numberActualDataSetsText = "0";
                    UniLogDialog.this.numberReadErrorText = "0";
                    UniLogDialog.this.redDataSetLabel.setText(UniLogDialog.this.numberRedDataSetsText);
                    UniLogDialog.this.actualDataSetNumber.setText(UniLogDialog.this.numberActualDataSetsText);
                    UniLogDialog.this.numberReadErrorLabel.setText(UniLogDialog.this.numberReadErrorText);
                    UniLogDialog.this.numberLess2Label.setText(UniLogDialog.this.numberLess2Text);
                    UniLogDialog.this.readDataProgressBar.setSelection(0);
                    if (UniLogDialog.this.taskBarItem != null) {
                        UniLogDialog.this.taskBarItem.setProgress(0);
                    }
                }
            });
        }
    }

    public void resetButtons() {
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            if (Thread.currentThread().getId() == this.application.getThreadId()) {
                this.setButtonStateLiveGatherer(true);
                this.startLoggingButton.setEnabled(true);
                this.stopLoggingButton.setEnabled(false);
                this.closeButton.setEnabled(true);
                this.setClosePossible(true);
                if (this.taskBarItem != null) {
                    this.taskBarItem.setProgressState(-1);
                }
            } else {
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UniLogDialog.this.setButtonStateLiveGatherer(true);
                        UniLogDialog.this.readAdjustmentButton.setEnabled(true);
                        UniLogDialog.this.startLoggingButton.setEnabled(true);
                        UniLogDialog.this.stopLoggingButton.setEnabled(false);
                        UniLogDialog.this.closeButton.setEnabled(true);
                        UniLogDialog.this.setClosePossible(true);
                        if (UniLogDialog.this.taskBarItem != null) {
                            UniLogDialog.this.taskBarItem.setProgressState(-1);
                        }
                    }
                });
            }
        }
    }

    public void enableStoreAdjustmentsButton(boolean enabled) {
        this.storeAdjustmentsButton.setEnabled(enabled);
    }

    public int[] getIndexAnalogModus() {
        return new int[]{this.modusA1Position, this.modusA2Position, this.modusA3Position};
    }

    void updateTimeStep_ms(int timeIntervalIndex) {
        switch (timeIntervalIndex) {
            case 0: {
                this.device.setTimeStep_ms(62.5);
                break;
            }
            case 1: {
                this.device.setTimeStep_ms(125.0);
                break;
            }
            default: {
                this.device.setTimeStep_ms(250.0);
                break;
            }
            case 3: {
                this.device.setTimeStep_ms(500.0);
                break;
            }
            case 4: {
                this.device.setTimeStep_ms(1000.0);
                break;
            }
            case 5: {
                this.device.setTimeStep_ms(2000.0);
                break;
            }
            case 6: {
                this.device.setTimeStep_ms(5000.0);
                break;
            }
            case 7: {
                this.device.setTimeStep_ms(10000.0);
                break;
            }
            case 8: {
                this.device.setTimeStep_ms(30000.0);
                break;
            }
            case 9: {
                this.device.setTimeStep_ms(60000.0);
                break;
            }
            case 10: {
                this.device.setTimeStep_ms(120000.0);
                break;
            }
            case 11: {
                this.device.setTimeStep_ms(300000.0);
            }
        }
        this.device.storeDeviceProperties();
    }

    public void updateActualConfigTabItemAnalogModi(int configTabIndex) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "updating configTab" + configTabIndex);
        }
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            switch (configTabIndex) {
                case 1: {
                    this.configTab1.checkUpdateAnalog();
                    break;
                }
                case 2: {
                    this.configTab2.checkUpdateAnalog();
                    break;
                }
                case 3: {
                    this.configTab3.checkUpdateAnalog();
                    break;
                }
                case 4: {
                    this.configTab4.checkUpdateAnalog();
                }
            }
        }
    }

    void setButtonStateLiveGatherer(boolean liveGathererEnabled) {
        this.isLiveGathererEnabled = liveGathererEnabled;
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            this.readAdjustmentButton.setEnabled(liveGathererEnabled);
            this.storeAdjustmentsButton.setEnabled(false);
            this.editConfigButton.setEnabled(false);
            this.readDataButton.setEnabled(liveGathererEnabled);
            this.stopDataButton.setEnabled(false);
            this.startLiveGatherButton.setEnabled(liveGathererEnabled);
            this.stopLiveGatherButton.setEnabled(!liveGathererEnabled);
            this.useConfigCombo.setEnabled(liveGathererEnabled);
            this.clearMemoryButton.setEnabled(liveGathererEnabled);
            this.closeButton.setEnabled(liveGathererEnabled);
        }
    }
}

