/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String CFSTR_INETURLW = "UniformResourceLocatorW";
    static final int CFSTR_INETURLIDW = URLTransfer.registerType("UniformResourceLocatorW");
    static final String CFSTR_INETURL = "UniformResourceLocator";
    static final int CFSTR_INETURLID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String url = (String)object;
        if (transferData.type == CFSTR_INETURLIDW) {
            int charCount = url.length();
            char[] chars = new char[charCount + 1];
            url.getChars(0, charCount, chars, 0);
            int byteCount = chars.length * 2;
            long newPtr = OS.GlobalAlloc(64, byteCount);
            OS.MoveMemory(newPtr, chars, byteCount);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = newPtr;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        } else if (transferData.type == CFSTR_INETURLID) {
            int count = url.length();
            char[] chars = new char[count + 1];
            url.getChars(0, count, chars, 0);
            int codePage = OS.GetACP();
            int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
            if (cchMultiByte == 0) {
                transferData.stgmedium = new STGMEDIUM();
                transferData.result = -2147221402;
                return;
            }
            long lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
            OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
            transferData.stgmedium = new STGMEDIUM();
            transferData.stgmedium.tymed = 1;
            transferData.stgmedium.unionField = lpMultiByteStr;
            transferData.stgmedium.pUnkForRelease = 0L;
            transferData.result = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Object nativeToJava(TransferData transferData) {
        block21: {
            if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
                return null;
            }
            data = new IDataObject(transferData.pIDataObject);
            data.AddRef();
            stgmedium = new STGMEDIUM();
            formatetc = transferData.formatetc;
            stgmedium.tymed = 1;
            transferData.result = this.getData(data, formatetc, stgmedium);
            data.Release();
            if (transferData.result != 0) {
                return null;
            }
            hMem = stgmedium.unionField;
            if (transferData.type == URLTransfer.CFSTR_INETURLIDW) {
                size = OS.GlobalSize(hMem) / 2 * 2;
                if (size == 0) {
                    var8_8 = null;
                    return var8_8;
                }
                chars = new char[size / 2];
                ptr = OS.GlobalLock(hMem);
                if (ptr == 0L) {
                    var11_13 = null;
                    return var11_13;
                }
                try {
                    OS.MoveMemory(chars, ptr, size);
                    length = chars.length;
                    for (i = 0; i < chars.length; ++i) {
                        if (chars[i] != '\u0000') continue;
                        length = i;
                        break;
                    }
                    var12_18 = new String(chars, 0, length);
                    return var12_18;
                }
                finally {
                    OS.GlobalUnlock(hMem);
                }
            }
            if (transferData.type != URLTransfer.CFSTR_INETURLID) break block21;
            lpMultiByteStr = OS.GlobalLock(hMem);
            if (lpMultiByteStr != 0L) ** GOTO lbl-1000
            ptr = null;
            return ptr;
lbl-1000:
            // 1 sources

            {
                codePage = OS.GetACP();
                cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                if (cchWideChar != 0) ** break block22
                length = null;
                OS.GlobalUnlock(hMem);
            }
            return length;
            {
                lpWideCharStr = new char[cchWideChar - 1];
                OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                var12_19 = new String(lpWideCharStr);
                OS.GlobalUnlock(hMem);
            }
            return var12_19;
            {
                catch (Throwable var14_22) {
                    OS.GlobalUnlock(hMem);
                    throw var14_22;
                }
            }
            finally {
                OS.GlobalFree(hMem);
            }
        }
        return null;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLIDW, CFSTR_INETURLID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CFSTR_INETURLW, CFSTR_INETURL};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

