/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    String text;
    String message;
    TrayItem item;
    int x;
    int y;
    int timerId;
    long layoutText = 0L;
    long layoutMessage = 0L;
    long provider;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 8000;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
        parent.addToolTip(this);
    }

    static int checkStyle(int style) {
        int mask = 11;
        if ((style & mask) == 0) {
            return style;
        }
        return ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] polyline;
        int t;
        boolean multipleMonitors;
        GTK.gtk_widget_realize(this.handle);
        Point point = this.getLocation();
        GdkRectangle dest = new GdkRectangle();
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
            long display = GDK.gdk_display_get_default();
            multipleMonitors = GDK.gdk_display_get_n_monitors(display) > 1;
            long monitor = GDK.gdk_display_get_monitor_at_point(display, point.x, point.y);
            GDK.gdk_monitor_get_geometry(monitor, dest);
        } else {
            long screen = GDK.gdk_screen_get_default();
            multipleMonitors = GDK.gdk_screen_get_n_monitors(screen) > 1;
            int monitorNumber = GDK.gdk_screen_get_monitor_at_point(screen, point.x, point.y);
            GDK.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
        }
        point = this.getSize(dest.width / 4);
        int w = point.x;
        int h = point.y;
        point = this.getLocation();
        int x = point.x;
        int y = point.y;
        GTK.gtk_window_resize(this.handle, w, h + 20);
        Rectangle bounds = this.display.getBounds();
        int width = bounds != null && GTK.GTK4 ? bounds.width : GDK.gdk_screen_width();
        boolean bl = this.spikeAbove = dest.height >= y + h + 20;
        if (dest.width >= x + w || multipleMonitors && width >= x + w) {
            if (dest.height >= y + h + 20) {
                t = 20;
                polyline = new int[]{0, 5 + t, 1, 5 + t, 1, 3 + t, 3, 1 + t, 5, 1 + t, 5, t, 16, t, 16, 0, 35, t, w - 5, t, w - 5, 1 + t, w - 3, 1 + t, w - 1, 3 + t, w - 1, 5 + t, w, 5 + t, w, h - 5 + t, w - 1, h - 5 + t, w - 1, h - 3 + t, w - 2, h - 3 + t, w - 2, h - 2 + t, w - 3, h - 2 + t, w - 3, h - 1 + t, w - 5, h - 1 + t, w - 5, h + t, 5, h + t, 5, h - 1 + t, 3, h - 1 + t, 3, h - 2 + t, 2, h - 2 + t, 2, h - 3 + t, 1, h - 3 + t, 1, h - 5 + t, 0, h - 5 + t, 0, 5 + t};
                this.borderPolygon = new int[]{0, 5 + t, 1, 4 + t, 1, 3 + t, 3, 1 + t, 4, 1 + t, 5, t, 16, t, 16, 1, 35, t, w - 6, 0 + t, w - 5, 1 + t, w - 4, 1 + t, w - 2, 3 + t, w - 2, 4 + t, w - 1, 5 + t, w - 1, h - 6 + t, w - 2, h - 5 + t, w - 2, h - 4 + t, w - 4, h - 2 + t, w - 5, h - 2 + t, w - 6, h - 1 + t, 5, h - 1 + t, 4, h - 2 + t, 3, h - 2 + t, 1, h - 4 + t, 1, h - 5 + t, 0, h - 6 + t, 0, 5 + t};
                if ((this.parent.style & 0x8000000) != 0) {
                    x -= w - 36;
                    polyline[12] = w - 36;
                    polyline[14] = w - 16;
                    polyline[16] = w - 15;
                    this.borderPolygon[12] = w - 35;
                    this.borderPolygon[14] = this.borderPolygon[16] = w - 16;
                }
                GTK.gtk_window_move(this.handle, Math.max(0, x - 17), y);
            } else {
                polyline = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, w - 5, 0, w - 5, 1, w - 3, 1, w - 1, 3, w - 1, 5, w, 5, w, h - 5, w - 1, h - 5, w - 1, h - 3, w - 2, h - 3, w - 2, h - 2, w - 3, h - 2, w - 3, h - 1, w - 5, h - 1, w - 5, h, 35, h, 16, h + 20, 16, h, 5, h, 5, h - 1, 3, h - 1, 3, h - 2, 2, h - 2, 2, h - 3, 1, h - 3, 1, h - 5, 0, h - 5, 0, 5};
                this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, w - 6, 0, w - 5, 1, w - 4, 1, w - 2, 3, w - 2, 4, w - 1, 5, w - 1, h - 6, w - 2, h - 5, w - 2, h - 4, w - 4, h - 2, w - 5, h - 2, w - 6, h - 1, 35, h - 1, 17, h + 20 - 2, 17, h - 1, 5, h - 1, 4, h - 2, 3, h - 2, 1, h - 4, 1, h - 5, 0, h - 6, 0, 5};
                if ((this.parent.style & 0x8000000) != 0) {
                    x -= w - 36;
                    polyline[42] = polyline[44] = w - 16;
                    polyline[46] = w - 35;
                    this.borderPolygon[36] = this.borderPolygon[38] = w - 17;
                    this.borderPolygon[40] = w - 35;
                }
                GTK.gtk_window_move(this.handle, Math.max(0, x - 17), y - h - 20);
            }
        } else if (dest.height >= y + h + 20) {
            t = 20;
            polyline = new int[]{0, 5 + t, 1, 5 + t, 1, 3 + t, 3, 1 + t, 5, 1 + t, 5, t, w - 35, t, w - 16, 0, w - 16, t, w - 5, t, w - 5, 1 + t, w - 3, 1 + t, w - 1, 3 + t, w - 1, 5 + t, w, 5 + t, w, h - 5 + t, w - 1, h - 5 + t, w - 1, h - 3 + t, w - 2, h - 3 + t, w - 2, h - 2 + t, w - 3, h - 2 + t, w - 3, h - 1 + t, w - 5, h - 1 + t, w - 5, h + t, 5, h + t, 5, h - 1 + t, 3, h - 1 + t, 3, h - 2 + t, 2, h - 2 + t, 2, h - 3 + t, 1, h - 3 + t, 1, h - 5 + t, 0, h - 5 + t, 0, 5 + t};
            this.borderPolygon = new int[]{0, 5 + t, 1, 4 + t, 1, 3 + t, 3, 1 + t, 4, 1 + t, 5, t, w - 35, t, w - 17, 2, w - 17, t, w - 6, t, w - 5, 1 + t, w - 4, 1 + t, w - 2, 3 + t, w - 2, 4 + t, w - 1, 5 + t, w - 1, h - 6 + t, w - 2, h - 5 + t, w - 2, h - 4 + t, w - 4, h - 2 + t, w - 5, h - 2 + t, w - 6, h - 1 + t, 5, h - 1 + t, 4, h - 2 + t, 3, h - 2 + t, 1, h - 4 + t, 1, h - 5 + t, 0, h - 6 + t, 0, 5 + t};
            if ((this.parent.style & 0x8000000) != 0) {
                x += w - 35;
                polyline[14] = 16;
                polyline[12] = 16;
                polyline[16] = 35;
                this.borderPolygon[14] = 16;
                this.borderPolygon[12] = 16;
                this.borderPolygon[16] = 35;
            }
            GTK.gtk_window_move(this.handle, Math.max(dest.width - w, x - w + 17), y);
        } else {
            polyline = new int[]{0, 5, 1, 5, 1, 3, 3, 1, 5, 1, 5, 0, w - 5, 0, w - 5, 1, w - 3, 1, w - 1, 3, w - 1, 5, w, 5, w, h - 5, w - 1, h - 5, w - 1, h - 3, w - 2, h - 3, w - 2, h - 2, w - 3, h - 2, w - 3, h - 1, w - 5, h - 1, w - 5, h, w - 16, h, w - 16, h + 20, w - 35, h, 5, h, 5, h - 1, 3, h - 1, 3, h - 2, 2, h - 2, 2, h - 3, 1, h - 3, 1, h - 5, 0, h - 5, 0, 5};
            this.borderPolygon = new int[]{0, 5, 1, 4, 1, 3, 3, 1, 4, 1, 5, 0, w - 6, 0, w - 5, 1, w - 4, 1, w - 2, 3, w - 2, 4, w - 1, 5, w - 1, h - 6, w - 2, h - 5, w - 2, h - 4, w - 4, h - 2, w - 5, h - 2, w - 6, h - 1, w - 17, h - 1, w - 17, h + 20 - 2, w - 36, h - 1, 5, h - 1, 4, h - 2, 3, h - 2, 1, h - 4, 1, h - 5, 0, h - 6, 0, 5};
            if ((this.parent.style & 0x8000000) != 0) {
                x += w - 35;
                polyline[42] = 35;
                polyline[46] = 16;
                polyline[44] = 16;
                this.borderPolygon[36] = 35;
                this.borderPolygon[40] = 17;
                this.borderPolygon[38] = 17;
            }
            GTK.gtk_window_move(this.handle, Math.max(dest.width - w, x - w + 17), y - h - 20);
        }
        GTK.gtk_widget_realize(this.handle);
        Region region = new Region(this.display);
        region.add(DPIUtil.autoScaleDown(polyline));
        GTK.gtk_widget_shape_combine_region(this.handle, region.handle);
        region.dispose();
    }

    @Override
    void createHandle(int index) {
        if ((this.style & 0x1000) != 0) {
            this.state |= 8;
            this.handle = GTK.gtk_window_new(1);
            Color background = this.display.getSystemColor(29);
            long context = GTK.gtk_widget_get_style_context(this.handle);
            GdkRGBA bgRGBA = background.handle;
            String css = "window {background-color: " + this.display.gtk_rgba_to_css_string(bgRGBA) + ";}";
            this.gtk_css_provider_load_from_css(context, css);
            GTK.gtk_style_context_invalidate(context);
            GTK.gtk_window_set_type_hint(this.handle, 10);
        }
    }

    void gtk_css_provider_load_from_css(long context, String css) {
        if (this.provider == 0L) {
            this.provider = GTK.gtk_css_provider_new();
            GTK.gtk_style_context_add_provider(context, this.provider, 600);
            OS.g_object_unref(this.provider);
        }
        if (GTK.GTK4) {
            GTK.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1L);
        } else {
            GTK.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(css, true), -1L, null);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.text = "";
        this.message = "";
        this.y = -1;
        this.x = -1;
        this.autohide = true;
    }

    @Override
    void destroyWidget() {
        long topHandle = this.topHandle();
        if (this.parent != null) {
            this.parent.removeTooTip(this);
        }
        this.releaseHandle();
        if (topHandle != 0L && (this.state & 8) != 0) {
            if ((this.style & 0x1000) != 0) {
                GTK.gtk_widget_destroy(topHandle);
            } else {
                OS.g_object_unref(topHandle);
            }
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getLocation() {
        int x = this.x;
        int y = this.y;
        if (this.item != null) {
            long itemHandle = this.item.handle;
            GdkRectangle area = new GdkRectangle();
            GTK.gtk_status_icon_get_geometry(itemHandle, 0L, area, 0L);
            x = area.x + area.width / 2;
            y = area.y + area.height / 2;
        }
        if (x == -1 || y == -1) {
            int[] px = new int[1];
            int[] py = new int[1];
            if (!GTK.GTK4) {
                this.display.gdk_window_get_device_position(0L, px, py, null);
            }
            x = px[0];
            y = py[0];
        }
        return new Point(x, y);
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    Point getSize(int maxWidth) {
        int textWidth = 0;
        int messageWidth = 0;
        int[] w = new int[1];
        int[] h = new int[1];
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, -1);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            textWidth = w[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, -1);
            OS.pango_layout_get_pixel_size(this.layoutMessage, w, h);
            messageWidth = w[0];
        }
        int messageTrim = 28;
        boolean hasImage = this.layoutText != 0L && (this.style & 0xB) != 0;
        int textTrim = messageTrim + (hasImage ? 16 : 0);
        int width = Math.min(maxWidth, Math.max(textWidth + textTrim, messageWidth + messageTrim));
        int textHeight = 0;
        int messageHeight = 0;
        if (this.layoutText != 0L) {
            OS.pango_layout_set_width(this.layoutText, (maxWidth - textTrim) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            textHeight = h[0];
        }
        if (this.layoutMessage != 0L) {
            OS.pango_layout_set_width(this.layoutMessage, (maxWidth - messageTrim) * 1024);
            OS.pango_layout_get_pixel_size(this.layoutMessage, w, h);
            messageHeight = h[0];
        }
        int height = 20 + messageHeight;
        if (this.layoutText != 0L) {
            height += Math.max(16, textHeight) + 10;
        }
        return new Point(width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if ((this.style & 0x1000) != 0) {
            return GTK.gtk_widget_get_visible(this.handle);
        }
        return false;
    }

    @Override
    long gtk_event(long widget, long event) {
        if (!GTK.GTK4) {
            return 0L;
        }
        int eventType = GDK.gdk_event_get_event_type(event);
        switch (eventType) {
            case 5: {
                return this.gtk_button_press_event(widget, event);
            }
            case 6: {
                return this.gtk_button_release_event(widget, event);
            }
        }
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        this.sendSelectionEvent(13, null, true);
        this.setVisible(false);
        return 0L;
    }

    void drawTooltip(long cairo) {
        int count;
        int x = 10;
        int y = 10;
        if (cairo == 0L) {
            this.error(2);
        }
        if ((count = this.borderPolygon.length / 2) != 0) {
            Cairo.cairo_set_line_width(cairo, 1.0);
            Cairo.cairo_move_to(cairo, this.borderPolygon[0], this.borderPolygon[1]);
            int i = 1;
            int j = 2;
            while (i < count) {
                Cairo.cairo_line_to(cairo, (double)this.borderPolygon[j] + 0.5, (double)this.borderPolygon[j + 1] + 0.5);
                ++i;
                j += 2;
            }
            Cairo.cairo_close_path(cairo);
            Cairo.cairo_stroke(cairo);
        }
        if (this.spikeAbove) {
            y += 20;
        }
        if (this.layoutText != 0L) {
            byte[] buffer = null;
            int id = this.style & 0xB;
            switch (id) {
                case 1: {
                    buffer = Converter.wcsToMbcs("dialog-error", true);
                    break;
                }
                case 2: {
                    buffer = Converter.wcsToMbcs("dialog-information", true);
                    break;
                }
                case 8: {
                    buffer = Converter.wcsToMbcs("dialog-warning", true);
                }
            }
            if (buffer != null) {
                long iconTheme = GTK.GTK4 ? GTK.gtk_icon_theme_get_for_display(GDK.gdk_display_get_default()) : GTK.gtk_icon_theme_get_default();
                long pixbuf = GTK.gtk_icon_theme_load_icon(iconTheme, buffer, 1, 0, 0L);
                GDK.gdk_cairo_set_source_pixbuf(cairo, pixbuf, x, y);
                Cairo.cairo_paint(cairo);
                OS.g_object_unref(pixbuf);
                x += 16;
            }
            int[] w = new int[1];
            int[] h = new int[1];
            Color foreground = this.display.getSystemColor(28);
            GDK.gdk_cairo_set_source_rgba(cairo, foreground.handle);
            Cairo.cairo_move_to(cairo, x += 4, y);
            OS.pango_cairo_show_layout(cairo, this.layoutText);
            OS.pango_layout_get_pixel_size(this.layoutText, w, h);
            y += 10 + Math.max(16, h[0]);
        }
        if (this.layoutMessage != 0L) {
            x = 14;
            Color foreground = this.display.getSystemColor(28);
            GDK.gdk_cairo_set_source_rgba(cairo, foreground.handle);
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.layoutMessage);
        }
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        this.drawTooltip(cairo);
        return 0L;
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        Point point = this.getLocation();
        int x = point.x;
        int y = point.y;
        GTK.gtk_widget_realize(widget);
        GdkRectangle dest = new GdkRectangle();
        if (GTK.GTK_VERSION >= OS.VERSION(3, 22, 0)) {
            long display = GDK.gdk_display_get_default();
            long monitor = GDK.gdk_display_get_monitor_at_point(display, x, y);
            GDK.gdk_monitor_get_geometry(monitor, dest);
        } else {
            long screen = GDK.gdk_screen_get_default();
            int monitorNumber = GDK.gdk_screen_get_monitor_at_point(screen, point.x, point.y);
            GDK.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
        }
        GtkAllocation widgetAllocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(widget, widgetAllocation);
        int w = widgetAllocation.width;
        int h = widgetAllocation.height;
        if (dest.height < y + h) {
            y -= h;
        }
        if (dest.width < x + w) {
            x -= w;
        }
        GTK.gtk_window_move(widget, x, y);
        return 0L;
    }

    @Override
    void hookEvents() {
        if ((this.style & 0x1000) != 0) {
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[18], 0, this.display.getClosure(18), true);
            OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[19], 0, this.display.getClosure(19), true);
            GTK.gtk_widget_add_events(this.handle, 256);
            if (GTK.GTK4) {
                OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[15], 0, this.display.getClosure(15), false);
            } else {
                OS.g_signal_connect_closure(this.handle, OS.button_press_event, this.display.getClosure(2), false);
            }
        }
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.setVisible(false);
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        this.text = null;
        this.message = null;
        this.borderPolygon = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAutoHide(boolean autoHide) {
        this.checkWidget();
        this.autohide = autoHide;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setLocation(new Point(x, y));
    }

    void setLocationInPixels(int x, int y) {
        this.checkWidget();
        this.x = x;
        this.y = y;
        if ((this.style & 0x1000) != 0 && GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(location));
    }

    void setLocationInPixels(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocationInPixels(location.x, location.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutMessage != 0L) {
            OS.g_object_unref(this.layoutMessage);
        }
        this.layoutMessage = 0L;
        if (this.message.length() != 0) {
            byte[] buffer = Converter.wcsToMbcs(this.message, true);
            this.layoutMessage = GTK.gtk_widget_create_pango_layout(this.handle, buffer);
            OS.pango_layout_set_auto_dir(this.layoutMessage, false);
            OS.pango_layout_set_wrap(this.layoutMessage, 2);
        }
        if (GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if ((this.style & 0x1000) == 0) {
            return;
        }
        if (this.layoutText != 0L) {
            OS.g_object_unref(this.layoutText);
        }
        this.layoutText = 0L;
        if (this.text.length() != 0) {
            byte[] buffer = Converter.wcsToMbcs(this.text, true);
            this.layoutText = GTK.gtk_widget_create_pango_layout(this.handle, buffer);
            OS.pango_layout_set_auto_dir(this.layoutText, false);
            long boldAttr = OS.pango_attr_weight_new(700);
            PangoAttribute attribute = new PangoAttribute();
            OS.memmove(attribute, boldAttr, (long)PangoAttribute.sizeof);
            attribute.start_index = 0;
            attribute.end_index = buffer.length;
            OS.memmove(boldAttr, attribute, (long)PangoAttribute.sizeof);
            long attrList = OS.pango_attr_list_new();
            OS.pango_attr_list_insert(attrList, boldAttr);
            OS.pango_layout_set_attributes(this.layoutText, attrList);
            OS.pango_attr_list_unref(attrList);
            OS.pango_layout_set_wrap(this.layoutText, 2);
        }
        if (GTK.gtk_widget_get_visible(this.handle)) {
            this.configure();
        }
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.timerId != 0) {
            OS.g_source_remove(this.timerId);
        }
        this.timerId = 0;
        if (visible) {
            if ((this.style & 0x1000) != 0) {
                this.configure();
                GTK.gtk_widget_show(this.handle);
            } else {
                long vboxHandle = this.parent.vboxHandle;
                StringBuilder string = new StringBuilder(this.text);
                if (this.text.length() > 0) {
                    string.append("\n\n");
                }
                string.append(this.message);
                byte[] buffer = Converter.wcsToMbcs(string.toString(), true);
                GTK.gtk_widget_set_tooltip_text(vboxHandle, buffer);
            }
            if (this.autohide) {
                this.timerId = OS.g_timeout_add(8000, this.display.windowTimerProc, this.handle);
            }
        } else if ((this.style & 0x1000) != 0) {
            GTK.gtk_widget_hide(this.handle);
        } else {
            long vboxHandle = this.parent.vboxHandle;
            byte[] buffer = Converter.wcsToMbcs("", true);
            GTK.gtk_widget_set_tooltip_text(vboxHandle, buffer);
        }
    }

    @Override
    long timerProc(long widget) {
        if ((this.style & 0x1000) != 0) {
            GTK.gtk_widget_hide(this.handle);
        }
        return 0L;
    }
}

