/*
 * Decompiled with CFR 0.152.
 */
package gde;

import com.sun.istack.Nullable;
import gde.Analyzer;
import gde.GDE;
import gde.config.ExportService;
import gde.config.Settings;
import gde.histo.cache.HistoVault;
import gde.histo.cache.VaultProxy;
import gde.log.Level;
import gde.log.Logger;
import gde.messages.Messages;
import gde.utils.FileUtils;
import gde.utils.OperatingSystemHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;

public abstract class DataAccess
implements Cloneable {
    protected static DataAccess dataAccess;

    public static DataAccess getInstance() {
        if (dataAccess == null) {
            dataAccess = !Analyzer.isWithBuilders() ? new LocalAccess() : null;
        }
        return dataAccess;
    }

    public abstract OutputStream getGraphicsTemplateOutputStream(Path var1) throws FileNotFoundException;

    public abstract InputStream getGraphicsTemplateInputStream(Path var1) throws FileNotFoundException;

    public abstract boolean existsGraphicsTemplate(Path var1);

    public abstract long getGraphicsTemplateLastModified(Path var1);

    public abstract Writer getSettingsWriter();

    public abstract Reader getSettingsReader();

    public abstract boolean ensureInclusionDirectory();

    public abstract OutputStream getInclusionsOutputStream(String var1) throws FileNotFoundException;

    public abstract InputStream getInclusionsInputStream(String var1) throws FileNotFoundException;

    public abstract boolean existsInclusionFile(String var1);

    public abstract void deleteInclusionFile(String var1);

    public abstract boolean ensureExclusionDirectory();

    public abstract OutputStream getExclusionsOutputStream(String var1) throws FileNotFoundException;

    public abstract InputStream getExclusionsInputStream(String var1) throws FileNotFoundException;

    public abstract boolean existsExclusionFile(String var1);

    public abstract void deleteExclusionFile(String var1);

    public abstract String[] getDeviceFolderList();

    public abstract boolean existsDeviceXml(Path var1);

    public abstract InputStream getDeviceXsdInputStream() throws FileNotFoundException;

    public abstract InputStream getDeviceXmlInputStream(Path var1) throws FileNotFoundException;

    public abstract InputStream getDeviceXmlInputStream(String var1) throws FileNotFoundException;

    public abstract OutputStream getDeviceXmlOutputStream(Path var1) throws FileNotFoundException;

    public abstract InputStream getGeoCodeInputStream(String var1) throws FileNotFoundException;

    public abstract boolean existsGeoCodeFile(String var1);

    public abstract void deleteGeoCodeFile(String var1);

    public abstract List<String> getGeoCodeFolderList() throws FileNotFoundException;

    public abstract boolean existsCacheDirectory(String var1);

    public abstract boolean ensureCacheDirectory(String var1);

    public abstract boolean existsCacheVault(String var1, String var2);

    public abstract long getCacheSize();

    public abstract InputStream getCacheXsdInputStream() throws FileNotFoundException;

    public abstract ZipInputStream getCacheZipInputStream(String var1) throws ZipException, IOException;

    public abstract FileSystem getCacheZipFileSystem(String var1) throws IOException;

    public abstract OutputStream getCacheZipOutputStream(FileSystem var1, String var2) throws IOException;

    public abstract OutputStream getCacheOutputStream(String var1, String var2) throws IOException;

    public abstract InputStream getCacheInputStream(String var1, String var2) throws IOException;

    public abstract String[] getCacheFolderList(String var1, int var2);

    public abstract String[] getCacheZipFolderList(String var1, int var2);

    @Nullable
    public abstract HistoVault getCacheVault(String var1, String var2, int var3, boolean var4);

    @Nullable
    public abstract HistoVault getCacheZipVault(String var1, String var2, int var3, boolean var4);

    public abstract InputStream getMappingInputStream(String var1) throws FileNotFoundException;

    public abstract void checkMappingFileAndCreate(Class<?> var1, String var2);

    public abstract long getSourceLastModified(Path var1);

    public abstract long getSourceLength(Path var1);

    public abstract InputStream getSourceInputStream(Path var1);

    public abstract boolean existsSourceFolder(Path var1);

    public abstract boolean existsSourceFile(Path var1);

    public abstract Stream<String> getSourceFolderList(Path var1);

    public abstract Stream<Path> getSourceFolders(Path var1) throws IOException;

    public abstract Stream<Path> getSourceFolders(Path var1, Stream<String> var2) throws IOException;

    public abstract Path getActualSourceFile(Path var1);

    public abstract FileOutputStream getFleetOutputStream(Path var1);

    public abstract FileInputStream getFleetInputStream(Path var1);

    public abstract boolean deleteFleetObjects();

    public abstract Set<String> getFleetFileNames(Function<String, Boolean> var1);

    public abstract DataAccess clone();

    public abstract void extractDeviceProperties(Path var1, String var2) throws IOException;

    public abstract void extractDeviceDefaultTemplates(Path var1, String var2) throws IOException;

    public abstract void verifyRoaming();

    public abstract void verifyLogging();

    public abstract boolean verifyAndBackupCache();

    public abstract boolean verifyAndBackupDevices();

    public abstract boolean verifyAndBackupTemplates();

    public abstract void checkGraphicsTemplates(Collection<ExportService> var1, Predicate<String> var2);

    public abstract void checkDeviceProperties(List<ExportService> var1, Predicate<String> var2);

    public abstract void checkMeasurementDisplayProperties(boolean var1, String var2);

    public abstract void deleteDeviceHistoTemplates(String var1) throws IOException;

    public abstract List<Path> getDeviceXmlSubPaths(int var1) throws FileNotFoundException;

    public abstract String[] getDevicePropertyFileNames(Path var1);

    public abstract boolean existsDeviceMigrationFolder(int var1);

    public abstract InputStream getDeviceXsdMigrationStream(int var1) throws FileNotFoundException;

    public static final class LocalAccess
    extends DataAccess {
        private static final String $CLASS_NAME = LocalAccess.class.getName();
        private static final Logger log = Logger.getLogger($CLASS_NAME);

        private LocalAccess() {
        }

        private LocalAccess(LocalAccess that) {
        }

        @Override
        @Nullable
        public Reader getSettingsReader() {
            BufferedReader reader = null;
            try {
                File file = new File(GDE.SETTINGS_FILE_PATH);
                if (!file.exists() && !file.createNewFile()) {
                    log.log(Level.WARNING, "failed creating ", file);
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            return reader;
        }

        @Override
        @Nullable
        public Writer getSettingsWriter() {
            BufferedWriter writer = null;
            try {
                File file = new File(GDE.SETTINGS_FILE_PATH);
                if (!file.exists() && !file.createNewFile()) {
                    log.log(Level.WARNING, "failed creating ", file);
                }
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            return writer;
        }

        @Override
        public void verifyRoaming() {
            FileUtils.checkDirectoryAndCreate(GDE.APPL_HOME_PATH);
        }

        @Override
        public void verifyLogging() {
            FileUtils.checkDirectoryAndCreate(String.join((CharSequence)"/", GDE.APPL_HOME_PATH, "Logs"));
        }

        @Override
        public boolean verifyAndBackupTemplates() {
            String templatePath = String.join((CharSequence)"/", GDE.APPL_HOME_PATH, "GraphicsTemplates");
            if (!FileUtils.checkDirectoryAndCreate(templatePath, "GraphicsTemplates_V08.xsd")) {
                FileUtils.extract(Settings.class, "GraphicsTemplates_V08.xsd", "resource/", templatePath, "555");
                return false;
            }
            return true;
        }

        @Override
        public void checkGraphicsTemplates(Collection<ExportService> services, Predicate<String> serviceValidator) {
            Map<String, List<Path>> templateFileMap = this.readTemplateFiles();
            for (ExportService service : services) {
                try {
                    String serviceName = service.getName();
                    if (serviceValidator.test(serviceName)) {
                        this.extractDeviceDefaultTemplates(service.getJarPath(), serviceName);
                        continue;
                    }
                    if (!templateFileMap.containsKey(serviceName)) continue;
                    for (Path path : templateFileMap.get(serviceName)) {
                        log.log(Level.FINE, "delete ", path);
                        if (path.toFile().delete()) continue;
                        log.log(Level.WARNING, "could not delete ", path);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }

        private Map<String, List<Path>> readTemplateFiles() {
            Map<String, List<Path>> filesMap = new HashMap<String, List<Path>>();
            Path templatePath = Paths.get(GDE.APPL_HOME_PATH, "GraphicsTemplates");
            try (Stream<Path> files = Files.walk(templatePath, 2, new FileVisitOption[0]);){
                Stream<Path> potentialFiles = files.filter(t -> t.getFileName().toString().contains("."));
                filesMap = potentialFiles.collect(Collectors.groupingBy(this::getTemplateFilePrefix));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return filesMap;
        }

        private String getTemplateFilePrefix(Path t) {
            String fileName = t.getFileName().toString();
            int index = fileName.lastIndexOf(95);
            return index < 0 ? "" : fileName.substring(0, index);
        }

        @Override
        public long getGraphicsTemplateLastModified(Path fileSubPath) {
            return Paths.get(GDE.APPL_HOME_PATH, "GraphicsTemplates").resolve(fileSubPath).toFile().lastModified();
        }

        @Nullable
        public InputStream getAlienTemplateInputStream(File file) throws FileNotFoundException {
            return new FileInputStream(file);
        }

        @Override
        public boolean existsGraphicsTemplate(Path fileSubPath) {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, "GraphicsTemplates").resolve(fileSubPath);
            return targetFilePath.toFile().exists();
        }

        @Override
        @Nullable
        public InputStream getGraphicsTemplateInputStream(Path fileSubPath) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, "GraphicsTemplates").resolve(fileSubPath);
            return new FileInputStream(targetFilePath.toFile());
        }

        @Override
        @Nullable
        public OutputStream getGraphicsTemplateOutputStream(Path fileSubPath) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, "GraphicsTemplates").resolve(fileSubPath);
            File folder = targetFilePath.getParent().toFile();
            if (!folder.exists() && !folder.mkdir()) {
                log.log(java.util.logging.Level.WARNING, "failed to create ", folder);
            }
            return new FileOutputStream(targetFilePath.toFile());
        }

        @Override
        public boolean ensureExclusionDirectory() {
            Path directoryPath = Paths.get(GDE.APPL_HOME_PATH, ".gdeignore");
            return FileUtils.checkDirectoryAndCreate(directoryPath.toString());
        }

        @Override
        public boolean existsExclusionFile(String fileName) {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeignore", fileName);
            return targetFilePath.toFile().exists();
        }

        @Override
        public void deleteExclusionFile(String fileName) {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeignore", fileName);
            FileUtils.deleteFile(targetFilePath.toString());
        }

        @Override
        @Nullable
        public InputStream getExclusionsInputStream(String fileName) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeignore", fileName);
            return new FileInputStream(targetFilePath.toFile());
        }

        @Override
        @Nullable
        public OutputStream getExclusionsOutputStream(String fileName) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeignore", fileName);
            File folder = targetFilePath.getParent().toFile();
            if (!folder.exists() && !folder.mkdir()) {
                log.log(java.util.logging.Level.WARNING, "failed to create ", folder);
            }
            return new FileOutputStream(targetFilePath.toFile());
        }

        @Override
        public boolean ensureInclusionDirectory() {
            Path directoryPath = Paths.get(GDE.APPL_HOME_PATH, ".gdeinclude");
            return FileUtils.checkDirectoryAndCreate(directoryPath.toString());
        }

        @Override
        public boolean existsInclusionFile(String fileName) {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeinclude", fileName);
            return targetFilePath.toFile().exists();
        }

        @Override
        public void deleteInclusionFile(String fileName) {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeinclude", fileName);
            FileUtils.deleteFile(targetFilePath.toString());
        }

        @Override
        @Nullable
        public InputStream getInclusionsInputStream(String fileName) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeinclude", fileName);
            return new FileInputStream(targetFilePath.toFile());
        }

        @Override
        @Nullable
        public OutputStream getInclusionsOutputStream(String fileName) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, ".gdeinclude", fileName);
            File folder = targetFilePath.getParent().toFile();
            if (!folder.exists() && !folder.mkdir()) {
                log.log(java.util.logging.Level.WARNING, "failed to create ", folder);
            }
            return new FileOutputStream(targetFilePath.toFile());
        }

        @Override
        public String[] getCacheFolderList(String vaultDirectory, int minFileLength) {
            Path cachePath = Paths.get(GDE.APPL_HOME_PATH, "Cache", vaultDirectory);
            if (!cachePath.toFile().exists()) {
                return new String[0];
            }
            if (minFileLength <= 0) {
                return cachePath.toFile().list();
            }
            ArrayList<String> vaultNames = new ArrayList<String>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(cachePath);){
                for (Path path : stream) {
                    if (path.toFile().length() < (long)minFileLength) continue;
                    vaultNames.add(path.getFileName().toString());
                }
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
            return vaultNames.toArray(new String[vaultNames.size()]);
        }

        @Override
        public String[] getCacheZipFolderList(String vaultDirectory, int minFileLength) {
            Path cachePath = Paths.get(GDE.APPL_HOME_PATH, "Cache", vaultDirectory);
            if (!cachePath.toFile().exists()) {
                return new String[0];
            }
            ArrayList<String> vaultNames = new ArrayList<String>();
            try (ZipInputStream stream = dataAccess.getCacheZipInputStream(vaultDirectory);){
                ZipEntry entry;
                while ((entry = stream.getNextEntry()) != null) {
                    if (entry.getSize() < (long)minFileLength) continue;
                    vaultNames.add(entry.getName());
                }
            }
            catch (Exception e) {
                log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            }
            return vaultNames.toArray(new String[vaultNames.size()]);
        }

        @Override
        @Nullable
        public HistoVault getCacheVault(String vaultDirectory, String vaultName, int minVaultLength, boolean xmlFormat) {
            Path cachePath = Paths.get(GDE.APPL_HOME_PATH, "Cache", vaultDirectory);
            HistoVault histoVault = null;
            File file = cachePath.resolve(vaultName).toFile();
            if (file.length() > (long)minVaultLength) {
                try (InputStream stream = this.getCacheInputStream(vaultDirectory, file.getName());){
                    histoVault = xmlFormat ? VaultProxy.load(stream) : VaultProxy.loadJson(stream);
                }
                catch (Exception e) {
                    log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                }
            }
            return histoVault;
        }

        @Override
        @Nullable
        public HistoVault getCacheZipVault(String vaultDirectory, String vaultName, int minVaultLength, boolean xmlFormat) {
            HistoVault histoVault;
            block13: {
                Path cachePath = Paths.get(GDE.APPL_HOME_PATH, "Cache", vaultDirectory);
                histoVault = null;
                try (ZipFile zf = new ZipFile(cachePath.toFile());){
                    if (zf.getEntry(vaultName) == null || zf.getEntry(vaultName).getSize() <= (long)minVaultLength) break block13;
                    try (InputStream stream = zf.getInputStream(zf.getEntry(vaultName));){
                        histoVault = xmlFormat ? VaultProxy.load(stream) : VaultProxy.loadJson(stream);
                    }
                }
                catch (Exception e) {
                    log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
                }
            }
            return histoVault;
        }

        @Override
        public boolean verifyAndBackupDevices() {
            String devicePath = String.join((CharSequence)"/", GDE.APPL_HOME_PATH, "Devices");
            if (!FileUtils.checkDirectoryAndCreate(devicePath, "DeviceProperties_V47.xsd")) {
                FileUtils.extract(Settings.class, "DeviceProperties_V47.xsd", "resource/", devicePath, "555");
                return false;
            }
            if (!FileUtils.checkFileExist(String.join((CharSequence)"/", devicePath, "DeviceProperties_V47.xsd"))) {
                FileUtils.extract(Settings.class, "DeviceProperties_V47.xsd", "resource/", devicePath, "555");
            }
            return true;
        }

        @Override
        public void checkDeviceProperties(List<ExportService> services, Predicate<String> serviceValidator) {
            for (ExportService service : services) {
                String serviceName = service.getName();
                try {
                    if (serviceValidator.test(serviceName)) {
                        this.extractDeviceProperties(service.getJarPath(), serviceName);
                        continue;
                    }
                    Path path = Paths.get(GDE.APPL_HOME_PATH, "Devices", serviceName + ".xml");
                    if (!path.toFile().exists()) continue;
                    log.log(Level.FINE, "delete ", path);
                    if (path.toFile().delete()) continue;
                    log.log(Level.WARNING, "could not delete", path);
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }

        @Override
        public String[] getDeviceFolderList() {
            String xmlBasePath = GDE.APPL_HOME_PATH + "/" + "Devices" + "/";
            File deviceFolder = new File(xmlBasePath);
            if (!deviceFolder.exists()) {
                return new String[0];
            }
            return deviceFolder.list();
        }

        @Override
        public boolean existsDeviceXml(Path fileSubPath) {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, new String[0]).resolve(fileSubPath);
            return targetFilePath.toFile().exists();
        }

        public boolean existsDeviceXml(String xmlFilePath) {
            return new File(xmlFilePath).exists();
        }

        @Override
        public InputStream getDeviceXsdInputStream() throws FileNotFoundException {
            String xmlBasePath = GDE.APPL_HOME_PATH + "/" + "Devices" + "/";
            Path targetFilePath = Paths.get(xmlBasePath, "DeviceProperties_V47.xsd");
            return new FileInputStream(targetFilePath.toFile());
        }

        @Override
        public InputStream getDeviceXmlInputStream(Path fileSubPath) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, new String[0]).resolve(fileSubPath);
            return new FileInputStream(targetFilePath.toFile());
        }

        @Override
        public InputStream getDeviceXmlInputStream(String xmlFilePath) throws FileNotFoundException {
            return new FileInputStream(xmlFilePath);
        }

        @Override
        public OutputStream getDeviceXmlOutputStream(Path fileSubPath) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, new String[0]).resolve(fileSubPath);
            return new FileOutputStream(targetFilePath.toFile());
        }

        @Nullable
        public FileOutputStream getDeviceXmlOutputStream(String xmlFilePath) throws FileNotFoundException {
            return new FileOutputStream(xmlFilePath);
        }

        @Override
        public InputStream getDeviceXsdMigrationStream(int versionNumber) throws FileNotFoundException {
            Path migratePropertyPath = Paths.get(GDE.APPL_HOME_PATH + "/" + "Devices" + "_V" + versionNumber, new String[0]);
            Path targetFilePath = migratePropertyPath.resolve("DeviceProperties_V" + versionNumber + ".xsd");
            return new FileInputStream(targetFilePath.toFile());
        }

        @Override
        public boolean existsDeviceMigrationFolder(int versionNumber) {
            Path migratePropertyPath = Paths.get(GDE.APPL_HOME_PATH + "/" + "Devices" + "_V" + versionNumber, new String[0]);
            return migratePropertyPath.toFile().exists();
        }

        @Override
        public String[] getDevicePropertyFileNames(Path devicePath) {
            return devicePath.toFile().list((dir, name) -> name.endsWith(".xml"));
        }

        @Override
        public List<Path> getDeviceXmlSubPaths(int versionNumber) throws FileNotFoundException {
            String folderName = "Devices_V" + versionNumber;
            Path migratePropertyPath = Paths.get(GDE.APPL_HOME_PATH + "/" + folderName, new String[0]);
            List<File> fileList = FileUtils.getFileListing(migratePropertyPath.toFile(), 1, ".xml");
            return fileList.stream().map(File::getName).map(s -> Paths.get(folderName, s)).collect(Collectors.toList());
        }

        @Override
        public void deleteDeviceHistoTemplates(final String deviceName) throws IOException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, new String[0]).resolve("GraphicsTemplates");
            Files.walkFileTree(targetFilePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String histoTemplateEnding = "H" + "*.xml".substring(1);
                    String fileName = file.getFileName().toString();
                    if (fileName.endsWith(histoTemplateEnding) && fileName.startsWith(deviceName)) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        @Override
        public InputStream getGeoCodeInputStream(String geoFileName) throws FileNotFoundException {
            Path filePath = Paths.get(GDE.APPL_HOME_PATH, "Locations", geoFileName);
            return new FileInputStream(filePath.toFile());
        }

        public InputStream getHttpsInputStream(URL requestUrl) throws IOException {
            HttpsURLConnection conn = (HttpsURLConnection)requestUrl.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
            InputStream httpInputStream = conn.getInputStream();
            return httpInputStream;
        }

        public FileOutputStream getGeoCodeOutputStream(String geoFileName) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, "Locations", geoFileName);
            return new FileOutputStream(targetFilePath.toString());
        }

        @Override
        public boolean existsGeoCodeFile(String geoFileName) {
            Path filePath = Paths.get(GDE.APPL_HOME_PATH, "Locations", geoFileName);
            return FileUtils.checkFileExist(filePath.toString());
        }

        @Override
        public void deleteGeoCodeFile(String geoFileName) {
            Path filePath = Paths.get(GDE.APPL_HOME_PATH, "Locations", geoFileName);
            FileUtils.deleteFile(filePath.toString());
        }

        @Override
        public List<String> getGeoCodeFolderList() throws FileNotFoundException {
            Path locationsPath = Paths.get(GDE.APPL_HOME_PATH, "Locations");
            List<File> fileListing = FileUtils.getFileListing(locationsPath.toFile(), 0);
            ArrayList<String> fileNames = new ArrayList<String>();
            for (File file : fileListing) {
                fileNames.add(file.getName());
            }
            return fileNames;
        }

        public boolean resetHistolocations() {
            Path locationsPath = Paths.get(GDE.APPL_HOME_PATH, "Locations");
            if (FileUtils.checkDirectoryExist(locationsPath.toString())) {
                FileUtils.deleteDirectory(locationsPath.toString());
                log.log(Level.CONFIG, "histo geo locations deleted");
                return true;
            }
            return false;
        }

        public boolean checkAndCreateHistoLocations() {
            return FileUtils.checkDirectoryAndCreate(GDE.APPL_HOME_PATH + "/" + "Locations");
        }

        public String resetHistoCache() {
            Path cachePath = Paths.get(GDE.APPL_HOME_PATH, "Cache");
            int initialSize_KiB = (int)FileUtils.size(cachePath) / 1024;
            FileUtils.cleanDirectory(cachePath.toFile());
            FileUtils.checkDirectoryAndCreate(cachePath.toString());
            int deletedSize_KiB = (int)FileUtils.size(cachePath) / 1024;
            FileUtils.extract(this.getClass(), "HistoVault_V04.xsd", "resource/", cachePath.toString(), "555");
            String message = Messages.getString("GDE_MSGT0831", new Object[]{initialSize_KiB, deletedSize_KiB, cachePath});
            log.log(Level.CONFIG, message);
            return message;
        }

        @Override
        public boolean verifyAndBackupCache() {
            String cachePath = GDE.APPL_HOME_PATH + "/" + "Cache";
            if (!FileUtils.checkDirectoryAndCreate(cachePath, "HistoVault_V04.xsd")) {
                FileUtils.extract(Settings.class, "HistoVault_V04.xsd", "resource/", cachePath, "555");
                return false;
            }
            return true;
        }

        @Override
        public boolean existsCacheDirectory(String directoryName) {
            Path cacheDirectoryPath = Paths.get(GDE.APPL_HOME_PATH, "Cache", directoryName);
            return cacheDirectoryPath.toFile().exists();
        }

        @Override
        public boolean ensureCacheDirectory(String directoryName) {
            Path cacheDirectoryPath = Paths.get(GDE.APPL_HOME_PATH, "Cache", directoryName);
            return FileUtils.checkDirectoryAndCreate(cacheDirectoryPath.toString());
        }

        @Override
        public boolean existsCacheVault(String directoryName, String fileName) {
            Path cacheDirectoryPath = Paths.get(GDE.APPL_HOME_PATH, "Cache", directoryName);
            return FileUtils.checkFileExist(cacheDirectoryPath.resolve(fileName).toString());
        }

        @Override
        public long getCacheSize() {
            Path cachePath = Paths.get(GDE.APPL_HOME_PATH, "Cache");
            return FileUtils.size(cachePath);
        }

        @Override
        public InputStream getCacheXsdInputStream() throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, "Cache", "HistoVault_V04.xsd");
            return new FileInputStream(targetFilePath.toFile());
        }

        @Override
        public InputStream getCacheInputStream(String directoryName, String fileName) throws IOException {
            Path cacheDirectoryPath = Paths.get(GDE.APPL_HOME_PATH, "Cache", directoryName);
            return Files.newInputStream(cacheDirectoryPath.resolve(fileName), StandardOpenOption.CREATE_NEW);
        }

        @Override
        public ZipInputStream getCacheZipInputStream(String directoryName) throws ZipException, IOException {
            Path cacheDirectoryPath = Paths.get(GDE.APPL_HOME_PATH, "Cache", directoryName);
            return new ZipInputStream(new FileInputStream(cacheDirectoryPath.toFile()));
        }

        @Override
        public FileSystem getCacheZipFileSystem(String directoryName) throws IOException {
            Path cacheDirectoryPath = Paths.get(GDE.APPL_HOME_PATH, "Cache", directoryName);
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            return FileSystems.newFileSystem(URI.create("jar:" + cacheDirectoryPath.toUri()), env);
        }

        @Override
        public OutputStream getCacheZipOutputStream(FileSystem fileSystem, String fileName) throws IOException {
            return Files.newOutputStream(fileSystem.getPath(fileName, new String[0]), StandardOpenOption.CREATE_NEW);
        }

        @Override
        public OutputStream getCacheOutputStream(String directoryName, String fileName) throws IOException {
            Path cacheDirectoryPath = Paths.get(GDE.APPL_HOME_PATH, "Cache", directoryName);
            return Files.newOutputStream(cacheDirectoryPath.resolve(fileName), StandardOpenOption.CREATE_NEW);
        }

        @Override
        public InputStream getMappingInputStream(String fileName) throws FileNotFoundException {
            Path targetFilePath = Paths.get(GDE.APPL_HOME_PATH, "Mapping", fileName);
            return new BufferedInputStream(new FileInputStream(targetFilePath.toFile()));
        }

        @Override
        public void checkMappingFileAndCreate(Class<?> sourceClass, String fileName) {
            File path = new File(GDE.APPL_HOME_PATH + "/" + "Mapping");
            Path targetFilePath = Paths.get(path.toString() + "/" + fileName, new String[0]);
            if (!targetFilePath.toFile().exists()) {
                if (!path.exists() && !path.isDirectory()) {
                    path.mkdir();
                }
                FileUtils.extract(sourceClass, fileName, Locale.getDefault().equals(Locale.ENGLISH) ? "resource/en" : "resource/de", path.getAbsolutePath(), "555");
            }
        }

        @Override
        public long getSourceLastModified(Path fittedFilePath) {
            return fittedFilePath.toFile().lastModified();
        }

        @Override
        public long getSourceLength(Path fittedFilePath) {
            return fittedFilePath.toFile().length();
        }

        @Override
        @Nullable
        public InputStream getSourceInputStream(Path fittedFilePath) {
            try {
                return new FileInputStream(fittedFilePath.toFile());
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("invalid path " + fittedFilePath);
            }
        }

        @Override
        public Stream<String> getSourceFolderList(Path fittedFolderPath) {
            if (this.existsSourceFolder(fittedFolderPath)) {
                try {
                    return Files.list(fittedFolderPath).map(Path::getFileName).map(Path::toString);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            return Stream.empty();
        }

        @Override
        public boolean existsSourceFolder(Path fittedFolderPath) {
            File sourceFolder = fittedFolderPath.toFile();
            return sourceFolder.exists() && sourceFolder.isDirectory() && sourceFolder.canRead();
        }

        @Override
        public boolean existsSourceFile(Path fittedFilePath) {
            return FileUtils.checkFileExist(fittedFilePath.toString());
        }

        @Override
        public Stream<Path> getSourceFolders(Path fittedFolderPath) throws IOException {
            Stream<Path> folders = Files.walk(fittedFolderPath, new FileVisitOption[0]).filter(p -> !p.equals(fittedFolderPath)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
            return folders;
        }

        @Override
        public Stream<Path> getSourceFolders(Path fittedFolderPath, Stream<String> objectKeys) throws IOException {
            Set lowerCaseKeys = objectKeys.map(String::toLowerCase).collect(Collectors.toSet());
            Stream<Path> folders = Files.walk(fittedFolderPath, new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> lowerCaseKeys.contains(p.getFileName().toString().toLowerCase()));
            return folders;
        }

        @Override
        @Nullable
        public Path getActualSourceFile(Path fittedFilePath) {
            long startMillis = System.currentTimeMillis();
            File tmpActualFile = null;
            try {
                tmpActualFile = new File(OperatingSystemHelper.getLinkContainedFilePath(fittedFilePath.toString()));
                log.log(Level.FINER, "time_ms=", System.currentTimeMillis() - startMillis);
                if (!fittedFilePath.toFile().exists()) {
                    throw new IllegalArgumentException("source file does not exist");
                }
                if (Files.isSameFile(fittedFilePath, tmpActualFile.toPath()) && System.currentTimeMillis() - startMillis > 555L) {
                    log.log(Level.WARNING, "Dead OSD link " + fittedFilePath + " pointing to ", tmpActualFile);
                    if (!fittedFilePath.toFile().delete()) {
                        log.log(Level.WARNING, "could not delete link file ", fittedFilePath);
                    }
                    tmpActualFile = null;
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            return tmpActualFile != null ? tmpActualFile.toPath() : null;
        }

        @Override
        public boolean deleteFleetObjects() {
            Path targetDirPath = Paths.get(GDE.APPL_HOME_PATH, "Fleet");
            return FileUtils.cleanDirectory(targetDirPath.toFile());
        }

        @Override
        public Set<String> getFleetFileNames(Function<String, Boolean> objectKeyfilter) {
            Set<String> objectNames;
            Path targetDirPath = Paths.get(GDE.APPL_HOME_PATH, "Fleet");
            FileUtils.checkDirectoryAndCreate(targetDirPath.toString());
            try (Stream<String> stream = Files.list(targetDirPath).map(p -> targetDirPath.relativize((Path)p)).map(Path::toString);){
                objectNames = stream.filter(objectKeyfilter::apply).collect(Collectors.toSet());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return objectNames;
        }

        @Override
        public FileInputStream getFleetInputStream(Path fileSubPath) {
            Path targetDirPath = Paths.get(GDE.APPL_HOME_PATH, "Fleet");
            FileUtils.checkDirectoryAndCreate(targetDirPath.toString());
            try {
                return new FileInputStream(targetDirPath.resolve(fileSubPath).toFile());
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("invalid path " + fileSubPath);
            }
        }

        @Override
        public FileOutputStream getFleetOutputStream(Path fileSubPath) {
            Path targetDirPath = Paths.get(GDE.APPL_HOME_PATH, "Fleet");
            FileUtils.checkDirectoryAndCreate(targetDirPath.toString());
            try {
                Files.createDirectories(targetDirPath, new FileAttribute[0]);
                return new FileOutputStream(targetDirPath.resolve(fileSubPath).toFile());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid path " + fileSubPath);
            }
        }

        @Override
        public void extractDeviceProperties(Path jarPath, String serviceName) throws IOException {
            if (!FileUtils.checkFileExist(Paths.get(Settings.getDevicesPath(), serviceName + ".xml").toString())) {
                FileUtils.extract(new JarFile(jarPath.toFile()), serviceName + ".xml", "resource/", Settings.getDevicesPath(), "555");
            }
        }

        @Override
        public void extractDeviceDefaultTemplates(Path jarPath, String serviceName) throws IOException {
            JarFile jarFile = new JarFile(jarPath.toFile());
            String serviceName_ = serviceName + "_";
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                String entryName = e.nextElement().getName();
                if (!entryName.startsWith("resource/template/") || !entryName.endsWith(".xml") || !entryName.contains(serviceName_)) continue;
                String defaultTemplateName = entryName.substring("resource/template/".length());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("jarFile = %s ; defaultTemplateName = %s", jarFile.getName(), entryName));
                }
                if (FileUtils.checkFileExist(Paths.get(Settings.getGraphicsTemplatePath(), defaultTemplateName).toString())) continue;
                FileUtils.extract(jarFile, defaultTemplateName, "resource/template/", Settings.getGraphicsTemplatePath(), "555");
            }
        }

        @Override
        public void checkMeasurementDisplayProperties(boolean localeChanged, String lang) {
            Path path = Paths.get(GDE.APPL_HOME_PATH, "Mapping");
            Path propertyFilePath = path.resolve("MeasurementDisplayProperties.xml");
            if (!localeChanged) {
                if (!FileUtils.checkFileExist(propertyFilePath.toString())) {
                    FileUtils.extract(this.getClass(), "MeasurementDisplayProperties.xml", String.format("%s%s%s", "resource/", lang, "/"), path.toString(), "555");
                }
            } else {
                if (FileUtils.checkFileExist(propertyFilePath.toString())) {
                    propertyFilePath.toFile().delete();
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                FileUtils.extract(this.getClass(), "MeasurementDisplayProperties.xml", String.format("%s%s%s", "resource/", lang, "/"), path.toString(), "555");
            }
        }

        @Override
        public synchronized LocalAccess clone() {
            LocalAccess clone = null;
            try {
                clone = new LocalAccess(this);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            return clone;
        }
    }
}

