/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit.network;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.webkit.network.Cookie;
import com.sun.webkit.network.CookieStore;
import com.sun.webkit.network.ExtendedTime;
import com.sun.webkit.network.PublicSuffixes;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class CookieManager
extends CookieHandler {
    private static final PlatformLogger logger = PlatformLogger.getLogger(CookieManager.class.getName());
    private final CookieStore store = new CookieStore();

    @Override
    public Map<String, List<String>> get(URI uRI, Map<String, List<String>> map2) {
        Map<String, List<String>> map3;
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("uri: [{0}], requestHeaders: {1}", uRI, CookieManager.toLogString(map2));
        }
        if (uRI == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("requestHeaders is null");
        }
        String string2 = this.get(uRI);
        if (string2 != null) {
            map3 = new HashMap();
            map3.put("Cookie", Arrays.asList(string2));
        } else {
            map3 = Collections.emptyMap();
        }
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("result: {0}", CookieManager.toLogString(map3));
        }
        return map3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(URI uRI) {
        List<Cookie> list2;
        String string2 = uRI.getHost();
        if (string2 == null || string2.length() == 0) {
            logger.finest("Null or empty URI host, returning null");
            return null;
        }
        string2 = CookieManager.canonicalize(string2);
        String string3 = uRI.getScheme();
        boolean bl = "https".equalsIgnoreCase(string3) || "javascripts".equalsIgnoreCase(string3);
        boolean bl2 = "http".equalsIgnoreCase(string3) || "https".equalsIgnoreCase(string3);
        Object object = this.store;
        synchronized (object) {
            list2 = this.store.get(string2, uRI.getPath(), bl, bl2);
        }
        object = new StringBuilder();
        for (Cookie cookie : list2) {
            if (((StringBuilder)object).length() > 0) {
                ((StringBuilder)object).append("; ");
            }
            ((StringBuilder)object).append(cookie.getName());
            ((StringBuilder)object).append('=');
            ((StringBuilder)object).append(cookie.getValue());
        }
        return ((StringBuilder)object).length() > 0 ? ((StringBuilder)object).toString() : null;
    }

    @Override
    public void put(URI uRI, Map<String, List<String>> map2) {
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("uri: [{0}], responseHeaders: {1}", uRI, CookieManager.toLogString(map2));
        }
        if (uRI == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (map2 == null) {
            throw new IllegalArgumentException("responseHeaders is null");
        }
        for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
            String string2 = entry.getKey();
            if (!"Set-Cookie".equalsIgnoreCase(string2)) continue;
            ExtendedTime extendedTime = ExtendedTime.currentTime();
            ListIterator<String> listIterator = entry.getValue().listIterator(entry.getValue().size());
            while (listIterator.hasPrevious()) {
                Cookie cookie = Cookie.parse(listIterator.previous(), extendedTime);
                if (cookie == null) continue;
                this.put(uRI, cookie);
                extendedTime = extendedTime.incrementSubtime();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(URI uRI, Cookie cookie) {
        boolean bl;
        logger.finest("cookie: {0}", cookie);
        String string2 = uRI.getHost();
        if (string2 == null || string2.length() == 0) {
            logger.finest("Null or empty URI host, ignoring cookie");
            return;
        }
        string2 = CookieManager.canonicalize(string2);
        if (PublicSuffixes.isPublicSuffix(cookie.getDomain())) {
            if (cookie.getDomain().equals(string2)) {
                cookie.setDomain("");
            } else {
                logger.finest("Domain is public suffix, ignoring cookie");
                return;
            }
        }
        if (cookie.getDomain().length() > 0) {
            if (!Cookie.domainMatches(string2, cookie.getDomain())) {
                logger.finest("Hostname does not match domain, ignoring cookie");
                return;
            }
            cookie.setHostOnly(false);
        } else {
            cookie.setHostOnly(true);
            cookie.setDomain(string2);
        }
        if (cookie.getPath() == null) {
            cookie.setPath(Cookie.defaultPath(uRI));
        }
        boolean bl2 = bl = "http".equalsIgnoreCase(uRI.getScheme()) || "https".equalsIgnoreCase(uRI.getScheme());
        if (cookie.getHttpOnly() && !bl) {
            logger.finest("HttpOnly cookie received from non-HTTP API, ignoring cookie");
            return;
        }
        CookieStore cookieStore = this.store;
        synchronized (cookieStore) {
            Cookie cookie2 = this.store.get(cookie);
            if (cookie2 != null) {
                if (cookie2.getHttpOnly() && !bl) {
                    logger.finest("Non-HTTP API attempts to overwrite HttpOnly cookie, blocked");
                    return;
                }
                cookie.setCreationTime(cookie2.getCreationTime());
            }
            this.store.put(cookie);
        }
        logger.finest("Stored: {0}", cookie);
    }

    private static String toLogString(Map<String, List<String>> map2) {
        if (map2 == null) {
            return null;
        }
        if (map2.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
            String string2 = entry.getKey();
            for (String string3 : entry.getValue()) {
                stringBuilder.append(String.format("%n    ", new Object[0]));
                stringBuilder.append(string2);
                stringBuilder.append(": ");
                stringBuilder.append(string3);
            }
        }
        return stringBuilder.toString();
    }

    private static String canonicalize(String string2) {
        return string2.toLowerCase();
    }
}

