/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi;

import gde.device.DeviceConfiguration;
import gde.device.junsi.iChargerUsb;
import java.io.FileNotFoundException;
import javax.xml.bind.JAXBException;

public class iChargerX6
extends iChargerUsb {
    public iChargerX6(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        this.BATTERIE_TYPES = BatteryTypesX.getValues();
    }

    public iChargerX6(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        this.BATTERIE_TYPES = BatteryTypesX.getValues();
    }

    @Override
    public int getNumberOfLithiumCells() {
        return 6;
    }

    @Override
    public int getDcInputVoltMin() {
        return 70;
    }

    @Override
    public int getDcInputVoltMax() {
        return 310;
    }

    @Override
    public int getDcInputCurrentMax() {
        return 350;
    }

    @Override
    public int getRegInputVoltMin() {
        return 70;
    }

    @Override
    public int getRegInputVoltMax() {
        return 310;
    }

    @Override
    public int getChargeCurrentMax4Channel() {
        return 300;
    }

    @Override
    public int getChargeCurrentMaxSyncChannels() {
        return 0;
    }

    @Override
    public int getDeviceChargePowerMax() {
        return 800;
    }

    @Override
    public int[] getChargePowerMax() {
        return new int[]{800, 0};
    }

    @Override
    public int[] getDischargePowerMax() {
        return new int[]{30, 0};
    }

    @Override
    public int[] getRegChannelVoltageLimits() {
        return new int[]{0, 0};
    }

    @Override
    public int[] getRegChannelCurrentLimits() {
        return new int[]{0, 0};
    }

    public static enum BatteryTypesX {
        BT_UNKNOWN("?"),
        BT_LIPO("LiPo"),
        BT_LIIO("LiIo"),
        BT_LIFE("LiFe"),
        BT_LIHV("LiHV"),
        BT_LTO("LTO"),
        BT_NIMH("NiMH"),
        BT_NICD("NiCd"),
        BT_NIZN("NiZn"),
        BT_PB("PB"),
        BT_POWER("Power"),
        BT_USER("User"),
        BT_UNKNOWN_("?");

        private String value;
        public static BatteryTypesX[] VALUES;

        private BatteryTypesX(String newValue) {
            this.value = newValue;
        }

        protected String getName() {
            return this.value;
        }

        public static String[] getValues() {
            StringBuilder sb = new StringBuilder();
            for (BatteryTypesX bt : BatteryTypesX.values()) {
                sb.append(bt.value).append(',');
            }
            return sb.toString().split(",");
        }

        static {
            VALUES = BatteryTypesX.values();
        }
    }
}

