/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog;

import gde.GDE;
import gde.config.Settings;
import gde.data.ObjectData;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.PropertyType;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GoogleEarthCustomizingDialog
extends Dialog {
    static final Logger log = Logger.getLogger(GoogleEarthCustomizingDialog.class.getName());
    final DataExplorer application;
    final Settings settings;
    final IDevice device;
    Shell dialogShell;
    Composite valueSelectorComposite;
    Composite colorComposite;
    Text upperLimitText;
    CLabel upperLimitLabel;
    Text avgFactorText;
    CLabel averageFactorLabel;
    Text avgText;
    CLabel averageLabel;
    private Label valueSelectionLabel;
    private Button randomColorButton;
    private Button extrudeButton;
    private Combo valueSelectionCombo;
    Composite fillerComposite;
    Text lowerLimitText;
    CLabel lowerLimitLabel;
    Button upperLimitButton;
    Button withinLimitsButton;
    Button lowerLimitButton;
    Composite limitComposite;
    Button closeButton;
    Composite compositeUpper;
    Composite compositeWithin;
    Composite compositeLower;
    int upperLimitVelocity = 100;
    int lowerLimitVelocity = 20;
    double avgLimitFactor = 2.0;
    RGB withinLimitsColor = SWTResourceManager.getColor(0, 255, 0).getRGB();
    RGB lowerLimitColor = SWTResourceManager.getColor(255, 0, 0).getRGB();
    RGB upperLimitColor = SWTResourceManager.getColor(128, 128, 0).getRGB();

    public static void main(String[] args) {
        try {
            Display display = Display.getDefault();
            Shell shell = new Shell(display);
            GoogleEarthCustomizingDialog inst = new GoogleEarthCustomizingDialog(shell, 0);
            inst.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public GoogleEarthCustomizingDialog(Shell parent, int style) {
        super(parent, style);
        this.application = DataExplorer.getInstance();
        this.settings = Settings.getInstance();
        this.device = this.application.getActiveDevice();
    }

    public void open() {
        try {
            Shell parent = this.getParent();
            this.dialogShell = new Shell(parent, 67680);
            SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
            this.dialogShell.setText(Messages.getString("GDE_MSGT0283"));
            this.dialogShell.setLayout((Layout)new FormLayout());
            this.dialogShell.layout();
            this.dialogShell.pack();
            this.dialogShell.setSize(360, 265);
            this.dialogShell.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: {
                            GoogleEarthCustomizingDialog.this.dialogShell.close();
                            event.detail = 0;
                            event.doit = false;
                        }
                    }
                }
            });
            this.dialogShell.setImage(SWTResourceManager.getImage("gde/resource/EarthConfigHot.gif"));
            this.dialogShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent evt) {
                    log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                    GoogleEarthCustomizingDialog.this.makePersistent();
                    GoogleEarthCustomizingDialog.this.application.resetShellIcon();
                }
            });
            this.valueSelectorComposite = new Composite((Composite)this.dialogShell, 0);
            FormData colorCompositeLData = new FormData();
            colorCompositeLData.top = new FormAttachment(0, 1000, 0);
            colorCompositeLData.left = new FormAttachment(0, 1000, 5);
            colorCompositeLData.right = new FormAttachment(1000, 1000, -5);
            colorCompositeLData.height = 55;
            this.valueSelectorComposite.setLayoutData((Object)colorCompositeLData);
            RowLayout compositeLayout = new RowLayout(512);
            this.valueSelectorComposite.setLayout((Layout)compositeLayout);
            this.valueSelectionLabel = new Label(this.valueSelectorComposite, 0);
            RowData valueSelectionLabelLData = new RowData(GDE.IS_LINUX ? 200 : 185, 18);
            this.valueSelectionLabel.setLayoutData((Object)valueSelectionLabelLData);
            this.valueSelectionLabel.setText(Messages.getString("GDE_MSGT0875"));
            this.valueSelectionCombo = new Combo(this.valueSelectorComposite, 0);
            RowData valueSelectionComboLData = new RowData(GDE.IS_WINDOWS ? 155 : 170, GDE.IS_MAC ? 26 : 18);
            this.valueSelectionCombo.setLayoutData((Object)valueSelectionComboLData);
            this.valueSelectionCombo.setItems(this.application.getActiveRecordSet().getRecordNames());
            this.valueSelectionCombo.select(this.device.getGPS2KMZMeasurementOrdinal().intValue());
            this.valueSelectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "valueSelectionCombo.widgetSelected, event=" + evt);
                    GoogleEarthCustomizingDialog.this.device.setGPS2KMZMeasurementOrdinal(GoogleEarthCustomizingDialog.this.valueSelectionCombo.getSelectionIndex());
                    GoogleEarthCustomizingDialog.this.avgFactorText.notifyListeners(2, new Event());
                }
            });
            this.extrudeButton = new Button(this.valueSelectorComposite, 16416);
            RowData isExtrudeButtonLData = new RowData(150, 18);
            this.extrudeButton.setLayoutData((Object)isExtrudeButtonLData);
            this.extrudeButton.setText(Messages.getString("GDE_MSGT0734"));
            this.extrudeButton.setToolTipText(Messages.getString("GDE_MSGT0735"));
            this.extrudeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "extrudeButton.widgetSelected, event=" + evt);
                }
            });
            this.randomColorButton = new Button(this.valueSelectorComposite, 16416);
            RowData randomColorButtonLData = new RowData(150, 18);
            this.randomColorButton.setLayoutData((Object)randomColorButtonLData);
            this.randomColorButton.setText(Messages.getString("GDE_MSGT0736"));
            this.randomColorButton.setToolTipText(Messages.getString("GDE_MSGT0737"));
            this.randomColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "randomColorButton.widgetSelected, event=" + evt);
                }
            });
            this.colorComposite = new Composite((Composite)this.dialogShell, 0);
            RowLayout compositeLayout2 = new RowLayout(512);
            this.colorComposite.setLayout((Layout)compositeLayout2);
            FormData colorCompositeLData2 = new FormData();
            colorCompositeLData2.right = new FormAttachment(450, 1000, 0);
            colorCompositeLData2.left = new FormAttachment(0, 1000, 0);
            colorCompositeLData2.width = 157;
            colorCompositeLData2.height = 118;
            colorCompositeLData2.top = new FormAttachment(240, 1000, 0);
            colorCompositeLData2.bottom = new FormAttachment(1000, 1000, -45);
            this.colorComposite.setLayoutData((Object)colorCompositeLData2);
            this.compositeLower = new Composite(this.colorComposite, 2048);
            RowData composite1LData = new RowData();
            composite1LData.width = 145;
            composite1LData.height = 30;
            GridLayout composite1Layout = new GridLayout();
            composite1Layout.makeColumnsEqualWidth = true;
            this.compositeLower.setLayout((Layout)composite1Layout);
            this.compositeLower.setLayoutData((Object)composite1LData);
            this.lowerLimitButton = new Button(this.compositeLower, 0x1000008);
            GridData lowerLimitButtonLData = new GridData();
            lowerLimitButtonLData.widthHint = 130;
            lowerLimitButtonLData.heightHint = 20;
            lowerLimitButtonLData.horizontalAlignment = 2;
            this.lowerLimitButton.setLayoutData((Object)lowerLimitButtonLData);
            this.lowerLimitButton.setText(Messages.getString("GDE_MSGT0289"));
            this.lowerLimitButton.setToolTipText(Messages.getString("GDE_MSGT0293"));
            this.lowerLimitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "lowerLimitButton.widgetSelected, event=" + evt);
                    GoogleEarthCustomizingDialog.this.lowerLimitColor = GoogleEarthCustomizingDialog.this.application.openColorDialog();
                    GoogleEarthCustomizingDialog.this.compositeLower.setBackground(SWTResourceManager.getColor(GoogleEarthCustomizingDialog.this.lowerLimitColor.red, GoogleEarthCustomizingDialog.this.lowerLimitColor.green, GoogleEarthCustomizingDialog.this.lowerLimitColor.blue));
                }
            });
            this.fillerComposite = new Composite(this.colorComposite, 0);
            RowData fillerComposite_RALData = new RowData();
            fillerComposite_RALData.width = 145;
            fillerComposite_RALData.height = 2;
            this.fillerComposite.setLayoutData((Object)fillerComposite_RALData);
            this.compositeWithin = new Composite(this.colorComposite, 2048);
            RowData composite2LData = new RowData();
            composite2LData.width = 145;
            composite2LData.height = 30;
            GridLayout composite2Layout = new GridLayout();
            composite2Layout.makeColumnsEqualWidth = true;
            this.compositeWithin.setLayout((Layout)composite2Layout);
            this.compositeWithin.setLayoutData((Object)composite2LData);
            this.withinLimitsButton = new Button(this.compositeWithin, 0x1000008);
            this.withinLimitsButton.setText(Messages.getString("GDE_MSGT0294"));
            GridData withinLimitsButtonLData = new GridData();
            withinLimitsButtonLData.horizontalAlignment = 2;
            withinLimitsButtonLData.widthHint = 130;
            withinLimitsButtonLData.heightHint = 20;
            this.withinLimitsButton.setLayoutData((Object)withinLimitsButtonLData);
            this.withinLimitsButton.setToolTipText(Messages.getString("GDE_MSGT0295"));
            this.withinLimitsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "withinLimitsButton.widgetSelected, event=" + evt);
                    GoogleEarthCustomizingDialog.this.withinLimitsColor = GoogleEarthCustomizingDialog.this.application.openColorDialog();
                    GoogleEarthCustomizingDialog.this.compositeWithin.setBackground(SWTResourceManager.getColor(GoogleEarthCustomizingDialog.this.withinLimitsColor.red, GoogleEarthCustomizingDialog.this.withinLimitsColor.green, GoogleEarthCustomizingDialog.this.withinLimitsColor.blue));
                }
            });
            this.fillerComposite = new Composite(this.colorComposite, 0);
            RowData fillerComposite_RA1LData = new RowData();
            fillerComposite_RA1LData.width = 145;
            fillerComposite_RA1LData.height = 2;
            this.fillerComposite.setLayoutData((Object)fillerComposite_RA1LData);
            this.compositeUpper = new Composite(this.colorComposite, 2048);
            RowData composite3LData = new RowData();
            composite3LData.width = 145;
            composite3LData.height = 30;
            GridLayout composite3Layout = new GridLayout();
            composite3Layout.makeColumnsEqualWidth = true;
            this.compositeUpper.setLayout((Layout)composite3Layout);
            this.compositeUpper.setLayoutData((Object)composite3LData);
            this.upperLimitButton = new Button(this.compositeUpper, 0x1000008);
            GridData upperLimitButtonLData = new GridData();
            upperLimitButtonLData.widthHint = 130;
            upperLimitButtonLData.heightHint = 20;
            upperLimitButtonLData.horizontalAlignment = 2;
            this.upperLimitButton.setLayoutData((Object)upperLimitButtonLData);
            this.upperLimitButton.setText(Messages.getString("GDE_MSGT0296"));
            this.upperLimitButton.setToolTipText(Messages.getString("GDE_MSGT0297"));
            this.upperLimitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "upperLimitButton.widgetSelected, event=" + evt);
                    GoogleEarthCustomizingDialog.this.upperLimitColor = GoogleEarthCustomizingDialog.this.application.openColorDialog();
                    GoogleEarthCustomizingDialog.this.compositeUpper.setBackground(SWTResourceManager.getColor(GoogleEarthCustomizingDialog.this.upperLimitColor.red, GoogleEarthCustomizingDialog.this.upperLimitColor.green, GoogleEarthCustomizingDialog.this.upperLimitColor.blue));
                }
            });
            this.colorComposite.layout();
            this.limitComposite = new Composite((Composite)this.dialogShell, 0);
            RowLayout limitCompositeLayout = new RowLayout(256);
            this.limitComposite.setLayout((Layout)limitCompositeLayout);
            FormData limitCompositeLData = new FormData();
            limitCompositeLData.left = new FormAttachment(461, 1000, 0);
            limitCompositeLData.right = new FormAttachment(1000, 1000, 0);
            limitCompositeLData.top = new FormAttachment(240, 1000, 0);
            limitCompositeLData.width = 189;
            limitCompositeLData.height = 118;
            limitCompositeLData.bottom = new FormAttachment(1000, 1000, -45);
            this.limitComposite.setLayoutData((Object)limitCompositeLData);
            this.lowerLimitLabel = new CLabel(this.limitComposite, 131072);
            RowData lowerLimitLabelLData = new RowData();
            lowerLimitLabelLData.width = 115;
            lowerLimitLabelLData.height = 22;
            this.lowerLimitLabel.setLayoutData((Object)lowerLimitLabelLData);
            this.lowerLimitLabel.setText(Messages.getString("GDE_MSGT0284"));
            this.lowerLimitLabel.setToolTipText(Messages.getString("GDE_MSGT0285"));
            this.lowerLimitText = new Text(this.limitComposite, 133124);
            RowData lowerLimitTextLData = new RowData();
            lowerLimitTextLData.width = 35;
            lowerLimitTextLData.height = 16;
            this.lowerLimitText.setLayoutData((Object)lowerLimitTextLData);
            this.lowerLimitText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(Level.FINEST, "lowerLimitText.verifyText, event=" + evt);
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.averageFactorLabel = new CLabel(this.limitComposite, 131072);
            RowData averageFactorLabelLData = new RowData();
            averageFactorLabelLData.width = 115;
            averageFactorLabelLData.height = 22;
            this.averageFactorLabel.setLayoutData((Object)averageFactorLabelLData);
            this.averageFactorLabel.setText(Messages.getString("GDE_MSGT0286"));
            this.averageFactorLabel.setToolTipText(Messages.getString("GDE_MSGT0287"));
            this.avgFactorText = new Text(this.limitComposite, 133124);
            RowData avgFactorTextLData = new RowData();
            avgFactorTextLData.width = 35;
            avgFactorTextLData.height = 16;
            this.avgFactorText.setLayoutData((Object)avgFactorTextLData);
            this.avgFactorText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(Level.FINEST, "avgFactorText.verifyText, event=" + evt);
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.DOUBLE, evt.text);
                }
            });
            this.avgFactorText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent arg0) {
                    block5: {
                        Integer measurementOrdinal = GoogleEarthCustomizingDialog.this.device.getGPS2KMZMeasurementOrdinal();
                        RecordSet activeRecordSet = GoogleEarthCustomizingDialog.this.application.getActiveRecordSet();
                        if (activeRecordSet != null && measurementOrdinal != null && measurementOrdinal >= 0) {
                            int avgValue = (int)GoogleEarthCustomizingDialog.this.device.translateValue(activeRecordSet.get(measurementOrdinal), (double)activeRecordSet.get(measurementOrdinal).getAvgValue() / 1000.0);
                            GoogleEarthCustomizingDialog.this.avgText.setText(" " + avgValue);
                            try {
                                double factor = Double.parseDouble(GoogleEarthCustomizingDialog.this.avgFactorText.getText().replace(',', '.'));
                                if (factor >= 1.0) {
                                    GoogleEarthCustomizingDialog.this.lowerLimitText.setText(String.format("%d", (int)((double)avgValue / factor)));
                                    GoogleEarthCustomizingDialog.this.upperLimitText.setText(String.format("%d", (int)((double)avgValue * factor)));
                                    GoogleEarthCustomizingDialog.this.lowerLimitText.setBackground(DataExplorer.getInstance().COLOR_LIGHT_GREY);
                                    GoogleEarthCustomizingDialog.this.avgFactorText.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                                    GoogleEarthCustomizingDialog.this.upperLimitText.setBackground(DataExplorer.getInstance().COLOR_LIGHT_GREY);
                                    break block5;
                                }
                                GoogleEarthCustomizingDialog.this.lowerLimitText.setText("" + GoogleEarthCustomizingDialog.this.lowerLimitVelocity);
                                GoogleEarthCustomizingDialog.this.upperLimitText.setText("" + GoogleEarthCustomizingDialog.this.upperLimitVelocity);
                                GoogleEarthCustomizingDialog.this.lowerLimitText.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                                GoogleEarthCustomizingDialog.this.avgFactorText.setBackground(DataExplorer.getInstance().COLOR_LIGHT_GREY);
                                GoogleEarthCustomizingDialog.this.upperLimitText.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                            }
                            catch (Exception exception) {}
                        } else {
                            GoogleEarthCustomizingDialog.this.avgText.setText("0");
                        }
                    }
                }
            });
            this.upperLimitLabel = new CLabel(this.limitComposite, 131072);
            RowData upperLimitLabelLData = new RowData();
            upperLimitLabelLData.width = 115;
            upperLimitLabelLData.height = 22;
            this.upperLimitLabel.setLayoutData((Object)upperLimitLabelLData);
            this.upperLimitLabel.setText(Messages.getString("GDE_MSGT0288"));
            this.upperLimitLabel.setToolTipText(Messages.getString("GDE_MSGT0290"));
            this.upperLimitText = new Text(this.limitComposite, 133124);
            RowData upperLimitTextLData = new RowData();
            upperLimitTextLData.width = 35;
            upperLimitTextLData.height = 16;
            this.upperLimitText.setLayoutData((Object)upperLimitTextLData);
            this.upperLimitText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(Level.FINEST, "upperLimitText.verifyText, event=" + evt);
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this.averageLabel = new CLabel(this.limitComposite, 131072);
            RowData averageLabelLData = new RowData();
            averageLabelLData.width = 115;
            averageLabelLData.height = 22;
            this.averageLabel.setLayoutData((Object)averageLabelLData);
            this.averageLabel.setText(Messages.getString("GDE_MSGT0678"));
            this.averageLabel.setToolTipText(Messages.getString("GDE_MSGT0679"));
            this.avgText = new Text(this.limitComposite, 133124);
            RowData avgTextLData = new RowData();
            avgTextLData.width = 35;
            avgTextLData.height = 16;
            this.avgText.setLayoutData((Object)avgTextLData);
            this.avgText.setEditable(false);
            Integer measurementOrdinal = this.device.getGPS2KMZMeasurementOrdinal();
            RecordSet activeRecordSet = this.application.getActiveRecordSet();
            if (activeRecordSet != null && measurementOrdinal != null && measurementOrdinal >= 0) {
                this.avgText.setText(String.format(" %d", (int)this.device.translateValue(activeRecordSet.get(measurementOrdinal), (double)activeRecordSet.get(measurementOrdinal).getAvgValue() / 1000.0)));
            }
            this.avgText.setToolTipText(Messages.getString("GDE_MSGT0679"));
            this.limitComposite.layout();
            this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
            this.closeButton.setText(Messages.getString("GDE_MSGT0291"));
            this.closeButton.setToolTipText(Messages.getString("GDE_MSGT0292"));
            FormData closeButtonLData = new FormData();
            closeButtonLData.height = 25;
            closeButtonLData.left = new FormAttachment(0, 1000, 70);
            closeButtonLData.right = new FormAttachment(1000, 1000, -70);
            closeButtonLData.bottom = new FormAttachment(1000, 1000, -12);
            this.closeButton.setLayoutData((Object)closeButtonLData);
            this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                    GoogleEarthCustomizingDialog.this.dialogShell.dispose();
                }
            });
            this.initialize();
            this.dialogShell.setLocation(this.getParent().toDisplay(350, 50));
            this.dialogShell.open();
            this.avgFactorText.notifyListeners(2, new Event());
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void initialize() {
        this.lowerLimitVelocity = 20;
        this.avgLimitFactor = 0.0;
        this.upperLimitVelocity = 100;
        this.withinLimitsColor = SWTResourceManager.getColor(0, 255, 0).getRGB();
        this.lowerLimitColor = SWTResourceManager.getColor(255, 0, 0).getRGB();
        this.upperLimitColor = SWTResourceManager.getColor(255, 255, 0).getRGB();
        if (this.application.isObjectoriented()) {
            ObjectData object = this.application.getObject();
            Properties properties = object.getProperties();
            if (properties != null) {
                int b;
                int g;
                String color2;
                try {
                    this.avgLimitFactor = Double.parseDouble(((String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value())).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.lowerLimitVelocity = Integer.parseInt(((String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value())).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.upperLimitVelocity = Integer.parseInt(((String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value())).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    color2 = (String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_WITHIN_LIMITS_COLOR.value());
                    int r = Integer.valueOf(color2.split(",")[0].trim());
                    g = Integer.valueOf(color2.split(",")[1].trim());
                    b = Integer.valueOf(color2.split(",")[2].trim());
                    this.withinLimitsColor = SWTResourceManager.getColor(r, g, b).getRGB();
                }
                catch (Exception color2) {
                    // empty catch block
                }
                try {
                    color2 = (String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_LOWER_LIMIT_COLOR.value());
                    int r = Integer.valueOf(color2.split(",")[0].trim());
                    g = Integer.valueOf(color2.split(",")[1].trim());
                    b = Integer.valueOf(color2.split(",")[2].trim());
                    this.lowerLimitColor = SWTResourceManager.getColor(r, g, b).getRGB();
                }
                catch (Exception color3) {
                    // empty catch block
                }
                try {
                    color2 = (String)properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_UPPER_LIMIT_COLOR.value());
                    int r = Integer.valueOf(color2.split(",")[0].trim());
                    g = Integer.valueOf(color2.split(",")[1].trim());
                    b = Integer.valueOf(color2.split(",")[2].trim());
                    this.upperLimitColor = SWTResourceManager.getColor(r, g, b).getRGB();
                }
                catch (Exception color4) {
                    // empty catch block
                }
                if (properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value()) != null) {
                    this.extrudeButton.setSelection(Boolean.parseBoolean(properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value()).toString()));
                }
                if (properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value()) != null) {
                    this.randomColorButton.setSelection(Boolean.parseBoolean(properties.get(MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value()).toString()));
                }
            }
        } else {
            Integer activeChannelNumber = this.application.getActiveChannelNumber();
            Integer measurementOrdinal = this.device.getGPS2KMZMeasurementOrdinal();
            if (activeChannelNumber != null && measurementOrdinal != null) {
                int b;
                int g;
                String color5;
                PropertyType property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value());
                if (property != null) {
                    try {
                        this.avgLimitFactor = Double.parseDouble(property.getValue());
                    }
                    catch (NumberFormatException g2) {
                        // empty catch block
                    }
                }
                if ((property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value())) != null) {
                    try {
                        this.lowerLimitVelocity = Integer.parseInt(property.getValue());
                    }
                    catch (Exception g2) {
                        // empty catch block
                    }
                }
                if ((property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value())) != null) {
                    try {
                        this.upperLimitVelocity = Integer.parseInt(property.getValue());
                    }
                    catch (Exception g2) {
                        // empty catch block
                    }
                }
                if ((property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_WITHIN_LIMITS_COLOR.value())) != null) {
                    try {
                        color5 = property.getValue();
                        int r = Integer.valueOf(color5.split(",")[0].trim());
                        g = Integer.valueOf(color5.split(",")[1].trim());
                        b = Integer.valueOf(color5.split(",")[2].trim());
                        this.withinLimitsColor = SWTResourceManager.getColor(r, g, b).getRGB();
                    }
                    catch (Exception color5) {
                        // empty catch block
                    }
                }
                if ((property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_LOWER_LIMIT_COLOR.value())) != null) {
                    try {
                        color5 = property.getValue();
                        int r = Integer.valueOf(color5.split(",")[0].trim());
                        g = Integer.valueOf(color5.split(",")[1].trim());
                        b = Integer.valueOf(color5.split(",")[2].trim());
                        this.lowerLimitColor = SWTResourceManager.getColor(r, g, b).getRGB();
                    }
                    catch (Exception color6) {
                        // empty catch block
                    }
                }
                if ((property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_UPPER_LIMIT_COLOR.value())) != null) {
                    try {
                        color5 = property.getValue();
                        int r = Integer.valueOf(color5.split(",")[0].trim());
                        g = Integer.valueOf(color5.split(",")[1].trim());
                        b = Integer.valueOf(color5.split(",")[2].trim());
                        this.upperLimitColor = SWTResourceManager.getColor(r, g, b).getRGB();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value())) != null) {
                    try {
                        this.extrudeButton.setSelection(Boolean.parseBoolean(property.getValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((property = this.device.getMeasruementProperty(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value())) != null) {
                    try {
                        this.randomColorButton.setSelection(Boolean.parseBoolean(property.getValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        this.lowerLimitText.setText("" + this.lowerLimitVelocity);
        this.avgFactorText.setText(String.format("%.1f", this.avgLimitFactor));
        this.upperLimitText.setText("" + this.upperLimitVelocity);
        this.compositeLower.setBackground(SWTResourceManager.getColor(this.lowerLimitColor.red, this.lowerLimitColor.green, this.lowerLimitColor.blue));
        this.compositeWithin.setBackground(SWTResourceManager.getColor(this.withinLimitsColor.red, this.withinLimitsColor.green, this.withinLimitsColor.blue));
        this.compositeUpper.setBackground(SWTResourceManager.getColor(this.upperLimitColor.red, this.upperLimitColor.green, this.upperLimitColor.blue));
        if (this.avgLimitFactor >= 1.0) {
            Integer measurementOrdinal = this.device.getGPS2KMZMeasurementOrdinal();
            RecordSet activeRecordSet = this.application.getActiveRecordSet();
            if (activeRecordSet != null && measurementOrdinal != null && measurementOrdinal >= 0) {
                int avgValue = (int)this.device.translateValue(activeRecordSet.get(measurementOrdinal), (double)activeRecordSet.get(measurementOrdinal).getAvgValue() / 1000.0);
                try {
                    this.lowerLimitText.setText(String.format("%d", (int)((double)avgValue / Double.parseDouble(this.avgFactorText.getText().replace(',', '.')))));
                    this.upperLimitText.setText(String.format("%d", (int)((double)avgValue * Double.parseDouble(this.avgFactorText.getText().replace(',', '.')))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.lowerLimitText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.avgFactorText.setBackground(this.application.COLOR_WHITE);
            this.upperLimitText.setBackground(this.application.COLOR_LIGHT_GREY);
        } else {
            this.lowerLimitText.setBackground(this.application.COLOR_WHITE);
            this.avgFactorText.setBackground(this.application.COLOR_LIGHT_GREY);
            this.upperLimitText.setBackground(this.application.COLOR_WHITE);
        }
    }

    void makePersistent() {
        this.lowerLimitVelocity = Integer.parseInt(this.lowerLimitText.getText());
        this.avgLimitFactor = Double.parseDouble(this.avgFactorText.getText().replace(',', '.'));
        this.upperLimitVelocity = Integer.parseInt(this.upperLimitText.getText());
        if (this.application.isObjectoriented()) {
            ObjectData object = this.application.getObject();
            if (object != null) {
                Properties properties = object.getProperties();
                if (properties == null) {
                    properties = new Properties();
                    object.setProperties(properties);
                }
                if (this.avgLimitFactor > 0.0) {
                    properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value(), " " + this.avgLimitFactor);
                    if (properties.containsKey(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value())) {
                        properties.remove(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value());
                    }
                    if (properties.containsKey(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value())) {
                        properties.remove(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value());
                    }
                } else {
                    if (properties.containsKey(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value())) {
                        properties.remove(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value());
                    }
                    properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value(), " " + this.lowerLimitVelocity);
                    properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value(), " " + this.upperLimitVelocity);
                }
                properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_WITHIN_LIMITS_COLOR.value(), this.withinLimitsColor.red + "," + this.withinLimitsColor.green + "," + this.withinLimitsColor.blue);
                properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_LOWER_LIMIT_COLOR.value(), this.lowerLimitColor.red + "," + this.lowerLimitColor.green + "," + this.lowerLimitColor.blue);
                properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_UPPER_LIMIT_COLOR.value(), this.upperLimitColor.red + "," + this.upperLimitColor.green + "," + this.upperLimitColor.blue);
                properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value(), this.extrudeButton.getSelection() ? "true" : "false");
                properties.setProperty(MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value(), this.randomColorButton.getSelection() ? "true" : "false");
                object.save();
            }
        } else {
            Integer activeChannelNumber = this.application.getActiveChannelNumber();
            Integer measurementOrdinal = this.device.getGPS2KMZMeasurementOrdinal();
            if (activeChannelNumber != null && measurementOrdinal != null) {
                if (this.avgLimitFactor >= 1.0) {
                    this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value(), DataTypes.DOUBLE, (Object)this.avgLimitFactor);
                    this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value(), DataTypes.INTEGER, null);
                    this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value(), DataTypes.INTEGER, null);
                } else {
                    this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_AVG_LIMIT_FACTOR.value(), DataTypes.DOUBLE, null);
                    this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_LOWER_LIMIT.value(), DataTypes.INTEGER, (Object)this.lowerLimitVelocity);
                    this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_VELOCITY_UPPER_LIMIT.value(), DataTypes.INTEGER, (Object)this.upperLimitVelocity);
                }
                this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_WITHIN_LIMITS_COLOR.value(), DataTypes.STRING, (Object)(this.withinLimitsColor.red + "," + this.withinLimitsColor.green + "," + this.withinLimitsColor.blue));
                this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_LOWER_LIMIT_COLOR.value(), DataTypes.STRING, (Object)(this.lowerLimitColor.red + "," + this.lowerLimitColor.green + "," + this.lowerLimitColor.blue));
                this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_UPPER_LIMIT_COLOR.value(), DataTypes.STRING, (Object)(this.upperLimitColor.red + "," + this.upperLimitColor.green + "," + this.upperLimitColor.blue));
                this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_IS_EXTRUDE.value(), DataTypes.BOOLEAN, (Object)(this.extrudeButton.getSelection() ? "true" : "false"));
                this.device.setMeasurementPropertyValue(activeChannelNumber, (int)measurementOrdinal, MeasurementPropertyTypes.GOOGLE_EARTH_IS_RANDOM_COLOR.value(), DataTypes.BOOLEAN, (Object)(this.randomColorButton.getSelection() ? "true" : "false"));
            }
            this.device.storeDeviceProperties();
        }
    }
}

