/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.settlements;

import gde.Analyzer;
import gde.config.Settings;
import gde.data.Record;
import gde.device.AmountTypes;
import gde.device.CalculusTypes;
import gde.device.ChannelPropertyType;
import gde.device.ChannelPropertyTypes;
import gde.device.ChannelType;
import gde.device.DeltaBasisTypes;
import gde.device.EvaluationType;
import gde.device.FigureTypes;
import gde.device.IDevice;
import gde.device.LevelingTypes;
import gde.device.TransitionAmountType;
import gde.device.TransitionCalculusType;
import gde.device.TransitionFigureType;
import gde.histo.settlements.RecordGroup;
import gde.histo.settlements.SettlementRecord;
import gde.histo.transitions.Transition;
import gde.histo.utils.SingleResponseRegression;
import gde.histo.utils.UniversalQuantile;
import gde.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;

@Deprecated
public final class SettlementCollector {
    private static final String $CLASS_NAME = SettlementCollector.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final Analyzer analyzer;
    private final Settings settings;

    public SettlementCollector(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.settings = analyzer.getSettings();
    }

    public synchronized void addFromTransitions(SettlementRecord histoSettlement, Collection<Transition> transitions) {
        EvaluationType evaluation = histoSettlement.getSettlement().getEvaluation();
        for (Transition transition : transitions) {
            if (evaluation.getTransitionFigure() != null) {
                this.addFigure(histoSettlement, transition);
                continue;
            }
            if (evaluation.getTransitionAmount() != null) {
                this.addAmount(histoSettlement, transition);
                continue;
            }
            if (evaluation.getTransitionCalculus() != null) {
                this.addCalculus(histoSettlement, transition);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    private void addFigure(SettlementRecord histoSettlement, Transition transition) {
        int reverseTranslatedResult;
        TransitionFigureType transitionFigure = histoSettlement.getSettlement().getEvaluation().getTransitionFigure();
        log.log(Level.FINE, ">", transitionFigure);
        if (transitionFigure.getFigureType() == FigureTypes.COUNT) {
            reverseTranslatedResult = transition.getThresholdSize() * 1000;
        } else if (transitionFigure.getFigureType() == FigureTypes.TIME_SUM_SEC) {
            reverseTranslatedResult = (int)(histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1) - histoSettlement.getParent().getTime_ms(transition.getThresholdStartIndex()));
        } else if (transitionFigure.getFigureType() == FigureTypes.TIME_STEP_SEC) {
            reverseTranslatedResult = (int)histoSettlement.getParent().getTime_ms(transition.getThresholdStartIndex());
        } else {
            boolean reverseTranslatedResult2 = false;
            throw new UnsupportedOperationException();
        }
        histoSettlement.add((Integer)reverseTranslatedResult, transition);
        log.fine(() -> String.format("%s: timeStamp_ms=%d  reverseTranslatedResult=%d  figureType=%s", new Object[]{histoSettlement.getName(), (int)histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1), reverseTranslatedResult, transitionFigure.getFigureType()}));
    }

    private void addAmount(SettlementRecord histoSettlement, Transition transition) {
        int reverseTranslatedResult;
        IDevice device = this.analyzer.getActiveDevice();
        TransitionAmountType transitionAmount = histoSettlement.getSettlement().getEvaluation().getTransitionAmount();
        log.log(Level.FINE, ">", transitionAmount);
        Record record = histoSettlement.getParent().get(histoSettlement.getParent().getRecordNames()[transitionAmount.getRefOrdinal()]);
        log.fine(() -> record.getName() + " values   " + record.subList(transition.getReferenceStartIndex(), transition.getThresholdEndIndex() + 1));
        if (transitionAmount.getAmountType() == AmountTypes.MIN) {
            double min = Double.MAX_VALUE;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) == null) continue;
                min = Math.min(min, transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0));
            }
            reverseTranslatedResult = (int)(histoSettlement.reverseTranslateValue(min) * 1000.0);
        } else if (transitionAmount.getAmountType() == AmountTypes.MAX) {
            double max = transitionAmount.isUnsigned() ? 0.0 : -1.7976931348623157E308;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) == null) continue;
                max = Math.max(max, transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0));
            }
            reverseTranslatedResult = (int)(histoSettlement.reverseTranslateValue(max) * 1000.0);
        } else if (transitionAmount.getAmountType() == AmountTypes.AVG) {
            double avg = 0.0;
            double value = 0.0;
            int skipCount = 0;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) != null) {
                    value = transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0);
                    double deltaAvg = value - avg;
                    avg += deltaAvg / (double)(j - transition.getThresholdStartIndex() - skipCount + 1);
                    continue;
                }
                ++skipCount;
            }
            reverseTranslatedResult = (int)(histoSettlement.reverseTranslateValue(avg) * 1000.0);
        } else if (transitionAmount.getAmountType() == AmountTypes.SIGMA) {
            double avg = 0.0;
            double q = 0.0;
            double value = 0.0;
            int skipCount = 0;
            for (int j = transition.getThresholdStartIndex(); j < transition.getThresholdEndIndex() + 1; ++j) {
                if (record.elementAt(j) != null) {
                    value = transitionAmount.isUnsigned() ? Math.abs(device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0)) : device.translateValue(record, (double)((Integer)record.elementAt(j)).intValue() / 1000.0);
                    double deltaAvg = value - avg;
                    q += deltaAvg * (value - (avg += deltaAvg / (double)(j - transition.getThresholdStartIndex() - skipCount + 1)));
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, String.format("value=%f  deltaAvg=%f  q=%f", value, deltaAvg, q));
                    continue;
                }
                ++skipCount;
            }
            reverseTranslatedResult = (int)(histoSettlement.reverseTranslateValue(Math.sqrt(q / (double)(transition.getThresholdSize() - skipCount - 1))) * 1000.0);
        } else {
            boolean reverseTranslatedResult2 = false;
            throw new UnsupportedOperationException();
        }
        histoSettlement.add((Integer)reverseTranslatedResult, transition);
        log.fine(() -> String.format("%s: timeStamp_ms=%d  reverseTranslatedResult=%d  amountType=%s", new Object[]{histoSettlement.getName(), (int)histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1), reverseTranslatedResult, transitionAmount.getAmountType()}));
    }

    private void addCalculus(SettlementRecord histoSettlement, Transition transition) {
        TransitionCalculusType calculus = histoSettlement.getSettlement().getEvaluation().getTransitionCalculus();
        log.log(Level.FINEST, ">", calculus);
        ChannelType logChannel = this.analyzer.getActiveDevice().getDeviceConfiguration().getChannel(histoSettlement.getLogChannelNumber());
        RecordGroup recordGroup = new RecordGroup(histoSettlement, logChannel.getReferenceGroupById(calculus.getReferenceGroupId()), this.analyzer);
        if (recordGroup.hasReasonableData()) {
            boolean isNeglectableRatioValue;
            int reverseTranslatedResult;
            double deltaValue;
            if (calculus.getCalculusType() == CalculusTypes.DELTA) {
                deltaValue = this.calculateLevelDelta(recordGroup, calculus.getDeltaBasis(), calculus.getLeveling(), transition);
                reverseTranslatedResult = (int)(histoSettlement.reverseTranslateValue(calculus.isUnsigned() ? Math.abs(deltaValue) : deltaValue) * 1000.0);
            } else if (calculus.getCalculusType() == CalculusTypes.DELTA_PERMILLE) {
                deltaValue = this.calculateLevelDelta(recordGroup, calculus.getDeltaBasis(), calculus.getLeveling(), transition);
                reverseTranslatedResult = (int)(histoSettlement.reverseTranslateValue(calculus.isUnsigned() ? Math.abs(deltaValue) : deltaValue) * 1000.0 * 1000.0);
            } else if (calculus.getCalculusType() == CalculusTypes.RELATIVE_DELTA_PERCENT) {
                double relativeDeltaValue = this.calculateLevelDelta(recordGroup, calculus.getDeltaBasis(), calculus.getLeveling(), transition) / (recordGroup.getRealMax() - recordGroup.getRealMin());
                reverseTranslatedResult = (int)(calculus.isUnsigned() ? Math.abs(relativeDeltaValue) * 1000.0 * 100.0 : relativeDeltaValue * 1000.0 * 100.0);
            } else if (calculus.getCalculusType() == CalculusTypes.RATIO || calculus.getCalculusType() == CalculusTypes.RATIO_PERMILLE) {
                double denominator = this.calculateLevelDelta(recordGroup, calculus.getDeltaBasis(), calculus.getLeveling(), transition);
                RecordGroup divisorRecordGroup = new RecordGroup(histoSettlement, logChannel.getReferenceGroupById(calculus.getReferenceGroupIdDivisor()), this.analyzer);
                if (!divisorRecordGroup.hasReasonableData()) {
                    return;
                }
                double divisor = this.calculateLevelDelta(divisorRecordGroup, calculus.getDeltaBasis(), calculus.getDivisorLeveling(), transition);
                log.finer(() -> recordGroup.getComment() + " denominator " + denominator + " divisor " + divisor);
                reverseTranslatedResult = calculus.getCalculusType() == CalculusTypes.RATIO ? (int)(calculus.isUnsigned() ? Math.abs(denominator / divisor * 1000.0) : denominator / divisor * 1000.0) : (int)(calculus.isUnsigned() ? Math.abs(denominator / divisor * 1000.0 * 1000.0) : denominator / divisor * 1000.0 * 1000.0);
            } else {
                boolean reverseTranslatedResult2 = false;
                throw new UnsupportedOperationException();
            }
            boolean bl = isNeglectableRatioValue = recordGroup.getSize() > 1 && (double)reverseTranslatedResult == 0.0 && (calculus.getCalculusType() == CalculusTypes.RATIO || calculus.getCalculusType() == CalculusTypes.RATIO_PERMILLE);
            if (!isNeglectableRatioValue) {
                histoSettlement.add((Integer)reverseTranslatedResult, transition);
            }
            log.fine(() -> String.format("%s: timeStamp_ms=%d  reverseTranslatedResult=%d  calcType=%s", new Object[]{histoSettlement.getName(), (int)histoSettlement.getParent().getTime_ms(transition.getThresholdEndIndex() + 1), reverseTranslatedResult, calculus.getCalculusType()}));
        }
    }

    private double calculateLevelDelta(RecordGroup recordGroup, DeltaBasisTypes deltaBasis, LevelingTypes leveling, Transition transition) {
        double deltaValue = 0.0;
        IDevice device = this.analyzer.getActiveDevice();
        boolean isPositiveDirection = SettlementCollector.isPositiveTransition(recordGroup, transition);
        double referenceExtremum = 0.0;
        double thresholdExtremum = 0.0;
        double recoveryExtremum = 0.0;
        if (leveling == LevelingTypes.FIRST) {
            Double aggregatedValue;
            int j;
            for (j = transition.getReferenceStartIndex(); j < transition.getReferenceEndIndex() + 1; ++j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                referenceExtremum = aggregatedValue;
                break;
            }
            for (j = transition.getThresholdStartIndex() - 1; j < transition.getThresholdEndIndex() + 1 + 1; ++j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                thresholdExtremum = aggregatedValue;
                break;
            }
            if (transition.getRecoveryStartIndex() > 0) {
                for (j = transition.getRecoveryStartIndex(); j < transition.getRecoveryEndIndex() + 1; ++j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue == null) continue;
                    recoveryExtremum = aggregatedValue;
                    break;
                }
            }
        } else if (leveling == LevelingTypes.LAST) {
            Double aggregatedValue;
            int j;
            for (j = transition.getReferenceEndIndex(); j >= transition.getReferenceStartIndex(); --j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                referenceExtremum = aggregatedValue;
                break;
            }
            for (j = transition.getThresholdEndIndex() + 1; j >= transition.getThresholdStartIndex() - 1; --j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                thresholdExtremum = aggregatedValue;
                break;
            }
            if (transition.getRecoveryStartIndex() > 0) {
                for (j = transition.getRecoveryEndIndex(); j >= transition.getRecoveryStartIndex(); --j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue == null) continue;
                    recoveryExtremum = aggregatedValue;
                    break;
                }
            }
        } else if (leveling == LevelingTypes.MID) {
            Double aggregatedValue;
            int j;
            int i;
            int midIndex;
            if (transition.getReferenceSize() > 1) {
                i = midIndex = (transition.getReferenceStartIndex() + transition.getReferenceEndIndex()) / 2;
                for (j = midIndex + 1; i <= transition.getReferenceEndIndex() && j >= transition.getReferenceStartIndex(); ++i, --j) {
                    aggregatedValue = recordGroup.getReal(i);
                    if (aggregatedValue != null) {
                        referenceExtremum = aggregatedValue;
                    } else {
                        aggregatedValue = recordGroup.getReal(j);
                        if (aggregatedValue == null) continue;
                        referenceExtremum = aggregatedValue;
                    }
                    break;
                }
            } else {
                referenceExtremum = recordGroup.getReal(transition.getReferenceStartIndex());
            }
            if (transition.getThresholdSize() > 1) {
                i = midIndex = (transition.getThresholdStartIndex() + transition.getThresholdEndIndex()) / 2;
                for (j = midIndex; i <= transition.getThresholdEndIndex() && j >= transition.getThresholdStartIndex(); --j) {
                    aggregatedValue = recordGroup.getReal(i);
                    if (aggregatedValue != null) {
                        thresholdExtremum = aggregatedValue;
                    } else {
                        aggregatedValue = recordGroup.getReal(j);
                        if (aggregatedValue == null) continue;
                        thresholdExtremum = aggregatedValue;
                    }
                    break;
                }
            } else {
                thresholdExtremum = recordGroup.getReal(transition.getThresholdStartIndex());
            }
            if (transition.getRecoveryStartIndex() > 0) {
                if (transition.getRecoverySize() > 1) {
                    i = midIndex = (transition.getRecoveryStartIndex() + transition.getRecoveryEndIndex()) / 2;
                    for (j = midIndex; i <= transition.getRecoveryEndIndex() && j >= transition.getRecoveryStartIndex(); --j) {
                        aggregatedValue = recordGroup.getReal(i);
                        if (aggregatedValue != null) {
                            recoveryExtremum = aggregatedValue;
                        } else {
                            aggregatedValue = recordGroup.getReal(j);
                            if (aggregatedValue == null) continue;
                            recoveryExtremum = aggregatedValue;
                        }
                        break;
                    }
                } else {
                    recoveryExtremum = recordGroup.getReal(transition.getRecoveryStartIndex());
                }
            }
        } else if (leveling == LevelingTypes.AVG) {
            Double aggregatedValue;
            int j;
            double value = 0.0;
            int skipCount = 0;
            for (j = transition.getReferenceStartIndex(); j < transition.getReferenceEndIndex() + 1; ++j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue != null) {
                    value += (aggregatedValue - value) / (double)(j - transition.getReferenceStartIndex() + 1);
                    continue;
                }
                ++skipCount;
            }
            referenceExtremum = value / (double)(transition.getReferenceSize() - skipCount);
            value = 0.0;
            skipCount = 0;
            for (j = transition.getThresholdStartIndex() - 1; j < transition.getThresholdEndIndex() + 1 + 1; ++j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue != null) {
                    value += (aggregatedValue - value) / (double)(j - transition.getThresholdStartIndex() + 1);
                    continue;
                }
                ++skipCount;
            }
            thresholdExtremum = value / (double)(transition.getThresholdSize() - skipCount);
            if (transition.getRecoveryStartIndex() > 0) {
                value = 0.0;
                skipCount = 0;
                for (j = transition.getRecoveryStartIndex(); j < transition.getRecoveryEndIndex() + 1; ++j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue != null) {
                        value += (aggregatedValue - value) / (double)(j - transition.getRecoveryStartIndex() + 1);
                        continue;
                    }
                    ++skipCount;
                }
                recoveryExtremum = value / (double)(transition.getRecoverySize() - skipCount);
            }
        } else if (leveling == LevelingTypes.MINMAX) {
            if (isPositiveDirection) {
                Double aggregatedValue;
                int j;
                referenceExtremum = Double.MAX_VALUE;
                for (j = transition.getReferenceStartIndex(); j < transition.getReferenceEndIndex() + 1; ++j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue < referenceExtremum)) continue;
                    referenceExtremum = aggregatedValue;
                }
                thresholdExtremum = -1.7976931348623157E308;
                for (j = transition.getThresholdStartIndex() - 1; j < transition.getThresholdEndIndex() + 1 + 1; ++j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue > thresholdExtremum)) continue;
                    thresholdExtremum = aggregatedValue;
                }
                if (transition.getRecoveryStartIndex() > 0) {
                    recoveryExtremum = Double.MAX_VALUE;
                    for (j = transition.getRecoveryStartIndex(); j < transition.getRecoveryEndIndex() + 1; ++j) {
                        aggregatedValue = recordGroup.getReal(j);
                        if (aggregatedValue == null || !(aggregatedValue < recoveryExtremum)) continue;
                        recoveryExtremum = aggregatedValue;
                    }
                }
            } else {
                Double aggregatedValue;
                int j;
                referenceExtremum = -1.7976931348623157E308;
                for (j = transition.getReferenceStartIndex(); j < transition.getReferenceEndIndex() + 1; ++j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue > referenceExtremum)) continue;
                    referenceExtremum = aggregatedValue;
                }
                thresholdExtremum = Double.MAX_VALUE;
                for (j = transition.getThresholdStartIndex() - 1; j < transition.getThresholdEndIndex() + 1 + 1; ++j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue == null || !(aggregatedValue < thresholdExtremum)) continue;
                    thresholdExtremum = aggregatedValue;
                }
                if (transition.getRecoveryStartIndex() > 0) {
                    recoveryExtremum = -1.7976931348623157E308;
                    for (j = transition.getRecoveryStartIndex(); j < transition.getRecoveryEndIndex() + 1; ++j) {
                        aggregatedValue = recordGroup.getReal(j);
                        if (aggregatedValue == null || !(aggregatedValue > recoveryExtremum)) continue;
                        recoveryExtremum = aggregatedValue;
                    }
                }
            }
        } else if (leveling == LevelingTypes.SMOOTH_MINMAX) {
            Double aggregatedValue;
            ChannelPropertyType channelProperty = device.getDeviceConfiguration().getChannelProperty(ChannelPropertyTypes.OUTLIER_SIGMA);
            double sigmaFactor = channelProperty.getValue() != null && !channelProperty.getValue().isEmpty() ? Double.parseDouble(channelProperty.getValue()) : 3.0;
            ChannelPropertyType channelProperty2 = device.getDeviceConfiguration().getChannelProperty(ChannelPropertyTypes.OUTLIER_RANGE_FACTOR);
            double outlierFactor = channelProperty2.getValue() != null && !channelProperty2.getValue().isEmpty() ? Double.parseDouble(channelProperty2.getValue()) : 2.0;
            double probabilityCutPoint = !isPositiveDirection ? 1.0 - this.settings.getMinmaxQuantileDistance() : this.settings.getMinmaxQuantileDistance();
            ArrayList<Double> values = new ArrayList<Double>();
            for (int j = transition.getReferenceStartIndex(); j < transition.getReferenceEndIndex() + 1; ++j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                values.add(aggregatedValue);
            }
            UniversalQuantile tmpQuantile = new UniversalQuantile(values, true, sigmaFactor, outlierFactor, this.settings);
            referenceExtremum = tmpQuantile.getQuantile(probabilityCutPoint);
            log.fine(() -> "reference " + Arrays.toString(values.toArray()));
            values = new ArrayList();
            for (int j = transition.getThresholdStartIndex() - 1; j < transition.getThresholdEndIndex() + 1 + 1; ++j) {
                aggregatedValue = recordGroup.getReal(j);
                if (aggregatedValue == null) continue;
                values.add(aggregatedValue);
            }
            tmpQuantile = new UniversalQuantile(values, true, sigmaFactor, outlierFactor, this.settings);
            referenceExtremum = tmpQuantile.getQuantile(probabilityCutPoint);
            thresholdExtremum = tmpQuantile.getQuantile(isPositiveDirection ? 1.0 - this.settings.getMinmaxQuantileDistance() : this.settings.getMinmaxQuantileDistance());
            log.fine(() -> "threshold " + Arrays.toString(values.toArray()));
            if (transition.getRecoveryStartIndex() > 0) {
                values = new ArrayList();
                for (int j = transition.getRecoveryStartIndex(); j < transition.getRecoveryEndIndex() + 1; ++j) {
                    aggregatedValue = recordGroup.getReal(j);
                    if (aggregatedValue == null) continue;
                    values.add(aggregatedValue);
                }
                tmpQuantile = new UniversalQuantile(values, true, sigmaFactor, outlierFactor, this.settings);
                referenceExtremum = tmpQuantile.getQuantile(probabilityCutPoint);
                recoveryExtremum = tmpQuantile.getQuantile(probabilityCutPoint);
                log.fine(() -> "recovery " + Arrays.toString(values.toArray()));
            }
        } else {
            throw new UnsupportedOperationException();
        }
        if (transition.isSlope() || deltaBasis == null || deltaBasis == DeltaBasisTypes.REFERENCE) {
            deltaValue = thresholdExtremum - referenceExtremum;
        } else if (deltaBasis == DeltaBasisTypes.RECOVERY) {
            deltaValue = thresholdExtremum - recoveryExtremum;
        } else if (deltaBasis == DeltaBasisTypes.BOTH_AVG) {
            deltaValue = thresholdExtremum - (referenceExtremum + recoveryExtremum) / 2.0;
        } else if (deltaBasis == DeltaBasisTypes.INNER) {
            deltaValue = isPositiveDirection ? thresholdExtremum - Math.max(referenceExtremum, recoveryExtremum) : thresholdExtremum - Math.min(referenceExtremum, recoveryExtremum);
        } else if (deltaBasis == DeltaBasisTypes.OUTER) {
            deltaValue = isPositiveDirection ? thresholdExtremum - Math.min(referenceExtremum, recoveryExtremum) : thresholdExtremum - Math.max(referenceExtremum, recoveryExtremum);
        } else {
            throw new UnsupportedOperationException();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("%s %s referenceExtremum=%f  thresholdExtremum=%f  recoveryExtremum=%f  deltaValue=%f  @ isBasedOnRecovery=%s", new Object[]{recordGroup.getComment(), leveling.value(), referenceExtremum, thresholdExtremum, recoveryExtremum, deltaValue, deltaBasis}));
        }
        return deltaValue;
    }

    private static boolean isPositiveTransition(RecordGroup recordGroup, Transition transition) {
        boolean isPositiveDirection;
        if (transition.isSlope()) {
            int toIndex;
            int fromIndex = transition.getReferenceStartIndex();
            SingleResponseRegression regression = new SingleResponseRegression(recordGroup.getSubPoints(fromIndex, toIndex = transition.getThresholdEndIndex() + 1), SingleResponseRegression.RegressionType.LINEAR);
            isPositiveDirection = regression.getSlope() > 0.0;
        } else {
            int toIndex;
            int fromIndex = transition.getReferenceStartIndex();
            SingleResponseRegression regression = new SingleResponseRegression(recordGroup.getSubPoints(fromIndex, toIndex = transition.getRecoveryEndIndex() + 1), SingleResponseRegression.RegressionType.QUADRATIC);
            boolean bl = isPositiveDirection = regression.getGamma() < 0.0;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "direction: ", isPositiveDirection);
        }
        return isPositiveDirection;
    }
}

