/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.cache;

import gde.Analyzer;
import gde.DataAccess;
import gde.config.Settings;
import gde.data.IRecord;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IChannelItem;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.ScoreLabelTypes;
import gde.device.SettlementType;
import gde.device.StatisticsType;
import gde.device.TrailTypes;
import gde.device.TransitionAmountType;
import gde.device.TransitionCalculusType;
import gde.device.TransitionFigureType;
import gde.histo.cache.CompartmentType;
import gde.histo.cache.DataTypes;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.PointType;
import gde.histo.datasources.HistoSet;
import gde.histo.datasources.SourceDataSet;
import gde.histo.device.IHistoDevice;
import gde.histo.settlements.AmountEvaluator;
import gde.histo.settlements.CalculusEvaluator;
import gde.histo.settlements.FigureEvaluator;
import gde.histo.settlements.SettlementRecord;
import gde.histo.transitions.GroupTransitions;
import gde.histo.transitions.Transition;
import gde.histo.transitions.TransitionCollector;
import gde.histo.transitions.TransitionTableMapper;
import gde.histo.utils.UniversalQuantile;
import gde.log.Logger;
import java.nio.file.Path;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class VaultCollector {
    private static final String $CLASS_NAME = VaultCollector.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final Analyzer analyzer;
    private ExtendedVault vault;
    private SourceDataSet sourceDataSet;

    public VaultCollector(String objectDirectory, Path sourcePath, int fileVersion, int logRecordSetSize, String logRecordsetBaseName, Analyzer analyzer, boolean providesReaderSettings) {
        this(objectDirectory, sourcePath, fileVersion, logRecordSetSize, 0, logRecordsetBaseName, analyzer.getActiveDevice().getName(), analyzer, analyzer.getDataAccess().getSourceLastModified(sourcePath), analyzer.getActiveChannel().getNumber(), objectDirectory, providesReaderSettings);
    }

    public VaultCollector(Analyzer analyzer, String objectDirectory, Path sourcePath, int fileVersion, int logRecordSetSize, int logRecordSetOrdinal, String logRecordsetBaseName, String logDeviceName, long logStartTimestamp_ms, int logChannelNumber, String logObjectKey) {
        this(objectDirectory, sourcePath, fileVersion, logRecordSetSize, logRecordSetOrdinal, logRecordsetBaseName, logDeviceName, analyzer, logStartTimestamp_ms, logChannelNumber, objectDirectory, false);
    }

    private VaultCollector(String objectDirectory, Path sourcePath, int fileVersion, int logRecordSetSize, int logRecordSetOrdinal, String logRecordsetBaseName, String logDeviceName, Analyzer analyzer, long logStartTimestamp_ms, int logChannelNumber, String logObjectKey, boolean providesReaderSettings) {
        this.analyzer = analyzer;
        String readerSettings = providesReaderSettings && analyzer.getActiveDevice() instanceof IHistoDevice ? ((IHistoDevice)((Object)analyzer.getActiveDevice())).getReaderSettingsCsv() : "";
        DataAccess dataAccess = analyzer.getDataAccess();
        this.vault = new ExtendedVault(objectDirectory, sourcePath, dataAccess.getSourceLastModified(sourcePath), dataAccess.getSourceLength(sourcePath), fileVersion, logRecordSetSize, logRecordSetOrdinal, logRecordsetBaseName, logDeviceName, analyzer, logStartTimestamp_ms, logChannelNumber, logObjectKey, readerSettings);
    }

    public String toString() {
        return String.format("logChannelNumber=%d  logRecordSetOrdinal=%d  logObjectKey=%s  startTimestamp=%s  %s", this.vault.getLogChannelNumber(), this.vault.getLogRecordSetOrdinal(), this.vault.getLogObjectKey(), this.vault.getStartTimeStampFormatted(), this.vault.getLoadFilePath());
    }

    public void promoteTruss(RecordSet recordSet, Integer[] scorePoints) {
        if (recordSet.getRecordDataSize(true) > 0) {
            this.vault.logStartTimestamp_ms = recordSet.getStartTimeStamp();
            boolean isSampled = scorePoints[ScoreLabelTypes.TOTAL_READINGS.ordinal()] != null && scorePoints[ScoreLabelTypes.TOTAL_READINGS.ordinal()] > recordSet.getRecordDataSize(true);
            this.setMeasurementPoints(recordSet, isSampled);
            GroupTransitions transitions = new TransitionCollector(recordSet).defineTransitions(this.vault.logChannelNumber);
            TransitionTableMapper.SettlementRecords histoSettlements = this.determineSettlements(recordSet, transitions);
            this.setSettlements(histoSettlements);
            scorePoints[ScoreLabelTypes.DURATION_MM.ordinal()] = (int)(recordSet.getMaxTime_ms() / 60000.0 * 1000.0 + 0.5);
            scorePoints[ScoreLabelTypes.AVERAGE_TIME_STEP_MS.ordinal()] = (int)(recordSet.getAverageTimeStep_ms() * 1000.0);
            scorePoints[ScoreLabelTypes.MAXIMUM_TIME_STEP_MS.ordinal()] = (int)(recordSet.getMaximumTimeStep_ms() * 1000.0);
            scorePoints[ScoreLabelTypes.MINIMUM_TIME_STEP_MS.ordinal()] = (int)(recordSet.getMinimumTimeStep_ms() * 1000.0);
            scorePoints[ScoreLabelTypes.SIGMA_TIME_STEP_MS.ordinal()] = (int)(recordSet.getSigmaTimeStep_ms() * 1000.0);
            scorePoints[ScoreLabelTypes.SAMPLED_READINGS.ordinal()] = recordSet.getRecordDataSize(true);
            this.setScorePoints(scorePoints);
        }
    }

    private void setMeasurementPoints(RecordSet recordSet, boolean isSampled) {
        List<MeasurementType> channelMeasurements = this.analyzer.getActiveDevice().getChannelMeasuremts(this.vault.getLogChannelNumber());
        for (int i = 0; i < recordSet.getRecordNames().length; ++i) {
            MeasurementType measurementType = channelMeasurements.get(i);
            Record record = recordSet.get(recordSet.getRecordNames()[i]);
            CompartmentType entryPoints = new CompartmentType(i, measurementType.getName(), DataTypes.fromDataType(record.getDataType()));
            this.vault.getMeasurements().put(i, entryPoints);
            entryPoints.setTrails(new HashMap<Integer, PointType>());
            if (!record.hasReasonableData()) {
                log.fine(() -> String.format("no reasonable data for measurementType.getName()=%s %s", measurementType.getName(), this.vault.getLoadFilePath()));
            } else {
                if (measurementType.getStatistics() != null) {
                    this.setTrailStatisticsPoints(entryPoints, record, recordSet);
                }
                this.setTrailPoints(entryPoints, record, isSampled);
            }
            log.finer(() -> record.getName() + " data " + entryPoints);
        }
    }

    private TransitionTableMapper.SettlementRecords determineSettlements(RecordSet recordSet, GroupTransitions transitions) {
        TransitionTableMapper.SettlementRecords histoSettlements = new TransitionTableMapper.SettlementRecords();
        for (SettlementType settlementType : this.analyzer.getActiveDevice().getDeviceConfiguration().getChannel(this.vault.logChannelNumber).getSettlements().values()) {
            Object evaluator;
            if (settlementType.getEvaluation() == null) continue;
            SettlementRecord record = new SettlementRecord(settlementType, recordSet, this.vault.logChannelNumber);
            histoSettlements.put(settlementType.getName(), record);
            if (transitions.isEmpty()) continue;
            TransitionFigureType transitionFigureType = settlementType.getEvaluation().getTransitionFigure();
            TransitionAmountType transitionAmountType = settlementType.getEvaluation().getTransitionAmount();
            TransitionCalculusType calculationType = settlementType.getEvaluation().getTransitionCalculus();
            if (transitionFigureType != null) {
                evaluator = new FigureEvaluator(record);
                for (Transition transition : transitions.get(transitionFigureType.getTransitionGroupId()).values()) {
                    ((FigureEvaluator)evaluator).addFromTransition(transition);
                }
                continue;
            }
            if (transitionAmountType != null) {
                evaluator = new AmountEvaluator(record, this.analyzer);
                for (Transition transition : transitions.get(transitionAmountType.getTransitionGroupId()).values()) {
                    ((AmountEvaluator)evaluator).addFromTransition(transition);
                }
                continue;
            }
            if (calculationType != null) {
                evaluator = new CalculusEvaluator(record, this.analyzer);
                for (Transition transition : transitions.get(calculationType.getTransitionGroupId()).values()) {
                    ((CalculusEvaluator)evaluator).addFromTransition(transition);
                }
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return histoSettlements;
    }

    private void setTrailStatisticsPoints(CompartmentType entryPoints, Record record, RecordSet recordSet) {
        boolean isTriggerLevel;
        IDevice device = this.analyzer.getActiveDevice();
        StatisticsType measurementStatistics = device.getChannelMeasuremts(this.vault.getLogChannelNumber()).get(record.getOrdinal()).getStatistics();
        int triggerRefOrdinal = -1;
        if (measurementStatistics == null) {
            log.log(Level.SEVERE, "===>> check corrupt file related to: " + recordSet.getDescription());
        }
        if (measurementStatistics.getTriggerRefOrdinal() != null) {
            int tmpOrdinal;
            triggerRefOrdinal = tmpOrdinal = measurementStatistics.getTriggerRefOrdinal().intValue();
        }
        boolean bl = isTriggerLevel = measurementStatistics.getTrigger() != null;
        if (measurementStatistics.isAvg()) {
            if (isTriggerLevel) {
                int dd = record.getAvgValueTriggered() != Integer.MIN_VALUE ? record.getAvgValueTriggered() : 0;
                entryPoints.addPoint(TrailTypes.REAL_AVG, this.transmuteValue(record, dd));
            } else if (triggerRefOrdinal < 0) {
                entryPoints.addPoint(TrailTypes.REAL_AVG, this.transmuteValue(record, record.getAvgValue()));
            } else if (record.getAvgValueTriggered(triggerRefOrdinal) != Integer.MIN_VALUE) {
                entryPoints.addPoint(TrailTypes.REAL_AVG, this.transmuteValue(record, record.getAvgValueTriggered(triggerRefOrdinal)));
            }
        } else {
            entryPoints.addPoint(TrailTypes.REAL_AVG, this.transmuteValue(record, record.getAvgValue()));
        }
        if (measurementStatistics.isMax()) {
            if (isTriggerLevel) {
                entryPoints.addPoint(TrailTypes.REAL_MAX, this.transmuteValue(record, record.getMaxValueTriggered()));
            } else if (triggerRefOrdinal < 0) {
                entryPoints.addPoint(TrailTypes.REAL_MAX, this.transmuteValue(record, record.getRealMaxValue()));
            } else if (record.getMaxValueTriggered(triggerRefOrdinal) != Integer.MIN_VALUE) {
                entryPoints.addPoint(TrailTypes.REAL_MAX, this.transmuteValue(record, record.getMaxValueTriggered(triggerRefOrdinal)));
            }
        } else {
            entryPoints.addPoint(TrailTypes.REAL_MAX, this.transmuteValue(record, record.getRealMaxValue()));
        }
        if (measurementStatistics.isMin()) {
            if (isTriggerLevel) {
                entryPoints.addPoint(TrailTypes.REAL_MIN, this.transmuteValue(record, record.getMinValueTriggered()));
            } else if (triggerRefOrdinal < 0) {
                entryPoints.addPoint(TrailTypes.REAL_MIN, this.transmuteValue(record, record.getRealMinValue()));
            } else if (record.getMinValueTriggered(triggerRefOrdinal) != Integer.MAX_VALUE) {
                entryPoints.addPoint(TrailTypes.REAL_MIN, this.transmuteValue(record, record.getMinValueTriggered(triggerRefOrdinal)));
            }
        } else {
            entryPoints.addPoint(TrailTypes.REAL_MIN, this.transmuteValue(record, record.getRealMinValue()));
        }
        if (measurementStatistics.isSigma()) {
            if (isTriggerLevel) {
                entryPoints.addPoint(TrailTypes.REAL_SD, this.transmuteDelta(record, record.getSigmaValueTriggered()));
            } else if (triggerRefOrdinal < 0) {
                entryPoints.addPoint(TrailTypes.REAL_SD, this.transmuteDelta(record, record.getSigmaValue()));
            } else if (record.getSigmaValueTriggered(triggerRefOrdinal) != Integer.MIN_VALUE) {
                entryPoints.addPoint(TrailTypes.REAL_SD, this.transmuteDelta(record, record.getSigmaValueTriggered(triggerRefOrdinal)));
            }
        } else {
            entryPoints.addPoint(TrailTypes.REAL_SD, this.transmuteDelta(record, record.getSigmaValue()));
        }
        Integer refOrdinal = measurementStatistics.getSumByTriggerRefOrdinal();
        Integer refSecondaryOrdinal = measurementStatistics.getSumBySecondaryTriggerRefOrdinal();
        if (refOrdinal != null) {
            Record referencedRecord;
            Integer ratioRefOrdinal;
            int referencedSumTriggeredRange = refSecondaryOrdinal != null ? record.getSumTriggeredRange(refOrdinal, refSecondaryOrdinal) : record.getSumTriggeredRange(refOrdinal);
            double summarizedValue = device.translateDeltaValue(record, (double)referencedSumTriggeredRange / 1000.0);
            log.finer(() -> String.format("%s -> summarizedValue = %d", record.getName(), (int)summarizedValue));
            if (measurementStatistics.getSumTriggerText() != null && measurementStatistics.getSumTriggerText().length() > 1 && summarizedValue > 0.0) {
                if (isTriggerLevel) {
                    entryPoints.addPoint(TrailTypes.REAL_SUM_TRIGGERED, this.transmuteDelta(record, record.getSumTriggeredRange()));
                } else {
                    entryPoints.addPoint(TrailTypes.REAL_SUM_TRIGGERED, this.transmuteDelta(record, referencedSumTriggeredRange));
                }
            }
            if (summarizedValue > 0.0 && (ratioRefOrdinal = measurementStatistics.getRatioRefOrdinal()) != null && measurementStatistics.getRatioText() != null && measurementStatistics.getRatioText().length() > 1 && (referencedRecord = recordSet.get(ratioRefOrdinal)) != null) {
                double summarizedReferencedValue = device.translateDeltaValue(referencedRecord, (double)referencedRecord.getSumTriggeredRange(refOrdinal) / 1000.0);
                log.finer(() -> String.format("summarizedReferencedValue = %d, ratioRefOrdinal = %d", (int)summarizedReferencedValue, ratioRefOrdinal));
                if (summarizedReferencedValue > 0.0) {
                    double ratio = summarizedReferencedValue / summarizedValue;
                    entryPoints.addPoint(TrailTypes.REAL_MAX_RATIO_TRIGGERED, this.transmuteScalar(record, (int)(ratio * 1000.0)));
                }
            }
        }
        String sumTriggerTimeText = measurementStatistics.getSumTriggerTimeText();
        if (measurementStatistics.getTrigger() != null && sumTriggerTimeText != null && sumTriggerTimeText.length() > 1) {
            entryPoints.addPoint(TrailTypes.REAL_TIME_SUM_TRIGGERED, this.transmuteScalar(record, record.getTimeSumTriggeredRange_ms()));
        }
        if (measurementStatistics.isCountByTrigger() != null) {
            int countValue = record.getTriggerRanges() != null ? record.getTriggerRanges().size() : 0;
            entryPoints.addPoint(TrailTypes.REAL_COUNT_TRIGGERED, this.transmuteScalar(record, countValue * 1000));
        }
    }

    private int transmuteValue(Record record, int value) {
        return this.encodeValue(record.getChannelItem(), this.analyzer.getActiveDevice().translateValue(record, (double)value / 1000.0));
    }

    private int transmuteDelta(Record record, int deltaValue) {
        return this.encodeValue(record.getChannelItem(), this.analyzer.getActiveDevice().translateDeltaValue(record, (double)deltaValue / 1000.0));
    }

    private int transmuteScalar(Record record, int scalar) {
        return this.encodeValue(record.getChannelItem(), (double)scalar / 1000.0);
    }

    private void setTrailPoints(CompartmentType entryPoints, Record record, boolean isSampled) {
        UniversalQuantile<? extends Number> quantile;
        int rawBitwiseOr;
        int rawMax;
        IChannelItem channelItem = record.getChannelItem();
        Function<Double, Integer> encoder = value -> this.encodeValue(channelItem, (double)value);
        if (channelItem.isBits()) {
            UniversalQuantile<? extends Number> rawQuantile = Coding.BITS.toValueQuantile(record, this.analyzer.getSettings());
            rawMax = (int)Math.round(rawQuantile.getQuartile4());
            rawBitwiseOr = rawQuantile.getOrFigure();
            log.finer(() -> "isBits " + rawQuantile.getQuartile4() + "   " + rawQuantile.getOrFigure());
            quantile = Coding.BITS.toIndexQuantile(record, this.analyzer.getSettings());
        } else if (channelItem.isTokens()) {
            UniversalQuantile<? extends Number> rawQuantile = Coding.TOKENS.toValueQuantile(record, this.analyzer.getSettings());
            rawMax = (int)Math.round(rawQuantile.getQuartile4());
            rawBitwiseOr = rawQuantile.getOrFigure();
            log.finer(() -> "isToken " + rawQuantile.getQuartile4() + "   " + rawQuantile.getOrFigure());
            quantile = Coding.TOKENS.toIndexQuantile(record, this.analyzer.getSettings());
        } else {
            rawBitwiseOr = 0;
            rawMax = 0;
            quantile = Coding.POINT.toValueQuantile(record, this.analyzer.getSettings());
            if (!quantile.getOutliers().isEmpty()) {
                IntStream outliers = quantile.getOutliers().stream().distinct().mapToInt(v -> this.encodeValue(channelItem, v.doubleValue()));
                String outliersCsv = outliers.boxed().map(String::valueOf).collect(Collectors.joining(","));
                entryPoints.setOutlierPoints(outliersCsv);
            }
            if (!quantile.getConstantScraps().isEmpty()) {
                IntStream scraps = quantile.getConstantScraps().stream().distinct().mapToInt(v -> (Integer)encoder.apply(v.doubleValue()));
                String scrapsCsv = scraps.boxed().map(String::valueOf).collect(Collectors.joining(","));
                entryPoints.setScrappedPoints(scrapsCsv);
            }
        }
        entryPoints.addPoint(TrailTypes.RAW_BITS, rawBitwiseOr);
        entryPoints.addPoint(TrailTypes.RAW_MAX, rawMax);
        entryPoints.addPoint(TrailTypes.REAL_FIRST, this.transmuteValue(record, (Integer)record.elementAt(0)));
        entryPoints.addPoint(TrailTypes.REAL_LAST, this.transmuteValue(record, (Integer)record.elementAt(record.realSize() - 1)));
        entryPoints.addPoint(TrailTypes.AVG, encoder.apply(quantile.getAvgFigure()));
        entryPoints.addPoint(TrailTypes.MAX, encoder.apply(quantile.getPopulationMaxFigure()));
        entryPoints.addPoint(TrailTypes.MIN, encoder.apply(quantile.getPopulationMinFigure()));
        entryPoints.addPoint(TrailTypes.SD, encoder.apply(quantile.getSigmaFigure()));
        entryPoints.addPoint(TrailTypes.Q0, encoder.apply(quantile.getQuartile0()));
        entryPoints.addPoint(TrailTypes.Q1, encoder.apply(quantile.getQuartile1()));
        entryPoints.addPoint(TrailTypes.Q2, encoder.apply(quantile.getQuartile2()));
        entryPoints.addPoint(TrailTypes.Q3, encoder.apply(quantile.getQuartile3()));
        entryPoints.addPoint(TrailTypes.Q4, encoder.apply(quantile.getQuartile4()));
        entryPoints.addPoint(TrailTypes.Q_25_PERMILLE, encoder.apply(quantile.getQuantile(0.025)));
        entryPoints.addPoint(TrailTypes.Q_975_PERMILLE, encoder.apply(quantile.getQuantile(0.975)));
        entryPoints.addPoint(TrailTypes.Q_LOWER_WHISKER, encoder.apply(quantile.getQuantileLowerWhisker()));
        entryPoints.addPoint(TrailTypes.Q_UPPER_WHISKER, encoder.apply(quantile.getQuantileUpperWhisker()));
        entryPoints.addPoint(TrailTypes.FIRST, encoder.apply(quantile.getFirstFigure()));
        entryPoints.addPoint(TrailTypes.LAST, encoder.apply(quantile.getLastFigure()));
        entryPoints.addPoint(TrailTypes.SUM, 0);
        entryPoints.addPoint(TrailTypes.COUNT, encoder.apply(Double.valueOf(quantile.getSize())));
        entryPoints.addPoint(TrailTypes.REAL_COUNT, encoder.apply(Double.valueOf(record.realSize())));
    }

    private void setSettlements(TransitionTableMapper.SettlementRecords histoSettlements) {
        for (Map.Entry<String, SettlementRecord> entry : histoSettlements.entrySet()) {
            SettlementRecord record = entry.getValue();
            SettlementType settlementType = record.getSettlement();
            CompartmentType entryPoints = new CompartmentType(settlementType.getSettlementId(), settlementType.getName(), DataTypes.DEFAULT);
            this.vault.getSettlements().put(settlementType.getSettlementId(), entryPoints);
            entryPoints.setTrails(new HashMap<Integer, PointType>());
            if (record.realSize() != 0 && record.hasReasonableData()) {
                UniversalQuantile<Number> quantile;
                entryPoints.addPoint(TrailTypes.REAL_FIRST, (Integer)record.elementAt(0));
                entryPoints.addPoint(TrailTypes.REAL_LAST, (Integer)record.elementAt(record.realSize() - 1));
                Function<Double, Integer> encoder = value -> this.encodeValue(settlementType, (double)value);
                if (settlementType.isBits()) {
                    quantile = Coding.BITS.toIndexQuantile(record, this.analyzer.getSettings());
                } else if (settlementType.isTokens()) {
                    quantile = Coding.TOKENS.toIndexQuantile(record, this.analyzer.getSettings());
                } else {
                    quantile = Coding.POINT.toValueQuantile(record, this.analyzer.getSettings());
                    if (!quantile.getOutliers().isEmpty()) {
                        IntStream outliers = quantile.getOutliers().stream().distinct().mapToInt(v -> (Integer)encoder.apply(v.doubleValue()));
                        String outliersCsv = outliers.boxed().map(String::valueOf).collect(Collectors.joining(","));
                        entryPoints.setOutlierPoints(outliersCsv);
                    }
                    if (!quantile.getConstantScraps().isEmpty()) {
                        IntStream scraps = quantile.getConstantScraps().stream().distinct().mapToInt(v -> (Integer)encoder.apply(v.doubleValue()));
                        String scrapsCsv = scraps.boxed().map(String::valueOf).collect(Collectors.joining(","));
                        entryPoints.setScrappedPoints(scrapsCsv);
                    }
                }
                entryPoints.addPoint(TrailTypes.RAW_BITS, quantile.getOrFigure());
                entryPoints.addPoint(TrailTypes.REAL_AVG, encoder.apply(quantile.getAvgFigure()));
                entryPoints.addPoint(TrailTypes.REAL_MAX, encoder.apply(quantile.getPopulationMaxFigure()));
                entryPoints.addPoint(TrailTypes.REAL_MIN, encoder.apply(quantile.getPopulationMinFigure()));
                entryPoints.addPoint(TrailTypes.REAL_SD, encoder.apply(quantile.getSigmaFigure()));
                entryPoints.addPoint(TrailTypes.REAL_SUM, encoder.apply(quantile.getSumFigure()));
                entryPoints.addPoint(TrailTypes.REAL_COUNT, encoder.apply(Double.valueOf(quantile.getSize())));
                entryPoints.addPoint(TrailTypes.AVG, encoder.apply(quantile.getAvgFigure()));
                entryPoints.addPoint(TrailTypes.MAX, encoder.apply(quantile.getPopulationMaxFigure()));
                entryPoints.addPoint(TrailTypes.MIN, encoder.apply(quantile.getPopulationMinFigure()));
                entryPoints.addPoint(TrailTypes.SD, encoder.apply(quantile.getSigmaFigure()));
                entryPoints.addPoint(TrailTypes.Q0, encoder.apply(quantile.getQuartile0()));
                entryPoints.addPoint(TrailTypes.Q1, encoder.apply(quantile.getQuartile1()));
                entryPoints.addPoint(TrailTypes.Q2, encoder.apply(quantile.getQuartile2()));
                entryPoints.addPoint(TrailTypes.Q3, encoder.apply(quantile.getQuartile3()));
                entryPoints.addPoint(TrailTypes.Q4, encoder.apply(quantile.getQuartile4()));
                entryPoints.addPoint(TrailTypes.Q_25_PERMILLE, encoder.apply(quantile.getQuantile(0.025)));
                entryPoints.addPoint(TrailTypes.Q_975_PERMILLE, encoder.apply(quantile.getQuantile(0.975)));
                entryPoints.addPoint(TrailTypes.Q_LOWER_WHISKER, encoder.apply(quantile.getQuantileLowerWhisker()));
                entryPoints.addPoint(TrailTypes.Q_UPPER_WHISKER, encoder.apply(quantile.getQuantileUpperWhisker()));
                entryPoints.addPoint(TrailTypes.FIRST, encoder.apply(quantile.getFirstFigure()));
                entryPoints.addPoint(TrailTypes.LAST, encoder.apply(quantile.getLastFigure()));
                entryPoints.addPoint(TrailTypes.SUM, encoder.apply(quantile.getSumFigure()));
                entryPoints.addPoint(TrailTypes.COUNT, encoder.apply(Double.valueOf(quantile.getSize())));
            }
            log.finer(() -> record.getName() + " data " + this.vault.getSettlements());
        }
    }

    private void setScorePoints(Integer[] scorePoints) {
        for (ScoreLabelTypes scoreLabelTypes : EnumSet.allOf(ScoreLabelTypes.class)) {
            Integer scoreValue = scorePoints[scoreLabelTypes.ordinal()];
            if (scoreValue == null) continue;
            PointType pointType = new PointType(scoreLabelTypes.ordinal(), scoreLabelTypes.toString(), scoreValue);
            this.vault.getScores().put(scoreLabelTypes.ordinal(), pointType);
        }
        log.fine(() -> "scores " + this.vault.getScores());
    }

    private int encodeValue(IChannelItem channelItem, double value) {
        return (int)(HistoSet.encodeVaultValue(channelItem, value) * 1000.0);
    }

    public ExtendedVault getVault() {
        return this.vault;
    }

    public void setSourceDataSet(SourceDataSet sourceDataSet) {
        this.sourceDataSet = sourceDataSet;
    }

    public SourceDataSet getSourceDataSet() {
        return this.sourceDataSet;
    }

    private static enum Coding {
        BITS{

            @Override
            public UniversalQuantile<Integer> toIndexQuantile(IRecord record, Settings settings) {
                List bitIndexes = record.getValues().stream().map(p -> p / 1000).flatMap(v -> BitSet.valueOf(new long[]{v.intValue()}).stream().boxed()).collect(Collectors.toList());
                UniversalQuantile<Integer> quantile = new UniversalQuantile<Integer>(bitIndexes, true, false, false, settings);
                log.finer(() -> quantile.toString());
                return quantile;
            }

            @Override
            public UniversalQuantile<? extends Number> toValueQuantile(IRecord record, Settings settings) {
                List intValues = record.getValues().stream().map(p -> p / 1000).collect(Collectors.toList());
                UniversalQuantile quantile = new UniversalQuantile(intValues, true, false, false, settings);
                return quantile;
            }
        }
        ,
        TOKENS{

            @Override
            public UniversalQuantile<Integer> toIndexQuantile(IRecord record, Settings settings) {
                List bitIndexes = record.getValues().stream().map(p -> p / 1000).collect(Collectors.toList());
                UniversalQuantile<Integer> quantile = new UniversalQuantile<Integer>(bitIndexes, true, false, false, settings);
                log.finer(() -> quantile.toString());
                return quantile;
            }

            @Override
            public UniversalQuantile<? extends Number> toValueQuantile(IRecord record, Settings settings) {
                Function<Integer, Integer> indexToSetMapper = i -> {
                    if (i <= 0) {
                        return 1;
                    }
                    int idx = i & 0x1F;
                    return idx > 0 ? 1 << idx : 0;
                };
                List intValues = record.getValues().stream().map(p -> p / 1000).map(indexToSetMapper).collect(Collectors.toList());
                UniversalQuantile quantile = new UniversalQuantile(intValues, true, false, false, settings);
                log.finer(() -> quantile.toString());
                return quantile;
            }
        }
        ,
        POINT{

            @Override
            public UniversalQuantile<Integer> toIndexQuantile(IRecord record, Settings settings) {
                throw new UnsupportedOperationException();
            }

            @Override
            public UniversalQuantile<? extends Number> toValueQuantile(IRecord record, Settings settings) {
                boolean removeCastaways = true;
                UniversalQuantile<Double> quantile = new UniversalQuantile<Double>(record.getTranslatedValues(), true, removeCastaways, false, settings);
                return quantile;
            }
        };


        public abstract UniversalQuantile<Integer> toIndexQuantile(IRecord var1, Settings var2);

        public abstract UniversalQuantile<? extends Number> toValueQuantile(IRecord var1, Settings var2);
    }
}

