/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.Analyzer;
import gde.data.Record;
import gde.device.DataTypes;
import gde.device.EvaluationType;
import gde.device.IChannelItem;
import gde.device.IDevice;
import gde.device.ObjectFactory;
import gde.device.PropertyType;
import gde.device.TrailDisplayType;
import gde.histo.cache.HistoVault;
import gde.histo.recordings.SettlementTrailSelector;
import gde.histo.recordings.TrailSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SettlementType", propOrder={"name", "symbol", "unit", "active", "evaluation", "property", "trailDisplay", "label"})
public class SettlementType
implements IChannelItem {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected String symbol;
    @XmlElement(required=true)
    protected String unit;
    protected boolean active;
    protected EvaluationType evaluation;
    protected List<PropertyType> property;
    protected TrailDisplayType trailDisplay;
    protected String label;
    @XmlAttribute(required=true)
    protected int settlementId;
    @XmlTransient
    protected Record.DataType dataType;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String value) {
        this.symbol = value;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public EvaluationType getEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation(EvaluationType value) {
        this.evaluation = value;
    }

    @Override
    public List<PropertyType> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<PropertyType>();
        }
        return this.property;
    }

    @Override
    public Optional<TrailDisplayType> getTrailDisplay() {
        return Optional.ofNullable(this.trailDisplay);
    }

    public void setTrailDisplay(TrailDisplayType value) {
        this.trailDisplay = value;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Override
    public String getChannelItemId() {
        return "" + this.settlementId + "_" + this.name;
    }

    public int getSettlementId() {
        return this.settlementId;
    }

    public void setSettlementId(int value) {
        this.settlementId = value;
    }

    private void createProperty(String propertyKey, DataTypes type, Object value) {
        ObjectFactory factory = new ObjectFactory();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName(propertyKey);
        newProperty.setType(type);
        newProperty.setValue("" + value);
        this.getProperty().add(newProperty);
    }

    public void removeProperties() {
        Iterator<PropertyType> iterator = this.getProperty().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public void removeProperty(String propertyKey) {
        Iterator<PropertyType> iterator = this.getProperty().iterator();
        while (iterator.hasNext()) {
            PropertyType tmpProp = iterator.next();
            if (!tmpProp.name.equals(propertyKey)) continue;
            iterator.remove();
        }
    }

    @Override
    public PropertyType getProperty(String propertyKey) {
        PropertyType tmpProperty = null;
        List<PropertyType> properties = this.getProperty();
        for (PropertyType propertyType : properties) {
            if (!propertyType.getName().equals(propertyKey)) continue;
            tmpProperty = propertyType;
            break;
        }
        return tmpProperty;
    }

    @Override
    public double getOffset() {
        double value = 0.0;
        PropertyType tmpProperty = this.getProperty(IDevice.OFFSET);
        if (tmpProperty != null) {
            value = Double.valueOf(tmpProperty.getValue());
        }
        return value;
    }

    public void setOffset(double offset) {
        PropertyType tmpProperty = this.getProperty(IDevice.OFFSET);
        if (tmpProperty == null) {
            this.createProperty(IDevice.OFFSET, DataTypes.DOUBLE, offset);
        } else {
            tmpProperty.setValue("" + offset);
        }
    }

    @Override
    public double getReduction() {
        double value = 0.0;
        PropertyType tmpProperty = this.getProperty(IDevice.REDUCTION);
        if (tmpProperty != null) {
            value = Double.valueOf(tmpProperty.getValue());
        }
        return value;
    }

    public void setReduction(double reduction) {
        PropertyType tmpProperty = this.getProperty(IDevice.REDUCTION);
        if (tmpProperty == null) {
            this.createProperty(IDevice.REDUCTION, DataTypes.DOUBLE, reduction);
        } else {
            tmpProperty.setValue("" + reduction);
        }
    }

    @Override
    public double getFactor() {
        double value = 1.0;
        PropertyType tmpProperty = this.getProperty(IDevice.FACTOR);
        if (tmpProperty != null) {
            value = Double.valueOf(tmpProperty.getValue());
        }
        return value;
    }

    public void setFactor(double factor) {
        PropertyType tmpProperty = this.getProperty(IDevice.FACTOR);
        if (tmpProperty == null) {
            this.createProperty(IDevice.FACTOR, DataTypes.DOUBLE, factor);
        } else {
            tmpProperty.setValue("" + factor);
        }
    }

    @Override
    public boolean isBits() {
        boolean isBits = false;
        PropertyType tmpProperty = this.getProperty(IDevice.IS_BITS);
        if (tmpProperty != null) {
            isBits = Boolean.parseBoolean(tmpProperty.getValue());
        }
        return isBits;
    }

    @Override
    public boolean isTokens() {
        boolean isBits = false;
        PropertyType tmpProperty = this.getProperty(IDevice.IS_TOKENS);
        if (tmpProperty != null) {
            isBits = Boolean.parseBoolean(tmpProperty.getValue());
        }
        return isBits;
    }

    @Override
    public int getSyncMasterRecordOrdinal() {
        int value = -1;
        PropertyType tmpProperty = this.getProperty(IDevice.SYNC_ORDINAL);
        if (tmpProperty != null) {
            value = Integer.parseInt(tmpProperty.getValue());
        }
        return value;
    }

    @Override
    public Integer getVaultPoint(HistoVault vault, int trailOrdinal) {
        return vault.getSettlementPoint(this.settlementId, trailOrdinal);
    }

    @Override
    public void setDataType(Record.DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public Record.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public TrailSelector createTrailSelector(Analyzer analyzer, String recordName, boolean smartStatistics) {
        return new SettlementTrailSelector(analyzer, this, recordName, smartStatistics);
    }

    public String toString() {
        int maxLen = 10;
        return "SettlementType [name=" + this.name + ", active=" + this.active + ", evaluation=" + this.evaluation + ", property=" + (this.property != null ? this.property.subList(0, Math.min(this.property.size(), 10)) : null) + ", trailDisplay=" + this.trailDisplay + ", label=" + this.label + ", settlementId=" + this.settlementId + ", dataType=" + (Object)((Object)this.dataType) + "]";
    }
}

