/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.Analyzer;
import gde.data.Record;
import gde.device.DataTypes;
import gde.device.IChannelItem;
import gde.device.IDevice;
import gde.device.ObjectFactory;
import gde.device.PropertyType;
import gde.device.ScoreType;
import gde.device.TrailDisplayType;
import gde.histo.cache.HistoVault;
import gde.histo.recordings.ScoregroupTrailSelector;
import gde.histo.recordings.TrailSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ScoreGroupType", propOrder={"name", "symbol", "unit", "active", "score", "property", "label"})
public class ScoreGroupType
implements IChannelItem {
    @XmlElement(required=true)
    protected String name;
    @XmlElement(required=true)
    protected String symbol;
    @XmlElement(required=true)
    protected String unit;
    protected boolean active;
    @XmlElement(required=true)
    protected List<ScoreType> score;
    protected List<PropertyType> property;
    protected String label;
    @XmlAttribute(name="scoregroupId", required=true)
    protected int scoreGroupId;
    @XmlTransient
    protected Record.DataType dataType;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String value) {
        this.symbol = value;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public List<ScoreType> getScore() {
        if (this.score == null) {
            this.score = new ArrayList<ScoreType>();
        }
        return this.score;
    }

    @Override
    public List<PropertyType> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<PropertyType>();
        }
        return this.property;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Override
    public String getChannelItemId() {
        return "" + this.scoreGroupId + "_" + this.name;
    }

    public int getScoreGroupId() {
        return this.scoreGroupId;
    }

    public void setScoreGroupId(int value) {
        this.scoreGroupId = value;
    }

    private void createProperty(String propertyKey, DataTypes type, Object value) {
        ObjectFactory factory = new ObjectFactory();
        PropertyType newProperty = factory.createPropertyType();
        newProperty.setName(propertyKey);
        newProperty.setType(type);
        newProperty.setValue("" + value);
        this.getProperty().add(newProperty);
    }

    public void removeProperties() {
        Iterator<PropertyType> iterator = this.getProperty().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    public void removeProperty(String propertyKey) {
        Iterator<PropertyType> iterator = this.getProperty().iterator();
        while (iterator.hasNext()) {
            PropertyType tmpProp = iterator.next();
            if (!tmpProp.name.equals(propertyKey)) continue;
            iterator.remove();
        }
    }

    @Override
    public PropertyType getProperty(String propertyKey) {
        PropertyType tmpProperty = null;
        List<PropertyType> properties = this.getProperty();
        for (PropertyType propertyType : properties) {
            if (!propertyType.getName().equals(propertyKey)) continue;
            tmpProperty = propertyType;
            break;
        }
        return tmpProperty;
    }

    @Override
    public double getOffset() {
        double value = 0.0;
        PropertyType tmpProperty = this.getProperty(IDevice.OFFSET);
        if (tmpProperty != null) {
            value = Double.valueOf(tmpProperty.getValue());
        }
        return value;
    }

    public void setOffset(double offset) {
        PropertyType tmpProperty = this.getProperty(IDevice.OFFSET);
        if (tmpProperty == null) {
            this.createProperty(IDevice.OFFSET, DataTypes.DOUBLE, offset);
        } else {
            tmpProperty.setValue("" + offset);
        }
    }

    @Override
    public double getReduction() {
        double value = 0.0;
        PropertyType tmpProperty = this.getProperty(IDevice.REDUCTION);
        if (tmpProperty != null) {
            value = Double.valueOf(tmpProperty.getValue());
        }
        return value;
    }

    public void setReduction(double reduction) {
        PropertyType tmpProperty = this.getProperty(IDevice.REDUCTION);
        if (tmpProperty == null) {
            this.createProperty(IDevice.REDUCTION, DataTypes.DOUBLE, reduction);
        } else {
            tmpProperty.setValue("" + reduction);
        }
    }

    @Override
    public double getFactor() {
        double value = 1.0;
        PropertyType tmpProperty = this.getProperty(IDevice.FACTOR);
        if (tmpProperty != null) {
            value = Double.valueOf(tmpProperty.getValue());
        }
        return value;
    }

    public void setFactor(double factor) {
        PropertyType tmpProperty = this.getProperty(IDevice.FACTOR);
        if (tmpProperty == null) {
            this.createProperty(IDevice.FACTOR, DataTypes.DOUBLE, factor);
        } else {
            tmpProperty.setValue("" + factor);
        }
    }

    @Override
    public boolean isBits() {
        boolean isBits = false;
        PropertyType tmpProperty = this.getProperty(IDevice.IS_BITS);
        if (tmpProperty != null) {
            isBits = Boolean.parseBoolean(tmpProperty.getValue());
        }
        return isBits;
    }

    @Override
    public boolean isTokens() {
        boolean isBits = false;
        PropertyType tmpProperty = this.getProperty(IDevice.IS_TOKENS);
        if (tmpProperty != null) {
            isBits = Boolean.parseBoolean(tmpProperty.getValue());
        }
        return isBits;
    }

    @Override
    public int getSyncMasterRecordOrdinal() {
        int value = -1;
        PropertyType tmpProperty = this.getProperty(IDevice.SYNC_ORDINAL);
        if (tmpProperty != null) {
            value = Integer.parseInt(tmpProperty.getValue());
        }
        return value;
    }

    @Override
    public Optional<TrailDisplayType> getTrailDisplay() {
        return Optional.empty();
    }

    @Override
    public Integer getVaultPoint(HistoVault vault, int trailOrdinal) {
        return vault.getScorePoint(trailOrdinal);
    }

    @Override
    public void setDataType(Record.DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public Record.DataType getDataType() {
        return this.dataType;
    }

    @Override
    public TrailSelector createTrailSelector(Analyzer analyzer, String recordName, boolean smartStatistics) {
        return new ScoregroupTrailSelector(analyzer, this, recordName, smartStatistics);
    }

    public String toString() {
        int maxLen = 10;
        return "ScoreGroupType [name=" + this.name + ", active=" + this.active + ", score=" + (this.score != null ? this.score.subList(0, Math.min(this.score.size(), 10)) : null) + ", property=" + (this.property != null ? this.property.subList(0, Math.min(this.property.size(), 10)) : null) + ", label=" + this.label + ", scoreGroupId=" + this.scoreGroupId + ", dataType=" + (Object)((Object)this.dataType) + "]";
    }
}

