/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.smmodellbau.GPSLogger;
import gde.device.smmodellbau.GPSLoggerSetupConfiguration1;
import gde.device.smmodellbau.GPSLoggerSetupConfiguration2;
import gde.device.smmodellbau.GPSLoggerVisualizationControl;
import gde.device.smmodellbau.SetupReaderWriter;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GPSLoggerDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(GPSLoggerDialog.class.getName());
    CTabFolder tabFolder;
    CTabFolder subTabFolder1;
    CTabFolder subTabFolder2;
    CTabItem visualizationTabItem;
    CTabItem configurationTabItem;
    CTabItem uniLogTabItem;
    CTabItem mLinkTabItem;
    Composite visualizationMainComposite;
    Composite uniLogVisualization;
    Composite mLinkVisualization;
    ScrolledComposite scrolledComposite;
    Composite configurationMainComposite;
    GPSLoggerSetupConfiguration1 configuration1Composite;
    GPSLoggerSetupConfiguration2 configuration2Composite;
    Button saveVisualizationButton;
    Button inputFileButton;
    Button helpButton;
    Button saveSetupButton;
    Button closeButton;
    CTabItem gpsLoggerTabItem;
    CTabItem telemetryTabItem;
    final GPSLogger device;
    final Settings settings;
    SetupReaderWriter loggerSetup;
    RecordSet lastActiveRecordSet = null;
    boolean isVisibilityChanged = false;
    int measurementsCount = 0;
    final List<CTabItem> configurations = new ArrayList<CTabItem>();

    public GPSLoggerDialog(Shell parent, GPSLogger useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
        for (int i = 1; i <= this.device.getChannelCount(); ++i) {
            this.measurementsCount = 16;
        }
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(java.util.logging.Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                this.loggerSetup = new SetupReaderWriter(this.dialogShell, this.device);
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(650, 155 + this.measurementsCount * 32 + 60 + 42);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                GPSLoggerDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                        if (GPSLoggerDialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{GPSLoggerDialog.this.device.getPropertiesFileName()});
                            if (GPSLoggerDialog.this.application.openYesNoMessageDialog(GPSLoggerDialog.this.getDialogShell(), msg) == 64) {
                                log.log(java.util.logging.Level.FINE, "SWT.YES");
                                GPSLoggerDialog.this.device.storeDeviceProperties();
                                GPSLoggerDialog.this.setClosePossible(true);
                            }
                        }
                        GPSLoggerDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(java.util.logging.Level.FINER, "dialogShell.helpRequested, event=" + evt);
                        GPSLoggerDialog.this.application.openHelpDialog(Messages.getString((String)"GDE_MSGT2010"), "HelpInfo.html");
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + paintevent);
                        }
                        RecordSet activeRecordSet = GPSLoggerDialog.this.application.getActiveRecordSet();
                        if (GPSLoggerDialog.this.lastActiveRecordSet == null && activeRecordSet != null || activeRecordSet != null && !GPSLoggerDialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            GPSLoggerDialog.this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                        }
                        GPSLoggerDialog.this.lastActiveRecordSet = GPSLoggerDialog.this.application.getActiveRecordSet();
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.tabFolder.setSimple(false);
                if (this.device.getChannelCount() >= 1) {
                    if (this.device.getChannelName(1).equals("UniLog")) {
                        this.createVisualizationTabItem(1, this.device.getName().equals("GPS-Logger") ? 17 : 26, 9, 15);
                    } else {
                        this.createVisualizationTabItem(2, this.device.getName().equals("GPS-Logger") ? 17 : 20, 17, 15);
                    }
                }
                if (this.device.getChannelCount() >= 2) {
                    this.createVisualizationTabItem(2, this.device.getName().equals("GPS-Logger") ? 17 : 26, 17, 15);
                }
                this.configurationTabItem = new CTabItem(this.tabFolder, 0);
                this.configurationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.configurationTabItem.setText(Messages.getString((String)"GDE_MSGT2015"));
                this.configurationMainComposite = new Composite((Composite)this.tabFolder, 0);
                FormLayout configurationMainCompositeLayout = new FormLayout();
                this.configurationMainComposite.setLayout((Layout)configurationMainCompositeLayout);
                this.configurationTabItem.setControl((Control)this.configurationMainComposite);
                FormData layoutConfig1Data = new FormData();
                layoutConfig1Data.top = new FormAttachment(0, 1000, 0);
                layoutConfig1Data.left = new FormAttachment(0, 1000, 0);
                layoutConfig1Data.right = new FormAttachment(493, 1000, 0);
                layoutConfig1Data.bottom = new FormAttachment(1000, 1000, 0);
                this.configuration1Composite = new GPSLoggerSetupConfiguration1(this.configurationMainComposite, 0, this, this.loggerSetup);
                this.configuration1Composite.setLayoutData(layoutConfig1Data);
                FormData layoutConfig2Data = new FormData();
                layoutConfig2Data.top = new FormAttachment(0, 1000, 0);
                layoutConfig2Data.left = new FormAttachment(493, 1000, 0);
                layoutConfig2Data.right = new FormAttachment(1000, 1000, 0);
                layoutConfig2Data.bottom = new FormAttachment(1000, 1000, 0);
                this.configuration2Composite = new GPSLoggerSetupConfiguration2(this.configurationMainComposite, 0, this, this.loggerSetup);
                this.configuration2Composite.setLayoutData(layoutConfig2Data);
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.setSelection(0);
                this.tabFolder.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        GPSLoggerDialog.this.configuration1Composite.changeVisibility();
                        if (GPSLoggerDialog.this.tabFolder.getSelectionIndex() == GPSLoggerDialog.this.tabFolder.getItemCount() - 1) {
                            GPSLoggerDialog.this.loggerSetup.loadSetup();
                        }
                        GPSLoggerDialog.this.configuration1Composite.updateValues();
                        GPSLoggerDialog.this.configuration2Composite.updateValues();
                    }
                });
                this.saveVisualizationButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 130;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 15);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveVisualizationButton.setLayoutData((Object)saveButtonLData);
                this.saveVisualizationButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveVisualizationButton.setText(Messages.getString((String)"GDE_MSGT2016"));
                this.saveVisualizationButton.setToolTipText(Messages.getString((String)"GDE_MSGT2023"));
                this.saveVisualizationButton.setEnabled(false);
                this.saveVisualizationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "saveButton.widgetSelected, event=" + evt);
                        GPSLoggerDialog.this.device.storeDeviceProperties();
                        GPSLoggerDialog.this.saveVisualizationButton.setEnabled(false);
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.width = 130;
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 155);
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT2017"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT2025"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "inputFileButton.widgetSelected, event=" + evt);
                        if (GPSLoggerDialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{GPSLoggerDialog.this.device.getPropertiesFileName()});
                            if (GPSLoggerDialog.this.application.openYesNoMessageDialog(GPSLoggerDialog.this.dialogShell, msg) == 64) {
                                log.log(java.util.logging.Level.FINE, "SWT.YES");
                                GPSLoggerDialog.this.device.storeDeviceProperties();
                            }
                        }
                        GPSLoggerDialog.this.device.open_closeCommPort();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, 302);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "helpButton.widgetSelected, event=" + evt);
                        GPSLoggerDialog.this.application.openHelpDialog(Messages.getString((String)"GDE_MSGT2010"), "HelpInfo.html");
                    }
                });
                this.saveSetupButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveSetupButtonLData = new FormData();
                saveSetupButtonLData.width = 130;
                saveSetupButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveSetupButtonLData.right = new FormAttachment(1000, 1000, -155);
                saveSetupButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveSetupButton.setLayoutData((Object)saveSetupButtonLData);
                this.saveSetupButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveSetupButton.setText(Messages.getString((String)"GDE_MSGT2018"));
                this.saveSetupButton.setToolTipText(Messages.getString((String)"GDE_MSGT2024"));
                this.saveSetupButton.setEnabled(false);
                this.saveSetupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "saveSetupButton.widgetSelected, event=" + evt);
                        GPSLoggerDialog.this.loggerSetup.saveSetup();
                        GPSLoggerDialog.this.saveSetupButton.setEnabled(false);
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 130;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(java.util.logging.Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                        GPSLoggerDialog.this.dispose();
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 375, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createVisualizationTabItem(int channelNumber, int numMeasurements, int numMeasurements_UL, int numMeasurements_ML) {
        this.visualizationTabItem = new CTabItem(this.tabFolder, 0);
        this.visualizationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.visualizationTabItem.setText(Messages.getString((String)"GDE_MSGT2009") + " - " + this.device.getChannelNameReplacement(channelNumber));
        this.scrolledComposite = new ScrolledComposite((Composite)this.tabFolder, 512);
        this.visualizationMainComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.visualizationTabItem.setControl((Control)this.scrolledComposite);
        this.visualizationMainComposite.setLayout((Layout)new FormLayout());
        this.scrolledComposite.setContent((Control)this.visualizationMainComposite);
        this.scrolledComposite.setMinSize(500, 770);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        FormData layoutData = new FormData();
        layoutData.top = new FormAttachment(0, 1000, 0);
        layoutData.left = new FormAttachment(0, 1000, 0);
        layoutData.right = new FormAttachment(458, 1000, 0);
        layoutData.height = 770;
        new GPSLoggerVisualizationControl(this.visualizationMainComposite, layoutData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2010"), 0, numMeasurements);
        this.subTabFolder1 = new CTabFolder(this.visualizationMainComposite, 0);
        FormData subTabFolder1LData = new FormData();
        subTabFolder1LData.top = new FormAttachment(0, 1000, 0);
        subTabFolder1LData.left = new FormAttachment(460, 1000, 0);
        subTabFolder1LData.right = new FormAttachment(1000, 1000, 0);
        subTabFolder1LData.bottom = new FormAttachment(1000, 1000, 0);
        this.subTabFolder1.setLayoutData((Object)subTabFolder1LData);
        this.uniLogTabItem = new CTabItem(this.subTabFolder1, 0);
        this.uniLogTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        this.uniLogTabItem.setText(Messages.getString((String)"GDE_MSGT2011"));
        this.uniLogVisualization = new Composite((Composite)this.subTabFolder1, 0);
        FormLayout compositeLayout = new FormLayout();
        this.uniLogVisualization.setLayout((Layout)compositeLayout);
        this.uniLogTabItem.setControl((Control)this.uniLogVisualization);
        FormData layoutUniLogData = new FormData();
        layoutUniLogData.top = new FormAttachment(0, 1000, 0);
        layoutUniLogData.left = new FormAttachment(0, 1000, 0);
        layoutUniLogData.right = new FormAttachment(1000, 1000, 0);
        layoutUniLogData.bottom = new FormAttachment(1000, 1000, 0);
        new GPSLoggerVisualizationControl(this.uniLogVisualization, layoutUniLogData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2011"), numMeasurements, numMeasurements_UL);
        this.mLinkTabItem = new CTabItem(this.subTabFolder1, 0);
        this.mLinkTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)1));
        this.mLinkTabItem.setText(Messages.getString((String)"GDE_MSGT2012"));
        this.mLinkVisualization = new Composite((Composite)this.subTabFolder1, 0);
        compositeLayout = new FormLayout();
        this.mLinkVisualization.setLayout((Layout)compositeLayout);
        this.mLinkTabItem.setControl((Control)this.mLinkVisualization);
        FormData layoutMLinkData = new FormData();
        layoutMLinkData.top = new FormAttachment(0, 1000, 0);
        layoutMLinkData.left = new FormAttachment(0, 1000, 0);
        layoutMLinkData.right = new FormAttachment(1000, 1000, 0);
        layoutMLinkData.bottom = new FormAttachment(1000, 1000, 0);
        new GPSLoggerVisualizationControl(this.mLinkVisualization, layoutMLinkData, this, channelNumber, this.device, Messages.getString((String)"GDE_MSGT2012"), numMeasurements + numMeasurements_UL, numMeasurements_ML);
        this.subTabFolder1.setSelection(0);
    }

    public void enableSaveButton(boolean enable) {
        this.saveVisualizationButton.setEnabled(enable);
        this.application.updateAllTabs(true);
    }

    public void enableSaveConfigurationButton(boolean enable) {
        this.saveSetupButton.setEnabled(enable);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }
}

