/*
 * Decompiled with CFR 0.152.
 */
package gde.device.gpx;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.gpx.GPXAdapter;
import gde.device.gpx.GPXAdapterDialogTabItem;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class GPXAdapterDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(GPXAdapterDialog.class.getName());
    CTabFolder tabFolder;
    CTabFolder subTabFolder1;
    CTabFolder subTabFolder2;
    CTabItem visualizationTabItem;
    Button saveVisualizationButton;
    Button inputFileButton;
    Button helpButton;
    Button closeButton;
    CTabItem gpsLoggerTabItem;
    CTabItem telemetryTabItem;
    final GPXAdapter device;
    final Settings settings;
    RecordSet lastActiveRecordSet = null;
    boolean isVisibilityChanged = false;
    int measurementsCount = 0;

    public GPXAdapterDialog(Shell parent, GPXAdapter useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
        this.measurementsCount = this.device.getNumberOfMeasurements(1);
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.layout();
                this.dialogShell.pack();
                this.dialogShell.setSize(GDE.IS_LINUX ? 750 : 685, 80 + this.measurementsCount / 4 * 26 + 50 + 42);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                GPXAdapterDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + evt);
                        if (GPXAdapterDialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{GPXAdapterDialog.this.device.getPropertiesFileName()});
                            if (GPXAdapterDialog.this.application.openYesNoMessageDialog(GPXAdapterDialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                GPXAdapterDialog.this.device.storeDeviceProperties();
                                GPXAdapterDialog.this.setClosePossible(true);
                            }
                        }
                        GPXAdapterDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + evt);
                        GPXAdapterDialog.this.application.openHelpDialog(GPXAdapterDialog.this.device.getName(), "HelpInfo.html");
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + paintevent);
                        }
                        RecordSet activeRecordSet = GPXAdapterDialog.this.application.getActiveRecordSet();
                        if (GPXAdapterDialog.this.lastActiveRecordSet == null && activeRecordSet != null || activeRecordSet != null && !GPXAdapterDialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            GPXAdapterDialog.this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                        }
                        GPXAdapterDialog.this.lastActiveRecordSet = GPXAdapterDialog.this.application.getActiveRecordSet();
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.tabFolder.setSimple(false);
                for (int i = 1; i <= this.device.getChannelCount(); ++i) {
                    new GPXAdapterDialogTabItem(this.tabFolder, this, i, this.device);
                }
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                this.tabFolder.setSelection(0);
                this.saveVisualizationButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 130;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 15);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveVisualizationButton.setLayoutData((Object)saveButtonLData);
                this.saveVisualizationButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveVisualizationButton.setText(Messages.getString((String)"GDE_MSGT1786"));
                this.saveVisualizationButton.setToolTipText(Messages.getString((String)"GDE_MSGT1787"));
                this.saveVisualizationButton.setEnabled(false);
                this.saveVisualizationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + evt);
                        GPXAdapterDialog.this.device.storeDeviceProperties();
                        GPXAdapterDialog.this.saveVisualizationButton.setEnabled(false);
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.width = 130;
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 155);
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT1788"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT1789"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + evt);
                        if (GPXAdapterDialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{GPXAdapterDialog.this.device.getPropertiesFileName()});
                            if (GPXAdapterDialog.this.application.openYesNoMessageDialog(GPXAdapterDialog.this.dialogShell, msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                GPXAdapterDialog.this.device.storeDeviceProperties();
                            }
                        }
                        GPXAdapterDialog.this.device.open_closeCommPort();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_MAC ? 50 : 40;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, 302);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + evt);
                        GPXAdapterDialog.this.application.openHelpDialog(GPXAdapterDialog.this.device.getName(), "HelpInfo.html");
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 130;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + evt);
                        GPXAdapterDialog.this.dispose();
                    }
                });
                try {
                    this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                }
                catch (RuntimeException e) {
                    this.tabFolder.setSelection(0);
                }
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 375, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void enableSaveButton(boolean enable) {
        this.saveVisualizationButton.setEnabled(enable);
        this.application.updateAllTabs(true);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getSelectionIndex();
    }
}

