/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.smmodellbau.LiPoWatch;
import gde.device.smmodellbau.LiPoWatchDataGatherer;
import gde.device.smmodellbau.LiPoWatchLiveGatherer;
import gde.device.smmodellbau.LiPoWatchSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.Locale;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.TaskItem;
import org.eclipse.swt.widgets.Widget;

public class LiPoWatchDialog
extends DeviceDialog {
    static final String DEVICE_NAME = "LiPoWatch";
    static final Logger log = Logger.getLogger(LiPoWatchDialog.class.getName());
    public static final int MAX_DATA_RECORDS = 25920;
    public static final int FLASH_SIZE = 0x100000;
    public static final int FLASH_POSITION_DATA_BEGIN = 256;
    public static final int MAX_DATA_VALUES = 1048320;
    public static final String[] TIME_INTERVAL = new String[]{"   1/4 s  (->     5 h)", "   1/2 s  (->   10 h)", "      1 s   (->   20 h)", "      2 s   (->   40 h)", "      5 s   (-> 100 h)", "    10 s   (->  200 h)"};
    public static final String[] RX_AUTO_START_MS = new String[]{" 1,1", " 1,2", " 1,3", " 1,4", " 1,5", " 1,6", " 1,7", " 1,8", " 1,9", " Rx on"};
    public static final String[] CELL_VOLTAGE_LIMITS = new String[]{" 2.0", " 2.1", " 2.2", " 2.3", " 2.4", " 2.5", " 2.6", " 2.7", " 2.8", " 2.9", " 3.0", " 3.1", " 3.2", " 3.3", " 3.4", " 3.5", " 3.6", " 3.7"};
    CTabFolder mainTabFolder;
    CTabItem configTabItem;
    Composite configMainComosite;
    Group statusGroup;
    CLabel snLabel;
    CLabel serialNumberText;
    CLabel firmwareVersionLabel;
    CLabel firmwareText;
    CLabel memUsageUnit;
    CLabel memoryUsageText;
    CLabel memUsagePercent;
    CCombo measurementModusCombo;
    CLabel measurementModusLabel;
    Group measurementTypeGroup;
    Group autoStartGroup;
    CCombo impulseTriggerCombo;
    CCombo timeTriggerCombo;
    Button impulseTriggerButton;
    Button timeTriggerButton;
    Button voltageDropTriggerButton;
    Group dataRateGroup;
    CCombo timeIntervalCombo;
    Group impuleRegulationGroup;
    CLabel cellTypeLabel;
    CLabel voltageLimitLabel;
    CLabel regulationTypeLabel;
    CCombo cellTypeCombo;
    CCombo voltageLevelRegulationCombo;
    CCombo regulationTypeCombo;
    Button storeConfigButton;
    Button readConfigButton;
    CTabItem displayTabItem;
    Composite displayComposite;
    CTabItem dataTabItem;
    Composite dataMainComposite;
    Group dataReadGroup;
    CLabel clearMemoryLabel;
    Group clearMemoryGroup;
    Button readDataButton;
    Button stopReadDataButton;
    CLabel dataSetLabel;
    CLabel redDataSetLabel;
    CLabel actualDataSetNumberLabel;
    CLabel actualDataSetNumber;
    CLabel readDataErrorLabel;
    CLabel numberReadErrorLabel;
    CLabel readLess4Label;
    CLabel numberLess4Label;
    ProgressBar readDataProgressBar;
    Group liveDataCaptureGroup;
    Group loggingGroup;
    Button startLiveGatherButton;
    Button stopLiveGatherButton;
    Button startLoggingButton;
    Button stopLoggingButton;
    Button clearMemoryButton;
    Button closeButton;
    LiPoWatchDataGatherer gatherThread;
    LiPoWatchLiveGatherer liveThread;
    String serialNumber = "";
    String lipoWatchVersion = "";
    int memoryUsed = 0;
    String memoryUsedPercent = "0";
    int timeIntervalPosition = 0;
    int measurementModus = 0;
    boolean isAutoStartVoltageDrop = true;
    boolean isAutStartRx = false;
    boolean isRxOn = false;
    boolean isAutoStartTime = false;
    int voltageLevelRegulationLimit = 10;
    int impulsReductionType = 1;
    int cellType = 0;
    int rxAutoStartValue = 0;
    int timeAutoStart_sec = 0;
    double offsetA1 = 0.0;
    double factorA1 = 1.0;
    boolean isLiveGathererEnabled = true;
    String numberRedDataSetsText = "0";
    String numberActualDataSetsText = "0";
    String numberReadErrorText = "0";
    String numberLess4Text = "0";
    TaskItem taskBarItem;
    final LiPoWatch device;
    final LiPoWatchSerialPort serialPort;
    final Channels channels;
    final Settings settings;

    public LiPoWatchDialog(Shell parent, LiPoWatch useDevice) {
        super(parent);
        this.serialPort = useDevice.getCommunicationPort();
        this.device = useDevice;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "dialogShell.isDisposed() " + (this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            }
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                if (this.isAlphaEnabled) {
                    this.dialogShell.setAlpha(254);
                }
                this.dialogShell.setText(DEVICE_NAME + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.setSize(515, 400);
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 175, 100));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                LiPoWatchDialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "dialogShell.widgetDisposed, event=" + evt);
                        }
                        if (LiPoWatchDialog.this.storeConfigButton.getEnabled()) {
                            String msg = Messages.getString((String)"GDE_MSGI1600");
                            if (LiPoWatchDialog.this.application.openYesNoMessageDialog(LiPoWatchDialog.this.getDialogShell(), msg) == 64) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "SWT.YES");
                                }
                                LiPoWatchDialog.this.setClosePossible(true);
                            }
                            if (LiPoWatchDialog.this.gatherThread != null && LiPoWatchDialog.this.gatherThread.isAlive()) {
                                LiPoWatchDialog.this.gatherThread.interrupt();
                            }
                            if (LiPoWatchDialog.this.liveThread != null && LiPoWatchDialog.this.liveThread.isTimerRunning) {
                                LiPoWatchDialog.this.liveThread.stopTimerThread();
                            }
                        }
                        LiPoWatchDialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "dialogShell.helpRequested, event=" + evt);
                        }
                        LiPoWatchDialog.this.application.openHelpDialog(LiPoWatchDialog.DEVICE_NAME, "HelpInfo.html");
                    }
                });
                this.dialogShell.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                    public void mouseEnter(MouseEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "dialogShell.mouseEnter, event=" + evt);
                        }
                        LiPoWatchDialog.this.fadeOutAplhaBlending(evt, LiPoWatchDialog.this.getDialogShell().getClientArea(), 20, 20, 20, 25);
                    }

                    public void mouseHover(MouseEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.mouseHover, event=" + evt);
                        }
                    }

                    public void mouseExit(MouseEvent evt) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "dialogShell.mouseExit, event=" + evt);
                        }
                        LiPoWatchDialog.this.fadeInAlpaBlending(evt, LiPoWatchDialog.this.getDialogShell().getClientArea(), 20, 20, -20, 25);
                    }
                });
                this.mainTabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.configTabItem = new CTabItem(this.mainTabFolder, 0);
                this.configTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.configTabItem.setText(Messages.getString((String)"GDE_MSGT1608"));
                this.configMainComosite = new Composite((Composite)this.mainTabFolder, 0);
                this.configTabItem.setControl((Control)this.configMainComosite);
                this.configMainComosite.setLayout(null);
                this.configMainComosite.setToolTipText(Messages.getString((String)"GDE_MSGT1609"));
                this.configMainComosite.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.statusGroup = new Group(this.configMainComosite, 0);
                this.statusGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.statusGroup.setLayout((Layout)new RowLayout(256));
                this.statusGroup.setText(Messages.getString((String)"GDE_MSGT1610"));
                this.statusGroup.setBounds(12, 4, 473, 45);
                this.statusGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.serialNumberText = new CLabel((Composite)this.statusGroup, 0);
                this.serialNumberText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.serialNumberText.setText(Messages.getString((String)"GDE_MSGT1611"));
                this.serialNumberText.setLayoutData((Object)new RowData(40, 22));
                this.serialNumberText.setToolTipText(Messages.getString((String)"GDE_MSGT1612"));
                this.snLabel = new CLabel((Composite)this.statusGroup, 0x1000000);
                this.snLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.snLabel.setLayoutData((Object)new RowData(65, 22));
                this.snLabel.setText(this.serialNumber);
                this.firmwareText = new CLabel((Composite)this.statusGroup, 0);
                this.firmwareText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.firmwareText.setText(Messages.getString((String)"GDE_MSGT1613"));
                this.firmwareText.setLayoutData((Object)new RowData(70, 22));
                this.firmwareText.setToolTipText(Messages.getString((String)"GDE_MSGT1614"));
                this.firmwareVersionLabel = new CLabel((Composite)this.statusGroup, 0);
                this.firmwareVersionLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.firmwareVersionLabel.setLayoutData((Object)new RowData(69, 22));
                this.firmwareVersionLabel.setText(this.lipoWatchVersion);
                this.memoryUsageText = new CLabel((Composite)this.statusGroup, 0);
                this.memoryUsageText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.memoryUsageText.setText(Messages.getString((String)"GDE_MSGT1615"));
                this.memoryUsageText.setLayoutData((Object)new RowData(124, 22));
                this.memUsagePercent = new CLabel((Composite)this.statusGroup, 131072);
                this.memUsagePercent.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.memUsagePercent.setLayoutData((Object)new RowData(59, 22));
                this.memUsagePercent.setText(this.memoryUsedPercent);
                this.memUsageUnit = new CLabel((Composite)this.statusGroup, 0);
                this.memUsageUnit.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.memUsageUnit.setText(Messages.getString((String)"GDE_MSGT1616"));
                this.memUsageUnit.setLayoutData((Object)new RowData(26, 22));
                this.statusGroup.layout();
                this.autoStartGroup = new Group(this.configMainComosite, 0);
                this.autoStartGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.autoStartGroup.setText(Messages.getString((String)"GDE_MSGT1617"));
                this.autoStartGroup.setBounds(12, 136, 232, 107);
                this.autoStartGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.autoStartGroup.setLayout((Layout)new RowLayout(256));
                this.voltageDropTriggerButton = new Button((Composite)this.autoStartGroup, 131104);
                this.voltageDropTriggerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.voltageDropTriggerButton.setText(Messages.getString((String)"GDE_MSGT1618"));
                this.voltageDropTriggerButton.setToolTipText(Messages.getString((String)"GDE_MSGT1619"));
                this.voltageDropTriggerButton.setSelection(this.isAutoStartVoltageDrop);
                this.voltageDropTriggerButton.setLayoutData((Object)new RowData(139, 20));
                this.voltageDropTriggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "currentTriggerButton.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.isAutoStartVoltageDrop = LiPoWatchDialog.this.voltageDropTriggerButton.getSelection();
                        if (LiPoWatchDialog.this.isAutoStartVoltageDrop) {
                            LiPoWatchDialog.this.isAutStartRx = false;
                            LiPoWatchDialog.this.impulseTriggerButton.setSelection(false);
                            LiPoWatchDialog.this.isAutoStartTime = false;
                            LiPoWatchDialog.this.timeTriggerButton.setSelection(false);
                        }
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.timeTriggerButton = new Button((Composite)this.autoStartGroup, 131104);
                this.timeTriggerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeTriggerButton.setText(Messages.getString((String)"GDE_MSGT1620"));
                this.timeTriggerButton.setToolTipText(Messages.getString((String)"GDE_MSGT1621"));
                this.timeTriggerButton.setSelection(this.isAutStartRx);
                this.timeTriggerButton.setLayoutData((Object)new RowData(139, 20));
                this.timeTriggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "timeTriggerButton.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.isAutoStartTime = LiPoWatchDialog.this.timeTriggerButton.getSelection();
                        if (LiPoWatchDialog.this.isAutoStartTime) {
                            LiPoWatchDialog.this.isAutStartRx = false;
                            LiPoWatchDialog.this.impulseTriggerButton.setSelection(false);
                            LiPoWatchDialog.this.isAutoStartVoltageDrop = false;
                            LiPoWatchDialog.this.voltageDropTriggerButton.setSelection(false);
                        }
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.timeTriggerCombo = new CCombo((Composite)this.autoStartGroup, 2048);
                this.timeTriggerCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeTriggerCombo.setLayoutData((Object)new RowData(59, GDE.IS_LINUX ? 22 : 20));
                this.timeTriggerCombo.setItems(new String[]{" 15", " 20", " 25", " 30", " 60", " 90"});
                this.timeTriggerCombo.select(3);
                this.timeTriggerCombo.setEditable(true);
                this.timeTriggerCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.timeTriggerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "timeTriggerCombo.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.timeAutoStart_sec = Integer.parseInt(LiPoWatchDialog.this.timeTriggerCombo.getText().trim());
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.timeTriggerCombo.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "timeTriggerCombo.keyReleased, event=" + evt);
                        }
                        if (evt.keyCode == 13) {
                            int timeSelect;
                            int value = Integer.parseInt(LiPoWatchDialog.this.timeTriggerCombo.getText().trim());
                            if (value < 15) {
                                value = 15;
                                LiPoWatchDialog.this.timeTriggerCombo.setText(" " + 15);
                            } else if (value > 90) {
                                value = 90;
                                LiPoWatchDialog.this.timeTriggerCombo.setText(" " + 90);
                            }
                            for (timeSelect = 0; timeSelect < LiPoWatchDialog.this.timeTriggerCombo.getItemCount() && value > Integer.parseInt(LiPoWatchDialog.this.timeTriggerCombo.getItems()[timeSelect].trim()); ++timeSelect) {
                            }
                            LiPoWatchDialog.this.timeTriggerCombo.select(timeSelect);
                            LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                        }
                    }
                });
                this.impulseTriggerButton = new Button((Composite)this.autoStartGroup, 131104);
                this.impulseTriggerButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.impulseTriggerButton.setText(Messages.getString((String)"GDE_MSGT1622"));
                this.impulseTriggerButton.setToolTipText(Messages.getString((String)"GDE_MSGT1623"));
                this.impulseTriggerButton.setSelection(this.isAutoStartTime);
                this.impulseTriggerButton.setLayoutData((Object)new RowData(139, 20));
                this.impulseTriggerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "impulseTriggerButton.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.isAutStartRx = LiPoWatchDialog.this.impulseTriggerButton.getSelection();
                        if (LiPoWatchDialog.this.isAutStartRx) {
                            LiPoWatchDialog.this.isAutoStartTime = false;
                            LiPoWatchDialog.this.timeTriggerButton.setSelection(false);
                            LiPoWatchDialog.this.isAutoStartVoltageDrop = false;
                            LiPoWatchDialog.this.voltageDropTriggerButton.setSelection(false);
                        }
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.impulseTriggerCombo = new CCombo((Composite)this.autoStartGroup, 2048);
                this.impulseTriggerCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.impulseTriggerCombo.setLayoutData((Object)new RowData(59, GDE.IS_LINUX ? 22 : 20));
                this.impulseTriggerCombo.setEditable(false);
                this.impulseTriggerCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.impulseTriggerCombo.setItems(RX_AUTO_START_MS);
                this.impulseTriggerCombo.select(4);
                this.impulseTriggerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "rcTriggerCombo.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.rxAutoStartValue = LiPoWatchDialog.this.impulseTriggerCombo.getSelectionIndex() + 11;
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.autoStartGroup.layout();
                this.dataRateGroup = new Group(this.configMainComosite, 0);
                this.dataRateGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dataRateGroup.setText(Messages.getString((String)"GDE_MSGT1624"));
                this.dataRateGroup.setBounds(14, 89, 232, 45);
                this.dataRateGroup.setToolTipText(Messages.getString((String)"GDE_MSGT1625"));
                this.dataRateGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.dataRateGroup.setLayout((Layout)new GridLayout(1, true));
                this.timeIntervalCombo = new CCombo((Composite)this.dataRateGroup, 2048);
                this.timeIntervalCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.timeIntervalCombo.setItems(TIME_INTERVAL);
                GridData gridData = new GridData(133, GDE.IS_LINUX ? 22 : 20);
                gridData.grabExcessHorizontalSpace = true;
                gridData.horizontalAlignment = 0x1000000;
                this.timeIntervalCombo.setLayoutData((Object)gridData);
                this.timeIntervalCombo.select(1);
                this.timeIntervalCombo.setEditable(false);
                this.timeIntervalCombo.setBackground(DataExplorer.getInstance().COLOR_WHITE);
                this.timeIntervalCombo.setToolTipText(Messages.getString((String)"GDE_MSGT1625"));
                this.timeIntervalCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "timeRateCombo.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.timeIntervalPosition = LiPoWatchDialog.this.timeIntervalCombo.getSelectionIndex();
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.dataRateGroup.layout();
                this.readConfigButton = new Button(this.configMainComosite, 0x1000008);
                this.readConfigButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.readConfigButton.setText(Messages.getString((String)"GDE_MSGT1627"));
                this.readConfigButton.setBounds(135, 56, 232, 30);
                this.readConfigButton.setEnabled(this.isLiveGathererEnabled);
                this.readConfigButton.setToolTipText(Messages.getString((String)"GDE_MSGT1628"));
                this.readConfigButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.readConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "readConfigButton.widgetSelected, event=" + evt);
                        }
                        try {
                            LiPoWatchDialog.this.updateConfigurationValues(LiPoWatchDialog.this.serialPort.readConfiguration());
                        }
                        catch (ApplicationConfigurationException e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            LiPoWatchDialog.this.application.openMessageDialog(LiPoWatchDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0010"));
                            LiPoWatchDialog.this.application.getDeviceSelectionDialog().open();
                        }
                        catch (Exception e) {
                            LiPoWatchDialog.this.application.openMessageDialog(LiPoWatchDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        }
                    }
                });
                this.storeConfigButton = new Button(this.configMainComosite, 0x1000008);
                this.storeConfigButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.storeConfigButton.setText(Messages.getString((String)"GDE_MSGT1629"));
                this.storeConfigButton.setBounds(135, 249, 229, 30);
                this.storeConfigButton.setToolTipText(Messages.getString((String)"GDE_MSGT1630"));
                this.storeConfigButton.setEnabled(false);
                this.storeConfigButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.storeConfigButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "storeConfigButton.widgetSelected, event=" + evt);
                        }
                        try {
                            if (LiPoWatchDialog.this.serialPort.setConfiguration(LiPoWatchDialog.this.buildUpdateBuffer())) {
                                LiPoWatchDialog.this.updateTimeStep_ms(LiPoWatchDialog.this.timeIntervalPosition);
                                LiPoWatchDialog.this.storeConfigButton.setEnabled(false);
                            } else {
                                LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                            }
                        }
                        catch (Exception e) {
                            LiPoWatchDialog.this.application.openMessageDialog(LiPoWatchDialog.this.getDialogShell(), e.getMessage());
                        }
                    }
                });
                this.impuleRegulationGroup = new Group(this.configMainComosite, 0);
                this.impuleRegulationGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.impuleRegulationGroup.setLayout(null);
                this.impuleRegulationGroup.setText(Messages.getString((String)"GDE_MSGT1631"));
                this.impuleRegulationGroup.setBounds(252, 136, 232, 107);
                this.impuleRegulationGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.impuleRegulationGroup.setLayout((Layout)new RowLayout(512));
                this.regulationTypeLabel = new CLabel((Composite)this.impuleRegulationGroup, 131072);
                this.regulationTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.regulationTypeLabel.setText(Messages.getString((String)"GDE_MSGT1632"));
                this.regulationTypeLabel.setLayoutData((Object)new RowData(110, 20));
                this.regulationTypeLabel.setToolTipText(Messages.getString((String)"GDE_MSGT1633"));
                this.voltageLimitLabel = new CLabel((Composite)this.impuleRegulationGroup, 131072);
                this.voltageLimitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.voltageLimitLabel.setText(Messages.getString((String)"GDE_MSGT1634"));
                this.voltageLimitLabel.setLayoutData((Object)new RowData(110, 20));
                this.voltageLimitLabel.setToolTipText(Messages.getString((String)"GDE_MSGT1635"));
                this.cellTypeLabel = new CLabel((Composite)this.impuleRegulationGroup, 131072);
                this.cellTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.cellTypeLabel.setText(Messages.getString((String)"GDE_MSGT1636"));
                this.cellTypeLabel.setLayoutData((Object)new RowData(110, 20));
                this.regulationTypeCombo = new CCombo((Composite)this.impuleRegulationGroup, 0x1000800);
                this.regulationTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.regulationTypeCombo.setItems(Messages.getString((String)"GDE_MSGT1637").split(";"));
                this.regulationTypeCombo.setLayoutData((Object)new RowData(75, GDE.IS_LINUX ? 22 : 20));
                this.regulationTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "regulationTypeCombo.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.impulsReductionType = LiPoWatchDialog.this.regulationTypeCombo.getSelectionIndex();
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.voltageLevelRegulationCombo = new CCombo((Composite)this.impuleRegulationGroup, 2048);
                this.voltageLevelRegulationCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.voltageLevelRegulationCombo.setItems(CELL_VOLTAGE_LIMITS);
                this.voltageLevelRegulationCombo.setLayoutData((Object)new RowData(75, GDE.IS_LINUX ? 22 : 20));
                this.voltageLevelRegulationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "voltageLimitCombo.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.voltageLevelRegulationLimit = LiPoWatchDialog.this.voltageLevelRegulationCombo.getSelectionIndex();
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.cellTypeCombo = new CCombo((Composite)this.impuleRegulationGroup, 2048);
                this.cellTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.cellTypeCombo.setLayoutData((Object)new RowData(75, GDE.IS_LINUX ? 22 : 20));
                this.cellTypeCombo.setItems(Messages.getString((String)"GDE_MSGT1640").split(";"));
                this.cellTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "cellTypeCombo.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.cellType = LiPoWatchDialog.this.cellTypeCombo.getSelectionIndex();
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.impuleRegulationGroup.layout();
                this.measurementTypeGroup = new Group(this.configMainComosite, 0);
                this.measurementTypeGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.measurementTypeGroup.setLayout(null);
                this.measurementTypeGroup.setText(Messages.getString((String)"GDE_MSGT1642"));
                this.measurementTypeGroup.setBounds(252, 89, 232, 45);
                this.measurementTypeGroup.setToolTipText(Messages.getString((String)"GDE_MSGT1643"));
                this.measurementTypeGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.measurementTypeGroup.setLayout((Layout)new GridLayout(2, true));
                this.measurementModusLabel = new CLabel((Composite)this.measurementTypeGroup, 131072);
                this.measurementModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.measurementModusLabel.setText(Messages.getString((String)"GDE_MSGT1644"));
                GridData labelGridData = new GridData(72, 20);
                labelGridData.horizontalSpan = 1;
                this.measurementModusLabel.setLayoutData((Object)labelGridData);
                this.measurementModusLabel.setToolTipText(Messages.getString((String)"GDE_MSGT1643"));
                this.measurementModusCombo = new CCombo((Composite)this.measurementTypeGroup, 2048);
                this.measurementModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                GridData comboGridData = new GridData(104, GDE.IS_LINUX ? 22 : 20);
                comboGridData.horizontalSpan = 1;
                this.measurementModusCombo.setLayoutData((Object)comboGridData);
                this.measurementModusCombo.setItems(Messages.getString((String)"GDE_MSGT1646").split(";"));
                this.measurementModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "measurementTypeCombo.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.measurementModus = LiPoWatchDialog.this.measurementModusCombo.getSelectionIndex();
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(true);
                    }
                });
                this.measurementTypeGroup.layout();
                this.dataTabItem = new CTabItem(this.mainTabFolder, 0);
                this.dataTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dataTabItem.setText(Messages.getString((String)"GDE_MSGT1648"));
                this.dataTabItem.setToolTipText(Messages.getString((String)"GDE_MSGT1649"));
                this.dataMainComposite = new Composite((Composite)this.mainTabFolder, 0);
                this.dataMainComposite.setLayout(null);
                this.dataTabItem.setControl((Control)this.dataMainComposite);
                this.dataMainComposite.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.dataReadGroup = new Group(this.dataMainComposite, 0);
                this.dataReadGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dataReadGroup.setBounds(12, 12, 241, 275);
                this.dataReadGroup.setText(Messages.getString((String)"GDE_MSGT1650"));
                this.dataReadGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.readDataButton = new Button((Composite)this.dataReadGroup, 0x1000008);
                this.readDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.readDataButton.setText(Messages.getString((String)"GDE_MSGT1651"));
                this.readDataButton.setBounds(11, 24, 218, 30);
                this.readDataButton.setEnabled(this.isLiveGathererEnabled);
                this.readDataButton.setToolTipText(Messages.getString((String)"GDE_MSGT1651"));
                this.readDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "readDataButton.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.gatherThread = new LiPoWatchDataGatherer(LiPoWatchDialog.this.application, LiPoWatchDialog.this.device, LiPoWatchDialog.this.serialPort);
                        try {
                            LiPoWatchDialog.this.gatherThread.start();
                        }
                        catch (RuntimeException e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                        LiPoWatchDialog.this.setClosePossible(false);
                        LiPoWatchDialog.this.readConfigButton.setEnabled(false);
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(false);
                        LiPoWatchDialog.this.readDataButton.setEnabled(false);
                        LiPoWatchDialog.this.stopReadDataButton.setEnabled(true);
                        LiPoWatchDialog.this.startLoggingButton.setEnabled(false);
                        LiPoWatchDialog.this.stopLoggingButton.setEnabled(false);
                        LiPoWatchDialog.this.startLiveGatherButton.setEnabled(false);
                        LiPoWatchDialog.this.clearMemoryButton.setEnabled(false);
                        LiPoWatchDialog.this.closeButton.setEnabled(false);
                    }
                });
                this.dataSetLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.dataSetLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dataSetLabel.setBounds(5, GDE.IS_MAC_COCOA ? 59 : 74, 165, 20);
                this.dataSetLabel.setText(Messages.getString((String)"GDE_MSGT1653"));
                this.redDataSetLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.redDataSetLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.redDataSetLabel.setBounds(175, GDE.IS_MAC_COCOA ? 59 : 74, 55, 20);
                this.redDataSetLabel.setText("0");
                this.actualDataSetNumberLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.actualDataSetNumberLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.actualDataSetNumberLabel.setBounds(5, GDE.IS_MAC_COCOA ? 81 : 96, 190, 20);
                this.actualDataSetNumberLabel.setText(Messages.getString((String)"GDE_MSGT1654"));
                this.actualDataSetNumber = new CLabel((Composite)this.dataReadGroup, 131072);
                this.actualDataSetNumber.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.actualDataSetNumber.setBounds(200, GDE.IS_MAC_COCOA ? 81 : 96, 30, 20);
                this.actualDataSetNumber.setText("0");
                this.readDataErrorLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.readDataErrorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.readDataErrorLabel.setBounds(5, GDE.IS_MAC_COCOA ? 103 : 118, 190, 20);
                this.readDataErrorLabel.setText(Messages.getString((String)"GDE_MSGT1655"));
                this.numberReadErrorLabel = new CLabel((Composite)this.dataReadGroup, 131072);
                this.numberReadErrorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.numberReadErrorLabel.setBounds(200, GDE.IS_MAC_COCOA ? 103 : 118, 30, 20);
                this.numberReadErrorLabel.setText("0");
                this.readLess4Label = new CLabel((Composite)this.dataReadGroup, 131072);
                this.readLess4Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.readLess4Label.setBounds(5, GDE.IS_MAC_COCOA ? 125 : 140, 190, 20);
                this.readLess4Label.setText(Messages.getString((String)"GDE_MSGT1659"));
                this.numberLess4Label = new CLabel((Composite)this.dataReadGroup, 131072);
                this.numberLess4Label.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.numberLess4Label.setBounds(200, GDE.IS_MAC_COCOA ? 125 : 140, 30, 20);
                this.numberLess4Label.setText("0");
                this.readDataProgressBar = new ProgressBar((Composite)this.dataReadGroup, 0);
                this.readDataProgressBar.setBounds(11, GDE.IS_MAC_COCOA ? 169 : 183, 218, 20);
                this.readDataProgressBar.setMinimum(0);
                this.readDataProgressBar.setMaximum(100);
                this.stopReadDataButton = new Button((Composite)this.dataReadGroup, 0x1000008);
                this.stopReadDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopReadDataButton.setBounds(11, GDE.IS_MAC_COCOA ? 207 : 222, 218, 30);
                this.stopReadDataButton.setText(Messages.getString((String)"GDE_MSGT0278"));
                this.stopReadDataButton.setEnabled(false);
                this.stopReadDataButton.setToolTipText(Messages.getString((String)"GDE_MSGT1656"));
                this.stopReadDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "stopDataButton.widgetSelected, event=" + evt);
                        }
                        if (LiPoWatchDialog.this.gatherThread != null && LiPoWatchDialog.this.gatherThread.isAlive()) {
                            LiPoWatchDialog.this.gatherThread.setThreadStop();
                        }
                        LiPoWatchDialog.this.resetButtons();
                    }
                });
                this.liveDataCaptureGroup = new Group(this.dataMainComposite, 0);
                this.liveDataCaptureGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.liveDataCaptureGroup.setBounds(259, 12, 228, 174);
                this.liveDataCaptureGroup.setText(Messages.getString((String)"GDE_MSGT1657"));
                this.liveDataCaptureGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.startLiveGatherButton = new Button((Composite)this.liveDataCaptureGroup, 0x1000008);
                this.startLiveGatherButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startLiveGatherButton.setText(Messages.getString((String)"GDE_MSGT1658"));
                this.startLiveGatherButton.setBounds(12, GDE.IS_MAC_COCOA ? 9 : 24, 202, 30);
                this.startLiveGatherButton.setEnabled(this.isLiveGathererEnabled);
                this.startLiveGatherButton.setToolTipText(Messages.getString((String)"GDE_MSGT1658"));
                this.startLiveGatherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "liveViewButton.widgetSelected, event=" + evt);
                        }
                        try {
                            LiPoWatchDialog.this.setButtonStateLiveGatherer(false);
                            LiPoWatchDialog.this.setClosePossible(false);
                            LiPoWatchDialog.this.liveThread = new LiPoWatchLiveGatherer(LiPoWatchDialog.this.application, LiPoWatchDialog.this.device, LiPoWatchDialog.this.serialPort, LiPoWatchDialog.this);
                            try {
                                LiPoWatchDialog.this.liveThread.start();
                            }
                            catch (RuntimeException e) {
                                log.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                        catch (Exception e) {
                            if (LiPoWatchDialog.this.liveThread != null && LiPoWatchDialog.this.liveThread.isTimerRunning) {
                                LiPoWatchDialog.this.liveThread.stopTimerThread();
                                LiPoWatchDialog.this.liveThread.interrupt();
                            }
                            LiPoWatchDialog.this.application.updateGraphicsWindow();
                            LiPoWatchDialog.this.application.openMessageDialog(LiPoWatchDialog.this.getDialogShell(), e.getClass().getSimpleName() + e.getMessage());
                            LiPoWatchDialog.this.resetButtons();
                        }
                    }
                });
                this.loggingGroup = new Group((Composite)this.liveDataCaptureGroup, 0);
                this.loggingGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.loggingGroup.setBounds(12, GDE.IS_MAC_COCOA ? 40 : 56, 202, 63);
                this.loggingGroup.setText(Messages.getString((String)"GDE_MSGT1660"));
                this.loggingGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.loggingGroup.setLayout((Layout)new GridLayout(2, true));
                this.startLoggingButton = new Button((Composite)this.loggingGroup, 0x1000008);
                this.startLoggingButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.startLoggingButton.setText(Messages.getString((String)"GDE_MSGT1661"));
                GridData startGridData = new GridData(70, 30);
                startGridData.horizontalSpan = 1;
                startGridData.horizontalAlignment = 0x1000000;
                startGridData.grabExcessHorizontalSpace = true;
                this.startLoggingButton.setLayoutData((Object)startGridData);
                this.startLoggingButton.setEnabled(true);
                this.startLoggingButton.setToolTipText(Messages.getString((String)"GDE_MSGT1662"));
                this.startLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "startLoggingButton.widgetSelected, event=" + evt);
                        }
                        try {
                            LiPoWatchDialog.this.setClosePossible(false);
                            LiPoWatchDialog.this.serialPort.startLogging();
                            LiPoWatchDialog.this.startLoggingButton.setEnabled(false);
                            LiPoWatchDialog.this.stopLoggingButton.setEnabled(true);
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            LiPoWatchDialog.this.application.openMessageDialog(LiPoWatchDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        }
                    }
                });
                this.stopLoggingButton = new Button((Composite)this.loggingGroup, 0x1000008);
                this.stopLoggingButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopLoggingButton.setText(Messages.getString((String)"GDE_MSGT1663"));
                GridData stopGridData = new GridData(70, 30);
                stopGridData.horizontalSpan = 1;
                stopGridData.horizontalAlignment = 0x1000000;
                stopGridData.grabExcessHorizontalSpace = true;
                this.stopLoggingButton.setLayoutData((Object)stopGridData);
                this.stopLoggingButton.setEnabled(false);
                this.stopLoggingButton.setToolTipText(Messages.getString((String)"GDE_MSGT1664"));
                this.stopLoggingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "stopLoggingButton.widgetSelected, event=" + evt);
                        }
                        try {
                            LiPoWatchDialog.this.serialPort.stopLogging();
                            LiPoWatchDialog.this.startLoggingButton.setEnabled(true);
                            LiPoWatchDialog.this.stopLoggingButton.setEnabled(false);
                            LiPoWatchDialog.this.setClosePossible(true);
                            if (!LiPoWatchDialog.this.stopLiveGatherButton.getEnabled()) {
                                LiPoWatchDialog.this.readDataButton.setEnabled(true);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            LiPoWatchDialog.this.application.openMessageDialog(LiPoWatchDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE0029", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                        }
                    }
                });
                this.loggingGroup.layout();
                this.stopLiveGatherButton = new Button((Composite)this.liveDataCaptureGroup, 0x1000008);
                this.stopLiveGatherButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.stopLiveGatherButton.setBounds(12, GDE.IS_MAC_COCOA ? 111 : 126, 202, 30);
                this.stopLiveGatherButton.setText(Messages.getString((String)"GDE_MSGT1665"));
                this.stopLiveGatherButton.setEnabled(!this.isLiveGathererEnabled);
                this.stopLiveGatherButton.setToolTipText(Messages.getString((String)"GDE_MSGT1666"));
                this.stopLiveGatherButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "stopLiveGatherButton.widgetSelected, event=" + evt);
                        }
                        if (LiPoWatchDialog.this.liveThread != null) {
                            LiPoWatchDialog.this.liveThread.stopTimerThread();
                            LiPoWatchDialog.this.liveThread.interrupt();
                            if (Channels.getInstance().getActiveChannel() != null) {
                                RecordSet activeRecordSet = Channels.getInstance().getActiveChannel().getActiveRecordSet();
                                if (LiPoWatchDialog.this.liveThread != null) {
                                    LiPoWatchDialog.this.liveThread.finalizeRecordSet(activeRecordSet.getName());
                                }
                            }
                        }
                        LiPoWatchDialog.this.setButtonStateLiveGatherer(true);
                        LiPoWatchDialog.this.setClosePossible(true);
                        if (!LiPoWatchDialog.this.stopLoggingButton.getEnabled()) {
                            LiPoWatchDialog.this.readDataButton.setEnabled(true);
                        }
                    }
                });
                this.clearMemoryGroup = new Group(this.dataMainComposite, 0);
                this.clearMemoryGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.clearMemoryGroup.setText(Messages.getString((String)"GDE_MSGT1667"));
                this.clearMemoryGroup.setBounds(259, 187, 228, 100);
                this.clearMemoryGroup.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.clearMemoryGroup.setLayout((Layout)new RowLayout(512));
                this.clearMemoryLabel = new CLabel((Composite)this.clearMemoryGroup, 0x1000000);
                this.clearMemoryLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.clearMemoryLabel.setText(Messages.getString((String)"GDE_MSGT1604"));
                this.clearMemoryLabel.setLayoutData((Object)new RowData(205, GDE.IS_WINDOWS ? 40 : 30));
                this.clearMemoryButton = new Button((Composite)this.clearMemoryGroup, 0x1000008);
                this.clearMemoryButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.clearMemoryButton.setText(Messages.getString((String)"GDE_MSGT1668"));
                this.clearMemoryButton.setLayoutData((Object)new RowData(205, 30));
                this.clearMemoryButton.setEnabled(this.isLiveGathererEnabled);
                this.clearMemoryButton.setToolTipText(Messages.getString((String)"GDE_MSGT1603"));
                this.clearMemoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "deleteMemoryButton.widgetSelected, event=" + evt);
                        }
                        try {
                            LiPoWatchDialog.this.clearMemoryButton.setEnabled(false);
                            LiPoWatchDialog.this.serialPort.clearMemory();
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, e.getMessage(), e);
                            LiPoWatchDialog.this.application.openMessageDialog(LiPoWatchDialog.this.getDialogShell(), Messages.getString((String)"GDE_MSGE1600", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
                            e.printStackTrace();
                        }
                        LiPoWatchDialog.this.clearMemoryButton.setEnabled(true);
                    }
                });
                this.clearMemoryGroup.layout();
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT1605"));
                this.closeButton.setBounds(110, 318, 280, 31);
                this.closeButton.setToolTipText(Messages.getString((String)"GDE_MSGT1606"));
                this.closeButton.addMouseTrackListener((MouseTrackListener)this.mouseTrackerEnterFadeOut);
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "closeButton.widgetSelected, event=" + evt);
                        }
                        LiPoWatchDialog.this.dispose();
                    }
                });
                this.mainTabFolder.setBounds(0, 0, 501, 312);
                this.mainTabFolder.setSelection(0);
                this.initialize();
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void updateConfigurationValues(byte[] readBuffer) {
        this.memoryUsed = ((readBuffer[8] & 0xFF) << 24) + ((readBuffer[7] & 0xFF) << 16) + ((readBuffer[6] & 0xFF) << 8) + (readBuffer[5] & 0xFF);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "memoryUsed = " + this.memoryUsed);
        }
        this.serialNumber = "" + (((readBuffer[10] & 0xFF) << 8) + (readBuffer[9] & 0xFF));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "serialNumber = " + this.serialNumber);
        }
        this.lipoWatchVersion = String.format(Locale.ENGLISH, "v%.2f", (double)(readBuffer[11] & 0xFF) / 100.0);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unilogVersion = " + this.lipoWatchVersion);
        }
        int memoryDeleted = readBuffer[12] & 0xFF;
        int tmpMemoryUsed = 0;
        tmpMemoryUsed = memoryDeleted > 0 ? 0 : this.memoryUsed;
        this.memoryUsedPercent = String.format("%.2f", (double)tmpMemoryUsed * 100.0 / 1048320.0);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "memoryUsedPercent = " + this.memoryUsedPercent + " (" + tmpMemoryUsed + "/" + 25920 + ")");
        }
        this.timeIntervalPosition = readBuffer[13] & 0xFF;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "timeIntervalPosition = " + this.timeIntervalPosition);
        }
        this.measurementModus = readBuffer[14] & 0xFF;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "measurementModus(relative, absolute) = " + this.measurementModus);
        }
        this.isAutoStartTime = false;
        this.timeAutoStart_sec = 0;
        if ((readBuffer[15] & 0x80) != 0) {
            this.isAutoStartTime = true;
        }
        this.timeAutoStart_sec = readBuffer[15] & 0x7F;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isAutoStartTime = " + this.isAutoStartTime + " timeAutoStart_sec = " + this.timeAutoStart_sec);
        }
        this.voltageLevelRegulationLimit = (readBuffer[16] & 0xFF) - 20;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "voltageLevelRegulationLimit = " + this.voltageLevelRegulationLimit);
        }
        this.isAutStartRx = (readBuffer[17] & 0x80) != 0;
        this.isRxOn = (readBuffer[17] & 0x7F) == 0;
        this.rxAutoStartValue = this.isRxOn ? (readBuffer[17] & 0x7F) + 9 : (readBuffer[17] & 0x7F) - 11;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isAutStartRx = " + this.isAutStartRx + " isRxOn = " + this.isRxOn + " rxAutoStartValue = " + this.rxAutoStartValue);
        }
        this.impulsReductionType = readBuffer[18] & 0x7F;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "impulsReductionType = " + this.impulsReductionType);
        }
        this.isAutoStartVoltageDrop = false;
        if ((readBuffer[19] & 0xFF) != 0) {
            this.isAutoStartVoltageDrop = true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isAutoStartVoltageDrop = " + this.isAutoStartVoltageDrop);
        }
        this.cellType = readBuffer[20] & 0xFF;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "cellType = " + this.cellType);
        }
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    int timeSelect;
                    LiPoWatchDialog.this.snLabel.setText(LiPoWatchDialog.this.serialNumber);
                    LiPoWatchDialog.this.firmwareVersionLabel.setText(LiPoWatchDialog.this.lipoWatchVersion);
                    LiPoWatchDialog.this.memUsagePercent.setText(LiPoWatchDialog.this.memoryUsedPercent);
                    LiPoWatchDialog.this.timeIntervalCombo.select(LiPoWatchDialog.this.timeIntervalPosition);
                    LiPoWatchDialog.this.updateTimeStep_ms(LiPoWatchDialog.this.timeIntervalPosition);
                    LiPoWatchDialog.this.measurementModusCombo.select(LiPoWatchDialog.this.measurementModus);
                    LiPoWatchDialog.this.timeTriggerButton.setSelection(LiPoWatchDialog.this.isAutoStartTime);
                    for (timeSelect = 0; timeSelect < LiPoWatchDialog.this.timeTriggerCombo.getItemCount() && LiPoWatchDialog.this.timeAutoStart_sec < Integer.parseInt(LiPoWatchDialog.this.timeTriggerCombo.getItems()[timeSelect].trim()); ++timeSelect) {
                    }
                    LiPoWatchDialog.this.timeTriggerCombo.select(timeSelect);
                    LiPoWatchDialog.this.timeTriggerCombo.setText(String.format("%4s", LiPoWatchDialog.this.timeAutoStart_sec));
                    LiPoWatchDialog.this.voltageLevelRegulationCombo.select(LiPoWatchDialog.this.voltageLevelRegulationLimit);
                    LiPoWatchDialog.this.impulseTriggerButton.setSelection(LiPoWatchDialog.this.isAutStartRx);
                    LiPoWatchDialog.this.impulseTriggerCombo.select(LiPoWatchDialog.this.rxAutoStartValue);
                    LiPoWatchDialog.this.regulationTypeCombo.select(LiPoWatchDialog.this.impulsReductionType);
                    LiPoWatchDialog.this.voltageDropTriggerButton.setSelection(LiPoWatchDialog.this.isAutoStartVoltageDrop);
                    LiPoWatchDialog.this.cellTypeCombo.select(LiPoWatchDialog.this.cellType);
                    TaskBar taskBar = LiPoWatchDialog.this.dialogShell.getDisplay().getSystemTaskBar();
                    if (taskBar == null) {
                        LiPoWatchDialog.this.taskBarItem = null;
                    } else {
                        TaskItem taskItem = LiPoWatchDialog.this.taskBarItem = taskBar.getItem(LiPoWatchDialog.this.dialogShell) != null ? taskBar.getItem(LiPoWatchDialog.this.dialogShell) : taskBar.getItem(null);
                        if (!LiPoWatchDialog.this.readDataButton.getEnabled() && LiPoWatchDialog.this.taskBarItem != null) {
                            LiPoWatchDialog.this.taskBarItem.setProgressState(GDE.IS_MAC ? 1 : 0);
                        }
                    }
                }
            });
        }
    }

    public byte[] buildUpdateBuffer() {
        int checkSum = 0;
        byte[] updateBuffer = new byte[21];
        updateBuffer[0] = -64;
        updateBuffer[1] = 4;
        checkSum += 0xFF & updateBuffer[1];
        updateBuffer[2] = 17;
        checkSum += 0xFF & updateBuffer[2];
        updateBuffer[3] = 2;
        checkSum += 0xFF & updateBuffer[3];
        updateBuffer[4] = 0;
        updateBuffer[5] = 0;
        updateBuffer[6] = 0;
        updateBuffer[7] = 0;
        updateBuffer[8] = 0;
        updateBuffer[9] = 0;
        updateBuffer[10] = 0;
        updateBuffer[11] = 0;
        updateBuffer[12] = (byte)this.timeIntervalCombo.getSelectionIndex();
        checkSum += 0xFF & updateBuffer[12];
        updateBuffer[13] = (byte)this.measurementModusCombo.getSelectionIndex();
        checkSum += 0xFF & updateBuffer[13];
        if (this.timeTriggerButton.getSelection()) {
            updateBuffer[14] = (byte)(Byte.parseByte(this.timeTriggerCombo.getText().trim()) | 0x80);
        } else {
            int autoStartZeit = Integer.parseInt(this.timeTriggerCombo.getText().trim());
            autoStartZeit -= autoStartZeit % 5;
            updateBuffer[14] = (byte)(autoStartZeit & 0x7F);
        }
        checkSum += 0xFF & updateBuffer[14];
        updateBuffer[15] = (byte)(this.voltageLevelRegulationCombo.getSelectionIndex() + 20);
        checkSum += 0xFF & updateBuffer[15];
        updateBuffer[16] = this.impulseTriggerButton.getSelection() ? (this.impulseTriggerCombo.getSelectionIndex() + 1 == RX_AUTO_START_MS.length ? -128 : (byte)((this.impulseTriggerCombo.getSelectionIndex() | 0x80) + 11)) : (this.impulseTriggerCombo.getSelectionIndex() + 1 == RX_AUTO_START_MS.length ? 0 : (int)(this.impulseTriggerCombo.getSelectionIndex() + 11));
        checkSum += 0xFF & updateBuffer[16];
        updateBuffer[17] = (byte)this.regulationTypeCombo.getSelectionIndex();
        checkSum += 0xFF & updateBuffer[17];
        updateBuffer[18] = (byte)(this.voltageDropTriggerButton.getSelection() ? 1 : 0);
        checkSum += 0xFF & updateBuffer[18];
        updateBuffer[19] = (byte)this.cellTypeCombo.getSelectionIndex();
        updateBuffer[20] = (byte)((checkSum += 0xFF & updateBuffer[19]) % 256);
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("updateBuffer = [");
            for (int i = 0; i < updateBuffer.length; ++i) {
                if (i == updateBuffer.length - 1) {
                    sb.append(String.format("%02X", updateBuffer[i]));
                    continue;
                }
                sb.append(String.format("%02X ", updateBuffer[i]));
            }
            sb.append("]");
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, sb.toString());
            }
        }
        return updateBuffer;
    }

    public void resetDataSetsLabel() {
        if (Thread.currentThread().getId() == this.application.getThreadId()) {
            this.numberRedDataSetsText = "0";
            this.numberActualDataSetsText = "0";
            this.numberReadErrorText = "0";
            this.numberLess4Text = "0";
            this.redDataSetLabel.setText(this.numberRedDataSetsText);
            this.actualDataSetNumber.setText(this.numberActualDataSetsText);
            this.numberReadErrorLabel.setText(this.numberReadErrorText);
            this.numberLess4Label.setText(this.numberLess4Text);
            this.readDataProgressBar.setSelection(0);
            if (this.taskBarItem != null) {
                this.taskBarItem.setProgress(0);
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LiPoWatchDialog.this.numberRedDataSetsText = "0";
                    LiPoWatchDialog.this.numberActualDataSetsText = "0";
                    LiPoWatchDialog.this.numberReadErrorText = "0";
                    LiPoWatchDialog.this.redDataSetLabel.setText(LiPoWatchDialog.this.numberRedDataSetsText);
                    LiPoWatchDialog.this.actualDataSetNumber.setText(LiPoWatchDialog.this.numberActualDataSetsText);
                    LiPoWatchDialog.this.numberReadErrorLabel.setText(LiPoWatchDialog.this.numberReadErrorText);
                    LiPoWatchDialog.this.numberLess4Label.setText(LiPoWatchDialog.this.numberLess4Text);
                    LiPoWatchDialog.this.readDataProgressBar.setSelection(0);
                    if (LiPoWatchDialog.this.taskBarItem != null) {
                        LiPoWatchDialog.this.taskBarItem.setProgress(0);
                    }
                }
            });
        }
    }

    public void resetButtons() {
        if (Thread.currentThread().getId() == this.application.getThreadId()) {
            this.readConfigButton.setEnabled(true);
            this.storeConfigButton.setEnabled(false);
            this.readDataButton.setEnabled(true);
            this.stopReadDataButton.setEnabled(false);
            this.startLoggingButton.setEnabled(true);
            this.stopLoggingButton.setEnabled(false);
            this.startLiveGatherButton.setEnabled(true);
            this.stopLiveGatherButton.setEnabled(false);
            this.clearMemoryButton.setEnabled(true);
            this.closeButton.setEnabled(true);
            this.setClosePossible(true);
            if (this.taskBarItem != null) {
                this.taskBarItem.setProgressState(-1);
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!LiPoWatchDialog.this.readConfigButton.isDisposed()) {
                        LiPoWatchDialog.this.readConfigButton.setEnabled(true);
                        LiPoWatchDialog.this.storeConfigButton.setEnabled(false);
                        LiPoWatchDialog.this.readDataButton.setEnabled(true);
                        LiPoWatchDialog.this.stopReadDataButton.setEnabled(false);
                        LiPoWatchDialog.this.startLoggingButton.setEnabled(true);
                        LiPoWatchDialog.this.stopLoggingButton.setEnabled(false);
                        LiPoWatchDialog.this.startLiveGatherButton.setEnabled(true);
                        LiPoWatchDialog.this.stopLiveGatherButton.setEnabled(false);
                        LiPoWatchDialog.this.clearMemoryButton.setEnabled(true);
                        LiPoWatchDialog.this.closeButton.setEnabled(true);
                        LiPoWatchDialog.this.setClosePossible(true);
                        if (LiPoWatchDialog.this.taskBarItem != null) {
                            LiPoWatchDialog.this.taskBarItem.setProgressState(-1);
                        }
                    }
                }
            });
        }
    }

    void setButtonStateLiveGatherer(boolean liveGathererEnabled) {
        this.isLiveGathererEnabled = liveGathererEnabled;
        if (this.dialogShell != null && !this.dialogShell.isDisposed()) {
            this.readConfigButton.setEnabled(this.isLiveGathererEnabled);
            this.storeConfigButton.setEnabled(false);
            this.startLiveGatherButton.setEnabled(this.isLiveGathererEnabled);
            this.readDataButton.setEnabled(this.isLiveGathererEnabled);
            this.stopReadDataButton.setEnabled(false);
            this.stopLiveGatherButton.setEnabled(!this.isLiveGathererEnabled);
            this.clearMemoryButton.setEnabled(this.isLiveGathererEnabled);
            this.closeButton.setEnabled(this.isLiveGathererEnabled);
        }
    }

    void updateTimeStep_ms(int timeIntervalIndex) {
        switch (timeIntervalIndex) {
            default: {
                this.device.setTimeStep_ms(250.0);
                break;
            }
            case 1: {
                this.device.setTimeStep_ms(500.0);
                break;
            }
            case 2: {
                this.device.setTimeStep_ms(1000.0);
                break;
            }
            case 3: {
                this.device.setTimeStep_ms(2000.0);
                break;
            }
            case 4: {
                this.device.setTimeStep_ms(5000.0);
                break;
            }
            case 5: {
                this.device.setTimeStep_ms(10000.0);
            }
        }
        this.device.storeDeviceProperties();
    }

    public void setReadDataProgressBar(final int value) {
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                int tmpValue = value < 0 ? 0 : value;
                tmpValue = value > 100 ? 100 : value;
                LiPoWatchDialog.this.readDataProgressBar.setSelection(tmpValue);
                if (LiPoWatchDialog.this.taskBarItem != null) {
                    LiPoWatchDialog.this.taskBarItem.setProgress(tmpValue);
                }
            }
        });
    }

    public void updateDataGatherProgress(final int redTelegrams, int numberRecordSet, int numReadErrors, int numLess4Measurements, final int memoryUsedValue) {
        this.numberRedDataSetsText = "" + redTelegrams;
        this.numberActualDataSetsText = "" + numberRecordSet;
        this.numberReadErrorText = "" + numReadErrors;
        this.numberLess4Text = "" + numLess4Measurements;
        GDE.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                int progress = redTelegrams * 100 / memoryUsedValue;
                int tmpValue = progress < 0 ? 0 : progress;
                tmpValue = progress > 100 ? 100 : progress;
                LiPoWatchDialog.this.readDataProgressBar.setSelection(tmpValue);
                if (LiPoWatchDialog.this.taskBarItem != null) {
                    LiPoWatchDialog.this.taskBarItem.setProgress(tmpValue);
                }
                LiPoWatchDialog.this.redDataSetLabel.setText(LiPoWatchDialog.this.numberRedDataSetsText);
                LiPoWatchDialog.this.actualDataSetNumber.setText(LiPoWatchDialog.this.numberActualDataSetsText);
                LiPoWatchDialog.this.numberReadErrorLabel.setText(LiPoWatchDialog.this.numberReadErrorText);
                LiPoWatchDialog.this.numberLess4Label.setText(LiPoWatchDialog.this.numberLess4Text);
            }
        });
    }

    private void initialize() {
        this.snLabel.setText(this.serialNumber);
        this.firmwareVersionLabel.setText(this.lipoWatchVersion);
        this.memUsagePercent.setText(this.memoryUsedPercent);
        this.timeIntervalCombo.select(this.timeIntervalPosition);
        this.measurementModusCombo.select(this.measurementModus);
        this.voltageDropTriggerButton.setSelection(this.isAutoStartVoltageDrop);
        this.timeTriggerButton.setSelection(this.isAutoStartTime);
        this.impulseTriggerButton.setSelection(this.isAutStartRx);
        this.regulationTypeCombo.select(this.impulsReductionType);
        this.voltageLevelRegulationCombo.select(this.voltageLevelRegulationLimit);
        this.cellTypeCombo.select(this.cellType);
    }
}

