/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend.form;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.XhtmlForm;
import org.xhtmlrenderer.simple.extend.form.FormField;
import org.xhtmlrenderer.simple.extend.form.FormFieldState;
import org.xhtmlrenderer.util.GeneralUtil;

class SelectField
extends FormField {
    public SelectField(Element e, XhtmlForm form2, LayoutContext context, BlockBox box) {
        super(e, form2, context, box);
    }

    @Override
    public JComponent create() {
        List optionList = this.createList();
        if (this.shouldRenderAsList()) {
            JList<Object> select2 = new JList<Object>(optionList.toArray());
            this.applyComponentStyle(select2);
            select2.setCellRenderer(new CellRenderer());
            select2.addListSelectionListener(new HeadingItemListener());
            if (this.hasAttribute("multiple") && this.getAttribute("multiple").equalsIgnoreCase("true")) {
                select2.setSelectionMode(2);
            } else {
                select2.setSelectionMode(0);
            }
            int size = 0;
            if (this.hasAttribute("size")) {
                size = GeneralUtil.parseIntRelaxed(this.getAttribute("size"));
            }
            if (size == 0) {
                select2.setVisibleRowCount(Math.min(select2.getModel().getSize(), 20));
            } else {
                select2.setVisibleRowCount(size);
            }
            return new JScrollPane(select2);
        }
        JComboBox<Object> select3 = new JComboBox<Object>(optionList.toArray());
        this.applyComponentStyle(select3);
        select3.setEditable(false);
        select3.setRenderer(new CellRenderer());
        select3.addItemListener(new HeadingItemListener());
        return select3;
    }

    @Override
    protected FormFieldState loadOriginalState() {
        ArrayList<Integer> list2 = new ArrayList<Integer>();
        NodeList options = this.getElement().getElementsByTagName("option");
        for (int i2 = 0; i2 < options.getLength(); ++i2) {
            Element option = (Element)options.item(i2);
            if (!option.hasAttribute("selected") || !option.getAttribute("selected").equalsIgnoreCase("selected")) continue;
            list2.add(new Integer(i2));
        }
        return FormFieldState.fromList(list2);
    }

    @Override
    protected void applyOriginalState() {
        if (this.shouldRenderAsList()) {
            JList select2 = (JList)((JScrollPane)this.getComponent()).getViewport().getView();
            select2.setSelectedIndices(this.getOriginalState().getSelectedIndices());
        } else {
            JComboBox select3 = (JComboBox)this.getComponent();
            int[] indices = this.getOriginalState().getSelectedIndices();
            if (indices.length == 0) {
                select3.setSelectedIndex(0);
            } else {
                select3.setSelectedIndex(indices[indices.length - 1]);
            }
        }
    }

    @Override
    protected String[] getFieldValues() {
        if (this.shouldRenderAsList()) {
            JList select2 = (JList)((JScrollPane)this.getComponent()).getViewport().getView();
            Object[] selectedValues = select2.getSelectedValues();
            String[] submitValues = new String[selectedValues.length];
            for (int i2 = 0; i2 < selectedValues.length; ++i2) {
                NameValuePair pair = (NameValuePair)selectedValues[i2];
                if (pair.getValue() == null) continue;
                submitValues[i2] = pair.getValue();
            }
            return submitValues;
        }
        JComboBox select3 = (JComboBox)this.getComponent();
        NameValuePair selectedValue = (NameValuePair)select3.getSelectedItem();
        if (selectedValue != null && selectedValue.getValue() != null) {
            return new String[]{selectedValue.getValue()};
        }
        return new String[0];
    }

    private List createList() {
        ArrayList list2 = new ArrayList();
        this.addChildren(list2, this.getElement(), 0);
        return list2;
    }

    private void addChildren(List list2, Element e, int indent) {
        NodeList children = e.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            if (!(children.item(i2) instanceof Element)) continue;
            Element child = (Element)children.item(i2);
            if ("option".equals(child.getNodeName())) {
                String optionText;
                String optionValue = optionText = XhtmlForm.collectText(child);
                if (child.hasAttribute("value")) {
                    optionValue = child.getAttribute("value");
                }
                list2.add(new NameValuePair(optionText, optionValue, indent));
                continue;
            }
            if (!"optgroup".equals(child.getNodeName())) continue;
            String titleText = child.getAttribute("label");
            list2.add(new NameValuePair(titleText, null, indent));
            this.addChildren(list2, child, indent + 1);
        }
    }

    private boolean shouldRenderAsList() {
        int size;
        boolean result2 = false;
        if (this.hasAttribute("multiple") && this.getAttribute("multiple").equalsIgnoreCase("true")) {
            result2 = true;
        } else if (this.hasAttribute("size") && (size = GeneralUtil.parseIntRelaxed(this.getAttribute("size"))) > 0) {
            result2 = true;
        }
        return result2;
    }

    private static class HeadingItemListener
    implements ItemListener,
    ListSelectionListener {
        private Object oldSelection = null;
        private int[] oldSelections = new int[0];

        private HeadingItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 1) {
                return;
            }
            if (!(e.getSource() instanceof JComboBox)) {
                return;
            }
            JComboBox combo = (JComboBox)e.getSource();
            if (((NameValuePair)e.getItem()).getValue() == null) {
                combo.setSelectedItem(this.oldSelection);
            } else {
                this.oldSelection = e.getItem();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!(e.getSource() instanceof JList)) {
                return;
            }
            JList list2 = (JList)e.getSource();
            ListModel model = list2.getModel();
            for (int i2 = e.getFirstIndex(); i2 <= e.getLastIndex(); ++i2) {
                NameValuePair pair;
                if (!list2.isSelectedIndex(i2) || (pair = (NameValuePair)model.getElementAt(i2)) == null || pair.getValue() != null) continue;
                if (list2.getSelectedIndices().length == 1) {
                    list2.setSelectedIndices(this.oldSelections);
                } else {
                    list2.removeSelectionInterval(i2, i2);
                }
                return;
            }
            if (!e.getValueIsAdjusting()) {
                this.oldSelections = list2.getSelectedIndices();
            }
        }
    }

    private static class CellRenderer
    extends DefaultListCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected2, boolean cellHasFocus) {
            NameValuePair pair = (NameValuePair)value;
            if (pair != null && pair.getValue() == null) {
                super.getListCellRendererComponent((JList<?>)list2, value, index, false, false);
                Font fold2 = this.getFont();
                Font fnew = new Font(fold2.getName(), 3, fold2.getSize());
                this.setFont(fnew);
            } else {
                super.getListCellRendererComponent((JList<?>)list2, value, index, isSelected2, cellHasFocus);
            }
            return this;
        }
    }

    private static class NameValuePair {
        private String _name;
        private String _value;
        private int _indent;

        public NameValuePair(String name, String value, int indent) {
            this._name = name;
            this._value = value;
            this._indent = indent;
        }

        public String getName() {
            return this._name;
        }

        public String getValue() {
            return this._value;
        }

        public int getIndent() {
            return this._indent;
        }

        public String toString() {
            String txt = this.getName();
            for (int i2 = 0; i2 < this.getIndent(); ++i2) {
                txt = "    " + txt;
            }
            return txt;
        }
    }
}

