/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.StringTokenizer;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSavePanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    Callback callback_completion_handler;
    Callback callback_overwrite_existing_file;
    NSSavePanel panel;
    NSPopUpButton popup;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    String fullPath;
    SWTPanelDelegate delegate = null;
    int filterIndex = -1;
    long jniRef = 0L;
    long method = 0L;
    long methodImpl = 0L;
    boolean overwrite = false;
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        if (Display.getSheetEnabled() && parent != null && (style & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    long _completionHandler(long result2) {
        this.handleResponse(result2);
        return result2;
    }

    long _overwriteExistingFileCheck(long id2, long sel, long str) {
        return 1L;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    void handleResponse(long response) {
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            NSApplication.sharedApplication().stopModal();
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(null);
        this.filterIndex = this.popup != null ? (int)this.popup.indexOfSelectedItem() : -1;
        if (response == 1L) {
            NSString filename = this.panel.filename();
            if ((this.style & 0x2000) != 0) {
                this.fullPath = filename.getString();
                this.fileNames = new String[1];
                this.fileName = this.fileNames[0] = filename.lastPathComponent().getString();
                this.filterPath = filename.stringByDeletingLastPathComponent().getString();
            } else {
                this.fullPath = filename.getString();
                NSArray filenames = ((NSOpenPanel)this.panel).filenames();
                int count = (int)filenames.count();
                this.fileNames = new String[count];
                int i2 = 0;
                while (i2 < count) {
                    filename = new NSString(filenames.objectAtIndex(i2));
                    NSString filenameOnly = filename.lastPathComponent();
                    NSString pathOnly = filename.stringByDeletingLastPathComponent();
                    if (i2 == 0) {
                        this.filterPath = pathOnly.getString();
                        this.fileName = this.fileNames[0] = filenameOnly.getString();
                    } else {
                        this.fileNames[i2] = pathOnly.getString().equals(this.filterPath) ? filenameOnly.getString() : filename.getString();
                    }
                    ++i2;
                }
            }
        }
        this.releaseHandles();
    }

    public String open() {
        this.fullPath = null;
        if ((this.style & 0x2000) != 0) {
            NSSavePanel savePanel;
            this.panel = savePanel = NSSavePanel.savePanel();
            if (!this.overwrite) {
                this.callback_overwrite_existing_file = new Callback(this, "_overwriteExistingFileCheck", 3);
                long proc = this.callback_overwrite_existing_file.getAddress();
                if (proc == 0L) {
                    this.error(3);
                }
                this.method = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_overwriteExistingFileCheck);
                if (this.method != 0L) {
                    this.methodImpl = OS.method_setImplementation(this.method, proc);
                }
            }
        } else {
            NSOpenPanel openPanel = NSOpenPanel.openPanel();
            openPanel.setAllowsMultipleSelection((this.style & 2) != 0);
            this.panel = openPanel;
        }
        this.panel.setCanCreateDirectories(true);
        this.jniRef = 0L;
        this.delegate = null;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            this.delegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            this.jniRef = OS.NewGlobalRef(this);
            if (this.jniRef == 0L) {
                this.error(2);
            }
            OS.object_setInstanceVariable(this.delegate.id, Display.SWT_OBJECT, this.jniRef);
            this.panel.setDelegate(this.delegate);
            NSPopUpButton widget = (NSPopUpButton)new NSPopUpButton().alloc();
            widget.initWithFrame(new NSRect(), false);
            widget.setTarget(this.delegate);
            widget.setAction(OS.sel_sendSelection_);
            NSMenu menu2 = widget.menu();
            menu2.setAutoenablesItems(false);
            int i2 = 0;
            while (i2 < this.filterExtensions.length) {
                String str = this.filterExtensions[i2];
                if (this.filterNames != null && this.filterNames.length > i2) {
                    str = this.filterNames[i2];
                }
                NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
                nsItem.initWithTitle(NSString.stringWith(str), 0L, NSString.string());
                menu2.addItem(nsItem);
                nsItem.release();
                ++i2;
            }
            int selectionIndex = this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length ? this.filterIndex : 0;
            widget.selectItemAtIndex(selectionIndex);
            widget.sizeToFit();
            this.panel.setAccessoryView(widget);
            this.popup = widget;
            this.setAllowedFileType(this.filterExtensions[selectionIndex]);
            this.panel.setAllowsOtherFileTypes(true);
            this.panel.setTreatsFilePackagesAsDirectories(this.shouldTreatAppAsDirectory(this.filterExtensions[selectionIndex]));
        } else {
            this.panel.setTreatsFilePackagesAsDirectories(false);
        }
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        if (this.filterPath != null && this.filterPath.length() > 0) {
            NSString dir = NSString.stringWith(this.filterPath);
            this.panel.setDirectoryURL(NSURL.fileURLWithPath(dir));
        }
        if (this.fileName != null && this.fileName.length() > 0) {
            this.panel.setNameFieldStringValue(NSString.stringWith(this.fileName));
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(this, this.panel);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            this.callback_completion_handler = new Callback(this, "_completionHandler", 1);
            long handler = this.callback_completion_handler.getAddress();
            if (handler == 0L) {
                this.error(3);
            }
            OS.beginSheetModalForWindow(this.panel, this.parent.view.window(), handler);
            NSApplication.sharedApplication().runModalForWindow(this.parent.view.window());
        } else {
            long response = this.panel.runModal();
            this.handleResponse(response);
        }
        return this.fullPath;
    }

    long panel_shouldShowFilename(long id2, long sel, long arg0, long arg1) {
        if ((this.style & 0x2000) != 0) {
            return 1L;
        }
        NSString path2 = new NSString(arg1);
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            NSFileManager manager = NSFileManager.defaultManager();
            long ptr = C.malloc(1L);
            boolean found = manager.fileExistsAtPath(path2, ptr);
            byte[] isDirectory = new byte[1];
            C.memmove(isDirectory, ptr, 1L);
            C.free(ptr);
            if (found) {
                if (isDirectory[0] != 0) {
                    return 1L;
                }
                if (this.popup != null) {
                    String fileName = path2.lastPathComponent().getString();
                    int filterIndex = (int)this.popup.indexOfSelectedItem();
                    String extensions = this.filterExtensions[filterIndex];
                    int start = 0;
                    int length = extensions.length();
                    while (start < length) {
                        String filter2;
                        int index = extensions.indexOf(59, start);
                        if (index == -1) {
                            index = length;
                        }
                        if ((filter2 = extensions.substring(start, index).trim()).equalsIgnoreCase(fileName)) {
                            return 1L;
                        }
                        if (filter2.equals("*") || filter2.equals("*.*")) {
                            return 1L;
                        }
                        if (filter2.startsWith("*.")) {
                            filter2 = filter2.substring(2);
                        } else if (filter2.startsWith(".")) {
                            filter2 = filter2.substring(1);
                        }
                        if (fileName.toLowerCase().endsWith("." + filter2.toLowerCase())) {
                            return 1L;
                        }
                        start = index + 1;
                    }
                    return 0L;
                }
            }
        }
        return 1L;
    }

    void releaseHandles() {
        if (!this.overwrite) {
            if (this.method != 0L) {
                OS.method_setImplementation(this.method, this.methodImpl);
            }
            if (this.callback_overwrite_existing_file != null) {
                this.callback_overwrite_existing_file.dispose();
            }
            this.callback_overwrite_existing_file = null;
        }
        if (this.callback_completion_handler != null) {
            this.callback_completion_handler.dispose();
            this.callback_completion_handler = null;
        }
        if (this.popup != null) {
            this.panel.setAccessoryView(null);
            this.popup.release();
            this.popup = null;
        }
        if (this.delegate != null) {
            this.panel.setDelegate(null);
            this.delegate.release();
            this.delegate = null;
        }
        if (this.jniRef != 0L) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0L;
        this.panel = null;
    }

    void sendSelection(long id2, long sel, long arg) {
        if (this.filterExtensions != null && this.filterExtensions.length > 0) {
            String fileTypes = this.filterExtensions[(int)this.popup.indexOfSelectedItem()];
            this.panel.setTreatsFilePackagesAsDirectories(this.shouldTreatAppAsDirectory(fileTypes));
            this.setAllowedFileType(fileTypes);
        }
        this.panel.validateVisibleColumns();
    }

    void setAllowedFileType(String fileTypes) {
        if (fileTypes == null) {
            return;
        }
        StringTokenizer fileTypesToken = new StringTokenizer(fileTypes, String.valueOf(';'));
        NSMutableArray allowedFileTypes = NSMutableArray.arrayWithCapacity(1L);
        while (fileTypesToken.hasMoreTokens()) {
            int index;
            String fileType = fileTypesToken.nextToken();
            if (fileType.equals("*") || fileType.equals("*.*")) {
                this.panel.setAllowedFileTypes(null);
                return;
            }
            if (fileType.startsWith("*.")) {
                fileType = fileType.substring(2);
            } else if (fileType.startsWith(".")) {
                fileType = fileType.substring(1);
            }
            if ((this.style & 0x2000) == 0 && (index = fileType.lastIndexOf(".")) != -1 && index + 1 < fileType.length()) {
                fileType = fileType.substring(index + 1);
            }
            allowedFileTypes.addObject(NSString.stringWith(fileType));
        }
        this.panel.setAllowedFileTypes(allowedFileTypes);
    }

    public void setFileName(String string2) {
        this.fileName = string2;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string2) {
        this.filterPath = string2;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    boolean shouldTreatAppAsDirectory(String extensions) {
        if ((this.style & 0x2000) != 0) {
            return false;
        }
        StringTokenizer fileTypesToken = new StringTokenizer(extensions, String.valueOf(';'));
        while (fileTypesToken.hasMoreTokens()) {
            String fileType = fileTypesToken.nextToken();
            if (fileType.equals("*") || fileType.equals("*.*")) {
                return true;
            }
            if (!fileType.equals("*.app") && !fileType.equals(".app")) continue;
            return false;
        }
        return true;
    }
}

