/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSComboBoxCell;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableString;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTComboBox;
import org.eclipse.swt.internal.cocoa.SWTPopUpButton;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    String text;
    int textLimit = LIMIT;
    boolean receivingFocus;
    boolean ignoreSetObject;
    boolean ignoreSelection;
    NSRange selectionRange;
    boolean listVisible;
    static final int VISIBLE_COUNT = 5;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        NSAttributedString str = this.createString(string2);
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)this.view;
            long selection2 = widget.indexOfSelectedItem();
            NSMenu nsMenu = widget.menu();
            NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString empty = NSString.string();
            nsItem.initWithTitle(empty, 0L, empty);
            nsItem.setAttributedTitle(str);
            nsMenu.addItem(nsItem);
            nsItem.release();
            if (selection2 == -1L) {
                widget.selectItemAtIndex(-1L);
            }
        } else {
            ((NSComboBox)this.view).addItemWithObjectValue(str);
        }
    }

    public void add(String string2, int index) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        NSAttributedString str = this.createString(string2);
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)this.view;
            long selection2 = widget.indexOfSelectedItem();
            NSMenu nsMenu = widget.menu();
            NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
            NSString empty = NSString.string();
            nsItem.initWithTitle(empty, 0L, empty);
            nsItem.setAttributedTitle(str);
            nsMenu.insertItem(nsItem, index);
            nsItem.release();
            if (selection2 == -1L) {
                widget.selectItemAtIndex(-1L);
            }
        } else {
            ((NSComboBox)this.view).insertItemWithObjectValue(str, index);
        }
    }

    public void addModifyListener(ModifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(listener2));
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(25, typedListener);
    }

    @Override
    boolean becomeFirstResponder(long id2, long sel) {
        this.receivingFocus = true;
        boolean result2 = super.becomeFirstResponder(id2, sel);
        this.receivingFocus = false;
        return result2;
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point selection2 = this.getSelection();
            selection2.y = selection2.x;
            this.setSelection(selection2);
        }
    }

    @Override
    void setObjectValue(long id2, long sel, long arg0) {
        super.setObjectValue(id2, sel, this.ignoreSetObject ? arg0 : this.createString((String)this.text).id);
    }

    @Override
    void comboBoxSelectionDidChange(long id2, long sel, long notification) {
        NSComboBox widget = (NSComboBox)this.view;
        long tableSelection = widget.indexOfSelectedItem();
        widget.selectItemAtIndex(tableSelection);
        NSAttributedString attStr = new NSAttributedString(widget.itemObjectValueAtIndex(tableSelection));
        NSString nsString = attStr.string();
        if (nsString != null) {
            this.setText(nsString.getString(), true);
        }
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13, null, this.display.trackingControl != this);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed2) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        NSControl widget = (NSControl)this.view;
        NSCell viewCell = widget.cell();
        NSSize size = viewCell.cellSize();
        width = (int)Math.ceil(size.width);
        height = (int)Math.ceil(size.height);
        if ((this.style & 8) == 0) {
            int frameHeight;
            String str;
            this.ignoreSetObject = true;
            NSComboBoxCell cell = new NSComboBoxCell(viewCell.id);
            NSArray array = cell.objectValues();
            int length = (int)array.count();
            if (length > 0) {
                cell = new NSComboBoxCell(cell.copy());
                int i2 = 0;
                while (i2 < length) {
                    NSAttributedString attStr = new NSAttributedString(array.objectAtIndex(i2));
                    cell.setAttributedStringValue(attStr);
                    size = cell.cellSize();
                    width = Math.max(width, (int)Math.ceil(size.width));
                    ++i2;
                }
                cell.release();
            }
            this.ignoreSetObject = false;
            NSString nsStr = widget.stringValue();
            if (nsStr != null && (str = nsStr.getString()) != null && (str.indexOf(10) >= 0 || str.indexOf(13) >= 0) && (frameHeight = (int)this.view.frame().height) > 0) {
                height = frameHeight;
            }
        } else {
            NSPopUpButton nsPopUpButton = (NSPopUpButton)this.view;
            if (nsPopUpButton.numberOfItems() == 1L && nsPopUpButton.indexOfSelectedItem() == -1L) {
                nsPopUpButton.selectItemAtIndex(0L);
                size = viewCell.cellSize();
                width = Math.max(width, (int)Math.ceil(size.width));
                nsPopUpButton.selectItemAtIndex(-1L);
            }
        }
        if (hHint != -1 && ((this.style & 8) != 0 || hHint < height)) {
            height = hHint;
        }
        if (wHint != -1) {
            width = wHint;
        }
        return new Point(width, height);
    }

    public void copy() {
        this.checkWidget();
        Point selection2 = this.getSelection();
        if (selection2.x == selection2.y) {
            return;
        }
        this.copyToClipboard(this.getText(selection2.x, selection2.y));
    }

    @Override
    void createHandle() {
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)new SWTPopUpButton().alloc();
            widget.initWithFrame(new NSRect(), false);
            widget.menu().setAutoenablesItems(false);
            widget.setTarget(widget);
            widget.setAction(OS.sel_sendSelection);
            widget.menu().setDelegate(widget);
            this.view = widget;
        } else {
            NSComboBox widget = (NSComboBox)new SWTComboBox().alloc();
            widget.init();
            widget.setDelegate(widget);
            NSCell cell = widget.cell();
            if (OS.VERSION >= 4192 && cell != null) {
                cell.setUsesSingleLineMode(true);
            }
            this.view = widget;
        }
    }

    NSAttributedString createString(String string2) {
        NSAttributedString attribStr = this.createString(string2, null, this.foreground, 16384, false, true, false);
        attribStr.autorelease();
        return attribStr;
    }

    @Override
    void createWidget() {
        this.text = "";
        super.createWidget();
        if ((this.style & 8) == 0) {
            NSComboBox widget = (NSComboBox)this.view;
            NSScreen screen = widget.window().screen();
            NSRect rect = screen != null ? screen.frame() : NSScreen.mainScreen().frame();
            int visibleCount = Math.max(5, (int)(rect.height / 3.0 / widget.itemHeight()));
            widget.setNumberOfVisibleItems(visibleCount);
        }
    }

    @Override
    void comboBoxWillDismiss(long id2, long sel, long notification) {
        this.display.currentCombo = null;
        this.listVisible = false;
    }

    @Override
    void comboBoxWillPopUp(long id2, long sel, long notification) {
        this.display.currentCombo = this;
        this.listVisible = true;
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point selection2 = this.getSelection();
        if (selection2.x == selection2.y) {
            return;
        }
        int start = selection2.x;
        int end = selection2.y;
        String text2 = this.getText();
        String leftText = text2.substring(0, start);
        String rightText = text2.substring(end, text2.length());
        String oldText = text2.substring(start, end);
        String newText = "";
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        char[] buffer = new char[oldText.length()];
        oldText.getChars(0, buffer.length, buffer, 0);
        this.copyToClipboard(buffer);
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    @Override
    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    @Override
    NSFont defaultNSFont() {
        if ((this.style & 8) != 0) {
            return this.display.popUpButtonFont;
        }
        return this.display.comboBoxFont;
    }

    @Override
    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        if (index == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItem(null);
                this.sendEvent(24);
            } else {
                ((NSComboBox)this.view).deselectItemAtIndex(index);
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).selectItem(null);
            this.sendEvent(24);
        } else {
            NSComboBox widget = (NSComboBox)this.view;
            long index = widget.indexOfSelectedItem();
            if (index != -1L) {
                widget.deselectItemAtIndex(index);
            }
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter2, boolean[] consume2) {
        if ((this.style & 8) == 0) {
            NSText fieldEditor = ((NSControl)this.view).currentEditor();
            if (fieldEditor != null) {
                NSRange selectedRange = fieldEditor.selectedRange();
                if (selectedRange.length > 0L) {
                    NSTextView feAsTextView = new NSTextView(fieldEditor);
                    NSPoint textViewMouse = new NSPoint();
                    textViewMouse.x = x;
                    textViewMouse.y = y;
                    long charPosition = feAsTextView.characterIndexForInsertionAtPoint(textViewMouse);
                    if (charPosition != OS.NSNotFound() && charPosition >= selectedRange.location && charPosition < selectedRange.location + selectedRange.length && super.dragDetect(x, y, filter2, consume2)) {
                        if (consume2 != null) {
                            consume2[0] = true;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        return super.dragDetect(x, y, filter2, consume2);
    }

    @Override
    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        return cursor != null || (this.style & 8) != 0 ? cursor : this.display.getSystemCursor(19);
    }

    @Override
    NSRect focusRingMaskBoundsForFrame(long id2, long sel, NSRect cellFrame, long view) {
        return cellFrame;
    }

    public int getCaretPosition() {
        this.checkWidget();
        return this.selectionRange != null ? (int)this.selectionRange.location : 0;
    }

    public Point getCaretLocation() {
        this.checkWidget();
        NSTextView widget = null;
        if (this.hasFocus()) {
            widget = new NSTextView(this.view.window().fieldEditor(true, this.view));
        }
        if (widget == null) {
            return new Point(0, 0);
        }
        NSLayoutManager layoutManager = widget.layoutManager();
        NSTextContainer container = widget.textContainer();
        NSRange range = widget.selectedRange();
        long[] rectCount = new long[1];
        long pArray = layoutManager.rectArrayForCharacterRange(range, range, container, rectCount);
        NSRect rect = new NSRect();
        if (rectCount[0] > 0L) {
            OS.memmove(rect, pArray, (long)NSRect.sizeof);
        }
        NSPoint pt = new NSPoint();
        pt.x = (int)rect.x;
        pt.y = (int)rect.y;
        pt = widget.convertPoint_toView_(pt, this.view);
        return new Point((int)pt.x, (int)pt.y);
    }

    int getCharCount() {
        NSString str = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (str == null) {
            return 0;
        }
        return (int)str.length();
    }

    public String getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        NSString str = null;
        if ((this.style & 8) != 0) {
            str = ((NSPopUpButton)this.view).itemTitleAtIndex(index);
        } else {
            NSAttributedString attString = new NSAttributedString(((NSComboBox)this.view).itemObjectValueAtIndex(index));
            if (attString != null) {
                str = attString.string();
            }
        }
        if (str == null) {
            this.error(8);
        }
        return str.getString();
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return (int)((NSPopUpButton)this.view).numberOfItems();
        }
        return (int)((NSComboBox)this.view).numberOfItems();
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result2 = new String[count];
        int i2 = 0;
        while (i2 < count) {
            result2[i2] = this.getItem(i2);
            ++i2;
        }
        return result2;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.listVisible;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    @Override
    int getMininumHeight() {
        return this.getTextHeight();
    }

    @Override
    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selectionRange == null) {
            NSString str = new NSTextFieldCell(((NSTextField)this.view).cell()).title();
            return new Point((int)str.length(), (int)str.length());
        }
        return new Point((int)this.selectionRange.location, (int)(this.selectionRange.location + this.selectionRange.length));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return (int)((NSPopUpButton)this.view).indexOfSelectedItem();
        }
        return (int)((NSComboBox)this.view).indexOfSelectedItem();
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int start, int end) {
        NSString str = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (str == null) {
            return new char[0];
        }
        NSRange range = new NSRange();
        range.location = start;
        if (end == -1) {
            long length = str.length();
            range.length = length - (long)start;
        } else {
            range.length = end - start;
        }
        char[] buffer = new char[(int)range.length];
        str.getCharacters(buffer, range);
        return buffer;
    }

    public int getTextHeight() {
        this.checkWidget();
        NSCell cell = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).cell() : ((NSComboBox)this.view).cell();
        return (int)cell.cellSize().height;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        return (int)((NSComboBox)this.view).numberOfVisibleItems();
    }

    public int indexOf(String string2) {
        return this.indexOf(string2, 0);
    }

    public int indexOf(String string2, int start) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (start < 0 || start >= count) {
            return -1;
        }
        int i2 = start;
        while (i2 < count) {
            if (string2.equals(this.getItem(i2))) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    @Override
    boolean isEventView(long id2) {
        return true;
    }

    @Override
    void menuWillOpen(long id2, long sel, long menu2) {
        this.listVisible = true;
    }

    @Override
    void menuDidClose(long id2, long sel, long menu2) {
        this.listVisible = false;
    }

    @Override
    void mouseDown(long id2, long sel, long theEvent) {
        this.display.sendPreExternalEventDispatchEvent();
        NSView viewCopy = this.view;
        viewCopy.retain();
        super.mouseDown(id2, sel, theEvent);
        viewCopy.release();
        this.display.sendPostExternalEventDispatchEvent();
    }

    public void paste() {
        int charCount;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point selection2 = this.getSelection();
        int start = selection2.x;
        int end = selection2.y;
        String text2 = this.getText();
        String leftText = text2.substring(0, start);
        String rightText = text2.substring(end, text2.length());
        String newText = this.getClipboardText();
        if (newText == null) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (newText = this.verifyText(newText, start, end, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (charCount = text2.length()) - (end - start) + newText.length() > this.textLimit) {
            newText = newText.substring(0, this.textLimit - charCount + (end - start));
        }
        this.setText(String.valueOf(leftText) + newText + rightText, false);
        this.setSelection(new Point(start += newText.length(), start));
        this.sendEvent(24);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    @Override
    void releaseWidget() {
        if (this.display.currentCombo == this) {
            this.display.currentCombo = null;
        }
        super.releaseWidget();
        if ((this.style & 8) == 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.text = null;
        this.selectionRange = null;
    }

    public void remove(int index) {
        this.checkWidget();
        if (index == -1) {
            this.error(6);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeItemAtIndex(index);
        } else {
            ((NSComboBox)this.view).removeItemAtIndex(index);
        }
    }

    public void remove(int start, int end) {
        int newEnd;
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = this.getItemCount();
        if (start < 0 || start > end || end >= count) {
            this.error(6);
        }
        int i2 = newEnd = Math.min(end, count - 1);
        while (i2 >= start) {
            this.remove(i2);
            --i2;
        }
    }

    public void remove(String string2) {
        int index;
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        if ((index = this.indexOf(string2, 0)) == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeAllItems();
        } else {
            this.setText("", true);
            ((NSComboBox)this.view).removeAllItems();
        }
        this.ignoreSelection = false;
    }

    public void removeModifyListener(ModifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener2);
    }

    public void removeSegmentListener(SegmentListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, listener2);
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    public void removeVerifyListener(VerifyListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener2);
    }

    public void select(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index >= 0 && index < count) {
            if (index == this.getSelectionIndex()) {
                return;
            }
            this.ignoreSelection = true;
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItemAtIndex(index);
                this.sendEvent(24);
            } else {
                NSComboBox widget = (NSComboBox)this.view;
                widget.deselectItemAtIndex(index);
                widget.selectItemAtIndex(index);
            }
            this.ignoreSelection = false;
        }
    }

    @Override
    void sendSelection() {
        this.sendEvent(24);
        if (!this.ignoreSelection) {
            this.sendSelectionEvent(13);
        }
    }

    @Override
    boolean sendKeyEvent(NSEvent nsEvent, int type2) {
        boolean result2 = super.sendKeyEvent(nsEvent, type2);
        if (!result2) {
            return result2;
        }
        int stateMask = 0;
        long modifierFlags = nsEvent.modifierFlags();
        if ((modifierFlags & 0x80000L) != 0L) {
            stateMask |= 0x10000;
        }
        if ((modifierFlags & 0x20000L) != 0L) {
            stateMask |= 0x20000;
        }
        if ((modifierFlags & 0x40000L) != 0L) {
            stateMask |= 0x40000;
        }
        if ((modifierFlags & 0x100000L) != 0L) {
            stateMask |= 0x400000;
        }
        if (type2 != 1) {
            return result2;
        }
        short keyCode = nsEvent.keyCode();
        if (stateMask == 0x400000) {
            switch (keyCode) {
                case 7: {
                    this.cut();
                    return false;
                }
                case 8: {
                    this.copy();
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    if ((this.style & 8) != 0) break;
                    ((NSComboBox)this.view).selectText(null);
                    return false;
                }
            }
        }
        switch (keyCode) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
            }
        }
        return result2;
    }

    boolean sendTrackingKeyEvent(NSEvent nsEvent, int type2) {
        long modifiers = nsEvent.modifierFlags();
        if ((modifiers & 0x20000L) == 0L) {
            short keyCode = nsEvent.keyCode();
            switch (keyCode) {
                case 125: 
                case 126: {
                    this.sendKeyEvent(nsEvent, type2);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        if ((this.style & 8) == 0) {
            ((NSTextField)this.view).setBackgroundColor(nsColor);
        }
    }

    @Override
    void setBackgroundImage(NSImage image) {
    }

    @Override
    void setBounds(int x, int y, int width, int height, boolean move2, boolean resize) {
        if ((this.style & 8) == 0) {
            int frameHeight;
            String str;
            NSControl widget = (NSControl)this.view;
            int hLimit = 0;
            NSString nsStr = widget.stringValue();
            if (nsStr != null && (str = nsStr.getString()) != null && (str.indexOf(10) >= 0 || str.indexOf(13) >= 0) && (frameHeight = (int)this.view.frame().height) > 0) {
                hLimit = frameHeight;
            }
            if (hLimit == 0) {
                NSSize size = widget.cell().cellSize();
                hLimit = (int)Math.ceil(size.height);
            }
            height = Math.min(height, hLimit);
        }
        super.setBounds(x, y, width, height, move2, resize);
    }

    @Override
    void setFont(NSFont font) {
        super.setFont(font);
        this.updateItems();
    }

    @Override
    void setForeground(double[] color) {
        super.setForeground(color);
        this.updateItems();
        if ((this.style & 8) == 0) {
            NSColor nsColor = color == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0);
            ((NSTextField)this.view).setTextColor(nsColor);
        }
    }

    public void setItem(int index, String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        int selection2 = this.getSelectionIndex();
        NSAttributedString str = this.createString(string2);
        this.ignoreSelection = true;
        if ((this.style & 8) != 0) {
            NSMenuItem nsItem = ((NSPopUpButton)this.view).itemAtIndex(index);
            nsItem.setAttributedTitle(str);
            if (string2.length() == 0) {
                nsItem.setTitle(NSString.string());
            }
        } else {
            NSComboBox widget = (NSComboBox)this.view;
            widget.insertItemWithObjectValue(str, index);
            widget.removeItemAtIndex(index + 1);
        }
        if (selection2 != -1) {
            this.select(selection2);
        }
        this.ignoreSelection = false;
    }

    public void setItems(String ... items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        int i2 = 0;
        while (i2 < items.length) {
            if (items[i2] == null) {
                this.error(5);
            }
            ++i2;
        }
        this.removeAll();
        if (items.length == 0) {
            return;
        }
        this.ignoreSelection = true;
        i2 = 0;
        while (i2 < items.length) {
            NSAttributedString str = this.createString(items[i2]);
            if ((this.style & 8) != 0) {
                NSMenu nsMenu = ((NSPopUpButton)this.view).menu();
                NSMenuItem nsItem = (NSMenuItem)new NSMenuItem().alloc();
                NSString empty = NSString.string();
                nsItem.initWithTitle(empty, 0L, empty);
                nsItem.setAttributedTitle(str);
                nsMenu.addItem(nsItem);
                nsItem.release();
                ((NSPopUpButton)this.view).selectItemAtIndex(-1L);
            } else {
                ((NSComboBox)this.view).addItemWithObjectValue(str);
            }
            ++i2;
        }
        this.ignoreSelection = false;
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).setPullsDown(visible);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    @Override
    void setOrientation() {
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        ((NSControl)this.view).setBaseWritingDirection(direction);
    }

    public void setSelection(Point selection2) {
        this.checkWidget();
        if (selection2 == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            NSComboBox widget = (NSComboBox)this.view;
            NSString str = new NSCell(widget.cell()).title();
            int length = (int)str.length();
            int start = Math.min(Math.max(Math.min(selection2.x, selection2.y), 0), length);
            int end = Math.min(Math.max(Math.max(selection2.x, selection2.y), 0), length);
            this.selectionRange = new NSRange();
            this.selectionRange.location = start;
            this.selectionRange.length = end - start;
            NSText fieldEditor = widget.currentEditor();
            if (fieldEditor != null) {
                fieldEditor.setSelectedRange(this.selectionRange);
            }
        }
    }

    public void setText(String string2) {
        this.checkWidget();
        if (string2 == null) {
            this.error(4);
        }
        this.setText(string2, true);
    }

    void setText(String string2, boolean notify) {
        if (notify && (this.hooks(25) || this.filters(25)) && (string2 = this.verifyText(string2, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string2);
            if (index != -1) {
                this.select(index);
            }
        } else {
            char[] buffer = new char[Math.min(string2.length(), this.textLimit)];
            string2.getChars(0, buffer.length, buffer, 0);
            this.text = new String(buffer, 0, buffer.length);
            ((NSComboBox)this.view).cell().setAttributedStringValue(this.createString(this.text));
            if (notify) {
                this.sendEvent(24);
            }
        }
        this.selectionRange = null;
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            ((NSComboBox)this.view).setNumberOfVisibleItems(count);
        }
    }

    @Override
    boolean shouldChangeTextInRange_replacementString(long id2, long sel, long affectedCharRange, long replacementString) {
        NSRange range = new NSRange();
        OS.memmove(range, affectedCharRange, (long)NSRange.sizeof);
        boolean result2 = this.callSuperBoolean(id2, sel, range, replacementString);
        if (this.hooks(25)) {
            String newText;
            String string2 = new NSString(replacementString).getString();
            NSEvent currentEvent = this.display.application.currentEvent();
            long type2 = currentEvent.type();
            if (type2 != 10L && type2 != 11L) {
                currentEvent = null;
            }
            if ((newText = this.verifyText(string2, (int)range.location, (int)(range.location + range.length), currentEvent)) == null) {
                return false;
            }
            if (!string2.equals(newText)) {
                int charCount;
                int length = newText.length();
                Point selection2 = this.getSelection();
                if (this.textLimit != LIMIT && (charCount = this.getCharCount()) - (selection2.y - selection2.x) + length > this.textLimit) {
                    length = this.textLimit - charCount + (selection2.y - selection2.x);
                }
                char[] buffer = new char[length];
                newText.getChars(0, buffer.length, buffer, 0);
                NSString nsstring = NSString.stringWithCharacters(buffer, buffer.length);
                NSText fieldEditor = ((NSTextField)this.view).currentEditor();
                fieldEditor.replaceCharactersInRange(fieldEditor.selectedRange(), nsstring);
                this.text = fieldEditor.string().getString();
                this.sendEvent(24);
                result2 = false;
            }
        }
        if (result2) {
            char[] chars = new char[this.text.length()];
            this.text.getChars(0, chars.length, chars, 0);
            NSMutableString mutable = (NSMutableString)NSMutableString.stringWithCharacters(chars, chars.length);
            mutable.replaceCharactersInRange(range, new NSString(replacementString));
            this.text = mutable.getString();
            this.selectionRange = null;
        }
        return result2;
    }

    @Override
    void textViewDidChangeSelection(long id2, long sel, long aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSText editor = new NSText(notification.object().id);
        this.selectionRange = editor.selectedRange();
    }

    @Override
    void textDidChange(long id2, long sel, long aNotification) {
        super.textDidChange(id2, sel, aNotification);
        this.postEvent(24);
    }

    @Override
    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long id2, long sel, long aTextView, long oldSelectedCharRange, long newSelectedCharRange) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange result2 = new NSRange();
        OS.memmove(result2, newSelectedCharRange, (long)NSRange.sizeof);
        return result2;
    }

    void updateItems() {
        if ((this.style & 8) != 0) {
            NSPopUpButton widget = (NSPopUpButton)this.view;
            int count = (int)widget.numberOfItems();
            int i2 = 0;
            while (i2 < count) {
                NSMenuItem item2 = new NSMenuItem(widget.itemAtIndex(i2));
                NSAttributedString attStr = item2.attributedTitle();
                String string2 = attStr.string().getString();
                item2.setAttributedTitle(this.createString(string2));
                ++i2;
            }
        } else {
            NSComboBox widget = (NSComboBox)this.view;
            int count = (int)widget.numberOfItems();
            int i3 = 0;
            while (i3 < count) {
                NSAttributedString attStr = new NSAttributedString(widget.itemObjectValueAtIndex(i3));
                String string3 = attStr.string().getString();
                widget.insertItemWithObjectValue(this.createString(string3), i3);
                widget.removeItemAtIndex(i3 + 1);
                ++i3;
            }
            widget.cell().setAttributedStringValue(this.createString(this.text));
        }
    }

    String verifyText(String string2, int start, int end, NSEvent keyEvent) {
        Event event = new Event();
        if (keyEvent != null) {
            this.setKeyState(event, 3, keyEvent);
        }
        event.text = string2;
        event.start = start;
        event.end = end;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

