/*
 * Decompiled with CFR 0.152.
 */
package freemarker.debug.impl;

import freemarker.debug.DebugModel;
import freemarker.debug.impl.RmiDebuggedEnvironmentImpl;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;

class RmiDebugModelImpl
extends UnicastRemoteObject
implements DebugModel {
    private static final long serialVersionUID = 1L;
    private final TemplateModel model;
    private final int type;

    RmiDebugModelImpl(TemplateModel model, int extraTypes) throws RemoteException {
        this.model = model;
        this.type = RmiDebugModelImpl.calculateType(model) + extraTypes;
    }

    private static DebugModel getDebugModel(TemplateModel tm) throws RemoteException {
        return (DebugModel)RmiDebuggedEnvironmentImpl.getCachedWrapperFor(tm);
    }

    public String getAsString() throws TemplateModelException {
        return ((TemplateScalarModel)this.model).getAsString();
    }

    public Number getAsNumber() throws TemplateModelException {
        return ((TemplateNumberModel)this.model).getAsNumber();
    }

    public Date getAsDate() throws TemplateModelException {
        return ((TemplateDateModel)this.model).getAsDate();
    }

    public int getDateType() {
        return ((TemplateDateModel)this.model).getDateType();
    }

    public boolean getAsBoolean() throws TemplateModelException {
        return ((TemplateBooleanModel)this.model).getAsBoolean();
    }

    public int size() throws TemplateModelException {
        if (this.model instanceof TemplateSequenceModel) {
            return ((TemplateSequenceModel)this.model).size();
        }
        return ((TemplateHashModelEx)this.model).size();
    }

    public DebugModel get(int index) throws TemplateModelException, RemoteException {
        return RmiDebugModelImpl.getDebugModel(((TemplateSequenceModel)this.model).get(index));
    }

    public DebugModel[] get(int fromIndex, int toIndex) throws TemplateModelException, RemoteException {
        DebugModel[] dm = new DebugModel[toIndex - fromIndex];
        TemplateSequenceModel s = (TemplateSequenceModel)this.model;
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            dm[i2 - fromIndex] = RmiDebugModelImpl.getDebugModel(s.get(i2));
        }
        return dm;
    }

    public DebugModel[] getCollection() throws TemplateModelException, RemoteException {
        ArrayList<DebugModel> list2 = new ArrayList<DebugModel>();
        TemplateModelIterator i2 = ((TemplateCollectionModel)this.model).iterator();
        while (i2.hasNext()) {
            list2.add(RmiDebugModelImpl.getDebugModel(i2.next()));
        }
        return list2.toArray(new DebugModel[list2.size()]);
    }

    public DebugModel get(String key2) throws TemplateModelException, RemoteException {
        return RmiDebugModelImpl.getDebugModel(((TemplateHashModel)this.model).get(key2));
    }

    public DebugModel[] get(String[] keys2) throws TemplateModelException, RemoteException {
        DebugModel[] dm = new DebugModel[keys2.length];
        TemplateHashModel h = (TemplateHashModel)this.model;
        for (int i2 = 0; i2 < keys2.length; ++i2) {
            dm[i2] = RmiDebugModelImpl.getDebugModel(h.get(keys2[i2]));
        }
        return dm;
    }

    public String[] keys() throws TemplateModelException {
        TemplateHashModelEx h = (TemplateHashModelEx)this.model;
        ArrayList<String> list2 = new ArrayList<String>();
        TemplateModelIterator i2 = h.keys().iterator();
        while (i2.hasNext()) {
            list2.add(((TemplateScalarModel)i2.next()).getAsString());
        }
        return list2.toArray(new String[list2.size()]);
    }

    public int getModelTypes() {
        return this.type;
    }

    private static int calculateType(TemplateModel model) {
        int type2 = 0;
        if (model instanceof TemplateScalarModel) {
            ++type2;
        }
        if (model instanceof TemplateNumberModel) {
            type2 += 2;
        }
        if (model instanceof TemplateDateModel) {
            type2 += 4;
        }
        if (model instanceof TemplateBooleanModel) {
            type2 += 8;
        }
        if (model instanceof TemplateSequenceModel) {
            type2 += 16;
        }
        if (model instanceof TemplateCollectionModel) {
            type2 += 32;
        }
        if (model instanceof TemplateHashModelEx) {
            type2 += 128;
        } else if (model instanceof TemplateHashModel) {
            type2 += 64;
        }
        if (model instanceof TemplateMethodModelEx) {
            type2 += 512;
        } else if (model instanceof TemplateMethodModel) {
            type2 += 256;
        }
        if (model instanceof TemplateTransformModel) {
            type2 += 1024;
        }
        return type2;
    }
}

