/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.CacheStorageWithGetSize;
import freemarker.cache.ConcurrentCacheStorage;
import freemarker.template.utility.UndeclaredThrowableException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SoftCacheStorage
implements ConcurrentCacheStorage,
CacheStorageWithGetSize {
    private static final Method atomicRemove = SoftCacheStorage.getAtomicRemoveMethod();
    private final ReferenceQueue queue = new ReferenceQueue();
    private final Map map;
    private final boolean concurrent;

    public SoftCacheStorage() {
        this(new ConcurrentHashMap());
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public SoftCacheStorage(Map backingMap) {
        this.map = backingMap;
        this.concurrent = this.map instanceof ConcurrentMap;
    }

    public Object get(Object key2) {
        this.processQueue();
        Reference ref = (Reference)this.map.get(key2);
        return ref == null ? null : ref.get();
    }

    public void put(Object key2, Object value) {
        this.processQueue();
        this.map.put(key2, new SoftValueReference(key2, value, this.queue));
    }

    public void remove(Object key2) {
        this.processQueue();
        this.map.remove(key2);
    }

    public void clear() {
        this.map.clear();
        this.processQueue();
    }

    public int getSize() {
        this.processQueue();
        return this.map.size();
    }

    private void processQueue() {
        SoftValueReference ref;
        while ((ref = (SoftValueReference)this.queue.poll()) != null) {
            Object key2 = ref.getKey();
            if (this.concurrent) {
                try {
                    atomicRemove.invoke((Object)this.map, key2, ref);
                }
                catch (IllegalAccessException e) {
                    throw new UndeclaredThrowableException(e);
                }
                catch (InvocationTargetException e) {
                    throw new UndeclaredThrowableException(e);
                }
            }
            if (this.map.get(key2) != ref) continue;
            this.map.remove(key2);
        }
        return;
    }

    private static Method getAtomicRemoveMethod() {
        try {
            return Class.forName("java.util.concurrent.ConcurrentMap").getMethod("remove", Object.class, Object.class);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static final class SoftValueReference
    extends SoftReference {
        private final Object key;

        SoftValueReference(Object key2, Object value, ReferenceQueue queue) {
            super(value, queue);
            this.key = key2;
        }

        Object getKey() {
            return this.key;
        }
    }
}

