/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.reflect;

import java.lang.reflect.Proxy;

public final class ReflectUtil {
    public static final String PROXY_PACKAGE = "com.sun.proxy";

    private ReflectUtil() {
    }

    public static void checkPackageAccess(Class<?> clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            ReflectUtil.privateCheckPackageAccess(securityManager, clazz);
        }
    }

    private static void privateCheckPackageAccess(SecurityManager securityManager, Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string2 = clazz.getPackageName();
        if (string2 != null && !string2.isEmpty()) {
            securityManager.checkPackageAccess(string2);
        }
        if (ReflectUtil.isNonPublicProxyClass(clazz)) {
            ReflectUtil.privateCheckProxyPackageAccess(securityManager, clazz);
        }
    }

    public static void checkPackageAccess(String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            int n;
            String string3 = string2.replace('/', '.');
            if (string3.startsWith("[") && (n = string3.lastIndexOf(91) + 2) > 1 && n < string3.length()) {
                string3 = string3.substring(n);
            }
            if ((n = string3.lastIndexOf(46)) != -1) {
                securityManager.checkPackageAccess(string3.substring(0, n));
            }
        }
    }

    public static boolean isPackageAccessible(Class<?> clazz) {
        try {
            ReflectUtil.checkPackageAccess(clazz);
        }
        catch (SecurityException securityException) {
            return false;
        }
        return true;
    }

    private static void privateCheckProxyPackageAccess(SecurityManager securityManager, Class<?> clazz) {
        if (Proxy.isProxyClass(clazz)) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                ReflectUtil.privateCheckPackageAccess(securityManager, clazz2);
            }
        }
    }

    public static boolean isNonPublicProxyClass(Class<?> clazz) {
        if (!Proxy.isProxyClass(clazz)) {
            return false;
        }
        String string2 = clazz.getPackageName();
        return string2 == null || !string2.startsWith(PROXY_PACKAGE);
    }
}

