/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.log.Level;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public class Library {
    private static final Logger log = Logger.getLogger(Library.class.getName());
    static final String SEPARATOR = System.getProperty("file.separator");

    public static void loadLibrary(String name) {
        Library.loadLibrary(name, true);
    }

    static boolean extract(String fileName, String mappedName) {
        block13: {
            FileOutputStream os = null;
            InputStream is = null;
            File file = new File(fileName);
            log.log(Level.FINE, fileName + " exist " + file.exists());
            try {
                int read;
                is = Library.class.getResourceAsStream("/" + mappedName);
                if (is == null) break block13;
                byte[] buffer = new byte[4096];
                os = new FileOutputStream(fileName);
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                os.close();
                is.close();
                if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    try {
                        log.log(Level.FINE, "chmod 755 " + fileName);
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", fileName}).waitFor();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                log.log(Level.FINE, fileName + " exist " + new File(fileName).exists());
                if (Library.load(fileName)) {
                    return true;
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.getMessage(), e);
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    static boolean load(String libName) {
        try {
            if (libName.indexOf(SEPARATOR) != -1) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static void loadLibrary(String name, boolean mapName) {
        String mappedName;
        String libName;
        if (mapName) {
            libName = name;
            mappedName = System.mapLibraryName(libName);
        } else {
            libName = mappedName = name;
        }
        log.log(Level.INFO, "...loading library libname = " + libName + " mappedName = " + mappedName);
        if (Library.load(libName)) {
            return;
        }
        if (mapName && Library.load(libName)) {
            return;
        }
        String path = System.getProperty("user.dir");
        if (Library.load((path = new File(path).getAbsolutePath()) + SEPARATOR + mappedName)) {
            return;
        }
        path = System.getProperty("java.io.tmpdir");
        if (Library.load((path = new File(path).getAbsolutePath()) + SEPARATOR + mappedName)) {
            return;
        }
        if (path != null && Library.extract(path + SEPARATOR + mappedName, mappedName)) {
            return;
        }
        throw new UnsatisfiedLinkError("no " + libName + " in java.library.path or the jar file");
    }
}

