/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.GDE;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.GraphicsUtils;
import gde.utils.MathUtils;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class CurveUtils {
    private static Logger log = Logger.getLogger(CurveUtils.class.getName());

    public static void drawScale(Record record, GC gc, int x0, int y0, int width, int height, int scaleWidthSpace, boolean isDrawScaleInRecordColor, boolean isDrawNameInRecordColor, boolean isDrawNumbersInRecordColor, boolean isDraw10TicksPerRecord) {
        int positionNumber;
        String graphText;
        String recordName;
        IDevice device = record.getDevice();
        RecordSet parent = record.getParent();
        boolean isCompareSet = parent.isCompareSet();
        int numberTicks = 10;
        int miniticks = 5;
        if (isDraw10TicksPerRecord) {
            record.setRoundOut(true);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "x0=" + x0 + " y0=" + y0 + " width=" + width + " height=" + height + " horizontalSpace=" + scaleWidthSpace);
        }
        if (record.isEmpty() && !record.isDisplayable() && !record.isScaleVisible()) {
            return;
        }
        String string = recordName = isCompareSet ? record.getKeyName() : record.getName();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawing record =" + recordName + " isCompareSet = " + isCompareSet);
        }
        double yMaxValue = (double)(record.isScaleSynced() ? record.getSyncMaxValue() : record.getMaxValue()) / 1000.0;
        double yMinValue = (double)(record.isScaleSynced() ? record.getSyncMinValue() : record.getMinValue()) / 1000.0;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "unmodified yMinValue=" + yMinValue + "; yMaxValue=" + yMaxValue);
        }
        double yMinValueDisplay = yMinValue;
        double yMaxValueDisplay = yMaxValue;
        boolean isRaw = parent.isRaw();
        if (Math.abs(yMaxValue - yMinValue) < 1.0E-4 && !isRaw) {
            yMinValueDisplay = yMinValue = (double)Double.valueOf(yMinValue - 1.0).intValue();
            yMaxValueDisplay = yMaxValue = (double)Double.valueOf(yMaxValue + 1.0).intValue();
        }
        if (record.isStartEndDefined()) {
            yMinValueDisplay = record.getMinScaleValue();
            yMaxValueDisplay = record.getMaxScaleValue();
            if (isRaw) {
                yMinValue = device.reverseTranslateValue(record, yMinValueDisplay);
                yMaxValue = device.reverseTranslateValue(record, yMaxValueDisplay);
            } else {
                yMinValue = yMinValueDisplay;
                yMaxValue = yMaxValueDisplay;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "defined yMinValue=" + yMinValue + "; yMaxValue=" + yMaxValue);
            }
        } else {
            if (device != null && isRaw) {
                yMinValueDisplay = device.translateValue(record, yMinValue);
                yMaxValueDisplay = device.translateValue(record, yMaxValue);
            }
            if (device != null && (record.isRoundOut() || Math.abs(yMaxValue - yMinValue) < 1.0E-4)) {
                double deltaValueDisplay = yMaxValueDisplay - yMinValueDisplay;
                yMaxValueDisplay = MathUtils.roundUp(yMaxValueDisplay, deltaValueDisplay);
                yMinValueDisplay = MathUtils.roundDown(yMinValueDisplay, deltaValueDisplay);
                Object[] roundResult = MathUtils.adaptRounding(yMinValueDisplay, yMaxValueDisplay, false, isDraw10TicksPerRecord ? 10 : (height / 25 >= 3 ? height / 25 : 2));
                yMinValueDisplay = (Double)roundResult[0];
                yMaxValueDisplay = (Double)roundResult[1];
                numberTicks = isDraw10TicksPerRecord ? 10 : (Integer)roundResult[2];
                miniticks = (Integer)roundResult[3];
                if (isRaw) {
                    yMinValue = device.reverseTranslateValue(record, yMinValueDisplay);
                    yMaxValue = device.reverseTranslateValue(record, yMaxValueDisplay);
                } else {
                    yMinValue = yMinValueDisplay;
                    yMaxValue = yMaxValueDisplay;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, String.format("rounded yMinValue = %5.3f - yMaxValue = %5.3f", yMinValue, yMaxValue));
                }
            }
            if (record.isStartpointZero()) {
                if (record.getAvgValue() >= 0) {
                    yMinValueDisplay = 0.0;
                    yMinValue = isRaw ? yMinValueDisplay - record.getOffset() : yMinValueDisplay;
                } else {
                    yMaxValueDisplay = 0.0;
                    yMaxValue = isRaw ? yMaxValueDisplay - record.getOffset() : yMaxValueDisplay;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "scale starts at 0; yMinValue=" + yMinValue + "; yMaxValue=" + yMaxValue);
                }
            }
        }
        record.setMinScaleValue(yMinValueDisplay);
        record.setMaxScaleValue(yMaxValueDisplay);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "scale  -> yMinValueDisplay = " + yMinValueDisplay + "; yMaxValueDisplay = " + yMaxValueDisplay);
        }
        String string2 = graphText = record.isScaleSyncMaster() ? record.getSyncMasterName() : recordName;
        if (record.getSymbol() != null && record.getSymbol().length() > 0) {
            graphText = graphText + "   " + record.getSymbol();
        }
        if (record.getUnit() != null && record.getUnit().length() > 0) {
            graphText = graphText + "   [" + record.getUnit() + "]";
        }
        Point pt = gc.textExtent("000,00");
        int ticklength = 5;
        int gap = 10;
        gc.setLineWidth(2);
        gc.setLineStyle(1);
        boolean isPositionLeft = record.isPositionLeft();
        int n = positionNumber = isCompareSet ? 0 : parent.getAxisPosition(recordName, isPositionLeft);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, recordName + " positionNumber = " + positionNumber);
        }
        if (isDrawScaleInRecordColor) {
            String rgb = record.isScaleSyncMaster() ? record.getSyncMasterRGB() : record.getRGB();
            gc.setForeground(SWTResourceManager.getColor(rgb));
        } else {
            gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
        }
        if (isPositionLeft) {
            int xPos = x0 - 1 - positionNumber * scaleWidthSpace;
            gc.drawLine(xPos, y0 + 1, xPos, y0 - height - 1);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "y-Achse = " + xPos + ", " + y0 + ", " + xPos + ", " + (y0 - height));
            }
            GraphicsUtils.drawVerticalTickMarks(record, gc, xPos, y0, height, yMinValueDisplay, yMaxValueDisplay, ticklength, miniticks, gap, isPositionLeft, numberTicks, isDrawNumbersInRecordColor);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "drawText x = " + (xPos - pt.y - 15));
            }
            if (!isCompareSet) {
                if (isDrawNameInRecordColor) {
                    gc.setForeground(SWTResourceManager.getColor(record.getRGB()));
                } else {
                    DataExplorer.getInstance();
                    gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
                }
                GraphicsUtils.drawTextCentered(graphText, xPos - scaleWidthSpace + 3, y0 / 2 + (y0 - height), gc, 128);
            }
        } else {
            int xPos = x0 + 1 + width + positionNumber * scaleWidthSpace;
            gc.drawLine(xPos, y0 + 1, xPos, y0 - height - 1);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "y-Achse = " + xPos + ", " + y0 + ", " + xPos + ", " + (y0 - height));
            }
            GraphicsUtils.drawVerticalTickMarks(record, gc, xPos, y0, height, yMinValueDisplay, yMaxValueDisplay, ticklength, miniticks, gap, isPositionLeft, numberTicks, isDrawNumbersInRecordColor);
            if (!isCompareSet) {
                if (isDrawNameInRecordColor) {
                    gc.setForeground(SWTResourceManager.getColor(record.getRGB()));
                } else {
                    DataExplorer.getInstance();
                    gc.setForeground(DataExplorer.getInstance().COLOR_BLACK);
                }
                GraphicsUtils.drawTextCentered(graphText, xPos + scaleWidthSpace - pt.y - 5, y0 / 2 + (y0 - height), gc, 128);
            }
        }
        record.setSyncedMinMaxDisplayValues(yMinValue, yMaxValue);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, record.getName() + " data limit  -> yMinValue = " + yMinValue + "; yMaxValue = " + yMaxValue);
        }
    }

    public static void drawCurve(Record record, GC gc, int x0, int y0, int width, int height, boolean isCompareSet) {
        int xScaleFactor;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, record.getName() + String.format(" x0 = %d, y0 = %d, width = %d, height = %d", x0, y0, width, height));
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "curve area bounds = " + record.getParent().getDrawAreaBounds().toString());
        }
        RecordSet parent = record.getParent();
        gc.setForeground(SWTResourceManager.getColor(record.getRGB()));
        gc.setLineWidth(record.getLineWidth());
        gc.setLineStyle(record.getLineStyle());
        int displayableSize = record.size();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "average record time step msec = " + record.getAverageTimeStep_ms());
        }
        double displayableTime_ms = record.getDrawTimeWidth_ms();
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "displayableSize = " + displayableSize + " displayableTime_ms = " + displayableTime_ms);
        }
        int n = xScaleFactor = (xScaleFactor = (int)((double)displayableSize / ((double)width * 2.2))) > 0 ? xScaleFactor : 1;
        while (displayableSize % xScaleFactor > 3 && xScaleFactor > 1) {
            --xScaleFactor;
        }
        double xTimeFactor = (double)width / displayableTime_ms;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "xTimeFactor = " + xTimeFactor + " xScaleFactor = " + xScaleFactor + " : " + xTimeFactor * (double)xScaleFactor);
        }
        record.setDisplayScaleFactorTime(xTimeFactor);
        record.setDisplayScaleFactorValue(height);
        StringBuffer sb = new StringBuffer();
        Point oldPoint = new Point(0, 0);
        try {
            oldPoint = record.getDisplayEndPoint(0);
            if (log.isLoggable(Level.FINEST)) {
                sb.append(GDE.LINE_SEPARATOR).append(oldPoint.toString());
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage() + " zoomed compare set ?", e);
        }
        try {
            if (parent.isCompareSet()) {
                Point newPoint;
                int j;
                boolean isGPSCoordinate = record.getDevice().isGPSCoordinates(record);
                int drawLimit = record.findBestIndex(record.getCompareSetDrawLimit_ms()) - record.findBestIndex(record.getZoomTimeOffset());
                for (j = 0; j < displayableSize && displayableSize > 1; j += xScaleFactor) {
                    newPoint = isGPSCoordinate ? record.getGPSDisplayPoint(j, x0, y0) : record.getDisplayPoint(j, x0, y0);
                    if (log.isLoggable(Level.FINEST)) {
                        sb.append(GDE.LINE_SEPARATOR).append(newPoint.toString());
                    }
                    if (j <= drawLimit) {
                        gc.drawLine(oldPoint.x, oldPoint.y, newPoint.x, newPoint.y);
                    }
                    oldPoint = newPoint;
                }
                if (j <= drawLimit) {
                    newPoint = record.getDisplayEndPoint(width);
                    gc.drawLine(oldPoint.x, oldPoint.y, newPoint.x, newPoint.y);
                }
            } else if (record.getDevice().isGPSCoordinates(record)) {
                Point newPoint;
                for (int j = 0; j <= displayableSize && displayableSize > 1; j += xScaleFactor) {
                    newPoint = record.getGPSDisplayPoint(j, x0, y0);
                    if (log.isLoggable(Level.FINEST)) {
                        sb.append(GDE.LINE_SEPARATOR).append(newPoint.toString());
                    }
                    gc.drawLine(oldPoint.x, oldPoint.y, newPoint.x, newPoint.y);
                    oldPoint = newPoint;
                }
                newPoint = record.getDisplayEndPoint(width);
                gc.drawLine(oldPoint.x, oldPoint.y, newPoint.x, newPoint.y);
            } else {
                Point newPoint;
                for (int j = 0; j <= displayableSize && displayableSize > 1; j += xScaleFactor) {
                    newPoint = record.getDisplayPoint(j, x0, y0);
                    if (log.isLoggable(Level.FINEST)) {
                        sb.append(GDE.LINE_SEPARATOR).append(newPoint.toString());
                    }
                    gc.drawLine(oldPoint.x, oldPoint.y, newPoint.x, newPoint.y);
                    oldPoint = newPoint;
                }
                newPoint = record.getDisplayEndPoint(width);
                gc.drawLine(oldPoint.x, oldPoint.y, newPoint.x, newPoint.y);
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage() + " zoomed compare set ?", e);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, sb.toString());
        }
    }
}

