/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.tab;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.tab.DigitalDisplay;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DigitalWindow
extends CTabItem {
    static final Logger log = Logger.getLogger(DigitalWindow.class.getName());
    Composite digitalMainComposite;
    HashMap<String, DigitalDisplay> displays;
    FillLayout digitalMainCompositeLayout = new FillLayout(256);
    String info = Messages.getString("GDE_MSGT0230");
    Color surroundingBackground;
    final DataExplorer application;
    final Channels channels;
    final CTabFolder displayTab;
    RecordSet oldRecordSet;
    Channel oldChannel;
    String[] oldRecordsToDisplay;

    public DigitalWindow(CTabFolder currentDisplayTab, int style, int position) {
        super(currentDisplayTab, style, position);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.displayTab = currentDisplayTab;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.setFont(SWTResourceManager.getFont((Control)this.application, GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 3 : 1), 0));
        this.setText(Messages.getString("GDE_MSGT0238"));
        this.surroundingBackground = Settings.getInstance().getDigitalSurroundingAreaBackground();
        this.displays = new HashMap(3);
        this.displayTab.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent evt) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "digitalMainComposite.paintControl, event=" + evt);
                }
                DigitalWindow.this.update(false);
            }
        });
    }

    public void create() {
        this.digitalMainComposite = new Composite((Composite)this.displayTab, 0);
        this.setControl((Control)this.digitalMainComposite);
        this.digitalMainComposite.setBackground(this.surroundingBackground);
        this.digitalMainComposite.setLayout(null);
        this.digitalMainComposite.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent evt) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "digitalMainComposite.helpRequested " + evt);
                }
                DataExplorer.getInstance().openHelpDialog("", "HelpInfo_7.html");
            }
        });
        this.digitalMainComposite.layout();
    }

    public synchronized void updateChilds() {
        RecordSet recordSet = this.channels.getActiveChannel().getActiveRecordSet();
        if (recordSet != null) {
            String[] activeRecordKeys = recordSet.getDisplayableAndVisibleRecordNames();
            if (activeRecordKeys.length != this.displays.size()) {
                this.update(true);
            } else {
                for (String recordKey : activeRecordKeys) {
                    DigitalDisplay display = this.displays.get(recordKey);
                    if (display == null) continue;
                    display.redawDisplay();
                }
            }
        }
    }

    public synchronized void update(boolean forceUpdate) {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null) {
            RecordSet recordSet;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, " ");
            }
            if ((recordSet = activeChannel.getActiveRecordSet()) != null && recordSet.getDevice().isDigitalTabRequested()) {
                boolean isUpdateRequired;
                String[] recordsToDisplay = recordSet.getDisplayableAndVisibleRecordNames();
                boolean bl = isUpdateRequired = forceUpdate || this.oldRecordSet == null || !recordSet.getName().equals(this.oldRecordSet.getName()) || this.oldChannel == null || !this.oldChannel.getName().equals(activeChannel.getName()) || recordsToDisplay.length != this.oldRecordsToDisplay.length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "isUpdateRequired = " + isUpdateRequired);
                }
                if (isUpdateRequired) {
                    DigitalDisplay display;
                    this.digitalMainComposite.setLayout((Layout)this.digitalMainCompositeLayout);
                    for (String recordKey : this.displays.keySet().toArray(new String[0])) {
                        display = this.displays.get(recordKey);
                        if (display == null) continue;
                        if (!display.isDisposed()) {
                            display.dispose();
                        }
                        this.displays.remove(recordKey);
                    }
                    for (String recordKey : recordSet.getDisplayableAndVisibleRecordNames()) {
                        display = new DigitalDisplay(this.application, this.digitalMainComposite, recordKey, DataExplorer.getInstance().getActiveDevice());
                        display.create();
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "created digital display for " + recordKey);
                        }
                        this.displays.put(recordKey, display);
                    }
                    this.oldRecordSet = recordSet;
                    this.oldRecordsToDisplay = recordsToDisplay;
                }
            } else {
                for (String recordKey : this.displays.keySet().toArray(new String[0])) {
                    DigitalDisplay display = this.displays.get(recordKey);
                    if (display == null) continue;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "clean child " + recordKey);
                    }
                    if (!display.isDisposed()) {
                        display.dispose();
                    }
                    this.displays.remove(recordKey);
                }
            }
            this.oldChannel = activeChannel;
            this.digitalMainComposite.layout();
        }
    }

    public Image getContentAsImage() {
        Rectangle bounds = this.digitalMainComposite.getClientArea();
        Image tabContentImage = new Image((Device)GDE.display, bounds.width, bounds.height);
        GC imageGC = new GC((Drawable)tabContentImage);
        this.digitalMainComposite.print(imageGC);
        if (GDE.IS_MAC) {
            this.digitalMainComposite.print(imageGC);
        }
        imageGC.dispose();
        return tabContentImage;
    }

    public void setInnerAreaBackground(Color newInnerAreaBackground) {
        this.update(true);
    }

    public void setDigitalDisplayFontSize(int newSize) {
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && this.digitalMainComposite.isVisible()) {
            RecordSet recordSet;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, " ");
            }
            if ((recordSet = activeChannel.getActiveRecordSet()) != null && recordSet.getDevice().isDigitalTabRequested()) {
                String[] recordsToDisplay;
                for (String recordKey : recordsToDisplay = recordSet.getDisplayableAndVisibleRecordNames()) {
                    this.displays.get(recordKey).setFontSize(newSize);
                }
            }
        }
        this.update(true);
    }

    public void setSurroundingAreaBackground(Color newSurroundingBackground) {
        this.digitalMainComposite.setBackground(newSurroundingBackground);
        this.surroundingBackground = newSurroundingBackground;
        this.digitalMainComposite.redraw();
    }
}

