/*
 * Decompiled with CFR 0.152.
 */
package gde.ui.dialog.edit;

import gde.GDE;
import gde.comm.DeviceCommPort;
import gde.device.DataBitsTypes;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.FlowControlTypes;
import gde.device.ParityTypes;
import gde.device.StopBitsTypes;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.ui.dialog.edit.ChannelTypeTabItem;
import gde.ui.dialog.edit.ContextMenu;
import gde.ui.dialog.edit.DevicePropertiesEditor;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SeriaPortTypeTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(ChannelTypeTabItem.class.getName());
    Composite serialPortComposite;
    Composite timeOutComposite;
    Label serialPortDescriptionLabel;
    Label timeOutDescriptionLabel;
    Label portNameLabel;
    Label baudeRateLabel;
    Label dataBitsLabel;
    Label stopBitsLabel;
    Label parityLabel;
    Label flowControlLabel;
    Label rtsLabel;
    Label dtrLabel;
    Label timeOutLabel;
    Text portNameText;
    CCombo baudeRateCombo;
    CCombo dataBitsCombo;
    CCombo stopBitsCombo;
    CCombo parityCombo;
    CCombo flowControlCombo;
    Button isRTSButton;
    Button isDTRButton;
    Button timeOutButton;
    Label _RTOCharDelayTimeLabel;
    Label _RTOExtraDelayTimeLabel;
    Label _WTOCharDelayTimeLabel;
    Label _WTOExtraDelayTimeLabel;
    Text _RTOCharDelayTimeText;
    Text _RTOExtraDelayTimeText;
    Text _WTOCharDelayTimeText;
    Text _WTOExtraDelayTimeText;
    String portName = "";
    int baudeRateIndex = 0;
    int dataBitsIndex = 0;
    int stopBitsIndex = 0;
    int parityIndex = 0;
    int flowControlIndex = 0;
    boolean isRTS = false;
    boolean isDTR = false;
    boolean useTimeOut = false;
    int RTOCharDelayTime = 0;
    int RTOExtraDelayTime = 0;
    int WTOCharDelayTime = 0;
    int WTOExtraDelayTime = 0;
    DeviceConfiguration deviceConfig;
    Menu popupMenu;
    ContextMenu contextMenu;
    final CTabFolder tabFolder;
    final DevicePropertiesEditor propsEditor;

    public SeriaPortTypeTabItem(CTabFolder parent, int style, int index) {
        super(parent, style, index);
        this.tabFolder = parent;
        this.propsEditor = DevicePropertiesEditor.getInstance();
        log.log(java.util.logging.Level.FINE, "SeriaPortTypeTabItem ");
        this.initGUI();
    }

    private void initGUI() {
        try {
            SWTResourceManager.registerResourceUser((Widget)this);
            this.setText(Messages.getString("GDE_MSGT0510"));
            this.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortComposite = new Composite((Composite)this.tabFolder, 0);
            this.serialPortComposite.setLayout(null);
            this.setControl((Control)this.serialPortComposite);
            this.serialPortComposite.addHelpListener(new HelpListener(){

                public void helpRequested(HelpEvent evt) {
                    log.log(Level.FINEST, "serialPortComposite.helpRequested " + evt);
                    DataExplorer.getInstance().openHelpDialog("", "HelpInfo_A1.html#device_properties_serial_port");
                }
            });
            this.serialPortComposite.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "serialPortComposite.focusLost, event=" + focusevent);
                    SeriaPortTypeTabItem.this.enableContextmenu(false);
                }

                public void focusGained(FocusEvent focusevent) {
                    log.log(java.util.logging.Level.FINEST, "serialPortComposite.focusGained, event=" + focusevent);
                    SeriaPortTypeTabItem.this.enableContextmenu(true);
                }
            });
            this.serialPortDescriptionLabel = new Label(this.serialPortComposite, 0x1000040);
            this.serialPortDescriptionLabel.setText(Messages.getString("GDE_MSGT0577"));
            this.serialPortDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.serialPortDescriptionLabel.setBounds(12, 6, 602, 56);
            this.portNameLabel = new Label(this.serialPortComposite, 131072);
            this.portNameLabel.setText(Messages.getString("GDE_MSGT0578"));
            this.portNameLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portNameLabel.setBounds(5, 74, 100, 20);
            this.portNameText = new Text(this.serialPortComposite, 2048);
            this.portNameText.setBounds(141, 76, 180, 20);
            this.portNameText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.portNameText.setEditable(false);
            this.baudeRateLabel = new Label(this.serialPortComposite, 131072);
            this.baudeRateLabel.setText(Messages.getString("GDE_MSGT0579"));
            this.baudeRateLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.baudeRateLabel.setBounds(5, 99, 100, 20);
            this.baudeRateCombo = new CCombo(this.serialPortComposite, 2048);
            this.baudeRateCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.baudeRateCombo.setItems(DeviceCommPort.STRING_ARRAY_BAUDE_RATES);
            this.baudeRateCombo.setBounds(142, 101, 180, 20);
            this.baudeRateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "baudeRateCombo.widgetSelected, event=" + evt);
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setBaudeRate(Integer.valueOf(SeriaPortTypeTabItem.this.baudeRateCombo.getText()));
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.baudeRateIndex = SeriaPortTypeTabItem.this.baudeRateCombo.getSelectionIndex();
                }
            });
            this.dataBitsLabel = new Label(this.serialPortComposite, 131072);
            this.dataBitsLabel.setText(Messages.getString("GDE_MSGT0580"));
            this.dataBitsLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataBitsLabel.setBounds(5, 124, 100, 20);
            this.dataBitsCombo = new CCombo(this.serialPortComposite, 2048);
            this.dataBitsCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dataBitsCombo.setItems(DataBitsTypes.valuesAsStingArray());
            this.dataBitsCombo.setBounds(142, 126, 180, 20);
            this.dataBitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "dataBitsCombo.widgetSelected, event=" + evt);
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setDataBits(DataBitsTypes.fromValue(SeriaPortTypeTabItem.this.dataBitsCombo.getText()));
                    }
                    SeriaPortTypeTabItem.this.dataBitsIndex = SeriaPortTypeTabItem.this.dataBitsCombo.getSelectionIndex();
                }
            });
            this.stopBitsLabel = new Label(this.serialPortComposite, 131072);
            this.stopBitsLabel.setText(Messages.getString("GDE_MSGT0581"));
            this.stopBitsLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.stopBitsLabel.setBounds(5, 149, 100, 20);
            this.stopBitsCombo = new CCombo(this.serialPortComposite, 2048);
            this.stopBitsCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.stopBitsCombo.setItems(StopBitsTypes.valuesAsStingArray());
            this.stopBitsCombo.setBounds(142, 151, 180, 20);
            this.stopBitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "stopBitsCombo.widgetSelected, event=" + evt);
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setStopBits(StopBitsTypes.values()[SeriaPortTypeTabItem.this.stopBitsCombo.getSelectionIndex()]);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.stopBitsIndex = SeriaPortTypeTabItem.this.stopBitsCombo.getSelectionIndex();
                }
            });
            this.parityLabel = new Label(this.serialPortComposite, 131072);
            this.parityLabel.setText(Messages.getString("GDE_MSGT0582"));
            this.parityLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.parityLabel.setBounds(5, 174, 100, 20);
            this.parityCombo = new CCombo(this.serialPortComposite, 2048);
            this.parityCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.parityCombo.setItems(ParityTypes.valuesAsStingArray());
            this.parityCombo.setBounds(142, 176, 180, 20);
            this.parityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "parityCombo.widgetSelected, event=" + evt);
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setParity(ParityTypes.values()[SeriaPortTypeTabItem.this.parityCombo.getSelectionIndex()]);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.parityIndex = SeriaPortTypeTabItem.this.parityCombo.getSelectionIndex();
                }
            });
            this.flowControlLabel = new Label(this.serialPortComposite, 131072);
            this.flowControlLabel.setText(Messages.getString("GDE_MSGT0583"));
            this.flowControlLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.flowControlLabel.setBounds(5, 199, 100, 20);
            this.flowControlCombo = new CCombo(this.serialPortComposite, 2048);
            this.flowControlCombo.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.flowControlCombo.setItems(FlowControlTypes.valuesAsStingArray());
            this.flowControlCombo.setBounds(142, 201, 180, 20);
            this.flowControlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "flowControlCombo.widgetSelected, event=" + evt);
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setFlowCtrlMode(FlowControlTypes.values()[SeriaPortTypeTabItem.this.flowControlCombo.getSelectionIndex()]);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.flowControlIndex = SeriaPortTypeTabItem.this.flowControlCombo.getSelectionIndex();
                }
            });
            this.rtsLabel = new Label(this.serialPortComposite, 131072);
            this.rtsLabel.setText(Messages.getString("GDE_MSGT0584"));
            this.rtsLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.rtsLabel.setBounds(5, 224, 100, 20);
            this.isRTSButton = new Button(this.serialPortComposite, 32);
            this.isRTSButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.isRTSButton.setBounds(142, 224, 180, 20);
            this.isRTSButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "isRTSButton.widgetSelected, event=" + evt);
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setIsRTS(SeriaPortTypeTabItem.this.isRTSButton.getSelection());
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.isRTS = SeriaPortTypeTabItem.this.isRTSButton.getSelection();
                }
            });
            this.dtrLabel = new Label(this.serialPortComposite, 131072);
            this.dtrLabel.setText(Messages.getString("GDE_MSGT0585"));
            this.dtrLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.dtrLabel.setBounds(5, 249, 100, 20);
            this.isDTRButton = new Button(this.serialPortComposite, 32);
            this.isDTRButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.isDTRButton.setBounds(142, 249, 180, 20);
            this.isDTRButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "isDTRButton.widgetSelected, event=" + evt);
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setIsDTR(SeriaPortTypeTabItem.this.isDTRButton.getSelection());
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                    SeriaPortTypeTabItem.this.isDTR = SeriaPortTypeTabItem.this.isDTRButton.getSelection();
                }
            });
            this.timeOutComposite = new Composite(this.serialPortComposite, 2048);
            this.timeOutComposite.setLayout(null);
            this.timeOutComposite.setBounds(355, 80, 250, 220);
            this.timeOutDescriptionLabel = new Label(this.timeOutComposite, 64);
            this.timeOutDescriptionLabel.setText(Messages.getString("GDE_MSGT0591"));
            this.timeOutDescriptionLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutDescriptionLabel.setBounds(6, 3, 232, 69);
            this.timeOutLabel = new Label(this.timeOutComposite, 131072);
            this.timeOutLabel.setText(Messages.getString("GDE_MSGT0586"));
            this.timeOutLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutLabel.setBounds(6, 70, 140, 20);
            this.timeOutButton = new Button(this.timeOutComposite, 32);
            this.timeOutButton.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this.timeOutButton.setBounds(161, 70, 70, 20);
            this.timeOutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "timeOutButton.widgetSelected, event=" + evt);
                    SeriaPortTypeTabItem.this.useTimeOut = SeriaPortTypeTabItem.this.timeOutButton.getSelection();
                    if (SeriaPortTypeTabItem.this.useTimeOut) {
                        if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                            SeriaPortTypeTabItem.this.RTOCharDelayTime = SeriaPortTypeTabItem.this.deviceConfig.getReadTimeOut();
                            SeriaPortTypeTabItem.this.deviceConfig.setReadTimeOut(SeriaPortTypeTabItem.this.RTOCharDelayTime);
                            SeriaPortTypeTabItem.this.RTOExtraDelayTime = SeriaPortTypeTabItem.this.deviceConfig.getReadStableIndex();
                            SeriaPortTypeTabItem.this.deviceConfig.setReadStableIndex(SeriaPortTypeTabItem.this.RTOExtraDelayTime);
                            SeriaPortTypeTabItem.this.WTOCharDelayTime = SeriaPortTypeTabItem.this.deviceConfig.getWriteCharDelayTime();
                            SeriaPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(SeriaPortTypeTabItem.this.WTOCharDelayTime);
                            SeriaPortTypeTabItem.this.WTOExtraDelayTime = SeriaPortTypeTabItem.this.deviceConfig.getWriteDelayTime();
                            SeriaPortTypeTabItem.this.deviceConfig.setWriteDelayTime(SeriaPortTypeTabItem.this.WTOExtraDelayTime);
                            SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                        } else {
                            SeriaPortTypeTabItem.this.RTOCharDelayTime = 0;
                            SeriaPortTypeTabItem.this.RTOExtraDelayTime = 0;
                            SeriaPortTypeTabItem.this.WTOCharDelayTime = 0;
                            SeriaPortTypeTabItem.this.WTOExtraDelayTime = 0;
                        }
                    } else {
                        if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                            SeriaPortTypeTabItem.this.deviceConfig.removeSerialPortTimeOut();
                        }
                        SeriaPortTypeTabItem.this.RTOCharDelayTime = 0;
                        SeriaPortTypeTabItem.this.RTOExtraDelayTime = 0;
                        SeriaPortTypeTabItem.this.WTOCharDelayTime = 0;
                        SeriaPortTypeTabItem.this.WTOExtraDelayTime = 0;
                    }
                    SeriaPortTypeTabItem.this.enableTimeout();
                }
            });
            this._RTOCharDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._RTOCharDelayTimeLabel.setText(Messages.getString("GDE_MSGT0587"));
            this._RTOCharDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._RTOCharDelayTimeLabel.setBounds(6, 100, 140, 20);
            this._RTOCharDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._RTOCharDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._RTOCharDelayTimeText.setBounds(162, 100, 70, 20);
            this._RTOCharDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_RTOCharDelayTimeText.verifyText, event=" + evt);
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._RTOCharDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_RTOCharDelayTimeText.keyReleased, event=" + evt);
                    SeriaPortTypeTabItem.this.RTOCharDelayTime = Integer.parseInt(SeriaPortTypeTabItem.this._RTOCharDelayTimeText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setReadTimeOut(SeriaPortTypeTabItem.this.RTOCharDelayTime);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._RTOExtraDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._RTOExtraDelayTimeLabel.setText(Messages.getString("GDE_MSGT0588"));
            this._RTOExtraDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._RTOExtraDelayTimeLabel.setBounds(6, 130, 140, 20);
            this._RTOExtraDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._RTOExtraDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._RTOExtraDelayTimeText.setBounds(162, 130, 70, 20);
            this._RTOExtraDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_RTOExtraDelayTimeText.verifyText, event=" + evt);
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._RTOExtraDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_RTOExtraDelayTimeText.keyReleased, event=" + evt);
                    SeriaPortTypeTabItem.this.RTOExtraDelayTime = Integer.parseInt(SeriaPortTypeTabItem.this._RTOExtraDelayTimeText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setReadStableIndex(SeriaPortTypeTabItem.this.RTOExtraDelayTime);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOCharDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOCharDelayTimeLabel.setText(Messages.getString("GDE_MSGT0589"));
            this._WTOCharDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeLabel.setBounds(6, 160, 140, 20);
            this._WTOCharDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOCharDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOCharDelayTimeText.setBounds(162, 160, 70, 20);
            this._WTOCharDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.verifyText, event=" + evt);
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOCharDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WRTOCharDelayTimeText.keyReleased, event=" + evt);
                    SeriaPortTypeTabItem.this.WTOCharDelayTime = Integer.parseInt(SeriaPortTypeTabItem.this._WTOCharDelayTimeText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setWriteCharDelayTime(SeriaPortTypeTabItem.this.WTOCharDelayTime);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this._WTOExtraDelayTimeLabel = new Label(this.timeOutComposite, 131072);
            this._WTOExtraDelayTimeLabel.setText(Messages.getString("GDE_MSGT0590"));
            this._WTOExtraDelayTimeLabel.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeLabel.setBounds(6, 190, 140, 20);
            this._WTOExtraDelayTimeText = new Text(this.timeOutComposite, 2048);
            this._WTOExtraDelayTimeText.setFont(SWTResourceManager.getFont(GDE.WIDGET_FONT_NAME, GDE.WIDGET_FONT_SIZE, 0));
            this._WTOExtraDelayTimeText.setBounds(162, 190, 70, 20);
            this._WTOExtraDelayTimeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.verifyText, event=" + evt);
                    evt.doit = StringHelper.verifyTypedInput(DataTypes.INTEGER, evt.text);
                }
            });
            this._WTOExtraDelayTimeText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent evt) {
                    log.log(java.util.logging.Level.FINEST, "_WTOExtraDelayTimeText.keyReleased, event=" + evt);
                    SeriaPortTypeTabItem.this.WTOExtraDelayTime = Integer.parseInt(SeriaPortTypeTabItem.this._WTOExtraDelayTimeText.getText());
                    if (SeriaPortTypeTabItem.this.deviceConfig != null) {
                        SeriaPortTypeTabItem.this.deviceConfig.setWriteDelayTime(SeriaPortTypeTabItem.this.WTOExtraDelayTime);
                        SeriaPortTypeTabItem.this.propsEditor.enableSaveButton(true);
                    }
                }
            });
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void enableContextmenu(boolean enable) {
        if (enable && (this.popupMenu == null || this.contextMenu == null)) {
            this.popupMenu = new Menu((Decorations)this.tabFolder.getShell(), 8);
            this.contextMenu = new ContextMenu(this.popupMenu, this.tabFolder);
            this.contextMenu.create();
        } else {
            this.popupMenu = null;
            this.contextMenu = null;
        }
        this.serialPortComposite.setMenu(this.popupMenu);
        this.serialPortDescriptionLabel.setMenu(this.popupMenu);
        this.portNameLabel.setMenu(this.popupMenu);
        this.baudeRateLabel.setMenu(this.popupMenu);
        this.dataBitsLabel.setMenu(this.popupMenu);
        this.stopBitsLabel.setMenu(this.popupMenu);
        this.parityLabel.setMenu(this.popupMenu);
        this.flowControlLabel.setMenu(this.popupMenu);
        this.rtsLabel.setMenu(this.popupMenu);
        this.isRTSButton.setMenu(this.popupMenu);
        this.dtrLabel.setMenu(this.popupMenu);
        this.isDTRButton.setMenu(this.popupMenu);
        this.timeOutComposite.setMenu(this.popupMenu);
        this.timeOutLabel.setMenu(this.popupMenu);
        this.timeOutButton.setMenu(this.popupMenu);
        this._RTOCharDelayTimeLabel.setMenu(this.popupMenu);
        this._RTOExtraDelayTimeLabel.setMenu(this.popupMenu);
        this._WTOCharDelayTimeLabel.setMenu(this.popupMenu);
        this._WTOExtraDelayTimeLabel.setMenu(this.popupMenu);
        this.timeOutDescriptionLabel.setMenu(this.popupMenu);
    }

    public void setDeviceConfig(DeviceConfiguration deviceConfig) {
        this.deviceConfig = deviceConfig;
        this.portName = deviceConfig.getPort();
        this.baudeRateIndex = this.getSelectionIndex(this.baudeRateCombo, "" + deviceConfig.getBaudeRate());
        this.dataBitsIndex = deviceConfig.getDataBits().ordinal();
        this.stopBitsIndex = deviceConfig.getStopBits().ordinal();
        this.parityIndex = deviceConfig.getParity().ordinal();
        this.flowControlIndex = deviceConfig.getFlowCtrlModeOrdinal();
        this.isRTS = deviceConfig.isRTS();
        this.isDTR = deviceConfig.isDTR();
        if (deviceConfig.getSerialPortType().getTimeOut() != null) {
            this.useTimeOut = true;
            this.timeOutButton.setSelection(true);
        } else {
            this.useTimeOut = false;
            this.timeOutButton.setSelection(false);
        }
        this.RTOCharDelayTime = deviceConfig.getReadTimeOut();
        this.RTOExtraDelayTime = deviceConfig.getReadStableIndex();
        this.WTOCharDelayTime = deviceConfig.getWriteCharDelayTime();
        this.WTOExtraDelayTime = deviceConfig.getWriteDelayTime();
        this.timeOutComposite.redraw();
        this.initialize();
    }

    private int getSelectionIndex(CCombo useCombo, String searchString) {
        int searchIndex = 0;
        for (String item : useCombo.getItems()) {
            if (item.equals(searchString)) break;
            ++searchIndex;
        }
        return searchIndex;
    }

    private void initialize() {
        this.portNameText.setText(this.portName);
        this.baudeRateCombo.select(this.baudeRateIndex);
        this.dataBitsCombo.select(this.dataBitsIndex);
        this.stopBitsCombo.select(this.stopBitsIndex);
        this.parityCombo.select(this.parityIndex);
        this.flowControlCombo.select(this.flowControlIndex);
        this.isRTSButton.setSelection(this.isRTS);
        this.isDTRButton.setSelection(this.isDTR);
        this._RTOCharDelayTimeText.setText("" + this.RTOCharDelayTime);
        this._RTOExtraDelayTimeText.setText("" + this.RTOExtraDelayTime);
        this._WTOCharDelayTimeText.setText("" + this.WTOCharDelayTime);
        this._WTOExtraDelayTimeText.setText("" + this.WTOExtraDelayTime);
        this.timeOutButton.setSelection(this.useTimeOut);
        this.enableTimeout();
    }

    private void enableTimeout() {
        if (this.timeOutButton.getSelection()) {
            this._RTOCharDelayTimeLabel.setEnabled(true);
            this._RTOCharDelayTimeText.setEnabled(true);
            this._RTOExtraDelayTimeLabel.setEnabled(true);
            this._RTOExtraDelayTimeText.setEnabled(true);
            this._WTOCharDelayTimeLabel.setEnabled(true);
            this._WTOCharDelayTimeText.setEnabled(true);
            this._WTOExtraDelayTimeLabel.setEnabled(true);
            this._WTOExtraDelayTimeText.setEnabled(true);
        } else {
            this._RTOCharDelayTimeLabel.setEnabled(false);
            this._RTOCharDelayTimeText.setEnabled(false);
            this._RTOExtraDelayTimeLabel.setEnabled(false);
            this._RTOExtraDelayTimeText.setEnabled(false);
            this._WTOCharDelayTimeLabel.setEnabled(false);
            this._WTOCharDelayTimeText.setEnabled(false);
            this._WTOExtraDelayTimeLabel.setEnabled(false);
            this._WTOExtraDelayTimeText.setEnabled(false);
        }
    }
}

