/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.config.Settings;
import gde.device.CheckSumTypes;
import gde.device.IDevice;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.io.IDataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import gde.utils.ValueCollector;
import gde.utils.ValueEventCollector;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import java.util.logging.Logger;

public class NMEAParser
implements IDataParser {
    private static final Logger log = Logger.getLogger(NMEAParser.class.getName());
    private final String $CLASS_NAME = "NMEAParser.";
    private static final String STRING_SENTENCE_SPLITTER = " |:";
    protected int time_ms;
    protected int state = 1;
    protected long startTimeStamp = 0L;
    protected long lastTimeStamp = 0L;
    protected int[] values;
    protected Date date;
    protected short timeOffsetUTC = 0;
    protected short dstOffset = Short.MIN_VALUE;
    protected boolean isAutoDstOffset = false;
    protected boolean isNmeaSentenceTime = false;
    protected int checkSum;
    protected String comment;
    protected int year;
    protected int month;
    protected int day;
    protected int numGSVsentence = 1;
    protected int numSattelites = 0;
    protected Vector<String> missingImpleWarned = new Vector();
    protected String deviceSerialNumber = "";
    protected String firmwareVersion = "";
    protected ValueEventCollector airPressures = new ValueEventCollector();
    protected boolean isOffsetSet = false;
    protected int initialPressure = 0;
    protected double rho = 0.0;
    protected ValueCollector vcAirSpeed40 = new ValueCollector();
    protected ValueCollector vcAirSpeedDp1 = new ValueCollector();
    protected ValueCollector vcAirSpeed70 = new ValueCollector();
    protected int recordSetNumberOffset = 0;
    protected int timeResetCounter = 0;
    protected boolean isTimeResetEnabled = false;
    protected final int dataBlockSize;
    protected final String separator;
    protected final String leader;
    protected final CheckSumTypes checkSumType;
    protected final IDevice device;
    protected final String deviceName;
    protected int channelConfigNumber;
    int lineNumber = 0;

    public NMEAParser(String useLeaderChar, String useSeparator, CheckSumTypes useCheckSum, int useDataBlockSize, IDevice useDevice, int useChannelConfigNumber, short useTimeOffsetUTC) {
        this.separator = useSeparator;
        this.leader = useLeaderChar;
        this.checkSumType = useCheckSum;
        this.dataBlockSize = useDataBlockSize;
        this.values = new int[Math.abs(this.dataBlockSize)];
        this.device = useDevice;
        this.deviceName = this.device.getName();
        this.channelConfigNumber = useChannelConfigNumber;
        this.timeOffsetUTC = useTimeOffsetUTC;
    }

    @Override
    public int getChannelConfigNumber() {
        return this.channelConfigNumber;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getRecordSetNumberOffset() {
        return this.recordSetNumberOffset;
    }

    @Override
    public synchronized void setTimeResetEnabled(boolean isTimeResetPrepared) {
        this.isTimeResetEnabled = isTimeResetPrepared;
    }

    public void parse(Vector<String> inputLines, int lastLineNumber) throws Exception {
        String $METHOD_NAME = "parse()";
        try {
            int indexRMC;
            for (indexRMC = 0; indexRMC < inputLines.size(); ++indexRMC) {
                if (inputLines.elementAt(indexRMC).indexOf("RMC", 1) <= -1) continue;
                this.lineNumber = lastLineNumber - inputLines.size() + indexRMC + 1;
                this.parse(inputLines.elementAt(indexRMC), this.lineNumber);
                inputLines.remove(indexRMC);
                break;
            }
            for (int i = 0; i < inputLines.size(); ++i) {
                String inputLine = inputLines.elementAt(i);
                this.lineNumber = lastLineNumber - inputLines.size() + (i < indexRMC ? i : i + 1);
                this.parse(inputLine, this.lineNumber);
            }
        }
        catch (NumberFormatException e) {
            log.logp(Level.WARNING, "NMEAParser.", "parse()", "line number " + this.lineNumber + " - " + e.getMessage(), e);
        }
        catch (Exception e) {
            log.logp(Level.WARNING, "NMEAParser.", "parse()", "line number " + this.lineNumber + " - " + e.getMessage(), e);
            throw e;
        }
    }

    @Override
    public void parse(String inputLine, int lineNum) throws DevicePropertiesInconsistenceException, Exception {
        String $METHOD_NAME = "parse()";
        log.log(Level.FINER, "parser inputLine = " + inputLine);
        if (!inputLine.startsWith(this.leader)) {
            throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0046", new Object[]{this.leader, lineNum}));
        }
        if (inputLine.startsWith("$SETUP1;") || inputLine.startsWith("$SETUP2;") || inputLine.startsWith("$D;")) {
            inputLine = inputLine.replace(',', '.').replace(";", this.separator);
        } else if (!this.isChecksumOK(inputLine)) {
            return;
        }
        if (!inputLine.contains(this.separator)) {
            throw new DevicePropertiesInconsistenceException(Messages.getString("GDE_MSGE0047", new String[]{inputLine, this.separator}));
        }
        String[] strValues = inputLine.split(this.separator);
        try {
            NMEA sentence = NMEA.valueOf(strValues[0].substring(1));
            switch (sentence) {
                case GPRMC: 
                case GNRMC: {
                    this.parseRMC(strValues);
                    break;
                }
                case GPGGA: 
                case GNGGA: {
                    this.parseGGA(strValues);
                    break;
                }
                case GPGNS: 
                case GNGNS: {
                    this.parseGNS(strValues);
                    break;
                }
                case GPGSA: 
                case GNGSA: {
                    this.parseGSA(strValues);
                    break;
                }
                case GPVTG: 
                case GNVTG: {
                    if (this.deviceName.startsWith("GPS-Logger")) break;
                    this.parseVTG(strValues);
                    break;
                }
                case GPGSV: 
                case GNGSV: {
                    this.parseGSV(strValues);
                    break;
                }
                case GPRMB: 
                case GNRMB: {
                    this.parseRMB(strValues);
                    break;
                }
                case GPGLL: 
                case GNGLL: {
                    this.parseGLL(strValues);
                    break;
                }
                case GPZDA: 
                case GNZDA: {
                    this.parseZDA(strValues);
                    break;
                }
                case SMGPS: {
                    if (this.values.length < 15) break;
                    this.parseSMGPS(strValues);
                    break;
                }
                case SMGPS2: {
                    if (this.values.length < 19) break;
                    this.parseSMGPS2(strValues);
                    break;
                }
                case UNILOG: {
                    if (this.values.length < 24) break;
                    this.parseUNILOG(strValues);
                    break;
                }
                case MLINK: {
                    if (this.values.length < 39) break;
                    this.parseMLINK(strValues);
                    break;
                }
                case COMMENT: 
                case KOMMENTAR: {
                    this.comment = strValues[1].trim();
                    this.comment = this.comment.endsWith("*") ? this.comment.substring(0, this.comment.length() - 1) : this.comment;
                    break;
                }
                case GPSSETUP: {
                    this.deviceSerialNumber = String.format("%d", Integer.parseInt(strValues[1].trim(), 16));
                    this.timeOffsetUTC = (short)Integer.parseInt(strValues[4].trim(), 16);
                    if (log.isLoggable(Level.TIME)) {
                        log.log(Level.TIME, String.format("timeOffsetUTC = %d", Integer.parseInt(strValues[4].trim(), 16)));
                    }
                    if (Integer.parseInt(strValues[11].trim(), 16) == 1) {
                        this.isAutoDstOffset = true;
                    }
                    this.firmwareVersion = String.format("%.2f", (double)Integer.parseInt(strValues[54].trim(), 16) / 100.0);
                    break;
                }
                case SETUP: {
                    break;
                }
                case UL2SETUP: {
                    String tempName;
                    this.deviceSerialNumber = String.format("%d", Integer.parseInt(strValues[1].trim(), 16));
                    this.firmwareVersion = String.format("%.2f", (double)Integer.parseInt(strValues[2].trim(), 16) / 100.0);
                    byte A1 = (byte)(Integer.parseInt(strValues[9].trim(), 16) & 0xFF);
                    byte A2 = (byte)(Integer.parseInt(strValues[10].trim(), 16) & 0xFF);
                    byte A3 = (byte)(Integer.parseInt(strValues[11].trim(), 16) & 0xFF);
                    String string = tempName = Settings.getInstance().getLocale().getLanguage().equalsIgnoreCase("de") ? "Temperatur" : "Temperature";
                    this.device.setMeasurementName(this.channelConfigNumber, 17, A1 == 0 ? tempName + " A1" : (A1 == 2 ? "Speed_250 A1" : (A1 == 3 ? "Speed_450 A1" : (A1 == 4 ? "PT1000 A1" : "Millivolt A1"))));
                    this.device.setMeasurementName(this.channelConfigNumber, 18, A2 == 0 ? tempName + " A2" : (A2 == 2 ? "Speed_250 A2" : (A2 == 3 ? "Speed_450 A2" : (A2 == 4 ? "PT1000 A2" : "Millivolt A2"))));
                    this.device.setMeasurementName(this.channelConfigNumber, 19, A3 == 0 ? tempName + " A3" : (A3 == 2 ? "Speed_250 A3" : (A3 == 3 ? "Speed_450 A3" : (A3 == 4 ? "PT1000 A3" : "Millivolt A3"))));
                    this.device.setMeasurementUnit(this.channelConfigNumber, 17, A1 == 0 || A1 == 4 ? "\u00b0C" : (A1 == 2 || A1 == 3 ? "km/h" : "mV"));
                    this.device.setMeasurementUnit(this.channelConfigNumber, 18, A2 == 0 || A2 == 4 ? "\u00b0C" : (A2 == 2 || A2 == 3 ? "km/h" : "mV"));
                    this.device.setMeasurementUnit(this.channelConfigNumber, 19, A3 == 0 || A2 == 4 ? "\u00b0C" : (A3 == 2 || A3 == 3 ? "km/h" : "mV"));
                    break;
                }
                case UL2: {
                    if (this.values.length < 25) break;
                    if (this.deviceName.equals("UniLog2")) {
                        int[] in2out = new int[]{-1, -1, -1, -1, 1, 2, 15, 16, 4, 13, 0, 3, 5, 17, 18, 19, 7, 8, 9, 10, 11, 12, 20, 21, 22, 23};
                        this.parseUNILOG2(strValues, in2out, 6, true);
                        break;
                    }
                    if (this.deviceName.equals("GPS-Logger")) {
                        if (this.channelConfigNumber != 2) break;
                        int[] in2out = new int[]{-1, -1, -1, -1, 17, 18, -1, -1, 20, 29, -1, 19, 21, 30, 31, 32, 23, 24, 25, 26, 27, 28, -1, 33, -1, -1};
                        this.parseUNILOG2(strValues, in2out, 20, false);
                        break;
                    }
                    if (!this.deviceName.equals("GPS-Logger2") && !this.deviceName.equals("GPS-Logger3") || this.channelConfigNumber != 2) break;
                    int[] in2out = new int[]{-1, -1, -1, -1, 26, 27, -1, -1, 29, 38, -1, 28, 30, 39, 40, 41, 32, 33, 34, 35, 36, 37, -1, 42, -1, -1};
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, String.format("isNmeaSentenceTime = %b", this.isNmeaSentenceTime));
                    }
                    this.parseUNILOG2(strValues, in2out, 31, !this.isNmeaSentenceTime);
                    break;
                }
                case SETUP1: {
                    int i = 4;
                    int j = 2;
                    while (i < this.device.getNumberOfMeasurements(this.channelConfigNumber)) {
                        if (j < strValues.length && strValues[j].trim().length() > 0) {
                            String name = strValues[j].trim();
                            this.device.setMeasurementName(this.channelConfigNumber, i, StringHelper.transfer(new String(name.getBytes("ISO-8859-1"), "UTF-8")));
                        } else {
                            this.device.setMeasurementName(this.channelConfigNumber, i, String.format("%d????", i));
                        }
                        ++i;
                        ++j;
                    }
                    break;
                }
                case SETUP2: {
                    int i = 4;
                    int j = 2;
                    while (i < this.device.getNumberOfMeasurements(this.channelConfigNumber)) {
                        if (j < strValues.length && strValues[j].trim().length() > 0) {
                            String unit = strValues[j].trim();
                            this.device.setMeasurementUnit(this.channelConfigNumber, i, StringHelper.transfer(new String(unit.getBytes("ISO-8859-1"), "UTF-8")));
                        } else {
                            this.device.setMeasurementUnit(this.channelConfigNumber, i, "");
                        }
                        ++i;
                        ++j;
                    }
                    if (!log.isLoggable(Level.FINE)) break;
                    StringBuilder sb = new StringBuilder();
                    String[] names = this.device.getMeasurementNamesReplacements(this.channelConfigNumber);
                    for (int i2 = 0; i2 < this.device.getNumberOfMeasurements(this.channelConfigNumber); ++i2) {
                        sb.append(String.format("\n%s %s", names[i2], this.device.getMeasurementUnit(this.channelConfigNumber, i2)));
                    }
                    log.log(Level.OFF, sb.toString());
                    break;
                }
                case D: {
                    this.parseMpxD(strValues);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException && e.getMessage().contains("No enum")) {
                if (!this.missingImpleWarned.contains(strValues[0].substring(1))) {
                    log.logp(Level.WARNING, "NMEAParser.", "parse()", "line number " + this.lineNumber + " - NMEA sentence = " + strValues[0].substring(1) + " actually not implemented!");
                    this.missingImpleWarned.add(strValues[0].substring(1));
                }
            }
            throw e;
        }
    }

    boolean isChecksumOK(String sentence) {
        boolean isOK = true;
        try {
            String hexCheckSum = sentence.trim().substring(sentence.indexOf(42) + 1);
            if (hexCheckSum.length() == 2) {
                String subSentence;
                int tmpCheckSum = Integer.parseInt(hexCheckSum, 16);
                boolean bl = isOK = tmpCheckSum == Checksum.XOR((subSentence = sentence.substring(1, sentence.indexOf(42))).toCharArray());
                if (!isOK) {
                    log.logp(Level.WARNING, "NMEAParser.", "parse()", String.format("line number %d : checkSum 0x%s missmatch 0x%02X in %s!", this.lineNumber, hexCheckSum, Checksum.XOR(subSentence.getBytes()), subSentence));
                }
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, "NMEAParser.", "isChecksumOK()", "line number " + this.lineNumber + " " + e.getClass().getSimpleName() + " " + e.getMessage() + " in " + sentence);
        }
        return isOK;
    }

    private void correctDstOffset(GregorianCalendar calendar) {
        this.dstOffset = (short)(calendar.get(16) / 3600000);
        this.timeOffsetUTC = (short)(this.timeOffsetUTC + this.dstOffset);
        log.log(Level.TIME, String.format("DST_OFFSET+timeOffsetUTC = %d", this.timeOffsetUTC));
        calendar.add(10, this.dstOffset);
    }

    void parseRMC(String[] strValues) {
        if (strValues[2].equals("A")) {
            String strValueTime;
            if (this.date == null) {
                String strValueDate = strValues[9].trim();
                if (strValueDate.length() < 6) {
                    return;
                }
                this.year = Integer.parseInt(strValueDate.substring(4));
                this.year = this.year > 50 ? this.year + 1900 : this.year + 2000;
                this.month = Integer.parseInt(strValueDate.substring(2, 4));
                this.day = Integer.parseInt(strValueDate.substring(0, 2));
            }
            if ((strValueTime = strValues[1].trim()).length() < 9) {
                return;
            }
            int hour = Integer.parseInt(strValueTime.substring(0, 2)) + this.timeOffsetUTC;
            int minute = Integer.parseInt(strValueTime.substring(2, 4));
            int second = Integer.parseInt(strValueTime.substring(4, 6));
            GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day, hour, minute, second);
            this.isNmeaSentenceTime = true;
            if (this.isAutoDstOffset && this.dstOffset == Short.MIN_VALUE) {
                this.correctDstOffset(calendar);
            }
            int indexAfterDot = strValueTime.indexOf(46) + 1;
            long timeStamp = calendar.getTimeInMillis() + (indexAfterDot > 0 && strValueTime.length() >= indexAfterDot + 2 ? Long.parseLong(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10L : 0L);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "RMC " + Integer.parseInt(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10);
            }
            if (this.lastTimeStamp < timeStamp) {
                int magneticVariation;
                int velocity;
                int longitude;
                int latitude;
                this.time_ms = (int)(this.lastTimeStamp == 0L ? 0L : (long)this.time_ms + (timeStamp - this.lastTimeStamp));
                this.lastTimeStamp = timeStamp;
                this.date = calendar.getTime();
                if (this.startTimeStamp == 0L) {
                    this.startTimeStamp = timeStamp;
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "RMC " + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss.SSS").format(timeStamp));
                }
                try {
                    latitude = (int)(Double.valueOf(strValues[3].trim()) * 10000.0);
                    latitude = strValues[4].trim().equalsIgnoreCase("N") ? latitude : -1 * latitude;
                }
                catch (Exception e) {
                    latitude = this.values[0];
                }
                try {
                    longitude = (int)(Double.valueOf(strValues[5].trim()) * 10000.0);
                    longitude = strValues[6].trim().equalsIgnoreCase("E") ? longitude : -1 * longitude;
                }
                catch (Exception e) {
                    longitude = this.values[1];
                }
                try {
                    velocity = (int)(Double.parseDouble(strValues[7].trim()) * 1852.0);
                }
                catch (Exception e) {
                    velocity = this.values[7];
                }
                try {
                    magneticVariation = strValues[10].trim().length() > 0 ? (int)(Double.parseDouble(strValues[10].trim()) * 1000.0) : this.values[10];
                }
                catch (Exception e) {
                    magneticVariation = this.values[8];
                }
                this.values[0] = latitude;
                this.values[1] = longitude;
                this.values[7] = velocity;
                this.values[8] = magneticVariation;
            }
        }
    }

    void parseGGA(String[] strValues) {
        if (strValues[6].trim().length() == 0 || Integer.parseInt(strValues[6].trim()) > 0) {
            int altitudeGPS;
            int numSatelites;
            int longitude;
            int latitude;
            String strValueTime = strValues[1].trim();
            long timeStamp = 0L;
            if (strValueTime.length() < 9) {
                return;
            }
            int hour = Integer.parseInt(strValueTime.substring(0, 2)) + this.timeOffsetUTC;
            int minute = Integer.parseInt(strValueTime.substring(2, 4));
            int second = Integer.parseInt(strValueTime.substring(4, 6));
            GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day, hour, minute, second);
            this.isNmeaSentenceTime = true;
            if (this.isAutoDstOffset && this.dstOffset == Short.MIN_VALUE) {
                this.correctDstOffset(calendar);
            }
            int indexAfterDot = strValueTime.indexOf(46) + 1;
            timeStamp = calendar.getTimeInMillis() + (long)(indexAfterDot > 0 && strValueTime.length() >= indexAfterDot + 2 ? Integer.parseInt(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10 : 0);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "GGA " + Integer.parseInt(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "GGA " + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss.SSS").format(timeStamp));
            }
            if (this.lastTimeStamp == timeStamp) {
                try {
                    if (this.values[0] == 0) {
                        latitude = (int)(Double.valueOf(strValues[2].trim()) * 10000.0);
                        latitude = strValues[3].trim().equalsIgnoreCase("N") ? latitude : -1 * latitude;
                    } else {
                        latitude = this.values[0];
                    }
                }
                catch (Exception e) {
                    latitude = this.values[0];
                }
                try {
                    if (this.values[1] == 0) {
                        longitude = (int)(Double.valueOf(strValues[4].trim()) * 10000.0);
                        longitude = strValues[5].trim().equalsIgnoreCase("E") ? longitude : -1 * longitude;
                    } else {
                        longitude = this.values[1];
                    }
                }
                catch (Exception e) {
                    longitude = this.values[1];
                }
                try {
                    numSatelites = Integer.parseInt(strValues[7].trim()) * 1000;
                }
                catch (Exception e) {
                    numSatelites = this.values[3];
                }
                try {
                    altitudeGPS = (int)(Double.parseDouble(strValues[9].trim()) * 1000.0);
                }
                catch (Exception e) {
                    altitudeGPS = this.values[2];
                }
            } else {
                try {
                    latitude = (int)(Double.valueOf(strValues[2].trim()) * 10000.0);
                    latitude = strValues[3].trim().equalsIgnoreCase("N") ? latitude : -1 * latitude;
                }
                catch (Exception e) {
                    latitude = this.values[0];
                }
                try {
                    longitude = (int)(Double.valueOf(strValues[4].trim()) * 10000.0);
                    longitude = strValues[5].trim().equalsIgnoreCase("E") ? longitude : -1 * longitude;
                }
                catch (Exception e) {
                    longitude = this.values[1];
                }
                try {
                    numSatelites = Integer.parseInt(strValues[7].trim()) * 1000;
                }
                catch (Exception e) {
                    numSatelites = this.values[3];
                }
                try {
                    altitudeGPS = (int)(Double.parseDouble(strValues[9].trim()) * 1000.0);
                }
                catch (Exception e) {
                    altitudeGPS = this.values[2];
                }
            }
            this.values[0] = latitude;
            this.values[1] = longitude;
            this.values[2] = altitudeGPS;
            this.values[3] = numSatelites;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("lat %9.6f, long %9.6f, alt %d, sats %d", (double)latitude / 1000000.0, (double)longitude / 1000000.0, altitudeGPS / 10000, numSatelites / 1000));
            }
        }
    }

    void parseGNS(String[] strValues) {
        String modeIndicator = strValues[6].trim();
        if (modeIndicator.length() == 0 || modeIndicator.contains("A") || modeIndicator.contains("D") || modeIndicator.contains("P")) {
            int altitudeGPS;
            int numSatelites;
            int longitude;
            int latitude;
            String strValueTime = strValues[1].trim();
            long timeStamp = 0L;
            if (strValueTime.length() < 9) {
                return;
            }
            int hour = Integer.parseInt(strValueTime.substring(0, 2)) + this.timeOffsetUTC;
            int minute = Integer.parseInt(strValueTime.substring(2, 4));
            int second = Integer.parseInt(strValueTime.substring(4, 6));
            GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day, hour, minute, second);
            this.isNmeaSentenceTime = true;
            if (this.isAutoDstOffset && this.dstOffset == Short.MIN_VALUE) {
                this.correctDstOffset(calendar);
            }
            int indexAfterDot = strValueTime.indexOf(46) + 1;
            timeStamp = calendar.getTimeInMillis() + (long)(indexAfterDot > 0 && strValueTime.length() >= indexAfterDot + 2 ? Integer.parseInt(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10 : 0);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "GNS " + Integer.parseInt(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "GNS " + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss.SSS").format(timeStamp));
            }
            if (this.lastTimeStamp == timeStamp) {
                try {
                    if (this.values[0] == 0) {
                        latitude = (int)(Double.valueOf(strValues[2].trim()) * 10000.0);
                        latitude = strValues[3].trim().equalsIgnoreCase("N") ? latitude : -1 * latitude;
                    } else {
                        latitude = this.values[0];
                    }
                }
                catch (Exception e) {
                    latitude = this.values[0];
                }
                try {
                    if (this.values[1] == 0) {
                        longitude = (int)(Double.valueOf(strValues[4].trim()) * 10000.0);
                        longitude = strValues[5].trim().equalsIgnoreCase("E") ? longitude : -1 * longitude;
                    } else {
                        longitude = this.values[1];
                    }
                }
                catch (Exception e) {
                    longitude = this.values[1];
                }
                try {
                    numSatelites = Integer.parseInt(strValues[7].trim()) * 1000;
                }
                catch (Exception e) {
                    numSatelites = this.values[3];
                }
                try {
                    altitudeGPS = (int)(Double.parseDouble(strValues[9].trim()) * 1000.0);
                }
                catch (Exception e) {
                    altitudeGPS = this.values[2];
                }
            } else {
                try {
                    latitude = (int)(Double.valueOf(strValues[2].trim()) * 10000.0);
                    latitude = strValues[3].trim().equalsIgnoreCase("N") ? latitude : -1 * latitude;
                }
                catch (Exception e) {
                    latitude = this.values[0];
                }
                try {
                    longitude = (int)(Double.valueOf(strValues[4].trim()) * 10000.0);
                    longitude = strValues[5].trim().equalsIgnoreCase("E") ? longitude : -1 * longitude;
                }
                catch (Exception e) {
                    longitude = this.values[1];
                }
                try {
                    numSatelites = Integer.parseInt(strValues[7].trim()) * 1000;
                }
                catch (Exception e) {
                    numSatelites = this.values[3];
                }
                try {
                    altitudeGPS = (int)(Double.parseDouble(strValues[9].trim()) * 1000.0);
                }
                catch (Exception e) {
                    altitudeGPS = this.values[2];
                }
            }
            this.values[0] = latitude;
            this.values[1] = longitude;
            this.values[2] = altitudeGPS;
            this.values[3] = numSatelites;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("lat %9.6f, long %9.6f, alt %d, sats %d", (double)latitude / 1000000.0, (double)longitude / 1000000.0, altitudeGPS / 10000, numSatelites / 1000));
            }
        }
    }

    void parseGSA(String[] strValues) {
        if (strValues[1].equals("A") || strValues[1].equals("M")) {
            int PDOP = this.values[4];
            int HDOP = this.values[5];
            int VDOP = this.values[6];
            try {
                PDOP = (int)(Double.parseDouble(strValues[strValues.length - 3].trim()) * 1000.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                HDOP = (int)(Double.parseDouble(strValues[strValues.length - 2].trim()) * 1000.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String value = strValues[strValues.length - 1].trim();
                value = value.contains("*") ? value.substring(0, value.indexOf(42)) : value;
                VDOP = (int)(Double.parseDouble(value) * 1000.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.values[4] = PDOP;
            this.values[5] = HDOP;
            this.values[6] = VDOP;
        }
    }

    void parseGSV(String[] strValues) {
        if (!("" + this.numGSVsentence).equals(strValues[1]) || ("" + this.numGSVsentence).equals(strValues[2])) {
            int numSentence = 1;
            int actualSentence = 0;
            int actualNumSattelites = 0;
            try {
                numSentence = Integer.parseInt(strValues[1]);
                actualSentence = Integer.parseInt(strValues[2]);
                actualNumSattelites = Integer.parseInt(strValues[3]) * 1000;
                if (numSentence < this.numGSVsentence || actualSentence > this.numGSVsentence || this.numSattelites != 0 && this.numSattelites != actualNumSattelites) {
                    this.numGSVsentence = 1;
                    log.log(Level.WARNING, "GSV sentences out of sync, skip and reset!");
                    return;
                }
                this.numGSVsentence = actualSentence == numSentence ? 1 : numSentence;
                this.numSattelites = actualNumSattelites;
                this.values[3] = actualNumSattelites;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                for (int i = 0; i < 4 && 7 + 4 * i < strValues.length; ++i) {
                    String tmpValue;
                    int numSattelite = Integer.parseInt(strValues[4 + 4 * i]);
                    int elevationDegrees = Integer.parseInt(strValues[5 + 4 * i]);
                    int azimuthDegrees = Integer.parseInt(strValues[6 + 4 * i]);
                    int signalNoiseRation = strValues[7 + 4 * i].contains("*") ? ((tmpValue = strValues[7 + 4 * i].substring(0, strValues[7 + 4 * i].indexOf(42))).length() > 0 ? Integer.parseInt(tmpValue) : 0) : Integer.parseInt(strValues[7 + 4 * i]);
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "numSattelite = " + numSattelite + " elevation = " + elevationDegrees + " azimuth = " + azimuthDegrees + " signalNoiseRation = " + signalNoiseRation);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void parseVTG(String[] strValues) {
        int velocity;
        try {
            velocity = (int)(Double.parseDouble(strValues[7].trim()) * 1000.0);
        }
        catch (Exception e) {
            try {
                velocity = (int)(Double.parseDouble(strValues[5].trim()) * 1852.0);
            }
            catch (Exception e1) {
                velocity = this.values[7];
            }
        }
        this.values[7] = velocity;
    }

    void parseGLL(String[] strValues) {
        if (strValues[6].equals("A")) {
            String strValueTime;
            if (this.date == null) {
                GregorianCalendar calendar = new GregorianCalendar();
                this.year = calendar.get(1);
                this.month = calendar.get(2) + 1;
                this.day = calendar.get(5);
            }
            if ((strValueTime = strValues[5].trim()).length() < 9) {
                return;
            }
            int hour = Integer.parseInt(strValueTime.substring(0, 2)) + this.timeOffsetUTC;
            int minute = Integer.parseInt(strValueTime.substring(2, 4));
            int second = Integer.parseInt(strValueTime.substring(4, 6));
            GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day, hour, minute, second);
            this.isNmeaSentenceTime = true;
            if (this.isAutoDstOffset && this.dstOffset == Short.MIN_VALUE) {
                this.correctDstOffset(calendar);
            }
            int indexAfterDot = strValueTime.indexOf(46) + 1;
            long timeStamp = calendar.getTimeInMillis() + (indexAfterDot > 0 && strValueTime.length() >= indexAfterDot + 2 ? Long.parseLong(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10L : 0L);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "GLL " + Integer.parseInt(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10);
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "GLL " + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss.SSS").format(timeStamp));
            }
            if (this.lastTimeStamp < timeStamp) {
                int longitude;
                int latitude;
                this.time_ms = (int)(this.lastTimeStamp == 0L ? 0L : (long)this.time_ms + (timeStamp - this.lastTimeStamp));
                this.lastTimeStamp = timeStamp;
                this.date = calendar.getTime();
                log.log(Level.FINE, new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(this.date));
                if (this.startTimeStamp == 0L) {
                    this.startTimeStamp = timeStamp;
                }
                try {
                    if (this.values[0] == 0) {
                        latitude = (int)(Double.valueOf(strValues[2].trim()) * 10000.0);
                        latitude = strValues[3].trim().equalsIgnoreCase("N") ? latitude : -1 * latitude;
                    } else {
                        latitude = this.values[0];
                    }
                }
                catch (Exception e) {
                    latitude = this.values[0];
                }
                try {
                    if (this.values[1] == 0) {
                        longitude = (int)(Double.valueOf(strValues[4].trim()) * 10000.0);
                        longitude = strValues[5].trim().equalsIgnoreCase("E") ? longitude : -1 * longitude;
                    } else {
                        longitude = this.values[1];
                    }
                }
                catch (Exception e) {
                    longitude = this.values[1];
                }
                this.values[0] = latitude;
                this.values[1] = longitude;
            }
        }
    }

    void parseZDA(String[] strValues) {
        String strValueTime;
        if (this.date == null) {
            String strValueDate = strValues[9].trim();
            this.year = Integer.parseInt(strValueDate.substring(4));
            this.year = this.year > 50 ? this.year + 1900 : this.year + 2000;
            this.month = Integer.parseInt(strValueDate.substring(2, 4));
            this.day = Integer.parseInt(strValueDate.substring(0, 2));
        }
        if ((strValueTime = strValues[1].trim()).length() < 9) {
            return;
        }
        int hour = Integer.parseInt(strValueTime.substring(0, 2)) + this.timeOffsetUTC;
        int minute = Integer.parseInt(strValueTime.substring(2, 4));
        int second = Integer.parseInt(strValueTime.substring(4, 6));
        GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day, hour, minute, second);
        this.isNmeaSentenceTime = true;
        if (this.isAutoDstOffset && this.dstOffset == Short.MIN_VALUE) {
            this.correctDstOffset(calendar);
        }
        int indexAfterDot = strValueTime.indexOf(46) + 1;
        long timeStamp = calendar.getTimeInMillis() + (indexAfterDot > 0 && strValueTime.length() >= indexAfterDot + 2 ? Long.parseLong(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10L : 0L);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "ZDA " + Integer.parseInt(strValueTime.substring(indexAfterDot, indexAfterDot + 2)) * 10);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "ZDA " + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss.SSS").format(timeStamp));
        }
        if (this.lastTimeStamp < timeStamp) {
            this.time_ms = (int)(this.lastTimeStamp == 0L ? 0L : (long)this.time_ms + (timeStamp - this.lastTimeStamp));
            this.lastTimeStamp = timeStamp;
            this.date = calendar.getTime();
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(this.date));
            }
            if (this.startTimeStamp == 0L) {
                this.startTimeStamp = timeStamp;
            }
        }
    }

    void parseRMB(String[] strValues) {
        if (strValues[1].equals("A")) {
            int velocity;
            try {
                velocity = this.values[7] == 0 ? (int)(Double.parseDouble(strValues[12].trim()) * 1852.0) : this.values[7];
            }
            catch (Exception e) {
                velocity = this.values[7];
            }
            this.values[7] = velocity;
        }
    }

    void parseSMGPS(String[] strValues) {
        for (int i = 0; i < strValues.length - 1 && i < 8; ++i) {
            try {
                String[] tmpValues = strValues[i + 1].trim().split(STRING_SENTENCE_SPLITTER);
                if (i < 6) {
                    this.values[8 + i] = (int)(Double.parseDouble(tmpValues[0]) * 1000.0);
                    if (this.device.getMeasurement(this.channelConfigNumber, 8 + i).getUnit().startsWith(tmpValues[1].substring(0, 1))) continue;
                    this.device.getMeasurement(this.channelConfigNumber, 8 + i).setUnit(tmpValues[1].contains("*") ? tmpValues[1].substring(0, tmpValues[1].indexOf(42)) : tmpValues[1]);
                    continue;
                }
                if (i == 6) {
                    tmpValues = strValues[i + 1].replace("  ", " ").trim().split(STRING_SENTENCE_SPLITTER);
                    if (!tmpValues[1].startsWith("-")) {
                        this.values[8 + i + 1] = (int)(Double.parseDouble(tmpValues[1]) * 1000.0);
                        if (!this.device.getMeasurement(this.channelConfigNumber, 8 + i + 1).getUnit().equals("m/1")) {
                            this.device.getMeasurement(this.channelConfigNumber, 8 + i + 1).setUnit("m/1");
                        }
                        if (tmpValues[2].equals("(")) {
                            this.values[8 + i + 2] = (int)(Double.parseDouble(tmpValues[3]) * 1000.0);
                        } else if (tmpValues[2].startsWith("(")) {
                            tmpValues[2] = tmpValues[2].substring(1);
                            this.values[8 + i + 2] = (int)(Double.parseDouble(tmpValues[2]) * 1000.0);
                        }
                        if (this.device.getMeasurement(this.channelConfigNumber, 8 + i + 2).getUnit().equals("km/h")) continue;
                        this.device.getMeasurement(this.channelConfigNumber, 8 + i + 2).setUnit("km/h");
                        continue;
                    }
                    this.values[8 + i + 1] = 0;
                    this.values[8 + i + 2] = 0;
                    continue;
                }
                if (i != 7) continue;
                try {
                    this.values[2] = (int)(Double.parseDouble(tmpValues[0].split(",")[0]) * 1000.0);
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    void parseSMGPS2(String[] strValues) {
        for (int i = 0; i < strValues.length - 1 && i < 9; ++i) {
            try {
                String[] tmpValues = strValues[i + 1].trim().split(STRING_SENTENCE_SPLITTER);
                this.values[17 + i] = (int)(Double.parseDouble(tmpValues[0]) * 1000.0);
                if (this.device.getMeasurement(this.channelConfigNumber, 17 + i).getUnit().startsWith(tmpValues[1].substring(0, 1))) continue;
                this.device.getMeasurement(this.channelConfigNumber, 17 + i).setUnit(tmpValues[1].contains("*") ? tmpValues[1].substring(0, tmpValues[1].indexOf(42)) : tmpValues[1]);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (strValues.length > 6 && this.device.getName().endsWith("Logger3")) {
            if (!this.isOffsetSet && (this.initialPressure == 0 || this.values[23] <= this.initialPressure + 20 && this.values[23] >= this.initialPressure - 20)) {
                this.airPressures.addValuePair(this.values[23], this.values[24]);
                this.values[24] = 0;
                if (this.initialPressure == 0) {
                    this.initialPressure = this.values[23];
                }
            } else {
                this.values[24] = this.values[23] - this.values[24] - this.airPressures.getAvgDiffMaxCount();
                this.isOffsetSet = true;
            }
            if (this.values[22] >= 39500 && this.values[22] <= 40500) {
                this.vcAirSpeed40.add(this.values[22], this.values[24]);
            }
            if (this.values[24] >= 950 && this.values[24] <= 1050) {
                this.vcAirSpeedDp1.add(this.values[22], this.values[24]);
            }
            if (this.values[22] >= 69500 && this.values[22] <= 70500) {
                this.vcAirSpeed70.add(this.values[22], this.values[24]);
            }
        }
    }

    void parseUNILOG(String[] strValues) {
        block8: {
            block7: {
                if (!this.deviceName.equals("GPS-Logger")) break block7;
                if (this.channelConfigNumber != 1) break block8;
                for (int i = 0; i < strValues.length && i < 9; ++i) {
                    try {
                        String[] tmpValues = strValues[i + 1].trim().split(" ");
                        this.values[17 + i] = (int)(Double.parseDouble(tmpValues[0]) * 1000.0);
                        if (this.device.getMeasurement(this.channelConfigNumber, 17 + i).getUnit().equals(tmpValues[1])) continue;
                        this.device.getMeasurement(this.channelConfigNumber, 17 + i).setUnit(tmpValues[1].contains("*") ? tmpValues[1].substring(0, tmpValues[1].indexOf(42)) : tmpValues[1]);
                        continue;
                    }
                    catch (Exception tmpValues) {
                        // empty catch block
                    }
                }
                break block8;
            }
            if ((this.deviceName.equals("GPS-Logger2") || this.deviceName.equals("GPS-Logger3")) && this.channelConfigNumber == 1) {
                for (int i = 0; i < strValues.length && i < 9; ++i) {
                    try {
                        String[] tmpValues = strValues[i + 1].trim().split(" ");
                        this.values[26 + i] = (int)(Double.parseDouble(tmpValues[0]) * 1000.0);
                        if (this.device.getMeasurement(this.channelConfigNumber, 26 + i).getUnit().equals(tmpValues[1])) continue;
                        this.device.getMeasurement(this.channelConfigNumber, 26 + i).setUnit(tmpValues[1].contains("*") ? tmpValues[1].substring(0, tmpValues[1].indexOf(42)) : tmpValues[1]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void parseUL2(String[] strValues) {
        int i;
        String tmpValue3;
        String tmpValue22;
        for (int i2 = 4; i2 < 6; ++i2) {
            try {
                tmpValue22 = strValues[i2].trim();
                this.values[i2 + 15 - 4] = (int)(tmpValue22.indexOf(42) > 1 ? Double.parseDouble(tmpValue22.substring(0, tmpValue22.indexOf(42))) * 1000.0 : Double.parseDouble(tmpValue22) * 1000.0);
                continue;
            }
            catch (Exception tmpValue22) {
                // empty catch block
            }
        }
        try {
            tmpValue3 = strValues[6].trim();
            this.values[20] = (int)(tmpValue3.indexOf(42) > 1 ? Double.parseDouble(tmpValue3.substring(0, tmpValue3.indexOf(42))) * 1000.0 : Double.parseDouble(tmpValue3) * 1000.0);
        }
        catch (Exception tmpValue3) {
            // empty catch block
        }
        try {
            tmpValue3 = strValues[8].trim();
            this.values[17] = (int)(tmpValue3.indexOf(42) > 1 ? Double.parseDouble(tmpValue3.substring(0, tmpValue3.indexOf(42))) * 1000.0 : Double.parseDouble(tmpValue3) * 1000.0);
        }
        catch (Exception tmpValue4) {
            // empty catch block
        }
        for (i = 9; i < 11; ++i) {
            try {
                tmpValue22 = strValues[i].trim();
                this.values[i + 18 - 9] = (int)(tmpValue22.indexOf(42) > 1 ? Double.parseDouble(tmpValue22.substring(0, tmpValue22.indexOf(42))) * 1000.0 : Double.parseDouble(tmpValue22) * 1000.0);
                continue;
            }
            catch (Exception tmpValue5) {
                // empty catch block
            }
        }
        for (i = 13; i < 16; ++i) {
            try {
                tmpValue22 = strValues[i].trim();
                this.values[i + 21 - 13] = (int)(tmpValue22.indexOf(42) > 1 ? Double.parseDouble(tmpValue22.substring(0, tmpValue22.indexOf(42))) * 1000.0 : Double.parseDouble(tmpValue22) * 1000.0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (log.isLoggable(Level.FINE)) {
            StringBuilder s = new StringBuilder();
            for (int value : this.values) {
                s.append(value).append("; ");
            }
            log.log(Level.FINE, s.toString());
        }
    }

    void parseUNILOG2(String[] strValues, int[] inOutMapping, int indexBalance, boolean checkTime) {
        if (checkTime) {
            String[] strValueDate = strValues[1].trim().split("-");
            if (this.date == null || Integer.parseInt(strValueDate[2]) > this.day) {
                this.year = Integer.parseInt(strValueDate[0]);
                this.month = Integer.parseInt(strValueDate[1]);
                this.day = Integer.parseInt(strValueDate[2]);
            }
            String[] strValueTime = strValues[2].trim().split(":");
            int hour = Integer.parseInt(strValueTime[0]) + this.timeOffsetUTC;
            int minute = Integer.parseInt(strValueTime[1]);
            int second = 0;
            second = strValueTime[2].contains(".") ? Integer.parseInt(strValueTime[2].substring(0, strValueTime[2].indexOf(46))) : Integer.parseInt(strValueTime[2]);
            GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day, hour, minute, second);
            if (this.isAutoDstOffset && this.dstOffset == Short.MIN_VALUE) {
                this.correctDstOffset(calendar);
            }
            int indexAfterDot = strValueTime[2].indexOf(46) + 1;
            long timeStamp = calendar.getTimeInMillis() + (indexAfterDot > 0 && strValueTime[2].length() >= indexAfterDot + 2 ? Long.parseLong(strValueTime[2].substring(indexAfterDot, indexAfterDot + 2)) * 10L : 0L);
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "UNILOG2 " + Integer.parseInt(strValueTime[2].substring(indexAfterDot, indexAfterDot + 2)) * 10);
            }
            if (this.lastTimeStamp < timeStamp) {
                this.time_ms = (int)(this.lastTimeStamp == 0L ? 0L : (long)this.time_ms + (timeStamp - this.lastTimeStamp));
                this.lastTimeStamp = timeStamp;
                this.date = calendar.getTime();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss.SS").format(timeStamp));
                }
                if (this.startTimeStamp == 0L) {
                    this.startTimeStamp = timeStamp;
                }
            } else {
                return;
            }
        }
        int maxVotage = Integer.MIN_VALUE;
        int minVotage = Integer.MAX_VALUE;
        for (int i = 4; i < strValues.length; ++i) {
            try {
                if (inOutMapping[i] < 0) continue;
                String tmpValue = strValues[i].trim();
                this.values[inOutMapping[i]] = (int)(tmpValue.indexOf(42) > 1 ? Double.parseDouble(tmpValue.substring(0, tmpValue.indexOf(42))) * 1000.0 : Double.parseDouble(tmpValue) * 1000.0);
                if (i < 16 || i > 21 || this.values[inOutMapping[i]] <= 0) continue;
                maxVotage = this.values[inOutMapping[i]] > maxVotage ? this.values[inOutMapping[i]] : maxVotage;
                minVotage = this.values[inOutMapping[i]] < minVotage ? this.values[inOutMapping[i]] : minVotage;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.values[indexBalance] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 1000;
        if (log.isLoggable(Level.FINE)) {
            StringBuilder s = new StringBuilder();
            for (int value : this.values) {
                s.append(value).append("; ");
            }
            log.log(Level.FINE, s.toString());
        }
    }

    void parseMLINK(String[] strValues) {
        block19: {
            block20: {
                int address;
                String[] tmpValues4;
                int i;
                block18: {
                    int address2;
                    String[] tmpValues22;
                    int i2;
                    if (!this.deviceName.equals("GPS-Logger")) break block18;
                    if (this.channelConfigNumber == 1) {
                        for (i2 = 1; i2 < strValues.length && i2 <= 15; ++i2) {
                            try {
                                tmpValues22 = strValues[i2].trim().split(STRING_SENTENCE_SPLITTER);
                                address2 = Integer.parseInt(tmpValues22[0]);
                                this.values[24 + address2] = (int)(Double.parseDouble(tmpValues22[2]) * 1000.0);
                                if (this.device.getMeasurement(this.channelConfigNumber, 24 + address2).getUnit().equals(tmpValues22[3])) continue;
                                this.device.getMeasurement(this.channelConfigNumber, 24 + address2).setUnit(tmpValues22[3].contains("*") ? tmpValues22[3].substring(0, tmpValues22[3].indexOf(42)) : tmpValues22[3]);
                                continue;
                            }
                            catch (Exception tmpValues22) {
                                // empty catch block
                            }
                        }
                    }
                    if (this.channelConfigNumber != 2) break block19;
                    for (i2 = 1; i2 < strValues.length && i2 <= 15; ++i2) {
                        try {
                            tmpValues22 = strValues[i2].trim().split(STRING_SENTENCE_SPLITTER);
                            address2 = Integer.parseInt(tmpValues22[0]);
                            this.values[32 + address2] = (int)(Double.parseDouble(tmpValues22[2]) * 1000.0);
                            if (this.device.getMeasurement(this.channelConfigNumber, 32 + address2).getUnit().equals(tmpValues22[3])) continue;
                            this.device.getMeasurement(this.channelConfigNumber, 32 + address2).setUnit(tmpValues22[3].contains("*") ? tmpValues22[3].substring(0, tmpValues22[3].indexOf(42)) : tmpValues22[3]);
                            continue;
                        }
                        catch (Exception tmpValues3) {
                            // empty catch block
                        }
                    }
                    break block19;
                }
                if (!this.deviceName.equals("GPS-Logger2") && !this.deviceName.equals("GPS-Logger3")) break block20;
                if (this.channelConfigNumber == 1) {
                    for (i = 1; i < strValues.length && i <= 15; ++i) {
                        try {
                            tmpValues4 = strValues[i].trim().split(STRING_SENTENCE_SPLITTER);
                            address = Integer.parseInt(tmpValues4[0]);
                            this.values[35 + address] = (int)(Double.parseDouble(tmpValues4[2]) * 1000.0);
                            if (this.device.getMeasurement(this.channelConfigNumber, 35 + address).getUnit().equals(tmpValues4[3])) continue;
                            this.device.getMeasurement(this.channelConfigNumber, 35 + address).setUnit(tmpValues4[3].contains("*") ? tmpValues4[3].substring(0, tmpValues4[3].indexOf(42)) : tmpValues4[3]);
                            continue;
                        }
                        catch (Exception tmpValues4) {
                            // empty catch block
                        }
                    }
                }
                if (this.channelConfigNumber != 2) break block19;
                for (i = 1; i < strValues.length && i <= 15; ++i) {
                    try {
                        tmpValues4 = strValues[i].trim().split(STRING_SENTENCE_SPLITTER);
                        address = Integer.parseInt(tmpValues4[0]);
                        this.values[43 + address] = (int)(Double.parseDouble(tmpValues4[2]) * 1000.0);
                        if (this.device.getMeasurement(this.channelConfigNumber, 43 + address).getUnit().equals(tmpValues4[3])) continue;
                        this.device.getMeasurement(this.channelConfigNumber, 43 + address).setUnit(tmpValues4[3].contains("*") ? tmpValues4[3].substring(0, tmpValues4[3].indexOf(42)) : tmpValues4[3]);
                        continue;
                    }
                    catch (Exception tmpValues5) {
                        // empty catch block
                    }
                }
                break block19;
            }
            if (this.deviceName.equals("UniLog2")) {
                for (int i = 1; i < strValues.length && i <= 15; ++i) {
                    try {
                        String[] tmpValues = strValues[i].trim().split(STRING_SENTENCE_SPLITTER);
                        int address = Integer.parseInt(tmpValues[0]);
                        this.values[24 + address] = (int)(Double.parseDouble(tmpValues[2]) * 1000.0);
                        if (this.device.getMeasurement(this.channelConfigNumber, 24 + address).getUnit().equals(tmpValues[3])) continue;
                        this.device.getMeasurement(this.channelConfigNumber, 24 + address).setUnit(tmpValues[3].contains("*") ? tmpValues[3].substring(0, tmpValues[3].indexOf(42)) : tmpValues[3]);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    void parseMpxD(String[] strValues) {
        try {
            long timeStamp = (long)(Double.parseDouble(strValues[1].replace(',', '.')) * 1000.0);
            if (this.lastTimeStamp < timeStamp) {
                this.time_ms = (int)(this.lastTimeStamp == 0L ? 0L : (long)this.time_ms + (timeStamp - this.lastTimeStamp));
                this.lastTimeStamp = timeStamp;
                log.log(Level.FINE, "timeStamp = " + timeStamp);
                if (this.startTimeStamp == 0L) {
                    this.startTimeStamp = timeStamp;
                }
            } else {
                return;
            }
            for (int i = 2; i < strValues.length - 1; ++i) {
                try {
                    String strValue = strValues[i].trim();
                    if (strValue.length() <= 0) continue;
                    this.values[i + 2] = (int)(Double.parseDouble(strValue) * 1000.0);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public long getTime_ms() {
        return this.time_ms;
    }

    @Override
    public int[] getValues() {
        return this.values;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    @Override
    public synchronized long getStartTimeStamp() {
        return this.startTimeStamp;
    }

    @Override
    public synchronized long getLastTimeStamp() {
        return this.lastTimeStamp;
    }

    @Override
    public void parse(String inputLine, String[] strValues) throws DevicePropertiesInconsistenceException {
    }

    public boolean isSupportedSentence(String sentenceSignature) {
        boolean isSupported = false;
        try {
            NMEA.valueOf(sentenceSignature);
            isSupported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isSupported;
    }

    @Override
    public boolean isRedirectChannel1() {
        return false;
    }

    public static enum NMEA {
        GPRMC,
        GPGSA,
        GPGGA,
        GPGNS,
        GPVTG,
        GPGSV,
        GPRMB,
        GPGLL,
        GPZDA,
        GNRMC,
        GNGSA,
        GNGGA,
        GNGNS,
        GNVTG,
        GNGSV,
        GNRMB,
        GNGLL,
        GNZDA,
        GPSSETUP,
        SETUP,
        SMGPS,
        SMGPS2,
        MLINK,
        UNILOG,
        KOMMENTAR,
        COMMENT,
        UL2SETUP,
        UL2,
        SETUP1,
        SETUP2,
        D;

    }
}

