/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui.menu;

import gde.Analyzer;
import gde.GDE;
import gde.device.resource.DeviceXmlResource;
import gde.histo.datasources.DirectoryScanner;
import gde.histo.exclusions.InclusionData;
import gde.histo.ui.menu.AbstractTabAreaContextMenu;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.SWTResourceManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class ChartTabAreaContextMenu
extends AbstractTabAreaContextMenu {
    private static final String $CLASS_NAME = ChartTabAreaContextMenu.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private MenuItem borderColorItem;
    private Menu warningMenu;
    private MenuItem boxplotItem;
    private MenuItem spreadItem;
    private MenuItem spotsItem;
    private MenuItem warningCountItem;
    private MenuItem warningCountItem0;
    private MenuItem warningCountItem1;
    private MenuItem warningCountItem2;
    private MenuItem warningCountItem3;
    private MenuItem warningLevelItem;
    private MenuItem warningLevelNone;
    private MenuItem warningLevelItem0;
    private MenuItem warningLevelItem1;
    private MenuItem warningLevelItem2;
    private MenuItem isExclusiveWarning;
    private MenuItem clearExclusiveWarnings;
    private MenuItem outherAreaColorItem;
    private MenuItem innerAreaColorItem;
    private Optional<SummaryWarning> warning;

    @Override
    public void createMenu(final Menu popupMenu) {
        popupMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                log.log(Level.FINEST, "menuShown action " + e);
                ChartTabAreaContextMenu.this.setCommonItems(popupMenu);
                ChartTabAreaContextMenu.this.warning = Optional.ofNullable((SummaryWarning)popupMenu.getData(AbstractTabAreaContextMenu.TabMenuOnDemand.SUMMARY_WARNING.toString()));
                log.log(Level.FINEST, "", ChartTabAreaContextMenu.this.warning);
                ChartTabAreaContextMenu.this.setWarningCountIndex(ChartTabAreaContextMenu.this.settings.getReminderCountIndex());
                ChartTabAreaContextMenu.this.setWarningLevel(ChartTabAreaContextMenu.this.settings.getReminderLevel());
                ChartTabAreaContextMenu.this.isExclusiveWarning.setText(Messages.getString("GDE_MSGT0915"));
                ChartTabAreaContextMenu.this.isExclusiveWarning.setSelection(false);
                if (popupMenu.getData(AbstractTabAreaContextMenu.TabMenuOnDemand.IS_CURSOR_IN_CANVAS.toString()) == null) {
                    ChartTabAreaContextMenu.this.setCoreEnabled(false);
                    ChartTabAreaContextMenu.this.setTrackEnabled(true);
                    ChartTabAreaContextMenu.this.isExclusiveWarning.setEnabled(false);
                    ChartTabAreaContextMenu.this.suppressModeItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.curveSelectionItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.hideItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.hideMenuRevokeItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.displayGraphicsHeaderItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.displayGraphicsCommentItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.displayGraphicsCurveSurvey.setEnabled(true);
                    ChartTabAreaContextMenu.this.copyTabItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.copyPrintImageItem.setEnabled(true);
                    ChartTabAreaContextMenu.this.setColorEnabled(true);
                } else {
                    ChartTabAreaContextMenu.this.setCoreEnabled(true);
                    ChartTabAreaContextMenu.this.setTrackEnabled(true);
                    ChartTabAreaContextMenu.this.trackItem.setEnabled(ChartTabAreaContextMenu.this.warning.map(SummaryWarning::isValid).orElse(true).booleanValue());
                    ChartTabAreaContextMenu.this.isExclusiveWarning.setEnabled(ChartTabAreaContextMenu.this.warning.map(SummaryWarning::isValid).orElse(false).booleanValue());
                    ChartTabAreaContextMenu.this.setColorEnabled(true);
                    String dataFilePath = (String)popupMenu.getData(AbstractTabAreaContextMenu.TabMenuOnDemand.DATA_FILE_PATH.toString());
                    if (dataFilePath.isEmpty()) {
                        ChartTabAreaContextMenu.this.fileName.setEnabled(false);
                        ChartTabAreaContextMenu.this.openRecordSetItem.setEnabled(false);
                        ChartTabAreaContextMenu.this.deleteFileItem.setEnabled(false);
                        ChartTabAreaContextMenu.this.openFolderItem.setEnabled(false);
                        ChartTabAreaContextMenu.this.hideMenuRecordSetItem.setEnabled(false);
                        ChartTabAreaContextMenu.this.hideMenuFileItem.setEnabled(false);
                    } else {
                        ChartTabAreaContextMenu.this.setDataPathItems(popupMenu, Paths.get(dataFilePath, new String[0]));
                    }
                }
                ChartTabAreaContextMenu.this.isExclusiveWarning.setText(Messages.getString("GDE_MSGT0915") + ChartTabAreaContextMenu.this.warning.map(SummaryWarning::getDisplayRecordName).orElse(""));
                ChartTabAreaContextMenu.this.isExclusiveWarning.setSelection(ChartTabAreaContextMenu.this.warning.map(SummaryWarning::isExclusiveRecord).orElse(false).booleanValue());
                String warningList = ChartTabAreaContextMenu.this.warning.map(w -> {
                    String includedNames = w.getDisplayNames();
                    return includedNames.isEmpty() ? includedNames : includedNames + "\n";
                }).orElse("");
                if (!GDE.IS_OS_ARCH_ARM) {
                    ChartTabAreaContextMenu.this.clearExclusiveWarnings.setToolTipText(warningList + Messages.getString("GDE_MSGT0918"));
                }
                if (!GDE.IS_OS_ARCH_ARM) {
                    ChartTabAreaContextMenu.this.trackItem.setToolTipText(warningList + Messages.getString("GDE_MSGT0891"));
                }
                popupMenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.IS_CURSOR_IN_CANVAS.toString(), null);
                popupMenu.setData(AbstractTabAreaContextMenu.TabMenuOnDemand.SUMMARY_WARNING.toString(), null);
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        if (!this.isCreated) {
            this.createFileItems(popupMenu);
            new MenuItem(popupMenu, 2);
            this.createTrackItems(popupMenu);
            new MenuItem(popupMenu, 2);
            this.createCheckItems(popupMenu);
            new MenuItem(popupMenu, 2);
            this.createCopyItems(popupMenu);
            new MenuItem(popupMenu, 2);
            this.createColorItems(popupMenu);
            this.isCreated = true;
        }
    }

    protected void createTrackItems(Menu popupMenu) {
        this.trackItem = new MenuItem(popupMenu, 64);
        this.trackItem.setText(Messages.getString("GDE_MSGT0890"));
        this.trackMenu = new Menu(this.trackItem);
        this.trackItem.setMenu(this.trackMenu);
        this.boxplotItem = new MenuItem(this.trackMenu, 32);
        this.boxplotItem.setText(Messages.getString("GDE_MSGT0892"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.boxplotItem.setToolTipText(Messages.getString("GDE_MSGT0893"));
        }
        this.boxplotItem.setSelection(this.settings.isSummaryBoxVisible());
        this.boxplotItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "boxplotItem.widgetSelected, event=" + evt);
                }
                boolean selection = ChartTabAreaContextMenu.this.boxplotItem.getSelection();
                ChartTabAreaContextMenu.this.settings.setSummaryBoxVisible(selection);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.spreadItem = new MenuItem(this.trackMenu, 32);
        this.spreadItem.setText(Messages.getString("GDE_MSGT0902"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.spreadItem.setToolTipText(Messages.getString("GDE_MSGT0903"));
        }
        this.spreadItem.setSelection(this.settings.isSummarySpreadVisible());
        this.spreadItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "spreadItem.widgetSelected, event=" + evt);
                }
                boolean selection = ChartTabAreaContextMenu.this.spreadItem.getSelection();
                ChartTabAreaContextMenu.this.settings.setSummarySpreadVisible(selection);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.spotsItem = new MenuItem(this.trackMenu, 32);
        this.spotsItem.setText(Messages.getString("GDE_MSGT0894"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.spotsItem.setToolTipText(Messages.getString("GDE_MSGT0895"));
        }
        this.spotsItem.setSelection(this.settings.isSummarySpotsVisible());
        this.spotsItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "spotsItem.widgetSelected, event=" + evt);
                }
                boolean selection = ChartTabAreaContextMenu.this.spotsItem.getSelection();
                ChartTabAreaContextMenu.this.settings.setSummarySpotsVisible(selection);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningCountItem = new MenuItem(this.trackMenu, 64);
        this.warningCountItem.setText(Messages.getString("GDE_MSGT0888"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.warningCountItem.setToolTipText(Messages.getString("GDE_MSGT0889"));
        }
        this.warningMenu = new Menu(this.hideItem);
        this.warningCountItem.setMenu(this.warningMenu);
        this.warningCountItem0 = new MenuItem(this.warningMenu, 32);
        this.warningCountItem0.setText(String.valueOf(this.settings.getReminderCount(0)) + " logs");
        this.warningCountItem0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningCountItem0.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningCountIndex(0);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningCountItem1 = new MenuItem(this.warningMenu, 32);
        this.warningCountItem1.setText(String.valueOf(this.settings.getReminderCount(1)) + " logs");
        this.warningCountItem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningCountItem1.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningCountIndex(1);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningCountItem2 = new MenuItem(this.warningMenu, 32);
        this.warningCountItem2.setText(String.valueOf(this.settings.getReminderCount(2)) + " logs");
        this.warningCountItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningCountItem2.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningCountIndex(2);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningCountItem3 = new MenuItem(this.warningMenu, 32);
        this.warningCountItem3.setText(String.valueOf(this.settings.getReminderCount(3)) + " logs");
        this.warningCountItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningCountItem3.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningCountIndex(3);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningLevelItem = new MenuItem(this.trackMenu, 64);
        this.warningLevelItem.setText(Messages.getString("GDE_MSGT0912"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.warningLevelItem.setToolTipText(Messages.getString("GDE_MSGT0913"));
        }
        this.warningMenu = new Menu(this.hideItem);
        this.warningLevelItem.setMenu(this.warningMenu);
        this.warningLevelNone = new MenuItem(this.warningMenu, 32);
        this.warningLevelNone.setText(Messages.getString("GDE_MSGT0919"));
        this.warningLevelNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningLevelNone.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningLevel(-1);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningLevelItem0 = new MenuItem(this.warningMenu, 32);
        this.warningLevelItem0.setText(Messages.getString("GDE_MSGT0904"));
        this.warningLevelItem0.setImage(SWTResourceManager.getImage("gde/resource/caution_portrait.png"));
        this.warningLevelItem0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningLevelItem0.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningLevel(0);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningLevelItem1 = new MenuItem(this.warningMenu, 32);
        this.warningLevelItem1.setText(Messages.getString("GDE_MSGT0905"));
        this.warningLevelItem1.setImage(SWTResourceManager.getImage("gde/resource/caution_portrait_yellow.png"));
        this.warningLevelItem1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningLevelItem1.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningLevel(1);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        this.warningLevelItem2 = new MenuItem(this.warningMenu, 32);
        this.warningLevelItem2.setText(Messages.getString("GDE_MSGT0910"));
        this.warningLevelItem2.setImage(SWTResourceManager.getImage("gde/resource/caution_portrait_blue.png"));
        this.warningLevelItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "warningLevelItem2.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.setWarningLevel(2);
                ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
            }
        });
        new MenuItem(this.trackMenu, 2);
        this.isExclusiveWarning = new MenuItem(this.trackMenu, 32);
        this.isExclusiveWarning.setText(Messages.getString("GDE_MSGT0915"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.isExclusiveWarning.setToolTipText(Messages.getString("GDE_MSGT0916"));
        }
        this.isExclusiveWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "isEclusiveWarning.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.warning.ifPresent(w -> {
                    InclusionData inclusionData = new InclusionData(DirectoryScanner.getActiveFolder4Ui(), Analyzer.getInstance().getDataAccess());
                    if (ChartTabAreaContextMenu.this.isExclusiveWarning.getSelection()) {
                        inclusionData.setProperty(((SummaryWarning)w).recordName);
                    } else {
                        inclusionData.deleteProperty(((SummaryWarning)w).recordName);
                    }
                    inclusionData.store();
                    ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
                });
            }
        });
        this.clearExclusiveWarnings = new MenuItem(this.trackMenu, 8);
        this.clearExclusiveWarnings.setText(Messages.getString("GDE_MSGT0917"));
        if (!GDE.IS_OS_ARCH_ARM) {
            this.clearExclusiveWarnings.setToolTipText(Messages.getString("GDE_MSGT0918"));
        }
        this.clearExclusiveWarnings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "isEclusiveWarning.widgetSelected, event=" + evt);
                }
                ChartTabAreaContextMenu.this.warning.ifPresent(w -> {
                    InclusionData inclusionData = new InclusionData(DirectoryScanner.getActiveFolder4Ui(), Analyzer.getInstance().getDataAccess());
                    inclusionData.delete();
                    ChartTabAreaContextMenu.this.presentHistoExplorer.updateHistoTabs(false, false, true);
                });
            }
        });
    }

    protected void createColorItems(Menu popupMenu) {
        this.outherAreaColorItem = new MenuItem(popupMenu, 8);
        this.outherAreaColorItem.setText(Messages.getString("GDE_MSGT0462"));
        this.outherAreaColorItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "outherAreaColorItem action performed! " + e);
                RGB rgb = ChartTabAreaContextMenu.this.application.openColorDialog();
                if (rgb != null) {
                    ChartTabAreaContextMenu.this.application.setSurroundingBackground(ChartTabAreaContextMenu.this.application.getTabSelectionIndex(), SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                }
            }
        });
        this.innerAreaColorItem = new MenuItem(popupMenu, 8);
        this.innerAreaColorItem.setText(Messages.getString("GDE_MSGT0463"));
        this.innerAreaColorItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "innerAreaColorItem action performed! " + e);
                RGB rgb = ChartTabAreaContextMenu.this.application.openColorDialog();
                if (rgb != null) {
                    ChartTabAreaContextMenu.this.application.setInnerAreaBackground(ChartTabAreaContextMenu.this.application.getTabSelectionIndex(), SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                }
            }
        });
        this.borderColorItem = new MenuItem(popupMenu, 8);
        this.borderColorItem.setText(Messages.getString("GDE_MSGT0464"));
        this.borderColorItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                log.log(Level.FINEST, "borderColorItem action performed! " + e);
                RGB rgb = ChartTabAreaContextMenu.this.application.openColorDialog();
                if (rgb != null) {
                    ChartTabAreaContextMenu.this.application.setBorderColor(ChartTabAreaContextMenu.this.application.getTabSelectionIndex(), SWTResourceManager.getColor(rgb.red, rgb.green, rgb.blue));
                }
            }
        });
    }

    protected void setTrackEnabled(boolean enabled) {
        this.trackItem.setEnabled(enabled);
        this.boxplotItem.setEnabled(enabled);
        this.spreadItem.setEnabled(enabled);
        this.spotsItem.setEnabled(enabled);
        this.warningCountItem.setEnabled(enabled);
        this.warningCountItem0.setEnabled(enabled);
        this.warningCountItem1.setEnabled(enabled);
        this.warningCountItem2.setEnabled(enabled);
        this.warningCountItem3.setEnabled(enabled);
        this.warningLevelItem.setEnabled(enabled);
        this.warningLevelNone.setEnabled(enabled);
        this.warningLevelItem0.setEnabled(enabled);
        this.warningLevelItem1.setEnabled(enabled);
        this.warningLevelItem2.setEnabled(enabled);
        this.isExclusiveWarning.setEnabled(enabled);
        this.clearExclusiveWarnings.setEnabled(enabled);
    }

    protected void setColorEnabled(boolean enabled) {
        this.borderColorItem.setEnabled(enabled);
    }

    protected void setWarningCountIndex(int newIndex) {
        this.settings.setReminderCountIndex(String.valueOf(newIndex));
        this.warningCountItem0.setSelection(newIndex == 0);
        this.warningCountItem1.setSelection(newIndex == 1);
        this.warningCountItem2.setSelection(newIndex == 2);
        this.warningCountItem3.setSelection(newIndex == 3);
    }

    protected void setWarningLevel(int newLevel) {
        this.settings.setReminderLevel(String.valueOf(newLevel));
        this.warningLevelNone.setSelection(newLevel == -1);
        this.warningLevelItem0.setSelection(newLevel == 0);
        this.warningLevelItem1.setSelection(newLevel == 1);
        this.warningLevelItem2.setSelection(newLevel == 2);
    }

    public static class SummaryWarning {
        private final Path dataPath;
        private final String recordName;
        private final String[] exclusiveRecordNames;

        public SummaryWarning(Path dataPath, String recordName, String[] exclusiveRecordNames) {
            if (dataPath == null) {
                throw new IllegalArgumentException();
            }
            if (recordName == null) {
                throw new IllegalArgumentException();
            }
            if (exclusiveRecordNames == null) {
                throw new IllegalArgumentException();
            }
            this.dataPath = dataPath;
            this.recordName = recordName;
            this.exclusiveRecordNames = exclusiveRecordNames;
        }

        String getDisplayRecordName() {
            String recordHint = !this.recordName.isEmpty() ? DeviceXmlResource.getInstance().getReplacement(this.recordName) : "";
            String displayName = recordHint.length() > 15 ? "..." + recordHint.substring(recordHint.length() - 15) : recordHint;
            return " [" + displayName + "]";
        }

        String getDisplayNames() {
            String result = Arrays.stream(DeviceXmlResource.getInstance().getReplacements(this.exclusiveRecordNames)).collect(Collectors.joining("\n "));
            return result.isEmpty() ? result : " " + result;
        }

        boolean isValid() {
            return !this.dataPath.toString().isEmpty();
        }

        boolean isExclusiveRecord() {
            return Arrays.asList(this.exclusiveRecordNames).contains(this.recordName);
        }

        public String toString() {
            return "SummaryWarning [recordName=" + this.recordName + ", exclusiveRecordNames=" + Arrays.toString(this.exclusiveRecordNames) + ", dataPath=" + this.dataPath + ", recordName=" + this.recordName + "]";
        }
    }
}

