/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.ui;

import com.sun.istack.Nullable;
import gde.GDE;
import gde.data.Channels;
import gde.data.CommonRecord;
import gde.histo.datasources.HistoSet;
import gde.histo.recordings.TrailRecord;
import gde.histo.recordings.TrailRecordSet;
import gde.histo.ui.AbstractChartComposite;
import gde.histo.ui.Measure;
import gde.histo.ui.SelectorComposite;
import gde.histo.ui.SummaryComposite;
import gde.log.Logger;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractChartWindow
extends CTabItem {
    private static final String $CLASS_NAME = AbstractChartWindow.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final int SELECTOR_WIDTH = 117;
    protected static final int HEADER_ROW_HEIGHT = 33;
    protected final WindowActor windowActor;
    protected final CTabFolder tabFolder;
    protected SashForm graphicSashForm;
    protected SelectorComposite curveSelectorComposite;
    protected boolean isCurveSelectorEnabled = true;
    private int[] sashFormWeights = new int[]{100, 1000};
    protected Optional<Measure> measure = Optional.empty();

    protected static ImageData flipHorizontal(ImageData inputImageData) {
        int bytesPerPixel = inputImageData.bytesPerLine / inputImageData.width;
        int outBytesPerLine = inputImageData.width * bytesPerPixel;
        byte[] outDataBytes = new byte[inputImageData.data.length];
        int outX = 0;
        int outY = 0;
        int inIndex = 0;
        int outIndex = 0;
        for (int y = 0; y < inputImageData.height; ++y) {
            for (int x = 0; x < inputImageData.width; ++x) {
                outX = x;
                outY = inputImageData.height - y - 1;
                inIndex = y * inputImageData.bytesPerLine + x * bytesPerPixel;
                outIndex = outY * outBytesPerLine + outX * bytesPerPixel;
                System.arraycopy(inputImageData.data, inIndex, outDataBytes, outIndex, bytesPerPixel);
            }
        }
        return new ImageData(inputImageData.width, inputImageData.height, inputImageData.depth, inputImageData.palette, outBytesPerLine, outDataBytes);
    }

    protected AbstractChartWindow(CTabFolder parent, int style, int index) {
        super(parent, style, index);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.tabFolder = parent;
        this.windowActor = new WindowActor();
    }

    public void resetStatusMessage() {
        this.windowActor.setStatusMessage("");
    }

    public abstract void redrawGraphics(boolean var1);

    @Deprecated
    public abstract void updateCaptions();

    @Deprecated
    public void updateCurveSelectorTable() {
        if (Thread.currentThread().getId() == DataExplorer.getInstance().getThreadId()) {
            this.curveSelectorComposite.doUpdateCurveSelectorTable();
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractChartWindow.this.curveSelectorComposite.doUpdateCurveSelectorTable();
                }
            });
        }
    }

    public void setSashFormWeights(int newSelectorCompositeWidth) {
        log.log(Level.FINER, "newSelectorCompositeWidth= ", newSelectorCompositeWidth);
        int tabFolderClientAreaWidth = this.tabFolder.getBounds().width;
        int bestGuessWidth = DataExplorer.getInstance().getClientArea().width;
        if (tabFolderClientAreaWidth > bestGuessWidth) {
            log.log(Level.WARNING, "tabFolder clientAreaWidth missmatch, tabFolderWidth = " + tabFolderClientAreaWidth + " vs applicationWidth = " + bestGuessWidth);
            tabFolderClientAreaWidth = bestGuessWidth;
            this.tabFolder.setSize(tabFolderClientAreaWidth, this.tabFolder.getBounds().height);
        }
        int selectorCompositeWidth = newSelectorCompositeWidth > tabFolderClientAreaWidth / 2 ? tabFolderClientAreaWidth / 2 : newSelectorCompositeWidth;
        int[] newWeights = new int[]{selectorCompositeWidth, tabFolderClientAreaWidth - selectorCompositeWidth};
        log.log(Level.FINER, "newSelectorCompositeWidth= ", selectorCompositeWidth);
        if (this.sashFormWeights[0] != newWeights[0] || this.sashFormWeights[1] != newWeights[1]) {
            this.sashFormWeights = newWeights;
            try {
                if (this.sashFormWeights.length == 2 && this.sashFormWeights[1] != 0) {
                    this.graphicSashForm.setWeights(this.sashFormWeights);
                }
            }
            catch (IllegalArgumentException e) {
                log.log(Level.WARNING, "graphicSashForm.setWeights(this.sashFormWeights) failed!", e);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "sash weight = " + this.sashFormWeights[0] + ", " + this.sashFormWeights[1] + " tabFolderClientAreaWidth = " + tabFolderClientAreaWidth);
        }
    }

    public int getWidth() {
        return this.graphicSashForm.getSize().x;
    }

    public int[] getSashFormWeights() {
        return this.sashFormWeights;
    }

    public SashForm getGraphicSashForm() {
        return this.graphicSashForm;
    }

    public abstract void enableRecordSetComment(boolean var1);

    public abstract void clearHeaderAndComment();

    protected abstract AbstractChartComposite getGraphicsComposite();

    protected abstract Optional<? extends AbstractChartComposite> getSummaryComposite();

    public boolean isActiveCurveSelectorContextMenu() {
        return this.curveSelectorComposite.contextMenu.isActive();
    }

    public abstract Image getContentAsImage();

    public abstract void enableGraphicsHeader(boolean var1);

    public abstract void enableGraphicsScale(boolean var1);

    public abstract void setCurveAreaBackground(Color var1);

    public abstract void setCurveAreaBorderColor(Color var1);

    public abstract void setSurroundingBackground(Color var1);

    public boolean isCurveSelectorEnabled() {
        return this.isCurveSelectorEnabled;
    }

    public void enableCurveSelector(boolean enabled) {
        this.isCurveSelectorEnabled = enabled;
        if (enabled) {
            this.setSashFormWeights(this.curveSelectorComposite.getCompositeWidth());
        } else {
            this.setSashFormWeights(0);
        }
    }

    public abstract void scrollSummaryComposite();

    public void scrollComposite() {
        this.windowActor.scrollSummaryComposite();
    }

    public void setMeasurementActive(String recordKey, boolean enabled, boolean isDeltaMeasuring) {
        this.windowActor.setMeasuringActive(recordKey, enabled, isDeltaMeasuring);
    }

    public void cleanMeasuring() {
        this.curveSelectorComposite.resetContextMenuMeasuring();
        this.windowActor.clearMeasuring();
    }

    public Optional<TrailRecord> getMeasureRecord() {
        return this.measure.map(m -> m.measureRecord);
    }

    public boolean isMeasureRecord(String recordKeyName) {
        return this.getMeasureRecord().map(CommonRecord::getName).map(r -> r.equals(recordKeyName)).orElse(false);
    }

    public void updateWindow(boolean redrawCurveSelector) {
        if (!this.isActiveCurveSelectorContextMenu()) {
            this.redrawGraphics(redrawCurveSelector);
        }
    }

    public abstract AbstractChartComposite[] getCharts();

    public Image getGraphicsPrintImage() {
        return this.getGraphicsComposite().getGraphicsPrintImage();
    }

    protected void setTemplateChart() {
    }

    public void updateColorSchema() {
        if (this.curveSelectorComposite != null) {
            this.curveSelectorComposite.updateColorSchema();
        }
    }

    class WindowActor {
        WindowActor() {
        }

        void clearMeasuring() {
            AbstractChartWindow.this.measure.ifPresent(mm -> {
                for (AbstractChartComposite c : AbstractChartWindow.this.getCharts()) {
                    c.cleanMeasuring();
                    if (!(c instanceof SummaryComposite)) continue;
                    log.log(Level.FINE, "started");
                    c.doRedrawGraphics();
                }
                this.setStatusMessage("");
                AbstractChartWindow.this.measure = Optional.empty();
            });
        }

        void setMeasuringActive(String recordKey, boolean enabled, boolean isDeltaMeasuring) {
            if (Channels.getInstance().getActiveChannel() == null) {
                return;
            }
            if (!DataExplorer.getInstance().getPresentHistoExplorer().hasRecords()) {
                return;
            }
            TrailRecordSet trailRecordSet = DataExplorer.getInstance().getPresentHistoExplorer().getTrailRecordSet();
            if (AbstractChartWindow.this.windowActor.getTrailRecordSet().containsKey(recordKey)) {
                AbstractChartWindow.this.windowActor.clearMeasuring();
                if (enabled) {
                    TrailRecord trailRecord = trailRecordSet.get(recordKey);
                    AbstractChartWindow.this.curveSelectorComposite.setRecordSelection(trailRecord);
                    Measure tmpMeasuring = new Measure(isDeltaMeasuring, trailRecord);
                    AbstractChartWindow.this.measure = Optional.of(tmpMeasuring);
                    for (AbstractChartComposite c : AbstractChartWindow.this.getCharts()) {
                        c.setMeasuringActive(tmpMeasuring);
                    }
                }
            }
        }

        void drawMeasuring(GC canvasGC) {
            AbstractChartWindow.this.measure.ifPresent(mm -> {
                for (AbstractChartComposite c : AbstractChartWindow.this.getCharts()) {
                    c.getMeasuring().ifPresent(m -> m.drawMeasuring(canvasGC));
                }
            });
        }

        void processMouseDownMove(long adjacentTimestamp_ms) {
            AbstractChartWindow.this.measure.ifPresent(mm -> AbstractChartWindow.this.getGraphicsComposite().getMeasuring().ifPresent(m -> m.processMouseDownMove(adjacentTimestamp_ms)));
            AbstractChartWindow.this.getSummaryComposite().ifPresent(AbstractChartComposite::doRedrawGraphics);
        }

        void processMouseUpMove(Point point) {
            AbstractChartWindow.this.measure.ifPresent(mm -> AbstractChartWindow.this.getGraphicsComposite().getMeasuring().ifPresent(m -> m.processMouseUpMove(point)));
        }

        void processMouseDownAction(Point point) {
            AbstractChartWindow.this.measure.ifPresent(mm -> AbstractChartWindow.this.getGraphicsComposite().getMeasuring().ifPresent(m -> m.processMouseDownAction(point)));
        }

        void processMouseUpAction(Point point) {
            AbstractChartWindow.this.measure.ifPresent(mm -> {
                AbstractChartWindow.this.getGraphicsComposite().getMeasuring().ifPresent(m -> m.processMouseUpAction(point));
                AbstractChartWindow.this.getSummaryComposite().ifPresent(AbstractChartComposite::doRedrawGraphics);
            });
        }

        void setStatusMessage(String message) {
            if (message.isEmpty() && !AbstractChartWindow.this.measure.isPresent() && this.getTrailRecordSet() != null && !this.getTrailRecordSet().getTemplate().getFilePathMessage().isEmpty()) {
                DataExplorer.getInstance().setStatusMessage(this.getTrailRecordSet().getTemplate().getFilePathMessage());
            } else if (!message.isEmpty() && AbstractChartWindow.this.measure.isPresent()) {
                DataExplorer.getInstance().setStatusMessage(message);
            } else if (DataExplorer.getInstance().getPresentHistoExplorer().getVolatileStatusMessage() == null) {
                DataExplorer.getInstance().setStatusMessage(message);
            }
        }

        void updateHistoTabs(boolean createRecordSet, boolean rebuildTrails, boolean updateSelector) {
            DataExplorer.getInstance().getPresentHistoExplorer().updateHistoTabs(createRecordSet, rebuildTrails, updateSelector);
        }

        void saveTemplate() {
            if (DataExplorer.getInstance().getPresentHistoExplorer().hasRecords()) {
                TrailRecordSet trailRecordSet = DataExplorer.getInstance().getPresentHistoExplorer().getTrailRecordSet();
                trailRecordSet.getTemplate().setHistoFileName(trailRecordSet.getTemplate().getDefaultHistoFileName());
                trailRecordSet.saveTemplate();
            }
        }

        void setChartSashFormWeights(SelectorComposite composite) {
            int compositeWidth = AbstractChartWindow.this.isCurveSelectorEnabled ? composite.getCompositeWidth() : 0;
            AbstractChartWindow.this.setSashFormWeights(compositeWidth);
        }

        void updateChartWindow(boolean redrawCurveSelector) {
            AbstractChartWindow.this.updateWindow(redrawCurveSelector);
        }

        HistoSet getHistoSet() {
            return DataExplorer.getInstance().getPresentHistoExplorer().getHistoSet();
        }

        @Nullable
        TrailRecordSet getTrailRecordSet() {
            return Channels.getInstance().getActiveChannel() != null ? DataExplorer.getInstance().getPresentHistoExplorer().getTrailRecordSet() : null;
        }

        boolean isCurveSelectorEnabled() {
            return AbstractChartWindow.this.isCurveSelectorEnabled;
        }

        boolean isMeasureRecord(String recordKeyName) {
            return AbstractChartWindow.this.isMeasureRecord(recordKeyName);
        }

        void scrollSummaryComposite() {
            AbstractChartWindow.this.scrollSummaryComposite();
        }

        public void setTrailVisible(TrailRecord record, int selectIndex) {
            AbstractChartWindow.this.curveSelectorComposite.setRecordSelection(record, selectIndex);
        }

        void setTemplateChart() {
            AbstractChartWindow.this.setTemplateChart();
        }
    }
}

